\name{threshold_image_list}
\alias{threshold_image_list}
\title{Image to matrix - List}
\usage{
threshold_image_list(list_names, filetype = "jpeg",
  compress_method = "none", compress_rate = 1, target_width = 100,
  target_height = 100, threshold_value = 0.5,
  transparency_regulation = 0.5, channel = "rgb")
}
\arguments{
\item{list_names}{An object contains the names of the files.}

\item{filetype}{Type of the file to be load. Compatible file types: ".JPGE", ".JPG" or ".PNG".}

\item{compress_method}{For high resolution files, i.e. numbers of pixels in width and height, it is suggested to reduce the resolution to create a smaller matrix,
it strongly reduce GPU usage and time necessary to run analyses. On the other hand, by reducing resolution, it will also reduce the accuracy of data description.
The available methods for image reduction are: i) frame_fixed, which resamples images to a desired target width and height;
ii) proportional, which resamples the image by a given ratio provided in the argument "proportion";
iii) width_fixed, which resamples images to a target width, and also reduces the image height by the same factor. For instance, if the original file had 1000 pixels in width,
and the new width_was set to 100, height will be reduced by a factor of 0.1 (100/1000); and iv) height_fixed, analogous to width_fixed, but assumes height as reference.}

\item{compress_rate}{Compress rate to by apply if compress_method=proportional. Note:  it should be ser as number range from 0 to 1 .}

\item{target_width}{Target width to be used if compress_method=frame_fixed or compress_method= width_fixed.}

\item{target_height}{Target height to be used if compress_method=frame_fixed or compress_method= height_fixed.}

\item{threshold_value}{For each pixel, the intensity of color channels (red, green and blue) are averaged and compared to a threshold_value (threshold).
If the average intensity is less than the threshold_value (default is 0.5) the pixel will be set as black, otherwise it will be white. See channel argument.}

\item{transparency_regulation}{For PNG images, the alpha channel is used to set transparent pixels, i.e. alpha channel values above transparency_regulation (a threshold)
will set the pixel as transparent, default is 0.5.  NOTE: In the data matrix the value 1 represents black pixels, 0 represents white pixels and NA represents transparent pixels.}

\item{channel}{RGB channel to be considered in threshold. If channel=RGB (default), the intensity of red, green and blue is averaged and compared to threshold_value.
If the average intensity is less than the threshold_value (default is 50%) the pixel will be set as black (matrix cell value =1), otherwise it will be white (matrix cell value =0).
If only one channel is defined ("R" for red, "G" for green, and "B" for blue), the average intensity selected channel compared direct to the threshold_value value.}
}
\value{
A matrix of 0, 1 and NA representing white, black and transparent pixels, respectively.
}
\description{
Convert two or more images into a list of matrices
}
\examples{
# Image examples provided by bwimage package
bush<-system.file("extdata/bush.JPG",package ="bwimage")
canopy<-system.file("extdata/canopy.JPG",package ="bwimage")

# Convert images to a list of matrices
working_matrices<-threshold_image_list(c(bush,canopy), "jpeg", "proportional", compress_rate = 0.1)
}
\seealso{
threshold_color
}
\author{
Carlos Biagolini-Jr.
}
