% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnb.R
\name{bnb}
\alias{bnb}
\alias{lik.bnb}
\alias{rbnb}
\title{The bivariate negative binomial distribution}
\usage{
lik.bnb(xvec, yvec, a0, a1, a2, b1, b2, param = NULL)

rbnb(n, a0, a1, a2, b1, b2, param = NULL)

bnb(
  xvec,
  yvec,
  em = TRUE,
  tol = 1e-08,
  maxiter = 50000,
  vcov = TRUE,
  initial = NULL,
  showFlag = FALSE
)
}
\arguments{
\item{xvec, yvec}{a pair of bnb random vectors. nonnegative integer vectors. 
If not integers, they will be rounded to the nearest integers.}

\item{a0, a1, a2}{shape parameters of the latent gamma variables. must be positive.}

\item{b1, b2}{scale parameters for the latent gamma variables. must be positive.}

\item{param}{a vector of parameters (\code{(a0, a1, a2, b1, b2)}). 
Either \code{param} or individual parameters (\code{a0, a1, a2, b1, b2}) 
need to be provided.}

\item{n}{number of observations.}

\item{em}{if \code{TRUE} in \code{bnb}, EM algorithm is applied. Otherwise, direct opitmation is used.}

\item{tol, maxiter, vcov, initial, showFlag}{optional arguments applied only when \code{em} is \code{TRUE} in \code{bnb}.}
}
\value{
\itemize{
   \item \code{rbnb} gives a pair of random vectors following BNB distribution.
   \item \code{bnb} gives the maximum likelihood estimates of a BNB pair. 
   Standard error and covariance matrix are provided when \code{em} is \code{TRUE}.
   \item \code{lik.bnb} gives the log-likelihood of a set of parameters for a BNB pair.
 }
}
\description{
random generation (\code{rbnb}), maximum likelihood estimation (\code{bnb}), 
   and log-likelihood. (\code{lik.bnb})  for the bivariate negative binomial 
   distribution with parameters equal to \code{(a0, a1, a2, b1, b2)}.
}
\examples{
# generating a pair of random vectors
set.seed(1)
data1 <- rbnb(n = 100, a0 = 2, a1 = 1, a2 = 1, 
                b1 = 1, b2 = 1)

lik.bnb(xvec = data1[, 1], yvec = data1[ ,2], 
          a0 = 1, a1 = 1, a2 = 1, b1 = 1, b2 = 1) 

bnb(xvec = data1[,1], yvec = data1[,2], showFlag = FALSE)

}
\references{
Cho, H., Liu, C., Preisser, J., and Wu, D. (In preparation), "A bivariate 
 zero-inflated negative binomial model for identifying underlying dependence"
}
\author{
Hunyong Cho, Chuwen Liu, Jinyoung Park, and Di Wu
}
