% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{grid}
\alias{grid}
\alias{grid.c3}
\title{C3 Grid}
\usage{
grid(c3, axis, show = TRUE, lines = NULL, ticks = NULL, ...)

\method{grid}{c3}(c3, axis, show = TRUE, lines = NULL, ticks = NULL, ...)
}
\arguments{
\item{c3}{c3 htmlwidget object}

\item{axis}{character 'x' or 'y'}

\item{show}{boolean}

\item{lines}{dataframe with options:
\itemize{
 \item{value}{: numeric, character or date depending on axis}
 \item{text}{: character (optional)}
 \item{class}{: character css class (optional)}
 \item{position}{: character one of 'start', 'middle', 'end' (optional)}
}}

\item{ticks}{boolean placeholder. Not yet implimented in \href{http://c3js.org/reference.html#grid-y-ticks}{C3.js}}

\item{...}{additional options passed to the grid object}
}
\value{
c3
}
\description{
Modify grid and line elements on both x and y axis
}
\examples{
iris \%>\%
 c3(x = 'Sepal_Length', y = 'Sepal_Width', group = 'Species') \%>\%
 c3_scatter() \%>\%
 grid('y') \%>\%
 grid('x', show = FALSE, lines = data.frame(value=c(5, 6),
                                            text= c('Line 1', 'Line 2')))

}
\seealso{
Other c3: \code{\link{RColorBrewer}}, \code{\link{c3}},
  \code{\link{legend}}, \code{\link{region}},
  \code{\link{subchart}}, \code{\link{tooltip}},
  \code{\link{xAxis}}, \code{\link{zoom}}
}
