% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaBinomial.R
\name{cnorm.betabinomial2}
\alias{cnorm.betabinomial2}
\title{Fit a beta-binomial regression model for continuous norming}
\usage{
cnorm.betabinomial2(
  age,
  score,
  n = NULL,
  weights = NULL,
  alpha_degree = 3,
  beta_degree = 3,
  control = NULL,
  scale = "T",
  plot = T
)
}
\arguments{
\item{age}{A numeric vector of predictor values (e.g., age).}

\item{score}{A numeric vector of response values.}

\item{n}{The maximum score (number of trials in the beta-binomial distribution). If NULL, max(score) is used.}

\item{weights}{A numeric vector of weights for each observation. Default is NULL (equal weights).}

\item{alpha_degree}{Integer specifying the degree of the polynomial for the alpha model. Default is 3.}

\item{beta_degree}{Integer specifying the degree of the polynomial for the beta model. Default is 3.}

\item{control}{A list of control parameters to be passed to the `optim` function.
If NULL, default values are used.}

\item{scale}{Type of norm scale, either "T" (default), "IQ", "z" or a double vector with the mean and standard deviation.}

\item{plot}{Logical indicating whether to plot the model. Default is TRUE.}
}
\value{
A list of class "cnormBetaBinomial2" containing:
  \item{alpha_est}{Estimated coefficients for the alpha model}
  \item{beta_est}{Estimated coefficients for the beta model}
  \item{se}{Standard errors of the estimated coefficients}
  \item{alpha_degree}{Degree of the polynomial for the alpha model}
  \item{beta_degree}{Degree of the polynomial for the beta model}
  \item{result}{Full result from the optimization procedure}
}
\description{
This function fits a beta-binomial regression model where both the alpha and beta
parameters of the beta-binomial distribution are modeled as polynomial functions
of the predictor variable (typically age). While 'cnorm-betabinomial' fits a beta-binomial model
on the basis of /$mu$ and /$sigma$, this function fits a beta-binomial model directly on the basis
of /$alpha$ and /$beta$.
}
\details{
The function standardizes the input variables, fits polynomial models for both
the alpha and beta parameters, and uses maximum likelihood estimation to
find the optimal parameters. The optimization is performed using the L-BFGS-B method.
}
\keyword{internal}
