% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaBinomial.R
\name{predictCoefficients2}
\alias{predictCoefficients2}
\title{Predict alpha and beta parameters for a beta-binomial regression model}
\usage{
predictCoefficients2(model, ages, n = NULL)
}
\arguments{
\item{model}{An object of class "cnormBetaBinomial2", typically the result of a call to cnorm.betabinomial2().}

\item{ages}{A numeric vector of age points at which to make predictions.}

\item{n}{The maximum score to be achieved.}
}
\value{
A data frame with columns:
  \item{age}{The input age points}
  \item{a}{Predicted alpha values}
  \item{b}{Predicted beta values}
  \item{mu}{Predicted mean values}
  \item{sigma}{Predicted standard deviation values}
}
\description{
This function generates predictions from a fitted beta-binomial regression model
for new age points.
}
\details{
This function takes a fitted beta-binomial regression model and generates predictions
for new age points. It applies the same standardization used in model fitting,
generates predictions on the standardized scale, and then transforms these back
to the original scale.
}
\keyword{internal}
