% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postestimate_doFloodlightAnalysis.R
\name{doFloodlightAnalysis}
\alias{doFloodlightAnalysis}
\title{Do a floodlight analysis}
\usage{
doFloodlightAnalysis(
 .object        = NULL,
 .alpha         = 0.05,
 .y             = NULL, 
 .x             = NULL,
 .z             = NULL,
 .n_spotlights  = 100
 )
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.alpha}{An integer or a numeric vector of significance levels.
Defaults to \code{0.05}.}

\item{.y}{Character string. The name of the dependent variable. Defaults to \code{NULL}.}

\item{.x}{Character string. The name of the moderator variable. Defaults to \code{NULL}.}

\item{.z}{Character string. The name of the independent variable. Defaults to \code{NULL}.}

\item{.n_spotlights}{Integer. A numeric value giving the number of spotlights (= values of .z)
between min(.z) and max(.z) to use. Defaults to \code{100}.}
}
\value{
A list of class \code{cSEMFloodlight} with a corresponding method for \code{plot()}.
See: \code{\link[=plot.cSEMFloodlight]{plot.cSEMFloodlight()}}.
}
\description{
Calculate the effect of an independent variable (z) on a dependent variable
(y) conditional on the values of a (continous) moderator variable (x)
to perform a floodlight analysis \insertCite{Spiller2013}{cSEM}. Moreover,
the Johnson-Neyman points are calculated, i.e. the value(s) of x for which
lower or upper boundary of the confidence interval of the effect
estimate of z for a given x switch signs.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=csem]{csem()}}, \link{cSEMResults}, \code{\link[=plot.cSEMFloodlight]{plot.cSEMFloodlight()}}
}
