% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_datasets.R
\docType{data}
\name{Yooetal2000}
\alias{Yooetal2000}
\title{Data: Yooetal2000}
\format{An object of class \code{data.frame} with 569 rows and 34 columns.}
\source{
Simulated data with the same correlation matrix as the data studied
by \insertCite{Yoo2000;textual}{cSEM}.
}
\usage{
Yooetal2000
}
\description{
A data frame containing 34 variables with 569 observations.
}
\details{
The data is simulated and has the identical correlation matrix as the data
that was analysed by \insertCite{Yoo2000;textual}{cSEM}
to examine how five elements of the marketing mix, namely price, store
image, distribution intensity, advertising spending, and price deals, are
related to the so-called dimensions of brand equity, i.e., perceived brand
quality, brand loyalty, and brand awareness/associations. It is also used in
\insertCite{Henseler2017;textual}{cSEM} and \insertCite{Henseler2020;textual}{cSEM}
for demonstration purposes (Tutorial 10).
}
\examples{
#============================================================================
# Example is taken from Henseler (2020)
#============================================================================
model_HOC="
# Measurement models FOC
PR =~ PR1 + PR2 + PR3
IM =~ IM1 + IM2 + IM3
DI =~ DI1 + DI2 + DI3
AD =~ AD1 + AD2 + AD3
DL =~ DL1 + DL2 + DL3
AA =~ AA1 + AA2 + AA3 + AA4 + AA5 + AA6
LO =~ LO1 + LO3
QL =~ QL1 + QL2 + QL3 + QL4 + QL5 + QL6

# Composite model for SOC
BR <~ QL + LO + AA

# Structural model
BR~ PR + IM + DI + AD + DL 
"

out <- csem(.data = Yooetal2000, .model = model_HOC,
            .PLS_weight_scheme_inner = 'factorial',
            .tolerance = 1e-06)

}
\references{
\insertAllCited{}
}
\keyword{datasets}
