% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTMed-methods-ctmedeffect.R
\name{print.ctmedeffect}
\alias{print.ctmedeffect}
\title{Print Method for Object of Class \code{ctmedeffect}}
\usage{
\method{print}{ctmedeffect}(x, digits = 4, ...)
}
\arguments{
\item{x}{an object of class \code{ctmedeffect}.}

\item{digits}{Integer indicating the number of decimal places to display.}

\item{...}{further arguments.}
}
\value{
Prints the effects.
}
\description{
Print Method for Object of Class \code{ctmedeffect}
}
\examples{
phi <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0, 0, -0.693
  ),
  nrow = 3
)
colnames(phi) <- rownames(phi) <- c("x", "m", "y")
delta_t <- 1

# Time Interval of One -----------------------------------------------------

## Total Effect ------------------------------------------------------------
total_dt <- Total(
  phi = phi,
  delta_t = delta_t
)
print(total_dt)

## Direct Effect -----------------------------------------------------------
direct_dt <- Direct(
  phi = phi,
  delta_t = delta_t,
  from = "x",
  to = "y",
  med = "m"
)
print(direct_dt)

## Indirect Effect ---------------------------------------------------------
indirect_dt <- Indirect(
  phi = phi,
  delta_t = delta_t,
  from = "x",
  to = "y",
  med = "m"
)
print(indirect_dt)

}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
