% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computerized_adaptive_test_function.R
\name{computerized_adaptive_test}
\alias{computerized_adaptive_test}
\title{Computerized Adaptive Test}
\usage{
computerized_adaptive_test(cat_item_bank, response_matrix, initial_theta = 0,
  model = NULL, randomesque = 1, maxItems = 50, method = "BM",
  nextItemControl = list(criterion = "MFI", method = method, priorDist =
  "norm", priorPar = c(0, 1), D = 1, range = c(-4, 4), parInt = c(-4, 4, 33),
  infoType = "Fisher", random.seed = NULL, rule = "precision", thr = 0.3, SETH =
  NULL, AP = 1, nAvailable = NULL, cbControl = NULL, cbGroup = NULL), ...)
}
\arguments{
\item{cat_item_bank}{A data frame with the items on the rows and their item parameters on the columns. These should be in the \pkg{catR} package format for item banks.}

\item{response_matrix}{A matrix of the person responses, with individuals as rows and items as columns.}

\item{initial_theta}{The initial theta estimate for all individuals. Default is 0.}

\item{model}{Either NULL (default) for dichotomous models or a character value indicating the polytomous model used. See the \pkg{mstR} package for more details.}

\item{randomesque}{An integer value that indicates the number of items from which the selection rule should choose from randomly for administration. See the help documentation for \code{catR::nextItem} for more details.}

\item{maxItems}{An integer value indicating the maximum number of items to administer, regardless of other stopping rules.}

\item{method}{A character value indicating method for the provisional theta estimate. Defaults to "BM" (Bayes Modal). See the \pkg{catR} package for more details.}

\item{nextItemControl}{A list of control values passed to \code{catR::nextItem}. See that function for more details.}

\item{...}{Further arguments to be passed to internal functions. Currently unimplemented.}
}
\value{
List of results.
\item{final.theta.estimate.catR}{The final theta estimate as specified in the `method` argument}
\item{eap.theta}{The expected a posteriori (EAP) theta estimate.}
\item{final.theta.Baker}{The maximum likelihood estimate as described in chapter 5 of Baker (2001)[http://echo.edres.org:8080/irt/baker/final.pdf].}
\item{final.theta.SEM}{The standard error of measurement of the `final.theta.estimate.catR`.}
\item{final.items.seen}{The final items seen by each individual. A matrix of n rows and maxItems columns. NA indicates an individual wasn't administered any additional items after the last one specified in their row.}
\item{final.responses}{The responses to the items in `final.items.seen`. A matrix of n rows and maxItems columns. NA indicates an individual wasn't administered any additional items after the last one specified in their row.}
}
\description{
Computerized Adaptive Test
}
\examples{
data(example_thetas) # 5 simulated abilities
data(example_responses) # 5 simulated responses
data(cat_items) # using just the CAT routing stage items
catResults <- computerized_adaptive_test(cat_item_bank = cat_items,
response_matrix = example_responses, randomesque = 1, maxItems = 3,
nextItemControl = list(criterion = "MFI",
priorDist = "norm", priorPar = c(0, 1), D = 1, range = c(-4, 4),
parInt = c(-4, 4, 33), infoType = "Fisher", randomesque = 1, random.seed = NULL,
rule = "precision", thr = .3, nAvailable = NULL,
cbControl = NULL, cbGroup = NULL))
}
