% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{\%outer\%}
\alias{\%outer\%}
\title{Numerical and Symbolic Outer Product}
\usage{
x \%outer\% y
}
\arguments{
\item{x}{\code{numeric} or \code{character} array.}

\item{y}{\code{numeric} or \code{character} array.}
}
\value{
\code{array}.
}
\description{
Computes the outer product of two \code{numeric} or \code{character} arrays.
}
\details{
The outer product between two arrays \code{A} and \code{B} is computed as:
\deqn{C_{i_1\dots i_mj_1\dots j_n} = A_{i_1\dots i_m}B_{j_1\dots j_n}}
}
\examples{
### numeric outer product 
c(1,2) \%outer\% c(2,3)

### symbolic outer product 
c("a","b") \%outer\% c("c","d")

}
\references{
Guidotti, E. (2020). "calculus: High dimensional numerical and symbolic calculus in R". \url{https://arxiv.org/abs/2101.00086}
}
\seealso{
Other basic arithmetic: 
\code{\link{\%diff\%}()},
\code{\link{\%div\%}()},
\code{\link{\%dot\%}()},
\code{\link{\%inner\%}()},
\code{\link{\%kronecker\%}()},
\code{\link{\%prod\%}()},
\code{\link{\%sum\%}()}
}
\concept{basic arithmetic}
