% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendR.R
\name{calendR}
\alias{calendR}
\title{Monthly and yearly calendars}
\usage{
calendR(
  year = format(Sys.Date(), "\%Y"),
  month = NULL,
  start = c("S", "M"),
  weeknames,
  orientation = c("portrait", "landscape"),
  title,
  title.size = 20,
  title.col = "gray30",
  subtitle = "",
  subtitle.col = "gray30",
  text = "",
  text.pos = NULL,
  text.size = 4,
  text.col = "gray30",
  special.days = NULL,
  special.col = rgb(0, 0, 1, alpha = 0.25),
  gradient = FALSE,
  low.col = "white",
  col = "gray30",
  lwd = 0.5,
  lty = 1,
  font.family = "sans",
  font.style = "plain",
  weekdays.col = "gray30",
  month.col = "gray30",
  days.col = "gray30",
  day.size = 3,
  legend.pos = "none",
  legend.title = "",
  pdf = FALSE,
  doc_name = ""
)
}
\arguments{
\item{year}{Calendar year. By default uses the current year.}

\item{month}{Month of the year or \code{NULL} (default) for the yearly calendar.}

\item{start}{\code{"S"} (default) for starting the week on Sunday or \code{"M"} for starting the week on Monday.}

\item{weeknames}{Character vector with the names of the days of the week. By default they will be in the system locale.}

\item{orientation}{The calendar orientation: \code{"portrait"} or \code{"landscape"} (default). Also accepts \code{"p"} and \code{"l"}.}

\item{title}{Title of the the calendar. If not supplied is the year and the month, or the year if \code{month = NULL}.}

\item{title.size}{Size of the main title.}

\item{title.col}{Color of the main title.}

\item{subtitle}{Subtitle of the calendar in italics (optional).}

\item{subtitle.col}{Color of the subtitle.}

\item{text}{Character vector of texts to be added on the calendar. Only for monthly calendars.}

\item{text.pos}{Numeric vector containing the number of days of the month where to add the texts of the \code{text} argument.}

\item{text.size}{Font size of the texts added with the \code{text} argument.}

\item{text.col}{Color of the texts added with the \code{text} argument.}

\item{special.days}{Numeric vector indicating the days to color or \code{"weekend"} for coloring all the weekends.}

\item{special.col}{Color for the days indicated in special.days. If \code{gradient = TRUE}, is the higher color of the gradient.}

\item{gradient}{Boolean. If \code{special.days} is a numeric vector of the length of the displayed days, \code{gradient = TRUE} creates a gradient of the \code{special.col} on the calendar.}

\item{low.col}{If \code{gradient = TRUE}, is the lower color of the gradient. Defaults to \code{"white"}.}

\item{col}{Color of the lines of the calendar.}

\item{lwd}{Line width of the calendar.}

\item{lty}{Line type of the calendar.}

\item{font.family}{Font family of all the texts.}

\item{font.style}{Style of all the texts and numbers except the subtitle. Possible options are \code{"plain"} (default), \code{"bold"}, \code{"italic"} and \code{"bold.italic"}.}

\item{weekdays.col}{Color of the names of the days.}

\item{month.col}{If \code{month = NULL}, is the color of the month names.}

\item{days.col}{Color of the number of the days.}

\item{day.size}{Font size of the number of the days.}

\item{legend.pos}{If \code{gradient = TRUE}, is the position of the legend. It can be set to \code{"none"} (default), \code{"top"}, \code{"bottom"}, \code{"left"} and \code{"right"}.}

\item{legend.title}{If \code{legend.pos != "none"} and  \code{gradient = TRUE}, is the title of the legend.}

\item{pdf}{Boolean. If TRUE, saves the calendar in the working directory in A4 format.}

\item{doc_name}{If \code{pdf = TRUE}, is the name of the generated file (without the file extension). If not specified, creates files of the format: \code{Calendar_year.pdf} for yearly calendars and \code{Calendar_month_year.pdf} for monthly calendars.}
}
\description{
Create ready to print monthly and yearly calendars. The function allows personalizing colors (even setting a gradient color scale for a full month or year), texts and fonts. In addition, for monthly calendars you can also add text on the days.
}
\examples{
# Calendar of the current year
calendR()

# Calendar of July, 2005, starting on Monday
calendR(year = 2005, month = 7, start = "M", subtitle = "Have a nice day")

\donttest{
# Create ready to print monthly calendars for all the months of the current year
# with week starting on Sunday
invisible(sapply(1:12 , function(i) calendR(month = i, pdf = TRUE,
 doc_name = file.path(tempdir(), paste0("myCalendar", i , ".pdf")))))
}

}
\author{
\itemize{
\item{Soage González, José Carlos.}
\item{Maintainer: José Carlos Soage González. \email{jsoage@uvigo.es}}
}
}
