% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic_read.R
\name{ic_write}
\alias{ic_write}
\title{Write ics file}
\usage{
ic_write(ic, file, zulu = FALSE)
}
\arguments{
\item{ic}{object of class \code{ical}}

\item{file}{ics file to write}

\item{zulu}{is the datetime in Zulu time?
\code{FALSE} by default, which means the calendar's current timezone
is used.}
}
\description{
Write ics file
}
\examples{
ic <- ical(ical_example)
ic_write(ic, file.path(tempdir(), "ic.ics"))
f <- system.file("extdata", "example.ics", package = "calendar")
identical(readLines(file.path(tempdir(), "ic.ics")), readLines(f))
f <- system.file("extdata", "england-and-wales.ics", package = "calendar")
ics_df <- ic_read(f)
ic_write(ics_df, file.path(tempdir(), "ic.ics"))
# test similarity between files with diff tool like meld - from shell:
# meld ic.ics inst/extdata/england-and-wales.ics
}
