% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback_stat.R
\name{stat_ecs}
\alias{stat_ecs}
\title{Exclusive callback shares}
\usage{
stat_ecs(x, level = 0.95)
}
\arguments{
\item{x}{a \code{callback} object.}

\item{level}{a number, containing the level of the confidence intervals (0.95
by default).}
}
\value{
A list with class \code{"stat_ecs"} containing 8 components : level, shares,
cp, wilson, student, t.student, t.pearson and t.fisher.

\code{level}: the level of the confidence intervals.

\code{shares}: a data frame containing the following variables.
\itemize{
\item \bold{disc:} number of discrimination cases.
\item \bold{c10:} number of tests with the 1st candidate preferred (2nd candidate
 discriminated against).
\item \bold{c01:} number of tests with the 2nd candidate preferred (1st candidate
 discriminated against).
\item \bold{cdif:} net discrimination c10-c01.
\item \bold{p_cand1:} 1st candidate callback share (c10/disc).
\item \bold{p_cand2:} 2nd candidate callback share (c01/disc).
\item \bold{p_cand_dif:} p_cand1-1/2.
}

\code{cp}: a data frame containing the Clopper-Pearson confidence intervals,
from binom.test(), and the p-value of the Fisher test of independence between
the candidate type and the callback variable, from fisher.test().
\itemize{
\item \bold{inf_p_cand1:} 1st candidate callback rate, lower bound.
\item \bold{sup_p_cand1:} 1st candidate callback rate, upper bound.
\item \bold{inf_p_cand2:} 2nd candidate callback rate, lower bound.
\item \bold{sup_p_cand2:} 2nd candidate callback rate, upper bound.
}

\code{wilson}: a data frame containing the Wilson confidence intervals
 and the p-value of the equality test of callback shares between the two
 candidates, from prop.test().
\itemize{
\item \bold{inf_p_cand1:} 1st candidate callback share, lower bound.
\item \bold{sup_p_cand1:} 1st candidate callback share, upper bound.
\item \bold{inf_p_cand2:} 2nd candidate callback share, lower bound.
\item \bold{sup_p_cand2:} 2nd candidate callback share, upper bound.
\item \bold{inf_cand_dif:} p_c10-p_c01, lower bound.
\item \bold{sup_cand_dif:} p_c10-p_c01, upper bound.
}

\code{student}: a data frame containing the Student confidence intervals
 and the p-value of the equality test of callback shares between the two
 candidates.
\itemize{
\item \bold{inf_p_cand1:} 1st candidate callback share, lower bound.
\item \bold{sup_p_cand1:} 1st candidate callback share, upper bound.
\item \bold{inf_p_cand2:} 2nd candidate callback share, lower bound.
\item \bold{sup_p_cand2:} 2nd candidate callback share, upper bound.
\item \bold{inf_cand_dif:} p_c10-p_c01, lower bound.
\item \bold{sup_cand_dif:} p_c10-p_c01, upper bound.
}

\code{t.fisher}: a data frame containing the statistics of the Fisher test.
 \itemize{
  \item\bold{p_cand_dif:} 1st candidate callback share - 1/2.
  \item\bold{p_Fisher:} the p-value of the Fisher test.
  \item\bold{s_Fisher:} the significance code of the Fisher test.
   }

\code{t.pearson}: a data frame containing the statistics of the Pearson test.
 \itemize{
  \item\bold{p_cand_dif:} 1st candidate callback share - 1/2.
  \item\bold{Pearson:} the value of Pearson's chi-squared test statistic.
  \item\bold{p_Pearson:} the p-value of the Pearson test.
  \item\bold{s_Pearson:} the significance code of the Pearson test.
   }

\code{t.student}: A data frame containing the statistics of the Student test.
 \itemize{
  \item\bold{p_cand_dif:} 1st candidate callback share - 1/2.
  \item\bold{Student:} the value of Student's test statistic.
  \item\bold{p_Student:} the p-value of the Student test.
  \item\bold{s_Student:} the significance code of the Student test.
   }
}
\description{
Computes the callback shares and their confidence intervals. The analysis is
 restricted to the tests with discrimination cases.
}
\examples{
data(labour1)
x <- callback(data=labour1,cluster="offer",candid="hist",callback="callback")
str(stat_ecs(x,level=0.9))

}
\references{
Clopper, C. J. & Pearson, E. S. (1934). The use of confidence or fiducial
limits illustrated in the case of the binomial. Biometrika, 26, 404–413.
doi:10.2307/2331986.

Wilson, E.B. (1927). Probable inference, the law of succession, and
statistical inference. Journal of the American Statistical Association, 22,
209–212. doi:10.2307/2276774.
}
\author{
Emmanuel Duguet
}
