% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcmd.R
\name{rcmd_copycat}
\alias{rcmd_copycat}
\title{Call and R CMD command, while mimicking the current R session}
\usage{
rcmd_copycat(cmd, cmdargs = character(), libpath = .libPaths(),
  repos = getOption("repos"), env = character(), ...)
}
\arguments{
\item{cmd}{Command to run. See \code{R --help} from the command
line for the various commands. In the current version of R (3.2.4)
these are: BATCH, COMPILE, SHLIB, INSTALL, REMOVE, build, check,
LINK, Rprof, Rdconv, Rd2pdf, Rd2txt, Stangle, Sweave, Rdiff, config,
javareconf, rtags.}

\item{cmdargs}{Command line arguments.}

\item{libpath}{The library path.}

\item{repos}{The \emph{repos} option. If \code{NULL}, then no
\emph{repos} option is set. This options is only used if
\code{user_profile} or \code{system_profile} is set \code{FALSE},
as it is set using the system or the user profile.}

\item{env}{Environment variables to set for the child process.}

\item{...}{Additional arguments are passed to \code{\link[=rcmd]{rcmd()}}.}
}
\description{
This function is similar to \code{\link[=rcmd]{rcmd()}}, but it has slightly different
defaults:
\itemize{
\item The \code{repos} options is unchanged.
\item No extra environment variables are defined.
}
}
\seealso{
Other R CMD commands: \code{\link{rcmd_bg}},
  \code{\link{rcmd}}
}
\concept{R CMD commands}
