% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reports.R
\name{get_reports}
\alias{get_reports}
\title{Get the day-to-day reports}
\usage{
get_reports(
  split = c("overall", "province"),
  province = NULL,
  region = NULL,
  fill_dates = NULL,
  stat = NULL,
  date = NULL,
  after = NULL,
  before = NULL
)
}
\arguments{
\item{split}{One of "overall", or "province" to specify how the
data is split. An "overall" report gives cumulative numbers across Canada.
Splitting by "province" returns all reports for all provinces/territories.}

\item{province}{One or more province/territory codes ("AB", "BC", "MB", "NB",
"NL", "NS", "NT", "NU", "ON", "PE", "QC", "SK", "YT") to get reports.
Upper, lower and mixed case strings are accepted.}

\item{region}{One or more health region IDs to get reports. Numeric and
character values are accepted.}

\item{fill_dates}{When TRUE, the response fills in any missing dates with
blank entries.}

\item{stat}{Returns only the specified statistics, e.g. "cases".}

\item{date}{Returns reports from only the specified date,
in YYYY-MM-DD format.}

\item{after}{Returns reports from only on or after the specified date,
in YYYY-MM-DD format.}

\item{before}{Returns reports from only on or before the specified date,
in YYYY-MM-DD format.}
}
\value{
A data frame containing the reports data, one row per day. Includes
a \code{province} variable if data is split by province, and a \code{hr_uid} variable
if data is split by health region.
}
\description{
Runs a GET request of reports data from the COVID-19 tracker API, and
returns parsed data.
Via the \code{split} argument, data may be "overall" (all provinces/territories
combined), or by "province".
Alternatively, provide one or more two-letter codes (e.g. "AB") to \code{province}
to return reports for specific provinces, or one or more numeric \code{region}
codes (e.g. "1204") to return specific health regions.
}
\examples{

get_reports()
get_reports("province")
get_reports(province = c("AB", "SK"))
get_reports(region = 1204)
get_reports(region = c("472", 1204), stat = "cases")
}
