% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{acacia}
\alias{acacia}
\title{\emph{Acacia} example data}
\format{
A list with two elements:
\describe{
\item{phy}{Phylogeny of Australian \emph{Acacia} (list of class "phylo").
Tip labels are specific epithet, except for the outgroup, which includes
genus and specific epithet. Includes 508 ingroup taxa (genus \emph{Acacia})
and two outgroup taxa.}
\item{comm}{Community matrix of Australian \emph{Acacia} (dataframe).
Column names are specific epithet of each species. Row names are centroids
of 50km grid cells in Australian Albers equal area EPSG:3577 projection.
3037 rows (sites) x 506 columns (species). Data are counts, i.e., the
number of times a species was observed in a grid cell.}
}
}
\usage{
acacia
}
\description{
Dataset of Australian \emph{Acacia} from Mishler et al. 2014 (Nat. Comm.)
}
\examples{
# Example phylogeny
acacia$phy
# Example community
acacia$comm[1:5, 1:5]
}
\references{
Mishler, B., Knerr, N., González-Orozco, C. et al. Phylogenetic
measures of biodiversity and neo- and paleo-endemism in Australian Acacia.
Nat Commun 5, 4473 (2014). \doi{10.1038/ncomms5473}
}
\keyword{datasets}
