% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_settings.R
\name{set_cancensus_cache_path}
\alias{set_cancensus_cache_path}
\title{Set persistent cancensus cache location}
\usage{
set_cancensus_cache_path(cache_path, overwrite = FALSE, install = FALSE)
}
\arguments{
\item{cache_path}{a local directory to use for saving cached data}

\item{overwrite}{Option to overwrite any existing cache path already stored locally.}

\item{install}{Option to install permanently for use across sessions.}
}
\description{
Cancensus provides session caching for retrieved data to increase speeds and reduce API usage. This function will create a persistent cache across sessions.
}
\examples{
\dontrun{
set_cancensus_cache_path("~/cancensus_cache")

# This will set the cache path permanently until overwritten again
set_cancensus_cache_path("~/cancensus_cache", install = TRUE)
}
}
