% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardized_incidence_rate_ratio.R
\name{standardized_incidence_rate_ratio}
\alias{standardized_incidence_rate_ratio}
\title{Age-standardized incidence rates ratio (asirr)}
\usage{
standardized_incidence_rate_ratio(
  ncan,
  py,
  ncanref,
  pyref,
  pystd,
  ncan.min = 5,
  py.min = 0
)
}
\arguments{
\item{ncan}{integer, (age-specific) number of cancers in the population of interest}

\item{py}{integer, (age-specific) person-year in the the population of interest}

\item{ncanref}{integer, (age-specific) number of cancers in the reference population}

\item{pyref}{integer, (age-specific) person-year in the the reference population}

\item{pystd}{numeric, (age-specific) standard population person-years (e.g. standard world population)}

\item{ncan.min}{integer, minimum number of observation required not to mask the CI's out}

\item{py.min}{integer, minimum person-year required not to mask the CI's out

Age-standardized incidence rate ratio (asirr) and associated 95\% confidence interval are computing Armitage and Berry (1987) formula.
asird is a summary statistics that should be computed per group of individuals providing age specific counts.}
}
\value{
a 1 line and 3 column data.frame containing the pir (est) and associated 95\% CI (lci, uci)
}
\description{
Age-standardized incidence rates ratio (asirr)
}
\examples{
ncan <- 1:10
py <- 101:110
ncanref <- 41:50
pyref <- 251:260
pystd <- 10:1
ncan.min <- 5
standardized_incidence_rate_ratio(ncan, py, ncanref, pyref, pystd, ncan.min)
standardized_incidence_rate_ratio(ncan, py, ncanref, pyref, pystd, sum(ncan) + 1)
}
\references{
Boyle P, Parkin DM. Cancer registration: principles and methods. Statistical methods for registries. IARC Sci Publ. 1991;(95):126-58. PMID: 1894318.
}
\concept{summary-stat}
