/**
 *
 * CanvasXpress 50.5 - JavaScript Canvas Library
 *
 * Copyright (c) 2009-2024 - license@canvasxpress.org
 *
 * Redistributions of the source code must retain this copyright
 * notice and the following disclaimer.
 *
 * CanvasXpress is released as open source for personal and
 * educational use with dual licensing for commercial purposes.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Please see a copy of the CanvasXpress License at
 * https://www.canvasxpress.org/docs/license.html.
 *
 * Dual licensing:
 * Commercial use may be granted to the extent that this source
 * code does NOT become part of any other Open Source or
 * Commercially licensed development library or toolkit without
 * explicit permission from CanvasXpress.
 *
 */
/**
 * 
 * sprintf() for JavaScript v.0.4
 *
 * Copyright (c) 2007 Alexandru Marasteanu <http://alexei.417.ro/>
 * Thanks to David Baird (unit test and patch).
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA
 *
 ***
 * 
 * Date Format 1.2.3
 * (c) 2007-2009 Steven Levithan <stevenlevithan.com>
 * MIT license
 *
 * Includes enhancements by Scott Trenda <scott.trenda.net>
 * and Kris Kowal <cixar.com/~kris.kowal/>
 *
 * Accepts a date, a mask, or a date and a mask.
 * Returns a formatted version of the given date.
 * The date defaults to the current date/time.
 * The mask defaults to dateFormat.masks.default.
 *
 ****
 *
 * jLouvain.js
 * Author: Corneliu S. (github.com/upphiminn)
 * This is a javascript implementation of the Louvain
 * community detection algorithm (http://arxiv.org/abs/0803.0476)
 * Based on https://bitbucket.org/taynaud/python-louvain/overview
 * 
 ****
 * 
 * science.js
 * Copyright (c) 2011, Jason Davies
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * The name Jason Davies may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL JASON DAVIES BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 ****
 *
 * Apache-Style Software License for ColorBrewer software and ColorBrewer Color
 * Schemes
 * 
 * Copyright (c) 2002 Cynthia Brewer, Mark Harrower, and The Pennsylvania State
 * University.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions as source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * 
 * 2. The end-user documentation included with the redistribution, if any, must
 * include the following acknowledgment: "This product includes color
 * specifications and designs developed by Cynthia Brewer
 * (http://colorbrewer.org/)." Alternately, this acknowledgment may appear in the
 * software itself, if and wherever such third-party acknowledgments normally
 * appear.
 * 
 * 4. The name "ColorBrewer" must not be used to endorse or promote products
 * derived from this software without prior written permission. For written
 * permission, please contact Cynthia Brewer at cbrewer@psu.edu.
 * 
 * 5. Products derived from this software may not be called "ColorBrewer", nor
 * may "ColorBrewer" appear in their name, without prior written permission of
 * Cynthia Brewer.
 *
 ****
 * 
 * FileSaver.js
 * Copyright © 2015 [Eli Grey][1].
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 **** 
 * 
 * canvas-toBlob.js
 * Copyright © 2011 Eli Grey and Devin Samarin.
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 ****
 *
 * Blob.js
 * Copyright © 2014 Eli Grey.
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 ****
 *
 * jstat.js
 * Copyright (c) 2013 jStat
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 ****
 *
 * numeric.js
 * Numeric Javascript
 * Copyright (C) 2011 by Sébastien Loisel
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 ****
 *
 * Sankey.js
 * Copyright (c) 2012, Michael Bostock
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * The name Michael Bostock may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL MICHAEL BOSTOCK BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****
 *
 * canvas2svg
 * The MIT License (MIT)
 *
 * Copyright (c) 2014 Gliffy Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
(function(b,a){if(typeof exports==="object"){a(exports)}else{(a((b.CanvasXpress=b.CanvasXpress||{})))}}(this,(function(){CanvasXpress=typeof CanvasXpress!="undefined"&&CanvasXpress.ready?CanvasXpress:function(h,e,d,l,c,i,k,g){var f=this;var j=function(){f.init(h,e,d,l,c,i,k,g)};var b=function(m){if(m){f.init(m)}else{f.init(h,e,d,l,c,i,k,g)}};if((d&&d.fonts)||(h&&h.config&&h.config.fonts)){if(d&&d.fonts){CanvasXpress.loadFonts(d.fonts,j)}else{CanvasXpress.loadFonts(h.config.fonts,j)}}else{if((d&&d.fontsExternal)||(h&&h.config&&h.config.fontsExternal)){if(d&&d.fontsExternal){CanvasXpress.loadFontsExternal(d.fontsExternal,j)}else{CanvasXpress.loadFontsExternal(h.config.fontsExternal,j)}}else{if((d&&d.topoJSON&&typeof d.topoJSON=="string")||(h&&h.config&&h.config.topoJSON&&typeof h.config.topoJSON=="string")||(d&&d.useLeaflet)||(h&&h.config&&h.config.useLeaflet)){if((d&&d.useLeaflet)||(h&&h.config&&h.config.useLeaflet)){var a=function(){if(d&&d.topoJSON){CanvasXpress.loadTopoJSON(d.topoJSON,d.mapId,j)}else{if(h&&h.config&&h.config.topoJSON){CanvasXpress.loadTopoJSON(h.config.topoJSON,h.config.mapId,j)}else{j()}}};CanvasXpress.loadLeaflet(a,f)}else{if(d&&d.topoJSON){CanvasXpress.loadTopoJSON(d.topoJSON,d.mapId,j)}else{CanvasXpress.loadTopoJSON(h.config.topoJSON,h.config.mapId,j)}}}else{if((e&&typeof e=="string")||(h&&h.data&&typeof h.data=="string")){if(e){CanvasXpress.loadRemoteData(h,e,d,l,b)}else{CanvasXpress.loadRemoteData(h.renderTo,h.data,h.config,h.events,b)}}else{this.init(h,e,d,l,c,i,k,g)}}}}}})));(function(b,a){if(typeof exports==="object"&&typeof module!=="undefined"){a(exports)}else{(a((b.cxplot=b.cxplot||{})))}}(this,(function(){cxplot=function(v,w,j,a){if(typeof(v)=="object"&&v.isGGPlot){var l=function(g){if(Array.isArray(g)&&!g.length){return{}}else{var f={};for(var m in g){if(g[m]&&typeof g[m]==="string"){f[m]=g[m].replace(/^"(.+)"$/,"$1")}else{f[m]=g[m]}}return f}};var k=function(){if(v.order){v.aes.meta={};for(var f in v.order){v.aes.meta[f]=v.order[f]}}if(!v.aes.hasOwnProperty("x")){for(var f=0;f<n.length;f++){var m=n[f];if(v.layers[m]&&v.layers[m].hasOwnProperty("x")&&v.data[0].hasOwnProperty(v.layers[m].x)){v.aes.x=v.layers[m].x;break}}}if(!v.aes.hasOwnProperty("y")){for(var f=0;f<n.length;f++){var m=n[f];if(v.layers[m]&&v.layers[m].hasOwnProperty("y")&&v.data[0].hasOwnProperty(v.layers[m].y)){v.aes.y=v.layers[m].y;break}}}return v.aes};var u=function(f){if(f&&f.hasOwnProperty("hoverTemplate")){f.hoverTemplate+="<br>"}return f};delete (v.isGGPlot);var o=JSON.stringify(v);var n=Array.isArray(v.geoms)?v.geoms:[v.geoms];var d=new cxplot(v.renderTo,v.data,aes(k()),a);var e={};d.skipGeoms=false;d.meta.config.user.geoms=n;d.meta.config.user.layers=v.layers;d.meta.config.user.cxplot=o;for(var q=0;q<n.length;q++){var r=n[q];var p=e[r]?r+"."+e[r]:r;var s=r.toLowerCase().replace("geom","geom_").replace("2","_2").replace("filled","_filled").replace("_qql","_qq_l").replace("ridgesgradient","ridges_gradient").replace("ridges","_ridges");if(d[s]&&!d.skipGeoms){d[s](l(v.layers[p]))}e[r]=e[r]?e[r]+1:1}d.skipGeoms=false;d.gg_labels(l(v.labels));d.gg_scales(l(v.scales));d.gg_coordinates(l(v.coords));d.gg_theme(l(v.theme));d.gg_facet(l(v.facet));d.gg_config(u(v.config));d.skipRender=false;d.draw();return d}else{if(j){var b=["x","y"];for(var q=0;q<b.length;q++){if(j[b[q]]&&j[b[q]].match(/\*/)){var h=j[b[q]].split("*");h[0]=h[0].replace(/\s*$/,"");h[1]=Number(h[1].replace(/^\s*/,""));j[b[q]]=h[0];if(!isNaN(h[1])){j[b[q]]=h[0];j[b[q]+"AxisFactorValue"]=h[1]}}}}var t={aes:(j||{}),remoteTransitionEffect:"none",theme:"GGPlot",widthFactor:1.5,sizes:[8,10,12,14,16,18,20,22,24,26,28],shapes:["circle","equilateral","rect","plus","minus","diamond","hexagon","octagon","star","pentagon"],isCxplot:true,skipRender:(j&&j.isR?true:false)};if(j.hasOwnProperty("xAxisFactorValue")){t.xAxisFactorValue=j.xAxisFactorValue}if(j.hasOwnProperty("yAxisFactorValue")){t.yAxisFactorValue=j.yAxisFactorValue}var c=new CanvasXpress(v,w,t,a);c.meta.ggplot.aes=j||{};c.meta.ggplot.data=w[0];c.meta.ggplot.order=j&&j.order?j.order:{};return c}}})));(function(b,a){if(typeof exports==="object"&&typeof module!=="undefined"){a(exports)}else{(a((b.aes=b.aes||{})))}}(this,(function(){aes=function(){var b=arguments;var f={};var e=["x","y","z","fill","color","shape","size"];var a=function(){if(!f.stringSampleFactors){f.stringSampleFactors=[]}if(!f.stringVariableFactors){f.stringVariableFactors=[]}if(!f.asSampleFactors){f.asSampleFactors=[]}if(!f.asVariableFactors){f.asVariableFactors=[]}};for(var c=0;c<b.length;c++){if(Array.isArray(b[c])&&Array.isArray(b[c][0])){f.data=b[c]}else{if(b[c] instanceof Object){for(var d in b[c]){f[d]=b[c][d];if(d=="factor"){a();f.stringSampleFactors.push(b[c][d]);f.stringVariableFactors.push(b[c][d]);f.asSampleFactors.push(b[c][d]);f.asVariableFactors.push(b[c][d]);if(b.length>1){if(c==0){f.x=b[c][d]}else{if(c==1){f.y=b[c][d]}else{if(c==2){f.z=b[c][d]}}}}}else{if(e.includes(d)){if(b[c][d] instanceof Object&&b[c][d].factor){a();f.stringSampleFactors.push(b[c][d].factor);f.stringVariableFactors.push(b[c][d].factor);f.asSampleFactors.push(b[c][d].factor);f.asVariableFactors.push(b[c][d].factor);f[d]=b[c][d].factor}else{if(b[c][d].toString().match(/^factor\(.+\)/)){f[d]=b[c][d].replace(/^factor\(/,"").replace(/\)$/,"");a();f.stringSampleFactors.push(f[d]);f.stringVariableFactors.push(f[d]);f.asSampleFactors.push(f[d]);f.asVariableFactors.push(f[d])}}}else{if(d=="sample"){f.x=b[c][d]}}}}}else{if(c==0){f.x=b[c]}else{if(c==1){f.y=b[c]}else{if(c==2){f.z=b[c]}}}f[b[c]]=b[c]}}}return f}})));CanvasXpress.onReady=function(){var f=[];var a=false;var d=false;var c=function(){if(!a){var g=CanvasXpress.instances[0];if(g){g.logConsole("canvasXpress JS ready");a=true;for(var h=0;h<f.length;h++){f[h].fn.call(window,f[h].ctx)}f=[]}}};var b=function(){if(window.document.readyState==="complete"){c()}};var e=function(){c()};window.onReady=function(h,g){if(a){setTimeout(function(){h(g)},1);return}else{f.push({fn:h,ctx:g})}if(window.document.readyState==="complete"){setTimeout(c,1)}else{if(!d){if(window.document.addEventListener){window.document.addEventListener("DOMContentLoaded",c,false);window.addEventListener("load",e,false)}else{window.document.attachEvent("onreadystatechange",b);window.attachEvent("onload",e)}d=true}}};return true}();CanvasXpress.loadLeaflet=function(c,d){var b=document.createElement("script");b.type="text/javascript";b.src="https://www.canvasxpress.org/assets/leaflet/leaflet.js";b.crossOrigin="anonymous";var a=document.createElement("link");a.type="text/css";a.rel="stylesheet";a.href="https://www.canvasxpress.org/assets/leaflet/leaflet.css";a.crossOrigin="anonymous";if(window.L){if(c){if(typeof(c)=="function"){c.call(d)}}}else{CanvasXpress.loadScripts([a,b],c,d)}};CanvasXpress.loadScripts=function(){var i=0;return function(files,callback,scope){var head=window.document.getElementsByTagName("head")[0];var loadScript=function(s,c){var t=s.type;if(t.match(/javascript/i)){s.onreadystatechange=function(){if(s.readyState==="loaded"||s.readyState==="complete"){s.onreadystatechange=null;c()}};s.onload=function(){c()};head.appendChild(s)}else{head.appendChild(s);c()}};var count=function(){if(i===files.length){i=0;if(callback){if(typeof(callback)=="function"){callback.call(scope)}else{if(typeof(callback)=="string"){eval("var fn = "+callback);fn()}}}}else{CanvasXpress.loadScripts(files,callback,scope)}};i++;if(files[i-1]){loadScript(files[i-1],count)}}}();CanvasXpress.transferDatasetAttributes=function(e,a,f){var d=JSON.parse(JSON.stringify(e.dataset));for(var c in d){if(d.hasOwnProperty(c)){if(f){a[c.replace(/^data-/,"")]=d[c]}else{var b="data-"+c.replace(/([a-zA-Z])(?=[A-Z])/g,"$1-").toLowerCase();a.setAttribute(b,d[c])}}}};CanvasXpress.initCanvas=function(){var e=window.document.getElementsByTagName("canvas");for(var d=0;d<e.length;d++){var g=e[d];if(g.classList.contains("CanvasXpress")&&g.id){var f=false;var a={};var b=CanvasXpress.getObject(g.id);if(g.hasAttribute("data-src")&&!b){f=g.getAttribute("data-src");CanvasXpress.transferDatasetAttributes(g,a,true);if(Object.keys(a).length){new CanvasXpress(g.id,f,a)}else{new CanvasXpress(g.id,f)}}}}};CanvasXpress.initImage=function(){var a=window.document.getElementsByTagName("img");for(var c=0;c<a.length;c++){var g=a[c];if(g.classList.contains("CanvasXpress")&&g.id){var f=CanvasXpress.getObject(g.id);var d=g.parentNode;if(!f){var e=g.src;var h=g.id;var b=window.document.createElement("canvas");b.width=g.clientWidth;b.height=g.clientHeight;CanvasXpress.transferDatasetAttributes(g,b);d.removeChild(g);b.id=h;d.appendChild(b);new CanvasXpress(h,e)}}}};CanvasXpress.initTable=function(){var c=window.document.getElementsByTagName("table");for(var b=0;b<c.length;b++){var e=c[b];if(e.classList.contains("CanvasXpress")&&e.id){var g=CanvasXpress.getObject(e.id);var d=e.parentNode;if(!g){var f=e.id;var a=window.document.createElement("canvas");a.id="temp-table-id-"+e.id;a.width=e.hasAttribute("data-width")?e.getAttribute("data-width"):500;a.height=e.hasAttribute("data-height")?e.getAttribute("data-height"):500;CanvasXpress.transferDatasetAttributes(e,a);d.appendChild(a);new CanvasXpress("temp-table-id-"+e.id,f)}}}};CanvasXpress.getObject=function(f,b){if(f){while(CanvasXpress.chain.hasOwnProperty(f)){f=CanvasXpress.chain[f]}for(var a=0;a<CanvasXpress.instances.length;a++){if(CanvasXpress.instances[a].target==f){return CanvasXpress.instances[a]}}}else{if(b){var d=window.document.getElementById(f);if(!d){var e=window.document.createElement("canvas");e.id=f;e.width=100;e.height=100;window.document.body.appendChild(e);d=new CanvasXpress({renderTo:f})}return d}else{if(CanvasXpress.instances.length){return CanvasXpress.instances[0]}}}};CanvasXpress.json=function(a,c){var b=new XMLHttpRequest();b.open("GET",a,true);b.responseType="json";b.onload=function(){var d=b.status;if(d==200){c(null,b.response)}else{c(d)}};b.send()};CanvasXpress.csv=function(a,c){var b=new XMLHttpRequest();b.open("GET",a,true);b.responseType="text";b.onload=function(){var d=b.status;if(d==200){c(null,b.response)}else{c(d)}};b.send()};CanvasXpress.svg=function(a,d,c){var b=new XMLHttpRequest();b.open("GET",a,true);b.responseType="text";b.onload=function(){var e=b.status;if(e==200){c(b.responseText,d)}else{c(e)}};b.send()};CanvasXpress.$=function(b,a){return CanvasXpress.getObject(b,a)};CanvasXpress.destroy=function(b,a){if(CanvasXpress.instances.length>0){CanvasXpress.instances[0].destroy(b,a)}};CanvasXpress.create=function(c,b,a){CanvasXpress.inject(c);return new CanvasXpress(c,b,a)};CanvasXpress.createObject=function(f,d,b,c,e,h,g,a){if(!f){throw new Error("No target provided")}else{if(typeof(f)=="object"&&f.renderTo){d=f.tracks?{tracks:f.tracks}:f.nodes?{nodes:f.nodes}:f.venn?{venn:f.venn}:f.data?f.data:false;b=f.config||false;if(f.version){b.createVersion=f.version}if(f.factory){b.createFactory=f.factory}c=f.events||false;e=f.info?f.info.replace(/'/g,"'").replace(/"/g,"'"):false;h=f.afterRender||false;g=f.callback||false;a=f.noValidate?f.noValidate:b&&b.noValidate?b.noValidate:false;f=f.renderTo;CanvasXpress.inject(f)}else{if(typeof f==="string"||f instanceof String){CanvasXpress.inject(f)}}}return{target:f,data:d,config:b,events:c,info:e,afterRender:h,callback:g,noValidate:a}};CanvasXpress.inject=function(c){if(typeof c==="string"||c instanceof String){var b=document.getElementById(c);if(b!==null){if(b.tagName.toLowerCase()=="canvas"){if(!b.width){b.width=500}if(!b.height){b.height=500}}else{if(b.tagName.toLowerCase()=="div"){b.id=c+"-div";var a=document.createElement("canvas");a.id=c;a.width=500;a.height=500;b.appendChild(a)}}}else{var a=document.createElement("canvas");a.id=c;a.width=500;a.height=500;document.body.appendChild(a)}}};CanvasXpress.loadFonts=function(d,c){if(d&&d.length&&c){var b=false;for(var a=0;a<d.length;a++){if(!CanvasXpress.fonts.hasOwnProperty(d[a])){b=true;break}}WebFontConfig={google:{families:d},timeout:2000};if(c){WebFontConfig.active=c}(function(h){if(window.navigator.onLine&&b){var e=h.createElement("script");var g=h.scripts[0];e.src="https://ajax.googleapis.com/ajax/libs/webfont/1.6.26/webfont.js";e.async=true;g.parentNode.insertBefore(e,g);for(var f=0;f<d.length;f++){CanvasXpress.fonts[d[f]]=true}}else{c()}})(document)}};CanvasXpress.loadFontsExternal=function(c,b){if(c&&c.length&&b){var a=false;if(!CanvasXpress.fonts.hasOwnProperty(c[0].name)){a=true}(function(f){if(window.navigator.onLine&&a){var e=new XMLHttpRequest();e.addEventListener("readystatechange",function(g){if(e.readyState==2&&e.status==200){}else{if(e.readyState==3){}else{if(e.readyState==4){var d=new FontFace(c[0].name,e.response);document.fonts.add(d);CanvasXpress.fonts[c[0].name]=true;b()}}}});e.responseType="arraybuffer";e.open("get",c[0].url);e.send()}else{b()}})(document)}};CanvasXpress.loadTopoJSON=function(a,b,d){if(a&&d){var c=false;if(!b){b="cXMap"}if(!window.hasOwnProperty(b)){c=true}(function(f){if(window.navigator.onLine&&c){var e=new XMLHttpRequest();e.addEventListener("readystatechange",function(g){if(e.readyState==2&&e.status==200){}else{if(e.readyState==3){}else{if(e.readyState==4){window[b]=JSON.parse(e.response);d()}}}});e.open("get",a);e.send()}else{d()}})(document)}};CanvasXpress.loadRemoteData=function(j,c,f,l,k){if(c&&k){var m=CanvasXpress.prototype.initIO.apply(CanvasXpress);var d=function(o,e){for(var n in e){o[n]=e[n]}};var h=null;var g=window.document.getElementById(c);if(g&&g.tagName.toLowerCase()=="table"&&g.classList.contains("CanvasXpress")&&g.id){h=m.HTMLTableToCX(g,f);h.renderTo=j||g.id;h.events=l;g.parentNode.removeChild(g);return k(h)}else{if(m.isValidURL(c)){(function(n){if(window.navigator.onLine){if(!j){j="cX-data-url"}var e=new XMLHttpRequest();e.onreadystatechange=function(){if(e.readyState==2&&e.status==200){}else{if(e.readyState==3){}else{if(e.readyState==4){if(c.match(/\.json$/)){h=m.parseJSON(e.response);if(Array.isArray(h)){var t=h[0][1];var s=[];for(var r=0;r<h.length;r++){s.push(h[r][0])}if(!f){f={}}f.remoteService=c;f.remoteData=h;f.remoteIds=s;CanvasXpress.loadRemoteData(j,t,f,l,k)}else{h.renderTo=j||h.renderTo;h.events=l||h.events;d(h.config,f);k(h)}}else{if(c.match(/\.png$/)){h=m.PNGtoCX(e.response);h.renderTo=j||h.renderTo;h.events=l||h.events;d(h.config,f);k(h)}else{if(c.match(/\.txt$/)||c.match(/\.csv$/)||c.match(/\.tsv$/)||c.match(/\.tab$/)){h=m.parseDelimited(e.response);if(f&&f.graphType=="Network"){h=m.arrayToCXNetwork(h,j,f,l)}else{h=m.arrayToCX(h,f);h.renderTo=j||h.renderTo;h.events=l||h.events}d(h.config,f);k(h)}else{if(c.match(/\.svg$/)){h=m.SVGtoCX(e.response);d(h.config,f);k(h)}else{if(c.match(/ml$/)||c.match(/ml\.bz2$/)||c.match(/\.gexf$/)){var q=c.match(/ml\.bz2$/)?m.parseXML(m.bz2(e.response)):m.parseXML(e.response);var p=q.childNodes[0];var o=q.childNodes[2];if(p.tagName&&p.tagName.toLowerCase()=="gexf"){h=m.gexfToCX(q,j,f,l);k(h)}else{if(p.tagName&&p.tagName.toLowerCase()=="map"){h=m.metabaseToCX(q,j,f,l);k(h)}else{if(p.tagName&&p.tagName.toLowerCase()=="graph"){h=m.cytoscapeToCX(q,j,f,l);k(h)}else{if(p.tagName&&p.tagName.toLowerCase()=="pathway"){h=m.wikipathwayToCX(q,j,f,l);k(h)}else{if(o&&o.tagName&&o.tagName.toLowerCase()=="pathway"){m.keggToCX(q,j,f,l,k)}}}}}}else{k()}}}}}}}}};e.open("get",c);if(c.match(/\.png$/)){e.responseType="arraybuffer"}else{if(c.match(/ml\.bz2$/)){e.responseType="binary"}else{e.responseType="text"}}e.send()}})(document)}else{try{h=JSON.parse(c);return k(h)}catch(i){h=null}var h=m.parseDelimited(c)||null;if(h){if(f&&f.graphType=="Network"){h=m.arrayToCXNetwork(h,j,f,l)}else{h=m.arrayToCX(h,f)}return k(h)}if(window.DOMParser){try{h=(new DOMParser()).parseFromString(c,"text/xml")}catch(i){h=null}}else{if(typeof window.ActiveXObject!="undefined"&&new window.ActiveXObject("Microsoft.XMLDOM")){try{h=new window.ActiveXObject("Microsoft.XMLDOM");h.async="false"}catch(i){h=null}}}if(h!=null&&h.getElementsByTagName("parsererror").length==0){var b=h.childNodes[0];var a=h.childNodes[2]||h.childNodes[1];if(b.tagName&&b.tagName.toLowerCase()=="gexf"){return k(m.gexfToCX(h,j,f,l))}else{if(b.tagName&&b.tagName.toLowerCase()=="map"){return k(m.metabaseToCX(h,j,f,l))}else{if(b.tagName&&b.tagName.toLowerCase()=="graph"){return k(m.cytoscapeToCX(h,j,f,l))}else{if(b.tagName&&b.tagName.toLowerCase()=="pathway"){return k(m.wikipathwayToCX(h,j,f,l))}else{if(a&&a.tagName&&a.tagName.toLowerCase()=="pathway"){return m.keggToCX(h,j,f,l,k)}}}}}}return null}}}};CanvasXpress.setColorSchemes=function(){CanvasXpress.colorSchemes={YlGn:{3:"f7fcb9addd8e31a354",4:"ffffccc2e69978c679238443",5:"ffffccc2e69978c67931a354006837",6:"ffffccd9f0a3addd8e78c67931a354006837",7:"ffffccd9f0a3addd8e78c67941ab5d238443005a32",8:"ffffe5f7fcb9d9f0a3addd8e78c67941ab5d238443005a32",9:"ffffe5f7fcb9d9f0a3addd8e78c67941ab5d238443006837004529"},YlGnBu:{3:"edf8b17fcdbb2c7fb8",4:"ffffcca1dab441b6c4225ea8",5:"ffffcca1dab441b6c42c7fb8253494",6:"ffffccc7e9b47fcdbb41b6c42c7fb8253494",7:"ffffccc7e9b47fcdbb41b6c41d91c0225ea80c2c84",8:"ffffd9edf8b1c7e9b47fcdbb41b6c41d91c0225ea80c2c84",9:"ffffd9edf8b1c7e9b47fcdbb41b6c41d91c0225ea8253494081d58"},GnBu:{3:"e0f3dba8ddb543a2ca",4:"f0f9e8bae4bc7bccc42b8cbe",5:"f0f9e8bae4bc7bccc443a2ca0868ac",6:"f0f9e8ccebc5a8ddb57bccc443a2ca0868ac",7:"f0f9e8ccebc5a8ddb57bccc44eb3d32b8cbe08589e",8:"f7fcf0e0f3dbccebc5a8ddb57bccc44eb3d32b8cbe08589e",9:"f7fcf0e0f3dbccebc5a8ddb57bccc44eb3d32b8cbe0868ac084081"},BuGn:{3:"e5f5f999d8c92ca25f",4:"edf8fbb2e2e266c2a4238b45",5:"edf8fbb2e2e266c2a42ca25f006d2c",6:"edf8fbccece699d8c966c2a42ca25f006d2c",7:"edf8fbccece699d8c966c2a441ae76238b45005824",8:"f7fcfde5f5f9ccece699d8c966c2a441ae76238b45005824",9:"f7fcfde5f5f9ccece699d8c966c2a441ae76238b45006d2c00441b"},PuBuGn:{3:"ece2f0a6bddb1c9099",4:"f6eff7bdc9e167a9cf02818a",5:"f6eff7bdc9e167a9cf1c9099016c59",6:"f6eff7d0d1e6a6bddb67a9cf1c9099016c59",7:"f6eff7d0d1e6a6bddb67a9cf3690c002818a016450",8:"fff7fbece2f0d0d1e6a6bddb67a9cf3690c002818a016450",9:"fff7fbece2f0d0d1e6a6bddb67a9cf3690c002818a016c59014636"},PuBu:{3:"ece7f2a6bddb2b8cbe",4:"f1eef6bdc9e174a9cf0570b0",5:"f1eef6bdc9e174a9cf2b8cbe045a8d",6:"f1eef6d0d1e6a6bddb74a9cf2b8cbe045a8d",7:"f1eef6d0d1e6a6bddb74a9cf3690c00570b0034e7b",8:"fff7fbece7f2d0d1e6a6bddb74a9cf3690c00570b0034e7b",9:"fff7fbece7f2d0d1e6a6bddb74a9cf3690c00570b0045a8d023858"},BuPu:{3:"e0ecf49ebcda8856a7",4:"edf8fbb3cde38c96c688419d",5:"edf8fbb3cde38c96c68856a7810f7c",6:"edf8fbbfd3e69ebcda8c96c68856a7810f7c",7:"edf8fbbfd3e69ebcda8c96c68c6bb188419d6e016b",8:"f7fcfde0ecf4bfd3e69ebcda8c96c68c6bb188419d6e016b",9:"f7fcfde0ecf4bfd3e69ebcda8c96c68c6bb188419d810f7c4d004b"},RdPu:{3:"fde0ddfa9fb5c51b8a",4:"feebe2fbb4b9f768a1ae017e",5:"feebe2fbb4b9f768a1c51b8a7a0177",6:"feebe2fcc5c0fa9fb5f768a1c51b8a7a0177",7:"feebe2fcc5c0fa9fb5f768a1dd3497ae017e7a0177",8:"fff7f3fde0ddfcc5c0fa9fb5f768a1dd3497ae017e7a0177",9:"fff7f3fde0ddfcc5c0fa9fb5f768a1dd3497ae017e7a017749006a"},PuRd:{3:"e7e1efc994c7dd1c77",4:"f1eef6d7b5d8df65b0ce1256",5:"f1eef6d7b5d8df65b0dd1c77980043",6:"f1eef6d4b9dac994c7df65b0dd1c77980043",7:"f1eef6d4b9dac994c7df65b0e7298ace125691003f",8:"f7f4f9e7e1efd4b9dac994c7df65b0e7298ace125691003f",9:"f7f4f9e7e1efd4b9dac994c7df65b0e7298ace125698004367001f"},OrRd:{3:"fee8c8fdbb84e34a33",4:"fef0d9fdcc8afc8d59d7301f",5:"fef0d9fdcc8afc8d59e34a33b30000",6:"fef0d9fdd49efdbb84fc8d59e34a33b30000",7:"fef0d9fdd49efdbb84fc8d59ef6548d7301f990000",8:"fff7ecfee8c8fdd49efdbb84fc8d59ef6548d7301f990000",9:"fff7ecfee8c8fdd49efdbb84fc8d59ef6548d7301fb300007f0000"},YlOrRd:{3:"ffeda0feb24cf03b20",4:"ffffb2fecc5cfd8d3ce31a1c",5:"ffffb2fecc5cfd8d3cf03b20bd0026",6:"ffffb2fed976feb24cfd8d3cf03b20bd0026",7:"ffffb2fed976feb24cfd8d3cfc4e2ae31a1cb10026",8:"ffffccffeda0fed976feb24cfd8d3cfc4e2ae31a1cb10026",9:"ffffccffeda0fed976feb24cfd8d3cfc4e2ae31a1cbd0026800026"},YlOrBr:{3:"fff7bcfec44fd95f0e",4:"ffffd4fed98efe9929cc4c02",5:"ffffd4fed98efe9929d95f0e993404",6:"ffffd4fee391fec44ffe9929d95f0e993404",7:"ffffd4fee391fec44ffe9929ec7014cc4c028c2d04",8:"ffffe5fff7bcfee391fec44ffe9929ec7014cc4c028c2d04",9:"ffffe5fff7bcfee391fec44ffe9929ec7014cc4c02993404662506"},Purples:{3:"efedf5bcbddc756bb1",4:"f2f0f7cbc9e29e9ac86a51a3",5:"f2f0f7cbc9e29e9ac8756bb154278f",6:"f2f0f7dadaebbcbddc9e9ac8756bb154278f",7:"f2f0f7dadaebbcbddc9e9ac8807dba6a51a34a1486",8:"fcfbfdefedf5dadaebbcbddc9e9ac8807dba6a51a34a1486",9:"fcfbfdefedf5dadaebbcbddc9e9ac8807dba6a51a354278f3f007d"},Blues:{3:"deebf79ecae13182bd",4:"eff3ffbdd7e76baed62171b5",5:"eff3ffbdd7e76baed63182bd08519c",6:"eff3ffc6dbef9ecae16baed63182bd08519c",7:"eff3ffc6dbef9ecae16baed64292c62171b5084594",8:"f7fbffdeebf7c6dbef9ecae16baed64292c62171b5084594",9:"f7fbffdeebf7c6dbef9ecae16baed64292c62171b508519c08306b"},BluesDark:{2:"132B4356B1F7"},Greens:{3:"e5f5e0a1d99b31a354",4:"edf8e9bae4b374c476238b45",5:"edf8e9bae4b374c47631a354006d2c",6:"edf8e9c7e9c0a1d99b74c47631a354006d2c",7:"edf8e9c7e9c0a1d99b74c47641ab5d238b45005a32",8:"f7fcf5e5f5e0c7e9c0a1d99b74c47641ab5d238b45005a32",9:"f7fcf5e5f5e0c7e9c0a1d99b74c47641ab5d238b45006d2c00441b"},Oranges:{3:"fee6cefdae6be6550d",4:"feeddefdbe85fd8d3cd94701",5:"feeddefdbe85fd8d3ce6550da63603",6:"feeddefdd0a2fdae6bfd8d3ce6550da63603",7:"feeddefdd0a2fdae6bfd8d3cf16913d948018c2d04",8:"fff5ebfee6cefdd0a2fdae6bfd8d3cf16913d948018c2d04",9:"fff5ebfee6cefdd0a2fdae6bfd8d3cf16913d94801a636037f2704"},Reds:{3:"fee0d2fc9272de2d26",4:"fee5d9fcae91fb6a4acb181d",5:"fee5d9fcae91fb6a4ade2d26a50f15",6:"fee5d9fcbba1fc9272fb6a4ade2d26a50f15",7:"fee5d9fcbba1fc9272fb6a4aef3b2ccb181d99000d",8:"fff5f0fee0d2fcbba1fc9272fb6a4aef3b2ccb181d99000d",9:"fff5f0fee0d2fcbba1fc9272fb6a4aef3b2ccb181da50f1567000d"},Greys:{3:"f0f0f0bdbdbd636363",4:"f7f7f7cccccc969696525252",5:"f7f7f7cccccc969696636363252525",6:"f7f7f7d9d9d9bdbdbd969696636363252525",7:"f7f7f7d9d9d9bdbdbd969696737373525252252525",8:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525",9:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525000000",256:"fffffffffffffefefefefefefdfdfdfdfdfdfcfcfcfcfcfcfbfbfbfbfbfbfafafafafafaf9f9f9f9f9f9f9f9f9f8f8f8f8f8f8f7f7f7f7f7f7f6f6f6f6f6f6f5f5f5f5f5f5f4f4f4f4f4f4f3f3f3f3f3f3f2f2f2f2f2f2f1f1f1f1f1f1f0f0f0f0f0f0efefefefefefeeeeeeeeeeeeededededededececececececebebebebebebeaeaeaeaeaeae9e9e9e9e9e9e8e8e8e8e8e8e7e7e7e7e7e7e6e6e6e6e6e6e5e5e5e5e5e5e4e4e4e4e4e4e3e3e3e3e3e3e2e2e2e2e2e2e1e1e1e1e1e1e0e0e0e0e0e0dfdfdfdfdfdfdedededddddddddddddcdcdcdcdcdcdbdbdbdbdbdbdadadadadadad9d9d9d9d9d9d8d8d8d7d7d7d7d7d7d6d6d6d6d6d6d5d5d5d5d5d5d4d4d4d4d4d4d3d3d3d2d2d2d2d2d2d1d1d1d1d1d1d0d0d0cfcfcfcfcfcfcececececececdcdcdcdcdcdcccccccbcbcbcbcbcbcacacacacacac9c9c9c8c8c8c8c8c8c7c7c7c7c7c7c6c6c6c5c5c5c5c5c5c4c4c4c3c3c3c3c3c3c2c2c2c2c2c2c1c1c1c0c0c0c0c0c0bfbfbfbebebebebebebdbdbdbcbcbcbcbcbcbbbbbbbabababababab9b9b9b8b8b8b8b8b8b7b7b7b6b6b6b6b6b6b5b5b5b4b4b4b4b4b4b3b3b3b2b2b2b2b2b2b1b1b1b0b0b0afafafafafafaeaeaeadadadadadadacacacabababaaaaaaaaaaaaa9a9a9a8a8a8a7a7a7a7a7a7a6a6a6a5a5a5a4a4a4a4a4a4a3a3a3a2a2a2a1a1a1a0a0a0a0a0a09f9f9f9e9e9e9d9d9d9c9c9c9c9c9c9b9b9b9a9a9a9999999898989797979797979696969595959494949393939292929191919090909090908f8f8f8e8e8e8d8d8d8c8c8c8b8b8b8a8a8a8989898888888787878686868585858484848383838282828181818080807f7f7f7e7e7e7d7d7d7c7c7c7b7b7b7a7a7a7878787777777676767575757474747373737272727070706f6f6f6e6e6e6d6d6d6b6b6b6a6a6a6969696767676666666565656363636262626060605f5f5f5d5d5d5c5c5c5a5a5a5959595757575555555454545252525050504e4e4e4c4c4c4a4a4a4848484646464444444242424040403d3d3d3b3b3b3838383535353232322e2e2e2b2b2b2727272222221c1c1c15151500000"},PuOr:{3:"f1a340f7f7f7998ec3",4:"e66101fdb863b2abd25e3c99",5:"e66101fdb863f7f7f7b2abd25e3c99",6:"b35806f1a340fee0b6d8daeb998ec3542788",7:"b35806f1a340fee0b6f7f7f7d8daeb998ec3542788",8:"b35806e08214fdb863fee0b6d8daebb2abd28073ac542788",9:"b35806e08214fdb863fee0b6f7f7f7d8daebb2abd28073ac542788",10:"7f3b08b35806e08214fdb863fee0b6d8daebb2abd28073ac5427882d004b",11:"7f3b08b35806e08214fdb863fee0b6f7f7f7d8daebb2abd28073ac5427882d004b"},BrBG:{3:"d8b365f5f5f55ab4ac",4:"a6611adfc27d80cdc1018571",5:"a6611adfc27df5f5f580cdc1018571",6:"8c510ad8b365f6e8c3c7eae55ab4ac01665e",7:"8c510ad8b365f6e8c3f5f5f5c7eae55ab4ac01665e",8:"8c510abf812ddfc27df6e8c3c7eae580cdc135978f01665e",9:"8c510abf812ddfc27df6e8c3f5f5f5c7eae580cdc135978f01665e",10:"5430058c510abf812ddfc27df6e8c3c7eae580cdc135978f01665e003c30",11:"5430058c510abf812ddfc27df6e8c3f5f5f5c7eae580cdc135978f01665e003c30"},PRGn:{3:"af8dc3f7f7f77fbf7b",4:"7b3294c2a5cfa6dba0008837",5:"7b3294c2a5cff7f7f7a6dba0008837",6:"762a83af8dc3e7d4e8d9f0d37fbf7b1b7837",7:"762a83af8dc3e7d4e8f7f7f7d9f0d37fbf7b1b7837",8:"762a839970abc2a5cfe7d4e8d9f0d3a6dba05aae611b7837",9:"762a839970abc2a5cfe7d4e8f7f7f7d9f0d3a6dba05aae611b7837",10:"40004b762a839970abc2a5cfe7d4e8d9f0d3a6dba05aae611b783700441b",11:"40004b762a839970abc2a5cfe7d4e8f7f7f7d9f0d3a6dba05aae611b783700441b"},PiYG:{3:"e9a3c9f7f7f7a1d76a",4:"d01c8bf1b6dab8e1864dac26",5:"d01c8bf1b6daf7f7f7b8e1864dac26",6:"c51b7de9a3c9fde0efe6f5d0a1d76a4d9221",7:"c51b7de9a3c9fde0eff7f7f7e6f5d0a1d76a4d9221",8:"c51b7dde77aef1b6dafde0efe6f5d0b8e1867fbc414d9221",9:"c51b7dde77aef1b6dafde0eff7f7f7e6f5d0b8e1867fbc414d9221",10:"8e0152c51b7dde77aef1b6dafde0efe6f5d0b8e1867fbc414d9221276419",11:"8e0152c51b7dde77aef1b6dafde0eff7f7f7e6f5d0b8e1867fbc414d9221276419"},RdBu:{3:"ef8a62f7f7f767a9cf",4:"ca0020f4a58292c5de0571b0",5:"ca0020f4a582f7f7f792c5de0571b0",6:"b2182bef8a62fddbc7d1e5f067a9cf2166ac",7:"b2182bef8a62fddbc7f7f7f7d1e5f067a9cf2166ac",8:"b2182bd6604df4a582fddbc7d1e5f092c5de4393c32166ac",9:"b2182bd6604df4a582fddbc7f7f7f7d1e5f092c5de4393c32166ac",10:"67001fb2182bd6604df4a582fddbc7d1e5f092c5de4393c32166ac053061",11:"67001fb2182bd6604df4a582fddbc7f7f7f7d1e5f092c5de4393c32166ac053061"},RdGy:{3:"ef8a62ffffff999999",4:"ca0020f4a582bababa404040",5:"ca0020f4a582ffffffbababa404040",6:"b2182bef8a62fddbc7e0e0e09999994d4d4d",7:"b2182bef8a62fddbc7ffffffe0e0e09999994d4d4d",8:"b2182bd6604df4a582fddbc7e0e0e0bababa8787874d4d4d",9:"b2182bd6604df4a582fddbc7ffffffe0e0e0bababa8787874d4d4d",10:"67001fb2182bd6604df4a582fddbc7e0e0e0bababa8787874d4d4d1a1a1a",11:"67001fb2182bd6604df4a582fddbc7ffffffe0e0e0bababa8787874d4d4d1a1a1a"},RdYlBu:{3:"fc8d59ffffbf91bfdb",4:"d7191cfdae61abd9e92c7bb6",5:"d7191cfdae61ffffbfabd9e92c7bb6",6:"d73027fc8d59fee090e0f3f891bfdb4575b4",7:"d73027fc8d59fee090ffffbfe0f3f891bfdb4575b4",8:"d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4",9:"d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4",10:"a50026d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4313695",11:"a50026d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4313695"},Spectral:{3:"fc8d59ffffbf99d594",4:"d7191cfdae61abdda42b83ba",5:"d7191cfdae61ffffbfabdda42b83ba",6:"d53e4ffc8d59fee08be6f59899d5943288bd",7:"d53e4ffc8d59fee08bffffbfe6f59899d5943288bd",8:"d53e4ff46d43fdae61fee08be6f598abdda466c2a53288bd",9:"d53e4ff46d43fdae61fee08bffffbfe6f598abdda466c2a53288bd",10:"9e0142d53e4ff46d43fdae61fee08be6f598abdda466c2a53288bd5e4fa2",11:"9e0142d53e4ff46d43fdae61fee08bffffbfe6f598abdda466c2a53288bd5e4fa2"},RdYlGn:{3:"fc8d59ffffbf91cf60",4:"d7191cfdae61a6d96a1a9641",5:"d7191cfdae61ffffbfa6d96a1a9641",6:"d73027fc8d59fee08bd9ef8b91cf601a9850",7:"d73027fc8d59fee08bffffbfd9ef8b91cf601a9850",8:"d73027f46d43fdae61fee08bd9ef8ba6d96a66bd631a9850",9:"d73027f46d43fdae61fee08bffffbfd9ef8ba6d96a66bd631a9850",10:"a50026d73027f46d43fdae61fee08bd9ef8ba6d96a66bd631a9850006837",11:"a50026d73027f46d43fdae61fee08bffffbfd9ef8ba6d96a66bd631a9850006837"},Accent:{3:"7fc97fbeaed4fdc086",4:"7fc97fbeaed4fdc086ffff99",5:"7fc97fbeaed4fdc086ffff99386cb0",6:"7fc97fbeaed4fdc086ffff99386cb0f0027f",7:"7fc97fbeaed4fdc086ffff99386cb0f0027fbf5b17",8:"7fc97fbeaed4fdc086ffff99386cb0f0027fbf5b17666666"},Dark2:{3:"1b9e77d95f027570b3",4:"1b9e77d95f027570b3e7298a",5:"1b9e77d95f027570b3e7298a66a61e",6:"1b9e77d95f027570b3e7298a66a61ee6ab02",7:"1b9e77d95f027570b3e7298a66a61ee6ab02a6761d",8:"1b9e77d95f027570b3e7298a66a61ee6ab02a6761d666666"},Paired:{3:"a6cee31f78b4b2df8a",4:"a6cee31f78b4b2df8a33a02c",5:"a6cee31f78b4b2df8a33a02cfb9a99",6:"a6cee31f78b4b2df8a33a02cfb9a99e31a1c",7:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6f",8:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00",9:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d6",10:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9a",11:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99",12:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99b15928"},Pastel1:{3:"fbb4aeb3cde3ccebc5",4:"fbb4aeb3cde3ccebc5decbe4",5:"fbb4aeb3cde3ccebc5decbe4fed9a6",6:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcc",7:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bd",8:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bdfddaec",9:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bdfddaecf2f2f2"},Pastel2:{3:"b3e2cdfdcdaccbd5e8",4:"b3e2cdfdcdaccbd5e8f4cae4",5:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9",6:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2ae",7:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2aef1e2cc",8:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2aef1e2cccccccc"},Set1:{3:"e41a1c377eb84daf4a",4:"e41a1c377eb84daf4a984ea3",5:"e41a1c377eb84daf4a984ea3ff7f00",6:"e41a1c377eb84daf4a984ea3ff7f00ffff33",7:"e41a1c377eb84daf4a984ea3ff7f00ffff33a65628",8:"e41a1c377eb84daf4a984ea3ff7f00ffff33a65628f781bf",9:"e41a1c377eb84daf4a984ea3ff7f00ffff33a65628f781bf999999"},Set2:{3:"66c2a5fc8d628da0cb",4:"66c2a5fc8d628da0cbe78ac3",5:"66c2a5fc8d628da0cbe78ac3a6d854",6:"66c2a5fc8d628da0cbe78ac3a6d854ffd92f",7:"66c2a5fc8d628da0cbe78ac3a6d854ffd92fe5c494",8:"66c2a5fc8d628da0cbe78ac3a6d854ffd92fe5c494b3b3b3"},Set3:{3:"8dd3c7ffffb3bebada",4:"8dd3c7ffffb3bebadafb8072",5:"8dd3c7ffffb3bebadafb807280b1d3",6:"8dd3c7ffffb3bebadafb807280b1d3fdb462",7:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69",8:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5",9:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9",10:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bd",11:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bdccebc5",12:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bdccebc5ffed6f"},Default:{20:"fe296c487eb6a7ce31f8cc03ff8c02699696b7784483acd0c2e076fadc5aff549fffaf549ab8b7d2a6833d699b87ac22cda908d02158d07300567676",36:"ff00000000ff00ff00ffff0000ffffff00ff993300000080808000ff6600008080660066ff99cc666699333300ffcc99ccffff9999ffff80803366ff339966ffcc0000ccffd020909933660066cc99cc00ff990033cccccc99ff800000333399008000ffffcc99ccff800080"},Basic:{24:"0000ffff004dffbf0074ff00a400ffff7400ffff0000ffffff0000ffd3003d00ff00ff00ff00ffff9200d3ff000090ff6d00ffff4900ffe80000ff92ff0090ffaa00aaff00004dff"},Light:{24:"6565ffff6593ffd865abff65c865ffffab65ffff6565ffffff6565ffe5658965ff65ff65ff65ffffbd65e5ff6565bcffa765ffff9165fff16565ffbdff65bcffcc65ccff656593ff"},Favorite:{1:"ff0000",2:"ff000000ffff",3:"ff000000ff000000ff",4:"ff000080ff0000ffff8000ff",5:"ff0000bfff0000ff800040ffff00ff",6:"ff0000ffff0000ff0000ffff0000ffff00ff",8:"ff0000ffbf0080ff0000ff4000ffff0040ff8000ffff00bf",10:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ff",12:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ffff00ffff0080",24:"ff0000ff4000ff8000ffbf00ffff00bfff0080ff0040ff0000ff0000ff4000ff8000ffbf00ffff00bfff0080ff0040ff0000ff4000ff8000ffbf00ffff00ffff00bfff0080ff0040"},Pastel:{24:"b5b5ffffb5cbffedb5d7ffb5e5b5ffffd7b5ffffb5b5ffffffb5b5fff2b5c7b5ffb5ffb5ffb5ffffdfb5f2ffb5b5dfffd5b5ffffcab5fff8b5b5ffdfffb5dfffe6b5e6ffb5b5cbff"},Balanced:{20:"fe296c487eb6a7ce31f8cc03ff8c02699696b7784483acd0c2e076fadc5aff549fffaf549ab8b7d2a6833d699b87ac22cda908d02158d07300567676"},Rpalette:{8:"000000ff000000cd000000ff00ffffff00ffffff00bebebe"},RlatticeBackground:{7:"ffe5ccccffccccffffcce6ffffccffffccccffffcc"},RlatticeShingle:{7:"ff7f0000ff0000ffff0080ffff00ffff0000ffff00"},RlatticeLine:{7:"0080ffff00ff006400ff0000ffa50000ff00a52a2a"},RlatticePolygon:{7:"ccffffffccffccffccffe5cccce6ffffffccffcccc"},Bootstrap:{1:"337ab7",2:"337ab7d9534f",3:"337ab75cb85cd9534f",4:"337ab75cb85cf0ad4ed9534f",5:"337ab75cb85c5bc0def0ad4ed9534f",6:"337ab75cb85c9370db5bc0def0ad4ed9534f",7:"337ab75cb85cd9534ff0ad4e5bc0de84fe83ff9976",8:"337ab75cb85cd9534ff0ad4e5bc0de84fe83ff9976c86727"},ColorSpectrum:{1:""},White:{1:"ffffff"},Black:{1:"000000"},Diverging:{5:"f5841dedbb69d0d5e155b5d90c4487"},DivergingAlt:{5:"9e0418dd6c72d0d5e135a0c8042750"},Brand:{4:"cfe2f15eaccf0e76b0042751"},Complementary:{4:"f7d6d5ff8581e040439e0418"},Colorful:{5:"fcf6c4b1ca91718be67d53b0920148"},ColorfulAlt:{5:"fcf6c4edb681c77b7a7f50930e3587"},WHO:{6:"108dc98eca3affa16ae65550ffa3005bc2e7"},NPG:{10:"e64b354dbbd500a0873c5488f39b7f8491b491d1c2dc00007e6148b09c85"},AAAS:{10:"3b4992ee0000008b45631879008280bb00215f559ba200568081801b1919"},NEJM:{8:"bc3c290072b5e1872720854e7876b16f99adffdc91ee4c97"},Lancet:{9:"00468bed000042b5400099b4925e9ffdaf91ad002aadb6b61b1919"},Jama:{7:"374e55df8f4400a1d5b2474579af976a659980796b"},JCO:{10:"0073c2efc000868686cd534c7aa6dc003c678f77003b3b3ba730304a6990"},Economist:{12:"6794a7014d6476c0c101a2d97ad2f600887dadadad7bd3f67c260bee8f7176c0c1a18376"},EconomistBG:{5:"d5e4ebc3d6dfed111aebebebc9c9c9"},Excel:{7:"ff00ffffff0000ffff8000808000000080800000ff"},Excel2:{7:"993366ffffccccffff660066ff80800066ccccccff"},Excel3:{10:"365e9698333477973d5d437c36869fd1702f8197c5c47f80acc4849887b0"},GGPlot:{1:"595959",2:"f8766d00bfc4",3:"f8766d00ba38619cff",4:"f8766d7cae0000bfc4c77cff",5:"f8766da3a50000bf7d00b0f6e76bf3",6:"f8766db79f0000ba3800bfc4619cfff564e3",7:"f8766dc49a0053b40000c09400b6eba58afffb61d7",8:"f8766dcd96007cae0000be6700bfc400a9ffc77cffff61cc",9:"f8766dd3920093aa0000ba3800c19f00b9e3619cffdb72fbff61c3",10:"f8766dd89000a3a50039b60000bf7d00bfc400b0f69590ffe76bf3ff62bc",11:"f8766ddb8e00aea20064b20000bd5c00c1a700bade00a6ffb385ffef67ebff63b6",12:"f8766dde8c00b79f007cae0000ba3800c08b00bfc400b4f0619cffc77cfff564e3ff64b0",13:"f8766de18a00be9c008cab0024b70000be7000c1ab00bbda00acfc8b93ffd575fef962ddff65ac",14:"f8766de38900c49a0099a80053b40000bc5600c09400bfc400b6eb06a4ffa58affdf70f8fb61d7ff66a8",15:"f8766de58700c99800a3a5006bb10000ba3800bf7d00c0af00bcd800b0f6619cffb983ffe76bf3fd61d1ff67a4",16:"f8766de68613cd9600aba3007cae000cb70200be6700c19a00bfc400b8e700a9ff8494ffc77cffed68edff61ccff68a1",17:"f8766de7851ed09400b2a10089ac0045b50000bc5100c08700c0b200bcd600b3f229a3ff9c8dffd277fff166e8ff61c7ff689e",18:"f8766de88526d39200b79f0093aa005eb30000ba3800bf7400c19f00bfc400b9e300adfa619cffae87ffdb72fbf564e3ff61c3ff699c"},Solarized:{1:"b58900",2:"b58900859900",3:"b58900c671c4859900",4:"b58900dc322f268bd2859900",5:"b58900dc322f6c71c4268bd2859900",6:"b58900cb4b16d336826c71c42aa198859900",7:"b58900cb4b16dc322f6c71c4268bd22aa198859900",8:"b58900cb4b16dc322fd336826c71c4268bd22aa198859900"},SolarizedBase:{7:"002b36073642586e7583949693a1a1eee8d5fdf6e3",8:"002b36073642586e75657b8383949693a1a1eee8d5fdf6e3"},PaulTol:{1:"4477aa",2:"4477aacc6677",3:"4477aaddcc77cc6677",4:"4477aa117733ddcc77cc6677",5:"4477aa88ccee117733ddcc77cc6677",6:"4477aa88ccee117733ddcc77cc6677aa4499",7:"33228888ccee44aa99117733ddcc77cc6677aa4499",8:"33228888ccee44aa99117733999933ddcc77cc6677aa4499",9:"33228888ccee44aa99117733999933ddcc77cc6677882255aa4499",10:"33228888ccee44aa99117733999933ddcc77661100cc6677882255aa4499",11:"3322886699cc88ccee44aa99117733999933ddcc77661100cc6677882255aa4499",12:"3322886699cc88ccee44aa99117733999933ddcc77661100cc6677aa4466882255aa4499"},ColorBlind:{8:"000000e69f0056b4e9009e73f0e4420072b2d55e00cc79a7"},Tableau:{20:"1f77b4aec7e8ff7f0effbb782ca02c98df8ad62728ff98969467bdc5b0d58c564bc49c94e377c2f7b6d27f7f7fc7c7c7bcbd22dbdb8d17becf9edae5",10:"1f77b4ff7f0e2ca02cd627289467bd8c564be377c27f7f7fbcbd2217becf"},TableauMedium:{10:"729eceff9e4a67bf5ced665dad8bc9a8786eed97caa2a2a2cdcc5d6dccda"},TableauLight:{10:"aec7e8ffbb7898df8aff9896c5b0d5c49c94f7b6d2c7c7c7dbdb8d9edae5"},TableauGrey:{5:"60636aa5acaf4144518f8782cfcfcf"},TableauColorBlind:{10:"006ba4ff800eababab5959595f9ed1c85200898989a2c8ecffbc79cfcfcf"},TableauTrafficLight:{9:"b10318dba13a309343d82526ffc15669b764f26c64ffdd719fcd99"},TableauPurpleGrey:{12:"7b66d2a699e8dc5fbdffc0da5f5a41b4b19b995688d898baab6ad5d098ee8b7c6edbd4c5"},TableauBlueRed:{12:"2c69b0b5c8e2f02720ffb6b0ac613ce9c39b6ba3d6b5dffdac8763ddc9b4bd0a36f4737a"},TableauGreenOrange:{12:"32a251acd98dff7f0fffb9773cb7cc98d9e4b85a0dffd94a39737c86b4a982853bccc94d"},TableauCyclic:{20:"1f83b41696ac18a18829a03c54a33882a93fadb828d8bd35ffbd4cffb022ff9c0eff810ee75727d23e4ec94d8cc04aa7b446b39658b18061b46f63bb"},TableauPairSequential:{32:"bccfb49c0824bccfb409622ab4d4da26456ef0c2947b3014c3c3c31e1e1ee5e5e5ffb2b6e5e5e5b7e6a7e5e5e5c4d8f3e5e5e5ffcc9ef5cac7bd1100dbe8b43c8200f3e0c2bb5137feffd941b7c4f7e4c6bb5137efedf5807dbaf0f0f0737373"},TableauTripleDiverging:{48:"9c0824cacaca26456e9c0824cacaca09622a9c0824ffffff09622a9c0824cacaca1e1e1e9c0824ffffff1e1e1e09622acacaca26456e7b3014cacaca26456e7b3014ffffff26456effb2b6e5e5e5b7e6a7ffb2b6ffffffb7e6a7ffb2b6ffffffc6c6c6ffcc9ee5e5e5c4d8f3ffcc9effffffc4d8f3e0ad30e4e4e27492aaeda389cde1d35c8b70529985dbcf47c26b51"},WallStreetJournal:{4:"efefefe9f3ead4dee7f8f2e4"},WallStreetJournal2:{4:"d3ba68d5695d5d8ca865a479"},WallStreetJournalRedGreen:{2:"088158ba2f2a"},WallStreetJournalBlackGreen:{4:"00000059595959a77f008856"},WallStreetJournalDemRep:{3:"006a8eb1283aa8a6a7"},WallStreetJournal3:{6:"c72e29016392be9c2e098154fb832d000000"},Stata:{15:"1a476f90353b55752fe37e006e8e84c10534938dd2cac27ea0522d7b92a82d6d669c8847bfa19cffd200d9e6eb"},Stata2:{15:"ffff0000ff000080ffff00ffff7f00ff0000add8e6ffe47400ff80c0dcc0ff45000000ffff00806e8e84a0522d"},Stata3:{15:"006000ff45001a476f90353b6e8e84a0522dff7f00ff00ff00ffffff000000ff009c8847800080c0dcc0add8e6"},StataMono:{15:"606060a0a0a0808080404040000000e0e0e0202020707070909090b0b0b0d0d0d0f0f0f0303030c0c0c0505050"},BlackAndWhite:{3:"f0f0f0bdbdbd636363",4:"f7f7f7cccccc969696525252",5:"f7f7f7cccccc969696636363252525",6:"f7f7f7d9d9d9bdbdbd969696636363252525",7:"f7f7f7d9d9d9bdbdbd969696737373525252252525",8:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525",9:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525000000"},BehancePair:{2:"6b5dd3cec8ff",4:"6b5dd3cec8ffffa2c0ffc6db",6:"6b5dd3cec8ffffa2c0ffc6db3f8cffa0d7e7",8:"6b5dd3cec8ffffa2c0ffc6db3f8cffa0d7e7fece73ffa25f",10:"6b5dd3cec8ffffa2c0ffc6db3f8cffa0d7e7fece73ffa25f1b1d218d8e90"},BehanceTrio:{3:"6b5dd3cec8ff9d93e9",6:"6b5dd3cec8ff9d93e9ffa2c0ffc6dbff78a4",9:"6b5dd3cec8ff9d93e9ffa2c0ffc6dbff78a43f8cffa0d7e71b49c5",12:"6b5dd3cec8ff9d93e9ffa2c0ffc6dbff78a43f8cffa0d7e71b49c5fece73ffa25ffee2ab",15:"6b5dd3cec8ff9d93e9ffa2c0ffc6dbff78a43f8cffa0d7e71b49c5fece73ffa25ffee2ab1b1d218d8e90494a4d"},BehanceQuartet:{4:"6b5dd3cec8ff9d93e98072dc",8:"6b5dd3cec8ff9d93e98072dcffa2c0ffc6dbff78a4ffbed3",12:"6b5dd3cec8ff9d93e98072dcffa2c0ffc6dbff78a4ffbed33f8cffa0d7e71b49c5cdf4ff",16:"6b5dd3cec8ff9d93e98072dcffa2c0ffc6dbff78a4ffbed33f8cffa0d7e71b49c5cdf4fffece73ffa25ffee2abfedd9d",20:"6b5dd3cec8ff9d93e98072dcffa2c0ffc6dbff78a4ffbed33f8cffa0d7e71b49c5cdf4fffece73ffa25ffee2abfedd9d1b1d218d8e90494a4dfafafa"},Behance:{1:"6b5dd3",2:"6b5dd3ffa2c0",3:"6b5dd3ffa2c03f8cff",4:"6b5dd3ffa2c03f8cfffece73",5:"6b5dd33f8cffffa2c0fece731b1d21",6:"6b5dd3ffa2c03f8cff9d93e9ffc6dba0d7e7",7:"6b5dd33f8cffffa2c0fece731b1d21ffa25fcdf4ff",8:"6b5dd3ffa2c03f8cfffece739d93e9a0d7e7ffc6dbfee2ab",9:"6b5dd33f8cffffa2c0fece731b1d219d93e9a0d7e7ffc6dbfee2ab",10:"6b5dd33f8cffffa2c0fece731b1d219d93e9a0d7e7ffc6dbfee2ab8d8e90",15:"6b5dd33f8cffffa2c0fece731b1d219d93e9a0d7e7ffc6dbfee2ab8d8e90cec8ff1b49c5ff78a4ffa25f494a4d",20:"6b5dd33f8cffffa2c0fece731b1d219d93e9a0d7e7ffc6dbfee2ab8d8e90cec8ff1b49c5ff78a4ffa25f494a4d8072dccdf4ffffbed3fedd9dfafafa"},GGBlanket:{1:"357BA2",2:"0095A8FFA600",3:"003f5cbc5090ffa600",4:"003f5cbc5090ffa60050bc70",5:"003f5cbc5090ffa60050bc70005aff",6:"003f5cbc5090ffa60050bc70005affff9f5c",7:"003f5cbc5090ffa60050bc70005affff9f5c7a5195",8:"003f5cbc5090ffa60050bc70005affff9f5c7a5195ff6e00",12:"003f5cbc5090ffa600007f8cd075a8ffcc3300bfbfe59bc0fff56600ffffffb6c1ffff99"},Prism:{1:"1f7ff1",2:"1f7ff1814cff",3:"1f7ff1814cffff7d00",4:"1f7ff1814cffff7d0012c5ff",5:"1f7ff1814cffff7d0012c5fff4d4fe",6:"1f7ff1814cffff7d0012c5fff4d4fee9c505",7:"1f7ff1814cffff7d0012c5fff4d4fee9c505898790"},PrismPair:{2:"1f7ff112c5ff",4:"1f7ff112c5ff814cfff4d4fe",6:"1f7ff112c5ff814cfff4d4feff7d00e9c505",8:"1f7ff112c5ff814cfff4d4feff7d00e9c505042d710ccffe"},PrismTrio:{3:"61459939d4fbfe7d29"},BMS:{4:"be2bbb585454a59fa0ede7e8",9:"be2bbb585454a59fa0ede7e8ffeccdfedccad9c5c4c6ffe6c0f2fc"},BMSPrimary:{4:"BE2BBBA69F9F595454EEE7E7"},BMSSecondary:{5:"ffeccdfedccad9c5c4c6ffe6c0f2fc",6:"ffeccdfedccaead6c8e0cbc3d9c5c4d2cac9",8:"FFECCDFEDCCAEAD5C9DFCBC3DAC5C5D2CAC8C5FFE6C0F2FB"},BMSTertiary:{2:"c6ffe6c0f2fc"},BMSTertiaryLight:{5:"59FFB9FDA97D33D6F1CB7C78FFD186"},BMSTertiaryDark:{5:"1DCE9BDF603A009FBA772A28FFAC25"},BMSBackground:{3:"f0ebeaefe6e7f9f7fa"},BMSWheat:{4:"ffeccdfed187feac25c37901"},BMSPink:{4:"fedccafea97de0613cba4421"},BMSBrown:{4:"d9c5c4cb7c79782a28511515"},BMSGreen:{4:"c6ffe652e7bd1ecd9a138967"},BMSBlue:{4:"c0f2fc33d7f102a0baa0778a"},CanvasXpress:{1:"4575b4",2:"d730274575b4",3:"d7191cfdae612c7bb6",4:"d7191cfdae61abd9e92c7bb6",5:"d7191cfdae61ffffbfabd9e92c7bb6",6:"d73027fc8d59fee090e0f3f891bfdb4575b4",7:"d73027fc8d59fee090ffffbfe0f3f891bfdb4575b4",8:"d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4",9:"d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4",10:"a50026d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4313695",11:"a50026d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4313695"},CanvasXpressTraditional:{1:"f2000d",2:"f2000d000df2",3:"f2000d000df20df200",4:"f2000d000df20df200f2f20d",5:"f2000d000df20df200f2f20df20df2",6:"f2000d000df20df200f2f20df20df20df2f2",7:"f2000d000df20df200f2f20df20df20df2f2f2f2f2",8:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd3",9:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fe",10:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b",11:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d0016",12:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d",13:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00",14:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808",15:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38b",16:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38bd38bfe",17:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38bd38bfe8bfed3",18:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38bd38bfe8bfed3404040"},Matlab:{7:"0072bdd95319edb1207e2f8e77ac304dbeeea2142f"},Parula:{10:"352a870f5cdd127dd8079ccf15b1b459bd8ca5be6be1b952fcce2ef9fb0e"},Viridis:{3:"44015421908cfde725",4:"44015431688e35b779fde725",5:"4401543b528b21908c5dc863fde725",6:"4401544144872a788e22a8847ad151fde725",7:"440154443a8331688e21908c35b7798fd744fde725",8:"44015446337e365c8d277f8e1fa1874ac16d9fda3afde725",9:"440154472d7b3b528b2c728e21908c27ad815dc863aadc32fde725",10:"4401544828783e4a8931688e26828e1f9e8935b7796dcd59b4de2cfde725",11:"44015448257641448735608d2a788e21908c22a88443bf717ad151bbdf27fde725",12:"440154482173433e8538598c2d708e25858e1e9b8a2bb07f51c56a85d54ac2df23fde725",256:"44015444025645045745055946075a46085c460a5d460b5e470d60470e6147106347116447136548146748166848176948186a481a6c481b6d481c6e481d6f481f70482071482173482374482475482576482677482878482979472a7a472c7a472d7b472e7c472f7d46307e46327e46337f463480453581453781453882443983443a83443b84433d84433e85423f854240864241864142874144874045884046883f47883f48893e49893e4a893e4c8a3d4d8a3d4e8a3c4f8a3c508b3b518b3b528b3a538b3a548c39558c39568c38588c38598c375a8c375b8d365c8d365d8d355e8d355f8d34608d34618d33628d33638d32648e32658e31668e31678e31688e30698e306a8e2f6b8e2f6c8e2e6d8e2e6e8e2e6f8e2d708e2d718e2c718e2c728e2c738e2b748e2b758e2a768e2a778e2a788e29798e297a8e297b8e287c8e287d8e277e8e277f8e27808e26818e26828e26828e25838e25848e25858e24868e24878e23888e23898e238a8d228b8d228c8d228d8d218e8d218f8d21908d21918c20928c20928c20938c1f948c1f958b1f968b1f978b1f988b1f998a1f9a8a1e9b8a1e9c891e9d891f9e891f9f881fa0881fa1881fa1871fa28720a38620a48621a58521a68522a78522a88423a98324aa8325ab8225ac8226ad8127ad8128ae8029af7f2ab07f2cb17e2db27d2eb37c2fb47c31b57b32b67a34b67935b77937b87838b9773aba763bbb753dbc743fbc7340bd7242be7144bf7046c06f48c16e4ac16d4cc26c4ec36b50c46a52c56954c56856c66758c7655ac8645cc8635ec96260ca6063cb5f65cb5e67cc5c69cd5b6ccd5a6ece5870cf5773d05675d05477d1537ad1517cd2507fd34e81d34d84d44b86d54989d5488bd6468ed64590d74393d74195d84098d83e9bd93c9dd93ba0da39a2da37a5db36a8db34aadc32addc30b0dd2fb2dd2db5de2bb8de29bade28bddf26c0df25c2df23c5e021c8e020cae11fcde11dd0e11cd2e21bd5e21ad8e219dae319dde318dfe318e2e418e5e419e7e419eae51aece51befe51cf1e51df4e61ef6e620f8e621fbe723fde725"},Magma:{3:"000004b63679fcfdbf",4:"000004721f81f1605dfcfdbf",5:"00000451127cb63679fb8861fcfdbf",6:"0000043b0f708c2981de4968fe9f6dfcfdbf",7:"0000042d1160721f81b63679f1605dfeaf77fcfdbf",8:"0000042311515f187f982d80d3436ef8765cfeba80fcfdbf",9:"0000041d114751127c822681b63679e65164fb8861fec287fcfdbf",10:"000004180f3e451077721f819f2f7fcd4071f1605dfd9567fec98dfcfdbf",11:"000004150e373b0f70641a808c2981b63679de4968f76f5cfe9f6dfece91fcfdbf",12:"000004120d323310685a167e7d2482a3307ec83e73e95562f97c5dfea873fed395fcfdbf",256:"00000401000501010601010802010902020b02020d03030f03031204041405041606051806051a07061c08071e0907200a08220b09240c09260d0a290e0b2b100b2d110c2f120d31130d34140e36150e38160f3b180f3d19103f1a10421c10441d11471e114920114b21114e22115024125325125527125829115a2a115c2c115f2d11612f116331116533106734106936106b38106c390f6e3b0f703d0f713f0f72400f74420f75440f764510774710784910784a10794c117a4e117b4f127b51127c52137c54137d56147d57157e59157e5a167e5c167f5d177f5f187f601880621980641a80651a80671b80681c816a1c816b1d816d1d816e1e81701f81721f817320817521817621817822817922827b23827c23827e24828025828125818326818426818627818827818928818b29818c29818e2a81902a81912b81932b80942c80962c80982d80992d809b2e7f9c2e7f9e2f7fa02f7fa1307ea3307ea5317ea6317da8327daa337dab337cad347cae347bb0357bb2357bb3367ab5367ab73779b83779ba3878bc3978bd3977bf3a77c03a76c23b75c43c75c53c74c73d73c83e73ca3e72cc3f71cd4071cf4070d0416fd2426fd3436ed5446dd6456cd8456cd9466bdb476adc4869de4968df4a68e04c67e24d66e34e65e44f64e55064e75263e85362e95462ea5661eb5760ec5860ed5a5fee5b5eef5d5ef05f5ef1605df2625df2645cf3655cf4675cf4695cf56b5cf66c5cf66e5cf7705cf7725cf8745cf8765cf9785df9795df97b5dfa7d5efa7f5efa815ffb835ffb8560fb8761fc8961fc8a62fc8c63fc8e64fc9065fd9266fd9467fd9668fd9869fd9a6afd9b6bfe9d6cfe9f6dfea16efea36ffea571fea772fea973feaa74feac76feae77feb078feb27afeb47bfeb67cfeb77efeb97ffebb81febd82febf84fec185fec287fec488fec68afec88cfeca8dfecc8ffecd90fecf92fed194fed395fed597fed799fed89afdda9cfddc9efddea0fde0a1fde2a3fde3a5fde5a7fde7a9fde9aafdebacfcecaefceeb0fcf0b2fcf2b4fcf4b6fcf6b8fcf7b9fcf9bbfcfbbdfcfdbf"},Plasma:{3:"0d0887cc4678f0f921",4:"0d08879c179eed7953f0f921",5:"0d08877e03a8cc4678f89441f0f921",6:"0d08876a00a8b12a90e16462fca636f0f921",7:"0d08875d01a69c179ecc4678ed7953fdb32ff0f921",8:"0d08875402a38b0aa5b93289db5c68f48849febc2af0f921",9:"0d08874c02a17e03a8a92395cc4678e56b5df89441fdc328f0f921",10:"0d088747039f7301a89c179ebd3786d8576bed7953fa9e3bfdc926f0f921",11:"0d088742049e6a00a8900da4b12a90cc4678e16462f1844bfca636fcce25f0f921",12:"0d08873e049c6300a78707a6a62098c03a83d5546ee76f5af58c46fdad32fcd225f0f921",256:"0d088710078813078916078a19068c1b068d1d068e20068f2206902406912605912805922a05932c05942e05952f059631059733059735049837049938049a3a049a3c049b3e049c3f049c41049d43039e44039e46039f48039f4903a04b03a14c02a14e02a25002a25102a35302a35502a45601a45801a45901a55b01a55c01a65e01a66001a66100a76300a76400a76600a76700a86900a86a00a86c00a86e00a86f00a87100a87201a87401a87501a87701a87801a87a02a87b02a87d03a87e03a88004a88104a78305a78405a78606a68707a68808a68a09a58b0aa58d0ba58e0ca48f0da4910ea3920fa39410a29511a19613a19814a099159f9a169f9c179e9d189d9e199da01a9ca11b9ba21d9aa31e9aa51f99a62098a72197a82296aa2395ab2494ac2694ad2793ae2892b02991b12a90b22b8fb32c8eb42e8db52f8cb6308bb7318ab83289ba3388bb3488bc3587bd3786be3885bf3984c03a83c13b82c23c81c33d80c43e7fc5407ec6417dc7427cc8437bc9447aca457acb4679cc4778cc4977cd4a76ce4b75cf4c74d04d73d14e72d24f71d35171d45270d5536fd5546ed6556dd7566cd8576bd9586ada5a6ada5b69db5c68dc5d67dd5e66de5f65de6164df6263e06363e16462e26561e26660e3685fe4695ee56a5de56b5de66c5ce76e5be76f5ae87059e97158e97257ea7457eb7556eb7655ec7754ed7953ed7a52ee7b51ef7c51ef7e50f07f4ff0804ef1814df1834cf2844bf3854bf3874af48849f48948f58b47f58c46f68d45f68f44f79044f79143f79342f89441f89540f9973ff9983ef99a3efa9b3dfa9c3cfa9e3bfb9f3afba139fba238fca338fca537fca636fca835fca934fdab33fdac33fdae32fdaf31fdb130fdb22ffdb42ffdb52efeb72dfeb82cfeba2cfebb2bfebd2afebe2afec029fdc229fdc328fdc527fdc627fdc827fdca26fdcb26fccd25fcce25fcd025fcd225fbd324fbd524fbd724fad824fada24f9dc24f9dd25f8df25f8e125f7e225f7e425f6e626f6e826f5e926f5eb27f4ed27f3ee27f3f027f2f227f1f426f1f525f0f724f0f921"},Inferno:{3:"000004bb3754fcffa4",4:"000004781c6ded6925fcffa4",5:"00000456106ebb3754f98c0afcffa4",6:"000004420a68932667dd513afca50afcffa4",7:"000004330a5f781c6dbb3754ed6925fcb519fcffa4",8:"000004280b5465156e9f2a63d44842f57d15fac127fcffa4",9:"000004210c4a56106e89226abb3754e35932f98c0af9c932fcffa4",10:"0000041b0c424b0c6b781c6da52c60cf4446ed6925fb9a06f7d03cfcffa4",11:"000004170c3a420a686b186e932667bb3754dd513af3771afca50af6d645fcffa4",12:"000004140b353a096360136e85216ba92e5ecb4149e65d2ff78311fcad12f5db4bfcffa4",256:"00000401000501010601010802010a02020c02020e03021004031204031405041706041907051b08051d09061f0a07220b07240c08260d08290e092b10092d110a30120a32140b34150b37160b39180c3c190c3e1b0c411c0c431e0c451f0c48210c4a230c4c240c4f260c51280b53290b552b0b572d0b592f0a5b310a5c320a5e340a5f3609613809623909633b09643d09653e0966400a67420a68440a68450a69470b6a490b6a4a0c6b4c0c6b4d0d6c4f0d6c510e6c520e6d540f6d550f6d57106e59106e5a116e5c126e5d126e5f136e61136e62146e64156e65156e67166e69166e6a176e6c186e6d186e6f196e71196e721a6e741a6e751b6e771c6d781c6d7a1d6d7c1d6d7d1e6d7f1e6c801f6c82206c84206b85216b87216b88226a8a226a8c23698d23698f24699025689225689326679526679727669827669a28659b29649d29649f2a63a02a63a22b62a32c61a52c60a62d60a82e5fa92e5eab2f5ead305dae305cb0315bb1325ab3325ab43359b63458b73557b93556ba3655bc3754bd3853bf3952c03a51c13a50c33b4fc43c4ec63d4dc73e4cc83f4bca404acb4149cc4248ce4347cf4446d04545d24644d34743d44842d54a41d74b3fd84c3ed94d3dda4e3cdb503bdd513ade5238df5337e05536e15635e25734e35933e45a31e55c30e65d2fe75e2ee8602de9612bea632aeb6429eb6628ec6726ed6925ee6a24ef6c23ef6e21f06f20f1711ff1731df2741cf3761bf37819f47918f57b17f57d15f67e14f68013f78212f78410f8850ff8870ef8890cf98b0bf98c0af98e09fa9008fa9207fa9407fb9606fb9706fb9906fb9b06fb9d07fc9f07fca108fca309fca50afca60cfca80dfcaa0ffcac11fcae12fcb014fcb216fcb418fbb61afbb81dfbba1ffbbc21fbbe23fac026fac228fac42afac62df9c72ff9c932f9cb35f8cd37f8cf3af7d13df7d340f6d543f6d746f5d949f5db4cf4dd4ff4df53f4e156f3e35af3e55df2e661f2e865f2ea69f1ec6df1ed71f1ef75f1f179f2f27df2f482f3f586f3f68af4f88ef5f992f6fa96f8fb9af9fc9dfafda1fcffa4"},Cividis:{3:"00204d7c7b78ffea46",4:"00204d575c6da69d75ffea46",5:"00204d414d6b7c7b78bcaf6fffea46",6:"00204d31446b666970958f78cbba69ffea46",7:"00204d233e6c575c6d7c7b78a69d75d3c164ffea46",8:"00204d16396d4b546c6c6e728e8a79b3a772dbc761ffea46",9:"00204d05366e414d6b61646f7c7b789b9477bcaf6fe0cb5effea46",10:"00204d00336f39486b575c6d7071738a8779a69d75c4b56ce4cf5bffea46",11:"00204d00326f31446b4e576c6669707c7b78958f78b0a473cbba69e7d159ffea46",12:"00204d00306f2a406c48526b5e626e7273748784799e9677b6a971d0be67ead357ffea46",256:"00204c00204e00215000225100235300235500245600255800265a00265b00275d00285f002861002963002a64002a66002b68002c6a002d6c002d6d002e6e002e6f002f6f002f6f00306f00316f00316f00326e00336e00346e00346e01356e06366e0a376d0e376d12386d15396d17396d1a3a6c1c3b6c1e3c6c203c6c223d6c243e6c263e6c273f6c29406b2b416b2c416b2e426b2f436b31446b32446b33456b35466b36466b37476b38486b3a496b3b496b3c4a6b3d4b6b3e4b6b404c6b414d6b424e6b434e6b444f6b45506b46506b47516b48526b49536b4a536b4b546b4c556b4d556b4e566b4f576c50586c51586c52596c535a6c545a6c555b6c565c6c575d6d585d6d595e6d5a5f6d5b5f6d5c606d5d616e5e626e5f626e5f636e60646e61656f62656f63666f64676f65676f666870676970686a70686a70696b716a6c716b6d716c6d726d6e726e6f726f6f726f70737071737172737272747373747474757575757575757676767777767878767978777a79777b7a777b7b787c7b787d7c787e7d787f7e78807e78817f788280788381788481788582788683788784788885788985788a86788b87788c88788d88788e89788f8a78908b78918c78928c78938d78948e78958f78968f779790779891779992779a93779b93779c94779d95779e96769f9776a09876a19876a29976a39a75a49b75a59c75a69c75a79d75a89e74a99f74aaa074aba174aca173ada273aea373afa473b0a572b1a672b2a672b4a771b5a871b6a971b7aa70b8ab70b9ab70baac6fbbad6fbcae6ebdaf6ebeb06ebfb16dc0b16dc1b26cc2b36cc3b46cc5b56bc6b66bc7b76ac8b86ac9b869cab969cbba68ccbb68cdbc67cebd67d0be66d1bf66d2c065d3c065d4c164d5c263d6c363d7c462d8c561d9c661dbc760dcc860ddc95fdeca5edfcb5de0cb5de1cc5ce3cd5be4ce5be5cf5ae6d059e7d158e8d257e9d356ebd456ecd555edd654eed753efd852f0d951f1da50f3db4ff4dc4ef5dd4df6de4cf7df4bf9e049fae048fbe147fce246fde345ffe443ffe542ffe642ffe743ffe844ffe945"},Rainbow:{3:"ff000000ff000000ff",4:"ff000080ff0000ffff8000ff",5:"ff0000ccff0000ff660066ffcc00ff",6:"ff0000ffff0000ff0000ffff0000ffff00ff",7:"ff0000ffdb0049ff0000ff920092ff4900ffff00db",8:"ff0000ffbf0080ff0000ff4000ffff0040ff8000ffff00bf",9:"ff0000ffaa00aaff0000ff0000ffaa00aaff0000ffaa00ffff00aa",10:"ff0000ff9900ccff0033ff0000ff6600ffff0066ff3300ffcc00ffff0099",11:"ff0000ff8b00e8ff005dff0000ff2e00ffb900b9ff002eff5d00ffe800ffff008b",12:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ffff00ffff0080"},Heat:{3:"ff0000ff8000ffff00",4:"ff0000ff8000ffff00ffff80",5:"ff0000ff5500ffaa00ffff00ffff80",6:"ff0000ff4000ff8000ffbf00ffff00ffff80",7:"ff0000ff3300ff6600ff9900ffcc00ffff00ffff80",8:"ff0000ff3300ff6600ff9900ffcc00ffff00ffff40ffffbf",9:"ff0000ff2a00ff5500ff8000ffaa00ffd500ffff00ffff40ffffbf",10:"ff0000ff2400ff4900ff6d00ff9200ffb600ffdb00ffff00ffff40ffffbf",11:"ff0000ff2000ff4000ff6000ff8000ff9f00ffbf00ffdf00ffff00ffff40ffffbf",12:"ff0000ff2000ff4000ff6000ff8000ff9f00ffbf00ffdf00ffff00ffff2affff80ffffd5"},LastAirBenderFire:{8:"ecb100a100007E605EFF45009948234B4C4E572530000000"},LastAirBenderAir:{7:"ff9933C24841FFFF338B5B4587AFD1EEB05ADBC5A0"},LastAirBenderEarth:{9:"015E05B1A8667A5C1264674225351C4C7022C7C45ED2CFABFEFED8"},LastAirBenderWater:{8:"0047ab1DB4D3A2CAEDAFB5B8120976fffafa174D79949BBC"},SpongeBob:{11:"C86925FDF56CC4433F989B46FC95765D57AFB2CE31FF2027000000B1D6C5AB8323"},Simpsons:{10:"fed90f424f46d1b271FB4122ABC67D0363C37A491E000000FC020946732E"},RickyAndMorty:{9:"01B4C697ce4cFFF874BEE5FDF675DA44281d3a4767F8D3ACE64358"},ParksAndRecreation:{10:"bdbdbda51209ffdb58ec70147A491EC24841005502f7fcb969983ab5651d"},KimPossible:{12:"FF8C0002466370D42389160402001F9CF6F7FFCE455D734DFEC3BB662C9Cfff9f5000000"},GravityFalls:{14:"417BA1ff1493ffff2e3456348b0000ff670093C0D58b45139248A71c88594747478fbc8fd2b48c000000"},GameOfThronesStark:{9:"cadde17B906F174D79fffafa898989D4CDB1708090120976000000"},GameOfThronesStannis:{7:"FF0000ff8d1aFFD700b20000cc6600FFFF66000000"},GameOfThronesLannister:{6:"89080AC5AA73FEDF25C248418B5B45000000"},GameOfThronesTyrell:{9:"068105F7DC27808000AB681BF9FE768DA08071749798FB983CB371"},GameOfThronesTargaryen:{5:"AC1F25272727ff993382878896804b"},GameOfThronesMartell:{8:"ff8000cc6600b81b1873110ff8fc23fafd7b4c2600a57642"},GameOfThronesTully:{6:"212250AE432FE4EDCA8B5B454682B4000000"},GameOfThronesGreyjoy:{6:"000000708090D4CDB1DCDCDCF7DC27808080"},GameOfThronesManderly:{7:"40e0d080808000ff00282828015202195953FFFFFF"},GameOfThronesArryn:{7:"007fff7fbfff0019334c4cffffefb2a89797FFFFFF"},Brooklyn99Regular:{10:"e7298a72bcd4e41a1cFCF40E49f149f16913525252F9FEFF000E33000000"},Brooklyn99Dark:{9:"6CA9C33A3533000E33800000CBCFD2175E78DAA520174D79000000"}};for(var e in CanvasXpress.colorSchemes){for(var f in CanvasXpress.colorSchemes[e]){var c=CanvasXpress.colorSchemes[e][f].match(/.{6}/g);CanvasXpress.colorSchemes[e][f]=c?c.map(function(a){return"#"+a}):[]}}var b=["Viridis","Magma","Plasma","Inferno","Cividis"];var b=["Viridis"];for(var d=0;d<b.length;d++){var e=JSON.parse(JSON.stringify(CanvasXpress.colorSchemes[b[d]]));CanvasXpress.colorSchemes[b[d]+"Inv"]={};for(var f in e){CanvasXpress.colorSchemes[b[d]+"Inv"][f]=e[f].reverse()}}}();CanvasXpress.instances=CanvasXpress.instances||[];CanvasXpress.config=CanvasXpress.config||[];CanvasXpress.transitions=CanvasXpress.transitions||{};CanvasXpress.remoteUpdating=CanvasXpress.remoteUpdating||false;CanvasXpress.cacheImages=CanvasXpress.cacheImages||{};CanvasXpress.cacheImagesReady=CanvasXpress.cacheImagesReady||false;CanvasXpress.cachePatterns=CanvasXpress.cachePatterns||{};CanvasXpress.cacheText=CanvasXpress.cacheText||{};CanvasXpress.tabPanels=CanvasXpress.tabPanels||{};CanvasXpress.fonts=CanvasXpress.fonts||{"American Typewriter":true,"Andale Mono":true,Arial:true,Baskerville:true,"Bradley Hand":true,"Brush Script MT":true,"Comic Sans MS":true,Courier:true,Didot:true,Georgia:true,"Gill Sans":true,Helvetica:true,Impact:true,"Lucida Console":true,Luminari:true,Monaco:true,Optima:true,Palatino:true,Roboto:true,Tahoma:true,"Times New Roman":true,"Trebuchet MS":true,Verdana:true};CanvasXpress.selector=CanvasXpress.selector||{vars:{},smps:{},meta:{},comp:{},nodes:{},edges:{},mixed:{},selections:0,groups:{},graphType:false};CanvasXpress.hidden=CanvasXpress.hidden||{hiddenVars:{},hiddenSmps:{},hiddenGrps:{},hiddenMapFeatures:{},hiddenNodes:{},hiddenEdges:{}};CanvasXpress.stack=CanvasXpress.stack||{};CanvasXpress.current=CanvasXpress.current||false;CanvasXpress.chain=CanvasXpress.chain||{};CanvasXpress.resizing=CanvasXpress.resizing||false;CanvasXpress.registered="7A64D88308817131500C253EA";CanvasXpress.system=CanvasXpress.system||{};CanvasXpress.ready=CanvasXpress.ready||false;CanvasXpress.readyFonts=CanvasXpress.readyFonts||false;CanvasXpress.png="data:image/png;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==";CanvasXpress.letters=["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];CanvasXpress.dates={Sun:1,Mon:2,Tue:3,Wed:4,Thu:5,Fri:6,Sat:7,Sunday:1,Monday:2,Tuesday:3,Wednesday:4,Thursday:5,Friday:6,Saturday:7,Jan:"01",Feb:"02",Mar:"03",Apr:"04",May:"05",Jun:"06",Jul:"07",Aug:"08",Sep:"09",Oct:"10",Nov:"11",Dec:"12",January:"01",February:"02",March:"03",April:"04",May:"05",June:"06",July:"07",August:"08",September:"09",October:"10",November:"11",December:"12"};CanvasXpress.countries={ABW:["Aruba","America","Caribbean","AW",12.521,-69.969],AFG:["Afghanistan","Asia","South Asia","AF",33.939,67.709],AGO:["Angola","Africa","Middle Africa","AO",-11.203,17.873],AIA:["Anguilla","America","Caribbean","AI",18.22,-63.069],ALA:["Aland Islands","Europe","North Europe","AX",48.464,-122.706],ALB:["Albania","Europe","South Europe","AL",41.153,20.168],AND:["Andorra","Europe","South Europe","AD",42.546,1.601],ANT:["Netherlands Antilles","","","AN",12.226,-69.061],ARE:["United Arab Emirates","Asia","West Asia","AE",23.424,53.847],ARG:["Argentina","America","South America","AR",-38.417,-63.617],ARM:["Armenia","Asia","West Asia","AM",40.069,45.038],ASM:["American Samoa","Oceania","Polynesia","AS",-14.271,-170.133],ATA:["Antarctica","","","AQ",-75.251,-0.072],ATF:["French Southern Territories","","","TF",-49.28,69.348],ATG:["Antigua and Barbuda","America","Caribbean","AG",17.06,-61.797],AUS:["Australia","Oceania","Australia and New Zealand","AU",-25.275,133.775],AUT:["Austria","Europe","West Europe","AT",47.516,14.55],AZE:["Azerbaijan","Asia","West Asia","AZ",40.143,47.576],BDI:["Burundi","Africa","East Africa","BI",-3.374,29.918],BEL:["Belgium","Europe","West Europe","BE",50.503,4.469],BEN:["Benin","Africa","West Africa","BJ",9.307,2.315],BES:["Bonaire","America","Caribbean","BQ",12.201,-68.262],BFA:["Burkina Faso","Africa","West Africa","BF",12.238,-1.562],BGD:["Bangladesh","Asia","South Asia","BD",23.684,90.356],BGR:["Bulgaria","Europe","East Europe","BG",42.733,25.485],BHR:["Bahrain","Asia","West Asia","BH",25.93,50.637],BHS:["Bahamas","America","Caribbean","BS",25.034,-77.397],BIH:["Bosnia and Herzegovina","Europe","South Europe","BA",43.915,17.679],BLM:["Saint Barthelemy","America","Caribbean","BL",17.899,-62.833],BLR:["Belarus","Europe","East Europe","BY",53.709,27.953],BLZ:["Belize","America","Central America","BZ",17.189,-88.498],BMU:["Bermuda","America","North America","BM",32.321,-64.758],BOL:["Bolivia","America","South America","BO",-16.291,-63.589],BRA:["Brazil","America","South America","BR",-14.236,-51.926],BRB:["Barbados","America","Caribbean","BB",13.193,-59.544],BRN:["Brunei Darussalam","Asia","South-East Asia","BN",4.535,114.727],BTN:["Bhutan","Asia","South Asia","BT",27.514,90.433],BVT:["Bouvet Island","","","BV",-54.424,3.413],BWA:["Botswana","Africa","South Africa","BW",-22.329,24.684],CAF:["Central African Republic","Africa","Middle Africa","CF",6.611,20.939],CAN:["Canada","America","North America","CA",56.13,-106.347],CCK:["Cocos (Keeling) Islands","","","CC",-12.165,96.87],CHE:["Switzerland","Europe","West Europe","CH",46.818,8.227],CHL:["Chile","America","South America","CL",-35.676,-71.543],CHN:["China","Asia","East Asia","CN",35.861,104.195],CIV:["Cote d'Ivoire","Africa","West Africa","CI",7.539,-5.548],CMR:["Cameroon","Africa","Middle Africa","CM",7.369,12.354],COD:["Congo (Democratic Republic of the)","Africa","Middle Africa","CD",-4.039,21.758],COG:["Congo","Africa","Middle Africa","CG",-0.229,15.827],COK:["Cook Islands","Oceania","Polynesia","CK",-21.237,-159.778],COL:["Colombia","America","South America","CO",4.57,-74.298],COM:["Comoros","Africa","East Africa","KM",-11.876,43.872],CPV:["Cabo Verde","Africa","West Africa","CV",16.002,-24.014],CRI:["Costa Rica","America","Central America","CR",9.748,-83.754],CUB:["Cuba","America","Caribbean","CU",21.521,-77.781],CUW:["Curacao","America","Caribbean","CW",12.169,-68.99],CXR:["Christmas Island","","","CX",-10.448,105.69],CYM:["Cayman Islands","America","Caribbean","KY",19.513,-80.567],CYP:["Cyprus","Asia","West Asia","CY",35.126,33.43],CZE:["Czech Republic","Europe","East Europe","CZ",49.817,15.472],DEU:["Germany","Europe","West Europe","DE",51.166,10.451],DJI:["Djibouti","Africa","East Africa","DJ",11.825,42.59],DMA:["Dominica","America","Caribbean","DM",15.414,-61.371],DNK:["Denmark","Europe","North Europe","DK",56.263,9.501],DOM:["Dominican Republic","America","Caribbean","DO",18.735,-70.164],DZA:["Algeria","Africa","North Africa","DZ",28.033,1.659],ECU:["Ecuador","America","South America","EC",-1.832,-78.184],EGY:["Egypt","Africa","North Africa","EG",26.82,30.802],ERI:["Eritrea","Africa","East Africa","ER",15.179,39.782],ESH:["Western Sahara","Africa","North Africa","EH",24.215,-12.885],ESP:["Spain","Europe","South Europe","ES",40.208,-3.752],EST:["Estonia","Europe","North Europe","EE",58.595,25.013],ETH:["Ethiopia","Africa","East Africa","ET",9.145,40.489],FIN:["Finland","Europe","North Europe","FI",61.924,25.748],FJI:["Fiji","Oceania","Melanesia","FJ",-16.579,179.414],FLK:["Falkland Islands","America","South America","FK",-51.797,-59.524],FRA:["France","Europe","West Europe","FR",46.227,2.213],FRO:["Faroe Islands","Europe","North Europe","FO",61.892,-6.912],FSM:["Micronesia (Federated States of)","Oceania","Micronesia","FM",6.887,158.215],GAB:["Gabon","Africa","Middle Africa","GA",-0.804,11.609],GBR:["United Kingdom","Europe","North Europe","GB",55.378,-3.436],GEO:["Georgia","Asia","West Asia","GE",42.315,43.356],GGY:["Guernsey","Europe","North Europe","GG",49.465,-2.586],GHA:["Ghana","Africa","West Africa","GH",7.946,-1.024],GIB:["Gibraltar","Europe","South Europe","GI",36.137,-5.346],GIN:["Guinea","Africa","West Africa","GN",9.945,-9.697],GLP:["Guadeloupe","America","Caribbean","GP",16.995,-62.068],GMB:["Gambia","Africa","West Africa","GM",13.443,-15.311],GNB:["Guinea-Bissau","Africa","West Africa","GW",11.803,-15.181],GNQ:["Equatorial Guinea","Africa","Middle Africa","GQ",1.65,10.267],GRC:["Greece","Europe","South Europe","GR",39.074,21.824],GRD:["Grenada","America","Caribbean","GD",12.262,-61.605],GRE:["Greece","Europe","South Europe","EL",39.074,21.824],GRL:["Greenland","America","North America","GL",71.706,-42.605],GTM:["Guatemala","America","Central America","GT",15.783,-90.231],GUF:["French Guiana","America","South America","GF",3.933,-53.126],GUM:["Guam","Oceania","Micronesia","GU",13.444,144.793],GUY:["Guyana","America","South America","GY",4.86,-58.93],HKG:["Hong Kong","Asia","East Asia","HK",22.396,114.109],HMD:["Heard Island and McDonald Islands","","","HM",-53.081,73.504],HND:["Honduras","America","Central America","HN",14.641,-86.074],HRV:["Croatia","Europe","South Europe","HR",45.1,15.2],HTI:["Haiti","America","Caribbean","HT",18.971,-72.285],HUN:["Hungary","Europe","East Europe","HU",47.162,19.506],IDN:["Indonesia","Asia","South-East Asia","ID",-0.789,113.921],IMN:["Isle of Man","Europe","North Europe","IM",54.236,-4.549],IND:["India","Asia","South Asia","IN",20.593,78.962],IOT:["British Indian Ocean Territory","","","IO",-6.344,71.876],IRL:["Ireland","Europe","North Europe","IE",53.142,-7.692],IRN:["Iran (Islamic Republic of)","Asia","West Asia","IR",32.427,53.688],IRQ:["Iraq","Asia","West Asia","IQ",33.223,43.679],ISL:["Iceland","Europe","North Europe","IS",64.963,-19.02],ISR:["Israel","Asia","West Asia","IL",31.046,34.851],ITA:["Italy","Europe","South Europe","IT",41.871,12.567],JAM:["Jamaica","America","Caribbean","JM",18.109,-77.298],JEY:["Jersey","Europe","North Europe","JE",49.214,-2.132],JOR:["Jordan","Asia","West Asia","JO",30.585,36.238],JPN:["Japan","Asia","East Asia","JP",36.204,138.252],KAZ:["Kazakhstan","Asia","Central Asia","KZ",48.019,66.923],KEN:["Kenya","Africa","East Africa","KE",-0.024,37.906],KGZ:["Kyrgyzstan","Asia","Central Asia","KG",41.204,74.766],KHM:["Cambodia","Asia","South-East Asia","KH",12.565,104.99],KIR:["Kiribati","Oceania","Micronesia","KI",-3.371,-168.735],KNA:["Saint Kitts and Nevis","America","Caribbean","KN",17.357,-62.782],KOR:["Korea (Republic of)","Asia","East Asia","KR",35.907,127.766],KWT:["Kuwait","Asia","West Asia","KW",29.311,47.481],LAO:["Lao People's Democratic Republic","Asia","South-East Asia","LA",19.856,102.495],LBN:["Lebanon","Asia","West Asia","LB",33.854,35.862],LBR:["Liberia","Africa","West Africa","LR",6.428,-9.43],LBY:["Libya","Africa","North Africa","LY",26.335,17.228],LCA:["Saint Lucia","America","Caribbean","LC",13.91,-60.978],LIE:["Liechtenstein","Europe","West Europe","LI",47.166,9.555],LKA:["Sri Lanka","Asia","South Asia","LK",7.612,80.705],LSO:["Lesotho","Africa","South Africa","LS",-29.61,28.233],LTU:["Lithuania","Europe","North Europe","LT",55.169,23.881],LUX:["Luxembourg","Europe","West Europe","LU",49.815,6.129],LVA:["Latvia","Europe","North Europe","LV",56.879,24.603],MAC:["Macao","Asia","East Asia","MO",22.198,113.543],MAF:["Saint Martin (French part)","America","Caribbean","MF",18.088,-63.052],MAR:["Morocco","Africa","North Africa","MA",31.791,-7.093],MCO:["Monaco","Europe","West Europe","MC",43.75,7.412],MDA:["Moldova (Republic of)","Europe","East Europe","MD",47.411,28.369],MDG:["Madagascar","Africa","East Africa","MG",-18.767,46.869],MDV:["Maldives","Asia","South Asia","MV",3.202,73.22],MEX:["Mexico","America","Central America","MX",23.634,-102.553],MHL:["Marshall Islands","Oceania","Micronesia","MH",7.131,171.184],MKD:["Macedonia (the former Yugoslav Republic of)","Europe","South Europe","MK",41.608,21.745],MLI:["Mali","Africa","West Africa","ML",17.57,-3.997],MLT:["Malta","Europe","South Europe","MT",35.937,14.375],MMR:["Myanmar","Asia","South-East Asia","MM",21.913,95.956],MNE:["Montenegro","Europe","South Europe","ME",42.708,19.374],MNG:["Mongolia","Asia","East Asia","MN",46.862,103.846],MNP:["Northern Mariana Islands","Oceania","Micronesia","MP",17.33,145.384],MOZ:["Mozambique","Africa","East Africa","MZ",-18.666,35.529],MRT:["Mauritania","Africa","West Africa","MR",21.007,-10.941],MSR:["Montserrat","America","Caribbean","MS",16.742,-62.188],MTQ:["Martinique","America","Caribbean","MQ",14.641,-61.025],MUS:["Mauritius","Africa","East Africa","MU",-20.349,57.552],MWI:["Malawi","Africa","East Africa","MW",-13.255,34.301],MYS:["Malaysia","Asia","South-East Asia","MY",4.21,101.975],MYT:["Mayotte","Africa","East Africa","YT",-12.828,45.166],NAM:["Namibia","Africa","South Africa","NA",-22.958,18.49],NCL:["New Caledonia","Oceania","Melanesia","NC",-20.905,165.618],NER:["Niger","Africa","West Africa","NE",17.607,8.081],NFK:["Norfolk Island","Oceania","Australia and New Zealand","NF",-29.041,167.954],NGA:["Nigeria","Africa","West Africa","NG",9.081,8.675],NIC:["Nicaragua","America","Central America","NI",12.865,-85.208],NIU:["Niue","Oceania","Polynesia","NU",-19.055,-169.868],NLD:["Netherlands","Europe","West Europe","NL",52.132,5.291],NOR:["Norway","Europe","North Europe","NO",60.472,8.468],NPL:["Nepal","Asia","South Asia","NP",28.394,84.124],NRU:["Nauru","Oceania","Micronesia","NR",-0.523,166.931],NZL:["New Zealand","Oceania","Australia and New Zealand","NZ",-40.901,174.885],OMN:["Oman","Asia","West Asia","OM",21.512,55.923],PAK:["Pakistan","Asia","South Asia","PK",30.375,69.345],PAN:["Panama","America","Central America","PA",8.537,-80.783],PCN:["Pitcairn","Oceania","Polynesia","PN",-24.704,-127.44],PER:["Peru","America","South America","PE",-9.19,-75.016],PHL:["Philippines","Asia","South-East Asia","PH",12.879,121.774],PLW:["Palau","Oceania","Micronesia","PW",7.514,134.582],PNG:["Papua New Guinea","Oceania","Melanesia","PG",-6.315,143.955],POL:["Poland","Europe","East Europe","PL",51.919,19.145],PRI:["Puerto Rico","America","Caribbean","PR",18.22,-66.591],PRK:["Korea (Democratic People's Republic of)","Asia","East Asia","KP",40.339,127.51],PRT:["Portugal","Europe","South Europe","PT",39.399,-8.225],PRY:["Paraguay","America","South America","PY",-23.443,-58.444],PSE:["Palestine","Asia","West Asia","PS",31.952,35.233],PYF:["French Polynesia","Oceania","Polynesia","PF",-17.68,-149.407],QAT:["Qatar","Asia","West Asia","QA",25.354,51.183],REU:["Reunion","Africa","East Africa","RE",-21.116,55.536],ROU:["Romania","Europe","East Europe","RO",45.943,24.966],RUS:["Russian Federation","Europe","East Europe","RU",61.524,105.318],RWA:["Rwanda","Africa","East Africa","RW",-1.941,29.873],SAU:["Saudi Arabia","Asia","West Asia","SA",23.885,45.079],SDN:["Sudan","Africa","North Africa","SD",12.862,30.218],SEN:["Senegal","Africa","West Africa","SN",14.497,-14.453],SGP:["Singapore","Asia","South-East Asia","SG",1.352,103.819],SGS:["South Georgia and the South Sandwich Islands","","","GS",-54.429,-36.587],SHN:["Saint Helena, Ascension and Tristan da Cunha","Africa","West Africa","SH",-24.144,-10.031],SJM:["Svalbard and Jan Mayen","Europe","North Europe","SJ",77.553,23.67],SLB:["Solomon Islands","Oceania","Melanesia","SB",-9.646,160.156],SLE:["Sierra Leone","Africa","West Africa","SL",8.46,-11.78],SLV:["El Salvador","America","Central America","SV",13.794,-88.897],SMR:["San Marino","Europe","South Europe","SM",43.942,12.457],SOM:["Somalia","Africa","East Africa","SO",5.152,46.199],SPM:["Saint Pierre and Miquelon","America","North America","PM",46.941,-56.272],SRB:["Serbia","Europe","South Europe","RS",44.016,21.005],SSD:["South Sudan","Africa","East Africa","SS",4.859,31.571],STP:["Sao Tome and Principe","Africa","Middle Africa","ST",0.186,6.613],SUR:["Suriname","America","South America","SR",3.919,-56.028],SVK:["Slovakia","Europe","East Europe","SK",48.669,19.699],SVN:["Slovenia","Europe","South Europe","SI",46.151,14.995],SWE:["Sweden","Europe","North Europe","SE",60.128,18.643],SWZ:["Swaziland","Africa","South Africa","SZ",-26.523,31.465],SXM:["Sint Maarten (Dutch part)","America","Caribbean","SX",18.042,-63.054],SYC:["Seychelles","Africa","East Africa","SC",-4.68,55.491],SYR:["Syrian Arab Republic","Asia","West Asia","SY",34.802,38.996],TCA:["Turks and Caicos Islands","America","Caribbean","TC",21.694,-71.798],TCD:["Chad","Africa","Middle Africa","TD",15.454,18.732],TGO:["Togo","Africa","West Africa","TG",8.619,0.824],THA:["Thailand","Asia","South-East Asia","TH",15.87,100.992],TJK:["Tajikistan","Asia","Central Asia","TJ",38.861,71.276],TKL:["Tokelau","Oceania","Polynesia","TK",-8.968,-171.856],TKM:["Turkmenistan","Asia","Central Asia","TM",38.969,59.556],TLS:["Timor-Leste","Asia","South-East Asia","TL",-8.875,125.727],TON:["Tonga","Oceania","Polynesia","TO",-21.179,-175.199],TTO:["Trinidad and Tobago","America","Caribbean","TT",10.691,-61.223],TUN:["Tunisia","Africa","North Africa","TN",33.886,9.537],TUR:["Turkey","Asia","West Asia","TR",38.963,35.243],TUV:["Tuvalu","Oceania","Polynesia","TV",-7.11,177.649],TWN:["Taiwan","Asia","East Asia","TW",23.697,120.96],TZA:["Tanzania","Africa","East Africa","TZ",-6.37,34.888],UGA:["Uganda","Africa","East Africa","UG",1.373,32.29],UKM:["United Kingdom of Great Britain and Northern Ireland","Europe","North Europe","UK",55.378,-3.436],UKR:["Ukraine","Europe","East Europe","UA",48.379,31.165],UMI:["United States Minor Outlying Islands","","","UM",-0.374,-159.996],URY:["Uruguay","America","South America","UY",-32.523,-55.766],USA:["United States of America","America","North America","US",37.09,-95.713],UZB:["Uzbekistan","Asia","Central Asia","UZ",41.377,64.585],VAT:["Holy See","Europe","South Europe","VA",41.902,12.453],VCT:["Saint Vincent and the Grenadines","America","Caribbean","VC",12.984,-61.288],VEN:["Venezuela","America","South America","VE",6.423,-66.59],VGB:["Virgin Islands (British)","America","Caribbean","VG",18.42,-64.64],VIR:["Virgin Islands (U.S.)","America","Caribbean","VI",18.335,-64.897],VNM:["Vietnam","Asia","South-East Asia","VN",14.058,108.277],VUT:["Vanuatu","Oceania","Melanesia","VU",-15.377,166.959],WLF:["Wallis and Futuna","Oceania","Polynesia","WF",-13.768,-177.156],WSM:["Samoa","Oceania","Polynesia","WS",-13.759,-172.105],XKX:["Kosovo","Europe","South Europe","XK",42.602,20.902],XXX:["Unespecified Nationality","","","XX",],YEM:["Yemen","Asia","West Asia","YE",15.552,48.516],ZAF:["South Africa","Africa","South Africa","ZA",-30.56,22.937],ZMB:["Zambia","Africa","East Africa","ZM",-13.134,27.849],ZWE:["Zimbabwe","Africa","East Africa","ZW",-19.016,29.154]};CanvasXpress.usa={AK:["Alaska",63.588753,-154.493062],AL:["Alabama",32.318231,-86.902298],AR:["Arkansas",35.20105,-91.831833],AZ:["Arizona",34.048928,-111.093731],CA:["California",36.778261,-119.417932],CO:["Colorado",39.550051,-105.782067],CT:["Connecticut",41.603221,-73.087749],DC:["District of Columbia",38.905985,-77.033418],DE:["Delaware",38.910832,-75.52767],FL:["Florida",27.664827,-81.515754],GA:["Georgia",32.157435,-82.907123],HI:["Hawaii",19.898682,-155.665857],IA:["Iowa",41.878003,-93.097702],ID:["Idaho",44.068202,-114.742041],IL:["Illinois",40.633125,-89.398528],IN:["Indiana",40.551217,-85.602364],KS:["Kansas",39.011902,-98.484246],KY:["Kentucky",37.839333,-84.270018],LA:["Louisiana",31.244823,-92.145024],MA:["Massachusetts",42.407211,-71.382437],MD:["Maryland",39.045755,-76.641271],ME:["Maine",45.253783,-69.445469],MI:["Michigan",44.314844,-85.602364],MN:["Minnesota",46.729553,-94.6859],MO:["Missouri",37.964253,-91.831833],MS:["Mississippi",32.354668,-89.398528],MT:["Montana",46.879682,-110.362566],NC:["North Carolina",35.759573,-79.0193],ND:["NorthDakota",47.551493,-101.002012],NE:["Nebraska",41.492537,-99.901813],NH:["New Hampshire",43.193852,-71.572395],NJ:["New Jersey",40.058324,-74.405661],NM:["New Mexico",34.97273,-105.032363],NV:["Nevada",38.80261,-116.419389],NY:["New York",43.299428,-74.217933],OH:["Ohio",40.417287,-82.907123],OK:["Oklahoma",35.007752,-97.092877],OR:["Oregon",43.804133,-120.554201],PA:["Pennsylvania",41.203322,-77.194525],PR:["Puerto Rico",18.220833,-66.590149],RI:["Rhode Island",41.580095,-71.477429],SC:["South Carolina",33.836081,-81.163725],SD:["South Dakota",43.969515,-99.901813],TN:["Tennessee",35.517491,-86.580447],TX:["Texas",31.968599,-99.901813],UT:["Utah",39.32098,-111.093731],VA:["Virginia",37.431573,-78.656894],VT:["Vermont",44.558803,-72.577841],WA:["Washington",47.751074,-120.740139],WI:["Wisconsin",43.78444,-88.787868],WV:["West Virginia",38.597626,-80.454903],WY:["Wyoming",43.075968,-107.290284]};CanvasXpress.maps={Africa:"/data/africa.geo.json",Asia:"/data/asia.geo.json",Countries:"/data/countries.geo.json",Europe:"/data/europe.geo.json",NorthAmerica:"/data/north-america.geo.json",Oceania:"/data/oceania.geo.json",SouthAmerica:"/data/south-america.geo.json",USACounties:"/data/usa-counties.json",USADistricts:"/data/usa-districts.json",USAStates:"/data/usa-states.json",WorldContinents:"/data/world-continents-geo.json",World:"/data/world.geo.json"};CanvasXpress.geojson={type:"FeatureCollection",features:[{type:"Feature",properties:{name:"Dummy"},geometry:{type:"Polygon",coordinates:[[[-180,-90],[180,-90],[180,90],[-180,90],[-180,-90]]]}}]};CanvasXpress.chromosomes={hg19:{columns:["start","end","name","stain"],order:[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,"X","Y"],data:{1:[[0,2300000,"p36.33","gneg"],[2300000,5400000,"p36.32","gpos25"],[5400000,7200000,"p36.31","gneg"],[7200000,9200000,"p36.23","gpos25"],[9200000,12700000,"p36.22","gneg"],[12700000,16200000,"p36.21","gpos50"],[16200000,20400000,"p36.13","gneg"],[20400000,23900000,"p36.12","gpos25"],[23900000,28000000,"p36.11","gneg"],[28000000,30200000,"p35.3","gpos25"],[30200000,32400000,"p35.2","gneg"],[32400000,34600000,"p35.1","gpos25"],[34600000,40100000,"p34.3","gneg"],[40100000,44100000,"p34.2","gpos25"],[44100000,46800000,"p34.1","gneg"],[46800000,50700000,"p33","gpos75"],[50700000,56100000,"p32.3","gneg"],[56100000,59000000,"p32.2","gpos50"],[59000000,61300000,"p32.1","gneg"],[61300000,68900000,"p31.3","gpos50"],[68900000,69700000,"p31.2","gneg"],[69700000,84900000,"p31.1","gpos100"],[84900000,88400000,"p22.3","gneg"],[88400000,92000000,"p22.2","gpos75"],[92000000,94700000,"p22.1","gneg"],[94700000,99700000,"p21.3","gpos75"],[99700000,102200000,"p21.2","gneg"],[102200000,107200000,"p21.1","gpos100"],[107200000,111800000,"p13.3","gneg"],[111800000,116100000,"p13.2","gpos50"],[116100000,117800000,"p13.1","gneg"],[117800000,120600000,"p12","gpos50"],[120600000,121500000,"p11.2","gneg"],[121500000,125000000,"p11.1","acen"],[125000000,128900000,"q11","acen"],[128900000,142600000,"q12","gvar"],[142600000,147000000,"q21.1","gneg"],[147000000,150300000,"q21.2","gpos50"],[150300000,155000000,"q21.3","gneg"],[155000000,156500000,"q22","gpos50"],[156500000,159100000,"q23.1","gneg"],[159100000,160500000,"q23.2","gpos50"],[160500000,165500000,"q23.3","gneg"],[165500000,167200000,"q24.1","gpos50"],[167200000,170900000,"q24.2","gneg"],[170900000,172900000,"q24.3","gpos75"],[172900000,176000000,"q25.1","gneg"],[176000000,180300000,"q25.2","gpos50"],[180300000,185800000,"q25.3","gneg"],[185800000,190800000,"q31.1","gpos100"],[190800000,193800000,"q31.2","gneg"],[193800000,198700000,"q31.3","gpos100"],[198700000,207200000,"q32.1","gneg"],[207200000,211500000,"q32.2","gpos25"],[211500000,214500000,"q32.3","gneg"],[214500000,224100000,"q41","gpos100"],[224100000,224600000,"q42.11","gneg"],[224600000,227000000,"q42.12","gpos25"],[227000000,230700000,"q42.13","gneg"],[230700000,234700000,"q42.2","gpos50"],[234700000,236600000,"q42.3","gneg"],[236600000,243700000,"q43","gpos75"],[243700000,249250621,"q44","gneg"]],2:[[0,4400000,"p25.3","gneg"],[4400000,7100000,"p25.2","gpos50"],[7100000,12200000,"p25.1","gneg"],[12200000,16700000,"p24.3","gpos75"],[16700000,19200000,"p24.2","gneg"],[19200000,24000000,"p24.1","gpos75"],[24000000,27900000,"p23.3","gneg"],[27900000,30000000,"p23.2","gpos25"],[30000000,32100000,"p23.1","gneg"],[32100000,36600000,"p22.3","gpos75"],[36600000,38600000,"p22.2","gneg"],[38600000,41800000,"p22.1","gpos50"],[41800000,47800000,"p21","gneg"],[47800000,52900000,"p16.3","gpos100"],[52900000,55000000,"p16.2","gneg"],[55000000,61300000,"p16.1","gpos100"],[61300000,64100000,"p15","gneg"],[64100000,68600000,"p14","gpos50"],[68600000,71500000,"p13.3","gneg"],[71500000,73500000,"p13.2","gpos50"],[73500000,75000000,"p13.1","gneg"],[75000000,83300000,"p12","gpos100"],[83300000,90500000,"p11.2","gneg"],[90500000,93300000,"p11.1","acen"],[93300000,96800000,"q11.1","acen"],[96800000,102700000,"q11.2","gneg"],[102700000,106000000,"q12.1","gpos50"],[106000000,107500000,"q12.2","gneg"],[107500000,110200000,"q12.3","gpos25"],[110200000,114400000,"q13","gneg"],[114400000,118800000,"q14.1","gpos50"],[118800000,122400000,"q14.2","gneg"],[122400000,129900000,"q14.3","gpos50"],[129900000,132500000,"q21.1","gneg"],[132500000,135100000,"q21.2","gpos25"],[135100000,136800000,"q21.3","gneg"],[136800000,142200000,"q22.1","gpos100"],[142200000,144100000,"q22.2","gneg"],[144100000,148700000,"q22.3","gpos100"],[148700000,149900000,"q23.1","gneg"],[149900000,150500000,"q23.2","gpos25"],[150500000,154900000,"q23.3","gneg"],[154900000,159800000,"q24.1","gpos75"],[159800000,163700000,"q24.2","gneg"],[163700000,169700000,"q24.3","gpos75"],[169700000,178000000,"q31.1","gneg"],[178000000,180600000,"q31.2","gpos50"],[180600000,183000000,"q31.3","gneg"],[183000000,189400000,"q32.1","gpos75"],[189400000,191900000,"q32.2","gneg"],[191900000,197400000,"q32.3","gpos75"],[197400000,203300000,"q33.1","gneg"],[203300000,204900000,"q33.2","gpos50"],[204900000,209000000,"q33.3","gneg"],[209000000,215300000,"q34","gpos100"],[215300000,221500000,"q35","gneg"],[221500000,225200000,"q36.1","gpos75"],[225200000,226100000,"q36.2","gneg"],[226100000,231000000,"q36.3","gpos100"],[231000000,235600000,"q37.1","gneg"],[235600000,237300000,"q37.2","gpos50"],[237300000,243199373,"q37.3","gneg"]],3:[[0,2800000,"p26.3","gpos50"],[2800000,4000000,"p26.2","gneg"],[4000000,8700000,"p26.1","gpos50"],[8700000,11800000,"p25.3","gneg"],[11800000,13300000,"p25.2","gpos25"],[13300000,16400000,"p25.1","gneg"],[16400000,23900000,"p24.3","gpos100"],[23900000,26400000,"p24.2","gneg"],[26400000,30900000,"p24.1","gpos75"],[30900000,32100000,"p23","gneg"],[32100000,36500000,"p22.3","gpos50"],[36500000,39400000,"p22.2","gneg"],[39400000,43700000,"p22.1","gpos75"],[43700000,44100000,"p21.33","gneg"],[44100000,44200000,"p21.32","gpos50"],[44200000,50600000,"p21.31","gneg"],[50600000,52300000,"p21.2","gpos25"],[52300000,54400000,"p21.1","gneg"],[54400000,58600000,"p14.3","gpos50"],[58600000,63700000,"p14.2","gneg"],[63700000,69800000,"p14.1","gpos50"],[69800000,74200000,"p13","gneg"],[74200000,79800000,"p12.3","gpos75"],[79800000,83500000,"p12.2","gneg"],[83500000,87200000,"p12.1","gpos75"],[87200000,87900000,"p11.2","gneg"],[87900000,91000000,"p11.1","acen"],[91000000,93900000,"q11.1","acen"],[93900000,98300000,"q11.2","gvar"],[98300000,100000000,"q12.1","gneg"],[100000000,100900000,"q12.2","gpos25"],[100900000,102800000,"q12.3","gneg"],[102800000,106200000,"q13.11","gpos75"],[106200000,107900000,"q13.12","gneg"],[107900000,111300000,"q13.13","gpos50"],[111300000,113500000,"q13.2","gneg"],[113500000,117300000,"q13.31","gpos75"],[117300000,119000000,"q13.32","gneg"],[119000000,121900000,"q13.33","gpos75"],[121900000,123800000,"q21.1","gneg"],[123800000,125800000,"q21.2","gpos25"],[125800000,129200000,"q21.3","gneg"],[129200000,133700000,"q22.1","gpos25"],[133700000,135700000,"q22.2","gneg"],[135700000,138700000,"q22.3","gpos25"],[138700000,142800000,"q23","gneg"],[142800000,148900000,"q24","gpos100"],[148900000,152100000,"q25.1","gneg"],[152100000,155000000,"q25.2","gpos50"],[155000000,157000000,"q25.31","gneg"],[157000000,159000000,"q25.32","gpos50"],[159000000,160700000,"q25.33","gneg"],[160700000,167600000,"q26.1","gpos100"],[167600000,170900000,"q26.2","gneg"],[170900000,175700000,"q26.31","gpos75"],[175700000,179000000,"q26.32","gneg"],[179000000,182700000,"q26.33","gpos75"],[182700000,184500000,"q27.1","gneg"],[184500000,186000000,"q27.2","gpos25"],[186000000,187900000,"q27.3","gneg"],[187900000,192300000,"q28","gpos75"],[192300000,198022430,"q29","gneg"]],4:[[0,4500000,"p16.3","gneg"],[4500000,6000000,"p16.2","gpos25"],[6000000,11300000,"p16.1","gneg"],[11300000,15200000,"p15.33","gpos50"],[15200000,17800000,"p15.32","gneg"],[17800000,21300000,"p15.31","gpos75"],[21300000,27700000,"p15.2","gneg"],[27700000,35800000,"p15.1","gpos100"],[35800000,41200000,"p14","gneg"],[41200000,44600000,"p13","gpos50"],[44600000,48200000,"p12","gneg"],[48200000,50400000,"p11","acen"],[50400000,52700000,"q11","acen"],[52700000,59500000,"q12","gneg"],[59500000,66600000,"q13.1","gpos100"],[66600000,70500000,"q13.2","gneg"],[70500000,76300000,"q13.3","gpos75"],[76300000,78900000,"q21.1","gneg"],[78900000,82400000,"q21.21","gpos50"],[82400000,84100000,"q21.22","gneg"],[84100000,86900000,"q21.23","gpos25"],[86900000,88000000,"q21.3","gneg"],[88000000,93700000,"q22.1","gpos75"],[93700000,95100000,"q22.2","gneg"],[95100000,98800000,"q22.3","gpos75"],[98800000,101100000,"q23","gneg"],[101100000,107700000,"q24","gpos50"],[107700000,114100000,"q25","gneg"],[114100000,120800000,"q26","gpos75"],[120800000,123800000,"q27","gneg"],[123800000,128800000,"q28.1","gpos50"],[128800000,131100000,"q28.2","gneg"],[131100000,139500000,"q28.3","gpos100"],[139500000,141500000,"q31.1","gneg"],[141500000,146800000,"q31.21","gpos25"],[146800000,148500000,"q31.22","gneg"],[148500000,151100000,"q31.23","gpos25"],[151100000,155600000,"q31.3","gneg"],[155600000,161800000,"q32.1","gpos100"],[161800000,164500000,"q32.2","gneg"],[164500000,170100000,"q32.3","gpos100"],[170100000,171900000,"q33","gneg"],[171900000,176300000,"q34.1","gpos75"],[176300000,177500000,"q34.2","gneg"],[177500000,183200000,"q34.3","gpos100"],[183200000,187100000,"q35.1","gneg"],[187100000,191154276,"q35.2","gpos25"]],5:[[0,4500000,"p15.33","gneg"],[4500000,6300000,"p15.32","gpos25"],[6300000,9800000,"p15.31","gneg"],[9800000,15000000,"p15.2","gpos50"],[15000000,18400000,"p15.1","gneg"],[18400000,23300000,"p14.3","gpos100"],[23300000,24600000,"p14.2","gneg"],[24600000,28900000,"p14.1","gpos100"],[28900000,33800000,"p13.3","gneg"],[33800000,38400000,"p13.2","gpos25"],[38400000,42500000,"p13.1","gneg"],[42500000,46100000,"p12","gpos50"],[46100000,48400000,"p11","acen"],[48400000,50700000,"q11.1","acen"],[50700000,58900000,"q11.2","gneg"],[58900000,62900000,"q12.1","gpos75"],[62900000,63200000,"q12.2","gneg"],[63200000,66700000,"q12.3","gpos75"],[66700000,68400000,"q13.1","gneg"],[68400000,73300000,"q13.2","gpos50"],[73300000,76900000,"q13.3","gneg"],[76900000,81400000,"q14.1","gpos50"],[81400000,82800000,"q14.2","gneg"],[82800000,92300000,"q14.3","gpos100"],[92300000,98200000,"q15","gneg"],[98200000,102800000,"q21.1","gpos100"],[102800000,104500000,"q21.2","gneg"],[104500000,109600000,"q21.3","gpos100"],[109600000,111500000,"q22.1","gneg"],[111500000,113100000,"q22.2","gpos50"],[113100000,115200000,"q22.3","gneg"],[115200000,121400000,"q23.1","gpos100"],[121400000,127300000,"q23.2","gneg"],[127300000,130600000,"q23.3","gpos100"],[130600000,136200000,"q31.1","gneg"],[136200000,139500000,"q31.2","gpos25"],[139500000,144500000,"q31.3","gneg"],[144500000,149800000,"q32","gpos75"],[149800000,152700000,"q33.1","gneg"],[152700000,155700000,"q33.2","gpos50"],[155700000,159900000,"q33.3","gneg"],[159900000,168500000,"q34","gpos100"],[168500000,172800000,"q35.1","gneg"],[172800000,176600000,"q35.2","gpos25"],[176600000,180915260,"q35.3","gneg"]],6:[[0,2300000,"p25.3","gneg"],[2300000,4200000,"p25.2","gpos25"],[4200000,7100000,"p25.1","gneg"],[7100000,10600000,"p24.3","gpos50"],[10600000,11600000,"p24.2","gneg"],[11600000,13400000,"p24.1","gpos25"],[13400000,15200000,"p23","gneg"],[15200000,25200000,"p22.3","gpos75"],[25200000,27000000,"p22.2","gneg"],[27000000,30400000,"p22.1","gpos50"],[30400000,32100000,"p21.33","gneg"],[32100000,33500000,"p21.32","gpos25"],[33500000,36600000,"p21.31","gneg"],[36600000,40500000,"p21.2","gpos25"],[40500000,46200000,"p21.1","gneg"],[46200000,51800000,"p12.3","gpos100"],[51800000,52900000,"p12.2","gneg"],[52900000,57000000,"p12.1","gpos100"],[57000000,58700000,"p11.2","gneg"],[58700000,61000000,"p11.1","acen"],[61000000,63300000,"q11.1","acen"],[63300000,63400000,"q11.2","gneg"],[63400000,70000000,"q12","gpos100"],[70000000,75900000,"q13","gneg"],[75900000,83900000,"q14.1","gpos50"],[83900000,84900000,"q14.2","gneg"],[84900000,88000000,"q14.3","gpos50"],[88000000,93100000,"q15","gneg"],[93100000,99500000,"q16.1","gpos100"],[99500000,100600000,"q16.2","gneg"],[100600000,105500000,"q16.3","gpos100"],[105500000,114600000,"q21","gneg"],[114600000,118300000,"q22.1","gpos75"],[118300000,118500000,"q22.2","gneg"],[118500000,126100000,"q22.31","gpos100"],[126100000,127100000,"q22.32","gneg"],[127100000,130300000,"q22.33","gpos75"],[130300000,131200000,"q23.1","gneg"],[131200000,135200000,"q23.2","gpos50"],[135200000,139000000,"q23.3","gneg"],[139000000,142800000,"q24.1","gpos75"],[142800000,145600000,"q24.2","gneg"],[145600000,149000000,"q24.3","gpos75"],[149000000,152500000,"q25.1","gneg"],[152500000,155500000,"q25.2","gpos50"],[155500000,161000000,"q25.3","gneg"],[161000000,164500000,"q26","gpos50"],[164500000,171115067,"q27","gneg"]],7:[[0,2800000,"p22.3","gneg"],[2800000,4500000,"p22.2","gpos25"],[4500000,7300000,"p22.1","gneg"],[7300000,13800000,"p21.3","gpos100"],[13800000,16500000,"p21.2","gneg"],[16500000,20900000,"p21.1","gpos100"],[20900000,25500000,"p15.3","gneg"],[25500000,28000000,"p15.2","gpos50"],[28000000,28800000,"p15.1","gneg"],[28800000,35000000,"p14.3","gpos75"],[35000000,37200000,"p14.2","gneg"],[37200000,43300000,"p14.1","gpos75"],[43300000,45400000,"p13","gneg"],[45400000,49000000,"p12.3","gpos75"],[49000000,50500000,"p12.2","gneg"],[50500000,54000000,"p12.1","gpos75"],[54000000,58000000,"p11.2","gneg"],[58000000,59900000,"p11.1","acen"],[59900000,61700000,"q11.1","acen"],[61700000,67000000,"q11.21","gneg"],[67000000,72200000,"q11.22","gpos50"],[72200000,77500000,"q11.23","gneg"],[77500000,86400000,"q21.11","gpos100"],[86400000,88200000,"q21.12","gneg"],[88200000,91100000,"q21.13","gpos75"],[91100000,92800000,"q21.2","gneg"],[92800000,98000000,"q21.3","gpos75"],[98000000,103800000,"q22.1","gneg"],[103800000,104500000,"q22.2","gpos50"],[104500000,107400000,"q22.3","gneg"],[107400000,114600000,"q31.1","gpos75"],[114600000,117400000,"q31.2","gneg"],[117400000,121100000,"q31.31","gpos75"],[121100000,123800000,"q31.32","gneg"],[123800000,127100000,"q31.33","gpos75"],[127100000,129200000,"q32.1","gneg"],[129200000,130400000,"q32.2","gpos25"],[130400000,132600000,"q32.3","gneg"],[132600000,138200000,"q33","gpos50"],[138200000,143100000,"q34","gneg"],[143100000,147900000,"q35","gpos75"],[147900000,152600000,"q36.1","gneg"],[152600000,155100000,"q36.2","gpos25"],[155100000,159138663,"q36.3","gneg"]],8:[[0,2200000,"p23.3","gneg"],[2200000,6200000,"p23.2","gpos75"],[6200000,12700000,"p23.1","gneg"],[12700000,19000000,"p22","gpos100"],[19000000,23300000,"p21.3","gneg"],[23300000,27400000,"p21.2","gpos50"],[27400000,28800000,"p21.1","gneg"],[28800000,36500000,"p12","gpos75"],[36500000,38300000,"p11.23","gneg"],[38300000,39700000,"p11.22","gpos25"],[39700000,43100000,"p11.21","gneg"],[43100000,45600000,"p11.1","acen"],[45600000,48100000,"q11.1","acen"],[48100000,52200000,"q11.21","gneg"],[52200000,52600000,"q11.22","gpos75"],[52600000,55500000,"q11.23","gneg"],[55500000,61600000,"q12.1","gpos50"],[61600000,62200000,"q12.2","gneg"],[62200000,66000000,"q12.3","gpos50"],[66000000,68000000,"q13.1","gneg"],[68000000,70500000,"q13.2","gpos50"],[70500000,73900000,"q13.3","gneg"],[73900000,78300000,"q21.11","gpos100"],[78300000,80100000,"q21.12","gneg"],[80100000,84600000,"q21.13","gpos75"],[84600000,86900000,"q21.2","gneg"],[86900000,93300000,"q21.3","gpos100"],[93300000,99000000,"q22.1","gneg"],[99000000,101600000,"q22.2","gpos25"],[101600000,106200000,"q22.3","gneg"],[106200000,110500000,"q23.1","gpos75"],[110500000,112100000,"q23.2","gneg"],[112100000,117700000,"q23.3","gpos100"],[117700000,119200000,"q24.11","gneg"],[119200000,122500000,"q24.12","gpos50"],[122500000,127300000,"q24.13","gneg"],[127300000,131500000,"q24.21","gpos50"],[131500000,136400000,"q24.22","gneg"],[136400000,139900000,"q24.23","gpos75"],[139900000,146364022,"q24.3","gneg"]],9:[[0,2200000,"p24.3","gneg"],[2200000,4600000,"p24.2","gpos25"],[4600000,9000000,"p24.1","gneg"],[9000000,14200000,"p23","gpos75"],[14200000,16600000,"p22.3","gneg"],[16600000,18500000,"p22.2","gpos25"],[18500000,19900000,"p22.1","gneg"],[19900000,25600000,"p21.3","gpos100"],[25600000,28000000,"p21.2","gneg"],[28000000,33200000,"p21.1","gpos100"],[33200000,36300000,"p13.3","gneg"],[36300000,38400000,"p13.2","gpos25"],[38400000,41000000,"p13.1","gneg"],[41000000,43600000,"p12","gpos50"],[43600000,47300000,"p11.2","gneg"],[47300000,49000000,"p11.1","acen"],[49000000,50700000,"q11","acen"],[50700000,65900000,"q12","gvar"],[65900000,68700000,"q13","gneg"],[68700000,72200000,"q21.11","gpos25"],[72200000,74000000,"q21.12","gneg"],[74000000,79200000,"q21.13","gpos50"],[79200000,81100000,"q21.2","gneg"],[81100000,84100000,"q21.31","gpos50"],[84100000,86900000,"q21.32","gneg"],[86900000,90400000,"q21.33","gpos50"],[90400000,91800000,"q22.1","gneg"],[91800000,93900000,"q22.2","gpos25"],[93900000,96600000,"q22.31","gneg"],[96600000,99300000,"q22.32","gpos25"],[99300000,102600000,"q22.33","gneg"],[102600000,108200000,"q31.1","gpos100"],[108200000,111300000,"q31.2","gneg"],[111300000,114900000,"q31.3","gpos25"],[114900000,117700000,"q32","gneg"],[117700000,122500000,"q33.1","gpos75"],[122500000,125800000,"q33.2","gneg"],[125800000,130300000,"q33.3","gpos25"],[130300000,133500000,"q34.11","gneg"],[133500000,134000000,"q34.12","gpos25"],[134000000,135900000,"q34.13","gneg"],[135900000,137400000,"q34.2","gpos25"],[137400000,141213431,"q34.3","gneg"]],10:[[0,3000000,"p15.3","gneg"],[3000000,3800000,"p15.2","gpos25"],[3800000,6600000,"p15.1","gneg"],[6600000,12200000,"p14","gpos75"],[12200000,17300000,"p13","gneg"],[17300000,18600000,"p12.33","gpos75"],[18600000,18700000,"p12.32","gneg"],[18700000,22600000,"p12.31","gpos75"],[22600000,24600000,"p12.2","gneg"],[24600000,29600000,"p12.1","gpos50"],[29600000,31300000,"p11.23","gneg"],[31300000,34400000,"p11.22","gpos25"],[34400000,38000000,"p11.21","gneg"],[38000000,40200000,"p11.1","acen"],[40200000,42300000,"q11.1","acen"],[42300000,46100000,"q11.21","gneg"],[46100000,49900000,"q11.22","gpos25"],[49900000,52900000,"q11.23","gneg"],[52900000,61200000,"q21.1","gpos100"],[61200000,64500000,"q21.2","gneg"],[64500000,70600000,"q21.3","gpos100"],[70600000,74900000,"q22.1","gneg"],[74900000,77700000,"q22.2","gpos50"],[77700000,82000000,"q22.3","gneg"],[82000000,87900000,"q23.1","gpos100"],[87900000,89500000,"q23.2","gneg"],[89500000,92900000,"q23.31","gpos75"],[92900000,94100000,"q23.32","gneg"],[94100000,97000000,"q23.33","gpos50"],[97000000,99300000,"q24.1","gneg"],[99300000,101900000,"q24.2","gpos50"],[101900000,103000000,"q24.31","gneg"],[103000000,104900000,"q24.32","gpos25"],[104900000,105800000,"q24.33","gneg"],[105800000,111900000,"q25.1","gpos100"],[111900000,114900000,"q25.2","gneg"],[114900000,119100000,"q25.3","gpos75"],[119100000,121700000,"q26.11","gneg"],[121700000,123100000,"q26.12","gpos50"],[123100000,127500000,"q26.13","gneg"],[127500000,130600000,"q26.2","gpos50"],[130600000,135534747,"q26.3","gneg"]],11:[[0,2800000,"p15.5","gneg"],[2800000,10700000,"p15.4","gpos50"],[10700000,12700000,"p15.3","gneg"],[12700000,16200000,"p15.2","gpos50"],[16200000,21700000,"p15.1","gneg"],[21700000,26100000,"p14.3","gpos100"],[26100000,27200000,"p14.2","gneg"],[27200000,31000000,"p14.1","gpos75"],[31000000,36400000,"p13","gneg"],[36400000,43500000,"p12","gpos100"],[43500000,48800000,"p11.2","gneg"],[48800000,51600000,"p11.12","gpos75"],[51600000,53700000,"p11.11","acen"],[53700000,55700000,"q11","acen"],[55700000,59900000,"q12.1","gpos75"],[59900000,61700000,"q12.2","gneg"],[61700000,63400000,"q12.3","gpos25"],[63400000,65900000,"q13.1","gneg"],[65900000,68400000,"q13.2","gpos25"],[68400000,70400000,"q13.3","gneg"],[70400000,75200000,"q13.4","gpos50"],[75200000,77100000,"q13.5","gneg"],[77100000,85600000,"q14.1","gpos100"],[85600000,88300000,"q14.2","gneg"],[88300000,92800000,"q14.3","gpos100"],[92800000,97200000,"q21","gneg"],[97200000,102100000,"q22.1","gpos100"],[102100000,102900000,"q22.2","gneg"],[102900000,110400000,"q22.3","gpos100"],[110400000,112500000,"q23.1","gneg"],[112500000,114500000,"q23.2","gpos50"],[114500000,121200000,"q23.3","gneg"],[121200000,123900000,"q24.1","gpos50"],[123900000,127800000,"q24.2","gneg"],[127800000,130800000,"q24.3","gpos50"],[130800000,135006516,"q25","gneg"]],12:[[0,3300000,"p13.33","gneg"],[3300000,5400000,"p13.32","gpos25"],[5400000,10100000,"p13.31","gneg"],[10100000,12800000,"p13.2","gpos75"],[12800000,14800000,"p13.1","gneg"],[14800000,20000000,"p12.3","gpos100"],[20000000,21300000,"p12.2","gneg"],[21300000,26500000,"p12.1","gpos100"],[26500000,27800000,"p11.23","gneg"],[27800000,30700000,"p11.22","gpos50"],[30700000,33300000,"p11.21","gneg"],[33300000,35800000,"p11.1","acen"],[35800000,38200000,"q11","acen"],[38200000,46400000,"q12","gpos100"],[46400000,49100000,"q13.11","gneg"],[49100000,51500000,"q13.12","gpos25"],[51500000,54900000,"q13.13","gneg"],[54900000,56600000,"q13.2","gpos25"],[56600000,58100000,"q13.3","gneg"],[58100000,63100000,"q14.1","gpos75"],[63100000,65100000,"q14.2","gneg"],[65100000,67700000,"q14.3","gpos50"],[67700000,71500000,"q15","gneg"],[71500000,75700000,"q21.1","gpos75"],[75700000,80300000,"q21.2","gneg"],[80300000,86700000,"q21.31","gpos100"],[86700000,89000000,"q21.32","gneg"],[89000000,92600000,"q21.33","gpos100"],[92600000,96200000,"q22","gneg"],[96200000,101600000,"q23.1","gpos75"],[101600000,103800000,"q23.2","gneg"],[103800000,109000000,"q23.3","gpos50"],[109000000,111700000,"q24.11","gneg"],[111700000,112300000,"q24.12","gpos25"],[112300000,114300000,"q24.13","gneg"],[114300000,116800000,"q24.21","gpos50"],[116800000,118100000,"q24.22","gneg"],[118100000,120700000,"q24.23","gpos50"],[120700000,125900000,"q24.31","gneg"],[125900000,129300000,"q24.32","gpos50"],[129300000,133851895,"q24.33","gneg"]],13:[[0,4500000,"p13","gvar"],[4500000,10000000,"p12","stalk"],[10000000,16300000,"p11.2","gvar"],[16300000,17900000,"p11.1","acen"],[17900000,19500000,"q11","acen"],[19500000,23300000,"q12.11","gneg"],[23300000,25500000,"q12.12","gpos25"],[25500000,27800000,"q12.13","gneg"],[27800000,28900000,"q12.2","gpos25"],[28900000,32200000,"q12.3","gneg"],[32200000,34000000,"q13.1","gpos50"],[34000000,35500000,"q13.2","gneg"],[35500000,40100000,"q13.3","gpos75"],[40100000,45200000,"q14.11","gneg"],[45200000,45800000,"q14.12","gpos25"],[45800000,47300000,"q14.13","gneg"],[47300000,50900000,"q14.2","gpos50"],[50900000,55300000,"q14.3","gneg"],[55300000,59600000,"q21.1","gpos100"],[59600000,62300000,"q21.2","gneg"],[62300000,65700000,"q21.31","gpos75"],[65700000,68600000,"q21.32","gneg"],[68600000,73300000,"q21.33","gpos100"],[73300000,75400000,"q22.1","gneg"],[75400000,77200000,"q22.2","gpos50"],[77200000,79000000,"q22.3","gneg"],[79000000,87700000,"q31.1","gpos100"],[87700000,90000000,"q31.2","gneg"],[90000000,95000000,"q31.3","gpos100"],[95000000,98200000,"q32.1","gneg"],[98200000,99300000,"q32.2","gpos25"],[99300000,101700000,"q32.3","gneg"],[101700000,104800000,"q33.1","gpos100"],[104800000,107000000,"q33.2","gneg"],[107000000,110300000,"q33.3","gpos100"],[110300000,115169878,"q34","gneg"]],14:[[0,3700000,"p13","gvar"],[3700000,8100000,"p12","stalk"],[8100000,16100000,"p11.2","gvar"],[16100000,17600000,"p11.1","acen"],[17600000,19100000,"q11.1","acen"],[19100000,24600000,"q11.2","gneg"],[24600000,33300000,"q12","gpos100"],[33300000,35300000,"q13.1","gneg"],[35300000,36600000,"q13.2","gpos50"],[36600000,37800000,"q13.3","gneg"],[37800000,43500000,"q21.1","gpos100"],[43500000,47200000,"q21.2","gneg"],[47200000,50900000,"q21.3","gpos100"],[50900000,54100000,"q22.1","gneg"],[54100000,55500000,"q22.2","gpos25"],[55500000,58100000,"q22.3","gneg"],[58100000,62100000,"q23.1","gpos75"],[62100000,64800000,"q23.2","gneg"],[64800000,67900000,"q23.3","gpos50"],[67900000,70200000,"q24.1","gneg"],[70200000,73800000,"q24.2","gpos50"],[73800000,79300000,"q24.3","gneg"],[79300000,83600000,"q31.1","gpos100"],[83600000,84900000,"q31.2","gneg"],[84900000,89800000,"q31.3","gpos100"],[89800000,91900000,"q32.11","gneg"],[91900000,94700000,"q32.12","gpos25"],[94700000,96300000,"q32.13","gneg"],[96300000,101400000,"q32.2","gpos50"],[101400000,103200000,"q32.31","gneg"],[103200000,104000000,"q32.32","gpos50"],[104000000,107349540,"q32.33","gneg"]],15:[[0,3900000,"p13","gvar"],[3900000,8700000,"p12","stalk"],[8700000,15800000,"p11.2","gvar"],[15800000,19000000,"p11.1","acen"],[19000000,20700000,"q11.1","acen"],[20700000,25700000,"q11.2","gneg"],[25700000,28100000,"q12","gpos50"],[28100000,30300000,"q13.1","gneg"],[30300000,31200000,"q13.2","gpos50"],[31200000,33600000,"q13.3","gneg"],[33600000,40100000,"q14","gpos75"],[40100000,42800000,"q15.1","gneg"],[42800000,43600000,"q15.2","gpos25"],[43600000,44800000,"q15.3","gneg"],[44800000,49500000,"q21.1","gpos75"],[49500000,52900000,"q21.2","gneg"],[52900000,59100000,"q21.3","gpos75"],[59100000,59300000,"q22.1","gneg"],[59300000,63700000,"q22.2","gpos25"],[63700000,67200000,"q22.31","gneg"],[67200000,67300000,"q22.32","gpos25"],[67300000,67500000,"q22.33","gneg"],[67500000,72700000,"q23","gpos25"],[72700000,75200000,"q24.1","gneg"],[75200000,76600000,"q24.2","gpos25"],[76600000,78300000,"q24.3","gneg"],[78300000,81700000,"q25.1","gpos50"],[81700000,85200000,"q25.2","gneg"],[85200000,89100000,"q25.3","gpos50"],[89100000,94300000,"q26.1","gneg"],[94300000,98500000,"q26.2","gpos50"],[98500000,102531392,"q26.3","gneg"]],16:[[0,7900000,"p13.3","gneg"],[7900000,10500000,"p13.2","gpos50"],[10500000,12600000,"p13.13","gneg"],[12600000,14800000,"p13.12","gpos50"],[14800000,16800000,"p13.11","gneg"],[16800000,21200000,"p12.3","gpos50"],[21200000,24200000,"p12.2","gneg"],[24200000,28100000,"p12.1","gpos50"],[28100000,34600000,"p11.2","gneg"],[34600000,36600000,"p11.1","acen"],[36600000,38600000,"q11.1","acen"],[38600000,47000000,"q11.2","gvar"],[47000000,52600000,"q12.1","gneg"],[52600000,56700000,"q12.2","gpos50"],[56700000,57400000,"q13","gneg"],[57400000,66700000,"q21","gpos100"],[66700000,70800000,"q22.1","gneg"],[70800000,72900000,"q22.2","gpos50"],[72900000,74100000,"q22.3","gneg"],[74100000,79200000,"q23.1","gpos75"],[79200000,81700000,"q23.2","gneg"],[81700000,84200000,"q23.3","gpos50"],[84200000,87100000,"q24.1","gneg"],[87100000,88700000,"q24.2","gpos25"],[88700000,90354753,"q24.3","gneg"]],17:[[0,3300000,"p13.3","gneg"],[3300000,6500000,"p13.2","gpos50"],[6500000,10700000,"p13.1","gneg"],[10700000,16000000,"p12","gpos75"],[16000000,22200000,"p11.2","gneg"],[22200000,24000000,"p11.1","acen"],[24000000,25800000,"q11.1","acen"],[25800000,31800000,"q11.2","gneg"],[31800000,38100000,"q12","gpos50"],[38100000,38400000,"q21.1","gneg"],[38400000,40900000,"q21.2","gpos25"],[40900000,44900000,"q21.31","gneg"],[44900000,47400000,"q21.32","gpos25"],[47400000,50200000,"q21.33","gneg"],[50200000,57600000,"q22","gpos75"],[57600000,58300000,"q23.1","gneg"],[58300000,61100000,"q23.2","gpos75"],[61100000,62600000,"q23.3","gneg"],[62600000,64200000,"q24.1","gpos50"],[64200000,67100000,"q24.2","gneg"],[67100000,70900000,"q24.3","gpos75"],[70900000,74800000,"q25.1","gneg"],[74800000,75300000,"q25.2","gpos25"],[75300000,81195210,"q25.3","gneg"]],18:[[0,2900000,"p11.32","gneg"],[2900000,7100000,"p11.31","gpos50"],[7100000,8500000,"p11.23","gneg"],[8500000,10900000,"p11.22","gpos25"],[10900000,15400000,"p11.21","gneg"],[15400000,17200000,"p11.1","acen"],[17200000,19000000,"q11.1","acen"],[19000000,25000000,"q11.2","gneg"],[25000000,32700000,"q12.1","gpos100"],[32700000,37200000,"q12.2","gneg"],[37200000,43500000,"q12.3","gpos75"],[43500000,48200000,"q21.1","gneg"],[48200000,53800000,"q21.2","gpos75"],[53800000,56200000,"q21.31","gneg"],[56200000,59000000,"q21.32","gpos50"],[59000000,61600000,"q21.33","gneg"],[61600000,66800000,"q22.1","gpos100"],[66800000,68700000,"q22.2","gneg"],[68700000,73100000,"q22.3","gpos25"],[73100000,78077248,"q23","gneg"]],19:[[0,6900000,"p13.3","gneg"],[6900000,13900000,"p13.2","gpos25"],[13900000,14000000,"p13.13","gneg"],[14000000,16300000,"p13.12","gpos25"],[16300000,20000000,"p13.11","gneg"],[20000000,24400000,"p12","gvar"],[24400000,26500000,"p11","acen"],[26500000,28600000,"q11","acen"],[28600000,32400000,"q12","gvar"],[32400000,35500000,"q13.11","gneg"],[35500000,38300000,"q13.12","gpos25"],[38300000,38700000,"q13.13","gneg"],[38700000,43400000,"q13.2","gpos25"],[43400000,45200000,"q13.31","gneg"],[45200000,48000000,"q13.32","gpos25"],[48000000,51400000,"q13.33","gneg"],[51400000,53600000,"q13.41","gpos25"],[53600000,56300000,"q13.42","gneg"],[56300000,59128983,"q13.43","gpos25"]],20:[[0,5100000,"p13","gneg"],[5100000,9200000,"p12.3","gpos75"],[9200000,12100000,"p12.2","gneg"],[12100000,17900000,"p12.1","gpos75"],[17900000,21300000,"p11.23","gneg"],[21300000,22300000,"p11.22","gpos25"],[22300000,25600000,"p11.21","gneg"],[25600000,27500000,"p11.1","acen"],[27500000,29400000,"q11.1","acen"],[29400000,32100000,"q11.21","gneg"],[32100000,34400000,"q11.22","gpos25"],[34400000,37600000,"q11.23","gneg"],[37600000,41700000,"q12","gpos75"],[41700000,42100000,"q13.11","gneg"],[42100000,46400000,"q13.12","gpos25"],[46400000,49800000,"q13.13","gneg"],[49800000,55000000,"q13.2","gpos75"],[55000000,56500000,"q13.31","gneg"],[56500000,58400000,"q13.32","gpos50"],[58400000,63025520,"q13.33","gneg"]],21:[[0,2800000,"p13","gvar"],[2800000,6800000,"p12","stalk"],[6800000,10900000,"p11.2","gvar"],[10900000,13200000,"p11.1","acen"],[13200000,14300000,"q11.1","acen"],[14300000,16400000,"q11.2","gneg"],[16400000,24000000,"q21.1","gpos100"],[24000000,26800000,"q21.2","gneg"],[26800000,31500000,"q21.3","gpos75"],[31500000,35800000,"q22.11","gneg"],[35800000,37800000,"q22.12","gpos50"],[37800000,39700000,"q22.13","gneg"],[39700000,42600000,"q22.2","gpos50"],[42600000,48129895,"q22.3","gneg"]],22:[[0,3800000,"p13","gvar"],[3800000,8300000,"p12","stalk"],[8300000,12200000,"p11.2","gvar"],[12200000,14700000,"p11.1","acen"],[14700000,17900000,"q11.1","acen"],[17900000,22200000,"q11.21","gneg"],[22200000,23500000,"q11.22","gpos25"],[23500000,25900000,"q11.23","gneg"],[25900000,29600000,"q12.1","gpos50"],[29600000,32200000,"q12.2","gneg"],[32200000,37600000,"q12.3","gpos50"],[37600000,41000000,"q13.1","gneg"],[41000000,44200000,"q13.2","gpos50"],[44200000,48400000,"q13.31","gneg"],[48400000,49400000,"q13.32","gpos50"],[49400000,51304566,"q13.33","gneg"]],X:[[0,4300000,"p22.33","gneg"],[4300000,6000000,"p22.32","gpos50"],[6000000,9500000,"p22.31","gneg"],[9500000,17100000,"p22.2","gpos50"],[17100000,19300000,"p22.13","gneg"],[19300000,21900000,"p22.12","gpos50"],[21900000,24900000,"p22.11","gneg"],[24900000,29300000,"p21.3","gpos100"],[29300000,31500000,"p21.2","gneg"],[31500000,37600000,"p21.1","gpos100"],[37600000,42400000,"p11.4","gneg"],[42400000,46400000,"p11.3","gpos75"],[46400000,49800000,"p11.23","gneg"],[49800000,54800000,"p11.22","gpos25"],[54800000,58100000,"p11.21","gneg"],[58100000,60600000,"p11.1","acen"],[60600000,63000000,"q11.1","acen"],[63000000,64600000,"q11.2","gneg"],[64600000,67800000,"q12","gpos50"],[67800000,71800000,"q13.1","gneg"],[71800000,73900000,"q13.2","gpos50"],[73900000,76000000,"q13.3","gneg"],[76000000,84600000,"q21.1","gpos100"],[84600000,86200000,"q21.2","gneg"],[86200000,91800000,"q21.31","gpos100"],[91800000,93500000,"q21.32","gneg"],[93500000,98300000,"q21.33","gpos75"],[98300000,102600000,"q22.1","gneg"],[102600000,103700000,"q22.2","gpos50"],[103700000,108700000,"q22.3","gneg"],[108700000,116500000,"q23","gpos75"],[116500000,120900000,"q24","gneg"],[120900000,128700000,"q25","gpos100"],[128700000,130400000,"q26.1","gneg"],[130400000,133600000,"q26.2","gpos25"],[133600000,138000000,"q26.3","gneg"],[138000000,140300000,"q27.1","gpos75"],[140300000,142100000,"q27.2","gneg"],[142100000,147100000,"q27.3","gpos100"],[147100000,155270560,"q28","gneg"]],Y:[[0,2500000,"p11.32","gneg"],[2500000,3000000,"p11.31","gpos50"],[3000000,11600000,"p11.2","gneg"],[11600000,12500000,"p11.1","acen"],[12500000,13400000,"q11.1","acen"],[13400000,15100000,"q11.21","gneg"],[15100000,19800000,"q11.221","gpos50"],[19800000,22100000,"q11.222","gneg"],[22100000,26200000,"q11.223","gpos50"],[26200000,28800000,"q11.23","gneg"],[28800000,59373566,"q12","gvar"]]}},hg38:{columns:["start","end","name","stain"],order:[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,"X","Y"],data:{1:[[0,2300000,"p36.33","gneg"],[2300000,5300000,"p36.32","gpos25"],[5300000,7100000,"p36.31","gneg"],[7100000,9100000,"p36.23","gpos25"],[9100000,12500000,"p36.22","gneg"],[12500000,15900000,"p36.21","gpos50"],[15900000,20100000,"p36.13","gneg"],[20100000,23600000,"p36.12","gpos25"],[23600000,27600000,"p36.11","gneg"],[27600000,29900000,"p35.3","gpos25"],[29900000,32300000,"p35.2","gneg"],[32300000,34300000,"p35.1","gpos25"],[34300000,39600000,"p34.3","gneg"],[39600000,43700000,"p34.2","gpos25"],[43700000,46300000,"p34.1","gneg"],[46300000,50200000,"p33","gpos75"],[50200000,55600000,"p32.3","gneg"],[55600000,58500000,"p32.2","gpos50"],[58500000,60800000,"p32.1","gneg"],[60800000,68500000,"p31.3","gpos50"],[68500000,69300000,"p31.2","gneg"],[69300000,84400000,"p31.1","gpos100"],[84400000,87900000,"p22.3","gneg"],[87900000,91500000,"p22.2","gpos75"],[91500000,94300000,"p22.1","gneg"],[94300000,99300000,"p21.3","gpos75"],[99300000,101800000,"p21.2","gneg"],[101800000,106700000,"p21.1","gpos100"],[106700000,111200000,"p13.3","gneg"],[111200000,115500000,"p13.2","gpos50"],[115500000,117200000,"p13.1","gneg"],[117200000,120400000,"p12","gpos50"],[120400000,121700000,"p11.2","gneg"],[121700000,123400000,"p11.1","acen"],[123400000,125100000,"q11","acen"],[125100000,143200000,"q12","gvar"],[143200000,147500000,"q21.1","gneg"],[147500000,150600000,"q21.2","gpos50"],[150600000,155100000,"q21.3","gneg"],[155100000,156600000,"q22","gpos50"],[156600000,159100000,"q23.1","gneg"],[159100000,160500000,"q23.2","gpos50"],[160500000,165500000,"q23.3","gneg"],[165500000,167200000,"q24.1","gpos50"],[167200000,170900000,"q24.2","gneg"],[170900000,173000000,"q24.3","gpos75"],[173000000,176100000,"q25.1","gneg"],[176100000,180300000,"q25.2","gpos50"],[180300000,185800000,"q25.3","gneg"],[185800000,190800000,"q31.1","gpos100"],[190800000,193800000,"q31.2","gneg"],[193800000,198700000,"q31.3","gpos100"],[198700000,207100000,"q32.1","gneg"],[207100000,211300000,"q32.2","gpos25"],[211300000,214400000,"q32.3","gneg"],[214400000,223900000,"q41","gpos100"],[223900000,224400000,"q42.11","gneg"],[224400000,226800000,"q42.12","gpos25"],[226800000,230500000,"q42.13","gneg"],[230500000,234600000,"q42.2","gpos50"],[234600000,236400000,"q42.3","gneg"],[236400000,243500000,"q43","gpos75"],[243500000,248956422,"q44","gneg"]],2:[[0,4400000,"p25.3","gneg"],[4400000,6900000,"p25.2","gpos50"],[6900000,12000000,"p25.1","gneg"],[12000000,16500000,"p24.3","gpos75"],[16500000,19000000,"p24.2","gneg"],[19000000,23800000,"p24.1","gpos75"],[23800000,27700000,"p23.3","gneg"],[27700000,29800000,"p23.2","gpos25"],[29800000,31800000,"p23.1","gneg"],[31800000,36300000,"p22.3","gpos75"],[36300000,38300000,"p22.2","gneg"],[38300000,41500000,"p22.1","gpos50"],[41500000,47500000,"p21","gneg"],[47500000,52600000,"p16.3","gpos100"],[52600000,54700000,"p16.2","gneg"],[54700000,61000000,"p16.1","gpos100"],[61000000,63900000,"p15","gneg"],[63900000,68400000,"p14","gpos50"],[68400000,71300000,"p13.3","gneg"],[71300000,73300000,"p13.2","gpos50"],[73300000,74800000,"p13.1","gneg"],[74800000,83100000,"p12","gpos100"],[83100000,91800000,"p11.2","gneg"],[91800000,93900000,"p11.1","acen"],[93900000,96000000,"q11.1","acen"],[96000000,102100000,"q11.2","gneg"],[102100000,105300000,"q12.1","gpos50"],[105300000,106700000,"q12.2","gneg"],[106700000,108700000,"q12.3","gpos25"],[108700000,112200000,"q13","gneg"],[112200000,118100000,"q14.1","gpos50"],[118100000,121600000,"q14.2","gneg"],[121600000,129100000,"q14.3","gpos50"],[129100000,131700000,"q21.1","gneg"],[131700000,134300000,"q21.2","gpos25"],[134300000,136100000,"q21.3","gneg"],[136100000,141500000,"q22.1","gpos100"],[141500000,143400000,"q22.2","gneg"],[143400000,147900000,"q22.3","gpos100"],[147900000,149000000,"q23.1","gneg"],[149000000,149600000,"q23.2","gpos25"],[149600000,154000000,"q23.3","gneg"],[154000000,158900000,"q24.1","gpos75"],[158900000,162900000,"q24.2","gneg"],[162900000,168900000,"q24.3","gpos75"],[168900000,177100000,"q31.1","gneg"],[177100000,179700000,"q31.2","gpos50"],[179700000,182100000,"q31.3","gneg"],[182100000,188500000,"q32.1","gpos75"],[188500000,191100000,"q32.2","gneg"],[191100000,196600000,"q32.3","gpos75"],[196600000,202500000,"q33.1","gneg"],[202500000,204100000,"q33.2","gpos50"],[204100000,208200000,"q33.3","gneg"],[208200000,214500000,"q34","gpos100"],[214500000,220700000,"q35","gneg"],[220700000,224300000,"q36.1","gpos75"],[224300000,225200000,"q36.2","gneg"],[225200000,230100000,"q36.3","gpos100"],[230100000,234700000,"q37.1","gneg"],[234700000,236400000,"q37.2","gpos50"],[236400000,242193529,"q37.3","gneg"]],3:[[0,2800000,"p26.3","gpos50"],[2800000,4000000,"p26.2","gneg"],[4000000,8100000,"p26.1","gpos50"],[8100000,11600000,"p25.3","gneg"],[11600000,13200000,"p25.2","gpos25"],[13200000,16300000,"p25.1","gneg"],[16300000,23800000,"p24.3","gpos100"],[23800000,26300000,"p24.2","gneg"],[26300000,30800000,"p24.1","gpos75"],[30800000,32000000,"p23","gneg"],[32000000,36400000,"p22.3","gpos50"],[36400000,39300000,"p22.2","gneg"],[39300000,43600000,"p22.1","gpos75"],[43600000,44100000,"p21.33","gneg"],[44100000,44200000,"p21.32","gpos50"],[44200000,50600000,"p21.31","gneg"],[50600000,52300000,"p21.2","gpos25"],[52300000,54400000,"p21.1","gneg"],[54400000,58600000,"p14.3","gpos50"],[58600000,63800000,"p14.2","gneg"],[63800000,69700000,"p14.1","gpos50"],[69700000,74100000,"p13","gneg"],[74100000,79800000,"p12.3","gpos75"],[79800000,83500000,"p12.2","gneg"],[83500000,87100000,"p12.1","gpos75"],[87100000,87800000,"p11.2","gneg"],[87800000,90900000,"p11.1","acen"],[90900000,94000000,"q11.1","acen"],[94000000,98600000,"q11.2","gvar"],[98600000,100300000,"q12.1","gneg"],[100300000,101200000,"q12.2","gpos25"],[101200000,103100000,"q12.3","gneg"],[103100000,106500000,"q13.11","gpos75"],[106500000,108200000,"q13.12","gneg"],[108200000,111600000,"q13.13","gpos50"],[111600000,113700000,"q13.2","gneg"],[113700000,117600000,"q13.31","gpos75"],[117600000,119300000,"q13.32","gneg"],[119300000,122200000,"q13.33","gpos75"],[122200000,124100000,"q21.1","gneg"],[124100000,126100000,"q21.2","gpos25"],[126100000,129500000,"q21.3","gneg"],[129500000,134000000,"q22.1","gpos25"],[134000000,136000000,"q22.2","gneg"],[136000000,139000000,"q22.3","gpos25"],[139000000,143100000,"q23","gneg"],[143100000,149200000,"q24","gpos100"],[149200000,152300000,"q25.1","gneg"],[152300000,155300000,"q25.2","gpos50"],[155300000,157300000,"q25.31","gneg"],[157300000,159300000,"q25.32","gpos50"],[159300000,161000000,"q25.33","gneg"],[161000000,167900000,"q26.1","gpos100"],[167900000,171200000,"q26.2","gneg"],[171200000,176000000,"q26.31","gpos75"],[176000000,179300000,"q26.32","gneg"],[179300000,183000000,"q26.33","gpos75"],[183000000,184800000,"q27.1","gneg"],[184800000,186300000,"q27.2","gpos25"],[186300000,188200000,"q27.3","gneg"],[188200000,192600000,"q28","gpos75"],[192600000,198295559,"q29","gneg"]],4:[[0,4500000,"p16.3","gneg"],[4500000,6000000,"p16.2","gpos25"],[6000000,11300000,"p16.1","gneg"],[11300000,15000000,"p15.33","gpos50"],[15000000,17700000,"p15.32","gneg"],[17700000,21300000,"p15.31","gpos75"],[21300000,27700000,"p15.2","gneg"],[27700000,35800000,"p15.1","gpos100"],[35800000,41200000,"p14","gneg"],[41200000,44600000,"p13","gpos50"],[44600000,48200000,"p12","gneg"],[48200000,50000000,"p11","acen"],[50000000,51800000,"q11","acen"],[51800000,58500000,"q12","gneg"],[58500000,65500000,"q13.1","gpos100"],[65500000,69400000,"q13.2","gneg"],[69400000,75300000,"q13.3","gpos75"],[75300000,78000000,"q21.1","gneg"],[78000000,81500000,"q21.21","gpos50"],[81500000,83200000,"q21.22","gneg"],[83200000,86000000,"q21.23","gpos25"],[86000000,87100000,"q21.3","gneg"],[87100000,92800000,"q22.1","gpos75"],[92800000,94200000,"q22.2","gneg"],[94200000,97900000,"q22.3","gpos75"],[97900000,100100000,"q23","gneg"],[100100000,106700000,"q24","gpos50"],[106700000,113200000,"q25","gneg"],[113200000,119900000,"q26","gpos75"],[119900000,122800000,"q27","gneg"],[122800000,127900000,"q28.1","gpos50"],[127900000,130100000,"q28.2","gneg"],[130100000,138500000,"q28.3","gpos100"],[138500000,140600000,"q31.1","gneg"],[140600000,145900000,"q31.21","gpos25"],[145900000,147500000,"q31.22","gneg"],[147500000,150200000,"q31.23","gpos25"],[150200000,154600000,"q31.3","gneg"],[154600000,160800000,"q32.1","gpos100"],[160800000,163600000,"q32.2","gneg"],[163600000,169200000,"q32.3","gpos100"],[169200000,171000000,"q33","gneg"],[171000000,175400000,"q34.1","gpos75"],[175400000,176600000,"q34.2","gneg"],[176600000,182300000,"q34.3","gpos100"],[182300000,186200000,"q35.1","gneg"],[186200000,190214555,"q35.2","gpos25"]],5:[[0,4400000,"p15.33","gneg"],[4400000,6300000,"p15.32","gpos25"],[6300000,9900000,"p15.31","gneg"],[9900000,15000000,"p15.2","gpos50"],[15000000,18400000,"p15.1","gneg"],[18400000,23300000,"p14.3","gpos100"],[23300000,24600000,"p14.2","gneg"],[24600000,28900000,"p14.1","gpos100"],[28900000,33800000,"p13.3","gneg"],[33800000,38400000,"p13.2","gpos25"],[38400000,42500000,"p13.1","gneg"],[42500000,46100000,"p12","gpos50"],[46100000,48800000,"p11","acen"],[48800000,51400000,"q11.1","acen"],[51400000,59600000,"q11.2","gneg"],[59600000,63600000,"q12.1","gpos75"],[63600000,63900000,"q12.2","gneg"],[63900000,67400000,"q12.3","gpos75"],[67400000,69100000,"q13.1","gneg"],[69100000,74000000,"q13.2","gpos50"],[74000000,77600000,"q13.3","gneg"],[77600000,82100000,"q14.1","gpos50"],[82100000,83500000,"q14.2","gneg"],[83500000,93000000,"q14.3","gpos100"],[93000000,98900000,"q15","gneg"],[98900000,103400000,"q21.1","gpos100"],[103400000,105100000,"q21.2","gneg"],[105100000,110200000,"q21.3","gpos100"],[110200000,112200000,"q22.1","gneg"],[112200000,113800000,"q22.2","gpos50"],[113800000,115900000,"q22.3","gneg"],[115900000,122100000,"q23.1","gpos100"],[122100000,127900000,"q23.2","gneg"],[127900000,131200000,"q23.3","gpos100"],[131200000,136900000,"q31.1","gneg"],[136900000,140100000,"q31.2","gpos25"],[140100000,145100000,"q31.3","gneg"],[145100000,150400000,"q32","gpos75"],[150400000,153300000,"q33.1","gneg"],[153300000,156300000,"q33.2","gpos50"],[156300000,160500000,"q33.3","gneg"],[160500000,169000000,"q34","gpos100"],[169000000,173300000,"q35.1","gneg"],[173300000,177100000,"q35.2","gpos25"],[177100000,181538259,"q35.3","gneg"]],6:[[0,2300000,"p25.3","gneg"],[2300000,4200000,"p25.2","gpos25"],[4200000,7100000,"p25.1","gneg"],[7100000,10600000,"p24.3","gpos50"],[10600000,11600000,"p24.2","gneg"],[11600000,13400000,"p24.1","gpos25"],[13400000,15200000,"p23","gneg"],[15200000,25200000,"p22.3","gpos75"],[25200000,27100000,"p22.2","gneg"],[27100000,30500000,"p22.1","gpos50"],[30500000,32100000,"p21.33","gneg"],[32100000,33500000,"p21.32","gpos25"],[33500000,36600000,"p21.31","gneg"],[36600000,40500000,"p21.2","gpos25"],[40500000,46200000,"p21.1","gneg"],[46200000,51800000,"p12.3","gpos100"],[51800000,53000000,"p12.2","gneg"],[53000000,57200000,"p12.1","gpos100"],[57200000,58500000,"p11.2","gneg"],[58500000,59800000,"p11.1","acen"],[59800000,62600000,"q11.1","acen"],[62600000,62700000,"q11.2","gneg"],[62700000,69200000,"q12","gpos100"],[69200000,75200000,"q13","gneg"],[75200000,83200000,"q14.1","gpos50"],[83200000,84200000,"q14.2","gneg"],[84200000,87300000,"q14.3","gpos50"],[87300000,92500000,"q15","gneg"],[92500000,98900000,"q16.1","gpos100"],[98900000,100000000,"q16.2","gneg"],[100000000,105000000,"q16.3","gpos100"],[105000000,114200000,"q21","gneg"],[114200000,117900000,"q22.1","gpos75"],[117900000,118100000,"q22.2","gneg"],[118100000,125800000,"q22.31","gpos100"],[125800000,126800000,"q22.32","gneg"],[126800000,130000000,"q22.33","gpos75"],[130000000,130900000,"q23.1","gneg"],[130900000,134700000,"q23.2","gpos50"],[134700000,138300000,"q23.3","gneg"],[138300000,142200000,"q24.1","gpos75"],[142200000,145100000,"q24.2","gneg"],[145100000,148500000,"q24.3","gpos75"],[148500000,152100000,"q25.1","gneg"],[152100000,155200000,"q25.2","gpos50"],[155200000,160600000,"q25.3","gneg"],[160600000,164100000,"q26","gpos50"],[164100000,170805979,"q27","gneg"]],7:[[0,2800000,"p22.3","gneg"],[2800000,4500000,"p22.2","gpos25"],[4500000,7200000,"p22.1","gneg"],[7200000,13700000,"p21.3","gpos100"],[13700000,16500000,"p21.2","gneg"],[16500000,20900000,"p21.1","gpos100"],[20900000,25500000,"p15.3","gneg"],[25500000,27900000,"p15.2","gpos50"],[27900000,28800000,"p15.1","gneg"],[28800000,34900000,"p14.3","gpos75"],[34900000,37100000,"p14.2","gneg"],[37100000,43300000,"p14.1","gpos75"],[43300000,45400000,"p13","gneg"],[45400000,49000000,"p12.3","gpos75"],[49000000,50500000,"p12.2","gneg"],[50500000,53900000,"p12.1","gpos75"],[53900000,58100000,"p11.2","gneg"],[58100000,60100000,"p11.1","acen"],[60100000,62100000,"q11.1","acen"],[62100000,67500000,"q11.21","gneg"],[67500000,72700000,"q11.22","gpos50"],[72700000,77900000,"q11.23","gneg"],[77900000,86700000,"q21.11","gpos100"],[86700000,88500000,"q21.12","gneg"],[88500000,91500000,"q21.13","gpos75"],[91500000,93300000,"q21.2","gneg"],[93300000,98400000,"q21.3","gpos75"],[98400000,104200000,"q22.1","gneg"],[104200000,104900000,"q22.2","gpos50"],[104900000,107800000,"q22.3","gneg"],[107800000,115000000,"q31.1","gpos75"],[115000000,117700000,"q31.2","gneg"],[117700000,121400000,"q31.31","gpos75"],[121400000,124100000,"q31.32","gneg"],[124100000,127500000,"q31.33","gpos75"],[127500000,129600000,"q32.1","gneg"],[129600000,130800000,"q32.2","gpos25"],[130800000,132900000,"q32.3","gneg"],[132900000,138500000,"q33","gpos50"],[138500000,143400000,"q34","gneg"],[143400000,148200000,"q35","gpos75"],[148200000,152800000,"q36.1","gneg"],[152800000,155200000,"q36.2","gpos25"],[155200000,159345973,"q36.3","gneg"]],8:[[0,2300000,"p23.3","gneg"],[2300000,6300000,"p23.2","gpos75"],[6300000,12800000,"p23.1","gneg"],[12800000,19200000,"p22","gpos100"],[19200000,23500000,"p21.3","gneg"],[23500000,27500000,"p21.2","gpos50"],[27500000,29000000,"p21.1","gneg"],[29000000,36700000,"p12","gpos75"],[36700000,38500000,"p11.23","gneg"],[38500000,39900000,"p11.22","gpos25"],[39900000,43200000,"p11.21","gneg"],[43200000,45200000,"p11.1","acen"],[45200000,47200000,"q11.1","acen"],[47200000,51300000,"q11.21","gneg"],[51300000,51700000,"q11.22","gpos75"],[51700000,54600000,"q11.23","gneg"],[54600000,60600000,"q12.1","gpos50"],[60600000,61300000,"q12.2","gneg"],[61300000,65100000,"q12.3","gpos50"],[65100000,67100000,"q13.1","gneg"],[67100000,69600000,"q13.2","gpos50"],[69600000,72000000,"q13.3","gneg"],[72000000,74600000,"q21.11","gpos100"],[74600000,74700000,"q21.12","gneg"],[74700000,83500000,"q21.13","gpos75"],[83500000,85900000,"q21.2","gneg"],[85900000,92300000,"q21.3","gpos100"],[92300000,97900000,"q22.1","gneg"],[97900000,100500000,"q22.2","gpos25"],[100500000,105100000,"q22.3","gneg"],[105100000,109500000,"q23.1","gpos75"],[109500000,111100000,"q23.2","gneg"],[111100000,116700000,"q23.3","gpos100"],[116700000,118300000,"q24.11","gneg"],[118300000,121500000,"q24.12","gpos50"],[121500000,126300000,"q24.13","gneg"],[126300000,130400000,"q24.21","gpos50"],[130400000,135400000,"q24.22","gneg"],[135400000,138900000,"q24.23","gpos75"],[138900000,145138636,"q24.3","gneg"]],9:[[0,2200000,"p24.3","gneg"],[2200000,4600000,"p24.2","gpos25"],[4600000,9000000,"p24.1","gneg"],[9000000,14200000,"p23","gpos75"],[14200000,16600000,"p22.3","gneg"],[16600000,18500000,"p22.2","gpos25"],[18500000,19900000,"p22.1","gneg"],[19900000,25600000,"p21.3","gpos100"],[25600000,28000000,"p21.2","gneg"],[28000000,33200000,"p21.1","gpos100"],[33200000,36300000,"p13.3","gneg"],[36300000,37900000,"p13.2","gpos25"],[37900000,39000000,"p13.1","gneg"],[39000000,40000000,"p12","gpos50"],[40000000,42200000,"p11.2","gneg"],[42200000,43000000,"p11.1","acen"],[43000000,45500000,"q11","acen"],[45500000,61500000,"q12","gvar"],[61500000,65000000,"q13","gneg"],[65000000,69300000,"q21.11","gpos25"],[69300000,71300000,"q21.12","gneg"],[71300000,76600000,"q21.13","gpos50"],[76600000,78500000,"q21.2","gneg"],[78500000,81500000,"q21.31","gpos50"],[81500000,84300000,"q21.32","gneg"],[84300000,87800000,"q21.33","gpos50"],[87800000,89200000,"q22.1","gneg"],[89200000,91200000,"q22.2","gpos25"],[91200000,93900000,"q22.31","gneg"],[93900000,96500000,"q22.32","gpos25"],[96500000,99800000,"q22.33","gneg"],[99800000,105400000,"q31.1","gpos100"],[105400000,108500000,"q31.2","gneg"],[108500000,112100000,"q31.3","gpos25"],[112100000,114900000,"q32","gneg"],[114900000,119800000,"q33.1","gpos75"],[119800000,123100000,"q33.2","gneg"],[123100000,127500000,"q33.3","gpos25"],[127500000,130600000,"q34.11","gneg"],[130600000,131100000,"q34.12","gpos25"],[131100000,133100000,"q34.13","gneg"],[133100000,134500000,"q34.2","gpos25"],[134500000,138394717,"q34.3","gneg"]],10:[[0,3000000,"p15.3","gneg"],[3000000,3800000,"p15.2","gpos25"],[3800000,6600000,"p15.1","gneg"],[6600000,12200000,"p14","gpos75"],[12200000,17300000,"p13","gneg"],[17300000,18300000,"p12.33","gpos75"],[18300000,18400000,"p12.32","gneg"],[18400000,22300000,"p12.31","gpos75"],[22300000,24300000,"p12.2","gneg"],[24300000,29300000,"p12.1","gpos50"],[29300000,31100000,"p11.23","gneg"],[31100000,34200000,"p11.22","gpos25"],[34200000,38000000,"p11.21","gneg"],[38000000,39800000,"p11.1","acen"],[39800000,41600000,"q11.1","acen"],[41600000,45500000,"q11.21","gneg"],[45500000,48600000,"q11.22","gpos25"],[48600000,51100000,"q11.23","gneg"],[51100000,59400000,"q21.1","gpos100"],[59400000,62800000,"q21.2","gneg"],[62800000,68800000,"q21.3","gpos100"],[68800000,73100000,"q22.1","gneg"],[73100000,75900000,"q22.2","gpos50"],[75900000,80300000,"q22.3","gneg"],[80300000,86100000,"q23.1","gpos100"],[86100000,87700000,"q23.2","gneg"],[87700000,91100000,"q23.31","gpos75"],[91100000,92300000,"q23.32","gneg"],[92300000,95300000,"q23.33","gpos50"],[95300000,97500000,"q24.1","gneg"],[97500000,100100000,"q24.2","gpos50"],[100100000,101200000,"q24.31","gneg"],[101200000,103100000,"q24.32","gpos25"],[103100000,104000000,"q24.33","gneg"],[104000000,110100000,"q25.1","gpos100"],[110100000,113100000,"q25.2","gneg"],[113100000,117300000,"q25.3","gpos75"],[117300000,119900000,"q26.11","gneg"],[119900000,121400000,"q26.12","gpos50"],[121400000,125700000,"q26.13","gneg"],[125700000,128800000,"q26.2","gpos50"],[128800000,133797422,"q26.3","gneg"]],11:[[0,2800000,"p15.5","gneg"],[2800000,11700000,"p15.4","gpos50"],[11700000,13800000,"p15.3","gneg"],[13800000,16900000,"p15.2","gpos50"],[16900000,22000000,"p15.1","gneg"],[22000000,26200000,"p14.3","gpos100"],[26200000,27200000,"p14.2","gneg"],[27200000,31000000,"p14.1","gpos75"],[31000000,36400000,"p13","gneg"],[36400000,43400000,"p12","gpos100"],[43400000,48800000,"p11.2","gneg"],[48800000,51000000,"p11.12","gpos75"],[51000000,53400000,"p11.11","acen"],[53400000,55800000,"q11","acen"],[55800000,60100000,"q12.1","gpos75"],[60100000,61900000,"q12.2","gneg"],[61900000,63600000,"q12.3","gpos25"],[63600000,66100000,"q13.1","gneg"],[66100000,68700000,"q13.2","gpos25"],[68700000,70500000,"q13.3","gneg"],[70500000,75500000,"q13.4","gpos50"],[75500000,77400000,"q13.5","gneg"],[77400000,85900000,"q14.1","gpos100"],[85900000,88600000,"q14.2","gneg"],[88600000,93000000,"q14.3","gpos100"],[93000000,97400000,"q21","gneg"],[97400000,102300000,"q22.1","gpos100"],[102300000,103000000,"q22.2","gneg"],[103000000,110600000,"q22.3","gpos100"],[110600000,112700000,"q23.1","gneg"],[112700000,114600000,"q23.2","gpos50"],[114600000,121300000,"q23.3","gneg"],[121300000,124000000,"q24.1","gpos50"],[124000000,127900000,"q24.2","gneg"],[127900000,130900000,"q24.3","gpos50"],[130900000,135086622,"q25","gneg"]],12:[[0,3200000,"p13.33","gneg"],[3200000,5300000,"p13.32","gpos25"],[5300000,10000000,"p13.31","gneg"],[10000000,12600000,"p13.2","gpos75"],[12600000,14600000,"p13.1","gneg"],[14600000,19800000,"p12.3","gpos100"],[19800000,21100000,"p12.2","gneg"],[21100000,26300000,"p12.1","gpos100"],[26300000,27600000,"p11.23","gneg"],[27600000,30500000,"p11.22","gpos50"],[30500000,33200000,"p11.21","gneg"],[33200000,35500000,"p11.1","acen"],[35500000,37800000,"q11","acen"],[37800000,46000000,"q12","gpos100"],[46000000,48700000,"q13.11","gneg"],[48700000,51100000,"q13.12","gpos25"],[51100000,54500000,"q13.13","gneg"],[54500000,56200000,"q13.2","gpos25"],[56200000,57700000,"q13.3","gneg"],[57700000,62700000,"q14.1","gpos75"],[62700000,64700000,"q14.2","gneg"],[64700000,67300000,"q14.3","gpos50"],[67300000,71100000,"q15","gneg"],[71100000,75300000,"q21.1","gpos75"],[75300000,79900000,"q21.2","gneg"],[79900000,86300000,"q21.31","gpos100"],[86300000,88600000,"q21.32","gneg"],[88600000,92200000,"q21.33","gpos100"],[92200000,95800000,"q22","gneg"],[95800000,101200000,"q23.1","gpos75"],[101200000,103500000,"q23.2","gneg"],[103500000,108600000,"q23.3","gpos50"],[108600000,111300000,"q24.11","gneg"],[111300000,111900000,"q24.12","gpos25"],[111900000,113900000,"q24.13","gneg"],[113900000,116400000,"q24.21","gpos50"],[116400000,117700000,"q24.22","gneg"],[117700000,120300000,"q24.23","gpos50"],[120300000,125400000,"q24.31","gneg"],[125400000,128700000,"q24.32","gpos50"],[128700000,133275309,"q24.33","gneg"]],13:[[0,4600000,"p13","gvar"],[4600000,10100000,"p12","stalk"],[10100000,16500000,"p11.2","gvar"],[16500000,17700000,"p11.1","acen"],[17700000,18900000,"q11","acen"],[18900000,22600000,"q12.11","gneg"],[22600000,24900000,"q12.12","gpos25"],[24900000,27200000,"q12.13","gneg"],[27200000,28300000,"q12.2","gpos25"],[28300000,31600000,"q12.3","gneg"],[31600000,33400000,"q13.1","gpos50"],[33400000,34900000,"q13.2","gneg"],[34900000,39500000,"q13.3","gpos75"],[39500000,44600000,"q14.11","gneg"],[44600000,45200000,"q14.12","gpos25"],[45200000,46700000,"q14.13","gneg"],[46700000,50300000,"q14.2","gpos50"],[50300000,54700000,"q14.3","gneg"],[54700000,59000000,"q21.1","gpos100"],[59000000,61800000,"q21.2","gneg"],[61800000,65200000,"q21.31","gpos75"],[65200000,68100000,"q21.32","gneg"],[68100000,72800000,"q21.33","gpos100"],[72800000,74900000,"q22.1","gneg"],[74900000,76700000,"q22.2","gpos50"],[76700000,78500000,"q22.3","gneg"],[78500000,87100000,"q31.1","gpos100"],[87100000,89400000,"q31.2","gneg"],[89400000,94400000,"q31.3","gpos100"],[94400000,97500000,"q32.1","gneg"],[97500000,98700000,"q32.2","gpos25"],[98700000,101100000,"q32.3","gneg"],[101100000,104200000,"q33.1","gpos100"],[104200000,106400000,"q33.2","gneg"],[106400000,109600000,"q33.3","gpos100"],[109600000,114364328,"q34","gneg"]],14:[[0,3600000,"p13","gvar"],[3600000,8000000,"p12","stalk"],[8000000,16100000,"p11.2","gvar"],[16100000,17200000,"p11.1","acen"],[17200000,18200000,"q11.1","acen"],[18200000,24100000,"q11.2","gneg"],[24100000,32900000,"q12","gpos100"],[32900000,34800000,"q13.1","gneg"],[34800000,36100000,"q13.2","gpos50"],[36100000,37400000,"q13.3","gneg"],[37400000,43000000,"q21.1","gpos100"],[43000000,46700000,"q21.2","gneg"],[46700000,50400000,"q21.3","gpos100"],[50400000,53600000,"q22.1","gneg"],[53600000,55000000,"q22.2","gpos25"],[55000000,57600000,"q22.3","gneg"],[57600000,61600000,"q23.1","gpos75"],[61600000,64300000,"q23.2","gneg"],[64300000,67400000,"q23.3","gpos50"],[67400000,69800000,"q24.1","gneg"],[69800000,73300000,"q24.2","gpos50"],[73300000,78800000,"q24.3","gneg"],[78800000,83100000,"q31.1","gpos100"],[83100000,84400000,"q31.2","gneg"],[84400000,89300000,"q31.3","gpos100"],[89300000,91400000,"q32.11","gneg"],[91400000,94200000,"q32.12","gpos25"],[94200000,95800000,"q32.13","gneg"],[95800000,100900000,"q32.2","gpos50"],[100900000,102700000,"q32.31","gneg"],[102700000,103500000,"q32.32","gpos50"],[103500000,107043718,"q32.33","gneg"]],15:[[0,4200000,"p13","gvar"],[4200000,9700000,"p12","stalk"],[9700000,17500000,"p11.2","gvar"],[17500000,19000000,"p11.1","acen"],[19000000,20500000,"q11.1","acen"],[20500000,25500000,"q11.2","gneg"],[25500000,27800000,"q12","gpos50"],[27800000,30000000,"q13.1","gneg"],[30000000,30900000,"q13.2","gpos50"],[30900000,33400000,"q13.3","gneg"],[33400000,39800000,"q14","gpos75"],[39800000,42500000,"q15.1","gneg"],[42500000,43300000,"q15.2","gpos25"],[43300000,44500000,"q15.3","gneg"],[44500000,49200000,"q21.1","gpos75"],[49200000,52600000,"q21.2","gneg"],[52600000,58800000,"q21.3","gpos75"],[58800000,59000000,"q22.1","gneg"],[59000000,63400000,"q22.2","gpos25"],[63400000,66900000,"q22.31","gneg"],[66900000,67000000,"q22.32","gpos25"],[67000000,67200000,"q22.33","gneg"],[67200000,72400000,"q23","gpos25"],[72400000,74900000,"q24.1","gneg"],[74900000,76300000,"q24.2","gpos25"],[76300000,78000000,"q24.3","gneg"],[78000000,81400000,"q25.1","gpos50"],[81400000,84700000,"q25.2","gneg"],[84700000,88500000,"q25.3","gpos50"],[88500000,93800000,"q26.1","gneg"],[93800000,98000000,"q26.2","gpos50"],[98000000,101991189,"q26.3","gneg"]],16:[[0,7800000,"p13.3","gneg"],[7800000,10400000,"p13.2","gpos50"],[10400000,12500000,"p13.13","gneg"],[12500000,14700000,"p13.12","gpos50"],[14700000,16700000,"p13.11","gneg"],[16700000,21200000,"p12.3","gpos50"],[21200000,24200000,"p12.2","gneg"],[24200000,28500000,"p12.1","gpos50"],[28500000,35300000,"p11.2","gneg"],[35300000,36800000,"p11.1","acen"],[36800000,38400000,"q11.1","acen"],[38400000,47000000,"q11.2","gvar"],[47000000,52600000,"q12.1","gneg"],[52600000,56000000,"q12.2","gpos50"],[56000000,57300000,"q13","gneg"],[57300000,66600000,"q21","gpos100"],[66600000,70800000,"q22.1","gneg"],[70800000,72800000,"q22.2","gpos50"],[72800000,74100000,"q22.3","gneg"],[74100000,79200000,"q23.1","gpos75"],[79200000,81600000,"q23.2","gneg"],[81600000,84100000,"q23.3","gpos50"],[84100000,87000000,"q24.1","gneg"],[87000000,88700000,"q24.2","gpos25"],[88700000,90338345,"q24.3","gneg"]],17:[[0,3400000,"p13.3","gneg"],[3400000,6500000,"p13.2","gpos50"],[6500000,10800000,"p13.1","gneg"],[10800000,16100000,"p12","gpos75"],[16100000,22700000,"p11.2","gneg"],[22700000,25100000,"p11.1","acen"],[25100000,27400000,"q11.1","acen"],[27400000,33500000,"q11.2","gneg"],[33500000,39800000,"q12","gpos50"],[39800000,40200000,"q21.1","gneg"],[40200000,42800000,"q21.2","gpos25"],[42800000,46800000,"q21.31","gneg"],[46800000,49300000,"q21.32","gpos25"],[49300000,52100000,"q21.33","gneg"],[52100000,59500000,"q22","gpos75"],[59500000,60200000,"q23.1","gneg"],[60200000,63100000,"q23.2","gpos75"],[63100000,64600000,"q23.3","gneg"],[64600000,66200000,"q24.1","gpos50"],[66200000,69100000,"q24.2","gneg"],[69100000,72900000,"q24.3","gpos75"],[72900000,76800000,"q25.1","gneg"],[76800000,77200000,"q25.2","gpos25"],[77200000,83257441,"q25.3","gneg"]],18:[[0,2900000,"p11.32","gneg"],[2900000,7200000,"p11.31","gpos50"],[7200000,8500000,"p11.23","gneg"],[8500000,10900000,"p11.22","gpos25"],[10900000,15400000,"p11.21","gneg"],[15400000,18500000,"p11.1","acen"],[18500000,21500000,"q11.1","acen"],[21500000,27500000,"q11.2","gneg"],[27500000,35100000,"q12.1","gpos100"],[35100000,39500000,"q12.2","gneg"],[39500000,45900000,"q12.3","gpos75"],[45900000,50700000,"q21.1","gneg"],[50700000,56200000,"q21.2","gpos75"],[56200000,58600000,"q21.31","gneg"],[58600000,61300000,"q21.32","gpos50"],[61300000,63900000,"q21.33","gneg"],[63900000,69100000,"q22.1","gpos100"],[69100000,71000000,"q22.2","gneg"],[71000000,75400000,"q22.3","gpos25"],[75400000,80373285,"q23","gneg"]],19:[[0,6900000,"p13.3","gneg"],[6900000,12600000,"p13.2","gpos25"],[12600000,13800000,"p13.13","gneg"],[13800000,16100000,"p13.12","gpos25"],[16100000,19900000,"p13.11","gneg"],[19900000,24200000,"p12","gvar"],[24200000,26200000,"p11","acen"],[26200000,28100000,"q11","acen"],[28100000,31900000,"q12","gvar"],[31900000,35100000,"q13.11","gneg"],[35100000,37800000,"q13.12","gpos25"],[37800000,38200000,"q13.13","gneg"],[38200000,42900000,"q13.2","gpos25"],[42900000,44700000,"q13.31","gneg"],[44700000,47500000,"q13.32","gpos25"],[47500000,50900000,"q13.33","gneg"],[50900000,53100000,"q13.41","gpos25"],[53100000,55800000,"q13.42","gneg"],[55800000,58617616,"q13.43","gpos25"]],20:[[0,5100000,"p13","gneg"],[5100000,9200000,"p12.3","gpos75"],[9200000,12000000,"p12.2","gneg"],[12000000,17900000,"p12.1","gpos75"],[17900000,21300000,"p11.23","gneg"],[21300000,22300000,"p11.22","gpos25"],[22300000,25700000,"p11.21","gneg"],[25700000,28100000,"p11.1","acen"],[28100000,30400000,"q11.1","acen"],[30400000,33500000,"q11.21","gneg"],[33500000,35800000,"q11.22","gpos25"],[35800000,39000000,"q11.23","gneg"],[39000000,43100000,"q12","gpos75"],[43100000,43500000,"q13.11","gneg"],[43500000,47800000,"q13.12","gpos25"],[47800000,51200000,"q13.13","gneg"],[51200000,56400000,"q13.2","gpos75"],[56400000,57800000,"q13.31","gneg"],[57800000,59700000,"q13.32","gpos50"],[59700000,64444167,"q13.33","gneg"]],21:[[0,3100000,"p13","gvar"],[3100000,7000000,"p12","stalk"],[7000000,10900000,"p11.2","gvar"],[10900000,12000000,"p11.1","acen"],[12000000,13000000,"q11.1","acen"],[13000000,15000000,"q11.2","gneg"],[15000000,22600000,"q21.1","gpos100"],[22600000,25500000,"q21.2","gneg"],[25500000,30200000,"q21.3","gpos75"],[30200000,34400000,"q22.11","gneg"],[34400000,36400000,"q22.12","gpos50"],[36400000,38300000,"q22.13","gneg"],[38300000,41200000,"q22.2","gpos50"],[41200000,46709983,"q22.3","gneg"]],22:[[0,4300000,"p13","gvar"],[4300000,9400000,"p12","stalk"],[9400000,13700000,"p11.2","gvar"],[13700000,15000000,"p11.1","acen"],[15000000,17400000,"q11.1","acen"],[17400000,21700000,"q11.21","gneg"],[21700000,23100000,"q11.22","gpos25"],[23100000,25500000,"q11.23","gneg"],[25500000,29200000,"q12.1","gpos50"],[29200000,31800000,"q12.2","gneg"],[31800000,37200000,"q12.3","gpos50"],[37200000,40600000,"q13.1","gneg"],[40600000,43800000,"q13.2","gpos50"],[43800000,48100000,"q13.31","gneg"],[48100000,49100000,"q13.32","gpos50"],[49100000,50818468,"q13.33","gneg"]],X:[[0,4400000,"p22.33","gneg"],[4400000,6100000,"p22.32","gpos50"],[6100000,9600000,"p22.31","gneg"],[9600000,17400000,"p22.2","gpos50"],[17400000,19200000,"p22.13","gneg"],[19200000,21900000,"p22.12","gpos50"],[21900000,24900000,"p22.11","gneg"],[24900000,29300000,"p21.3","gpos100"],[29300000,31500000,"p21.2","gneg"],[31500000,37800000,"p21.1","gpos100"],[37800000,42500000,"p11.4","gneg"],[42500000,47600000,"p11.3","gpos75"],[47600000,50100000,"p11.23","gneg"],[50100000,54800000,"p11.22","gpos25"],[54800000,58100000,"p11.21","gneg"],[58100000,61000000,"p11.1","acen"],[61000000,63800000,"q11.1","acen"],[63800000,65400000,"q11.2","gneg"],[65400000,68500000,"q12","gpos50"],[68500000,73000000,"q13.1","gneg"],[73000000,74700000,"q13.2","gpos50"],[74700000,76800000,"q13.3","gneg"],[76800000,85400000,"q21.1","gpos100"],[85400000,87000000,"q21.2","gneg"],[87000000,92700000,"q21.31","gpos100"],[92700000,94300000,"q21.32","gneg"],[94300000,99100000,"q21.33","gpos75"],[99100000,103300000,"q22.1","gneg"],[103300000,104500000,"q22.2","gpos50"],[104500000,109400000,"q22.3","gneg"],[109400000,117400000,"q23","gpos75"],[117400000,121800000,"q24","gneg"],[121800000,129500000,"q25","gpos100"],[129500000,131300000,"q26.1","gneg"],[131300000,134500000,"q26.2","gpos25"],[134500000,138900000,"q26.3","gneg"],[138900000,141200000,"q27.1","gpos75"],[141200000,143000000,"q27.2","gneg"],[143000000,148000000,"q27.3","gpos100"],[148000000,156040895,"q28","gneg"]],Y:[[0,300000,"p11.32","gneg"],[300000,600000,"p11.31","gpos50"],[600000,10300000,"p11.2","gneg"],[10300000,10400000,"p11.1","acen"],[10400000,10600000,"q11.1","acen"],[10600000,12400000,"q11.21","gneg"],[12400000,17100000,"q11.221","gpos50"],[17100000,19600000,"q11.222","gneg"],[19600000,23800000,"q11.223","gpos50"],[23800000,26600000,"q11.23","gneg"],[26600000,57227415,"q12","gvar"]]}}};CanvasXpress.graphTypes={Area:["Area"],AreaLine:["AreaLine"],Bar:["Bar"],BarLine:["BarLine"],Boxplot:["Boxplot"],Fish:["Fish"],Gantt:["Gantt"],Circular:["Circular"],Correlation:["Correlation"],DotLine:["DotLine"],Dotplot:["Dotplot"],Genome:["Genome"],Heatmap:["Heatmap"],Line:["Line"],Map:["Map"],Meter:["Meter"],Network:["Network"],ParallelCoordinates:["ParallelCoordinates"],Pie:["Pie"],Sankey:["Sankey"],Scatter2D:["Scatter2D"],ScatterBubble2D:["ScatterBubble2D"],Scatter3D:["Scatter3D"],Stacked:["Stacked"],StackedLine:["StackedLine"],StackedPercent:["StackedPercent"],StackedPercentLine:["StackedPercentLine"],TagCloud:["TagCloud"],Tree:["Tree"],Treemap:["Treemap"],Venn:["Venn"],DotGraphs:["Boxplot","DotLine","Dotplot"],LineGraphs:["AreaLine","BarLine","DotLine","Line","ParallelCoordinates","StackedLine","StackedPercentLine"],CombinationLineGraphs:["AreaLine","BarLine","DotLine","StackedLine","StackedPercentLine"],ScatterGraphs:["Scatter2D","ScatterBubble2D","Scatter3D"],StackedGraphs:["Stacked","StackedLine","StackedPercent","StackedPercentLine"],OneDPlots:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Meter","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Sankey","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap"],OneDGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Meter","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Stacked","StackedLine","StackedPercent","StackedPercentLine"],OneTwoThreeeDGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Fish","Gantt","Meter","Circular","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Pie","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine","Treemap"],AllGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Fish","Meter","Circular","Correlation","DotLine","Dotplot","Genome","Heatmap","Line","Map","Network","ParallelCoordinates","Pie","Sankey","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap","Venn"],AGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Fish","Meter","Circular","Correlation","DotLine","Dotplot","Heatmap","Line","Map","ParallelCoordinates","Sankey","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap"],AttGraphs:["Bar","BarLine","Boxplot","Dotplot","Treemap","Heatmap","Stacked","StackedLine","StackedPercent","StackedPercentLine","ParallelCoordinates","Line","Sankey","Tree","TagCloud","Gantt"],NoneDGraphs:["Fish","Genome","Map","Network","Sankey","TagCloud","Tree","Treemap","Venn"],NonSegregatable:["Fish","Genome","Map","Network","Sankey","TagCloud","Tree","Treemap","Venn","Circular","Gantt"]};CanvasXpress.colorNames={aliceblue:"f0f8ff",antiquewhite1:"ffefdb",antiquewhite2:"eedfcc",antiquewhite3:"cdc0b0",antiquewhite4:"8b8378",antiquewhite:"faebd7",aqua:"00ffff",aquamarine1:"7fffd4",aquamarine2:"76eec6",aquamarine4:"458b74",aquamarine:"7fffd4",azure1:"f0ffff",azure2:"e0eeee",azure3:"c1cdcd",azure4:"838b8b",azure:"f0ffff",beige:"f5f5dc",bisque1:"ffe4c4",bisque2:"eed5b7",bisque3:"cdb79e",bisque4:"8b7d6b",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blue1:"0000ff",blue2:"0000ee",blue3:"1874cd",blue4:"00008b",blueviolet:"8a2be2",brown1:"ff4040",brown2:"ee3b3b",brown3:"cd3333",brown4:"8b2323",brown:"a52a2a",burlywood1:"ffd39b",burlywood2:"eec591",burlywood3:"cdaa7d",burlywood4:"8b7355",burlywood:"deb887",cadetblue1:"98f5ff",cadetblue2:"8ee5ee",cadetblue3:"7ac5cd",cadetblue4:"53868b",cadetblue:"5f9ea0",chartreuse1:"7fff00",chartreuse2:"76ee00",chartreuse3:"66cd00",chartreuse4:"458b00",chartreuse:"7fff00",chocolate1:"ff7f24",chocolate2:"ee7621",chocolate3:"cd661d",chocolate:"d2691e",coral1:"ff7256",coral2:"ee6a50",coral3:"cd5b45",coral4:"8b3e2f",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk1:"fff8dc",cornsilk2:"eee8cd",cornsilk3:"cdc8b1",cornsilk4:"8b8878",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",cyan1:"00ffff",cyan2:"00eeee",cyan3:"00cdcd",cyan4:"008b8b",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod1:"ffb90f",darkgoldenrod2:"eead0e",darkgoldenrod3:"cd950c",darkgoldenrod4:"8b6508",darkgoldenrod4:"8b6508",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen1:"caff70",darkolivegreen2:"bcee68",darkolivegreen3:"a2cd5a",darkolivegreen4:"6e8b3d",darkolivegreen:"556b2f",darkorange1:"ff7f00",darkorange2:"ee7600",darkorange3:"cd6600",darkorange4:"8b4500",darkorange:"ff8c00",darkorchid1:"bf3eff",darkorchid2:"b23aee",darkorchid3:"9a32cd",darkorchid4:"68228b",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen1:"c1ffc1",darkseagreen2:"b4eeb4",darkseagreen3:"9bcd9b",darkseagreen4:"698b69",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray1:"97ffff",darkslategray2:"8deeee",darkslategray:"2f4f4f",darkslategray3:"79cdcd",darkslategray4:"528b8b",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink1:"ff1493",deeppink2:"ee1289",deeppink3:"cd1076",deeppink4:"8b0a50",deeppink:"ff1493",deepskyblue:"00bfff",deepskyblue1:"00bfff",deepskyblue2:"00b2ee",deepskyblue3:"009acd",deepskyblue4:"00688b",dimgray:"696969",dimgrey:"696969",dodgerblue1:"1e90ff",dodgerblue:"1e90ff",dodgerblue2:"1c86ee",dodgerblue3:"1874cd",dodgerblue4:"104e8b",firebrick1:"ff3030",firebrick2:"ee2c2c",firebrick3:"cd2626",firebrick4:"8b1a1a",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold1:"ffd700",gold2:"eec900",gold3:"cdad00",gold4:"8b7500",goldenrod1:"ffc125",goldenrod2:"eeb422",goldenrod3:"cd9b1d",goldenrod4:"8b6914",goldenrod:"daa520",goldenrod:"daa520",gold:"ffd700",gray10:"1a1a1a",gray1:"030303",gray11:"1c1c1c",gray12:"1f1f1f",gray13:"212121",gray14:"242424",gray15:"262626",gray16:"292929",gray17:"2b2b2b",gray18:"2e2e2e",gray19:"303030",gray20:"333333",gray2:"050505",gray21:"363636",gray22:"383838",gray23:"3b3b3b",gray24:"3d3d3d",gray25:"404040",gray26:"424242",gray27:"454545",gray28:"474747",gray29:"4a4a4a",gray30:"4d4d4d",gray3:"080808",gray31:"4f4f4f",gray32:"525252",gray33:"545454",gray34:"575757",gray35:"595959",gray36:"5c5c5c",gray37:"5e5e5e",gray38:"616161",gray39:"636363",gray40:"666666",gray4:"0a0a0a",gray41:"696969",gray42:"6b6b6b",gray43:"6e6e6e",gray44:"707070",gray45:"737373",gray46:"757575",gray47:"787878",gray48:"7a7a7a",gray49:"7d7d7d",gray50:"7f7f7f",gray5:"0d0d0d",gray51:"828282",gray52:"858585",gray53:"878787",gray54:"8a8a8a",gray55:"8c8c8c",gray56:"8f8f8f",gray57:"919191",gray58:"949494",gray59:"969696",gray60:"999999",gray6:"0f0f0f",gray61:"9c9c9c",gray62:"9e9e9e",gray63:"a1a1a1",gray64:"a3a3a3",gray65:"a6a6a6",gray66:"a8a8a8",gray67:"ababab",gray68:"adadad",gray69:"b0b0b0",gray70:"b3b3b3",gray7:"121212",gray71:"b5b5b5",gray72:"b8b8b8",gray73:"bababa",gray74:"bdbdbd",gray75:"bfbfbf",gray76:"c2c2c2",gray77:"c4c4c4",gray78:"c7c7c7",gray79:"c9c9c9",gray:"808080",gray80:"cccccc",gray8:"141414",gray81:"cfcfcf",gray82:"d1d1d1",gray83:"d4d4d4",gray84:"d6d6d6",gray85:"d9d9d9",gray86:"dbdbdb",gray87:"dedede",gray88:"e0e0e0",gray89:"e3e3e3",gray90:"e5e5e5",gray9:"171717",gray91:"e8e8e8",gray92:"ebebeb",gray93:"ededed",gray94:"f0f0f0",gray95:"f2f2f2",gray97:"f7f7f7",gray98:"fafafa",gray99:"fcfcfc",gray:"bebebe",green:"008000",green1:"00ff00",green2:"00ee00",green3:"00cd00",green4:"008b00",greenyellow:"adff2f",grey10:"1a1a1a",grey1:"030303",grey11:"1c1c1c",grey12:"1f1f1f",grey13:"212121",grey14:"242424",grey15:"262626",grey16:"292929",grey17:"2b2b2b",grey18:"2e2e2e",grey19:"303030",grey20:"333333",grey2:"050505",grey21:"363636",grey22:"383838",grey23:"3b3b3b",grey24:"3d3d3d",grey25:"404040",grey26:"424242",grey27:"454545",grey28:"474747",grey29:"4a4a4a",grey30:"4d4d4d",grey3:"080808",grey31:"4f4f4f",grey32:"525252",grey33:"545454",grey34:"575757",grey35:"595959",grey36:"5c5c5c",grey37:"5e5e5e",grey38:"616161",grey39:"636363",grey40:"666666",grey4:"0a0a0a",grey41:"696969",grey42:"6b6b6b",grey43:"6e6e6e",grey44:"707070",grey45:"737373",grey46:"757575",grey47:"787878",grey48:"7a7a7a",grey49:"7d7d7d",grey50:"7f7f7f",grey5:"0d0d0d",grey51:"828282",grey52:"858585",grey53:"878787",grey54:"8a8a8a",grey55:"8c8c8c",grey56:"8f8f8f",grey57:"919191",grey58:"949494",grey59:"969696",grey60:"999999",grey6:"0f0f0f",grey61:"9c9c9c",grey62:"9e9e9e",grey63:"a1a1a1",grey64:"a3a3a3",grey65:"a6a6a6",grey66:"a8a8a8",grey67:"ababab",grey68:"adadad",grey69:"b0b0b0",grey70:"b3b3b3",grey7:"121212",grey71:"b5b5b5",grey72:"b8b8b8",grey73:"bababa",grey74:"bdbdbd",grey75:"bfbfbf",grey76:"c2c2c2",grey77:"c4c4c4",grey78:"c7c7c7",grey79:"c9c9c9",grey:"808080",grey80:"cccccc",grey8:"141414",grey81:"cfcfcf",grey82:"d1d1d1",grey83:"d4d4d4",grey84:"d6d6d6",grey85:"d9d9d9",grey86:"dbdbdb",grey87:"dedede",grey88:"e0e0e0",grey89:"e3e3e3",grey90:"e5e5e5",grey9:"171717",grey91:"e8e8e8",grey92:"ebebeb",grey93:"ededed",grey94:"f0f0f0",grey95:"f2f2f2",grey97:"f7f7f7",grey98:"fafafa",grey99:"fcfcfc",grey:"808080",honeydew1:"f0fff0",honeydew2:"e0eee0",honeydew3:"c1cdc1",honeydew4:"838b83",honeydew:"f0fff0",hotpink1:"ff6eb4",hotpink2:"ee6aa7",hotpink3:"cd6090",hotpink4:"8b3a62",hotpink:"ff69b4",indianred1:"ff6a6a",indianred2:"ee6363",indianred3:"cd5555",indianred4:"8b3a3a",indianred:"cd5c5c",indigo:"4b0082",ivory1:"fffff0",ivory2:"eeeee0",ivory3:"cdcdc1",ivory4:"8b8b83",ivory:"fffff0",khaki1:"fff68f",khaki2:"eee685",khaki3:"cdc673",khaki4:"8b864e",khaki:"f0e68c",lavenderblush1:"fff0f5",lavenderblush2:"eee0e5",lavenderblush3:"cdc1c5",lavenderblush4:"8b8386",lavenderblush:"fff0f5",lavender:"e6e6fa",lawngreen:"7cfc00",lemonchiffon1:"fffacd",lemonchiffon2:"eee9bf",lemonchiffon3:"cdc9a5",lemonchiffon4:"8b8970",lemonchiffon:"fffacd",lightblue1:"bfefff",lightblue2:"b2dfee",lightblue3:"9ac0cd",lightblue4:"68838b",lightblue:"add8e6",lightcoral:"f08080",lightcyan1:"e0ffff",lightcyan2:"d1eeee",lightcyan3:"b4cdcd",lightcyan4:"7a8b8b",lightcyan:"e0ffff",light:"eedd82",lightgoldenrod1:"ffec8b",lightgoldenrod2:"eedc82",lightgoldenrod3:"cdbe70",lightgoldenrod4:"8b814c",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink1:"ffaeb9",lightpink2:"eea2ad",lightpink3:"cd8c95",lightpink4:"8b5f65",lightpink:"ffb6c1",lightsalmon1:"ffa07a",lightsalmon2:"ee9572",lightsalmon3:"cd8162",lightsalmon4:"8b5742",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue1:"b0e2ff",lightskyblue2:"a4d3ee",lightskyblue3:"8db6cd",lightskyblue4:"607b8b",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightslategrey:"778899",lightsteelblue1:"cae1ff",lightsteelblue2:"bcd2ee",lightsteelblue3:"a2b5cd",lightsteelblue4:"6e7b8b",lightsteelblue:"b0c4de",lightyellow1:"ffffe0",lightyellow2:"eeeed1",lightyellow3:"cdcdb4",lightyellow4:"8b8b7a",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta2:"ee00ee",magenta3:"cd00cd",magenta4:"8b008b",magenta:"ff00ff",maroon1:"ff34b3",maroon2:"ee30a7",maroon3:"cd2990",maroon4:"8b1c62",maroon:"800000",maroon:"b03060",medium:"66cdaa",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid1:"e066ff",mediumorchid2:"d15fee",mediumorchid3:"b452cd",mediumorchid4:"7a378b",mediumorchid:"ba55d3",mediumpurple1:"ab82ff",mediumpurple2:"9f79ee",mediumpurple3:"8968cd",mediumpurple4:"5d478b",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose1:"ffe4e1",mistyrose2:"eed5d2",mistyrose3:"cdb7b5",mistyrose4:"8b7d7b",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite1:"ffdead",navajowhite2:"eecfa1",navajowhite3:"cdb38b",navajowhite4:"8b795e",navajowhite:"ffdead",navy:"000080",navyblue:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab1:"c0ff3e",olivedrab2:"b3ee3a",olivedrab4:"698b22",olivedrab:"6b8e23",orange1:"ffa500",orange2:"ee9a00",orange3:"cd8500",orange4:"8b5a00",orange:"ffa500",orangered1:"ff4500",orangered2:"ee4000",orangered3:"cd3700",orangered4:"8b2500",orangered:"ff4500",orchid1:"ff83fa",orchid2:"ee7ae9",orchid3:"cd69c9",orchid4:"8b4789",orchid:"da70d6",pale:"db7093",palegoldenrod:"eee8aa",palegreen1:"9aff9a",palegreen2:"90ee90",palegreen3:"7ccd7c",palegreen4:"548b54",palegreen:"98fb98",paleturquoise1:"bbffff",paleturquoise2:"aeeeee",paleturquoise3:"96cdcd",paleturquoise4:"668b8b",paleturquoise:"afeeee",palevioletred1:"ff82ab",palevioletred2:"ee799f",palevioletred3:"cd6889",palevioletred4:"8b475d",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff1:"ffdab9",peachpuff2:"eecbad",peachpuff3:"cdaf95",peachpuff4:"8b7765",peachpuff:"ffdab9",peru:"cd853f",pink1:"ffb5c5",pink2:"eea9b8",pink3:"cd919e",pink4:"8b636c",pink:"ffc0cb",plum1:"ffbbff",plum2:"eeaeee",plum3:"cd96cd",plum4:"8b668b",plum:"dda0dd",powderblue:"b0e0e6",purple1:"9b30ff",purple2:"912cee",purple3:"7d26cd",purple4:"551a8b",purple:"800080",purple:"a020f0",rebeccapurple:"663399",red1:"ff0000",red2:"ee0000",red3:"cd0000",red4:"8b0000",red:"ff0000",rosybrown1:"ffc1c1",rosybrown2:"eeb4b4",rosybrown3:"cd9b9b",rosybrown4:"8b6969",rosybrown:"bc8f8f",royalblue1:"4876ff",royalblue2:"436eee",royalblue3:"3a5fcd",royalblue:"4169e1",royalblue4:"27408b",saddlebrown:"8b4513",salmon1:"ff8c69",salmon2:"ee8262",salmon3:"cd7054",salmon4:"8b4c39",salmon:"fa8072",sandybrown:"f4a460",seagreen1:"54ff9f",seagreen2:"4eee94",seagreen:"2e8b57",seagreen3:"43cd80",seagreen4:"2e8b57",seashell1:"fff5ee",seashell2:"eee5de",seashell3:"cdc5bf",seashell4:"8b8682",seashell:"fff5ee",sienna1:"ff8247",sienna2:"ee7942",sienna3:"cd6839",sienna4:"8b4726",sienna:"a0522d",silver:"c0c0c0",skyblue1:"87ceff",skyblue2:"7ec0ee",skyblue3:"6ca6cd",skyblue4:"4a708b",skyblue:"87ceeb",slateblue1:"836fff",slateblue2:"7a67ee",slateblue3:"6959cd",slateblue4:"473c8b",slateblue:"6a5acd",slategray1:"c6e2ff",slategray2:"b9d3ee",slategray3:"9fb6cd",slategray4:"6c7b8b",slategray:"708090",slategrey:"708090",snow1:"fffafa",snow2:"eee9e9",snow3:"cdc9c9",snow4:"8b8989",snow:"fffafa",springgreen:"00ff7f",springgreen1:"00ff7f",springgreen2:"00ee76",springgreen3:"00cd66",springgreen4:"008b45",steelblue1:"63b8ff",steelblue2:"5cacee",steelblue3:"4f94cd",steelblue4:"36648b",steelblue:"4682b4",tan1:"ffa54f",tan2:"ee9a49",tan3:"cd853f",tan4:"8b5a2b",tan:"d2b48c",teal:"008080",thistle1:"ffe1ff",thistle2:"eed2ee",thistle3:"cdb5cd",thistle4:"8b7b8b",thistle:"d8bfd8",tomato1:"ff6347",tomato2:"ee5c42",tomato3:"cd4f39",tomato4:"8b3626",tomato:"ff6347",turquoise1:"00f5ff",turquoise2:"00e5ee",turquoise3:"00c5cd",turquoise4:"00868b",turquoise:"40e0d0",violet:"ee82ee",violetred1:"ff3e96",violetred2:"ee3a8c",violetred3:"cd3278",violetred4:"8b2252",violetred:"d02090",wheat1:"ffe7ba",wheat2:"eed8ae",wheat3:"cdba96",wheat4:"8b7e66",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow1:"ffff00",yellow2:"eeee00",yellow3:"cdcd00",yellow4:"8b8b00",yellow:"ffff00",yellowgreen:"9acd32"};CanvasXpress.colorWords=["4627f67737371607","465647365647f62705028607162774","475707e6944627f67737371605d28536d2","271656c636","465677f6c6c6160247f6e6022756767657265644","4627f677373716070216028647967702e4f435a402371602566716370247f6e6e61634","d65647379737","27567676572656443796","373756270785371667e61634","4707972736e656","47079727365646","374627f67527f6c6f636","5346d6","47c61637","473756769646","465686361636","4627f67737371607021602864796770274653502371602566716370247f6e6e61634","74e405d6f62764164716445637271607","56c696644616f6c6","56671637","74653556671637","47e6962707","0742","850742","8642","6742","7742","27563777f6272456a796c616964796e696","4642","472756c616","56079747f647f62707","56c6f637e6f636","76f6c6","2756767657265646","5636e616d627f666275607","37569647275607f6270556e696665646","e6f696471636f6c6","56d616e64737f686","473656a626f4","57e656d647875647e6f636","57e656d647875647e6f636e6f6","07f64737","0476e696274735f647","27f6272754","4787564577162746","27f6c6f63447e6f666","5646f6e43796","373756c6461656843796","47361656253796","46562756473796765627"];CanvasXpress.salt="7A64D88308817131500C253EA";CanvasXpress.ambiguityCodes={"-":["-"],A:["A"],C:["C"],G:["G"],T:["T"],M:["A","C"],R:["A","G"],W:["A","T"],S:["C","G"],Y:["C","T"],K:["G","T"],V:["A","C","G"],H:["A","C","T"],D:["A","G","T"],B:["C","G","T"],N:["A","C","G","T"],X:["A","C","G","T"]};CanvasXpress.codon={TTT:["F","Phe","Phenylalanine"],TCT:["S","Ser","Serine"],TAT:["Y","Tyr","Tyrosine"],TGT:["C","Cys","Cysteine"],TTC:["F","Phe","Phenylalanine"],TCC:["S","Ser","Serine"],TAC:["Y","Tyr","Tyrosine"],TGC:["C","Cys","Cysteine"],TTA:["L","Leu","Leucine"],TCA:["S","Ser","Serine"],TAA:["*","Stop","Ochre"],TGA:["*","Stop","Opal"],TTG:["L","Leu","Leucine"],TCG:["S","Ser","Serine"],TAG:["*","Stop","Amber"],TGG:["W","Trp","Tryptophan"],CTT:["L","Leu","Leucine"],CCT:["P","Pro","Proline"],CAT:["H","His","Histidine"],CGT:["R","Arg","Arginine"],CTC:["L","Leu","Leucine"],CCC:["P","Pro","Proline"],CAC:["H","His","Histidine"],CGC:["R","Arg","Arginine"],CTA:["L","Leu","Leucine"],CCA:["P","Pro","Proline"],CAA:["Q","Gln","Glutamine"],CGA:["R","Arg","Arginine"],CTG:["L","Leu","Leucine"],CCG:["P","Pro","Proline"],CAG:["Q","Gln","Glutamine"],CGG:["R","Arg","Arginine"],ATT:["I","Ile","Isoleucine"],ACT:["T","Thr","Threonine"],AAT:["N","Asn","Asparagine"],AGT:["S","Ser","Serine"],ATC:["I","Ile","Isoleucine"],ACC:["T","Thr","Threonine"],AAC:["N","Asn","Asparagine"],AGC:["S","Ser","Serine"],ATA:["I","Ile","Isoleucine"],ACA:["T","Thr","Threonine"],AAA:["K","Lys","Lysine"],AGA:["R","Arg","Arginine"],ATG:["M","Met","Methionine"],ACG:["T","Thr","Threonine"],AAG:["K","Lys","Lysine"],AGG:["R","Arg","Arginine"],GTT:["V","Val","Valine"],GCT:["A","Ala","Alanine"],GAT:["D","Asp","Aspartic acid"],GGT:["G","Gly","Glycine"],GTC:["V","Val","Valine"],GCC:["A","Ala","Alanine"],GAC:["D","Asp","Aspartic acid"],GGC:["G","Gly","Glycine"],GTA:["V","Val","Valine"],GCA:["A","Ala","Alanine"],GAA:["E","Glu","Glutamic acid"],GGA:["G","Gly","Glycine"],GTG:["V","Val","Valine"],GCG:["A","Ala","Alanine"],GAG:["E","Glu","Glutamic acid"],GGG:["G","Gly","Glycine"]};CanvasXpress.reverseComplement={A:"T",C:"G",G:"C",T:"A",U:"A",Y:"R",R:"Y",W:"W",S:"S",K:"M",M:"K",B:"V",V:"B",D:"H",H:"D",X:"X",N:"N",a:"t",c:"g",g:"c",t:"a",u:"a",y:"r",r:"y",w:"w",s:"s",k:"m",m:"k",b:"v",v:"b",d:"h",h:"d",x:"x",n:"n"," ":" ","-":"-","/":"/","[":"[","]":"]"};CanvasXpress.themeDef={grey:{"axis.line":"element_blank","axis.minor.ticks.length":0.75,"axis.text.colour":"grey30","axis.text.size":12,"axis.text.r.hjust":0.5,"axis.text.r.margin":2.2,"axis.text.x.margin":2.2,"axis.text.x.vjust":1,"axis.text.x.top.margin":2.2,"axis.text.x.top.vjust":0,"axis.text.y.hjust":1,"axis.text.y.margin":2.2,"axis.text.y.right.hjust":0,"axis.text.y.right.margin":2.2,"axis.ticks.arrow":false,"axis.ticks.colour":"grey20","axis.ticks.length":2.75,"axis.title.x.margin":2.75,"axis.title.x.vjust":1,"axis.title.x.top.margin":2.75,"axis.title.x.top.vjust":0,"axis.title.y.angle":90,"axis.title.y.margin":2.75,"axis.title.y.vjust":1,"axis.title.y.right.angle":-90,"axis.title.y.right.margin":2.75,"axis.title.y.right.vjust":1,"legend.background.colour":null,"legend.box.background":"element_blank","legend.background.linewidth":5.5,"legend.box.margin":null,"legend.box.spacing":11,"legend.justification":"center","legend.key.size":"1.2lines","legend.key.spacing":"5.5","legend.margin":5.5,"legend.position":"right","legend.spacing":11,"legend.text.size":12,"legend.ticks.length":0.2,"legend.title.hjust":0,"line.arrow":false,"line.colour":"black","line.lineend":"butt","line.linetype":1,"line.linewidth":0.5,"panel.background.colour":null,"panel.background.fill":"grey92","panel.border":"element_blank","panel.grid.arrow":false,"panel.grid.colour":"white","panel.grid.minor.arrow":false,"panel.grid.minor.linewidth":0.5,"panel.ontop":false,"panel.spacing":"5.5","plot.background.colour":"white","plot.caption.hjust":1,"plot.caption.margin":5.5,"plot.caption.size":12,"plot.caption.vjust":5.5,"plot.caption.position":"panel","plot.margin":5.5,"plot.subtitle.hjust":0,"plot.subtitle.margin":5.5,"plot.subtitle.vjust":1,"plot.tag.hjust":0.5,"plot.tag.size":14,"plot.tag.vjust":0.5,"plot.tag.position":"topleft","plot.title.hjust":0,"plot.title.margin":5.5,"plot.title.size":12,"plot.title.vjust":1,"plot.title.position":"panel","rect.colour":"black","rect.fill":"white","rect.linetype":1,"rect.linewidth":0.5,"strip.background.colour":null,"strip.background.fill":"grey85","strip.clip":"inherit","strip.placement":"inside","strip.switch.pad.grid":2.75,"strip.switch.pad.wrap":2.75,"strip.text.colour":"grey10","strip.text.margin":4.4,"strip.text.size":12,"strip.text.y.angle":-90,"strip.text.y.left.angle":90,"text.angle":0,"text.colour":"black","text.debug":false,"text.face":"plain","text.family":"","text.hjust":0.5,"text.lineheight":0.9,"text.margin":0,"text.size":12,"text.vjust":0.5},bw:{"axis.line":"element_blank","axis.minor.ticks.length":0.75,"axis.text.colour":"grey30","axis.text.size":12,"axis.text.r.hjust":0.5,"axis.text.r.margin":2.2,"axis.text.x.margin":2.2,"axis.text.x.vjust":1,"axis.text.x.top.margin":2.2,"axis.text.x.top.vjust":0,"axis.text.y.hjust":1,"axis.text.y.margin":2.2,"axis.text.y.right.hjust":0,"axis.text.y.right.margin":2.2,"axis.ticks.arrow":false,"axis.ticks.colour":"grey20","axis.ticks.length":2.75,"axis.title.x.margin":2.75,"axis.title.x.vjust":1,"axis.title.x.top.margin":2.75,"axis.title.x.top.vjust":0,"axis.title.y.angle":90,"axis.title.y.margin":2.75,"axis.title.y.vjust":1,"axis.title.y.right.angle":-90,"axis.title.y.right.margin":2.75,"axis.title.y.right.vjust":1,"legend.background.colour":null,"legend.box.background":"element_blank","legend.background.linewidth":5.5,"legend.box.margin":null,"legend.box.spacing":11,"legend.justification":"center","legend.key.size":"1.2lines","legend.key.spacing":"5.5","legend.margin":5.5,"legend.position":"right","legend.spacing":11,"legend.text.size":12,"legend.ticks.length":0.2,"legend.title.hjust":0,"line.arrow":false,"line.colour":"black","line.lineend":"butt","line.linetype":1,"line.linewidth":0.5,"panel.background.colour":null,"panel.background.fill":"white","panel.border.colour":"grey20","panel.border.fill":null,"panel.grid.arrow":false,"panel.grid.colour":"grey92","panel.grid.minor.arrow":false,"panel.grid.minor.linewidth":0.5,"panel.ontop":false,"panel.spacing":"5.5","plot.background.colour":"white","plot.caption.hjust":1,"plot.caption.margin":5.5,"plot.caption.size":12,"plot.caption.vjust":5.5,"plot.caption.position":"panel","plot.margin":5.5,"plot.subtitle.hjust":0,"plot.subtitle.margin":5.5,"plot.subtitle.vjust":1,"plot.tag.hjust":0.5,"plot.tag.size":14,"plot.tag.vjust":0.5,"plot.tag.position":"topleft","plot.title.hjust":0,"plot.title.margin":5.5,"plot.title.size":12,"plot.title.vjust":1,"plot.title.position":"panel","rect.colour":"black","rect.fill":"white","rect.linetype":1,"rect.linewidth":0.5,"strip.background.colour":"grey20","strip.background.fill":"grey85","strip.clip":"inherit","strip.placement":"inside","strip.switch.pad.grid":2.75,"strip.switch.pad.wrap":2.75,"strip.text.colour":"grey10","strip.text.margin":4.4,"strip.text.size":12,"strip.text.y.angle":-90,"strip.text.y.left.angle":90,"text.angle":0,"text.colour":"black","text.debug":false,"text.face":"plain","text.family":"","text.hjust":0.5,"text.lineheight":0.9,"text.margin":0,"text.size":12,"text.vjust":0.5},linedraw:{"axis.line":"element_blank","axis.minor.ticks.length":0.75,"axis.text.colour":"black","axis.text.size":12,"axis.text.r.hjust":0.5,"axis.text.r.margin":2.2,"axis.text.x.margin":2.2,"axis.text.x.vjust":1,"axis.text.x.top.margin":2.2,"axis.text.x.top.vjust":0,"axis.text.y.hjust":1,"axis.text.y.margin":2.2,"axis.text.y.right.hjust":0,"axis.text.y.right.margin":2.2,"axis.ticks.arrow":false,"axis.ticks.colour":"black","axis.ticks.linewidth":0.5,"axis.ticks.length":2.75,"axis.title.x.margin":2.75,"axis.title.x.vjust":1,"axis.title.x.top.margin":2.75,"axis.title.x.top.vjust":0,"axis.title.y.angle":90,"axis.title.y.margin":2.75,"axis.title.y.vjust":1,"axis.title.y.right.angle":-90,"axis.title.y.right.margin":2.75,"axis.title.y.right.vjust":1,"legend.background.colour":null,"legend.box.background":"element_blank","legend.background.linewidth":5.5,"legend.box.margin":null,"legend.box.spacing":11,"legend.justification":"center","legend.key.size":"1.2lines","legend.key.spacing":"5.5","legend.margin":5.5,"legend.position":"right","legend.spacing":11,"legend.text.size":12,"legend.ticks.length":0.2,"legend.title.hjust":0,"line.arrow":false,"line.colour":"black","line.lineend":"butt","line.linetype":1,"line.linewidth":0.5,"panel.background.colour":null,"panel.background.fill":"white","panel.border.colour":"black","panel.border.fill":null,"panel.border.linewidth":1,"panel.grid.arrow":false,"panel.grid.colour":"black","panel.grid.major.arrow":false,"panel.grid.major.linewidth":"0.1","panel.grid.minor.arrow":false,"panel.grid.minor.linewidth":"0.05","panel.ontop":false,"panel.spacing":"5.5","plot.background.colour":"white","plot.caption.hjust":1,"plot.caption.margin":5.5,"plot.caption.size":12,"plot.caption.vjust":5.5,"plot.caption.position":"panel","plot.margin":5.5,"plot.subtitle.hjust":0,"plot.subtitle.margin":5.5,"plot.subtitle.vjust":1,"plot.tag.hjust":0.5,"plot.tag.size":14,"plot.tag.vjust":0.5,"plot.tag.position":"topleft","plot.title.hjust":0,"plot.title.margin":5.5,"plot.title.size":12,"plot.title.vjust":1,"plot.title.position":"panel","rect.colour":"black","rect.fill":"white","rect.linetype":1,"rect.linewidth":0.5,"strip.background.fill":"black","strip.clip":"inherit","strip.placement":"inside","strip.switch.pad.grid":2.75,"strip.switch.pad.wrap":2.75,"strip.text.colour":"white","strip.text.margin":4.4,"strip.text.size":12,"strip.text.y.angle":-90,"strip.text.y.left.angle":90,"text.angle":0,"text.colour":"black","text.debug":false,"text.face":"plain","text.family":"","text.hjust":0.5,"text.lineheight":0.9,"text.margin":0,"text.size":12,"text.vjust":0.5},light:{"axis.line":"element_blank","axis.minor.ticks.length":0.75,"axis.text.colour":"grey30","axis.text.size":12,"axis.text.r.hjust":0.5,"axis.text.r.margin":2.2,"axis.text.x.margin":2.2,"axis.text.x.vjust":1,"axis.text.x.top.margin":2.2,"axis.text.x.top.vjust":0,"axis.text.y.hjust":1,"axis.text.y.margin":2.2,"axis.text.y.right.hjust":0,"axis.text.y.right.margin":2.2,"axis.ticks.arrow":false,"axis.ticks.colour":"grey70","axis.ticks.linewidth":0.5,"axis.ticks.length":2.75,"axis.title.x.margin":2.75,"axis.title.x.vjust":1,"axis.title.x.top.margin":2.75,"axis.title.x.top.vjust":0,"axis.title.y.angle":90,"axis.title.y.margin":2.75,"axis.title.y.vjust":1,"axis.title.y.right.angle":-90,"axis.title.y.right.margin":2.75,"axis.title.y.right.vjust":1,"legend.background.colour":null,"legend.box.background":"element_blank","legend.background.linewidth":5.5,"legend.box.margin":null,"legend.box.spacing":11,"legend.justification":"center","legend.key.size":"1.2lines","legend.key.spacing":"5.5","legend.margin":5.5,"legend.position":"right","legend.spacing":11,"legend.text.size":12,"legend.ticks.length":0.2,"legend.title.hjust":0,"line.arrow":false,"line.colour":"black","line.lineend":"butt","line.linetype":1,"line.linewidth":0.5,"panel.background.colour":null,"panel.background.fill":"white","panel.border.colour":"grey70","panel.border.fill":null,"panel.border.linewidth":1,"panel.grid.arrow":false,"panel.grid.colour":"grey87","panel.grid.major.arrow":false,"panel.grid.major.linewidth":0.5,"panel.grid.minor.arrow":false,"panel.grid.minor.linewidth":"0.25","panel.ontop":false,"panel.spacing":"5.5","plot.background.colour":"white","plot.caption.hjust":1,"plot.caption.margin":5.5,"plot.caption.size":12,"plot.caption.vjust":5.5,"plot.caption.position":"panel","plot.margin":5.5,"plot.subtitle.hjust":0,"plot.subtitle.margin":5.5,"plot.subtitle.vjust":1,"plot.tag.hjust":0.5,"plot.tag.size":14,"plot.tag.vjust":0.5,"plot.tag.position":"topleft","plot.title.hjust":0,"plot.title.margin":5.5,"plot.title.size":12,"plot.title.vjust":1,"plot.title.position":"plot","rect.colour":"black","rect.fill":"white","rect.linetype":1,"rect.linewidth":0.5,"strip.background.colour":null,"strip.background.fill":"grey70","strip.clip":"inherit","strip.placement":"inside","strip.switch.pad.grid":2.75,"strip.switch.pad.wrap":2.75,"strip.text.colour":"white","strip.text.margin":4.4,"strip.text.size":12,"strip.text.y.angle":-90,"strip.text.y.left.angle":90,"text.angle":0,"text.colour":"black","text.debug":false,"text.face":"plain","text.family":"","text.hjust":0.5,"text.lineheight":0.9,"text.margin":0,"text.size":12,"text.vjust":0.5},dark:{"axis.line":"element_blank","axis.minor.ticks.length":0.75,"axis.text.colour":"grey30","axis.text.size":12,"axis.text.r.hjust":0.5,"axis.text.r.margin":2.2,"axis.text.x.margin":2.2,"axis.text.x.vjust":1,"axis.text.x.top.margin":2.2,"axis.text.x.top.vjust":0,"axis.text.y.hjust":1,"axis.text.y.margin":2.2,"axis.text.y.right.hjust":0,"axis.text.y.right.margin":2.2,"axis.ticks.arrow":false,"axis.ticks.colour":"grey20","axis.ticks.linewidth":0.5,"axis.ticks.length":2.75,"axis.title.x.margin":2.75,"axis.title.x.vjust":1,"axis.title.x.top.margin":2.75,"axis.title.x.top.vjust":0,"axis.title.y.angle":90,"axis.title.y.margin":2.75,"axis.title.y.vjust":1,"axis.title.y.right.angle":-90,"axis.title.y.right.margin":2.75,"axis.title.y.right.vjust":1,"legend.background.colour":null,"legend.box.background":"element_blank","legend.background.linewidth":5.5,"legend.box.margin":null,"legend.box.spacing":11,"legend.justification":"center","legend.key.size":"1.2lines","legend.key.spacing":"5.5","legend.margin":5.5,"legend.position":"right","legend.spacing":11,"legend.text.size":12,"legend.ticks.length":0.2,"legend.title.hjust":0,"line.arrow":false,"line.colour":"black","line.lineend":"butt","line.linetype":1,"line.linewidth":0.5,"panel.background.colour":null,"panel.background.fill":"grey50","panel.border":"element_blank","panel.grid.arrow":false,"panel.grid.colour":"grey42","panel.grid.major.arrow":false,"panel.grid.major.linewidth":0.5,"panel.grid.minor.arrow":false,"panel.grid.minor.linewidth":"0.25","panel.ontop":false,"panel.spacing":"5.5","plot.background.colour":"white","plot.caption.hjust":1,"plot.caption.margin":5.5,"plot.caption.size":12,"plot.caption.vjust":5.5,"plot.caption.position":"panel","plot.margin":5.5,"plot.subtitle.hjust":0,"plot.subtitle.margin":5.5,"plot.subtitle.vjust":1,"plot.tag.hjust":0.5,"plot.tag.size":14,"plot.tag.vjust":0.5,"plot.tag.position":"topleft","plot.title.hjust":0,"plot.title.margin":5.5,"plot.title.size":12,"plot.title.vjust":1,"plot.title.position":"panel","rect.colour":"black","rect.fill":"white","rect.linetype":1,"rect.linewidth":0.5,"strip.background.colour":null,"strip.background.fill":"grey15","strip.clip":"inherit","strip.placement":"inside","strip.switch.pad.grid":2.75,"strip.switch.pad.wrap":2.75,"strip.text.colour":"grey90","strip.text.margin":4.4,"strip.text.size":12,"strip.text.y.angle":-90,"strip.text.y.left.angle":90,"text.angle":0,"text.colour":"black","text.debug":false,"text.face":"plain","text.family":"","text.hjust":0.5,"text.lineheight":0.9,"text.margin":0,"text.size":12,"text.vjust":0.5},minimal:{"axis.line":"element_blank","axis.minor.ticks.length":0.75,"axis.text.colour":"grey30","axis.text.size":12,"axis.text.r.hjust":0.5,"axis.text.r.margin":2.2,"axis.text.x.margin":2.2,"axis.text.x.vjust":1,"axis.text.x.top.margin":2.2,"axis.text.x.top.vjust":0,"axis.text.y.hjust":1,"axis.text.y.margin":2.2,"axis.text.y.right.hjust":0,"axis.text.y.right.margin":2.2,"axis.ticks":"element_blank","axis.ticks.length":2.75,"axis.title.x.margin":2.75,"axis.title.x.vjust":1,"axis.title.x.top.margin":2.75,"axis.title.x.top.vjust":0,"axis.title.y.angle":90,"axis.title.y.margin":2.75,"axis.title.y.vjust":1,"axis.title.y.right.angle":-90,"axis.title.y.right.margin":2.75,"axis.title.y.right.vjust":5.5,"legend.background":"element_blank","legend.box.background":"element_blank","legend.box.margin":null,"legend.box.spacing":11,"legend.justification":"center","legend.key":"element_blank","legend.key.size":"1.2lines","legend.key.spacing":"5.5","legend.margin":5.5,"legend.position":"right","legend.spacing":11,"legend.text.size":12,"legend.ticks.length":0.2,"legend.title.hjust":0,"line.arrow":false,"line.colour":"black","line.lineend":"butt","line.linetype":1,"line.linewidth":0.5,"panel.background":"element_blank","panel.border":"element_blank","panel.grid.arrow":false,"panel.grid.colour":"grey92","panel.grid.minor.arrow":false,"panel.grid.minor.linewidth":0.5,"panel.ontop":false,"panel.spacing":"5.5","plot.background":"element_blank","plot.caption.hjust":1,"plot.caption.margin":5.5,"plot.caption.size":12,"plot.caption.vjust":5.5,"plot.caption.position":"panel","plot.margin":5.5,"plot.subtitle.hjust":0,"plot.subtitle.margin":5.5,"plot.subtitle.vjust":1,"plot.tag.hjust":0.5,"plot.tag.size":14,"plot.tag.vjust":0.5,"plot.tag.position":"topleft","plot.title.hjust":0,"plot.title.margin":5.5,"plot.title.size":12,"plot.title.vjust":1,"plot.title.position":"panel","rect.colour":"black","rect.fill":"white","rect.linetype":1,"rect.linewidth":0.5,"strip.background":"element_blank","strip.clip":"inherit","strip.placement":"inside","strip.switch.pad.grid":2.75,"strip.switch.pad.wrap":2.75,"strip.text.colour":"grey10","strip.text.margin":4.4,"strip.text.size":12,"strip.text.y.angle":-90,"strip.text.y.left.angle":90,"text.angle":0,"text.colour":"black","text.debug":false,"text.face":"plain","text.family":"","text.hjust":0.5,"text.lineheight":0.9,"text.margin":0,"text.size":12,"text.vjust":0.5},classic:{"axis.line.arrow":false,"axis.line.colour":"black","axis.line.linewidth":1,"axis.minor.ticks.length":0.75,"axis.text.colour":"grey30","axis.text.size":12,"axis.text.r.hjust":0.5,"axis.text.r.margin":2.2,"axis.text.x.margin":2.2,"axis.text.x.vjust":1,"axis.text.x.top.margin":2.2,"axis.text.x.top.vjust":0,"axis.text.y.hjust":1,"axis.text.y.margin":2.2,"axis.text.y.right.hjust":0,"axis.text.y.right.margin":2.2,"axis.ticks.arrow":false,"axis.ticks.colour":"grey20","axis.ticks.length":2.75,"axis.title.x.margin":2.75,"axis.title.x.vjust":1,"axis.title.x.top.margin":2.75,"axis.title.x.top.vjust":0,"axis.title.y.angle":90,"axis.title.y.margin":2.75,"axis.title.y.vjust":1,"axis.title.y.right.angle":-90,"axis.title.y.right.margin":2.75,"axis.title.y.right.vjust":1,"legend.background.colour":null,"legend.box.background":"element_blank","legend.background.linewidth":5.5,"legend.box.margin":null,"legend.box.spacing":11,"legend.justification":"center","legend.key.size":"1.2lines","legend.key.spacing":"5.5","legend.margin":5.5,"legend.position":"right","legend.spacing":11,"legend.text.size":12,"legend.ticks.length":0.2,"legend.title.hjust":0,"line.arrow":false,"line.colour":"black","line.lineend":"butt","line.linetype":1,"line.linewidth":0.5,"panel.background.colour":null,"panel.background.fill":"white","panel.border":"element_blank","panel.grid.arrow":false,"panel.grid.colour":"grey92","panel.grid.major":"element_blank","panel.grid.minor":"element_blank","panel.ontop":false,"panel.spacing":"5.5","plot.background.colour":"white","plot.caption.hjust":1,"plot.caption.margin":5.5,"plot.caption.size":12,"plot.caption.vjust":5.5,"plot.caption.position":"panel","plot.margin":5.5,"plot.subtitle.hjust":0,"plot.subtitle.margin":5.5,"plot.subtitle.vjust":1,"plot.tag.hjust":0.5,"plot.tag.size":14,"plot.tag.vjust":0.5,"plot.tag.position":"topleft","plot.title.hjust":0,"plot.title.margin":5.5,"plot.title.size":12,"plot.title.vjust":1,"plot.title.position":"panel","rect.colour":"black","rect.fill":"white","rect.linetype":1,"rect.linewidth":0.5,"strip.background.colour":"black","strip.background.fill":"white","strip.background.linewidth":"2","strip.clip":"inherit","strip.placement":"inside","strip.switch.pad.grid":2.75,"strip.switch.pad.wrap":2.75,"strip.text.colour":"grey10","strip.text.margin":4.4,"strip.text.size":12,"strip.text.y.angle":-90,"strip.text.y.left.angle":90,"text.angle":0,"text.colour":"black","text.debug":false,"text.face":"plain","text.family":"","text.hjust":0.5,"text.lineheight":0.9,"text.margin":0,"text.size":12,"text.vjust":0.5},void0:{"axis.minor.ticks.length":"0","axis.text":"element_blank","axis.ticks.length":"0","axis.title":"element_blank","legend.key.size":"1.2lines","legend.key.spacing":"5.5","legend.position":"right","legend.text.size":12,"legend.ticks.length":0.2,"legend.title.hjust":0,line:"element_blank","panel.ontop":false,"panel.spacing":"5.5","plot.caption.hjust":1,"plot.caption.margin":5.5,"plot.caption.size":12,"plot.caption.vjust":null,"plot.caption.position":"panel","plot.margin":null,"plot.subtitle.hjust":0,"plot.subtitle.margin":5.5,"plot.subtitle.vjust":1,"plot.tag.hjust":0.5,"plot.tag.size":14,"plot.tag.vjust":0.5,"plot.tag.position":"topleft","plot.title.hjust":0,"plot.title.margin":5.5,"plot.title.size":12,"plot.title.vjust":1,"plot.title.position":"panel",rect:"element_blank","strip.clip":"inherit","strip.switch.pad.grid":2.75,"strip.switch.pad.wrap":2.75,"strip.text.size":12,"text.angle":0,"text.colour":"black","text.debug":false,"text.face":"plain","text.family":"","text.hjust":0.5,"text.lineheight":0.9,"text.margin":0,"text.size":12,"text.vjust":0.5},economist:{"axis.line.arrow":false,"axis.line.linewidth":0.8,"axis.line.y":"element_blank","axis.minor.ticks.length":0.75,"axis.text.size":11,"axis.text.r.hjust":0.5,"axis.text.r.margin":2.2,"axis.text.x.margin":10,"axis.text.x.vjust":0,"axis.text.x.top.margin":10,"axis.text.x.top.vjust":0,"axis.text.y.hjust":0,"axis.text.y.margin":10,"axis.text.y.right.hjust":0,"axis.text.y.right.margin":2.2,"axis.ticks.arrow":false,"axis.ticks.length":-5,"axis.ticks.y":"element_blank","axis.title.size":12,"axis.title.x.top.margin":2.75,"axis.title.x.top.vjust":0,"axis.title.y.angle":90,"axis.title.y.right.angle":-90,"axis.title.y.right.margin":2.75,"axis.title.y.right.vjust":1,"legend.background.linetype":0,"legend.box.background":"element_blank","legend.background.linewidth":null,"legend.box.margin":null,"legend.box.spacing":11,"legend.justification":"center","legend.key.linetype":0,"legend.key.size":"1.2lines","legend.key.spacing":5.5,"legend.key.linewidth":5.5,"legend.margin":5.5,"legend.position":"top","legend.spacing":15,"legend.text.size":16,"legend.ticks.length":0.2,"legend.title.hjust":0,"legend.title.size":12,"line.arrow":false,"line.colour":"black","panel.background.linetype":0,"panel.border":"element_blank","panel.grid.arrow":false,"panel.grid.colour":"white","panel.grid.major.arrow":false,"panel.grid.major.colour":"white","panel.grid.major.linewidth":1.75,"panel.grid.major.x":"element_blank","panel.grid.minor":"element_blank","panel.ontop":false,"panel.spacing":"0.25lines","plot.background.colour":null,"plot.background.fill":"#d5e4eb","plot.caption.hjust":1,"plot.caption.margin":5.5,"plot.caption.size":12,"plot.caption.vjust":12,"plot.caption.position":"panel","plot.margin":12,"plot.subtitle.hjust":0,"plot.subtitle.margin":5.5,"plot.subtitle.vjust":1,"plot.tag.hjust":0.5,"plot.tag.size":14,"plot.tag.vjust":0.5,"plot.tag.position":"topleft","plot.title.face":"bold","plot.title.hjust":0,"plot.title.size":20,"plot.title.position":"panel","rect.colour":null,"rect.fill":null,"rect.linetype":1,"strip.background.colour":null,"strip.background.fill":null,"strip.background.linetype":0,"strip.clip":"inherit","strip.placement":"inside","strip.switch.pad.grid":2.75,"strip.switch.pad.wrap":2.75,"strip.text.size":16,"strip.text.y.angle":-90,"strip.text.y.left.angle":90,"text.colour":"black"},excel:{"axis.line":"element_blank","axis.minor.ticks.length":0.75,"axis.text.colour":"grey30","axis.text.size":12,"axis.text.r.hjust":0.5,"axis.text.r.margin":2.2,"axis.text.x.margin":2.2,"axis.text.x.vjust":1,"axis.text.x.top.margin":2.2,"axis.text.x.top.vjust":0,"axis.text.y.hjust":1,"axis.text.y.margin":2.2,"axis.text.y.right.hjust":0,"axis.text.y.right.margin":2.2,"axis.ticks.arrow":false,"axis.ticks.colour":"grey20","axis.ticks.length":2.75,"axis.title.x.margin":2.75,"axis.title.x.vjust":1,"axis.title.x.top.margin":2.75,"axis.title.x.top.vjust":0,"axis.title.y.angle":90,"axis.title.y.margin":2.75,"axis.title.y.vjust":1,"axis.title.y.right.angle":-90,"axis.title.y.right.margin":2.75,"axis.title.y.right.vjust":1,"legend.background.colour":"black","legend.background.linetype":1,"legend.box.background":"element_blank","legend.background.linewidth":null,"legend.box.margin":null,"legend.box.spacing":11,"legend.justification":"center","legend.key.colour":null,"legend.key.size":"1.2lines","legend.key.spacing":"5.5","legend.key.linewidth":5.5,"legend.margin":5.5,"legend.position":"right","legend.spacing":11,"legend.text.size":12,"legend.ticks.length":0.2,"legend.title.hjust":0,"line.arrow":false,"line.colour":"black","line.lineend":"butt","line.linetype":1,"line.linewidth":0.5,"panel.background.colour":null,"panel.background.fill":"#C0C0C0","panel.border.colour":"black","panel.border.fill":null,"panel.border.linetype":1,"panel.grid.arrow":false,"panel.grid.colour":"grey92","panel.grid.major.arrow":false,"panel.grid.major.colour":"black","panel.grid.major.x":"element_blank","panel.grid.minor":"element_blank","panel.ontop":false,"panel.spacing":"5.5","plot.background.colour":"white","plot.caption.hjust":1,"plot.caption.margin":5.5,"plot.caption.size":12,"plot.caption.vjust":5.5,"plot.caption.position":"panel","plot.margin":5.5,"plot.subtitle.hjust":0,"plot.subtitle.margin":5.5,"plot.subtitle.vjust":1,"plot.tag.hjust":0.5,"plot.tag.size":14,"plot.tag.vjust":0.5,"plot.tag.position":"topleft","plot.title.hjust":0,"plot.title.margin":5.5,"plot.title.size":12,"plot.title.vjust":1,"plot.title.position":"panel","rect.colour":"black","rect.fill":"white","rect.linetype":1,"rect.linewidth":0.5,"strip.background.colour":null,"strip.background.fill":"white","strip.background.linetype":0,"strip.clip":"inherit","strip.placement":"inside","strip.switch.pad.grid":2.75,"strip.switch.pad.wrap":2.75,"strip.text.colour":"grey10","strip.text.margin":4.4,"strip.text.size":12,"strip.text.y.angle":-90,"strip.text.y.left.angle":90,"text.angle":0,"text.colour":"black","text.debug":false,"text.face":"plain","text.family":"","text.hjust":0.5,"text.lineheight":0.9,"text.margin":0,"text.size":12,"text.vjust":0.5},solarized:{"axis.line.arrow":false,"axis.line.colour":"#93a1a1","axis.line.linetype":1,"axis.minor.ticks.length":0.75,"axis.text.colour":"grey30","axis.text.size":12,"axis.text.r.hjust":0.5,"axis.text.r.margin":2.4,"axis.text.x.margin":2.4,"axis.text.x.vjust":1,"axis.text.x.top.margin":2.4,"axis.text.x.top.vjust":0,"axis.text.y.hjust":1,"axis.text.y.margin":2.4,"axis.text.y.right.hjust":0,"axis.text.y.right.margin":2.4,"axis.ticks.arrow":false,"axis.ticks.colour":"#93a1a1","axis.ticks.length":"3","axis.title.x.margin":3,"axis.title.x.vjust":1,"axis.title.x.top.margin":3,"axis.title.x.top.vjust":0,"axis.title.y.angle":90,"axis.title.y.margin":3,"axis.title.y.vjust":1,"axis.title.y.right.angle":-90,"axis.title.y.right.margin":3,"axis.title.y.right.vjust":1,"legend.background.colour":null,"legend.box.background":"element_blank","legend.background.linewidth":null,"legend.box.margin":null,"legend.box.spacing":12,"legend.justification":"center","legend.key.linetype":0,"legend.key.size":"1.2lines","legend.key.spacing":"6","legend.key.linewidth":6,"legend.margin":6,"legend.position":"right","legend.spacing":12,"legend.text.size":12,"legend.ticks.length":0.2,"legend.title.hjust":0,"line.arrow":false,"line.colour":"#93a1a1","line.lineend":"butt","line.linetype":1,"line.linewidth":"0.545454545454545","panel.background.colour":"#93a1a1","panel.background.fill":"#fdf6e3","panel.border":"element_blank","panel.grid.arrow":false,"panel.grid.colour":"#eee8d5","panel.grid.major.arrow":false,"panel.grid.major.colour":"#eee8d5","panel.grid.minor.arrow":false,"panel.grid.minor.colour":"#eee8d5","panel.grid.minor.linewidth":0.5,"panel.ontop":false,"panel.spacing":"6","plot.background.colour":null,"plot.background.linetype":0,"plot.caption.hjust":1,"plot.caption.margin":6,"plot.caption.size":12,"plot.caption.vjust":6,"plot.caption.position":"panel","plot.margin":6,"plot.subtitle.hjust":0,"plot.subtitle.margin":6,"plot.subtitle.vjust":1,"plot.tag.hjust":0.5,"plot.tag.size":14,"plot.tag.vjust":0.5,"plot.tag.position":"topleft","plot.title.hjust":0,"plot.title.margin":6,"plot.title.size":12,"plot.title.vjust":1,"plot.title.position":"panel","rect.colour":"#93a1a1","rect.fill":"#fdf6e3","rect.linetype":1,"rect.linewidth":"0.545454545454545","strip.background.colour":"grey20","strip.background.fill":"grey85","strip.clip":"inherit","strip.placement":"inside","strip.switch.pad.grid":"3","strip.switch.pad.wrap":"3","strip.text.colour":"grey10","strip.text.margin":4.8,"strip.text.size":12,"strip.text.y.angle":-90,"strip.text.y.left.angle":90,"text.angle":0,"text.colour":"#93a1a1","text.debug":false,"text.face":"plain","text.family":"","text.hjust":0.5,"text.lineheight":0.9,"text.margin":0,"text.size":12,"text.vjust":0.5,"title.colour":"#657b83"},ptol:{"axis.line":"element_blank","axis.minor.ticks.length":0.75,"axis.text.colour":"grey30","axis.text.size":12,"axis.text.r.hjust":0.5,"axis.text.r.margin":2.2,"axis.text.x.margin":2.2,"axis.text.x.vjust":1,"axis.text.x.top.margin":2.2,"axis.text.x.top.vjust":0,"axis.text.y.hjust":1,"axis.text.y.margin":2.2,"axis.text.y.right.hjust":0,"axis.text.y.right.margin":2.2,"axis.ticks":"element_blank","axis.ticks.length":2.75,"axis.title.x.margin":2.75,"axis.title.x.vjust":1,"axis.title.x.top.margin":2.75,"axis.title.x.top.vjust":0,"axis.title.y.angle":90,"axis.title.y.margin":2.75,"axis.title.y.vjust":1,"axis.title.y.right.angle":-90,"axis.title.y.right.margin":2.75,"axis.title.y.right.vjust":5.5,"legend.background":"element_blank","legend.box.background":"element_blank","legend.box.margin":null,"legend.box.spacing":11,"legend.justification":"center","legend.key":"element_blank","legend.key.size":"1.2lines","legend.key.spacing":"5.5","legend.margin":5.5,"legend.position":"right","legend.spacing":11,"legend.text.size":12,"legend.ticks.length":0.2,"legend.title.hjust":0,"line.arrow":false,"line.colour":"black","line.lineend":"butt","line.linetype":1,"line.linewidth":0.5,"panel.background":"element_blank","panel.border":"element_blank","panel.grid.arrow":false,"panel.grid.colour":"grey92","panel.grid.minor.arrow":false,"panel.grid.minor.linewidth":0.5,"panel.ontop":false,"panel.spacing":"5.5","plot.background":"element_blank","plot.caption.hjust":1,"plot.caption.margin":5.5,"plot.caption.size":12,"plot.caption.vjust":5.5,"plot.caption.position":"panel","plot.margin":5.5,"plot.subtitle.hjust":0,"plot.subtitle.margin":5.5,"plot.subtitle.vjust":1,"plot.tag.hjust":0.5,"plot.tag.size":14,"plot.tag.vjust":0.5,"plot.tag.position":"topleft","plot.title.hjust":0,"plot.title.margin":5.5,"plot.title.size":12,"plot.title.vjust":1,"plot.title.position":"panel","rect.colour":"black","rect.fill":"white","rect.linetype":1,"rect.linewidth":0.5,"strip.background":"element_blank","strip.clip":"inherit","strip.placement":"inside","strip.switch.pad.grid":2.75,"strip.switch.pad.wrap":2.75,"strip.text.colour":"grey10","strip.text.margin":4.4,"strip.text.size":12,"strip.text.y.angle":-90,"strip.text.y.left.angle":90,"text.angle":0,"text.colour":"black","text.debug":false,"text.face":"plain","text.family":"","text.hjust":0.5,"text.lineheight":0.9,"text.margin":0,"text.size":12,"text.vjust":0.5},wsj:{"axis.line.arrow":false,"axis.line.y":"element_blank","axis.minor.ticks.length":0.75,"axis.text.face":"bold","axis.text.size":12,"axis.text.r.hjust":0.5,"axis.text.r.margin":2.4,"axis.text.x.margin":2.4,"axis.text.x.vjust":1,"axis.text.x.top.margin":2.4,"axis.text.x.top.vjust":0,"axis.text.y.hjust":1,"axis.text.y.margin":2.4,"axis.text.y.right.hjust":0,"axis.text.y.right.margin":2.4,"axis.ticks.arrow":false,"axis.ticks.length":"3","axis.ticks.x.arrow":false,"axis.ticks.y":"element_blank","axis.title":"element_blank","axis.title.x.margin":3,"axis.title.x.vjust":1,"axis.title.x.top.margin":3,"axis.title.x.top.vjust":0,"axis.title.y.angle":90,"axis.title.y.margin":3,"axis.title.y.vjust":1,"axis.title.y.right.angle":-90,"axis.title.y.right.margin":3,"axis.title.y.right.vjust":1,"legend.background.colour":null,"legend.box":"vertical","legend.box.background":"element_blank","legend.background.linewidth":6,"legend.box.margin":null,"legend.box.spacing":12,"legend.direction":"horizontal","legend.justification":"center","legend.key.size":"1.2lines","legend.key.spacing":"6","legend.margin":6,"legend.position":"top","legend.spacing":12,"legend.text.size":12,"legend.ticks.length":0.2,"legend.title.hjust":0,"line.arrow":false,"line.colour":"black","line.lineend":"butt","line.linetype":1,"line.linewidth":"0.545454545454545","panel.border.fill":null,"panel.grid.arrow":false,"panel.grid.linetype":"3","panel.grid.major.arrow":false,"panel.grid.major.colour":"black","panel.grid.major.x":"element_blank","panel.grid.minor":"element_blank","panel.ontop":false,"panel.spacing":"6","plot.caption.hjust":1,"plot.caption.margin":6,"plot.caption.size":12,"plot.caption.vjust":null,"plot.caption.position":"panel","plot.margin":null,"plot.subtitle.hjust":0,"plot.subtitle.margin":6,"plot.subtitle.vjust":1,"plot.tag.hjust":0.5,"plot.tag.size":14,"plot.tag.vjust":0.5,"plot.tag.position":"topleft","plot.title.face":"bold","plot.title.hjust":0,"plot.title.margin":6,"plot.title.size":12,"plot.title.vjust":1,"plot.title.position":"panel","rect.colour":null,"rect.fill":"#f8f2e4","rect.linetype":0,"rect.linewidth":"0.545454545454545","strip.clip":"inherit","strip.placement":"inside","strip.switch.pad.grid":"3","strip.switch.pad.wrap":"3","strip.text.margin":4.8,"strip.text.size":12,"strip.text.y.angle":-90,"strip.text.y.left.angle":90,"text.angle":0,"text.colour":"black","text.debug":false,"text.face":"plain","text.family":"sans","text.hjust":0.5,"text.lineheight":0.9,"text.margin":0,"text.size":12,"text.vjust":0.5,"title.family":"mono","title.size":24},tableau:{"axis.line":"element_blank","axis.minor.ticks.length":0.75,"axis.text.colour":"grey30","axis.text.size":12,"axis.text.r.hjust":0.5,"axis.text.r.margin":2.2,"axis.text.x.margin":2.2,"axis.text.x.vjust":1,"axis.text.x.top.margin":2.2,"axis.text.x.top.vjust":0,"axis.text.y.hjust":1,"axis.text.y.margin":2.2,"axis.text.y.right.hjust":0,"axis.text.y.right.margin":2.2,"axis.ticks.arrow":false,"axis.ticks.colour":"grey20","axis.ticks.length":2.75,"axis.title.x.margin":2.75,"axis.title.x.vjust":1,"axis.title.x.top.margin":2.75,"axis.title.x.top.vjust":0,"axis.title.y.angle":90,"axis.title.y.margin":2.75,"axis.title.y.vjust":1,"axis.title.y.right.angle":-90,"axis.title.y.right.margin":2.75,"axis.title.y.right.vjust":1,"legend.background.colour":null,"legend.box.background":"element_blank","legend.background.linewidth":5.5,"legend.box.margin":null,"legend.box.spacing":11,"legend.justification":"center","legend.key.size":"1.2lines","legend.key.spacing":"5.5","legend.margin":5.5,"legend.position":"right","legend.spacing":11,"legend.text.size":12,"legend.ticks.length":0.2,"legend.title.hjust":0,"line.arrow":false,"line.colour":"black","line.lineend":"butt","line.linetype":1,"line.linewidth":0.5,"panel.background.colour":null,"panel.background.fill":"grey92","panel.border":"element_blank","panel.grid.arrow":false,"panel.grid.colour":"white","panel.grid.minor.arrow":false,"panel.grid.minor.linewidth":0.5,"panel.ontop":false,"panel.spacing":"5.5","plot.background.colour":"white","plot.caption.hjust":1,"plot.caption.margin":5.5,"plot.caption.size":12,"plot.caption.vjust":5.5,"plot.caption.position":"panel","plot.margin":5.5,"plot.subtitle.hjust":0,"plot.subtitle.margin":5.5,"plot.subtitle.vjust":1,"plot.tag.hjust":0.5,"plot.tag.size":14,"plot.tag.vjust":0.5,"plot.tag.position":"topleft","plot.title.hjust":0,"plot.title.margin":5.5,"plot.title.size":12,"plot.title.vjust":1,"plot.title.position":"panel","rect.colour":"black","rect.fill":"white","rect.linetype":1,"rect.linewidth":0.5,"strip.background.colour":null,"strip.background.fill":"grey85","strip.clip":"inherit","strip.placement":"inside","strip.switch.pad.grid":2.75,"strip.switch.pad.wrap":2.75,"strip.text.colour":"grey10","strip.text.margin":4.4,"strip.text.size":12,"strip.text.y.angle":-90,"strip.text.y.left.angle":90,"text.angle":0,"text.colour":"black","text.debug":false,"text.face":"plain","text.family":"","text.hjust":0.5,"text.lineheight":0.9,"text.margin":0,"text.size":12,"text.vjust":0.5},stata:{"axis.line.arrow":false,"axis.minor.ticks.length":0.75,"axis.text.size":12,"axis.text.r.hjust":0.5,"axis.text.r.margin":2.4,"axis.text.x.colour":"black","axis.text.x.margin":2.4,"axis.text.x.vjust":1,"axis.text.x.top.margin":2.4,"axis.text.x.top.vjust":0,"axis.text.y.angle":90,"axis.text.y.colour":"black","axis.text.y.hjust":1,"axis.text.y.margin":2.4,"axis.text.y.vjust":0.5,"axis.text.y.right.hjust":0,"axis.text.y.right.margin":2.4,"axis.ticks.arrow":false,"axis.ticks.length":2.75,"axis.ticks.x.arrow":false,"axis.ticks.x.colour":"black","axis.ticks.y.arrow":false,"axis.ticks.y.colour":"black","axis.title.colour":"black","axis.title.size":12,"axis.title.x.margin":3,"axis.title.x.vjust":1,"axis.title.x.top.margin":3,"axis.title.x.top.vjust":0,"axis.title.y.angle":90,"axis.title.y.margin":3,"axis.title.y.vjust":0,"axis.title.y.right.angle":-90,"axis.title.y.right.margin":3,"axis.title.y.right.vjust":1,"legend.background.colour":"black","legend.background.linetype":1,"legend.background.linewidth":null,"legend.box":"vertical","legend.box.background":"element_blank","legend.box.margin":null,"legend.box.spacing":12,"legend.justification":"center","legend.key.colour":null,"legend.key.fill":"white","legend.key.linetype":0,"legend.key.size":"1.2lines","legend.key.spacing":"6","legend.key.linewidth":6,"legend.margin":6,"legend.position":"bottom","legend.spacing":"0.012npc","legend.text.size":12,"legend.ticks.length":0.2,"legend.title.hjust":0.5,"legend.title.size":14,"line.arrow":false,"line.colour":"black","line.lineend":"butt","line.linetype":1,"line.linewidth":0.5,"panel.background.colour":null,"panel.background.fill":"white","panel.background.linetype":1,"panel.border":"element_blank","panel.grid.arrow":false,"panel.grid.major.arrow":false,"panel.grid.major.colour":"#eaf2f3","panel.grid.major.x":"element_blank","panel.grid.minor":"element_blank","panel.ontop":false,"panel.spacing":"0.25lines","plot.background.colour":null,"plot.background.fill":"#eaf2f3","plot.background.linetype":0,"plot.caption.hjust":0,"plot.caption.margin":6,"plot.caption.size":10,"plot.caption.vjust":null,"plot.caption.position":"panel","plot.margin":null,"plot.subtitle.hjust":0.5,"plot.subtitle.margin":6,"plot.subtitle.size":12,"plot.subtitle.vjust":1,"plot.tag.hjust":0.5,"plot.tag.size":14,"plot.tag.vjust":0.5,"plot.tag.position":"topleft","plot.title.hjust":0.5,"plot.title.margin":6,"plot.title.size":12,"plot.title.vjust":1,"plot.title.position":"panel","rect.colour":"black","rect.fill":"white","rect.linetype":1,"rect.linewidth":0.5,"strip.background.colour":null,"strip.background.fill":"#d9e6eb","strip.background.linetype":1,"strip.clip":"inherit","strip.placement":"inside","strip.switch.pad.grid":"3","strip.switch.pad.wrap":"3","strip.text.margin":4.8,"strip.text.size":12,"strip.text.x.vjust":0.5,"strip.text.y.angle":-90,"strip.text.y.left.angle":90,"text.angle":0,"text.colour":"black","text.debug":false,"text.face":"plain","text.family":"sans","text.hjust":0.5,"text.lineheight":1,"text.margin":0,"text.size":12,"text.vjust":1,"title.colour":"#1e2d53"},ggblanket:{"axis.line.y.left":"element_blank","axis.line.y.right":"element_blank","axis.minor.ticks.length":0.75,"axis.minor.ticks.y.left":"element_blank","axis.minor.ticks.y.right":"element_blank","axis.text.r.hjust":0.5,"axis.text.r.margin":2.2,"axis.text.x.margin":11,"axis.text.x.vjust":1,"axis.text.x.top.margin":3.3,"axis.text.x.top.vjust":0,"axis.text.y.hjust":1,"axis.text.y.margin":2.75,"axis.text.y.right.hjust":0,"axis.text.y.right.margin":2.75,"axis.ticks.length":2.75,"axis.ticks.length.x":"3.66666666666667","axis.ticks.length.y":2.75,"axis.ticks.y.left":"element_blank","axis.ticks.y.right":"element_blank","axis.title.x.margin":8.25,"axis.title.x.top.margin":11,"axis.title.y.angle":90,"axis.title.y.margin":11,"axis.title.y.right.angle":-90,"axis.title.y.right.margin":11,"legend.background.colour":null,"legend.background.linewidth":0,"legend.box.margin":0,"legend.byrow":false,"legend.direction":"vertical","legend.justification":[0,1],"legend.key.colour":"#FFFFFF","legend.key.fill":"#FFFFFF","legend.key.size":19.25,"legend.key.spacing.x":"3.63","legend.key.spacing.y":"3.63","legend.location":"panel","legend.key.linewidth":8.25,"legend.margin":8.25,"legend.position":"right","legend.spacing":11,"legend.text.margin":5.5,"legend.ticks.length":"3.38461538461538","legend.title.margin":5.5,"legend.title.position":"top","line.arrow":false,"line.colour":"#121B24","line.lineend":"square","line.linetype":1,"line.linewidth":"0.333333333333333","panel.background.colour":"#FFFFFF","panel.background.fill":"#FFFFFF","panel.border":"element_blank","panel.grid.arrow":false,"panel.grid.colour":"#F6F8FA","panel.grid.linewidth":"4","panel.grid.major.x":"element_blank","panel.grid.minor":"element_blank","panel.grid.minor.x":"element_blank","panel.ontop":false,"panel.spacing":"22","plot.caption.colour":"#121B24BF","plot.caption.hjust":0,"plot.caption.margin":5.5,"plot.caption.size":10,"plot.caption.position":"plot","plot.caption.vjust":22,"plot.margin":22,"plot.subtitle.hjust":0,"plot.subtitle.margin":22,"plot.tag.hjust":0,"plot.tag.size":14,"plot.tag.vjust":0.5,"plot.tag.position":"topleft","plot.title.face":"bold","plot.title.hjust":0,"plot.title.margin":27.5,"plot.title.size":14,"plot.title.position":"plot","rect.colour":"#FFFFFF","rect.fill":"#FFFFFF","rect.linetype":1,"rect.linewidth":"0.333333333333333","strip.background.colour":null,"strip.background.fill":null,"strip.clip":"inherit","strip.placement":"outside","strip.switch.pad.grid":"0.15","strip.switch.pad.wrap":"0.15","strip.text.margin":7.26,"strip.text.x.bottom.margin":11,"strip.text.y.angle":-90,"strip.text.y.margin":7.3333,"strip.text.y.left.angle":90,"strip.text.y.left.margin":7.3333,"text.angle":0,"text.colour":"#121B24","text.debug":false,"text.face":"plain","text.family":"","text.hjust":0.5,"text.lineheight":0.9,"text.margin":0,"text.size":12,"text.vjust":0.5},cx:{"axis.line":"#337AB7","axis.minor.ticks.length":0.75,"axis.text.colour":"grey30","axis.text.size":12,"axis.text.r.hjust":0.5,"axis.text.r.margin":2.2,"axis.text.x.margin":2.2,"axis.text.x.vjust":1,"axis.text.x.top.margin":2.2,"axis.text.x.top.vjust":0,"axis.text.y.hjust":1,"axis.text.y.margin":2.2,"axis.text.y.right.hjust":0,"axis.text.y.right.margin":2.2,"axis.ticks.arrow":false,"axis.ticks.colour":"#337AB7","axis.ticks.length":2.75,"axis.title.x.margin":2.75,"axis.title.x.vjust":1,"axis.title.x.top.margin":2.75,"axis.title.x.top.vjust":0,"axis.title.y.angle":90,"axis.title.y.margin":2.75,"axis.title.y.vjust":1,"axis.title.y.right.angle":-90,"axis.title.y.right.margin":2.75,"axis.title.y.right.vjust":1,"legend.background.colour":null,"legend.box.background":"element_blank","legend.background.linewidth":5.5,"legend.box.margin":null,"legend.box.spacing":11,"legend.justification":"center","legend.key.size":"1.2lines","legend.key.spacing":"5.5","legend.margin":5.5,"legend.position":"right","legend.spacing":11,"legend.text.size":12,"legend.ticks.length":0.2,"legend.title.hjust":0,"line.arrow":false,"line.colour":"black","line.lineend":"butt","line.linetype":1,"line.linewidth":0.5,"panel.background.colour":null,"panel.background.fill":"grey92","panel.border":"#337AB7","panel.grid.arrow":false,"panel.grid.colour":"white","panel.grid.minor.arrow":false,"panel.grid.minor.linewidth":0.5,"panel.ontop":false,"panel.spacing":"5.5","plot.background.colour":"white","plot.caption.hjust":1,"plot.caption.margin":5.5,"plot.caption.size":12,"plot.caption.vjust":5.5,"plot.caption.position":"panel","plot.margin":5.5,"plot.subtitle.hjust":0,"plot.subtitle.margin":5.5,"plot.subtitle.vjust":1,"plot.tag.hjust":0.5,"plot.tag.size":14,"plot.tag.vjust":0.5,"plot.tag.position":"topleft","plot.title.hjust":0,"plot.title.margin":5.5,"plot.title.size":12,"plot.title.vjust":1,"plot.title.position":"panel","rect.colour":"black","rect.fill":"white","rect.linetype":1,"rect.linewidth":0.5,"strip.background.colour":null,"strip.background.fill":"grey85","strip.clip":"inherit","strip.placement":"inside","strip.switch.pad.grid":2.75,"strip.switch.pad.wrap":2.75,"strip.text.colour":"grey10","strip.text.margin":4.4,"strip.text.size":12,"strip.text.y.angle":-90,"strip.text.y.left.angle":90,"text.angle":0,"text.colour":"black","text.debug":false,"text.face":"plain","text.family":"","text.hjust":0.5,"text.lineheight":0.9,"text.margin":0,"text.size":12,"text.vjust":0.5}};CanvasXpress.R={lty:[[0,0],[],[8,6],[1,3],[1,3,5,3],[14,6],[4,3,8,3]],ltyNames:["blank","solid","dashed","dotted","dotdash","longdash","twodash"]};CanvasXpress.digest=["007ecc86b2c1a7aad6c42d4b41e2786b","02e021e56cae76338f0e6d96f89600f9","0509351bd79c7731e5e174e3582fb4dc","07808a40a7802f68929c7ee651267d07","0b30135ab683cb27d8b50777eaa35b77","0dc09f39a70b90bfedb41dc44538c311","0f4562977345c7e8840f46a25454c5df","0ff9c7f41032cfd102b1bd29a69ef3c8","18f76dc521597e11876f6b634dab0fa0","19d74afa8005baea14b1836b9ac42276","1c32795bd3f33abb594d8a70d542784d","1dc810c9aa9eb24873dd4e749e319744","2109f9f138edb1e9ba42760b46e0231a","25ebeece10cd6266c5ae14e987ebb04e","273dfefbaac8ae8df8ad4e95dc6ffc1c","2763ced804923685c93cb00677d1feac","308da4b7c3c2202b9916da555c67e471","30ab087c0bc7145da56f14ec47c283ca","33ce8bbbcf864286276924eeebc095cb","37e864417369dc2cfd6880850803b824","38c85dde7930ea4d6b57cc0a45ea3416","3b2f63768a544ee9f0b53d00af3e9969","3ebd30b3cfb651963918ce5b998382aa","3ec73e87e998f1a75f70aab03ff50c4c","4011dbb678e80a0847b72a110d65bbdf","431011fea17845801f89121a77709167","46969b2dd9abb3b1ca8f1a6990d891ab","51a6dc1b0b50349f62278ed43bc9824d","540dd24407bc77f721741e47b6176d2b","54559ff15f8a33508e6322495830c65d","58124fa2029e2cf1f9ddee9df6ef56df","5ccc4e8ca3dcfc3ae1aa37d89da43ae6","5e2bada30cb42595f37a3ec589a7a9c3","5e76cf277f8b5fc31b78034354f7816b","5ede9db6a9dc3ae5f507c1aadfd6b3f2","64263e347d22a9714b2e684d1b77e4cc","65aea115c69b710461fac597b2a40a63","65b0751e7b6544376b23ed53a7dc17c1","65c1a5db75f8a315fcba1e54264e05c1","66d37d970bf29476173843b26ae827d5","66f35e29d2bcf3702c1d8e43f5a16726","67ade69420963398795b1790c6991de0","6ad8f5307c998451df24f00dbe3cf3a7","6d2cce2ae2a9a528359ea5a5d4d904a3","6da17092c6d9e492d7491b5ad2bd368e","6e239d1d18f8b847ab5b6a90a63bfd00","7298c333cc4ba018c79da24359f511c6","749fb6a2c1e1960612220deacf7fb7cb","7739eed764e6a471a5fc0f6acf427edb","7c1368cdbc23988b15934bf7655c765b","7d2f3573da31f029cc49548ab0751f99","7e29f68790cf3247b6341dbf66738421","7f1814d66d7ce11f445a7ec130d3aacf","83fa9eccf1369a99e32fdc5bc76b47eb","840ac2e46c2ddbd911448645e4ed6d33","86231e4e85e810a36e7841862dc8cd66","899598da8752716ddf2c7c7256b170d9","8a69eefb42c9769fd8c705ffb595e734","8dc0e97ca4905ce660a227ab26d3678b","925eced05449b54a5781bad8ffd18a9f","9354fb80a95dac79c9acab36ccb205c6","943c4b6b7418a276de73288040b2a9a8","951fb3c19d46ad8bb36f97987866d06a","9914a7cf5284d1aadaee00be40b4411c","a17b92e53e718af4ffe23c9c9611ee4b","a42e64c61cb0c4d713a12f3b6cc0c88f","ab0689d3b3371ffaabbb77b860ce5758","af7481ba4d98f10bb4a016892e93e0a5","b3da203bee8b8c92b4b9fcd8ea7a01bf","b5f872b25d7dfeb601eda1d748651845","b79514dc4e215ce68db9e65fb040f916","b9778e3e022946944ecc315f78404ce3","b9d0c7ad23530e2b0acefdb18046712d","bc81694926b907da7b49b82d16aef6fe","c09f312228617151f48d19f805b1c5ca","c26d15f28859dca2d135414d8fe58498","c594d73eac2c8c1481319f58be7d143f","c6774b26a5084ba8353e99724d255ffb","c76cbe8db5aa853c69ed4ac1f5f0407a","ca943509c96f00027e7f88fe22306d5e","cb87892bffd0d78cbcf6318186025897","cc58bfe503a792f24c09992e1f7cfcbd","cd74422ef9ec928adcd81d4bb3e264f3","d723a0e01daea6997ccb3a8ee0ffe98b","d7b76c9fd9cd231cf5d5fabcf8bd9e49","da205a486433b88adfc1b0148ec7a6bc","de6553e10fb1401664367e1de6cd3391","df1eb9ee10377b8a650bec599aa46eea","e3db9d806f90132e3999345f88a39137","e80f0df23f06b378d648b695483a6fdd","eb7b3a7910410363d7d3630d7e17020c","eb905a4e457a0e04960fe704ea3c4e70","f2e3e1f6083bdca6f7ea3fc79af27147","f760fb6f46776c97fba5a709e3418ead","f943122dda30f6b63f7fd34f28dd20dd","fbe4ac217f5a2aba22f833b0651da7d1","fc96c6550d5468025e501bc398bfd54e","fd597fa6af8ca2e0f0f145b3636c6a87"];CanvasXpress.factory=CanvasXpress.factory||{version:50.5,buildDate:"06-19-2024",client:"",siteSrc:false,valid:typeof window.cX=="string"?window.cX:undefined,href:window.location.href};CanvasXpress.factory.services="https://www.canvasxpress.org/cgi-bin/services.pl";CanvasXpress.prototype.init=function(f,d,b,c,e,h,g,a){this.initialize=function(j){try{CanvasXpress}catch(i){return false}CanvasXpress.instances.push(this);this.initStart();this.initData();this.initAesthetics();this.initScale();this.initGeometry();this.initStatistics();this.initFacets();this.initCoordinates();this.initTheme();this.initRender();this.initUI();this.initProcess(j)};if(!f){throw new Error("No target provided")}else{if(typeof(f)=="object"&&f.isGGPlot){return new cxplot(f)}else{this.initialize(CanvasXpress.createObject(f,d,b,c,e,h,g,a))}}};CanvasXpress.prototype.initProcess=function(a){this.wu=function(b){this.target=b.target;this.events=b.events;this.info=b.info;this.userId=1;this.url={};this.meta={ids:{},time:{start:parseInt(performance.timeOrigin),current:0,end:null,elapsed:[]},data:false,canvas:{},config:{user:b.config,orig:{},vals:{},remote:false},ggplot:{aes:{},config:[],coords:[],data:[],facet:[],geoms:[],labels:{},layers:{},order:{},scales:[],theme:[],map:{}},vals:{},render:{objects:[],groups:{},types:{},order:[],map:{},origin:[],transition:false},console:[],events:{},stack:[],def:{},dom:{},layout:{}};this.config={};this.legend={color:{},shape:{},size:{},sample:{},variable:{},line:{},pattern:{},outline:{},connect:{},contour:{},bin2d:{},decoration:{},oncoprint:{},overlays:{},colorNode:{},shapeNode:{},sizeNode:{},patternNode:{},colorEdge:{},sizeEdge:{},colorLabel:{},sizeLabel:{}};this.scales={};this.panel={};this.plot={}};this.GW=function(b){var e=this.meta.time.current||performance.now();if(!b){b=""}var d=performance.now();this.meta.time.elapsed.push([b,parseInt(d-e),parseInt(d)]);this.meta.time.current=d};this.gh=function(b){this.qS(b);this.eg(b);this.jk(b);this.sK(b);this.hu(b)};this.qS=function(c){if(typeof(c.data)=="function"){try{c.data=c.data.call(this)}catch(b){alert("Not a valid Data object:\n"+b)}}else{if(!c.noValidate){try{JSON.stringify(c.data)}catch(b){alert("Data object malformed:\n"+b)}}}};this.eg=function(c){if(c.config){if(typeof(c.config)=="function"){try{c.config=c.config.call(this)}catch(b){alert("Not a valid Data object:\n"+b)}}else{if(!c.noValidate){try{JSON.stringify(c.config)}catch(b){alert("Config object malformed:\n"+b)}}}}};this.jk=function(b){};this.sK=function(b){if(!b.info){b.info=""}};this.hu=function(c){if(c.afterRender){try{JSON.stringify(c.afterRender)}catch(b){alert("AfterRender object malformed:\n"+b)}}};this.Vs=function(b){if(!b){b=this}if(b.transposeData){return true}if(b.transformData){}if(b.asSampleFactors&&b.asSampleFactors.length){return true}if(b.asVariableFactors&&b.asVariableFactors.length){return true}if(b.stringSampleFactors&&b.stringSampleFactors.length){return true}if(b.stringVariableFactors&&b.stringVariableFactors.length){return true}if(b.stringNodeAttributes&&b.stringNodeAttributes.length){return true}if(b.stringEdgeAttributes&&b.stringEdgeAttributes.length){return true}if(b.showHistogram){return true}if(b.ridgeBy){return true}if(b.sortData&&b.sortData.length){return true}if(b.asDOE){}return false};this.lA=function(e){var d=[];if(e.showHistogram||e.ridgeBy){if(e.showHistogram===true&&e.colorBy){d.unshift(["createHistogram",[false,true],{}])}else{d.unshift(["createHistogram",[e.ridgeBy||e.showHistogram||e.colorBy,true],{}])}}if(e.stringVariableFactors&&e.stringVariableFactors.length){for(var b=0;b<e.stringVariableFactors.length;b++){d.unshift(["switchNumericToString",[e.stringVariableFactors[b]],{}])}}if(e.stringSampleFactors&&e.stringSampleFactors.length){for(var b=0;b<e.stringSampleFactors.length;b++){d.unshift(["switchNumericToString",[e.stringSampleFactors[b],true],{}])}}if(e.stringNodeAttributes&&e.stringNodeAttributes.length){for(var b=0;b<e.stringNodeAttributes.length;b++){d.unshift(["switchNumericToString",[e.stringNodeAttributes[b],false],{}])}}if(e.stringEdgeAttributes&&e.stringEdgeAttributes.length){for(var b=0;b<e.stringEdgeAttributes.length;b++){d.unshift(["switchNumericToString",[e.stringEdgeAttributes[b],true],{}])}}if(e.asVariableFactors&&e.asVariableFactors.length){for(var b=0;b<e.asVariableFactors.length;b++){d.unshift(["switchVarToAnnotation",[e.asVariableFactors[b]],{}])}}if(e.asSampleFactors&&e.asSampleFactors.length){for(var b=0;b<e.asSampleFactors.length;b++){d.unshift(["switchSmpToAnnotation",[e.asSampleFactors[b]],{}])}}if(e.transposeData){d.unshift(["transpose",[false,true],{}])}if(e.transformData){d.unshift(["transform",[e.transformData,e.transformAxis,false,true],{}])}if(e.sortData&&e.sortData.length){for(var b=0;b<e.sortData.length;b++){d.push(["modifySort",[e.sortData[b][0],e.sortData[b][1],e.sortData[b][2],false,b==this.sortData.length-1?true:false],{}])}}if(e.asDOE){d.push(["createDOE",[],{}])}return d};this.AH=function(){if(this.isCxplot&&this.meta.config.user.aes){var b=this.meta.config.user.aes;if(b.stringVariableFactors){this.stringVariableFactors=this.gg(b.stringVariableFactors)}if(b.stringSampleFactors){this.stringSampleFactors=this.gg(b.stringSampleFactors)}if(b.asVariableFactors){this.asVariableFactors=this.gg(this.asVariableFactors)}if(b.asSampleFactors){this.asSampleFactors=this.gg(b.asSampleFactors)}}};this.yh=function(b){var g=this;var r=function(){if(g.selectedDataPoints.length){var t=false;var c=g.xAxisIndices&&g.xAxisIndices.length?g.xAxisIndices[0]:0;var A=g.yAxisIndices&&g.yAxisIndices.length?g.yAxisIndices[0]:1;for(var v=0;v<g.selectedDataPoints.length;v++){var z=g.FP(g.selectedDataPoints[v]);if(z>=0){g.fW([z,c,A]);t=true}}if(t){b.unshift(["broadcastDraw",[{func:"afterRender"}],{},n,true])}}};this.afterRendering=true;if(!b){b=[]}var n=this.meta.time.start;var l=this.graphType=="Scatter2D"&&this.scatterType=="visium";this.AH();if(this.showHistogram||this.ridgeBy){if(this.showHistogram===true){b.push(["createHistogram",[false],{},n,true])}else{b.push(["createHistogram",[this.ridgeBy||this.showHistogram],{},n,true])}}if(this.stringVariableFactors.length){for(var u=0;u<this.stringVariableFactors.length;u++){b.unshift(["switchNumericToString",[this.stringVariableFactors[u],false],{},n,true])}this.stringVariableFactors=[];this.layoutRestore=false}if(this.stringSampleFactors.length){for(var u=0;u<this.stringSampleFactors.length;u++){b.unshift(["switchNumericToString",[this.stringSampleFactors[u],true],{},n,true])}this.stringSampleFactors=[];this.layoutRestore=false}if(this.stringNodeAttributes.length){for(var u=0;u<this.stringNodeAttributes.length;u++){b.unshift(["switchNumericToString",[this.stringNodeAttributes[u],false],{},n,true])}this.stringNodeAttributes=[];this.layoutRestore=false}if(this.stringEdgeAttributes.length){for(var u=0;u<this.stringEdgeAttributes.length;u++){b.unshift(["switchNumericToString",[this.stringEdgeAttributes[u],true],{},n,true])}this.stringEdgeAttributes=[];this.layoutRestore=false}if(this.asVariableFactors.length){for(var u=0;u<this.asVariableFactors.length;u++){b.unshift(["switchVarToAnnotation",[this.asVariableFactors[u],false],{},n,true])}this.asVariableFactors=[];this.layoutRestore=false}if(this.asSampleFactors.length){for(var u=0;u<this.asSampleFactors.length;u++){b.unshift(["switchSmpToAnnotation",[this.asSampleFactors[u],false],{},n,true])}this.asSampleFactors=[];this.layoutRestore=false}if(this.transposeData){b.unshift(["transpose",[false,this.sortData.length||this.selectedDataPoints.length],{},n,true]);this.transposeData=false;delete (CanvasXpress.stack[this.target].config.transposeData)}if(this.sortData){for(var u=0;u<this.sortData.length;u++){b.push(["modifySort",[this.sortData[u][0],this.sortData[u][1],this.sortData[u][2],false,u==this.sortData.length-1?true:false],{},n,true])}this.sortData=[];delete (CanvasXpress.stack[this.target].config.sortData)}var j=b.length-1;var q=false;var e=false;for(var u=0;u<b.length;u++){var o=b[u];var h=o.shift();if(h){var s=o.length>0?o.shift():[];var f=o.length>0?o.shift():{};var d=o.length>0?o.shift():n;var k=o.length>0?o.shift():false;if(this.view=="table"&&h=="setDimensions"){continue}if(h=="clickView"){e=true;continue}if(h=="updateDataFilter"||h=="resetDataFilter"){this.skipRender=true}var p=b[u+1]&&b[u+1][0]&&b[u+1][0].match(/drag/i)?true:false;this.skipRender=h=="createDOE"||h=="createHistogram"||h=="modifyColorScheme"||h.match(/segregate/)||p?false:!this.showTransition&&u<j?true:this.view=="table"?false:false;if(h.match(/switch/)){this.skipRender=u<j?true:false}if(h.match(/updateConfig/)){this.skipRender=false}if(this.debug){this.skipRender=false}for(var w in f){this[w]=f[w]}if(h.match(/switch/)&&l&&u==j){q=true}if(this[h]){this[h].apply(this,s)}if(h.match(/switch|clickGraphMaxMin/)&&u==j&&!q){this.dG()}if(h=="moveCanvas"){CanvasXpress.stack[this.target].afterRender.push([h,s])}if(k){var m=CanvasXpress.stack[this.target].afterRender.length-1;CanvasXpress.stack[this.target].afterRender[m][4]=true}if(q){this.aE()}}}if(this.asDOE&&this.Ek()){this.o7(this.asDOE)}if(this.view=="table"){this.view="canvas";this.Zk()}else{if(this.view=="layout"){this.view="canvas";this.DY(false,false,"none")}}r();this.iS("afterRender");this.afterRendering=false};this.Hz=function(){if(window.location.search!=""){var d=location.search.substring(1).split("&");for(var c=0;c<d.length;c++){var b=d[c].split("=");if(!b[0]){continue}if(b[0].match(/^cX/)){this.url[b[0]]=b[1]||true}else{this.url[b[0]]=b[1]=="false"?false:b[1]=="true"?true:b[1]}}}};this.h3=function(){var e=CanvasXpress.alias.split("#");var l=e.pop().split("");var k=e.shift().split("");var p={};for(var d=0;d<l.length;d++){p[k[d]]=l[d]}for(var d=0;d<e.length;d++){var o=e[d].split("");var b=o.length;var m="";for(var c=0;c<b-2;c++){m+=p[o[c]]}var h=o[b-2]+o[b-1];if(this[h]){this[m]=this[h]}}};this.T4=function(){if(this.url.hasOwnProperty("cXprint")||this.printThumbnail){this.printThumbnail=false;var d=this.url.cXprint!==true&&this.url.cXprint!=="true"?this.url.cXprint:this.saveFilename?this.saveFilename:this.target+".png";var b=this;var e=function(c,f){b.r8(c,f);setTimeout(function(){window.close()},4000)};b.OX(false,d,e)}else{if(this.url.hasOwnProperty("cXprintBase64")||this.cacheBase64){this.cacheBase64=false;var e=function(){return};if(CanvasXpress.$(this.target)){this.OX(false,false,e)}}}};this.Ki=function(g,f){var c=this;var b=window;var d=c.$w;if(this.verbose){b[d(8)][d(31)][d(32)](g)}};this.iS=function(e,c){var d=this;var b=function(){var f=c||d;if(f.graphType=="Map"&&f.mapId&&!window[f.mapId]){return}if(f.fonts&&f.fonts.length>0&&!CanvasXpress.readyFonts){CanvasXpress.readyFonts=true;return}f.Ki("canvasXpress data ready - "+e);f.T4();CanvasXpress.ready=true};if(CanvasXpress.cacheImagesReady){if(e=="afterRender"){if(!this.isAnimation&&!this.isTransitionOn&&!this.isUpdateRemoteData){b()}}else{if(this.graphType=="Network"){if(!this.isAnimation&&!this.isUpdateRemoteData){b()}}else{if(!this.isTransitionOn){b()}}}}};this.fo=function(){CanvasXpress.stack[this.target].stateCX.push(this.sw())};this.dU=function(){var d=CanvasXpress.stack[this.target];var c=this.Vs();this.nb(false,false,false,false,false,false,c);this.yh(d.afterRenderInit);this.fo();CanvasXpress.current=this.target;this.meta.time.end=parseInt(performance.now());this.LC()};this.A2=function(){if(!this.lazyLoad||(!this.loaded&&this.ZT(this.meta.canvas.ctx.canvas))){this.dU()}};this.VL=function(c){var b=this;b.wu(c);b.GW("init");b.Hz();b.gh(c);b.KV();b.h3();b.dQ();b.Pn();b.us(c.config);b.KI();b.RG();b.AR();b.gK(c.data);b.GW("initData");b.nm();b.tC();b.qv();b.ON();b.GC(c.data,c.config,c.events,c.info,c.afterRender);b.IC();b.h3();b.A2()};this.VL(a)};CanvasXpress.prototype.initStart=function(){this.initIO();this.initCrypt();this.initDOM();this.initViewport();this.initConfig()};CanvasXpress.prototype.initDataset=function(){this.c9=function(){delete (this.meta.data);this.h4(false,false,false,true)};this.uY=function(c){if(c){this.meta.data={tracks:[]}}for(var I=0;I<this.data.tracks.length;I++){var y=this.data.tracks[I];var p={};if(y.type=="dataframe"){for(var F in y.dataframe){var J=y.dataframe[F];if(this.Hl(J)){var s=this.ID(J);var a=this[this.axisAlgorithm](s[0],s[1],5,this.isGraphTime,this.axisWilkinsonLoose);var q=[];for(var C=0;C<a.length;C++){q.push(a[C].toString())}var f=this.wS(q);var K=this.uo(f,this.xAxisTextFont);var B=Math.min(s[0],a[0]);var H=Math.max(s[1],a[a.length-1]);var A=(y.height||this.featureTypeDefault)/((H-B)*1.05);var h=this.s8(y.colorSpectrum||this.colorSpectrum,B,H,y.colorSpectrumZeroValue||this.colorSpectrumZeroValue,y.colorSpectrumBreaks||this.colorSpectrumBreaks,true);p[F]={type:"Numeric",range:s,values:a,valuesStr:q,maxValueStrLen:K,min:B,max:H,units:A,brew:h}}else{var b={};for(var C=0;C<J.length;C++){b[J[C]]=true}var x=this.Nf(b);var E={};var G=0;var L=0;var u="";for(var C=0;C<x.length;C++){E[x[C]]=C;var g=this.uo(x[C],this.xAxisTextFont);if(g>G){G=g;L=x[C].length;u=x[C]}}var e=[];for(var C=0;C<x.length;C++){if(y.meta&&y.meta.hasOwnProperty(F)&&y.meta[F].hasOwnProperty("color")&&y.meta[F].color.hasOwnProperty(x[C])){e.push(y.meta[F].color[x[C]])}else{e.push(this.colors[C%this.colors.length])}}var w=[];for(var C=0;C<x.length;C++){if(y.meta&&y.meta.hasOwnProperty(F)&&y.meta[F].hasOwnProperty("shape")&&y.meta[F].shape.hasOwnProperty(x[C])){w.push(y.meta[F].shape[x[C]])}else{w.push(this.shapes[C%this.shapes.length])}}p[F]={type:"String",levels:x,order:E,maxLevLen:G,maxLevChr:L,maxLevStr:u,colors:e,shapes:w,sizes:this.vD(x.length)}}}}else{if(y.type.match(/bar|heatmap/)){var J=y.data;var r=[];for(var D=0;D<J.length;D++){for(var C=0;C<J[D].data.length;C++){r.push(J[D].data[C])}}var s=this.ID(r);var a=this[this.axisAlgorithm](s[0],s[1],5,this.isGraphTime,this.axisWilkinsonLoose);var q=[];for(var D=0;D<a.length;D++){q.push(a[D].toString())}var f=this.wS(q);var K=this.uo(f,this.xAxisTextFont);var B=Math.min(s[0],a[0]);var H=Math.max(s[1],a[a.length-1]);var A=(y.height||this.featureTypeDefault)/((H-B)*1.05);var h=this.s8(y.colorSpectrum||this.colorSpectrum,B,H,y.colorSpectrumZeroValue||this.colorSpectrumZeroValue,y.colorSpectrumBreaks||this.colorSpectrumBreaks,true);p={range:s,values:a,valuesStr:q,maxValueStrLen:K,min:B,max:H,units:A,brew:h}}}this.meta.data.tracks.push(p)}};this.yi=function(p,N,L){var e=this;var P=this.meta.data;var x=this.data;var q=["nodes","edges"];var w=this.nodeFont;var D={x:true,y:true,z:true,width:true,height:true,eventless:true,color:true,hideLabel:true,imagePath:true,size:true,shape:true,endArrow:true,startArrow:true,elbows:true};var f=function(d){for(var a in d){if(d[a]["t"]=="Numeric"){var j=e.b6(d[a]["o"]);if(j.length==2&&(d[a]["o"].hasOwnProperty("true")&&d[a]["o"].hasOwnProperty("false"))){d[a]["t"]="String"}else{if(j.length==1&&(d[a]["o"].hasOwnProperty("true")||d[a]["o"].hasOwnProperty("false"))){d[a]["t"]="String"}else{if(j.length==1&&d[a]["o"].hasOwnProperty("")){d[a]["t"]="String"}}}}}return d};var K=function(a){var k={};for(var j=0;j<e.data[a].length;j++){var r=e.data[a][j];for(var d in r){if(D.hasOwnProperty(d)){continue}var l=r[d]===null?false:r[d];if(typeof(l)!="object"){if(k.hasOwnProperty(d)){if(!k[d]["o"].hasOwnProperty(l)){k[d]["o"][l]=true}if(isNaN(l)){k[d]["t"]="String"}}else{k[d]={o:{},t:isNaN(l)?"String":"Numeric"};k[d]["o"][l]=true}}else{if(!k.hasOwnProperty(d)){k[d]={o:{}}}k[d]["t"]="Object";for(var t in l){k[d]["o"][t]=true}}}}return f(k)};var c=function(d){var a=e.Nf(b[d]["o"]);if(e.legendOrder&&e.legendOrder[d]){var l=e.gg(e.legendOrder[d]);for(var j=0;j<a.length;j++){if(!l.includes(a[j])){l.push(a[j])}}return l}else{return a}};if(!p||p=="nodes"||p=="edges"){if(p&&L&&P[p][N]){delete (P[p][N])}for(var I=0;I<q.length;I++){var E=q[I];if(p){if(p!=E){continue}}if(x[E]){var b=K(E);for(var G in b){if(N){if(N!=G){continue}}mmk={};mmk.len=this.uo(G,w);mmk.type=b[G]["t"];var J=0;var O=0;var A="";if((this.colorKey&&this.colorKey.hasOwnProperty(G))||(this.legendOrder&&this.legendOrder.hasOwnProperty(G))){mmk.type="String"}if(mmk.type=="String"||mmk.type=="Object"){var B=c(G);mmk.unique=this.pv(B);mmk.levels=B;mmk.order={};for(var H=0;H<B.length;H++){mmk.order[B[H]]=H;var g=this.uo(B[H],w);if(g>J){J=g;O=B[H].length;A=B[H]}}mmk.maxLevLen=J;mmk.maxLevChr=O;mmk.maxLevStr=A;mmk.colors=[];var h=0;for(var H=0;H<B.length;H++){mmk.colors.push(this.colors[h%this.colors.length]);h++}if(this.colorKey&&this.colorKey.hasOwnProperty(G)){for(var H in this.colorKey[G]){if(mmk.order.hasOwnProperty(H)){mmk.colors[mmk.order[H]]=this.colorKey[G][H]}}}mmk.shapes=[];var h=0;for(var H=0;H<B.length;H++){mmk.shapes.push(this.shapes[h%this.shapes.length]);h++}if(this.shapeKey&&this.shapeKey.hasOwnProperty(G)){for(var H in this.shapeKey[G]){if(mmk.order.hasOwnProperty(H)){mmk.shapes[mmk.order[H]]=this.shapeKey[G][H]}}}mmk.sizes=this.vD(B.length,E=="edges");if(this.sizeKey&&this.sizeKey.hasOwnProperty(G)){for(var H in this.sizeKey[G]){if(mmk.order.hasOwnProperty(H)){mmk.sizes[mmk.order[H]]=this.sizeKey[G][H]}}}mmk.patterns=[];var h=0;for(var H=0;H<B.length;H++){mmk.patterns.push(this.patterns[h%this.patterns.length]);h++}if(this.patternKey&&this.patternKey.hasOwnProperty(G)){for(var H in this.patternKey[G]){if(mmk.order.hasOwnProperty(H)){mmk.patterns[mmk.order[H]]=this.patternKey[G][H]}}}}else{mmk.unique=false;var B=this.Nf(b[G]["o"]);var u=this.ID(B);mmk.rmin=u[0];mmk.rmax=u[1];mmk.n=B.length;var M=this.colorSpectrum;if(E=="edges"){mmk.colorBrew=this.s8(M,u[0],u[1])}else{mmk.colorBrew=this.s8(M,u[0],u[1],this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}mmk.min=mmk.colorBrew.min;mmk.max=mmk.colorBrew.max;mmk.zero=mmk.colorBrew.zero;mmk.vals=mmk.colorBrew.vals;mmk.incr=mmk.colorBrew.incr;mmk.decs=mmk.colorBrew.decs;mmk.levels=mmk.colorBrew.vals;mmk.order={};for(var H=0;H<mmk.levels.length;H++){mmk.order[mmk.levels[H]]=H;var g=this.uo(mmk.levels[H],w);if(g>J){J=g;O=mmk.levels[H].toString().length;A=mmk.levels[H]}mmk.maxLevLen=J;mmk.maxLevChr=O;mmk.maxLevStr=A}mmk.shapes=this.shapes;mmk.sizes=this.sizes;mmk.patterns=this.patterns}P[E][G]=mmk}}}}if(this.decorations.length&&this.decorationsType=="heatmap"){var s=[];P.decorations={};P.decorations.unique=false;P.decorations.type="Numeric";P.decorations.n=0;for(var H=0;H<this.decorations.length;H++){var G=this.decorations[H];if(P.nodes[G]&&P.nodes[G].type=="Numeric"){P.decorations.n+=P.nodes[G].n;s.push(P.nodes[G].rmin);s.push(P.nodes[G].rmax)}else{if(P.nodes[G]&&P.nodes[G].type=="Object"){for(var F=0;F<P.nodes[G].levels.length;F++){var y=P.nodes[G].levels[F];for(var C=0;C<x.nodes.length;C++){if(x.nodes[C][G]&&x.nodes[C][G].hasOwnProperty(y)&&x.nodes[C][G][y]&&!isNaN(x.nodes[C][G][y])){P.decorations.n++;s.push(x.nodes[C][G][y])}}}}}}if(s.length){var M=this.colorSpectrum;var u=this.ID(s);P.decorations.rmin=u[0];P.decorations.rmax=u[1];P.decorations.colorBrew=this.s8(M,u[0],u[1],this.colorSpectrumZeroValue,this.colorSpectrumBreaks);P.decorations.min=P.decorations.colorBrew.min;P.decorations.max=P.decorations.colorBrew.max;P.decorations.zero=P.decorations.colorBrew.zero;P.decorations.vals=P.decorations.colorBrew.vals;P.decorations.incr=P.decorations.colorBrew.incr;P.decorations.decs=P.decorations.colorBrew.decs;P.decorations.levels=P.decorations.colorBrew.vals;P.decorations.order={};for(var H=0;H<P.decorations.levels.length;H++){P.decorations.order[P.decorations.levels[H]]=H;var g=this.uo(P.decorations.levels[H],w);if(g>J){J=g;O=P.decorations.levels[H].toString().length;A=P.decorations.levels[H]}P.decorations.maxLevLen=J;P.decorations.maxLevChr=O;P.decorations.maxLevStr=A}}}};this.af=function(P,ag,ad,Q,ai){var K=this;var H=this.meta.config.user;var B=this.meta.data;var l=this.data;var D=CanvasXpress.colorSchemes;var p=["x","z","w"];var Z=this.font;var E=function(s,a,r,aj,al){var t={};if(K.legendOrder&&K.legendOrder[s]){for(var ak=0;ak<K.legendOrder[s].length;ak++){t[K.legendOrder[s][ak]]=ak}var j=K.legendOrder[s].length;if(a){for(var ak in a){if(!t.hasOwnProperty(ak)){t[ak]=j++}}}else{for(var ak=0;ak<r.length;ak++){if(!t.hasOwnProperty(r[ak])){t[ak]=j++}}}return t}else{if(K.isCxplot&&H.hasOwnProperty("aes")&&H.aes.hasOwnProperty("meta")&&H.aes.meta.hasOwnProperty(s)){var d={};var j=0;for(var ak=0;ak<H.aes.meta[s].length;ak++){if(a.hasOwnProperty(H.aes.meta[s][ak])){d[H.aes.meta[s][ak]]=j++}}return d}else{if(aj){var r=[];for(var ak in a){t[ak]=new Date(K.dateFormat(ak)).getTime();r.push(ak)}r=r.sort(function(am,k){return t[am]-t[k]});var d={};var j=0;for(var ak=0;ak<r.length;ak++){if(!d.hasOwnProperty(r[ak])){d[r[ak]]=j++}}return d}else{if(al){var r=K.b6(a);r=r.sort(function(am,k){return parseInt(CanvasXpress.dates[am])-parseInt(CanvasXpress.dates[k])});var d={};for(var ak=0;ak<r.length;ak++){d[r[ak]]=ak}return d}else{var r=K.b6(a);for(var ak=0;ak<r.length;ak++){if(!r[ak].match("\x00")){return false}}r=r.sort(function(am,k){return Number(am.replace("\x00",""))-Number(k.replace("\x00",""))});var d={};for(var ak=0;ak<r.length;ak++){d[r[ak]]=ak}return d}}}}};var aa=function(ak,d,r){if(K[ak+"Key"]&&K[ak+"Key"][V]){if(K.Ov(K[ak+"Key"][V])){r[ak+"By"]=K[ak+"Key"][V];for(var k=0;k<T.length;k++){if(!r[ak+"By"].hasOwnProperty(T[k])){var t=Number(T[k].replace("\x00",""));if(!r[ak+"By"].hasOwnProperty(t)){r[ak+"By"][T[k]]=d[k%d.length]}else{r[ak+"By"][T[k]]=r[ak+"By"][t]}}else{if(ak=="color"){r[ak+"By"][T[k]]=K.DF(r[ak+"By"][T[k]])}}}r[ak+"s"]=[];for(var k=0;k<T.length;k++){r[ak+"s"][k]=r[ak+"By"][T[k]]}}else{if(K.eO(K[ak+"Key"][V])){r[ak+"s"]=K[ak+"Key"][V]}else{if(ak=="color"){var aj=T.length;if(D[K[ak+"Key"][V]][aj]){r[ak+"s"]=D[K[ak+"Key"][V]][aj]}else{var s=K.b6(D[K[ak+"Key"][V]]);s.sort(function(al,j){return al-j});if(aj>s[s.length-1]){aj--;while(!D[K[ak+"Key"][V]][aj]){aj--}}else{if(aj<s[s.length-1]){aj++;while(!D[K[ak+"Key"][V]][aj]){aj++}}}r[ak+"s"]=D[K[ak+"Key"][V]][aj]}for(var k=0;k<aj;k++){r[ak+"s"][k]=K.DF(D[K[ak+"Key"][V]][aj][k])}}}}}else{r[ak+"s"]=[];var a=0;if(ak=="color"&&T.length>d.length&&d.length==1&&K.graphType=="Map"){var aj=T.length;var s=K.b6(D[K.colorScheme]);s.sort(function(al,j){return al-j});if(aj>s[s.length-1]){aj--;while(!D[K.colorScheme][aj]){aj--}}else{if(aj<s[s.length-1]){aj++;while(!D[K.colorScheme][aj]){aj++}}}for(var k=0;k<aj;k++){r[ak+"s"][k]=K.DF(D[K.colorScheme][aj][k])}}else{for(var k=0;k<d.length;k++){if(ak=="color"){r[ak+"s"].push(K.DF(d[a%d.length]))}else{r[ak+"s"].push(d[a%d.length])}a++}}}};var C=function(a,d,k){var al=K.colorSpectrum;if(K[a+"Key"]&&K[a+"Key"][V]){if(K.Ov(K[a+"Key"][V])){d[a+"By"]=K[a+"Key"][V];for(var t=0;t<k.length;t++){if(!d[a+"By"].hasOwnProperty(k[t].toString())){d[a+"By"][k[t].toString()]=K[a+"s"][t%K[a+"s"].length]}}d.orderS=E(V,false,k)}else{if(a=="color"){if(K.eO(K[a+"Key"][V])){al=K[a+"Key"][V]}else{var ak=K.b6(D[K[a+"Key"][V]]);ak.sort(function(am,j){return am-j});al=D[K[a+"Key"][V]].hasOwnProperty(8)?D[K[a+"Key"][V]][8]:D[K[a+"Key"][V]][ak[0]]}}}}if(a=="color"){d.colorBrew=K.s8(al,R[0],R[1],K.colorSpectrumZeroValue,K.colorSpectrumBreaks,true);var s=["min","max","zero","vals","incr","decs"];for(var t=0;t<s.length;t++){var r=s[t];d[r]=d.colorBrew[r]}d.levels=d.colorBrew.vals;d.order={};for(var t=0;t<d.levels.length;t++){d.order[d.levels[t]]=t;var aj=K.uo(d.levels[t],Z);if(aj>ah){ah=aj;c=d.levels[t].toString().length;ab=d.levels[t]}d.maxLevLen=ah;d.maxLevChr=c;d.maxLevStr=ab}}else{d[a+"s"]=a=="connect"?K.colors:K[a+"s"]}};if(!P||P=="w"||P=="x"||P=="z"){if(P&&ad){if(!ag){delete (B[P])}else{if(B[P][ag]){delete (B[P][ag])}}}for(var Y=0;Y<p.length;Y++){var U=p[Y];if(P){if(P!=U){continue}}Z=U=="z"?this.varTextFont:this.smpTextFont;var u=l[U];if(u){for(var V in u){if(ag){if(ag!=V){continue}}if(U=="w"){if(V!="smps"&&V!="grps"){continue}if(V=="grps"){J=u[V];B[U].smps={};for(var W=0;W<u.smps.length;W++){B[U].smps[u.smps[W]]=W}continue}}var J={origin:U,len:this.uo(V,Z)};var N=u[V];var ae=J.len;var b=V.length;var X=V;var ah=0;var c=0;var ab="";J.type=this.Hl(N)&&!this.ak(N)&&!this.ZR(N)?"Numeric":"String";if(J.type=="String"){this.Cl(U,V);J.unique=this.pv(N);J["boolean"]=this.f6(N);J.date=this.gZ(N);J.monthDay=this.a2(N);J.geo=this.kg(N)||this.ai(N);if(J["boolean"]&&this.isR){for(var W=0;W<N.length;W++){if(N[W]!=null){if(typeof(N[W])=="string"){if(N[W].toLowerCase()=="true"){N[W]=true}else{if(N[W].toLowerCase()=="false"){N[W]=false}else{N[W]=null}}}}}}var G=this.Rd(N);var q=this.Be(N);var e=E(V,G,false,J.date,J.monthDay);var T=this.Aw(this.b6(G));J.levels=e?T.sort(function(j,d){return e[j]-e[d]}):T;J.n=[];for(var W=0;W<J.levels.length;W++){J.n.push(G[J.levels[W]])}J.unordered=q;J.order={};for(var W=0;W<T.length;W++){J.order[T[W]]=e&&e.hasOwnProperty(T[W])?e[T[W]]:W;var F=this.uo(T[W],Z);if(F>ah){ah=F;c=T[W].length;ab=T[W]}}J.maxLevLen=ah;J.maxLevChr=c;J.maxLevStr=ab;aa("color",this.colors,J);aa("shape",this.shapes,J);aa("size",this.vD(T.length),J);aa("pattern",this.patterns,J);aa("linePattern",this.linePatterns,J);aa("connect",this.colors,J)}else{J.unique=false;J["boolean"]=false;for(var W=0;W<N.length;W++){N[W]=N[W]==null||N[W]==this.missingDataValue?Number.NaN:Number(N[W])}var R=this.ID(N);J.rmin=R[0];J.rmax=R[1];J.n=N.length;C("color",J,N);C("shape",J,N);C("size",J,N);C("pattern",J,N);C("linePattern",J,N);C("connect",J,N)}B[U][V]=J;if(!B.m[U]){B.m[U]={}}if(B.m[U].maxFacLen){if(ae>B.m[U].maxFacLen){B.m[U].maxFacLen=ae;B.m[U].maxFacChr=b;B.m[U].maxFacStr=X}}else{B.m[U].maxFacLen=ae;B.m[U].maxFacChr=b;B.m[U].maxFacStr=X}}}if(Q){return}var w,I,S;if(U=="z"){w="y";I="vars";S="Var"}if(U=="x"||U=="q"){w="y";I="smps";S="Smp"}if(U=="w"){w="w";I="smps";S="Smp"}var ah=0;var c=0;var ab="";if(l[w]){for(var W=0;W<l[w][I].length;W++){if(l[w][I].length>this.fullTextMeasureCheck){var M=l[w][I][W].toString().length;if(M>c){var F=this.uo(l[w][I][W],Z);if(F>ah){ah=F;c=M;ab=l[w][I][W]}}}else{if(l[w][I][W]!=null){var M=l[w][I][W].toString().length;if(M>=c){var F=this.uo(l[w][I][W].toString(),Z);if(F>ah){ah=F;c=M;ab=l[w][I][W].toString()}}}}}B[w]["max"+S+"Len"]=ah;B[w]["max"+S+"Chr"]=c;B[w]["max"+S+"Str"]=ab;B[w].vars=this.kg(l.y.vars)?"World":this.ai(l.y.vars)?"USA":this.gZ(l.y.vars)?"Date":"String";B[w].smps=this.kg(l.y.smps)?"World":this.ai(l.y.smps)?"USA":this.gZ(l.y.smps)?"Date":"String";if(U=="x"){var ac={};var A=l.y.smps;for(var W=0;W<A.length;W++){var R=this.ID(this.Jn(W));ac[A[W]]={min:R[0],max:R[1],type:"Numeric"};if(ai){ac[A[W]].time=ai[W]}}if(!B[w]["range"]){B[w]["range"]={}}this.z3(B[w]["range"],ac)}if(U=="z"){var ac={};var x=l.y.vars;for(var W=0;W<l.y.data.length;W++){var R=this.ID(l.y.data[W]);ac[x[W]]={min:R[0],max:R[1],type:"Numeric"}}if(!B[w]["range"]){B[w]["range"]={}}this.z3(B[w]["range"],ac)}if(U=="w"){var ac={};var g=[];var h=this.isGroupedData?this.data.w:this.data.y;if(this.layoutValid&&this.data.l&&this.data.l.smps){for(var W=0;W<this.data.l.smps.length;W++){g.push(W)}}else{g=this.isGroupedData&&this.grpIndices?this.grpIndices:this.smpIndices}var O=h.smps;for(var W=0;W<g.length;W++){var R=this.ID(this.uP(W));ac[O]={min:R[0],max:R[1],type:"Numeric"}}if(!B[w]["range"]){B[w]["range"]={}}this.z3(B[w]["range"],ac)}}}this.WP(P&&ag?this.meta.data[P][ag]:false)}else{if(P=="y"&&l.y){var ah=0;var c=0;var ab="";for(var W=0;W<l.y.vars.length;W++){if(l.y.vars.length>this.fullTextMeasureCheck){var M=l.y.vars[W].toString().length;if(M>c){var F=this.uo(l.y.vars[W],Z);if(F>ah){ah=F;c=M;ab=l.y.vars[W]}}}else{if(l.y.vars[W]!=null){var M=l.y.vars[W].toString().length;if(M>=c){var F=this.uo(l.y.vars[W],Z);if(F>ah){ah=F;c=M;ab=l.y.vars[W]}}}}}B.y.maxVarLen=ah;B.y.maxVarChr=c;B.y.maxVarStr=ab;B.y.vars=this.kg(l.y.vars)?"World":this.ai(l.y.vars)?"USA":this.gZ(l.y.vars)?"Date":"String";if(!B.y.range){B.y.range={}}for(var W=0;W<l.y.data.length;W++){var R=this.ID(l.y.data[W]);B.y.range[l.y.vars[W]]={};B.y.range[l.y.vars[W]].min=R[0];B.y.range[l.y.vars[W]].max=R[1];B.y.range[l.y.vars[W]].type="Numeric"}}else{if(l.y[P]){B[P]={};var ah=0;var c=0;var ab="";if(this.VJ(l.y[P])){for(var W=0;W<l.y[P].length;W++){for(var V=0;V<l.y[P][W].length;V++){if(l.y[P][W][V]!=null){l.y[P][W][V]=Number(l.y[P][W][V])}else{l.y[P][W][V]=Number.NaN}}}var R=this.yc(l.y[P]);B[P].rmin=R[0];B[P].rmax=R[1];B[P].n=l.y[P].length*l.y[P][0].length;B[P].type="Numeric";B[P].colorBrew=this.s8(this.colorSpectrum,R[0],R[1],null,false,true);var af=["min","max","zero","vals","incr","decs"];for(var W=0;W<af.length;W++){var f=af[W];B[P][f]=B[P].colorBrew[f]}B[P].levels=B[P].colorBrew.vals;B[P].order={};for(var W=0;W<B[P].levels.length;W++){B[P].order[B[P].levels[W]]=W;var F=this.uo(B[P].levels[W],Z);if(F>ah){ah=F;c=B[P].levels[W].toString().length;ab=B[P].levels[W]}B[P].maxLevLen=ah;B[P].maxLevChr=c;B[P].maxLevStr=ab}B[P].shapes=this.shapes;B[P].sizes=this.sizes;B[P].patterns=this.patterns}else{var T={};for(var W=0;W<l.y[P].length;W++){for(var V=0;V<l.y[P][W].length;V++){if(l.y[P][W][V]!=null){T[l.y[P][W][V]]=true}else{l.y[P][W][V]=""}}}T=this.Aw(this.b6(T));B[P].levels=T;B[P].order={};for(var W=0;W<T.length;W++){B[P].order[T[W]]=W;var F=this.uo(T[W],Z);if(F>ah){ah=F;c=T[W].length;ab=T[W]}}B[P].maxLevLen=ah;B[P].maxLevChr=c;B[P].maxLevStr=ab;B[P].type="String";B[P].colors=[];var L=0;for(var W=0;W<T.length;W++){B[P].colors.push(this.colors[L%this.colors.length]);L++}B[P].shapes=[];var L=0;for(var W=0;W<T.length;W++){B[P].shapes.push(this.shapes[L%this.shapes.length]);L++}var y=this.vD(T.length);B[P].sizes=[];var L=0;for(var W=0;W<T.length;W++){B[P].sizes.push(y[L%y.length]);L++}B[P].patterns=[];var L=0;for(var W=0;W<T.length;W++){B[P].patterns.push(this.patterns[L%this.patterns.length]);L++}}}else{alert("Error while setting metadata. This may not work!")}}}};this.k8=function(){if(!this.meta.data){if(this.graphType=="Network"){this.meta.data={nodes:{},edges:{},decorations:{}};this.yi()}else{if(this.graphType=="Genome"){this.meta.data={tracks:[]};this.uY()}else{if(this.graphType=="Venn"){}else{this.meta.data={w:{},x:{},y:{},z:{},m:{},p:{g:[],l:[],i:[]},l:[],q:{l:{},g:[],b:false,o:false},f:false,r:false,u:false,s:false,b:{l:[],g:false,c:false},c:{z:{},s:{},p:[]},d:{m:{},v:[],g:[],s:{},a:{},l:[],q:null,x:{},y:{},z:{},d:{}}};if(this.data.y){var N=/(^\d{1,4}?[\.|\\/|-]\d{1,2}?[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/;var P=this.data.y;var F=P.data;var B=new Array(P.smps.length).fill(true);var q=[];if(this.isRawData){var M=this.xAxisTime;var x=this.yAxisTime;var R=this.xAxis[0];var c=this.yAxis[0];var O=this.missingDataValue;for(var J=0,K=P.smps.length;J<K;J++){if((M&&R==P.smps[J])||(x&&c==P.smps[J])){q.push(J)}}for(var J=0,K=q.length;J<K;J++){for(var I=0,h=F.length;I<h;I++){var a=F[I][q[J]];if(a!=null&&toString.call(a)!=="[object Date]"&&N.test(a)){F[I][q[J]]=new Date(a).getTime()}}}for(var J=0,K=F.length;J<K;J++){for(var I=0,h=F[J].length;I<h;I++){var L=F[J][I];if(L!=null){if(B[I]&&!this.gZ([L])){B[I]=false}F[J][I]=L==O?Number.NaN:Number(L)}else{F[J][I]=Number.NaN}}}}else{var A=this.summaryType=="iqr"?["iqr1","iqr3","median","qtl1","qtl3","out"]:[this.summaryType];var w=A.length;var O=this.missingDataValue;var b=this.summaryType;for(var J=0;J<w;J++){var y=A[J];if(P.hasOwnProperty(y)){var D=P[y];var r=D.length;for(var I=0;I<r;I++){var u=D[I];var g=u.length;for(var H=0;H<g;H++){if(y=="out"){var e=u[H];var C=e.length;for(var G=0;G<C;G++){if(e[G]!=null){e[G]=e[G]==O?Number.NaN:Number(e[G])}else{F[J][I]=Number.NaN}}}else{if(u[H]!=null){u[H]=u[H]==O?Number.NaN:Number(u[H])}else{u[H]=Number.NaN}}}}}else{if(y){P[y]=[];var S=b=="iqr"?"median":b;var Q=P[S];var p=Q.length;for(var I=0;I<p;I++){var u=P[y][I]=[];var s=Q[I];var E=s.length;for(var H=0;H<E;H++){u[H]=[]}}}}}var y=b=="iqr"?"median":b;var D=P[y];var r=D?D.length:0;P.data=[];if(y){for(var J=0;J<r;J++){P.data.push(D[J])}}}}this.af(false,false,false,false,B)}}}}};this.FV=function(a){var b=this.isGroupedData?this.data.w:this.data.y;if(a=="cor"&&b.cor){return true}else{if(a=="venn"&&this.data.venn){return true}else{if(a=="network"&&this.data.nodes){return true}else{if(a=="genome"&&this.data.tracks){return true}else{if(a=="sum"&&b.sum&&b.sum[0].length>0){return true}else{if(a=="max"&&b.max&&b.max[0].length>0){return true}else{if(a=="min"&&b.min&&b.min[0].length>0){return true}else{if(a=="count"&&b.count&&b.count[0].length>0){return true}else{if(a=="mean"&&b.mean&&b.mean[0].length>0){return true}else{if(a=="median"&&b.median&&b.median[0].length>0){return true}else{if(a=="iqr"&&b.iqr1&&b.qtl1&&b.median&&b.qtl3&&b.iqr3&&b.median[0].length>0){return true}else{if(a=="raw"&&this.isRawData){return true}else{return false}}}}}}}}}}}}};this.MR=function(at,f,O,ad,I){var U=this;var t=this.isDOE?this.data.l.data[this.layoutCurrent||0]:false;var u=this.isGroupedData&&!f&&this.data.w?this.data.w:this.data.y;var ae=this.graphType=="Scatter2D"&&this.scatterType=="visium"?CanvasXpress.cacheImages[this.backgroundImageMD5||this.Ng(this.backgroundImage)]:false;var ap=Number.POSITIVE_INFINITY;var J=Number.NEGATIVE_INFINITY;if(this.setMin!=null&&this.setMax!=null){this.minData=this.setMin;this.maxData=this.setMax;return}if(this.isGroupedData&&!at&&!t){at=this.graphType=="Boxplot"?"iqr":this.summaryType;if(this.graphType=="Boxplot"&&!this.isBoxplotCalc){this.Ph(this.groupingFactors,false,false,false,true);u=this.data.w}}if(this.isGroupedData&&!f&&this.data.w&&!ad&&!t&&!this.layoutCurrent){for(var ah=0;ah<u.min.length;ah++){if(u.min[ah]){for(var ag=0;ag<u.min[ah].length;ag++){if(!isNaN(u.min[ah][ag])){ap=Math.min(ap,u.min[ah][ag])}if(!isNaN(u.max[ah][ag])){J=Math.max(J,u.max[ah][ag])}}}}}else{if(this.graphType=="Meter"){var G;if(this.layoutValid&&this.segregateVariablesBy.length&&this.segregateSamplesBy.length){G=this.data.l.comp[this.layoutCurrent||0][0][0]}else{if(this.layoutValid&&this.segregateVariablesBy.length&&!this.segregateSamplesBy.length){G=this.layoutCurrent||0}else{if(this.layoutValid&&this.segregateSamplesBy.length){G=this.meterVar?this.FP(this.meterVar):0}else{G=this.layoutValid?(this.layoutCurrent||0):this.meterVar?this.FP(this.meterVar):0}}}this.meterIndex=G>=0?G:0;var W=this.data.y.data[this.meterIndex];ap=0;J=this.ds(W,true)}else{if(at=="fish"){if(I=="xAxis"){ap=this.fishTimepoints[0]-((this.fishTimepoints[this.fishTimepoints.length-1]-this.fishTimepoints[0])/5);J=this.fishTimepoints[this.fishTimepoints.length-1]}else{ap=0;J=100}}else{if(at=="genome"){var Q=this.data.tracks.length;for(var ah=0;ah<Q;ah++){var C=this.data.tracks[ah].data.length;for(var ag=0;ag<C;ag++){if(this.data.tracks[ah].type=="box"){var aq=this.data.tracks[ah].data[ag].data.length;for(var af=0;af<aq;af++){W=this.data.tracks[ah].data[ag].data[af];J=Math.max(J,Math.max(W[0],W[1]));ap=Math.min(ap,Math.min(W[0],W[1]))}}else{if(this.data.tracks[ah].type=="sequence"){W=this.data.tracks[ah].data[ag].offset;J=Math.max(J,W+this.data.tracks[ah].data[ag].sequence.length);ap=Math.min(ap,W)}else{if(this.data.tracks[ah].type.match(/bar|heatmap/)){W=this.data.tracks[ah].data[ag].offset;J=this.data.tracks[ah].autowidth?Math.max(J,W+this.data.tracks[ah].data[ag].data.length):Math.max(J,W);ap=Math.min(ap,W)}else{if(this.data.tracks[ah].type=="dataframe"){var aq=this.data.tracks[ah].data[0].data.length;for(var af=0;af<aq;af++){W=this.data.tracks[ah].dataframe[this.data.tracks[ah].data[0].data[af].xAxis];J=Math.max(J,W[W.length-1]);ap=Math.min(ap,W[0])}}else{if(this.data.tracks[ah].type=="marker"){var aq=this.data.tracks[ah].data[ag].data.length;for(var af=0;af<aq;af++){W=this.data.tracks[ah].data[ag].data[af];J=Math.max(J,W[W.length-1]);ap=Math.min(ap,W[0])}}else{W=this.data.tracks[ah].data[ag].offset;J=Math.max(J,W);ap=Math.min(ap,W)}}}}}}}}else{if(at=="circular"){if(this.circularType=="chord"){this.circularChord=this.cR();ap=0;J=this.circularChord.total}else{var am=this.FP(this.rAxis);if(am>=0){var aa=this.ID(this.data.y.data[am]);ap=aa[0];J=aa[1]}else{ap=0;J=1}}}else{if(at=="gantt"){if(!this.data.gantt){this.isGanttDataFormated=false;this.cN()}var ah=this.FP(this.ganttStart);var ag=this.FP(this.ganttEnd);var ao=this.lB(this.data.gantt);ap=ao[ah].sort(function(d,c){return d-c})[0];J=ao[ag].sort(function(d,c){return c-d})[0]}else{if(at=="km"&&!f){if(!this.layoutValid){this.Yt()}if(I=="y"){ap=0;J=1}else{var Z=this.layoutValid&&this.meta.data.p.l.length?this.meta.data.p.l:this.meta.data.p.g;if(this.layoutValid&&this.meta.data.p.l.length){for(var ah=0;ah<Z.length;ah++){for(var ag=0;ag<Z[ah].length;ag++){ap=Math.min(ap,Z[ah][ag].data.time[0]);J=Math.max(J,Z[ah][ag].data.time[Z[ah][ag].data.time.length-1])}}}else{for(var ah=0;ah<Z.length;ah++){ap=Math.min(ap,Z[ah].data.time[0]);J=Math.max(J,Z[ah].data.time[Z[ah].data.time.length-1])}}}}else{if(at=="qq"||at=="cdf"){if(at=="qq"){this.NV()}else{this.ff()}var Z=this.layoutValid?this.meta.data.p.l:this.meta.data.p.g;if(this.layoutValid){for(var ah=0;ah<Z.length;ah++){for(var ag=0;ag<Z[ah].length;ag++){ap=Math.min(ap,Z[ah][ag].data[I][0]);J=Math.max(J,Z[ah][ag].data[I][Z[ah][ag].data[I].length-1])}}}else{for(var ah=0;ah<Z.length;ah++){ap=Math.min(ap,Z[ah].data[I][0]);J=Math.max(J,Z[ah].data[I][Z[ah].data[I].length-1])}}}else{if(at=="density"&&u.density){var N=function(d){for(var c=1;c<U.data.l.name.length;c++){if(U.data.l.name[c]==d){return c-1}}return 0};if(I=="xAxis"){var am=this.layoutCurrent||0;ap=u.density[am].histogram.breaks[0];J=u.density[am].histogram.breaks[u.density[am].histogram.breaks.length-1]}else{if(this.histogramAsDotplot&&I=="yAxis"){if(this.histogramStackDir!="down"){ap=-0.5;J=0.5}else{ap=0;J=1}}else{if(this.densityPosition.match(/filled|stacked/)){if(this.histogramStat=="count"){if(this.densityPosition=="filled"){J=u.global.maxY}else{if(this.densityPosition=="stacked"){J=u.global.maxY}}}else{if(this.densityPosition=="filled"){J=1}else{if(this.densityPosition=="stacked"){J=u.position.max}}}ap=0}else{if(this.histogramType=="stacked"&&this.histogramStat=="count"){if(this.layoutValid&&this.data.l){for(var ah=0;ah<this.data.l.axes.length;ah++){var w=[];var h=0;for(var ag=0;ag<this.data.l.axes[ah].yAxis.length;ag++){var am=N(this.data.l.axes[ah].yAxis[ag]);h+=u.density[am].histogram.maxY}J=Math.max(J,h)}}else{J=u.global.maxY}ap=0}else{if(this.histogramType=="stacked"){J=0}for(var ah=0;ah<this.smpIndices.length;ah++){if(this.histogramType=="stacked"){J+=u.density[this.smpIndices[ah]-1].globalMaxY}else{J=Math.max(J,u.density[this.smpIndices[ah]-1].globalMaxY)}}ap=0}}}}}else{if(at=="percentile"&&!f&&!ad){ap=0;J=100}else{if((at=="mean"||at=="median"||at=="sum"||at=="max"||at=="min"||at=="count")&&!f){if(ad){if(this.dodgeBy){var an=this.dodgeBy;this.dodgeBy=false;this.groupingFactors.push(an);this.Ph(this.groupingFactors,false,false,false,true);J=this.maxData;ap=this.minData;this.groupingFactors.pop();this.Ph(this.groupingFactors,false,false,false,true);this.dodgeBy=an}else{J=0;ap=0;maxSt=0;minSt=0;var q=this.isGroupedData?this.grpIndices:this.smpIndices;var al=this.isTransformedData?u.trans:u[this.summaryType];var T=this.graphType=="Circular"&&this.showIdeogram;var E=T?[this.varIndices,q]:[q,this.varIndices];var y=E[0].length;for(var ah=0;ah<y;ah++){var Q=E[0][ah];var e=0;var g=0;var A=E[1].length;for(var ag=0;ag<A;ag++){var C=this.isGroupedData?ag:E[1][ag];var M=T?al[Q][C]:al[C][Q];if(!isNaN(M)){minSt=Math.min(M,minSt);maxSt=Math.max(M,maxSt);if(M>0){e+=M}else{if(M<0){g+=M}}}}J=Math.max(e,J);ap=Math.min(g,ap)}}}else{var F=this.isDOE&&this.isDOE==1?this.data.y.vars.length:this.varIndices.length;for(var ah=0;ah<F;ah++){var Q=this.varIndices[ah];if(Q==undefined){continue}var W;var ab;if(this.isTransformedData){W=u.trans[Q]||u.trans[ah];ab=u.tstdev?(u.tstdev[Q]||u.tstdev[ah]):false}else{if(this.summaryType=="mean"){W=u.mean[Q]||u.mean[ah]}else{if(this.summaryType=="median"){W=u.median[Q]||u.median[ah]}else{if(this.summaryType=="sum"){W=u.sum[Q]||u.sum[ah]}else{if(this.summaryType=="max"){W=u.max[Q]||u.max[ah]}else{if(this.summaryType=="min"){W=u.min[Q]||u.min[ah]}else{if(this.summaryType=="count"){W=u.count[Q]||u.count[ah]}}}}}}ab=u.stdev?(u.stdev[Q]||u.stdev[ah]):false}if(W){var aj=W.length;for(var ag=0;ag<aj;ag++){var X;var M=W[ag];if(ab){X=ab[ag]/2}else{X=Number.NaN}if(!isNaN(M)){if(!isNaN(X)){if(O){if(M>0){ap=Math.min(M-X,ap);J=Math.max(M+X,J)}}else{ap=Math.min(M-X,ap);J=Math.max(M+X,J)}}else{if(O){if(M>0){ap=Math.min(M,ap);J=Math.max(M,J)}}else{ap=Math.min(M,ap);J=Math.max(M,J)}}}}}}}}else{if(this.summaryType=="mean"&&!this.isRawData){var Q=this.isDOE&&this.isDOE==1?this.data.y.vars.length:this.varIndices.length;for(var ah=0;ah<Q;ah++){if(this.varIndices[ah]==undefined){continue}var C=this.smpIndices.length;for(var ag=0;ag<C;ag++){var M=u.mean[this.varIndices[ah]][this.smpIndices[ag]];var ai=u.stdev&&u.stdev[this.varIndices[ah]]&&u.stdev[this.varIndices[ah]][this.smpIndices[ag]]/2?u.stdev[this.varIndices[ah]][this.smpIndices[ag]]/2:0;if(!isNaN(M)){if(!isNaN(ai)){ap=Math.min(M-ai,ap);J=Math.max(M+ai,J)}else{ap=Math.min(M,ap);J=Math.max(M,J)}}}}}else{if((at=="iqr"&&!f&&this.grpIndices)||(this.summaryType=="iqr"&&!this.isRawData)){var F=this.isDOE&&this.isDOE==1?this.data.y.vars.length:this.varIndices.length;for(var ah=0;ah<F;ah++){var Q=this.varIndices[ah];var L=this.grpIndices?this.grpIndices:this.smpIndices;var ar=L.length;if(u.iqr1[Q]){for(var ag=0;ag<ar;ag++){var C=L[ag];var D=u.iqr1[Q][C];var B=u.iqr3[Q][C];var V=u.out[Q][C];if(!isNaN(D)&&!isNaN(B)){if(O){if(D>0&&B>0){ap=Math.min(D,ap);J=Math.max(B,J)}}else{ap=Math.min(D,ap);J=Math.max(B,J)}}if(V){var R=V.length;for(var af=0;af<R;af++){if(!isNaN(V[af])){if(O){if(V[af]>0){ap=Math.min(V[af],ap);J=Math.max(V[af],J)}}else{ap=Math.min(V[af],ap);J=Math.max(V[af],J)}}}}}}}}else{if(at=="cor"){var q=this.correlationAxis=="variables"?this.varIndices:this.isGroupedData?this.grpIndices:this.smpIndices;var Q=q.length;for(var ah=0;ah<Q;ah++){var C=q.length;for(var ag=0;ag<C;ag++){var M=this.isTransformedData&&u.trans?u.trans[ah][ag]:u.cor[ah][ag];if(!isNaN(M)){if(O){if(M>0){ap=Math.min(M,ap);J=Math.max(M,J)}}else{ap=Math.min(M,ap);J=Math.max(M,J)}}}}}else{if(t){var C=I=="xAxis"?0:1;if(this.graphType=="Scatter2D"){for(var ah=0;ah<t.y.data.length;ah++){var M=t.y.data[ah][C];if(!isNaN(M)){ap=Math.min(M,ap);J=Math.max(M,J)}}}else{for(var ah=0;ah<t.y.data[C].length;ah++){var M=t.y.data[C][ah];if(!isNaN(M)){ap=Math.min(M,ap);J=Math.max(M,J)}}}}else{var al=this.isTransformedData&&u.trans?u.trans:u.data;var a=ae?ae.height:false;if(al&&al.length>0){if(ad){var T=this.graphType=="Circular"&&this.showIdeogram;var E=T?[this.varIndices,this.smpIndices]:[this.smpIndices,this.varIndices];var y=E[0].length;J=0;ap=0;maxSt=0;minSt=0;for(var ah=0;ah<y;ah++){var e=0;var g=0;var A=E[1].length;for(var ag=0;ag<A;ag++){var M=T?al[E[0][ah]][E[1][ag]]:al[E[1][ag]][E[0][ah]];if(!isNaN(M)){minSt=Math.min(M,minSt);maxSt=Math.max(M,maxSt);if(M>0){e+=M}else{if(M<0){g+=M}}}}J=Math.max(e,J);ap=Math.min(g,ap)}}else{var Q=this.motionBy||(this.isDOE&&this.isDOE==1)?this.data.y.vars.length:this.varIndices.length;for(var ah=0;ah<Q;ah++){if(this.varIndices[ah]==undefined){continue}var C=this.smpIndices.length;for(var ag=0;ag<C;ag++){var K=this.motionBy?ah:this.varIndices[ah];if(al[K]){var M=a?a-al[K][this.smpIndices[ag]]:al[K][this.smpIndices[ag]];if(!isNaN(M)){if(O){if(M>0){ap=Math.min(M,ap);J=Math.max(M,J)}}else{ap=Math.min(M,ap);J=Math.max(M,J)}}}}}if(this[I+"Transform"]=="sqrt"){ap=Math.sqrt(ap);J=Math.sqrt(J)}}}}}}}}}}}}}}}}}}if(this.graphType=="Boxplot"&&this.showViolinBoxplot&&!this.violinTrim){var x=this.meta.data.d;if(this.isGroupedData){x=x.g;var Q=x.length;for(var ah=0;ah<Q;ah++){var C=x[ah].length;for(var ag=0;ag<C;ag++){var ak=x[ah][ag].density.xy;if(ak.length){if(!isNaN(ak[0][0])){ap=Math.min(ap,ak[0][0])}if(!isNaN(ak[ak.length-1][0])){J=Math.max(J,ak[ak.length-1][0])}}}}}else{x=x.v;var Q=x.length;for(var ah=0;ah<Q;ah++){var ak=x[ah].density.xy;if(ak.length){if(!isNaN(ak[0][0])){ap=Math.min(ap,ak[0][0])}if(!isNaN(ak[ak.length-1][0])){J=Math.max(J,ak[ak.length-1][0])}}}}}else{if(this.graphType=="Scatter2D"&&this.scatterType=="visium"){var P=CanvasXpress.cacheImages[this.backgroundImageMD5||this.Ng(this.backgroundImage)];ap=0;J=I.match(/y/i)?P.height:P.width}else{if(this.graphType=="Scatter2D"&&this.ribbonBy){var al=this.isTransformedData&&u.trans?u.trans:u.data;var x=this.meta.data;if(this.eO(this.ribbonBy)){if(this.eO(this.ribbonBy[0])&&this.eO(this.ribbonBy[1])&&I=="yAxis"){for(var ah=0;ah<this.ribbonBy[0].length;ah++){var r=this.ribbonBy[0][ah];var b=this.ribbonBy[1][ah];if(!isNaN(r)){ap=Math.min(r,ap)}if(!isNaN(b)){J=Math.max(b,J)}}}else{if(x.z&&x.z.hasOwnProperty(this.ribbonBy[0])&&x.z[this.ribbonBy[0]].type=="Numeric"&&x.z.hasOwnProperty(this.ribbonBy[1])&&x.z[this.ribbonBy[1]].type=="Numeric"){for(var ah=0;ah<this.varIndices.length;ah++){var b=this.data.z[this.ribbonBy[0]][this.varIndices[ah]];var r=this.data.z[this.ribbonBy[1]][this.varIndices[ah]];if(!isNaN(b)){ap=Math.min(b,ap);J=Math.max(b,J)}if(!isNaN(r)){ap=Math.min(r,ap);J=Math.max(r,J)}}}else{var S=this.u4(this.ribbonBy);if(this.eO(S)){for(var ah=0;ah<this.varIndices.length;ah++){for(var ag=0;ag<this.smpIndices.length;ag++){var b=al[this.varIndices[ah]][S[0]];var r=al[this.varIndices[ah]][S[1]];if(!isNaN(b)){ap=Math.min(b,ap);J=Math.max(b,J)}if(!isNaN(r)){ap=Math.min(r,ap);J=Math.max(r,J)}}}}}}}else{if(x.z&&x.z.hasOwnProperty(this.ribbonBy)&&x.z[this.ribbonBy].type=="Numeric"){for(var ah=0;ah<this.varIndices.length;ah++){var X=this.data.z[this.ribbonBy][this.varIndices[ah]];for(var ag=0;ag<this.smpIndices.length;ag++){var M=al[this.varIndices[ah]][this.smpIndices[ag]];if(!isNaN(M)&&!isNaN(X)){ap=Math.min(M-X,ap);J=Math.max(M+X,J)}}}}else{for(var ah=0;ah<this.varIndices.length;ah++){for(var ag=0;ag<this.smpIndices.length;ag++){var M=al[this.varIndices[ah]][this.smpIndices[ag]];var X=al[this.varIndices[ah]][S];if(!isNaN(M)&&!isNaN(X)){ap=Math.min(M-X,ap);J=Math.max(M+X,J)}}}}}}else{if(this.showHistogram||this.isDOE){var Y=this.wD();if(Y){if(this.isDOE){if(this.isDOE&&this.layoutCurrent&&this.data.l.data&&this.data.l.data[this.layoutCurrent]&&this.data.l.params&&!this.data.l.params[this.layoutCurrent].showHistogram){}else{if(I=="xAxis"){ap=Y.histogram?Y.histogram.breaks[0]:Y.density.histogram.breaks[0];J=Y.histogram?Y.histogram.breaks[Y.histogram.breaks.length-1]:Y.density.histogram.breaks[Y.density.histogram.breaks.length-1]}else{if(I=="yAxis"){switch(this.densityPosition){case"filled":ap=0;J=Y.density?Y.density.histogram.maxY:Y.histogram.maxY;break;case"stacked":ap=0;J=Y.density?Y.density.histogram.maxY:Y.histogram.maxY;break;default:ap=0;J=this.histogramType=="stacked"&&Y.density?Y.density.histogram.maxY:this.histogramType=="stacked"?Y.histogram.maxY:this.layoutCurrent?Y.histogram.maxY:this.ds(Y.summary.cols);break}}}}}else{if(I=="xAxis"){ap=Y.density.minData;J=Y.density.maxData}else{if(I=="yAxis"){if(this.histogramStat=="count"){switch(this.densityPosition){case"filled":ap=0;J=this.layoutValid?Y.summary.globalMaxCount:Y.density.histogram.maxY;break;case"stacked":ap=0;J=this.layoutValid?Y.summary.globalMaxCount:Y.density.histogram.maxY;break;default:ap=0;J=this.layoutValid&&this.histogramType=="stacked"?Y.summary.globalMaxCount:this.histogramType=="stacked"?Y.density.histogram.maxY:this.ds(Y.summary.cols);break}}else{if(this.histogramStat=="density"){switch(this.densityPosition){case"filled":ap=0;J=1;break;case"stacked":ap=0;J=Y.summary.position.max;break;default:ap=0;J=Y.summary.globalMaxY;break}}}}}}}}else{if(this.graphType=="Scatter2D"&&this.colorBy&&this.scatterType=="area"&&I=="yAxis"){this.ba();if(this.meta.data.s){var Y=this.layoutValid?this.meta.data.s.layout[this.layoutCurrent||0]:this.meta.data.s;ap=0;J=Y.maxY}}else{if(this.graphType=="Scatter2D"&&this.colorBy&&!this.dataPointSizeScaleFactor&&this.scatterType=="stream"){if(I=="xAxis"){var H=(J-ap)*this.scatterStreamExtraSpan;ap-=H;J+=H}else{if(I=="yAxis"){this.Tw();if(this.meta.data.s){var Y=this.layoutValid?this.meta.data.s.layout[this.layoutCurrent||0]:this.meta.data.s;switch(this.scatterStreamType){case"mirror":ap=-Y.maxY;J=Y.maxY;break;case"ridge":ap=0;J=Y.maxY*2;break;case"proportional":ap=0;J=1;break}}}}}else{if(this.graphType=="Scatter2D"&&I=="yAxis"&&(this.showLoessFit||this.showRegressionFit||this.showQuantileRegressionFit)){if(this.showLoessFit){this.dL()}if(this.showRegressionFit){this.WL()}if(this.showQuantileRegressionFit){this.l1()}if(this.meta.data.s){var ac=this.meta.data.s;if(ac.minY!=null&&ac.minY<Number.POSITIVE_INFINITY&&ac.maxY!=null&&ac.maxY>Number.NEGATIVE_INFINITY){if(this.dataPointSizeScaleFactor){ap=Math.min(ap,ac.minY);J=Math.max(J,ac.maxY)}else{ap=ac.minY;J=ac.maxY}}}}}}}}}}if(this.decorations&&this.decorations.error){for(var ah=0;ah<this.decorations.error.length;ah++){if(this.graphType=="Scatter2D"){}else{ap=Math.min(ap,this.decorations.error[ah].min);J=Math.max(J,this.decorations.error[ah].max)}}}this.minData=this.setMin!=null?this.setMin:ap==Number.POSITIVE_INFINITY||ap==Number.NEGATIVE_INFINITY?0:ap;this.maxData=this.setMax!=null?this.setMax:J==Number.NEGATIVE_INFINITY||J==Number.POSITIVE_INFINITY?1:J;if(ad&&at!="percentile"){this.minDataStacked=minSt;this.maxDataStacked=maxSt}};this.ir=function(a){var c=false;if(this.scatterPlotMatrix&&a!=null){var b=this.meta.data.s&&this.meta.data.s.density?this.meta.data.s.density:false;if(b&&b.layout&&b.Global&&b.Global.Samples&&b.Global.sets&&this.layoutValidN!=null&&b.Global.sets[b.layout[this.layoutValidN][a]]){c=b.Global.Samples[b.Global.sets[b.layout[this.layoutValidN][a]].name.split(":")[1]].summary}}else{c=this.meta.data.s&&this.meta.data.s.density&&this.meta.data.s.density.Global&&this.meta.data.s.density.Global.summary?this.meta.data.s.density.Global.summary:false}if(c){return{data:c.histogram,vars:c.vars,smps:this.gg(c.smps).splice(1,c.smps.length-1)}}else{return false}};this.we=function(k,q,s,r){var f=k!=null?(this.layoutParams?this.layoutParams[k].setMinX:null):this.setMinX;var b=k!=null?(this.layoutParams?this.layoutParams[k].setMaxX:null):this.setMaxX;var e=k!=null?(this.layoutParams?this.layoutParams[k].setMinY:null):this.setMinY;var a=k!=null?(this.layoutParams?this.layoutParams[k].setMaxY:null):this.setMaxY;var p=this.ES(this.scatterPlotMatrix?q:this.xAxisIndices[q],"x",r);var l=this.ES(this.scatterPlotMatrix?s:this.yAxisIndices[s],"y",r);for(var h=0;h<p.length;h++){if(p[h]==null||l[h]==null||isNaN(p[h])||isNaN(l[h])){p.splice(h,1);l.splice(h,1);h--}}if((f===null||f<=b)&&(e===null||e<=a)){return[p,l]}const j=[];const g=[];for(let h=0;h<p.length;h++){const d=p[h];const c=l[h];if((f===null||(d>=f&&d<=b))&&(e===null||(c>=e&&c<=a))){j.push(d);g.push(c)}}return[j,g]};this.wD=function(){var K=this;var M=[];var U=function(ay,ap,at){var ac=[];var al=[];var q=ay.sets||[ay];var aj=0;if(!K.isDOE){for(var ax=0;ax<q.length;ax++){ac=ac.concat(q[ax].data);al=al.concat(q[ax].idxs);aj=Math.max(aj,q[ax].globalMaxY)}}var af=!K.isDOE?K.oE(ac,ap,al):ay;var ad={globalMaxY:aj,vars:[],smps:[],data:[],histogram:[],values:[],cols:[],position:{factor:1,max:0,tot:[]},stacked:[],filled:[]};var aq=af.histogram.count.length;var ao=af.histogram.breaks;var aD=af.histogram.fbreaks;var ar=ao[0];for(var ax=0;ax<aq;ax++){ad.vars.push("Bin"+(ax+1)+" ("+af.histogram.breaks[ax]+" - "+af.histogram.breaks[ax+1]+")");ad.data[ax]=[];ad.data[ax][0]=ao[ax+1]-ar;ad.histogram[ax]=[];ad.values[ax]=[];for(var aw=0;aw<q.length;aw++){ad.histogram[ax][aw]=[];ad.values[ax][aw]=[]}}ad.smps.push("Bin");for(var ax=0;ax<q.length;ax++){var aB=0;ad.smps.push(q[ax].name);var ae=[];for(var aw=0;aw<aq;aw++){ae[aw]=0}for(var aw=0;aw<q[ax].data.length;aw++){var ah=q[ax].data[aw];var aA=q[ax].idxs[aw];if(typeof ah==="number"&&isFinite(ah)){var an=K.kh(ah,aD);ae[an]++;if(ad.histogram[an]&&ad.histogram[an][ax]){ad.histogram[an][ax].push(aA);ad.values[an][ax].push(ah)}}}for(var aw=0;aw<aq;aw++){ad.data[aw][ax+1]=ae[aw];aB=Math.max(aB,ae[aw])}ad.cols.push(aB)}for(var ax=0;ax<af.xy.length;ax++){ad.position.tot[ax]=0}var av=[];var au=0;for(var ax=0;ax<q.length;ax++){var ak=q[ax];var aC=K.rI(ak.xy,af.xy);var am=[];var ag=[];for(var aw=0;aw<af.xy.length;aw++){am[aw]=[af.xy[aw][0],ad.position.tot[aw]];ad.position.tot[aw]+=aC[aw][1];ag[aw]=[af.xy[aw][0],ad.position.tot[aw]]}ad.stacked[ax]=ag.concat(am.reverse());av.push(aC);for(var aw=0;aw<ad.position.tot.length;aw++){au=Math.max(au,ad.position.tot[aw])}ad.position.max=au;ad.position.factor=af.histogram.maxY/au}var az=[];for(var ax=0;ax<af.xy.length;ax++){az[ax]=0}for(var ax=0;ax<q.length;ax++){var ak=q[ax];var aC=av.shift();var am=[];var ag=[];for(var aw=0;aw<af.xy.length;aw++){am[aw]=[af.xy[aw][0],az[aw]];az[aw]+=(ad.position.tot[aw]>0?aC[aw][1]/ad.position.tot[aw]:0);ag[aw]=[af.xy[aw][0],az[aw]]}ad.filled[ax]=ag.concat(am.reverse())}if(at!=null){var aB=0;for(var ax=0;ax<at.length;ax++){var ai=0;for(var aw=0;aw<at[ax].length;aw++){ai+=ad.cols[at[ax][aw]]}aB=Math.max(aB,ai)}ad.globalMaxCount=aB}if(!K.isDOE){ay.density=af}ay.summary=ad};var b=function(){var j=K.meta.data.s.density;if(K.isDOE&&j.DOE){if(K.layoutCurrent){return j.DOE[K.data.l.smps[K.layoutCurrent]]}else{return j.Global}}else{if(K.scatterPlotMatrix){return K.layoutCurrent!==false&&j.layout[K.layoutCurrent].length?j.Global.Samples[j.Global.sets[j.layout[K.layoutCurrent][0]].name.split(":")[1]]:false}else{if(j.Global){return j.Global}}}};var t=function(k,j){return k.filter(function(l){return j.includes(l)})};var E=function(){var l=[];var j=[];var ac=[];var q=[];var ad=K.meta.data.s.density.layout;if(K.segregateVariablesBy.length){if(K.meta.data.z&&K.meta.data.z.hasOwnProperty(K.segregateVariablesBy[0])){l=K.meta.data.z[K.segregateVariablesBy[0]].levels}if(K.segregateVariablesBy.length>1&&K.meta.data.z&&K.meta.data.z.hasOwnProperty(K.segregateVariablesBy[1])){j=K.meta.data.z[K.segregateVariablesBy[1]].levels}}if(K.segregateSamplesBy.length){if(K.meta.data.z&&K.meta.data.z.hasOwnProperty(K.segregateSamplesBy[0])){ac=K.meta.data.z[K.segregateSamplesBy[0]].levels}else{if(K.segregateSamplesBy[0]=="sample"){ac=K.data.y.smps}}if(K.segregateSamplesBy.length>1&&K.meta.data.z&&K.meta.data.z.hasOwnProperty(K.segregateSamplesBy[1])){q=K.meta.data.z[K.segregateSamplesBy[1]].levels}}var k=(l.length||1)*(j.length||1)*(ac.length||1)*(q.length||1);if(ad.length&&ad.length==k){return true}else{return false}};var C=function(ai,ag){var ae=[];var ad=ag||K.segregateVariablesBy[ai];var al=K.meta.data.z[ad].levels;var ar=K.data;if(!ab.hasOwnProperty("Factor")){ab.Factor={}}var ak=0;for(var ao=0;ao<al.length;ao++){ab.layout[ao]=[];var aj=K.meta.data.z[ad].levels[ao];ab.Factor[aj]={};var af=[];for(var an=0;an<K.varIndices.length;an++){var ap=K.varIndices[an];if(String(ar.z[ad][ap])==aj){af.push(ap)}}ae.push(K.gg(af));var q=[];for(var an=0;an<K.smpIndices.length;an++){var ap=K.smpIndices[an];var l=[];var aq=[];var at=aj+":"+ar.y.smps[ap];for(var am=0;am<af.length;am++){var ac=af[am];var ah=ar.y.data[ac][ap];if(typeof ah==="number"&&isFinite(ah)){l.push(ah);aq.push(ac)}}ab.Factor[aj][ar.y.smps[ap]]=K.oE(l,"Factor:"+at,aq);q.push(ab.Factor[aj][ar.y.smps[ap]]);ab.layout[ao].push(ak++)}M=M.concat(q)}return ae};if(!this.meta.data.s){this.meta.data.s={}}if(!this.meta.data.s.density){this.meta.data.s.density={}}if(!this.meta.data.s.density.layout){this.meta.data.s.density.layout=[]}if(this.isDOE&&this.meta.data.s.density.hasOwnProperty("DOE")){return b()}else{if(this.meta.data.s.ready&&!this.isDOE){var S=this.segregateSamplesBy.length+this.segregateVariablesBy.length;if(S&&!E()){this.meta.data.s={};this.meta.data.s.density={};this.meta.data.s.density.layout=[]}else{return b()}}}if(this.isDOE){if(this.meta.config.user.graphType==this.graphType||this.meta.config.user.graphType==this.meta.data.s.graphType||this.meta.config.user.graphType=="Heatmap"){var Z=this.data;var A=this.meta.data.s.graphType||this.meta.config.user.graphType||this.graphType;var ab=this.meta.data.s.density;var d=A.match(/Scatter|Map/)?Z.z:Z.x;var a=A.match(/Scatter|Map/)?this.sO("z","Numeric"):this.sO("x","Numeric");var c=this.data.l.doe;var p=false;if(!ab.hasOwnProperty("DOE")){ab.DOE={}}if(a&&a.length){for(var V=0;V<a.length;V++){var J=a[V];var u=[];var D=[];for(var T=0;T<c.length;T++){var L=d[J][c[T]];if(typeof L==="number"&&isFinite(L)){u.push(L);D.push(c[T])}}ab.DOE[J]=this.oE(u,"DOE:"+J,D);U(ab.DOE[J],"Global-"+J)}}var P=Object.keys(ab.DOE).length;while(P<this.maxDOENumber+1&&!p){if(A.match(/Scatter|^Map/)){for(var V=0;V<Z.y.smps.length;V++){var J=Z.y.smps[V];var u=[];var D=[];for(var T=0;T<this.varIndices.length;T++){var L=Z.y.data[this.varIndices[T]][V];if(typeof L==="number"&&isFinite(L)){u.push(L);D.push(this.varIndices[T])}}ab.DOE[J]=this.oE(u,"DOE:"+J,D);U(ab.DOE[J],"Global-"+J);P++;if(P>this.maxDOENumber){break}}}else{for(var V=0;V<Z.y.vars.length;V++){var J=Z.y.vars[V];var u=[];var D=[];for(var T=0;T<this.smpIndices.length;T++){var L=Z.y.data[V][this.smpIndices[T]];if(typeof L==="number"&&isFinite(L)){u.push(L);D.push(this.smpIndices[T])}}ab.DOE[J]=this.oE(u,"DOE:"+J,D);U(ab.DOE[J],"Global-"+J);P++;if(P>this.maxDOENumber){break}}}p=true}}}else{if(this.graphType.match(/Scatter|Map/)){if(this.segregateVariablesBy.length&&this.meta.data.z&&this.meta.data.z.hasOwnProperty(this.segregateVariablesBy[0])){var ab=K.meta.data.s.density;var X=C(0);if(this.segregateVariablesBy.length==2||(this.showHistogram!=true&&this.showHistogram!=this.segregateVariablesBy[0])){var e=this.segregateVariablesBy.length==2?this.segregateVariablesBy[1]:this.showHistogram;var W=this.segregateVariablesBy.length==2?C(1):C(false,e);M=[];var h=this.meta.data.z[this.segregateVariablesBy[0]].levels;var f=this.meta.data.z[e].levels;var Z=this.data;var P=0;for(var V=0;V<h.length;V++){for(var T=0;T<f.length;T++){ab.layout[P]=[];var I=this.meta.data.z[this.segregateVariablesBy[0]].levels[V];var G=this.meta.data.z[e].levels[T];var s=I+":"+G;ab.Factor[s]={};var B=t(X[V],W[T]);var O=[];for(var R=0;R<this.smpIndices.length;R++){var aa=this.smpIndices[R];var u=[];var D=[];var x=s+":"+Z.y.smps[aa];for(var Q=0;Q<B.length;Q++){var F=B[Q];var L=Z.y.data[F][aa];if(typeof L==="number"&&isFinite(L)){u.push(L);D.push(F)}}ab.Factor[s][Z.y.smps[aa]]=this.oE(u,"Factor:"+x,D);O.push(ab.Factor[s][Z.y.smps[aa]]);if(this.segregateVariablesBy.length==2){ab.layout[P].push(P++)}else{ab.layout[V].push(P++)}}M=M.concat(O)}}}}else{if((this.segregateSamplesBy.length&&this.segregateSamplesBy[0]=="sample")||(this.scatterPlotMatrix&&this.scatterPlotMatrix!==true&&this.meta.data.z&&this.meta.data.z.hasOwnProperty(this.scatterPlotMatrix))){var w=this.scatterPlotMatrix?this.scatterPlotMatrix:this.showHistogram;var ab=this.meta.data.s.density;var Y=w!==true&&this.meta.data.z&&this.meta.data.z.hasOwnProperty(w)?this.meta.data.z[w].levels:false;var Z=this.data;var P=0;if(this.scatterPlotMatrix){var N=this.scatterPlotMatrixType=="all"?this.smpIndices.length+1:this.smpIndices.length;for(var V=0;V<N;V++){for(var T=0;T<N;T++){ab.layout[P++]=[]}}P=0}if(!ab.hasOwnProperty("Samples")){ab.Samples={}}if(Y){for(var V=0;V<this.smpIndices.length;V++){if(!this.scatterPlotMatrix){if(!ab.layout[V]){ab.layout[V]=[]}}var H=this.smpIndices[V];ab.Samples[Z.y.smps[H]]={};var y=[];for(var T=0;T<Y.length;T++){var s=this.meta.data.z[w].levels[T];var B=[];for(var R=0;R<this.varIndices.length;R++){var aa=this.varIndices[R];if(String(Z.z[w][aa])==s){B.push(aa)}}var u=[];var D=[];var x=Z.y.smps[H]+":"+s;for(var R=0;R<B.length;R++){var aa=B[R];var L=Z.y.data[aa][H];if(typeof L==="number"&&isFinite(L)){u.push(L);D.push(aa)}}ab.Samples[Z.y.smps[H]][s]=this.oE(u,"Samples:"+x,D);y.push(ab.Samples[Z.y.smps[H]][s]);if(this.scatterPlotMatrix){ab.layout[(V*this.smpIndices.length)+(V%this.smpIndices.length)+(this.scatterPlotMatrixType=="all"?V:0)].push(P++)}else{ab.layout[V].push(P++)}}M=M.concat(y)}if(this.scatterPlotMatrixType=="all"){var H=this.smpIndices.length*(this.smpIndices.length+1);var P=0;for(var V=0;V<this.smpIndices.length;V++){for(var T=0;T<Y.length;T++){ab.layout[H].push(P++)}H++}}}else{for(var V=0;V<this.smpIndices.length;V++){ab.layout[V]=[];var H=this.smpIndices[V];var u=[];var D=[];for(var T=0;T<this.varIndices.length;++T){var r=this.varIndices[T];var L=Z.y.data[r][H];if(typeof L==="number"&&isFinite(L)){u.push(L);D.push(r)}}ab.Samples[Z.y.smps[H]]=this.oE(u,"Samples:"+Z.y.smps[H],D);ab.layout[V].push(P++);M=M.concat([ab.Samples[Z.y.smps[H]]])}}}else{if((this.showHistogram&&this.showHistogram!==true&&this.meta.data.z&&this.meta.data.z.hasOwnProperty(this.showHistogram))||(this.ridgeBy&&this.ridgeBy&&this.meta.data.z&&this.meta.data.z.hasOwnProperty(this.ridgeBy))){var w=this.ridgeBy?this.ridgeBy:this.showHistogram;var ab=this.meta.data.s.density;var Y=this.meta.data.z[w].levels;var Z=this.data;var P=0;if(!ab.hasOwnProperty("Factor")){ab.Factor={}}for(var V=0;V<Y.length;V++){var s=this.meta.data.z[w].levels[V];ab.Factor[s]={};var B=[];for(var T=0;T<this.varIndices.length;T++){var r=this.varIndices[T];if(String(Z.z[w][r])==s){B.push(r)}}for(var T=0;T<this.smpIndices.length;T++){var r=this.smpIndices[T];var u=[];var D=[];var x=s+":"+Z.y.smps[r];for(var R=0;R<B.length;R++){var aa=B[R];var L=Z.y.data[aa][r];if(typeof L==="number"&&isFinite(L)){u.push(L);D.push(aa)}}ab.Factor[s][Z.y.smps[r]]=this.oE(u,"Factor:"+x,D);M.push(ab.Factor[s][Z.y.smps[r]])}}}else{if(!this.meta.data.s.density.hasOwnProperty("Variables")){var ab=this.meta.data.s.density;var Z=this.data;if(!ab.hasOwnProperty("Samples")){ab.Samples={}}for(var V=0;V<this.smpIndices.length;V++){var H=this.smpIndices[V];var u=[];var D=[];for(var T=0;T<this.varIndices.length;T++){var r=this.varIndices[T];var L=Z.y.data[r][H];if(typeof L==="number"&&isFinite(L)){u.push(L);D.push(r)}}ab.Samples[Z.y.smps[H]]=this.oE(u,"Samples:"+Z.y.smps[H],D);M.push(ab.Samples[Z.y.smps[H]])}}}}}}else{var ab=this.meta.data.s.density;var Y=this.stackBy&&this.meta.data.x.hasOwnProperty(this.stackBy)?this.meta.data.x[this.stackBy].levels:false;var Z=this.data;if(!ab.hasOwnProperty("Variables")){ab.Variables={}}if(Y){var y=[];for(var V=0;V<this.varIndices.length;V++){var H=this.varIndices[V];ab.Variables[Z.y.vars[H]]={};for(var T=0;T<Y.length;T++){var s=this.meta.data.x[this.stackBy].levels[T];var g=[];for(var R=0;R<this.smpIndices.length;R++){var aa=this.smpIndices[R];if(String(Z.x[this.stackBy][aa])==s){g.push(aa)}}var u=[];var D=[];var x=Z.y.vars[H]+":"+s;for(var R=0;R<g.length;R++){var aa=g[R];var L=Z.y.data[H][aa];if(typeof L==="number"&&isFinite(L)){u.push(L);D.push(aa)}}ab.Variables[Z.y.vars[H]][s]=this.oE(u,"Variables:"+x,D);y.push(ab.Variables[Z.y.vars[H]][s])}M=M.concat(y)}}else{for(var V=0;V<this.varIndices.length;V++){var H=this.varIndices[V];var u=[];var D=[];for(var T=0;T<this.smpIndices.length;T++){var r=this.smpIndices[T];var L=Z.y.data[H][r];if(typeof L==="number"&&isFinite(L)){u.push(L);D.push(r)}}ab.Variables[Z.y.vars[H]]=this.oE(u,"Variables:"+Z.y.vars[H],D);M.push(ab.Variables[Z.y.vars[H]])}}}}if(M.length){if(!ab.hasOwnProperty("Global")){ab.Global={sets:M};U(ab.Global,"Global",ab.layout)}if(ab.Samples&&this.scatterPlotMatrix){ab.Global.Samples={};for(var V in ab.Samples){ab.Global.Samples[V]={sets:[]};for(var T in ab.Samples[V]){ab.Global.Samples[V].sets.push(ab.Samples[V][T])}U(ab.Global.Samples[V],"Global-"+V)}}}this.meta.data.s.ready=true;this.meta.data.s.graphType=this.meta.data.s.graphType||this.graphType;return b()};this.dL=function(a,g){var f=this.meta.console;if(!a){if(!this.meta.data.s){this.meta.data.s={loess:{},layout:[]}}else{if(this.meta.data.s&&!this.meta.data.s.hasOwnProperty("loess")){this.meta.data.s.loess={}}}if(this.layoutValid&&this.meta.data.s.layout.length!=this.data.l.comp.length){for(var e=0;e<this.data.l.comp.length;e++){this.meta.data.s.layout[e]={loess:{}};this.dL(true,e)}}else{this.dL(true)}}else{var b=g!=null?this.meta.data.s.layout[g]:this.meta.data.s;var h=this.showLoessFit!==true&&this.meta.data.z&&this.meta.data.z.hasOwnProperty(this.showLoessFit)?this.meta.data.z[this.showLoessFit].levels:false;var q=this.axesType=="XYZ"?1:Math.max(this.xAxisIndices.length,this.yAxisIndices.length);b.minY=Number.POSITIVE_INFINITY;b.maxY=Number.NEGATIVE_INFINITY;for(var e=0;e<q;e++){var k=this.axesType=="Y"||this.axesType=="XYZ"?0:e;var s=this.axesType=="X"||this.axesType=="XYZ"?0:e;var p=this.xAxisIndices[k]+":"+this.yAxisIndices[s];if(h){for(var d=0;d<h.length;d++){var l=this.J9(this.showLoessFit,h[d],g!=null?this.data.l.comp[g]:false);var r=this.we(g,k,s,l);if(r[0].length>5){try{b.loess[p+":"+h[d]]=this.CO([r[0],r[1]],"Loess:"+p+":"+h[d]+(g!=null?":"+g:""));b.minY=Math.min(b.minY,b.loess[p+":"+h[d]].range[2]);b.maxY=Math.max(b.maxY,b.loess[p+":"+h[d]].range[3])}catch(c){f.push(["setLoessData",r[0].length,p+":"+h[d],c])}}}}else{var l=g!=null?this.data.l.comp[g]:false;var r=this.we(g,k,s,l);if(r[0].length>5){try{b.loess[p]=this.CO([r[0],r[1]],"Global:"+p+(g!=null?":"+g:""));b.minY=Math.min(b.minY,b.loess[p].range[2]);b.maxY=Math.max(b.maxY,b.loess[p].range[3])}catch(c){f.push(["setLoessData",r[0].length,p,c])}}}}}};this.WL=function(a,g){var f=this.meta.console;if(!a){if(!this.meta.data.s){this.meta.data.s={regression:{},layout:[]}}else{if(this.meta.data.s&&!this.meta.data.s.hasOwnProperty("regression")){this.meta.data.s.regression={}}}if(this.layoutValid&&this.meta.data.s.layout&&this.meta.data.s.layout.length!=this.data.l.comp.length){for(var e=0;e<this.data.l.comp.length;e++){this.meta.data.s.layout[e]={regression:{}};this.WL(true,e)}}else{this.WL(true)}}else{var b=g!=null?this.meta.data.s.layout[g]:this.meta.data.s;var h=this.showRegressionFit!==true&&this.meta.data.z&&this.meta.data.z.hasOwnProperty(this.showRegressionFit)?this.meta.data.z[this.showRegressionFit].levels:false;var r=this.scatterPlotMatrix?this.data.y.smps.length:this.axesType=="XYZ"?1:Math.max(this.xAxisIndices.length,this.yAxisIndices.length);b.minY=Number.POSITIVE_INFINITY;b.maxY=Number.NEGATIVE_INFINITY;if(this.scatterPlotMatrix){for(var e=0;e<r;e++){for(var d=0;d<r;d++){if(e==d){continue}var q=e+":"+d;if(h){for(var c=0;c<h.length;c++){var p=this.J9(this.showRegressionFit,h[c],this.data.l.comp[e]);var t=this.we(g,e,d,p);if(t[0].length>3){b.regression[q+":"+h[c]]=this.So(t[0],t[1],"Regression:"+q+":"+h[c]);b.minY=Math.min(b.minY,b.regression[q+":"+h[c]][4][2]);b.maxY=Math.max(b.maxY,b.regression[q+":"+h[c]][4][3])}else{f.push(["setRegressionData",t[0].length,q+":"+h[c],"Less than 3 values"])}}}else{var p=g!=null?this.data.l.comp[g]:false;var t=this.we(g,e,d,p);if(t[0].length>3){b.regression[q]=this.So(t[0],t[1],"Global:"+q+(g!=null?":"+g:""));b.minY=Math.min(b.minY,b.regression[q][4][2]);b.maxY=Math.max(b.maxY,b.regression[q][4][3])}else{f.push(["setRegressionData",t[0].length,q,"Less than 3 values"])}}}}}else{for(var e=0;e<r;e++){var l=this.axesType=="Y"||this.axesType=="XYZ"?0:e;var s=this.axesType=="X"||this.axesType=="XYZ"?0:e;var q=this.xAxisIndices[l]+":"+this.yAxisIndices[s];if(h){for(var d=0;d<h.length;d++){var p=this.J9(this.showRegressionFit,h[d],g!=null?this.data.l.comp[g]:false);var t=this.we(g,l,s,p);if(t[0].length>3){b.regression[q+":"+h[d]]=this.So(t[0],t[1],"Regression:"+q+":"+h[d]+(g!=null?":"+g:""));b.minY=Math.min(b.minY,b.regression[q+":"+h[d]][4][2]);b.maxY=Math.max(b.maxY,b.regression[q+":"+h[d]][4][3])}else{f.push(["setRegressionData",t[0].length,q+":"+h[d],"Less than 3 values"])}}}else{var p=g!=null?this.data.l.comp[g]:false;var t=this.we(g,l,s,p);if(t[0].length>3){b.regression[q]=this.So(t[0],t[1],"Global:"+q+(g!=null?":"+g:""));b.minY=Math.min(b.minY,b.regression[q][4][2]);b.maxY=Math.max(b.maxY,b.regression[q][4][3])}else{f.push(["setRegressionData",t[0].length,q,"Less than 3 values"])}}}}}};this.l1=function(a,g){var f=this.meta.console;if(!a){if(!this.meta.data.s){this.meta.data.s={quantileRegression:{},layout:[]}}else{if(this.meta.data.s&&!this.meta.data.s.hasOwnProperty("quantileRegression")){this.meta.data.s.quantileRegression={}}}if(this.layoutValid&&this.meta.data.s.layout.length!=this.data.l.comp.length){for(var e=0;e<this.data.l.comp.length;e++){this.meta.data.s.layout[e]={quantileRegression:{}};this.l1(true,e)}}else{this.l1(true)}}else{var b=g!=null?this.meta.data.s.layout[g]:this.meta.data.s;var h=this.showQuantileRegressionFit!==true&&this.meta.data.z&&this.meta.data.z.hasOwnProperty(this.showQuantileRegressionFit)?this.meta.data.z[this.showQuantileRegressionFit].levels:false;var q=this.axesType=="XYZ"?1:Math.max(this.xAxisIndices.length,this.yAxisIndices.length);b.minY=Number.POSITIVE_INFINITY;b.maxY=Number.NEGATIVE_INFINITY;for(var e=0;e<q;e++){var k=this.axesType=="Y"||this.axesType=="XYZ"?0:e;var s=this.axesType=="X"||this.axesType=="XYZ"?0:e;var p=this.xAxisIndices[k]+":"+this.yAxisIndices[s];if(h){for(var d=0;d<h.length;d++){var l=this.J9(this.showQuantileRegressionFit,h[d],g!=null?this.data.l.comp[g]:false);var r=this.we(g,k,s,l);if(r[0].length>5){try{b.quantileRegression[p+":"+h[d]]=this.C2(r[0],r[1],this.quantiles,"QuantileRegression:"+p+":"+h[d]+(g!=null?":"+g:""));if(this.Ov(b.quantileRegression[p+":"+h[d]])){b.minY=Math.min(b.minY,b.quantileRegression[p+":"+h[d]].range[2]);b.maxY=Math.max(b.maxY,b.quantileRegression[p+":"+h[d]].range[3])}}catch(c){f.push(["setQuantileRegressionData",r[0].length,p+":"+h[d],c])}}}}else{var l=g!=null?this.data.l.comp[g]:false;var r=this.we(g,k,s,l);if(r[0].length>5){try{b.quantileRegression[p]=this.C2(r[0],r[1],this.quantiles,"Global:"+p+(g!=null?":"+g:""));if(this.Ov(b.quantileRegression[p])){b.minY=Math.min(b.minY,b.quantileRegression[p].range[2]);b.maxY=Math.max(b.maxY,b.quantileRegression[p].range[3])}}catch(c){f.push(["setQuantileRegressionData",r[0].length,p,c])}}}}}};this.ba=function(b,p){if(!b){if(!this.meta.data.s||(this.layoutValid&&this.meta.data.s.layout.length!=this.data.l.comp.length)){if(!this.meta.data.s){this.meta.data.s={areas:{},layout:[]};this.ba(true)}if(this.layoutValid&&this.meta.data.s.layout.length!=this.data.l.comp.length){for(var f=0;f<this.data.l.comp.length;f++){this.meta.data.s.layout[f]={areas:{}};this.ba(true,f)}}}}else{var c=p!=null?this.meta.data.s.layout[p]:this.meta.data.s;var g=[];var q=this.meta.data.z[this.colorBy].levels;var h=this.zK(this.ES(this.xAxisIndices[0],"x")).sort(function(w,j){return w-j});for(var f=0;f<q.length;f++){var s=this.J9(this.colorBy,q[f]);var l=this.ES(this.xAxisIndices[0],"x",s).sort(function(w,j){return w-j});var d=this.ES(this.yAxisIndices[0],"y",s).sort(function(w,j){return l[w]-l[j]});var t=0;var u=[[],[]];for(var e=0;e<h.length;e++){var s=l.indexOf(h[e]);if(s>=0){u[0].push(l[s]);u[1].push(d[s]);t=s}else{if(e==0){u[0].push(h[e]);u[1].push(h[e]<l[0]?NaN:0)}else{if(t<d.length){u[0].push(h[e]);u[1].push(this.KS(h[e-1],d[t],h[e+1],d[t+1],h[e]))}else{u[0].push(h[e]);u[1].push(NaN)}}}}c.areas[q[f]]=u}for(var f=0;f<q.length;f++){var r=c.areas[q[f]];for(e=0;e<h.length;e++){if(!g[e]){g[e]=0}if(!isNaN(c.areas[q[f]][1][e])){g[e]+=c.areas[q[f]][1][e]}}}c.totals=g;var k=Number.NEGATIVE_INFINITY;for(var f in g){k=Math.max(k,g[f])}c.minY=0;c.maxY=k;min=0;max=c.maxY}};this.Tw=function(q,F){if(!q){if(!this.meta.data.s||(this.layoutValid&&this.meta.data.s.layout.length!=this.data.l.comp.length)){if(!this.meta.data.s){this.meta.data.s={wiggles:{},layout:[]};this.Tw(true)}if(this.layoutValid&&this.meta.data.s.layout.length!=this.data.l.comp.length){for(var A=0;A<this.data.l.comp.length;A++){this.meta.data.s.layout[A]={wiggles:{}};this.Tw(true,A)}}}}else{var b=F!=null?this.meta.data.s.layout[F]:this.meta.data.s;var w=[];var t=this.meta.data.z[this.colorBy].levels;var k=this.zK(this.ES(this.xAxisIndices[0],"x")).sort(function(l,j){return l-j});var E=Number.POSITIVE_INFINITY;var D=Number.NEGATIVE_INFINITY;var B=Number.NEGATIVE_INFINITY;var p=this.meta.console;for(var A=0;A<t.length;A++){var r=this.J9(this.colorBy,t[A],F!=null?this.data.l.comp[F]:false);var s=this.ES(this.xAxisIndices[0],"x",r);var G=this.ES(this.yAxisIndices[0],"y",r);var g=[[],[]];for(var x=0;x<k.length;x++){var r=s.indexOf(k[x]);if(r>=0){g[0].push(s[r]);g[1].push(G[r])}else{g[0].push(k[x]);g[1].push(0)}}if(s.length>5){this.loessSpan=this.scatterStreamBandwidth?Math.max(0.1,this.scatterStreamBandwidth-0.45):0.3;try{var u=this.CO([g[0],g[1]],"Stream"+t[A]+(F!=null?F:""));for(var x=0;x<u.y.length;x++){u.y[x]=Math.max(u.y[x],0);B=Math.max(B,u.y[x])}E=Math.min(E,u.x[0]);D=Math.max(D,u.x[u.x.length-1]);b.wiggles[t[A]]=u}catch(f){p.push(["setStreamData",s.length,t[A],f])}}}var s=[];var h=(D-E)/(this.scatterStreamNumber-1);var y=(D-E)*this.scatterStreamExtraSpan;var C=B/500;for(var A=E-(this.scatterStreamTrueRange.match(/none|min_x/)?y:0);A<=D+(this.scatterStreamTrueRange.match(/none|max_x/)?y:0);A+=h){s.push(A)}for(var A=0;A<t.length;A++){var u=b.wiggles[t[A]];var d=this.gg(u.x);var c=this.gg(u.y);d.unshift(E-y);d.push(D+y);c.unshift(0);c.push(0);var e=this.Bt(d,c,s);for(var x=0;x<e[1].length;x++){e[1][x]=Math.max(e[1][x],C)}b.wiggles[t[A]].stream={x:e[0],y:e[1]};for(x=0;x<e[0].length;x++){if(!w[x]){w[x]=0}w[x]+=Math.abs(e[1][x]*0.5)}}b.totals=w;var a=Number.NEGATIVE_INFINITY;for(var A in w){a=Math.max(a,w[A])}b.minY=-a;b.maxY=a;switch(this.scatterStreamType){case"mirror":min=-a;max=a;break;case"ridge":min=0;max=a*2;break;case"proportional":min=0;max=1;break}}};this.yc=function(g){var d=Number.POSITIVE_INFINITY;var a=Number.NEGATIVE_INFINITY;var e=this.varIndices.length;for(var c=0;c<e;c++){var f=this.smpIndices.length;for(var b=0;b<f;b++){var h=g[this.varIndices[c]][this.smpIndices[b]];if(!isNaN(h)){d=Math.min(h,d);a=Math.max(h,a)}}}d=d==Number.POSITIVE_INFINITY||d==Number.NEGATIVE_INFINITY?-1:d;a=a==Number.NEGATIVE_INFINITY||a==Number.POSITIVE_INFINITY?1:a;return[d,a]};this.b8=function(){var d=this.data.y;if(this.isGroupedData){this.data.w={};d=this.data.w}var b=["vars","smps","labs","glab","desc","data","mean","median","stdev","n","qtl1","qtl3","iqr1","iqr3","out","conf","nfac","trans","tstdev","cor","min","max","sum","count","grps","grpIdxs","factors","scale"];var c=b.length;for(var a=0;a<c;a++){if(!d[b[a]]){if(b[a]=="factors"){d[b[a]]={}}else{d[b[a]]=[]}}}d.iqr=d.median};this.hE=function(a){var c=["mean","median","stdev","n","qtl1","qtl3","iqr1","iqr3","out","conf","nfac","cor","min","max","sum","count","grps","grpIdxs","factors","scale"];var d=c.length;if(this.isGroupedData){if(!this.isTransformedData){c.push("trans");c.push("tstdev")}d=c.length;for(var b=0;b<d;b++){delete (this.data.y[c[b]])}delete (this.data.w)}else{if(!this.isTransformedData){c.push("trans");c.push("tstdev")}d=c.length;if(this.isRawData){for(var b=0;b<d;b++){delete (this.data.y[c[b]])}}else{}}if(a&&this.isRawData){this.b8()}};this.HS=function(f,K){var b=this.isGroupedData?this.data.w:this.data.y;var h=this.isGroupedData?false:true;var C=Number.POSITIVE_INFINITY;var B=Number.NEGATIVE_INFINITY;if(!this.isGroupedData){this.b8()}var d=["trans","tstdev","mean","median","stdev","qtl1","qtl3","iqr1","iqr3","out","conf","nfac","n","min","max","sum","count","scale"];var G=function(j,c){if(!b[j][c]){b[j][c]=[]}};if(f=="gantt"){if(!this.data.gantt){this.isGanttDataFormated=false;this.cN()}var I=this.FP(this.ganttStart);var H=this.FP(this.ganttEnd);var M=this.lB(this.data.gantt);C=M[I].sort(function(j,c){return j-c})[0];B=M[H].sort(function(j,c){return c-j})[0];b.min=[[C]];b.max=[[B]];b.scale=this[this.axisAlgorithm](C,B,5,this.isGraphTime,this.axisWilkinsonLoose)}else{if(f=="cor"){this.isBoxplotCalc=false;if(this.correlationAxis=="samples"){if(this.isGroupedData&&b.cor.length==0){this.bD(true,true,true)}var s=this.isGroupedData?this.grpIndices:this.smpIndices;var l=s.length;for(var I=0;I<l;I++){var x=s[I];var t=this.uP(x);if(!b.cor[x]){b.cor[x]=[]}var g=s.length;for(var H=I;H<g;H++){var J=s[H];if(!b.cor[J]){b.cor[J]=[]}var r=this.uP(J);if(I==H){if(this.isTransformedData){b.trans[x][J]=1}b.cor[x][J]=1}else{b.cor[x][J]=this.nM(t,r);b.cor[J][x]=b.cor[x][J];if(this.isTransformedData){b.trans[x][J]=b.cor[x][J];b.trans[J][x]=b.cor[J][x]}}C=Math.min(C,b.cor[x][J]);B=Math.max(B,b.cor[x][J])}}}else{var l=this.varIndices.length;for(var I=0;I<l;I++){var x=this.varIndices[I];if(!b.cor[x]){b.cor[x]=[]}var g=this.varIndices.length;for(var H=I;H<g;H++){var J=this.varIndices[H];if(!b.cor[J]){b.cor[J]=[]}if(I==H){b.cor[x][J]=1;if(this.isTransformedData){b.trans[x][J]=1}}else{b.cor[x][J]=this.nM(b.data[x],b.data[J],h);b.cor[J][x]=b.cor[x][J];if(this.isTransformedData){b.trans[x][J]=b.cor[x][J];b.trans[J][x]=b.cor[J][x]}}C=Math.min(C,b.cor[x][J]);B=Math.max(B,b.cor[x][J])}}}b.min=[C];b.max=[B];b.scale=this[this.axisAlgorithm](C,B,5,this.isGraphTime,this.axisWilkinsonLoose)}else{this.isBoxplotCalc=f=="iqr"?true:false;var l=this.isDOE&&this.isDOE==1?this.data.y.vars.length:this.varIndices.length;for(var I=0;I<l;I++){var a;var x=this.varIndices[I];if(x==undefined){continue}var w=d.length;for(var H=0;H<w;H++){G(d[H],x)}if(this.isGroupedData){if(!K){var A=this.isTransformedData?this.data.y.trans:this.data.y.data;a=[];var q=this.data.w.grps.length;for(var H=0;H<q;H++){a[H]=[];var p=this.data.w.grps[H].length;for(var F=0;F<p;F++){var e=this.data.w.grps[H][F];a[H].push(A[x][e])}}}else{a=K[x]}}else{b.grps=[];a=[];var g=this.smpIndices.length;for(var H=0;H<g;H++){var J=this.smpIndices[H];b.grps[H]=[];b.grps[H].push(J);a[H]=[this.isTransformedData&&b.trans?b.trans[x][J]:b.data[x][J]]}}if(f=="iqr"){this.summaryType="iqr";if(this.isRawData){if(!this.isGroupedData){var g=this.smpIndices.length;for(var H=0;H<g;H++){var J=this.smpIndices[H];if(this.isTransformedData){b.trans[x][H]=a[H][0]}b.mean[x][J]=a[H][0];b.median[x][J]=a[H][0];b.qtl1[x][J]=a[H][0];b.qtl3[x][J]=a[H][0];b.iqr1[x][J]=a[H][0];b.iqr3[x][J]=a[H][0];b.out[x][J]=[];b.n[x][J]=1;b.conf[x][J]=[];b.min[x][J]=a[H][0];b.max[x][J]=a[H][0]}}else{var w=a.length;for(var H=0;H<w;H++){var y=this.MN(a[H]);if(this.isTransformedData){b.trans[x][H]=y[1]}b.mean[x][H]=y[0];b.median[x][H]=y[2];b.qtl1[x][H]=y[1];b.qtl3[x][H]=y[3];b.iqr1[x][H]=y[4];b.iqr3[x][H]=y[5];b.out[x][H]=y[6];b.n[x][H]=y[7];b.conf[x][H]=y[8]?y[8]:[];b.min[x][H]=y[9]?y[9][0]:NaN;b.max[x][H]=y[9]?y[9][1]:NaN}}}b.iqr=b.median}else{if(f=="median"){this.summaryType="median";if(this.isRawData){var w=a.length;for(var H=0;H<w;H++){var E=this.m8(a[H],h);var D=this.ds(a[H],h);var y=this.NC(a[H],h);if(this.isTransformedData){b.trans[x][H]=y[1]}b.min[x][H]=E;b.max[x][H]=D;b.median[x][H]=y[0];b.n[x][H]=y[1]}}}else{if(f=="mean"||f=="raw"){this.summaryType="mean";if(this.isRawData){var w=a.length;for(var H=0;H<w;H++){var E=this.m8(a[H],h);var D=this.ds(a[H],h);var y=this.hm(a[H],h);if(this.isTransformedData){b.trans[x][H]=y[0];b.tstdev[x][H]=y[1]}b.min[x][H]=E;b.max[x][H]=D;b.mean[x][H]=y[0];b.stdev[x][H]=y[1];b.n[x][H]=y[2]}}}else{if(f=="min"||f=="max"){this.summaryType=f;if(this.isRawData){var w=a.length;for(var H=0;H<w;H++){var E=this.m8(a[H],h);var D=this.ds(a[H],h);if(this.isTransformedData){b.trans[x][H]=D}b.min[x][H]=E;b.max[x][H]=D;b.n[x][H]=a[H].length}}}else{if(f=="sum"){this.summaryType="sum";if(this.isRawData){var w=a.length;for(var H=0;H<w;H++){var L=this.IK(a[H],h);if(this.isTransformedData){b.trans[x][H]=L}b.min[x][H]=0;b.max[x][H]=L;b.sum[x][H]=L;b.n[x][H]=a[H].length}}}else{if(f=="count"){this.summaryType="count";if(this.isRawData){var w=a.length;for(var H=0;H<w;H++){var u=a[H].length;if(this.isTransformedData){b.trans[x][H]=u}b.min[x][H]=0;b.max[x][H]=u;b.count[x][H]=u;b.n[x][H]=u}}}}}}}}}if(f=="iqr"){for(var I=0;I<b.n.length;I++){if(b.n[I]){for(var H=0;H<b.n[I].length;H++){b.nfac[I][H]=Math.sqrt((b.n[I][H])/(this.smpIndices.length))*2}}}}for(var I=0;I<b.min.length;I++){if(b.min[I]){for(var H=0;H<b.min[I].length;H++){C=Math.min(C,b.min[I][H]);B=Math.max(B,b.max[I][H])}}}b.scale=this[this.axisAlgorithm](C,B,this.xAxisTicks,this.isGraphTime,this.axisWilkinsonLoose)}}};this.WR=function(){var e=this.isGroupedData?this.data.w:this.data.y;var d;for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];e.data[c]=[];e.trans[c]=[];if(this.summaryType=="mean"){for(var a=0;a<e.mean[c].length;a++){e.data[c][a]=e.mean[c][a]}}else{if(this.summaryType=="median"||this.summaryType=="iqr"){for(var a=0;a<e.median[c].length;a++){e.data[c][a]=e.median[c][a]}}else{if(this.summaryType=="sum"){for(var a=0;a<e.sum[c].length;a++){e.data[c][a]=e.sum[c][a]}}else{if(this.summaryType=="max"){for(var a=0;a<e.max[c].length;a++){e.data[c][a]=e.max[c][a]}}else{if(this.summaryType=="min"){for(var a=0;a<e.min[c].length;a++){e.data[c][a]=e.min[c][a]}}else{if(this.summaryType=="count"){for(var a=0;a<e.count[c].length;a++){e.data[c][a]=e.count[c][a]}}}}}}}if(!d){d=c}}return d};this.Fc=function(b,c,a){switch(b){case"log2":return a?Math.pow(2,c):Math.log(c)/Math.LN2;case"log10":return a?Math.pow(10,c):Math.log(c)/Math.LN10;case"exp2":return a?Math.log(c)/Math.LN2:Math.pow(2,c);case"exp10":return a?Math.log(c)/Math.LN10:Math.pow(10,c);case"sqrt":return a?c*c:Math.sqrt(c);default:return c}};this.H6=function(e,d,a,c){if(this.QT()||this.graphType.match(/Area/)){return}if(!this.isGroupedData){this.b8()}var b=this.transformData;this.transformData=e;this.transformAxis=d;this.xAxisMaxStrLength=false;this.xAxis2MaxStrLength=false;this.yAxisMaxStrLength=false;this.zAxisMaxStrLength=false;if(e=="reset"||e=="undo"){this.xQ();this.transformData=false;this.isTransformedData=false;if(this.tempIndices){if(this.isGroupedData){this.grpIndices=this.tempIndices}else{this.smpIndices=this.tempIndices}this.tempIndices=false}}else{if(e=="save"){this.Ux();this.transformData=false;this.isTransformedData=false}else{if(e=="log2"||e=="log10"||e=="exp2"||e=="exp10"||e=="sqrt"){if(this.Zl(e)){this.isTransformedData=e}else{this.transformData=b;return}}else{if(e=="ratio2"||e=="ratio10"){this.HV(e,a);this.isTransformedData=e}else{this.Jb(e,d,!this.isRawData||this.isGroupedData?this.WR():0);this.isTransformedData=e}}}}delete (this.meta.def.colorBrew);if(this.graphType=="Boxplot"){this.summarizeBoxplot=true}this.by();if(!c){this.dG({func:"transform",par:[e,d,a,c]})}};this.xQ=function(){var d=this.data.y;for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];for(var a=0;a<d.data[c].length;a++){if(d.trans&&d.trans[c]&&!isNaN(d.data[c][a])){d.trans[c][a]=d.data[c][a]}}}if(this.isGroupedData){this.isTransformedData=false;this.Ph(this.groupingFactors,false,false,false,true)}};this.Ux=function(){var a=this.isGroupedData?this.groupingFactors:false;var e=this.data.y;if(e.trans&&e.trans.length>0){this.bD();for(var c=0;c<this.varIndices.length;c++){var d=this.varIndices[c];for(var b=0;b<e.data[d].length;b++){if(!isNaN(e.data[d][b])){e.data[d][b]=e.trans[d][b]}}}if(a){this.isTransformedData=false;this.Ph(a,false,false,false,true)}}};this.Zl=function(e){var g=this.data.y;var a=this.o1(g.data);if(e.match(/log/)){if(a[0]<=0){if(!this.nanOmit){alert("Cannot log transform values <= 0");return false}else{this.Ki("Dropping values <= 0");alert("Dropping values <= 0")}}e=e=="log2"?"log2":"log10"}else{if(e.match(/exp/)){if(a[1]>=1000){alert("Cannot exp transform values > 1000");return false}e=e=="exp2"?"exp2":"exp10"}}if(!g.trans){g.trans=[]}if(!g.tstdev){g.tstdev=[]}var f=this.motionBy?this.data.y.vars.length:this.isGroupedData?this.data.y.vars.length:!this.isDOE?this.data.y.vars.length:this.varIndices.length;for(var c=0;c<f;c++){var d=this.motionBy||!this.isDOE?c:this.varIndices[c];if(!g.trans[d]){g.trans[d]=[]}if(!g.tstdev[d]){g.tstdev[d]=[]}for(var b=0;b<g.data[d].length;b++){if(!isNaN(g.data[d][b])){if(e=="log2"){this.transformBase=2;g.trans[d][b]=Math.log(g.data[d][b])/Math.LN2}else{if(e=="log10"){this.transformBase=10;g.trans[d][b]=Math.log(g.data[d][b])/Math.LN10}else{if(e=="exp2"){this.transformBase=2;g.trans[d][b]=Math.pow(2,g.data[d][b])}else{if(e=="exp10"){this.transformBase=10;g.trans[d][b]=Math.pow(10,g.data[d][b])}else{if(e=="sqrt"){g.trans[d][b]=Math.sqrt(g.data[d][b])}}}}}}}}if(this.isGroupedData){this.isTransformedData=e;this.Ph(this.groupingFactors,false,false,true,true)}return true};this.HV=function(){var h=[];var q=this.data;var a=this.isGroupedData&&!this.graphType.match(/dotplot|boxplot/i)?q.w:q.y;if(this.isGroupedData&&this.ratioGroupReference&&q.x.hasOwnProperty(this.ratioGroupReference)){if(!this.ratioLevelReference){for(var w=0;w<q.x[this.ratioGroupReference].length;w++){if(q.x[this.ratioGroupReference][w]!=null){this.ratioLevelReference=q.x[this.ratioGroupReference][w];break}}}if(this.groupingFactors.length==1){this.ratioReference=this.u4(this.ratioLevelReference);if(this.ratioReference<0){this.ratioLevelReference=q.w.smps[0];this.ratioReference=0}h=[this.ratioReference]}else{var f=[];for(var w=0;w<this.groupingFactors.length;w++){if(this.groupingFactors[w]!=this.ratioGroupReference){f.push(this.groupingFactors[w])}}var b={};var y=[];var u=0;for(var w=0;w<this.smpIndices.length;w++){var k=this.smpIndices[w];var p=[];var C;for(var t=0;t<f.length;t++){var x=f[t];C=q.x[x][k];if(!C){C="NA"}p.push(C)}C=p.join(" - ");if(!b.hasOwnProperty(C)){q.w.smps.push(C);y[u]=C;b[C]=[];b[C].push(k);u++}else{b[C].push(k)}}h=this.sF(this.ratioGroupReference,this.ratioLevelReference);this.ratioReference=[];for(var w=0;w<q.w.grps.length;w++){var g=q.w.grps[w][0];var r=false;for(var s in b){for(var t=0;t<b[s].length;t++){if(g==b[s][t]){r=this.NB(b[s]);break}}if(r){break}}for(var t=0;t<h.length;t++){if(r.hasOwnProperty(h[t])){this.ratioReference.push(h[t]);break}}}}}else{if(this.ratioSampleReference){var A=this.isGroupedData&&this.graphType.match(/dotplot|boxplot/i);if(A){this.isGroupedData=false;this.ratioReference=this.u4(this.ratioSampleReference);this.isGroupedData=true}else{this.ratioReference=this.u4(this.ratioSampleReference)}}if(this.ratioReference<0){this.ratioSampleReference=q.y.smps[0];this.ratioReference=0}h=[this.ratioReference]}for(var w=0;w<this.varIndices.length;w++){var k=this.varIndices[w];if(!a.trans){a.trans=[]}if(!a.stdev){a.stdev=[]}if(!a.trans[k]){a.trans[k]=[]}if(!a.stdev[k]){a.stdev[k]=[]}for(var t=0;t<a.data[k].length;t++){var e;if(this.isGroupedData&&this.ratioGroupReference&&q.x.hasOwnProperty(this.ratioGroupReference)){if(this.groupingFactors.length==1){e=q.w.mean[k][this.ratioReference]}else{e=q.w.mean[k][this.ratioReference[t]]}}else{e=a.data[k][this.ratioReference]}if(!isNaN(a.data[k][t])&&!isNaN(e)&&e>0){var c=this.transformBase==2?"ratio2":"ratio10";var B=a.data[k][t]/e;var d=a.stdev[k][t];if(c=="ratio2"){a.trans[k][t]=Math.log(B)/Math.LN2;if(d&&d>0){a.tstdev[k][t]=Math.log(d)/Math.LN2}}else{if(c=="ratio10"){a.trans[k][t]=Math.log(B)/Math.LN10;if(d&&d>0){a.tstdev[k][t]=Math.log(d)/Math.LN10}}}}}}};this.Jb=function(u,q,p){var c=this.isGroupedData&&!this.graphType.match(/dotplot|boxplot/i)?this.data.w:this.data.y;var k=this.isGroupedData?false:true;var r;q=q?q:this.transformAxis;if(q=="samples"){for(var g=0;g<c.data[p].length;g++){var b=[];for(var d=0;d<this.varIndices.length;d++){var h=this.varIndices[d];b.push(c.data[h][g])}if(u=="percentile"){r=this.ID(b)}else{if(u=="zscore"){r=this.hm(b,k)}}for(var d=0;d<this.varIndices.length;d++){var h=this.varIndices[d];if(!c.trans){c.trans=[]}if(!c.trans[h]){c.trans[h]=[]}if(!isNaN(c.data[h][g])){if(u=="percentile"){c.trans[h][g]=this.W9(r[0],r[1],c.data[h][g])}else{if(u=="zscore"){c.trans[h][g]=(c.data[h][g]-r[0])/r[1]}}}}}}else{for(var g=0;g<this.varIndices.length;g++){var s=this.varIndices[g];if(!c.trans){c.trans=[]}if(!c.trans[s]){c.trans[s]=[]}var b=c.data[s];if(u=="percentile"){r=this.ID(b)}else{if(u=="zscore"){r=this.hm(b,k)}}for(var d=0;d<b.length;d++){if(!isNaN(c.data[s][d])){if(u=="percentile"){c.trans[s][d]=this.W9(r[0],r[1],c.data[s][d])}else{if(u=="zscore"){c.trans[s][d]=(c.data[s][d]-r[0])/r[1]}}}}}}};this.kX=function(c){var d=this.gg(this.segregateSamplesBy);var b=this.gg(this.segregateVariablesBy);this.un(true);this.Ph(c,false,false,true,true,true);this.Rz(b,d,true)};this.Ph=function(aj,T,u,ae,c,E,ak){var N=this;if(this.QT()){return}if(!this.isRawData){return}var ah=this.data;if(!this.eO(aj)){aj=[aj]}else{aj=this.zK(aj)}if(!aj||aj.length<1||!ah.x){return this.bD()}if(aj.length>1&&aj.includes("__FACTOR__")){aj=aj.filter(function(a){return a!="__FACTOR__"})}for(var aa=0;aa<aj.length;aa++){if(!aj||!ah.x[aj[aa]]){return this.bD()}}if(!this.isDOE&&this.layoutComb&&ah.l&&!this.iT(ah.l.group,aj)){this.kX(aj);ah.l.group=aj;if(!c){this.dG({func:"groupSamples",par:[aj,T,u,ae,c,E,ak]})}return}if(ah.l&&ah.l.group){ah.l.group=aj}var x={};var R={};var f=this.NB(this.smpOverlays);var B=ah.w&&ah.w.smps?ah.w.smps:false;var F=this.gg(this.hiddenGrps);if(!this.isDOE&&!ae){this.ta(true)}if(!ae){this.ta()}this.isGroupedData=true;this.groupingFactors=aj;this.hE(true);this.hiddenGrps=ak?F:[];this.isGroupedData=false;var an=this.smpIndices.length;for(var aa=0;aa<an;aa++){var A=this.smpIndices[aa];var I=[];var r=[];var D;var W;for(var Z=0;Z<aj.length;Z++){var O=aj[Z];D=this.PR(A,"x",O);if(this.meta.data.x[O].type=="Numeric"){D=D||"null"}else{D=D===false?"false":(D||"null")}I.push(D);if(!f.hasOwnProperty(O)){r.push(D)}}D=I.join(" :: ");W=r.length>0?r.join(" :: "):"";if(!x.hasOwnProperty(D)){ah.w.smps.push(D);R[D]=W;x[D]=[]}x[D].push(A)}this.isGroupedData=true;if(ah.w.smps.length<1){ah.w.smps=B;this.dG({func:"groupSamples",par:[aj,T,u,ae,c,E,ak]});return}if(this.isCxplot&&aj.length==1&&this.meta.data.x&&this.meta.data.x.hasOwnProperty(aj[0])&&this.meta.data.x[aj[0]].levels&&this.meta.data.x[aj[0]].type!="Numeric"){if(this.sortIncludeEmpty){if(this.meta.config.user.aes.hasOwnProperty("meta")){if(aj[0]==this.meta.config.user.aes.x&&this.meta.config.user.aes.meta.hasOwnProperty("xLabels")){var ab=this.gg(this.meta.config.user.aes.meta.xLabels);var ad=false;for(var aa=0;aa<ab.length;aa++){if(this.meta.data.x[aj[0]].levels.includes(ab[aa])){continue}else{ad=true}}ah.w.smps=ad?this.gg(this.meta.data.x[aj[0]].levels):ab}else{if(aj[0]==this.meta.config.user.aes.y&&this.meta.config.user.aes.meta.hasOwnProperty("yLabels")){var ab=this.gg(this.meta.config.user.aes.meta.yLabels);var ad=false;for(var aa=0;aa<ab.length;aa++){if(this.meta.data.x[aj[0]].levels.includes(ab[aa])){continue}else{ad=true}}ah.w.smps=ad?this.gg(this.meta.data.x[aj[0]].levels):ab}else{ah.w.smps=this.gg(this.meta.data.x[aj[0]].levels)}}}else{ah.w.smps=this.gg(this.meta.data.x[aj[0]].levels)}}}else{if(this.isCxplot&&aj.length==2&&this.meta.data.x&&this.meta.data.x.hasOwnProperty(aj[0])&&this.meta.data.x[aj[0]].levels&&this.meta.data.x[aj[0]].type!="Numeric"&&this.meta.data.x.hasOwnProperty(aj[1])&&this.meta.data.x[aj[1]].levels&&this.meta.data.x[aj[1]].type!="Numeric"){if(this.sortIncludeEmpty){var l=this.meta.data.x;ah.w.smps=this.gg(ah.w.smps.sort(function(s,k){var t=s.split(" :: ");var j=k.split(" :: ");var d=l[aj[0]].levels.indexOf(t[0]);var a=l[aj[0]].levels.indexOf(j[0]);if(d==a){d=l[aj[1]].levels.indexOf(t[1]);a=l[aj[1]].levels.indexOf(j[1])}return d-a}))}}else{if(this.sortOnGrouping){if(this.sortOnGrouping=="size"){ah.w.smps.sort(function(j,d){return x[j].length-x[d].length})}else{if(this.sortOnGrouping=="descending"){ah.w.smps.sort().reverse()}else{ah.w.smps.sort()}}}}}var an=ah.w.smps.length;for(var aa=0;aa<an;aa++){var D=ah.w.smps[aa];ah.w.labs.push(R[D]);ah.w.grps.push(x[D]);ah.w.grpIdxs.push(aa)}this.grpIndices=[];if(u){var an=u.length;for(var aa=0;aa<an;aa++){this.grpIndices.push(u[aa]);if(!ak){this.hiddenGrps.push(false)}}}else{var an=ah.w.grps.length;for(var aa=0;aa<an;aa++){this.grpIndices.push(aa);if(!ak){this.hiddenGrps.push(false)}}}var an=this.varIndices.length;var V=ah.w.vars;for(var aa=0;aa<an;aa++){V.push(ah.y.vars[this.varIndices[aa]])}var U={};var h=this.meta.data.x;for(var D in ah.x){U[D]=h[D].type=="Numeric"}var an=ah.w.grps.length;for(var aa=0;aa<an;aa++){var G=ah.w.grps[aa];var al=G?G.length:0;for(var D in ah.x){var g=ah.x[D];var af=ah.w.factors[D];if(!af){af=ah.w.factors[D]=[]}var L;if(U[D]){L=[];for(var Z=0;Z<al;Z++){var J=g[G[Z]];if(!isNaN(J)){L.push(J)}}af.push(this.fj(L))}else{L={};for(var Z=0;Z<al;Z++){var J=g[G[Z]];if(J!=null&&J!==""){L[J]=true}}var C=this.b6(L);af.push(C.join(" + "))}}}var ac=this.meta.data.x;for(var D in ah.x){if(ac[D]["boolean"]){var af=ah.w.factors[D];var y=af.length;for(var aa=0;aa<y;aa++){af[aa]=af[aa]!=="false"}}}var U=[];if(T){U=this.eO(T)?T:[T]}else{T=this.graphType=="Boxplot"?"iqr":this.graphType.match(/Stacked/i)?"sum":this.summaryType?this.summaryType:"mean";U.push(T)}var H=this.isTransformedData;var w=this.summaryType;var e=ah.y;for(var S=0,K=U.length;S<K;S++){var p=[];var am=U[S];var X=H?e.trans:true;var ag;if(H&&e.trans){ag=e.trans?e.trans:this.data.y.trans}else{if(this.isRawData){ag=e.data}else{ag=e[w]||e[this.summaryType]}}var an=this.isDOE&&this.isDOE==1?this.data.y.vars.length:this.varIndices.length;for(var aa=0;aa<an;aa++){var M=this.varIndices[aa];if(M==undefined){continue}var Q=p[M]=[];var q=ah.w.grps;var al=q.length;for(var Z=0;Z<al;Z++){var b=Q[Z]=[];var P=q[Z];var ai=P?P.length:0;for(var Y=0;Y<ai;Y++){b.push(ag[M][P[Y]])}}}this.HS(am,p)}this.QN();this.wT(false,false,false,!this.layoutComb);if(!E){this.xAxisValues=[];this.xAxis2Values=[];this.yAxisValues=[];this.zAxisValues=[];if(!this.layoutComb||!this.layoutAdjust){if(typeof(this.setAxes)=="function"){this.A9()}}}if(!X){this.Zl(this.isTransformedData)}if(!c){this.dG({func:"groupSamples",par:[aj,T,u,ae,c,E,ak]})}};this.bD=function(f,c,a){if(this.QT()){return}var b=this.groupingFactors.length==1&&this.groupingFactors[0]=="__FACTOR__";if(!this.isGroupedData&&!this.groupingFactors.length){return}this.ta(true);this.isGroupedData=false;var e=this.data;if(e.l){delete (e.l.group)}if(e.w&&!a){delete (e.w)}this.groupingFactors=[];this.hiddenGrps=[];this.af("w");if(!c){this.wT(false,false,false,true)}if(this.summaryType=="iqr"&&b){this.summaryType="raw";this.graphType="Bar"}if(!f){this.dG({func:"ungroupSamples",par:[f,c,a]})}return};this.cg=function(){this.isGroupedData=false;this.Ph(this.groupingFactors,false,false,false,true)};this.Ab=function(){var a={data:this.lB(this.data),config:this.PF()};a.config.groupingFactors=this.gg(this.groupingFactors);a.config.segregateVariablesBy=this.gg(this.segregateVariablesBy);a.config.segregateSamplesBy=this.gg(this.segregateSamplesBy);return a};this.HJ=function(b){this.Hu();if(this.QT()){return}if(this.isPivot){var a=this.lB(this.data.y.unpivoted);this.colorBy=a.config.colorBy;this.un(true);if(this.isGroupedData){this.bD(true)}this.gK(a.data,true);if(a.config.groupingFactors.length){this.Ph(a.config.groupingFactors,false,false,false,true)}this.isPivot=false;if(a.config.segregateVariablesBy.length||a.config.segregateSamplesBy.length){this.Rz(a.config.segregateVariablesBy,a.config.segregateSamplesBy,true)}if(!b){this.dG({func:"removePivot",par:[b]})}}this.wE()};this.zV=function(e,h){this.Hu();if(this.QT()){return}var b=this.Ab();this.isPivot=true;this.colorBy=false;var f={y:{data:[],vars:[],smps:[]}};this.un(true);if(this.isGroupedData){this.bD(true)}var g=e.shift();for(var d=0;d<e.length;d++){f.y.vars.push(e[d][0]);var a=[];for(var c=1;c<g.length;c++){a.push(e[d][c])}f.y.data.push(a)}g.shift();f.y.smps=g;this.gK(f,true);this.data.y.unpivoted=b;if(b.config.segregateVariablesBy.length||b.config.segregateSamplesBy.length){this.Rz(b.config.segregateVariablesBy,b.config.segregateSamplesBy,true)}this.hE();if(b.config.groupingFactors.length){this.groupingFactors=this.gg(b.config.groupingFactors);this.ub([cat],true,"groupingFactors")}if(!h){this.dG({func:"pivot",par:[e,h]})}this.wE()};this.hW=function(e,f){this.Hu();if(this.QT()){return}var r=this.Ab();var L={y:{vars:[],smps:[],data:[]}};var b=function(c){var d=[];for(var k=0;k<g.length;k++){if(g[k]!=e){var j=J.x[g[k]][c];if(j===false){j="false"}else{if(j===null){j="null"}else{if(j===true){j="true"}}}d.push(j.toString().replace("\x00",""))}}return d.length?d.join("\x00"):"x"+c};this.un(true);if(this.isGroupedData){this.bD(true)}var g=this.Nf(this.data.x);var E=this.meta.data.x[e];var J=this.data;var h=E.levels;var F=h.length;var y=[];var s={};var D=1;for(var I=0;I<F;I++){y[I]={};for(var H=0;H<J.y.smps.length;H++){v=J.x[e][H];if(v===false){v="false"}else{if(v===null){v="null"}else{if(v===true){v="true"}}}if(v==h[I]){var K=b(H);if(!y[I][K]){y[I][K]=[]}y[I][K].push(H)}if(K!=null){s[K]=true}}}for(var K in s){z=0;for(var I=0;I<F;I++){if(y[I].hasOwnProperty(K)){z=Math.max(z,y[I][K].length)}}s[K]=z}for(var I=0;I<F;I++){for(H=0;H<J.y.vars.length;H++){L.y.data[I+H]=[];if(J.y.vars.length==1){L.y.vars.push(h[I].replace("\x00",""))}else{L.y.vars.push(J.y.vars[H]+"::"+h[I].replace("\x00",""))}for(var K in s){for(var G=0;G<s[K];G++){if(I==0&&H==0){L.y.smps.push("Smp"+D++);var C=K.split("\x00");var B=0;for(var A=0;A<g.length;A++){if(g[A]!=e){if(!L.x){L.x={}}if(!L.x.hasOwnProperty(g[A])){L.x[g[A]]=[]}L.x[g[A]].push(C[B++])}}}if(y[I].hasOwnProperty(K)&&y[I][K][G]!=null){L.y.data[I+H].push(J.y.data[H][y[I][K][G]])}else{L.y.data[I+H].push(null)}}}}}if(L.y.data.length!=L.y.vars.length||L.y.data[0].length!=L.y.smps.length){if(r.config.segregateVariablesBy.length||r.config.segregateSamplesBy.length){this.Rz(L.config.segregateVariablesBy,L.config.segregateSamplesBy)}this.hE();if(r.config.groupingFactors.length){this.groupingFactors=this.gg(r.config.groupingFactors)}alert("Invalid Pivoting");return}else{this.isPivot=true;this.colorBy=false;r.factor=e}if(L.y.vars.includes("null")){var a=null;for(var I=0;I<L.y.vars.length;I++){if(L.y.vars[I]=="null"){a=I;break}}if(a!=null){L.y.vars.splice(a,1);L.y.data.splice(a,1)}}this.gK(L,true);this.data.y.unpivoted=r;this.hE();if(r.config.groupingFactors.length){this.groupingFactors=this.gg(r.config.groupingFactors);this.ub([e],true,"groupingFactors")}if(r.config.segregateVariablesBy.length||r.config.segregateSamplesBy.length){this.Rz(r.config.segregateVariablesBy,r.config.segregateSamplesBy,true)}if(!f){this.dG({func:"pivotX",par:[e,f]})}this.wE()};this.qO=function(h,a,g){var c=[];var f=this.data;for(var b=0;b<f.y.smps.length;b++){c.push([f.x[h][b],f.x[a][b],f.y.data[0][b]])}var e=this.im(c,0,1,2);return this.zV(e,g)};this.Qs=function(h,a,g){var e=[];var c;var f=this.data;if(f.x.hasOwnProperty(h)){for(var b=0;b<f.y.smps.length;b++){e.push([f.x[h][b],f.y.data[0][b],f.y.data[1][b]])}if(f.y.vars[0]==a){c=this.im(e,0,1,2)}else{if(f.y.vars[1]==a){c=this.im(e,0,2,1)}}}else{if(f.x.hasOwnProperty(a)){for(var b=0;b<f.y.smps.length;b++){e.push([f.x[a][b],f.y.data[0][b],f.y.data[1][b]])}if(f.y.vars[0]==h){c=this.im(e,1,0,2)}else{if(f.y.vars[1]==h){c=this.im(e,2,0,1)}}}}return this.zV(c,g)};this.uz=function(e,a,d){var c;e=this.FP(e);a=this.FP(a);for(var b=0;b<this.data.y.vars.length;b++){if(b!=e&&b!=a){c=b;break}}return this.zV(this.im(this.l4(this.data.y.data),e,a,c),d)};this.jK=function(f){var h=f.x;var g=f.z;if(h){f.z=h}else{delete (f.z)}if(g){f.x=g}else{delete (f.x)}var l=f.y.smps;f.y.smps=f.y.vars;f.y.vars=l;var k=f.y.data;f.y.data=[];var b=f.y.vars.length;for(var c=0;c<b;c++){f.y.data[c]=[];var e=f.y.smps.length;for(var a=0;a<e;a++){f.y.data[c][a]=k[a][c]}}return f};this.HH=function(C,f,a){if(this.QT()){return}this.Hu();if(this.graphType.match(/Gantt/)){this.oG(100,100,"Data transpose not allowed for Gantt graphs",5000);return}if(this.graphType=="Bar"&&this.barType=="lollipop"&&!a){this.oG(100,100,"Data transpose not allowed for Lollipops",5000);return}var A=this.data;var u=this.meta.data;if(C){return this.l4(C)}else{this.bD(true);this.H6("reset",false,false,true);if(A.l){delete (A.l)}var e=["varOverlays","varOverlayInfo","varOverlayProperties","varOverlaysStrLength","varOverlaysThicknessBottom","varOverlaysThicknessTop","varDendrogramNewick","colorVarDendrogramBy","heatmapVarSeparateBy","variablesClustered","segregateVariablesBy"];var g=["smpOverlays","smpOverlayInfo","smpOverlayProperties","smpOverlaysStrLength","smpOverlaysThicknessBottom","smpOverlaysThicknessTop","smpDendrogramNewick","colorSmpDendrogramBy","heatmapSmpSeparateBy","samplesClustered","segregateSamplesBy"];for(var y=0;y<e.length;y++){if(this[e[y]]||this[g[y]]){var p=this[e[y]];var q=this[g[y]];this[e[y]]=q;this[g[y]]=p}}var l=A.x;var k=A.z;if(l){A.z=l}else{delete (A.z)}if(k){A.x=k}else{delete (A.x)}var r=u.x;var c=u.z;u.x=c;u.z=r;for(var y in u.x){u.x[y].origin="x"}for(var y in u.z){u.z[y].origin="z"}var h=u.y.maxSmpChr;var b=u.y.maxSmpLen;var D=u.y.maxSmpStr;u.y.maxSmpChr=u.y.maxVarChr;u.y.maxSmpLen=u.y.maxVarLen;u.y.maxSmpStr=u.y.maxVarStr;u.y.maxVarChr=h;u.y.maxVarLen=b;u.y.maxVarStr=D;var t=A.y.smps;A.y.smps=A.y.vars;A.y.vars=t;var B=A.y.data;A.y.data=[];for(var y=0;y<A.y.vars.length;y++){A.y.data[y]=[];for(var w=0;w<A.y.smps.length;w++){A.y.data[y][w]=B[w][y]}}this.xAxis=[];this.yAxis=[];this.zAxis=[];this.gK(this.data);this.hE();this.wT(false,false,false,true);this.dataTableTransposed=!this.dataTableTransposed;if(!f){this.dG({func:"transpose",par:[C,f]})}this.wE()}};this.cR=function(){var q={};var x=[];var N=[];var I=[];var A=[];for(var F=0;F<this.varIndices.length;F++){var l=this.varIndices[F];var L=this.data.y.vars[l];x.push(L);q[L]={};for(var E=0;E<this.smpIndices.length;E++){var K=this.smpIndices[E];var J=this.data.y.smps[K];x.push(J);q[L][J]=this.data.y.data[l][K]}}x=this.zK(x);var B=x.length;var k=0;for(var F=0;F<B;F++){N[F]=[];A.push(this.Tr(0,B-1,1));var b=0;for(var E=0;E<B;E++){N[F][E]=0;if(q[x[F]]&&q[x[F]][x[E]]){N[F][E]=q[x[F]][x[E]]}b+=N[F][E]}I.push(b);k+=b}for(var F=0;F<A.length;F++){A[F].sort(function(d,c){return N[F][c]-N[F][d]})}if(this.circularArc>360){this.circularArc=360}else{if(this.circularArc<90){this.circularArc=90}}var y=this.circularArc*(Math.PI*2)/360;var p=(y-this.pu(this.arcSegmentsSeparation)*(this.circularArc==360?B:B-1))/k;var h=[];var f=[];var C=0;for(var F=0;F<B;F++){var a=C;for(var E=0;E<B;E++){var H=A[F][E];var M=N[F][H];var D=C;var P=C+=M*p;h[H*B+F]={idx:F,sid:H,start:D,end:P,value:M,color:this.colors[H%this.colors.length]}}f[F]={name:x[F],idx:F,start:a,end:C,value:I[F],color:this.colors[F%this.colors.length]};C+=this.pu(this.arcSegmentsSeparation)}var O=[];for(var F=0;F<B;F++){for(var E=F;E<B;E++){var e=h[E*B+F];var G=h[F*B+E];if(e.value||G.value){O.push({source:e,target:G})}}}return{chords:O,segments:f,total:k,unit:p}};this.Ho=function(){var b=[];for(var a=0;a<this.data.y.smps.length;a++){b.push(" ")}if(!this.data.x){this.data.x={}}this.data.x.__FACTOR__=b;this.af("x","__FACTOR__",false,true);this.Ph(["__FACTOR__"],false,false,false,true)};this.H2=function(b,e){if(b){this.data.y.smps.push("__COUNT__");for(var a=0;a<this.data.y.vars.length;a++){this.data.y.data[a].push(1)}}else{this.data.y.vars.push("__COUNT__");var c=[];for(var a=0;a<this.data.y.smps.length;a++){c.push(1)}this.data.y.data.push(c)}this.af("y");this.HY(true,true);this.Ec();if(!e){this.dG({func:"countData",par:[]})}};this.ud=function(b,c){if(b){var a=this.u4("__COUNT__");if(a>=0){this.data.y.smps.splice(a,1);for(var a=0;a<this.data.y.vars.length;a++){this.data.y.data[a].splice(a,1)}}}else{var a=this.FP("__COUNT__");if(a>=0){this.data.y.vars.splice(a,1);this.data.y.data.splice(a,1)}this.af("y");this.HY(true,true);this.Ec()}if(!c){this.dG({func:"uncountData",par:[]})}};this.Nc=function(b,e){if(b){this.data.y.smps.push("__SEQ__");for(var a=0;a<this.data.y.vars.length;a++){this.data.y.data[a].push(a+1)}}else{this.data.y.vars.push("__SEQ__");var c=[];for(var a=0;a<this.data.y.smps.length;a++){c.push(a+1)}this.data.y.data.push(c)}this.af("y");this.HY(true,true);this.Ec();if(!e){this.dG({func:"sequenceData",par:[]})}};this.rq=function(b,c){if(b){var a=this.u4("__SEQ__");if(a>=0){this.data.y.smps.splice(a,1);for(var a=0;a<this.data.y.vars.length;a++){this.data.y.data[a].splice(a,1)}}}else{var a=this.FP("__SEQ__");if(a>=0){this.data.y.vars.splice(a,1);this.data.y.data.splice(a,1)}}this.af("y");this.HY(true,true);this.Ec();if(!c){this.dG({func:"unsequenceData",par:[]})}};this.K6=function(){var w=this.isDOE?this.data.l.data[this.layoutCurrent]:false;var g=this.isDOE?w.y.data[0]:this.gg(this.data.y.data[this.meterIndex]);var u=this.isDOE?w.y.meter.group:this.meterGroup;var e=this.isDOE?w.x[u]:u?this.gg(this.data.x[u]):false;var h=this.isDOE?w.y.meter.summary:this.meterSummary;var c=this.isDOE?w.y.meter.topology:this.meterTopology;var q=u&&(!this.isDOE||this.isDOE==1)?this.meta.data.x[u]:u&&this.isDOE>1?this.meta.data.z[u]:false;var j=this.isDOE&&this.isDOE>1?this.varIndices:this.smpIndices;this.isMeterSummarized={data:g,count:g.length,sum:this.IK(g),mean:this.fj(g),max:this.ds(g)};var t=this.isMeterSummarized;var a=this.meterSegments.length&&!this.isDOE?this.meterSegments[this.meterSegments.length-1]:false;switch(h){case"count":case"countTotal":t.value=t.count;t.scale=this[this.axisAlgorithm](0,a||t.count,5,false,this.axisWilkinsonLoose);t.reference=t.count;break;case"average":t.value=t.mean;t.scale=this[this.axisAlgorithm](0,a||t.max,5,false,this.axisWilkinsonLoose);t.reference=t.max;break;case"sum":case"sumTotal":t.value=t.sum;t.scale=this[this.axisAlgorithm](0,a||t.sum,5,false,this.axisWilkinsonLoose);t.reference=t.sum;break;case"percentage":case"percentageTotal":t.value=100;t.scale=this[this.axisAlgorithm](0,a||100,5,false,this.axisWilkinsonLoose);t.reference=100;break}t.range=a||t.scale[t.scale.length-1];var k=this.JR();var b=this.isDOE?this.layoutWidth:this.width-(this.marginLeft+this.marginRight);var p=(this.isDOE?this.layoutHeight:this.height)-(k+this.marginTop+this.marginBottom);if(u){if(q&&q.type=="String"){t.n=q.levels.length;let ratio=b/p;let inverseRatio=p/b;let condition=t.n<2&&c=="auto";let condition2=c=="auto"&&ratio>t.n-0.5;let condition3=c=="auto"&&inverseRatio>t.n-0.5;let condition4=c=="horizontal";let condition5=c=="vertical";if(condition||condition2||condition4){t.cols=t.n;t.rows=1}else{if(condition3||condition5){t.cols=1;t.rows=t.n}else{t.cols=Math.ceil(Math.sqrt(t.n));t.rows=Math.ceil(t.n/t.cols)}}t[u]={};t.levels=q.levels;for(var f=0;f<j.length;f++){var d=e[f];if(!t[u][d]){t[u][d]={data:[],count:0,sum:0,mean:0,max:0}}t[u][d].data.push(g[f])}for(var f in t[u]){t[u][f].count=t[u][f].data.length;t[u][f].sum=this.IK(t[u][f].data);t[u][f].mean=this.fj(t[u][f].data);t[u][f].max=this.ds(t[u][f].data);switch(h){case"count":t[u][f].value=t[u][f].count;t[u][f].scale=this[this.axisAlgorithm](0,t[u][f].count,5,false,this.axisWilkinsonLoose);t[u][f].reference=t[u][f].count;break;case"countTotal":t[u][f].value=t[u][f].count;t[u][f].scale=this[this.axisAlgorithm](0,t.count,5,false,this.axisWilkinsonLoose);t[u][f].reference=t.count;break;case"average":t[u][f].value=t[u][f].mean;t[u][f].scale=this[this.axisAlgorithm](0,t[u][f].max,5,false,this.axisWilkinsonLoose);t[u][f].reference=t[u][f].max;break;case"sum":t[u][f].value=t[u][f].sum;t[u][f].scale=this[this.axisAlgorithm](0,t[u][f].sum,5,false,this.axisWilkinsonLoose);t[u][f].reference=t[u][f].sum;break;case"sumTotal":t[u][f].value=t[u][f].sum;t[u][f].scale=this[this.axisAlgorithm](0,t.sum,5,false,this.axisWilkinsonLoose);t[u][f].reference=t.sum;break;case"percentage":t[u][f].value=100;t[u][f].scale=this[this.axisAlgorithm](0,100,5,false,this.axisWilkinsonLoose);t[u][f].reference=100;break;case"percentageTotal":t[u][f].value=t[u][f].mean*100/t.max;t[u][f].scale=this[this.axisAlgorithm](0,Math.max(100,t[u][f].value),5,false,this.axisWilkinsonLoose);t[u][f].reference=Math.max(100,t[u][f].value);break}}}else{u=false}}if(!u){t.n=1;t.cols=1;t.rows=1}t.width=b/t.cols;t.height=p/t.rows};this.yH=function(){if(this.isSwimmerSumarized){if(this.isGroupedData!=this.isSwimmerSumarized.grouped){delete this.isSwimmerSumarized}}if(!this.isSwimmerSumarized){var w=this;var p=function(){var c={title:"Response",shape:[w.shapes[0],w.shapes[1]],shapeColor:["grey","grey"],size:[false,false],line:[false,false],lineColor:[false,false],lineStart:[false,false],lineEnd:[false,false],text:["Response Start","Response End"]};for(var e in B.color){c.shape.push(false);c.shapeColor.push(false);c.size.push(false);c.line.push("solid");c.lineColor.push(B.color[e]);c.lineStart.push(false);c.lineEnd.push(false);c.text.push(e)}c.shape.push("triangle");c.shapeColor.push("grey");c.size.push(false);c.line.push(false);c.lineColor.push(false);c.lineStart.push(false);c.lineEnd.push(false);c.text.push("Continued Response");return c};var B={high:[],cap:[],fill:[],color:{},shape:{},smps:{},grouped:this.isGroupedData};var a=this.zl();var b=this.FP(this.swimHigh);var r=this.FP(this.swimStart);var f=this.FP(this.swimEnd);if(!this.swimStatus){this.swimStatus="Status"}if(!this.swimHighCap){this.swimHighCap="HighCap"}var D=this.meta.data.x&&this.meta.data.x.hasOwnProperty(this.swimStatus)?this.meta.data.x[this.swimStatus]:false;var A=this.meta.data.x&&this.meta.data.x.hasOwnProperty(this.swimHighCap)?this.meta.data.x[this.swimHighCap]:false;if(this.isGroupedData){this.isGroupedData=false;for(var q=0;q<a.length;q++){for(var k=0;k<this.data.w.grps[a[q]].length;k++){var u=this.data.w.grps[a[q]][k];var t=this.VY(b,u,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue,this.xAxisFactorValue);var C=this.VY(r,u,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue,this.xAxisFactorValue);var x=this.VY(f,u,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue,this.xAxisFactorValue);B.smps[this.data.w.smps[a[q]]]=q;B.fill[q]=this.mU(a[q],u,"colorBy");if(D){var d=this.PR(u,"x",this.swimStatus);if(!B[d]){B[d]=[]}if(!B[d][q]){B[d][q]=[]}B[d][q].push([C,x]);B.color[d]=this.pQ(this.meta.data.x[this.swimStatus].colors[this.meta.data.x[this.swimStatus].order[d]],-50)}else{if(!B.none){B.none=[]}if(!B.none[q]){B.none[q]=[]}B.none[q].push([C,x]);B.color.none="green"}B.high.push(t);if(A){var y=this.PR(u,"x",this.swimHighCap);B.cap[q]=y&&y.match(/arrow/i)?true:false}}}this.isGroupedData=true}else{for(var q=0;q<a.length;q++){var t=this.VY(b,a[q],false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue,this.xAxisFactorValue);var C=this.VY(r,a[q],false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue,this.xAxisFactorValue);var x=this.VY(f,a[q],false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue,this.xAxisFactorValue);B.smps[this.data.y.smps[a[q]]]=q;B.fill[q]=this.mU(t[q],a[q],"colorBy");if(D){var d=this.PR(a[q],"x",this.swimStatus);if(!B[d]){B[d]=[]}if(!B[d][q]){B[d][q]=[]}B[d][q].push([C,x]);B.color[d]=this.pQ(this.meta.data.x[this.swimStatus].colors[this.meta.data.x[this.swimStatus].order[d]],-50)}else{if(!B.none){B.none=[]}if(!B.none[q]){B.none[q]=[]}B.none[q].push([C,x]);B.color.none="green"}B.high.push(t);if(A){var y=this.PR(a[q],"x",this.swimHighCap);B.cap[q]=y&&y.match(/arrow/i)?true:false}}}this.isSwimmerSumarized=B;this.customLegend[0]=p()}};this.qR=function(){if(this.isOncoprint&&!this.isOncoprintSumarized){var g=this;var r=this.data;var k=80;var q=this.meta.data;var p=function(){for(var c=0;c<q[g.oncoprintCNA].levels.length;c++){if(q[g.oncoprintCNA].levels[c].match(/ampli/i)){return c}}return false};var a=function(){for(var c=0;c<q[g.oncoprintCNA].levels.length;c++){if(q[g.oncoprintCNA].levels[c].match(/delet/i)){return c}}return false};var l=function(){var y=q[g.oncoprintCNA].levels.length;var x={};var t=p();var c=a();var w=[];if(t!=null){x[q[g.oncoprintCNA].levels[t]]="rgb(255,0,0)"}if(c!=null){x[q[g.oncoprintCNA].levels[c]]="rgb(0,0,255)"}for(var u=0;u<q[g.oncoprintCNA].levels.length;u++){var j=q[g.oncoprintCNA].levels[u];if(x.hasOwnProperty(j)){w.push(x[j])}else{if(j==""){w.push("rgb(220,220,220)")}else{w.push(g.colors[u])}}}q[g.oncoprintCNA].colors=w};var s=function(){if(g.oncoprintMUT){var j=q[g.oncoprintMUT].levels.length;if(CanvasXpress.colorSchemes.Greens[j]){q[g.oncoprintMUT].colors=CanvasXpress.colorSchemes.Greens[j]}else{if(j==2){var c=CanvasXpress.colorSchemes.Greens[3];q[g.oncoprintMUT].colors=[c[1],c[2]]}else{if(j==1){q[g.oncoprintMUT].colors=["rgb(0,153,0)"]}else{q[g.oncoprintMUT].colors=CanvasXpress.colorSchemes.Greens[9]}}}}};var f={cols:[],rows:[]};l();s();for(var e=0;e<r.y.vars.length;e++){f.rows[e]={CNA:{},MUT:{},TOT:0};for(var d=0;d<q[this.oncoprintCNA].levels.length;d++){var h=q[this.oncoprintCNA].levels[d];f.rows[e].CNA[h]=0}for(var d=0;d<q[this.oncoprintMUT].levels.length;d++){var b=q[this.oncoprintMUT].levels[d];f.rows[e].MUT[b]=0}}for(var e=0;e<r.y.smps.length;e++){f.cols[e]={CNA:{},MUT:{},TOT:0};for(var d=0;d<q[this.oncoprintCNA].levels.length;d++){var h=q[this.oncoprintCNA].levels[d];f.cols[e].CNA[h]=0}for(var d=0;d<q[this.oncoprintMUT].levels.length;d++){var b=q[this.oncoprintMUT].levels[d];f.cols[e].MUT[b]=0}}for(var e=0;e<r.y.vars.length;e++){for(var d=0;d<r.y.smps.length;d++){var h=this.VY(e,d,false,false,false,false,this.oncoprintCNA);var b=this.VY(e,d,false,false,false,false,this.oncoprintMUT);if(h){f.rows[e].CNA[h]++;f.cols[d].CNA[h]++}if(b){f.rows[e].MUT[b]++;f.cols[d].MUT[b]++}if(h||b){f.rows[e].TOT++;f.cols[d].TOT++}}}if(!r.z){r.z={}}for(var e=0;e<q[this.oncoprintCNA].levels.length;e++){var h=q[this.oncoprintCNA].levels[e];r.z[h]=[];for(var d=0;d<r.y.vars.length;d++){r.z[h][d]=f.rows[d].CNA[h]}this.af("z",h,false,true);this.varOverlayProperties[h]={type:"Stacked",position:"top",thickness:k,color:q[this.oncoprintCNA].colors[e],showName:false,showBox:false};if(this.oncoprintColSummary){this.varOverlays.push(h)}}for(var e=0;e<q[this.oncoprintMUT].levels.length;e++){var b=q[this.oncoprintMUT].levels[e];r.z[b]=[];for(var d=0;d<r.y.vars.length;d++){r.z[b][d]=f.rows[d].MUT[b]}this.af("z",b,false,true);this.varOverlayProperties[b]={type:"Stacked",position:"top",thickness:k,color:q[this.oncoprintMUT].colors[e],showName:false,showBox:false};if(this.oncoprintColSummary){this.varOverlays.push(b)}}r.z["Altered-Vars"]=[];r.z["% Altered-Vars"]=[];for(var e=0;e<r.y.vars.length;e++){r.z["Altered-Vars"][e]=f.rows[e].TOT;r.z["% Altered-Vars"][e]=(f.rows[e].TOT/r.y.smps.length*100).toFixed(1)+"%"}this.af("z","Altered-Vars",false,true);this.af("z","% Altered-Vars",false,true);this.varOverlayProperties["% Altered-Vars"]={type:"Text",position:"bottom",thickness:this.overlaysThickness+2,showName:false};if(!r.x){r.x={}}for(var e=0;e<q[this.oncoprintCNA].levels.length;e++){var h=q[this.oncoprintCNA].levels[e];r.x[h]=[];for(var d=0;d<r.y.smps.length;d++){r.x[h][d]=f.cols[d].CNA[h]}this.af("x",h,false,true);this.smpOverlayProperties[h]={type:"Stacked",position:"right",thickness:k,color:q[this.oncoprintCNA].colors[e],showName:false,showBox:false};if(this.oncoprintRowSummary){this.smpOverlays.push(h)}}for(var e=0;e<q[this.oncoprintMUT].levels.length;e++){var b=q[this.oncoprintMUT].levels[e];r.x[b]=[];for(var d=0;d<r.y.smps.length;d++){r.x[b][d]=f.cols[d].MUT[b]}this.af("x",b,false,true);this.smpOverlayProperties[b]={type:"Stacked",position:"right",thickness:k,color:q[this.oncoprintMUT].colors[e],showName:false,showBox:false};if(this.oncoprintRowSummary){this.smpOverlays.push(b)}}r.x["Altered-Smps"]=[];r.x["% Altered-Smps"]=[];for(var e=0;e<r.y.smps.length;e++){r.x["Altered-Smps"][e]=f.cols[e].TOT;r.x["% Altered-Smps"][e]=(f.cols[e].TOT/r.y.vars.length*100).toFixed(1)+"%"}this.af("x","Altered-Smps",false,true);this.af("x","% Altered-Smps",false,true);this.smpOverlayProperties["% Altered-Smps"]={type:"Text",position:"left",thickness:Math.ceil(q.x["% Altered-Smps"].maxLevLen),showName:false,rotate:true};if(this.oncoprintRowSummary){this.smpOverlays.push("% Altered-Smps")}this.isOncoprintSumarized=true;this.p0()}};this.B2=function(){if(this.isUpSet&&!this.isUpSetSumarized){this.isUpSetSumarized={vars:[],smps:[]};this.showHeatmapIndicator=false;this.showVariableNames=false;var l=[];var a=[];for(var g=0;g<this.data.y.smps.length;g++){l[g]=0;if(this.upSetSets.length){if(this.upSetSets.includes(this.data.y.smps[g])){a.push(g)}}else{a.push(g)}for(var f=0;f<this.data.y.vars.length;f++){if(this.data.y.data[f][g]>0){l[g]++}}}if(!this.data.x){this.data.x={}}this.data.x.Sets=l;a=a.sort(function(t,j){return l[j]-l[t]});if(!this.upSetSets.length){a=a.splice(0,this.nUpSets)}this.isUpSetSumarized.vars=this.gg(a.reverse());a=this.NB(a);var b=[];var p=[];var s=[];var c=[];var e={};var h={};var k=[];for(var g=0;g<this.data.y.vars.length;g++){p=[];b[g]=0;for(var f=0;f<this.data.y.smps.length;f++){if(this.data.y.data[g][f]>0){b[g]++;if(a.hasOwnProperty(f)){p.push(f)}}}var r=p.join(":");if(!e.hasOwnProperty(r)){e[r]=[]}e[r].push(g)}this.isUpSetSumarized.inter=e;var q=[];for(var g in e){var d=g.split(":").length;h[g]=e[g].length;if(g!=""){q.push(g)}for(var f=0;f<e[g].length;f++){s[e[g][f]]=h[g];c[e[g][f]]=g;k[e[g][f]]=d}}if(!this.data.z){this.data.z={}}this.data.z.Matrix=b;this.data.z.Size=s;this.data.z.Label=c;this.data.z.Terms=k;q=q.sort(function(t,j){return t.split(":").length-j.split(":").length||e[j].length-e[t].length});for(var g=0;g<q.length;g++){this.isUpSetSumarized.smps.push(e[q[g]][0])}this.smpIndices=this.isUpSetSumarized.vars;this.varIndices=this.isUpSetSumarized.smps;this.af("z","Matrix");this.af("z","Size");this.af("z","Label");this.af("z","Terms");this.varOverlayProperties.Size={type:"Bar",position:"top",color:this.upsetMainBarColor,thickness:(this.layoutValid?this.layoutHeight:this.height)*this.upsetMatrixPlotBarRatio,showBox:false};this.varOverlays.push("Size");this.af("x","Sets");this.smpOverlayProperties.Sets={type:"Bar",position:"left",color:this.upsetSetsBarColor,thickness:(this.layoutValid?this.layoutWidth:this.width)*0.2,showBox:false};this.smpOverlays.push("Sets")}};this.VY=function(h,g,p,d,f,q,r,l,b){var c=Number.NaN;var a=this.isGroupedData?this.data.w:this.data.y;if(l){c=this.data.y[l][h][g]}else{if(this.isGroupedData||!this.isRawData){if(this.isTransformedData){if(!p){c=a.trans[h][g]}else{if(p=="stdev"){c=a.tstdev[h][g]}else{if(a.hasOwnProperty(p)){c=a[p][h][g]}}}}else{p=p?p:this.summaryType;if(a.hasOwnProperty(p)){c=a[p][h]?a[p][h][g]:NaN}else{c=0}}}else{if(p){if(a[p]&&a[p][h]){c=a[p][h][g]}else{if(p=="sum"&&!this.isGroupedData){c=a.data[h][g]}}}else{if(this.isTransformedData&&a.trans&&a.trans.length){c=a.trans[h][g]}else{c=a.data[h][g]}if(b){c=b-c}}}}if(d!="percentile"&&((f!=null||q!=null||r))){if(r){if(p=="out"){for(var e=0;e<c.length;e++){c[e]*=r}}else{c*=r}}if(f!=null&&f!=false&&f!=undefined){if(p=="out"){for(var e=0;e<c.length;e++){c[e]=Math.max(f,c[e])}}else{c=Math.max(f,c)}}if(q!=null&&q!=false&&q!=undefined){if(p=="out"){for(var e=0;e<c.length;e++){c[e]=Math.min(q,c[e])}}else{c=Math.min(q,c)}}}if(d){if(!isNaN(c)){if(d=="log2"){c=Math.log(c)/Math.LN2}else{if(d=="log10"){c=Math.log(c)/Math.LN10}else{if(d=="exp2"){c=Math.pow(2,c)}else{if(d=="exp10"){c=Math.pow(10,c)}else{if(d=="sqrt"){c=Math.sqrt(c)}else{if(d=="percentile"){c=this.W9(f,q,c)}}}}}}}}return c==null?Number.NaN:c};this.Jn=function(b){var a=[];var d=this.data.y.data.length;for(var c=0;c<d;c++){a.push(this.data.y.data[c][b])}return a};this.uP=function(k,p,j,d){var h=[];if(!p){p=this.varIndices}if(this.isGroupedData||!this.isRawData){var b=this.isGroupedData?this.data.w:this.data.y;if(this.isTransformedData){if(b.trans[0]&&b.trans[0][k]){h.push(b.trans[0][k])}}else{j=this.summaryType=="iqr"?"median":this.summaryType;if(b.hasOwnProperty(j)&&b[j].length){var c=this.isDOE&&this.isDOE==1?this.data.y.vars.length:p.length;for(var g=0;g<c;g++){var l=p[g];if(b[j][l]){h.push(b[j][l][k])}}}}}else{var f=j?this.data.y[j]:this.data.y.data;var c=this.isDOE&&this.isDOE==1?this.data.y.vars.length:p.length;var a=this.xAxisIndices||[];var q=this.yAxisIndices||[];var e=a.includes(k)?"x":q.includes(k)?"y":false;if(this.isTransformedData){for(var g=0;g<c;g++){var l=p[g];if(this.data.y.trans[l]){h.push(this.data.y.trans[l][k])}}}else{if(d){for(var g=0;g<c;g++){var l=p[g];if(l==undefined){continue}h.push(this.VY(l,k,false,d,this[e+"AxisFloorValue"],this[e+"AxisCeilValue"],this[e+"AxisFactorValue"]))}}else{for(var g=0;g<c;g++){var l=p[g];if(f[l]){if(e){h.push(this.VY(l,k,false,d,this[e+"AxisFloorValue"],this[e+"AxisCeilValue"],this[e+"AxisFactorValue"]))}else{h.push(f[l][k])}}}}}}return h};this.uV=function(b){var a=[];var e=this.smpIndices.length;if(this.isTransformedData){for(var c=0;c<e;c++){var d=this.smpIndices[c];a.push(this.data.y.trans[b][d])}}else{for(var c=0;c<e;c++){var d=this.smpIndices[c];a.push(this.data.y.data[b][d])}}return a};this.et=function(a){var c={};if(this.data.z){for(var b in this.data.z){c[b]=this.PR(a,"z",b)}}c[name]=this.data.y.vars[a];return c};this.AL=function(a){if(this.isGroupedData){return this.BO(a)}else{return this.Cb(a)}};this.Cb=function(a){var c={};if(this.data.x){for(var b in this.data.x){c[b]=this.PR(a,"x",b)}}else{i=Math.min(Math.max(Math.floor(v*(m.vals.length+1)/m.vals[n])-1,0),n)}c.name=this.data.y.vars[a];return c};this.BO=function(a){var d=[];var e=this.data.w.grps[a].length;for(var b=0;b<e;b++){var c=this.data.w.grps[a][b];d.push(this.getMetaDataForSmpAtIndex[c])}return d};this.wT=function(f,a,b,e){var d=this.layoutComb&&this.layoutParams?this.layoutParams[f||0]:this;if(!a){a=d.varIndices}if(!b){b=this.isGroupedData?d.grpIndices:d.smpIndices}if(e||!d.startingVarIndices||d.startingVarIndices.length==0){d.startingVarIndices=this.gg(a)}if(this.isGroupedData){if(e||!d.startingGrpIndices||d.startingGrpIndices.length==0){d.startingGrpIndices=this.gg(b)}}else{if(e||!d.startingSmpIndices||d.startingSmpIndices.length==0){d.startingSmpIndices=this.gg(b)}}};this.hU=function(c){var f=["colorNodeBy","shapeNodeBy","sizeNodeBy","patternNodeBy"];var h=["colorEdgeBy","SizeEdgeBy"];var g=this.meta.data;for(var e=0;e<f.length;e++){var b=this[f[e]];if(!g.nodes.hasOwnProperty(b)){this[f[e]]=false}}for(var e=0;e<h.length;e++){var b=this[h[e]];if(!g.edges.hasOwnProperty(b)){this[h[e]]=false}}if(this.decorations){var k=[];for(var e=0;e<this.decorations.length;e++){var j=this.decorations[e];if(g.nodes.hasOwnProperty(j)){k.push(j)}}this.decorations=k}if(c){this.bV()}};this.C6=function(c){var p=this;var k=["color","shape","size","line","pattern","outline","connect","motion","ellipse","ridge","stack"];var b="";var h=function(){if(p.graphType.match(/Scatter/)){if(p.meta.data.hasOwnProperty("z")&&p.meta.data.z.hasOwnProperty("variable")){return"variable"}else{return false}}else{if(p.meta.data.hasOwnProperty("x")&&p.meta.data.x.hasOwnProperty("variable")){return"variable"}else{return false}}};for(var f=0;f<k.length;f++){var r=this[k[f]+"By"];if(this.eO(r)){r=r[0]}var q=this[r+"Data"];if(r){if(this.isMultidimensionalData){if(q&&!this.data.y[q]){this[k[f]+"By"]=false;this[r+"Data"]=false}}else{if(r=="variable"){continue}else{if(r=="data"&&this.ridgeBy){continue}else{if(this.data.x&&this.data.x.hasOwnProperty(r)){continue}else{if(this.data.z&&this.data.z.hasOwnProperty(r)){if(k[f].match(/ellipse|ridge/)&&this.meta.data.z[r].type=="Numeric"){this[k[f]+"By"]=false}continue}else{if(this.u4(r)!=-1||this.u4(r,true)!=-1){continue}else{if(this.graphType.match(/Scatter/)&&r=="sample"&&(k[f]=="shape"||k[f]=="color")){continue}else{this[k[f]+"By"]=false}}}}}}}}}if(this.treemapBy.length>0){var g=[];var e=[];for(var f=0;f<this.treemapBy.length;f++){if(this.treemapBy[f]=="sample"){e.push("sample")}else{if(!this.data.x||!this.data.x.hasOwnProperty(this.treemapBy[f])){e.push("sample")}else{if(this.data.x&&this.data.x.hasOwnProperty(this.treemapBy[f])){g.push(this.treemapBy[f])}}}}if(e.length>0){}this.treemapBy=g}var j=this.graphType.match(/Boxplot|Dotplot|Gantt|Scatter|Map/)||this.graphType=="Tree";if(this.shapeBy&&!this.isMultidimensionalData&&!j){b+="shapeBy changed to false (shapeBy not support in"+this.graphType+")\n";this.shapeBy=false}else{if(this.shapeBy&&this.groupingFactors.length>1&&!j){b+="shapeBy changed to variable (multiple grouping factors not allowed)\n";this.shapeBy="variable"}else{if(this.shapeBy&&this.groupingFactors.length==1&&this.shapeBy!=this.groupingFactors[0]&&!j){b+="shapeBy changed to variable (grouping factor should the same as shapeBy)\n";this.shapeBy="variable"}}}if(this.sizeBy&&!this.isMultidimensionalData&&!j){b+="sizeBy changed to false (sizeBy not support in"+this.graphType+")\n";this.sizeBy=false}else{if(this.sizeBy&&this.groupingFactors.length>1&&!j){b+="sizeBy changed to variable (multiple grouping factors not allowed)\n";this.sizeBy="variable"}else{if(this.sizeBy&&this.groupingFactors.length==1&&this.sizeBy!=this.groupingFactors[0]&&!j){b+="sizeBy changed to variable (grouping factor should the same as sizeBy)\n";this.sizeBy="variable"}}}if(this.colorBy&&this.graphType=="Heatmap"&&!this.isMultidimensionalData){b+="colorBy changed to false (colorBy not support in"+this.graphType+")\n";this.colorBy=false}else{if(this.colorBy&&this.groupingFactors.length>1&&!this.graphType.match(/Boxplot|Dotplot|Gantt|Scatter|Stacked|Treemap/)){b+="colorBy changed to variable (multiple grouping factors not allowed)\n";this.colorBy="variable"}else{if(this.colorBy&&this.groupingFactors.length==1&&this.colorBy!=this.groupingFactors[0]&&!this.graphType.match(/Boxplot|Dotplot|Gantt|Scatter|Stacked|Treemap|Line/)&&this.barType!="swimmer"){b+="colorBy changed to variable (grouping factor should the same as colorBy)\n";this.colorBy="variable"}}}if((this.shapeBy||this.sizeBy||this.patternBy||this.outlineBy)&&!this.colorBy&&!this.isMultidimensionalData&&!this.graphType=="Heatmap"&&!this.isCxplot){this.colorBy="variable"}else{if(!this.shapeBy&&!this.sizeBy&&!this.patternBy&&this.colorBy=="variable"){this.colorBy=h()}}if(this.shapeBy=="variable"&&!this.colorBy&&!this.graphType.match(/Scatter/)){this.colorBy="variable"}if(this.sizeBy=="variable"&&!this.colorBy&&!this.graphType.match(/Scatter/)){this.colorBy="variable"}if(this.patternBy=="variable"&&!this.colorBy&&!this.graphType.match(/Scatter/)){this.colorBy="variable"}if(this.stackBy&&!this.colorBy){this.colorBy=this.stackBy}else{if(this.stackBy&&this.colorBy&&this.stackBy!=this.colorBy){b+="colorBy changed to stackBy (remove stackBy to color by different factor)\n";this.colorBy=this.stackBy}}if(this.dodgeBy&&!this.colorBy){this.colorBy=this.dodgeBy}else{if(this.dodgeBy&&this.colorBy&&this.dodgeBy!=this.colorBy){b+="colorBy changed to dodgeBy (remove dodgeBy to color by different factor)\n";this.colorBy=this.dodgeBy}}if(this.lineBy&&!this.colorBy&&this.isGroupedData){}else{if(this.lineBy&&this.colorBy&&this.lineBy!=this.colorBy&&this.isGroupedData){b+="colorBy changed to lineBy (remove lineBy to color by different factor)\n";this.colorBy=this.lineBy}else{if(this.lineBy&&!this.isGroupedData&&this.graphType!="Scatter2D"){b+="Data needs to be grouped";this.lineBy=false}}}if(b!=""){this.oG(10,10,b,3000)}if(c){this.bV()}};this.sO=function(e,d){var a=[];if(this.meta.data[e]){for(var b in this.meta.data[e]){if(d&&this.meta.data[e][b].type==d){a.push(b)}else{if(!d){a.push(b)}}}}return a};this.R0=function(d,f,c,k,e){var l=d.vals.length-1;var g;if((k[e]=="shapes"&&!this.shapeByContinuous)||(k[e]=="sizes"&&!this.sizeByContinuous)){for(var j=0;j<d.vals.length;j++){if(f<=d.vals[j]){g=j;break}}}else{g=Math.min(Math.max(Math.floor(f*(d.vals.length+1)/d.vals[l])-1,0),l)}return c?g:parseInt(this[k[e]][g%this[k[e]].length])};this.Yg=function(b,d,c){var e=b.vals?b.vals.length-1:b.values.length-1;return parseFloat((((d-b.min)/(b.max-b.min))*(this[c][e]-this[c][0])))+parseInt(this[c][0])};this.PR=function(a,d,e,c){var f=d=="x"?this.data.x:d=="z"?this.data.z:false;if(this.isGroupedData&&!c&&d!="z"){var b=this.data.w;return b&&b.factors.hasOwnProperty(e)?b.factors[e][a]:"NoCatFound"}else{if(f&&f.hasOwnProperty(e)){return f[e][a]}else{return undefined}}};this.eP=function(e,c,r){var g=e?this.meta.data.nodes:this.meta.data.edges;var b=this[r];var k={colorNodeBy:"colors",colorEdgeBy:"colors",shapeNodeBy:"shapes",sizeNodeBy:"sizes",sizeEdgeBy:"sizes",patternNodeBy:"patterns"};var l=0.5;if(e){if(b&&g.hasOwnProperty(b)&&e.hasOwnProperty(b)&&e[b]!=null){if(g[b].type=="Numeric"&&r!="shapeNodeBy"){switch(r){case"colorNodeBy":return e[b]!=null?this.eN(g[b].colorBrew,Number(e[b])):false;case"shapeNodeBy":var j=parseInt(this.W9(g[b].min,g[b].max,Number(e[b]))/10);return j==10?"circle":"pie"+j;case"sizeNodeBy":var q=g[b].max-g[b].min<=10?100:g[b].max-g[b].min<=100?50:20;var j=parseInt(this.W9(g[b].min,g[b].max,Number(e[b])))/q;return Math.pow(l+j,2);case"patternNodeBy":return"closed"}}else{if(k[r]){var j=g[b].order[e[b]];return g[b][k[r]][j]}else{alert("Ooops")}}}else{r=r.replace("NodeBy","");if(e.hasOwnProperty(r)){return e[r]}else{switch(r){case"color":return this.nodeColor;case"shape":return"circle";case"size":return 1;case"pattern":return"closed"}}}}else{if(b&&g.hasOwnProperty(b)&&(c.hasOwnProperty(b))){if(r=="colorEdgeBy"){if(g[b].type=="Numeric"){return this.eN(g[b].colorBrew,Number(c[b]))}else{if(k[r]){var j=g[b].order[c[b]];return g[b][k[r]][j]}else{alert("Ooops")}}}else{if(r="sizeEdgeBy"){if(g[b].type=="Numeric"){l=Math.min(this.minEdgeSize,this.edgeThickness);var j=(parseInt(this.W9(g[b].min,g[b].max,Number(c[b]||g[b].min)))/100)*this.maxEdgeSize*this.edgeThickness;return l+(isNaN(j)?l:j)}else{if(k[r]){var j=g[b].order[c[b]];return j*this.edgeThickness}else{alert("Ooops")}}}else{alert("Ooops. Not implemented yet!")}}}else{if(r=="colorEdgeBy"){return c.color||this.edgeColor}else{if(r="sizeEdgeBy"){return c.thickness||this.edgeThickness}else{alert("Ooops. Not implemented yet!")}}}}};this.mU=function(I,G,H,F,x){var e=this;var A,y,j,D,k;var w=F||this[H];var E=this.tO();var C=this.groupingFactors&&this.groupingFactors.length==1;var r=this.data;var J=this.meta.data;var B={colorVarDendrogramBy:"colors",colorSmpDendrogramBy:"colors",colorBy:"colors",colorLabelBy:"colors",colorByData:"colors",outlineBy:"colors",outlineByData:"colors",markerBy:"colors",shapeBy:"shapes",shapeByData:"shapes",sizeBy:"sizes",sizeLabelBy:"sizes",sizeByData:"sizes",patternBy:"patterns",patternByData:"patterns",stackBy:"colors",dodgeBy:"colors",lineBy:"colors",linePatternBy:"linePatterns",confidenceBy:"colors"};var d=function(){var b={};var h=0;if(G>=0&&r.w.grps[G]){for(var g=0;g<r.w.grps[G].length;g++){var c=J.x[w].type;var a=r.x[w][r.w.grps[G][g]];if(!b.hasOwnProperty(a)){b[a]=true;h++}if(h>1){return false}}}return true};var f=function(){if(!e.patternBy){if(I>e.colors.length-1&&!e.colorBy){return e[B[H]][Math.floor(I/e.colors.length)]}else{return e[B[H]][0]}}else{return e[B[H]][0]}};var u=H&&this[B[H]]?this[B[H]].length:false;if(I!=null&&G!=null&&w&&r.y.hasOwnProperty(w)){A=r.y[w][I][G];y=J[w];j=y.type}else{if(G!=null&&w&&r.x&&r.x.hasOwnProperty(w)){y=J.x[w];if(E||!this.isGroupedData){j=y.type;A=this.graphType=="Gantt"?r.x[w][G]:this.isGroupedData?r.w.smps[G]:r.x[w][G];if(y[H]&&y[H].hasOwnProperty(A)){return y[H][A]}else{if(H=="colorSmpDendrogramBy"&&y.colorBy&&y.colorBy.hasOwnProperty(A)){return y.colorBy[A]}}}else{if(C&&(this.groupingFactors[0]==w||d())){j=y.type;A=G!==false&&G>=0&&r.w.grps[G]?r.x[w][r.w.grps[G][0]]:false;if(A&&H.match(/color|patternBy/)){if(y[H]&&y[H].hasOwnProperty(A)){return y[H][A]}else{if(y[B[H]]){return y[B[H]][y.order[A]%u]}else{return this[B[H]][y.order[A]%u]}}}else{return y[B[H]]?y[B[H]][0]:H.match(/color/)?this[B[H]][0]:H=="patternBy"?f():this[B[H]][0]}}else{return I!=null&&H.match(/color/)?this[B[H]][I%u]:H=="patternBy"?f():this[B[H]][0]}}}else{if(I!=null&&w&&r.z&&r.z.hasOwnProperty(w)){y=J.z[w];j=y.type;A=r.z[w][I];if(y[H]&&y[H].hasOwnProperty(A)){return y[H][A]}else{if(y[H]&&y[H].hasOwnProperty(A+"\x00")){return y[H][A+"\x00"]}else{if(H=="colorVarDendrogramBy"&&y.colorBy&&y.colorBy.hasOwnProperty(A)){return y.colorBy[A]}else{if(y[H]&&H=="linePatterns"&&y.order&&y.order.hasOwnProperty(A)){return y[H][y.order[A]%this[H].length]}}}}}else{if(I!=null&&G!=null&&H&&((this.isGroupedData&&J.w.smps.hasOwnProperty(H))||(!this.isGroupedData&&J.y.range.hasOwnProperty(H)))){A=r.y.data[I][G];y=J.y.range[H];j=J.y.type}else{if(I!=null&&!this.isGroupedData&&w&&J.y.range.hasOwnProperty(w)){y=J.y.range[w];j=y.type;k=G!=null?false:this.u4(w);A=G!=null?r.y.data[I][G]:r.y.data[I]?r.y.data[I][k>=0?k:0]:0;if(J.modified&&J.modified.z&&J.modified.z[w]){return this[B[H]][A%u]}else{if(!y.colorBrew){y.colorBrew=this.s8(false,y.min,y.max);y.vals=y.colorBrew.vals}}}else{if(I!=null){if(w){return this[B[H]][I%u]}else{return !w&&H.match(/color/)?this[B[H]][I%u]:H=="patternBy"?f():this[B[H]][0]}}else{return this[B[H]][0]}}}}}}if(j=="Numeric"){if(H.match(/color|outlineBy/)){return !isNaN(A)&&A!==null?this.eN(y.colorBrew,Number(A)):this.missingDataColor}else{if(H.match(/shapeBy/)){if(!isNaN(A)){return this.shapeByContinuous?"pie"+this.R0(y,A,true,B,H):this[B[H]][this.R0(y,A,true,B,H)]}else{return"sphere"}}else{if(H.match(/sizeBy/)){if(!isNaN(A)){return this.sizeByContinuous?this.Yg(y,A,B[H]):this.R0(y,A,false,B,H)}else{return this[B[H]][0]}}else{if(H.match(/patternBy/)){if(!isNaN(A)){return this.R0(y,A,false,B,H)}else{return"closed"}}}}}}else{if(j=="String"){if(y[B[H]]){if(x){if(H=="sizeLabelBy"){return this.nU([5,9,13,17,21],this.W9(y[B[H]][0],y[B[H]][y[B[H]].length-1],y[B[H]][y.order[A]%y[B[H]].length])/100)}else{return this.W9(y[B[H]][0],y[B[H]][y[B[H]].length-1],y[B[H]][y.order[A]%y[B[H]].length])}}else{return H=="sizeBy"?parseInt(y[B[H]][y.order[A]%y[B[H]].length]):y[B[H]][y.order[A]%y[B[H]].length]}}else{return H=="sizeBy"?parseInt(this[B[H]][y.order[A]%this[B[H]].length]):this[B[H]][y.order[A]%this[B[H]].length]}}}};this.hr=function(a,t){var s=this.meta.data;var d=this.data;var u=this.graphType=="Network"?["nodes","edges"]:["x","z"];if(a&&t){t.colors=a;t.connects=a}else{for(var p=0;p<u.length;p++){var f=u[p];if(d[f]){if(this.graphType=="Network"){this.decorationsTextColors=[];return}else{var b=d[f]||s[f];for(var h in b){if(s[f][h].type=="String"){var r=b[h];var q=this.Be(d[f]?r:r.levels);var c=this.Aw(q);var e=c.length;if((!this.colorKey&&this.graphType!="Map")||(this.colorKey&&!this.colorKey.hasOwnProperty(h))){s[f][h].colors=[];var w=0;if(e!=a.length&&this.colorScheme){var g=this.P8(e,this.colorScheme);for(var l=0;l<c.length;l++){s[f][h].colors.push(g[w%g.length]);w++}}else{for(var l=0;l<c.length;l++){s[f][h].colors.push(a[w%a.length]);w++}}}}}}}}}};this.QN=function(){if(this.groupingFactors.length){var e=true;if(this.colorBy&&this.groupingFactors.includes(this.colorBy)&&this.data.w&&this.groupingFactors.length>1){e=false;var a=this.groupingFactors.indexOf(this.colorBy);for(var c=0;c<this.data.w.smps.length;c++){if(this.data.w.smps[c].length){if(!this.data.w.glab[c]){this.data.w.glab[c]=this.gg(this.data.w.smps[c])}var d=this.data.w.glab[c].split(" :: ");d.splice(a,1).join(" :: ");if(this.showLegend){this.data.w.smps[c]=d}}}}if(this.shapeBy&&this.groupingFactors.includes(this.shapeBy)&&this.data.w&&this.groupingFactors.length>1){e=false;var a=this.groupingFactors.indexOf(this.shapeBy);for(var c=0;c<this.data.w.smps.length;c++){if(this.data.w.smps[c].length){if(!this.data.w.glab[c]){this.data.w.glab[c]=this.gg(this.data.w.smps[c])}var d=this.data.w.glab[c].split(" :: ");d.splice(a,1).join(" :: ");if(this.showLegend){this.data.w.smps[c]=d}}}}if(e){if(this.data.w&&this.data.w.glab.length==this.data.w.smps.length){this.data.w.smps=this.gg(this.data.w.glab)}}}if(this.data.w&&this.data.w.smps&&this.groupingFactors.length){for(var c=0;c<this.segregateSamplesBy.length;c++){var a=this.groupingFactors.indexOf(this.segregateSamplesBy[c]);for(var b=0;b<this.data.w.smps.length;b++){if(this.data.w.smps[b].length){if(!this.data.w.glab[b]){this.data.w.glab[b]=this.gg(this.data.w.smps[b])}var d=this.data.w.glab[b].split(" :: ");if(a>=0){d.splice(a,1).join(" :: ")}else{d=d.join(" :: ")}this.data.w.smps[b]=d}}}}if(this.data.w){this.af("w")}};this.By=function(b,f,c){if(b!=null&&f){if(!c){c=this.JG(f)}var e=[];if(this.eO(b)){if(this.eO(f)){var g=b.length;for(var d=0;d<g;d++){if(c.hasOwnProperty(b[d])){e.push(c[b[d]])}}return e}else{return c.hasOwnProperty(f)?c[f[d]]:-1}}else{return f.indexOf(b)}}};this.Mk=function(q,d,p,h,b){var j=[];var t={};var e=this.data[p];var g=this.meta.data[p];if(e&&q&&e[q]){g=g[q];for(var k=0;k<d.length;k++){var r=d[k];var f=this.PR(r,p,q,h)||"";if(!t.hasOwnProperty(f)){j.push(f)}t[f]=true}if(g&&b){if(g.monthDay){j=j.sort(function(l,c){return parseInt(CanvasXpress.dates[l])-parseInt(CanvasXpress.dates[c])})}else{if(this.scatterPlotMatrix){j=j.sort(function(l,c){return l.toLowerCase().localeCompare(c.toLowerCase())})}else{j=j.sort(function(l,c){return g.n[g.order[c]]-g.n[g.order[l]]||c>l})}}}}return j};this.NO=function(j,d,b,g,f){var q=[];o=this.data[g];if(o&&j&&o[j]){if(d){for(var e=0;e<b.length;e++){var p=b[e];var k=this.PR(p,g,j);if(k==d){if(f&&!f[p]){q.push(p)}else{q.push(p)}}}}else{for(var e=0;e<b.length;e++){var p=b[e];var k=this.PR(p,g,j);if(!k){if(f&&!f[p]){q.push(p)}else{q.push(p)}}}}}return q};this.wn=function(p,d,l,g,k){var b={};var h=[];var j=false;var e=this.data[k];if(!d){d=k=="x"?this.smpIndices:this.varIndices}if(e&&e.hasOwnProperty(p)){for(var f=0;f<d.length;f++){var r=d[f];var q=this.PR(r,k,p);if(q!=null){b[q]=true;h.push(q)}else{j=true}}if(j){h.push("")}if(g){return l?h.join("+"):h}else{h=[]}for(var f in b){h.push(f)}if(j){h.push("")}return l?h.join("+"):h}};this.rj=function(a,c,b){var f=this.data;if(f.y){var k=f.y.smps;if(!k&&f.y.vars){if(!f.y.data){alert("Missing data object")}k=[];for(var e=0;e<f.y.data[0].length;e++){k.push("smp"+(e+1))}f.y.smps=k}var h=[];var g=[];if(a){for(var e=0;e<a.length;e++){h.push(a[e]);g.push(false)}}else{for(var e=0;e<k.length;e++){h.push(e);g.push(false)}}if(!c&&this.varIndices){this.rB()}this.smpIndices=this.sortDir=="descending"?h.reverse():h;this.hiddenSmps=this.sortDir=="descending"?g.reverse():g}if(this.data.w&&this.data.w.smps){h=[];g=[];this.hiddenGrps=[];for(var e=0;e<this.data.w.smps.length;e++){h.push(e);g.push(false)}this.grpIndices=this.sortDir=="descending"?h.reverse():h;this.hiddenGrps=this.sortDir=="descending"?g.reverse():g}if(this.layoutComb&&this.layoutParams&&!b){for(var e=0;e<this.layoutParams.length;e++){var j=this.layoutParams[e];if(j){if(j.startingSmpIndices){j.smpIndices=j.startingSmpIndices;j.smpIndicesStart=-1}if(this.isGroupedData&&j.startingGrpIndices){j.grpIndices=j.startingGrpIndices;j.grpIndicesStart=-1}}}}};this.u4=function(b,e,d,f,c){if(!f){f=this.isGroupedData&&!e?this.data.w.smps:this.data.y.smps;c=this.JG(f)}return this.By(b,f,c)};this.qT=function(b){return this[b]||[]};this.sF=function(c,b,d){return this.NO(c,b,d||this.smpIndices,"x",this.hiddenSmps)};this.sN=function(b,c){return this.Mk(b,c||this.smpIndices,"x",true)};this.hA=function(b,e){if(this.isGroupedData&&!this.data.w){this.grpIndices=[];for(var d=0;d<b.length;d++){this.grpIndices.push(b[d])}}else{this.smpIndices=[];for(var d=0;d<b.length;d++){this.smpIndices.push(b[d])}}if(e){var c=this.NB(b);var g=this.isGroupedData?this.data.w:this.data.y;var f=this.isGroupedData?this.hiddenGrps:this.hiddenSmps;for(var d=0;d<g.smps.length;d++){if(c.hasOwnProperty(d)){f[d]=false}else{f[d]=true}}}};this.OU=function(g){if(this.QT()){return}if(g){var b=this.isGroupedData?this.data.w:this.data.y;var e=this.isGroupedData?this.hiddenGrps:this.hiddenSmps;var f=[];if(this.eO(g)){for(var d=0;d<g.length;d++){for(var c=0;c<b.smps.length;c++){if(b.smps[c]==g[d]){if(e[c]){e[c]=false}else{e[c]=true}break}}}}else{for(var d=0;d<b.smps.length;d++){if(b.smps[d]==g){if(e[d]){e[d]=false}else{e[d]=true}break}}}var a=[];for(var d=0;d<b.smps.length;d++){if(!e[d]){a.push(d)}}this.hA(a);this.dG({func:"hideUnhideSmps",par:[g]})}};this.yV=function(){var c=[];var g=this.isGroupedData?this.data.w.smps:this.data.y.smps;var h=this.isGroupedData?this.data.w:this.data.y;var e=this.isGroupedData?this.hiddenGrps:this.hiddenSmps;var f=this.isGroupedData?this.grpIndices:this.smpIndices;for(var d=0;d<g.length;d++){var a=-1;for(var b=0;b<f.length;b++){if(f[b]==d){a=b;break}}c.push({name:g[d],hidden:e[d],index:a})}return c};this.WE=function(b,e,d,c){return this.wn(b,e,d,c,"x")};this.MJ=function(g,h){var j=this.data;if(j.y){var c=j.y.vars;if(!c){c=[];if(j.y.data){for(var f=0;f<j.y.data.length;f++){c.push("var"+(f+1))}}else{c=[];j.y.data=null}j.y.vars=c}var a=[];var b=[];if(!this.isDOE&&this.xAxis.length&&this.TG()){g=this.xAxis2.length?this.FP(this.xAxis).concat(this.FP(this.xAxis2)):this.FP(this.xAxis);if(this.eO(g)){if(!g.length&&(this.isPivot||this.graphType=="Pie"||this.graphType=="Map")){for(var f=0;f<j.y.data.length;f++){g.push(f)}}}else{if(g>=0){g=[g]}else{g=false}}}if(g&&g.length){for(var f=0;f<g.length;f++){a.push(g[f]);b.push(false)}}else{for(var f=0;f<c.length;f++){a.push(f);b.push(false)}}if(!h&&this.smpIndices){this.rB()}if(this.layoutComb&&this.layoutParams){for(var f=0;f<this.layoutParams.length;f++){var e=this.layoutParams[f];if(e&&e.startingVarIndices){e.varIndices=e.startingVarIndices;e.varIndicesStart=-1}}}this.varIndices=a;this.hiddenVars=b}};this.FP=function(b,e,d,c){if(!d){d=this.data.y.vars;c=this.JG(d)}return this.By(b,d,c)};this.tM=function(c,b){var d=this[c+"VarIndices"];d=[];for(var e=0;e<b.length;e++){d.push(b[e])}};this.as=function(b){return this[b+"VarIndices"]};this.J9=function(c,b,d){return this.NO(c,b,d||this.varIndices,"z",this.hiddenVars)};this.JA=function(b,c){return this.Mk(b,c||this.varIndices,"z")};this.lG=function(b){this.varIndices=[];for(var c=0;c<b.length;c++){this.varIndices.push(b[c])}};this.tU=function(f){if(this.QT()){return}var e=this.data.y;var d=this.hiddenVars;if(f){if(this.eO(f)){for(var c=0;c<f.length;c++){for(var b=0;b<e.vars.length;b++){if(e.vars[b]==f[c]){if(d[b]){d[b]=false}else{d[b]=true}break}}}}else{for(var c=0;c<e.vars.length;c++){if(e.vars[c]==f){if(d[c]){d[c]=false}else{d[c]=true}break}}}var a=[];for(var c=0;c<e.vars.length;c++){if(!d[c]){a.push(c)}}this.lG(a);this.dG({func:"hideUnhideVars",par:[f]})}};this.Uf=function(){var d=[];for(var c=0;c<this.data.y.vars.length;c++){var a=-1;for(var b=0;b<this.varIndices.length;b++){if(this.varIndices[b]==c){a=b;break}}d.push({name:this.data.y.vars[c],hidden:this.hiddenVars[c],index:a})}return d};this.wV=function(b,e,d,c){return this.wn(b,e,d,c,"z")};this.iW=function(){var e=this.data.nodes;var g={};var f={};var a={};for(var b=0;b<e.length;b++){var c=e[b];g[c.id]=c;f[c.id]=b;a[c.id]=false}this.nodes=g;this.data.nodeIndices=f;this.nodeInitialCache=a;this.CK()};this.fO=function(){if(this.data.nodeIndices){var a=this.data.nodeIndices;var e=this.data.nodes;var f={};for(var b=0;b<e.length;b++){var c=e[b];f[c.id]=c}e=[];for(var b in a){e[a[b]]=f[b]}this.data.nodes=e;this.nodes=f;this.CK()}else{this.iW()}};this.FE=function(c){this.nodes={};this.data.nodeIndices={};var f=this.data.nodes;for(var a=0;a<f.length;a++){var b=f[a];b.hide=false;this.nodes[b.id]=b;this.data.nodeIndices[b.id]=a}var d=this.data.edges;for(var a=0;a<d.length;a++){d[a].hide=false}this.CK();if(!c){this.rB()}};this.CK=function(){this.hiddenNodes={};this.hiddenEdges={};var d=this.data.nodes;for(var a=0;a<d.length;a++){this.hiddenNodes[d[a].id]=false}var b=this.data.edges;for(var a=0;a<b.length;a++){var c=b[a].id1+":"+b[a].id2;this.hiddenEdges[c]=false}};this.tD=function(b,c){c=c?true:false;this.isHiddenNodes=c;var f=this.data.nodes;var j=this.nodes;if(b){if(this.eO(b)){for(var a=0;a<b.length;a++){var g=b[a];var e=f[this.data.nodeIndices[g]];e.hide=c;if(j&&j[g]!=null){j[g].hide=c}}}}else{for(var a=0;a<f.length;a++){var e=f[a];e.hide=c;if(j&&j[e.id]!=null){j[e.id].hide=c}}this.Hu();this.dG({func:"hideUnhideNodes",par:[b,c]})}};this.MK=function(){var d=this.data.tracks;for(var c=0;c<d.length;c++){var a=d[c];a.hide=false;var e=a.data;for(var b=0;b<e.length;b++){e[b].hide=false}}};this.O1=function(c,b,d){var e=this.meta.map.geojson.features;if(d){for(var a=0;a<e.length;a++){e[a].hidden=d}}for(var a=0;a<c.length;a++){e[c[a]].hidden=b}};this.Ui=function(){if(this.meta.map&&this.meta.map.geojson){for(var a=0;a<this.meta.map.geojson.features.length;a++){this.meta.map.geojson.features[a].hidden=false}}};this.AM=function(c,a,b){if(this.graphType=="Network"){this.fO()}else{if(this.graphType!="Genome"&&this.graphType!="Venn"){this.MJ(c,b);this.rj(a,b)}}};this.ta=function(c){if(this.isGroupedData&&this.grpIndices&&this.data.w){if(c&&this.grpIndices.length){var a=[];for(var b=0;b<this.grpIndices.length;b++){var d=this.data.w.grps[this.grpIndices[b]];if(d){a=a.concat(d)}}this.smpIndices=a}else{this.AM()}}};this.h4=function(h,b,f,e){var d=this.graphType;var a=["colorByData","outlineByData","shapeByData","sizeByData","patternByData"];if(!e){this.AM(h,b,f)}if(d=="Network"||d=="Genome"){this.k8()}else{if(d!="Venn"){this.k8();for(var c=0;c<a.length;c++){if(this[a[c]]&&this.data.y.hasOwnProperty(this[a[c]])){this.af(this[a[c]])}else{this[a[c]]=false}}if(this.oncoprintCNA&&this.data.y.hasOwnProperty(this.oncoprintCNA)){this.af(this.oncoprintCNA);this.isOncoprint=true}if(this.oncoprintMUT&&this.data.y.hasOwnProperty(this.oncoprintMUT)){this.af(this.oncoprintMUT)}if(this.heatmapType=="upset"){this.isUpSet=true}}}};this.Ff=function(c){var b=["sankey","tree","bubble","gantt","contour"];for(var a=0;a<b.length;a++){delete (c[b[a]])}return c};this.cN=function(){if(!this.isGanttDataFormated){this.data.gantt=[];for(var b=0;b<this.data.y.vars.length;b++){this.data.gantt[b]=[];for(var a=0;a<this.data.y.smps.length;a++){var c=this.data.y.data[b][a]!=null?this.Xb(this.data.y.data[b][a]).getTime():null;this.data.gantt[b].push(c)}}this.isGanttDataFormated=true}};this.RY=function(){if(!this.isQQ){this.bb(true)}};this.ww=function(){if(!this.isCDF){this.hz(true)}};this.F3=function(){if(!this.isManhattanDataFormated){var f=this;var l=function(p,s){var q=0;for(var r=0;r<p-1;r++){q+=f.chromosomeLengths[r]}return q+s};var g=this.manhattanMarkerChromosomeNumber?this.u4(this.manhattanMarkerChromosomeNumber):-1;var j=this.manhattanMarkerPosition?this.u4(this.manhattanMarkerPosition):-1;var b=this.manhattanMarkerLogPValue?this.u4(this.manhattanMarkerLogPValue):-1;if(g<0){this.scatterType=false;alert("Missing marker chromosome number");return}if(j<0){this.scatterType=false;alert("Missing marker base postion");return}if(b<0){this.scatterType=false;alert("Missing marker p-value");return}if(!this.chromosomeLengths.length){var a=[];for(var e=0;e<this.data.y.vars.length;e++){var d=this.data.y.data[e][g];var h=this.data.y.data[e][j];if(!a[d]){a[d]=[]}a[d].push(h)}for(var e=0;e<a.length;e++){this.chromosomeLengths[e]=this.ds(a[e]||[0])+1}}var k=this.u4("Manhattan");if(k>=0){for(var e=0;e<this.data.y.vars.length;e++){this.data.y.data[e][k]=l(this.data.y.data[e][g],this.data.y.data[e][j])}}else{this.data.y.smps.push("Manhattan");for(var e=0;e<this.data.y.vars.length;e++){this.data.y.data[e].push(l(this.data.y.data[e][g],this.data.y.data[e][j]))}}var c=this.meta.config.user;this.manhattanMarkerChromosomeNumberIndex=g;this.manhattanMarkerPositionIndex=j;this.manhattanMarkerLogPValueIndex=b;this.xAxis=["Manhattan"];this.xAxisTitle=c.xAxisTitle||"Chromosome";this.yAxis=[this.data.y.smps[b]];this.yAxisTitle=c.yAxisTitle||this.data.y.smps[b];this.xAxisGridMajorShow=c.xAxisGridMajorShow||false;this.xAxisGridMinorShow=c.xAxisGridMinorShow||false;this.xAxisLineRighShow=c.xAxisLineRightShow||false;this.yAxisGridMinorShow=c.yAxisGridMinorShow||false;this.yAxisLineTopShow=c.yAxisLineTopShow||false;this.yAxisLineBottomShow=c.yAxisLineBottomShow||false;this.isManhattanDataFormated=true}};this.QM=function(){if(this.sankeySource&&this.sankeyTarget){this.data.sankey={nodes:[],links:[]};var g={};for(var c=0;c<this.smpIndices.length;c++){var e=this.smpIndices[c];var d=this.PR(e,"x",this.sankeySource);var b=this.PR(e,"x",this.sankeyTarget);var a=this.VY(this.hierarchyVarIndex,e,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue,this.xAxisFactorValue);this.data.sankey.links.push({source:d,target:b,value:a,id:e});g[d]=true;g[b]=true}var h=0;for(var c in g){this.data.sankey.nodes.push({name:c,id:h++})}var f={};this.data.sankey.nodes.forEach(function(j){f[j.name]=j});this.data.sankey.links=this.data.sankey.links.map(function(j){return{source:f[j.source],target:f[j.target],parent:j.parent,value:j.value,id:j.id}})}else{if(this.data.sankey){var f={};this.data.sankey.nodes.forEach(function(j){f[j.name]=j});this.data.sankey.links=this.data.sankey.links.map(function(j){return{source:f[j.source],target:f[j.target],parent:j.parent,value:j.value,id:j.id}})}}};this.Hx=function(b){if(this.graphType=="Sankey"||(this.graphType=="Circular"&&(this.circularType=="sunburst"||this.circularType=="bubble"))){var f=this.hierarchyVar?this.FP(this.hierarchyVar):0;this.hierarchyVarIndex=f>=0?f:0}if(this.hierarchy.length>0){if(!this.data[b]||(this.data[b].hierarchy&&!this.iT(this.data[b].hierarchy,this.hierarchy))){this.data[b]={};this.data[b]["data"]={name:this.hierarchy[0],children:[]};for(var f=0;f<this.smpIndices.length;f++){var l=this.smpIndices[f];var a=this.data[b]["data"].children;for(var e=0;e<this.hierarchy.length;e++){var c=this.hierarchy[e];var h=-1;for(var d=0;d<a.length;d++){if(this.PR(l,"x",c)==a[d].name){h=d}}if(h==-1){var g=this.PR(l,"x",c);if(g!=null){a.push({name:g,children:[]});h=a.length-1}else{if(e==this.hierarchy.length-1){a.push({name:this.data.y.smps[l],size:this.data.y.data[this.hierarchyVarIndex][l],idx:l});continue}else{continue}}}a=a[h].children;if(e===this.hierarchy.length-1){a.push({name:this.data.y.smps[l],size:this.data.y.data[this.hierarchyVarIndex][l],idx:l})}}}}}else{this.data[b]={};this.data[b]["data"]={name:"Samples",children:[]};for(var f=0;f<this.smpIndices.length;f++){var l=this.smpIndices[f];var a=this.data[b]["data"].children;a.push({name:this.data.y.smps[l],size:this.data.y.data[this.hierarchyVarIndex][l],idx:l})}}};this.oV=function(){var a=window.location.origin;var b={};for(m in CanvasXpress.countries){var c=CanvasXpress.countries[m][0];b[m]=[c,a+"/data/maps/"+m+".json"]}for(m in CanvasXpress.usa){var c=CanvasXpress.usa[m][0];b[m]=[c,a+"/data/maps/"+m+".json"]}for(m in CanvasXpress.maps){b[m]=[c,a+"/"+m]}return b};this.Zq=function(c){if(!c){c="png"}var b=window.location.origin+"/data/flags"+(c=="svg"?"/svg/3x2/":"/png/");var a={};for(m in CanvasXpress.countries){var e=CanvasXpress.countries[m][0];var d=c=="svg"?CanvasXpress.countries[m][3]:CanvasXpress.countries[m][3].toLowerCase();a[m]=[e,b+d+"."+c]}return a};this.gK=function(d,c,a){if(d&&typeof d=="string"&&this.isValidJSON(d)){d=JSON.parse(d)}this.data=d||this.QA();this.isExample=d?false:true;if(this.isExample){this.$(this.target).style.display="none"}this.nodesData=false;this.edgesData=false;this.featuresData=false;if(c){delete this.meta.data;this.meta.vals={}}this.validGraphTypes=[];if(Array.isArray(d)&&Array.isArray(d[0])){var b=this.arrayToCX(this.gg(d),this.meta.config.user);this.data=b.data;if(b.config&&b.config.summaryType){this.summaryType=b.config.summaryType;this.dataTableZeroHeader=b.config.dataTableZeroHeader||""}}else{if(this.isDataFrame){this.data=this.Kr(d,this.meta.config.user)}}if(this.data&&(this.data.y||this.data.venn||this.data.nodes||this.data.tracks||this.data.fx)){if(this.data.fx){this.sI()}if(this.data.venn){if(this.graphType=="Venn"){this.summaryType="venn"}this.validGraphTypes.push("Venn")}if(this.data.nodes){if(this.graphType=="Network"){this.summaryType="network"}this.validGraphTypes.push("Network")}if(this.data.tracks){if(this.graphType=="Genome"){this.summaryType="genome"}this.validGraphTypes.push("Genome")}if(this.data.y){if(!this.data.y&&!this.data.y.cor&&!this.data.y.close){alert("Dude! there is not a valid data structure");return}else{if(this.data.y.data){this.isRawData=true;this.summaryType=this.summaryType&&this.summaryType.match(/iqr|median|mean|cor|sum|max|min|count|gantt/)?this.summaryType:"raw";if(this.summaryType=="cor"){this.graphType="Correlation"}else{if(this.summaryType=="iqr"){this.graphType="Boxplot"}else{if(this.summaryType=="gantt"){this.graphType="Gantt"}else{if(this.data.y[this.summaryType]){if(this.iT(this.data.y[this.summaryType],this.data.y.data)){this.isRawData=false}}}}}if(this.graphType=="Gantt"){if(!this.ganttStart||this.FP(this.ganttStart)<0){this.ganttStart=this.data.y.vars[0]}if(!this.ganttEnd||this.FP(this.ganttEnd)<0){this.ganttEnd=this.data.y.vars[1]||this.data.y.vars[0]}this.cN()}else{if(this.graphType=="Scatter2D"&&this.scatterType=="manhattan"){this.F3()}}}else{this.isRawData=false;if(this.data.y.iqr1&&this.data.y.qtl1&&this.data.y.median&&this.data.y.qtl3&&this.data.y.iqr3){this.summaryType="iqr"}else{if(this.data.y.median){this.summaryType="median"}else{if(this.data.y.mean){this.summaryType="mean"}else{if(this.data.y.cor){this.summaryType="cor"}else{if(this.data.y.sum){this.summaryType="sum"}else{if(this.data.y.max){this.summaryType="max"}else{if(this.data.y.min){this.summaryType="min"}else{if(this.data.y.count){this.summaryType="count"}else{this.summaryType=false}}}}}}}}}}this.validGraphTypes.push("Bar");this.validGraphTypes.push("Line");this.validGraphTypes.push("Area");this.validGraphTypes.push("AreaLine");this.validGraphTypes.push("BarLine");this.validGraphTypes.push("Boxplot");this.validGraphTypes.push("Dotplot");this.validGraphTypes.push("DotLine");this.validGraphTypes.push("Heatmap");this.validGraphTypes.push("Stacked");this.validGraphTypes.push("StackedLine");this.validGraphTypes.push("StackedPercent");this.validGraphTypes.push("StackedPercentLine");this.validGraphTypes.push("Pie");this.validGraphTypes.push("Correlation");this.validGraphTypes.push("Circular");if(this.data.y.smps||this.isDOE){if(this.data.y.smps.length>2||this.isDOE){this.validGraphTypes.push("Scatter2D");this.validGraphTypes.push("ScatterBubble2D");this.validGraphTypes.push("Scatter3D")}else{if(this.data.y.smps.length>1||this.isDOE){this.validGraphTypes.push("Scatter2D")}}}}this.validGraphTypes.sort();this.h4(false,false,a)}}};CanvasXpress.prototype.initAesthetics=function(){this.initLegendUtils();this.initMarkerUtils()};CanvasXpress.prototype.initScale=function(){};CanvasXpress.prototype.initGeometry=function(){this.initPrimitives();this.initUtils();this.initGraph()};CanvasXpress.prototype.initStatistics=function(){this.initNumeric();this.initjLouvain();this.initCola();this.initMathUtils();this.initSankeyUtils();this.initTreeUtils();this.initCirclePackUtils();this.initNetworkUtils();this.initComplex();this.initFFT();this.initContour();this.initDensity();this.initHist();this.initLoess();this.initQuantreg();this.initLAPACK();this.initClusterUtils()};CanvasXpress.prototype.initFacets=function(){this.initLayout()};CanvasXpress.prototype.initCoordinates=function(){this.initAxes()};CanvasXpress.prototype.initTheme=function(){this.UZ=function(b){var a=b.toLowerCase().replace(/ /g,"");switch(a){case"grey":case"gray":case"igray":case"ggplot":return CanvasXpress.themeDef.grey;case"bw":case"blackandwhite":return CanvasXpress.themeDef.bw;case"linedraw":return CanvasXpress.themeDef.linedraw;case"light":return CanvasXpress.themeDef.light;case"dark":return CanvasXpress.themeDef.dark;case"minimal":return CanvasXpress.themeDef.minimal;case"classic":return CanvasXpress.themeDef.classic;case"void":case"void0":return CanvasXpress.themeDef.void0;case"economist":return CanvasXpress.themeDef.economist;case"excel":return CanvasXpress.themeDef.excel;case"solarized":return CanvasXpress.themeDef.solarized;case"paulTol":case"ptol":return CanvasXpress.themeDef.ptol;case"wallstreetjournal":case"wallstreet":case"wsj":return CanvasXpress.themeDef.wsj;case"tableau":return CanvasXpress.themeDef.tableau;case"stata":return CanvasXpress.themeDef.stata;case"ggblanket":return CanvasXpress.themeDef.ggblanket;case"cx":case"canvasxpress":return CanvasXpress.themeDef.cx;default:return CanvasXpress.themeDef.light}};this.jY=function(b){if(!b){b="x"}var e=["AxisShow","Axis2Show","AxisTitleColor","AxisTitleScaleFontFactor","AxisTextColor","AxisTextScaleFontFactor","AxisTicksShow","AxisTicksColor","AxisTicksLength","AxisTicksWidth","AxisLineBottomShow","AxisLineBottomColor","AxisLineBottomLineType","AxisLineBottomWidth","AxisLineTopShow","AxisLineTopColor","AxisLineTopLineType","AxisLineTopWidth","AxisGridMajorShow","AxisGridMajorColor","AxisGridMajorLineType","AxisGridMajorWidth","AxisGridMinorShow","AxisGridMinorColor","AxisGridMinorLineType","AxisGridMinorWidth"];var f=["r","z"];for(var d=0;d<f.length;d++){for(var c=0;c<e.length;c++){this[f[d]+e[c]]=this[b+e[c]]}}};this.hM=function(c){var b=c.toLowerCase().replace(/ /g,"");var a=CanvasXpress.graphTypes.OneDPlots.includes(this.graphType);this.theme="none";this.backgroundType="panel";this.colorScheme="User";this.guides=false;this.guidesColor="#cccccc";this.lineDecoration="symbol";this.mapOutlineColor="#cccccc";this.objectBorderColor="#000000";this.fitLineColor="#FFD700";this.legendColumns=1;switch(b){case"grey":case"gray":case"igray":case"ggplot":this.guides=true;this.guidesColor="#ffffff";this.mapOutlineColor="#ffffff";this.fitLineColor="#0000FF";this.objectBorderColor="rgba(0,0,0,0)";this.colorScheme="";break;case"bw":case"blackandwhite":this.backgroundType="solid";this.lineDecoration="pattern";this.colorScheme="BlackAndWhite";break;case"linedraw":this.colorScheme="GGPlot";break;case"light":this.colorScheme="GGPlot";break;case"dark":this.colorScheme="GGPlot";break;case"minimal":this.colorScheme="GGPlot";break;case"classic":this.colorScheme="GGPlot";break;case"void":case"void0":this.colorScheme="GGPlot";break;case"economist":this.colorScheme="Economist";this.backgroundType="solid";this.mapOutlineColor="#D5E4EB";this.legendColumns=8;if(a){this.xAxisTicksMajorShow=true}break;case"excel":this.colorScheme="Excel";this.mapOutlineColor="#C0C0C0";if(a){this.xAxisTicksMajorShow=true}break;case"solarized":this.colorScheme="Solarized";this.backgroundType="solid";this.mapOutlineColor="#FDF6E3";break;case"paulTol":case"ptol":this.colorScheme="PaulTol";this.backgroundType="solid";this.mapOutlineColor="#ffffff";break;case"wallstreetjournal":case"wsj":this.colorScheme="WallStreetJournal3";this.backgroundType="solid";this.mapOutlineColor="#F8F2E4";this.legendColumns=4;if(a){this.xAxisTicksMajorShow=true}break;case"tableau":this.colorScheme="TableauMedium";this.mapOutlineColor="#E5E5E5";break;case"stata":this.colorScheme="Stata";this.mapOutlineColor="#EAF2F3";this.legendColumns=4;if(a){this.xAxisTicksMajorShow=true}break;case"ggblanket":this.colorScheme="GGBlanket";break;case"cx":case"canvasxpress":this.colorScheme="CanvasXpress";this.stripBackgroundColor="#ebebeb";this.stripBackgroundBorderColor="#337ab7";break;case"lastairbenderfire":this.plotBackgroundColor="#ede5d3";this.backgroundType="solid";this.xAxisGridMajorColor="#ffffff";this.yAxisGridMajorColor="#ffffff";this.zAxisGridMajorColor="#ffffff";this.rAxisGridMajorColor="#ffffff";this.colorScheme="LastAirBenderFire";break;case"lastairbenderair":this.plotBackgroundColor="#ede5d3";this.backgroundType="solid";this.xAxisGridMajorColor="#ffffff";this.yAxisGridMajorColor="#ffffff";this.zAxisGridMajorColor="#ffffff";this.rAxisGridMajorColor="#ffffff";this.colorScheme="LastAirBenderAir";break;case"lastairbenderwater":this.plotBackgroundColor="#ede5d3";this.backgroundType="solid";this.xAxisGridMajorColor="#ffffff";this.yAxisGridMajorColor="#ffffff";this.zAxisGridMajorColor="#ffffff";this.rAxisGridMajorColor="#ffffff";this.colorScheme="LastAirBenderWater";break;case"lastairbenderearth":this.plotBackgroundColor="#ede5d3";this.backgroundType="solid";this.xAxisGridMajorColor="#ffffff";this.yAxisGridMajorColor="#ffffff";this.zAxisGridMajorColor="#ffffff";this.rAxisGridMajorColor="#ffffff";this.colorScheme="LastAirBenderEarth";break;case"gameofthronestargaryen":this.colorScheme="GameOfThronesTargaryen";break;case"gameofthronesstark":this.colorScheme="GameOfThronesStark";break;case"gameofthronesstannis":this.colorScheme="GameOfThronesStannis";break;case"gameofthroneslannister":this.colorScheme="GameOfThronesLannister";break;case"gameofthronestyrell":this.colorScheme="GameOfThronesTyrell";break;case"gameofthronesmartell":this.colorScheme="GameOfThronesMartell";break;case"gameofthronestully":this.colorScheme="GameOfThronesTully";break;case"gameofthronesgreyjoy":this.colorScheme="GameOfThronesGreyjoy";break;case"gameofthronesmanderly":this.colorScheme="GameOfThronesManderly";break;case"gameofthronesarryn":this.colorScheme="GameOfThronesArryn";break;default:this.colorScheme="User";this.colors=["#fe296c","#487eb6","#a7ce31","#f8cc03","#ff8c02","#699696","#b77844","#83acd0","#c2e076","#fadc5a","#ff549f","#ffaf54","#9ab8b7","#d2a683","#3d699b","#87ac22","#cda908","#d02158","#d07300","#567676"];break}};this.L3=function(a){return this.bN(a)};this.bN=function(c,a){if(!c){c=CanvasXpress.stack[this.target]&&CanvasXpress.stack[this.target].config&&CanvasXpress.stack[this.target].config.theme?CanvasXpress.stack[this.target].config.theme:"none"}var b=this.UZ(c);this.CX(b,true);this.jY();this.hM(c);if(!a){this.dG({func:"setTheme",par:[c]})}}};CanvasXpress.prototype.initRender=function(){this.YN=function(p){var l=this;var c=function(i){return s&&s.map.hasOwnProperty(i)?s.map[i]:false};if(!this.counterFoo){this.counterFoo=[]}if(!this.counterFoo[this.layoutCurrent||0]){this.counterFoo[this.layoutCurrent||0]=0}this.counterFoo[this.layoutCurrent||0]++;var m=function(i,B){var C=i.replace("draw","get")+"Area";return l[C].apply(l,B)};var q=p.p;var r=p.i;var y=p.m;var n=p.g;var t=p.s;var d=p.b;var A=p.t;var f=p.h;var h=this.meta.render;var s=h.transition;var x=q.shift();var k=p.i?m(x,q):false;var b=x.match(/^draw/)?x.replace("draw","").substring(0,1):"O";var g=h.objects.length;var o=this.transparencyHidden;n=n!=null?n.toString():g;if(!h.groups.hasOwnProperty(n)){h.groups[n]=[]}if(!h.types.hasOwnProperty(A)){h.types[A]={all:[],drawShape:[],drawLine:[],drawText:[],drawArcText:[],other:[]}}if(!h.order.includes(A)){h.order.push(A)}var w=h.types[A].hasOwnProperty(x)?h.types[A][x].length:h.types[A].other.length;var u=r&&this.eO(r)?r.join(":"):r?r:A+":"+b+":"+this.N0(w);h.objects.push({func:x,params:q,idx:r,id:u,n:g,modifier:y,group:n,area:k,layout:(this.layoutComb?this.layoutCurrent:false),type:A,skip:t,baseline:d});h.groups[n].push(g);h.types[A].all.push(g);switch(x){case"drawShape":h.types[A].drawShape.push(g);break;case"drawLine":h.types[A].drawLine.push(g);break;case"drawText":h.types[A].drawText.push(g);break;case"drawArcText":h.types[A].drawText.push(g);break;default:h.types[A].other.push(g);break}if(n!=g&&x=="drawLine"&&h.objects[n].idx){if(!r){r=h.objects[n].idx}u=r.join(":")+":"+h.groups[n].length;h.objects[g].id=u;if(this.showBoxplotOriginalData){}}h.origin[g]=[];var a=h.map;var z=h.origin[g];if(this.showTransition){if(A=="Data"&&r&&!this.graphType.match(/Scatter|Treemap|Circular/)){if(this.isGroupedData){if((this.Nv()&&r[r.length-1]!="box")||this.graphType.match(/Stacked/)){u=r[0]+":"+r[r.length-1];a[u]=g;z.push(c(u))}else{if(r.length==2&&n==g){var e=this.data.w.grps[r[1]]||[];var j=e.length;for(var v=0;v<j;v++){u=r[0]+":"+e[v];a[u]=g;z.push(c(u))}}else{if(r.length==3&&r[2]=="box"){var e=this.data.w.grps[r[1]]||[];var j=e.length;for(var v=0;v<j;v++){u=r[0]+":"+e[v]+":box";a[u]=g;z.push(c(u))}}else{a[u]=g;z.push(c(u))}}}}else{a[u]=g;z.push(c(u))}}else{a[u]=g;z.push(c(u))}}if(CanvasXpress.graphTypes.OneTwoThreeeDGraphs.includes(this.graphType)||this.graphType=="TagCloud"||this.graphType=="Map"||this.graphType=="Network"||this.graphType=="Sankey"){if(f){if(this.filterMode=="color"){switch(x){case"drawShape":q[5]=this.missingDataColor;q[6]=this.missingDataColor;break;case"drawLine":q[5]=this.missingDataColor;break;case"drawText":q[4]=this.missingDataColor;break;case"drawArcText":q[7]=this.missingDataColor;break}}else{switch(x){case"drawShape":q[5]=this.a0(this.ZM(q[5]),o,true);q[6]=this.a0(this.ZM(q[6])||this.foreground,o,true);break;case"drawLine":q[5]=this.a0(this.ZM(q[5]),o,true);break;case"drawText":q[4]=this.a0(this.ZM(q[4]),o,true);break;case"drawArcText":q[7]=this.a0(this.ZM(q[7]),o,true);break}}}}if(this.debug&&!this.isSVG||(this.graphType=="Network"&&this.is3DNetwork&&this.isR)){this.fQ(g,g+1)}return g};this.oe=function(c,d){var a=this.meta.render;var b=this.ZO();if(a.objects.length>0&&!this.skipTransition&&this.showTransition){delete (a.transition);if(!d){if(this.graphType=="Network"&&!this.isLayoutDone){}else{a.transition=this.gg(a)}}}if(!c){a.objects=[];a.groups={};a.types={};a.order=[];a.map={};a.origin=[]}b.resetRender();b.resetContext()};this.fQ=function(c,g){if(!this.skipRender){this.GW("render - start");var a=this.ZO();var d=this.meta.render.objects;var j=0;if(d.length>0){if(!c){c=0}if(!g){g=d.length}for(var b=c;b<g;b++){var h=d[b];var f=h.params;switch(h.func){case"drawShape":this.Pw(f[0],f[1],f[2],f[3],f[4],f[5],f[6],f[7],f[8],f[9],f[10],f[11],f[12],f[13],f[14],f[15],a);break;case"drawLine":this.q4(f[0],f[1],f[2],f[3],f[4],f[5],f[6],f[7],f[8],f[9],f[10],f[11],f[12],f[13],f[14],f[15],f[16],a);break;case"drawText":this.mh(f[0],f[1],f[2],f[3],f[4],f[5],f[6],f[7],f[8],f[9],f[10],a);break;case"setClipArea":this.W6(f[0],a);break;case"resetClipArea":this.VQ(a);break;case"setGlobalCompositionOperation":this.Tx(f[0],a);break;default:this[h.func].apply(this,h.params);break}j++}}a.render();this.GW("render - end - "+j+"/"+(g-c)+" objects");a.resetRender()}}};CanvasXpress.prototype.initUI=function(){this.initSave();this.initSVG();this.initInterface();this.initFilterUtils();this.initSortUtils();this.initTooltip();this.initTooltipMouse();this.initTooltipDiv();this.initToolbar();this.initTabpanel();this.initMenus();this.initLinks();this.initDataFilter();this.initDataTable();this.initCodeInfo();this.initBin();this.initCustomizer();this.initEvents();this.initAnimation();this.initRemote()};CanvasXpress.prototype.initDOM=function(){this.$=function(id){return window.document.getElementById(id)};this.$cX=function(t,p,s){var e=window.document.createElement(t);if(p){for(var i in p){e[i]=p[i]}}if(s){for(var i in s){e.style[i]=s[i]}}return e};this.$cXI=function(f,a,o,m,j){try{CanvasXpress}catch(e){return false}var b=document.createElementNS("http://www.w3.org/2000/svg","svg");var e=function(q){var k={};var i=q.split(/class=/);var t="<style>";for(var u=1;u<i.length;u++){var p=i[u].match(/"(.+?)"/);if(p){var s=p[1].split(/\s+/);for(var r=0;r<s.length;r++){var d=s[r];if(CanvasXpress.icons.classes.hasOwnProperty(d)&&!k.hasOwnProperty(d)){var tt=CanvasXpress.icons.classes[d];tt=tt.replace(/l:/g,"stroke-miterlimit:");tt=tt.replace(/w:/g,"stroke-width:");tt=tt.replace(/n:/g,"font:");tt=tt.replace(/s:/g,"stroke:");tt=tt.replace(/f:/g,"fill:");t+="."+d+tt}}}}t+="</style>";return t};if(CanvasXpress.icons.use.hasOwnProperty(f)){var h='<rect class="cxnc" x="0" y="0" width="100" height="100" />';if(CanvasXpress.icons.gradients.hasOwnProperty(f)){var hh=CanvasXpress.icons.gradients[f].replace(/&quot;/g,'"');hh=hh.replace(/s=/g,"style=");hh=hh.replace(/o=/g,"offset=");hh=hh.replace(/c=/g,"stop-color=");hh=hh.replace(/t=/g,"gradientTransform=");hh=hh.replace(/u=/g,"gradientUnits=");hh=hh.replace(/<\/s/g,"</stop").replace(/<s/g,"<stop");hh=hh.replace(/<\/r/g,"</radialGradient").replace(/<r/g,"<radialGradient");hh=hh.replace(/<\/l/g,"</linearGradient").replace(/<l/g,"<linearGradient");h+=hh}for(var g=0;g<CanvasXpress.icons.use[f].length;g++){var hh=CanvasXpress.icons.symbols[CanvasXpress.icons.use[f][g]];hh=hh.replace(/&quot;/g,'"').replace(/&apos;/g,"'");hh=hh.replace(/<\/y/g,"</polyline").replace(/<y/g,"<polyline");hh=hh.replace(/<\/l/g,"</line").replace(/<l/g,"<line");hh=hh.replace(/<\/c/g,"</circle").replace(/<c/g,"<circle");hh=hh.replace(/<\/r/g,"</rect").replace(/<r/g,"<rect");hh=hh.replace(/<\/p/g,"</path").replace(/<p /g,"<path ");hh=hh.replace(/<\/t/g,"</text").replace(/<t/g,"<text");hh=hh.replace(/tr=/g,"transform=");hh=hh.replace(/q=/g,"points=");hh=hh.replace(/h=/g,"height=");hh=hh.replace(/w=/g,"width=");hh=hh.replace(/c=/g,"class=");h+=hh}var l=e(h);if(!j){j=24}b.setAttribute("xmlns","http://www.w3.org/2000/svg");b.setAttribute("viewBox","0 0 100 100");b.setAttribute("style","width:"+j+"px;height:"+j+"px;box-sizing:border-box;");if(a){for(var g in a){if(g=="className"){b.setAttribute("class",a[g])}else{b.setAttribute(g,a[g]);if(g=="title"){b.setAttribute("title",a[g])}}}}if(o){for(var g in o){b.style[g]=o[g]}}b.innerHTML=l+h}return m?new XMLSerializer().serializeToString(b):b};this.$cXIU=function(b,e,a,l){try{CanvasXpress}catch(f){return false}var j="";var d=function(p){var n={};var k=p.split(/class=|c=/);var s="<style>";for(var t=1;t<k.length;t++){var o=k[t].match(/"(.+?)"/);if(o){var r=o[1].split(/\s+/);for(var q=0;q<r.length;q++){var i=r[q];if(CanvasXpress.icons.classes.hasOwnProperty(i)&&!n.hasOwnProperty(i)){s+="."+i+CanvasXpress.icons.classes[i]}}}}s+="</style>";s=s.replace(/l:/g,"stroke-miterlimit:");s=s.replace(/w:/g,"stroke-width:");s=s.replace(/n:/g,"font:");s=s.replace(/s:/g,"stroke:");s=s.replace(/f:/g,"fill:");return s};if(b&&CanvasXpress.icons.use.hasOwnProperty(e)){var g="";if(CanvasXpress.icons.gradients.hasOwnProperty(e)){g+=CanvasXpress.icons.gradients[e].replace(/&quot;/g,'"');g=g.replace(/&quot;/g,'"').replace(/&apos;/g,"'");g=g.replace(/<\/y/g,"</polyline").replace(/<y/g,"<polyline");g=g.replace(/<\/l/g,"</line").replace(/<l/g,"<line");g=g.replace(/<\/c/g,"</circle").replace(/<c/g,"<circle");g=g.replace(/<\/r/g,"</rect").replace(/<r/g,"<rect");g=g.replace(/<\/p/g,"</path").replace(/<p /g,"<path ");g=g.replace(/<\/t/g,"</text").replace(/<t/g,"<text");g=g.replace(/tr=/g,"transform=");g=g.replace(/q=/g,"points=");g=g.replace(/h=/g,"height=");g=g.replace(/w=/g,"width=");g=g.replace(/c=/g,"class=")}for(var f=0;f<CanvasXpress.icons.use[e].length;f++){g+=CanvasXpress.icons.symbols[CanvasXpress.icons.use[e][f]].replace(/&quot;/g,'"').replace(/&apos;/g,"'");g=g.replace(/&quot;/g,'"').replace(/&apos;/g,"'");g=g.replace(/<\/y/g,"</polyline").replace(/<y/g,"<polyline");g=g.replace(/<\/l/g,"</line").replace(/<l/g,"<line");g=g.replace(/<\/c/g,"</circle").replace(/<c/g,"<circle");g=g.replace(/<\/r/g,"</rect").replace(/<r/g,"<rect");g=g.replace(/<\/p/g,"</path").replace(/<p /g,"<path ");g=g.replace(/<\/t/g,"</text").replace(/<t/g,"<text");g=g.replace(/tr=/g,"transform=");g=g.replace(/q=/g,"points=");g=g.replace(/h=/g,"height=");g=g.replace(/w=/g,"width=");g=g.replace(/c=/g,"class=")}g='<rect class="cxnc" x="0" y="0" width="100" height="100" />'+g;var h=d(g);if(a){for(var f in a){if(f=="className"){b.setAttribute("class",a[f])}else{b.setAttribute(f,a[f]);if(f=="title"){j="<title>"+a[f]+"</title>"}}}}if(l){for(var f in l){b.style[f]=l[f]}}b.innerHTML=j+h+g}};this.$p=function(s){var t=this;var w=window;var q=t.$w;var p=t[q(0)];var u=t[q(0,true)];var r=s?p:!p?false:!u;if(w[q(8)][q(15)]&&!w[q(8)][q(15)].length){if(t.$v()){r=true}}if(!s&&r){w[q(40)]=function(){return false}}return r};this.$pX=function(c){var t=this;var q=t.$w;var p=t.$(t.target+q(2));if(c&&p){var x=t[q(0)];if(x){var e=t[q(10)](x);if(e==p.value){t[q(0,true)]=true;return true}else{return false}}else{return false}}else{if(p&&p.value!=""){var e=t[q(9)](p.value);t[q(0)]=e;t[q(0,true)]=true;return e}else{return false}}};this.To=function(s){var h="";for(var i=0;i<s.length;i++){h+=""+s.charCodeAt(i).toString(16)}return h};this.$h=function(h){var s="";for(var i=0;i<h.length;i+=2){s+=String.fromCharCode(parseInt(h.substr(i,2),16))}return s};this.$w=function(i,n){try{CanvasXpress}catch(e){return false}var q=this.$h||CanvasXpress.instances[0].$h;return i>50?CanvasXpress.colorWords[i]:n?q(CanvasXpress.colorWords[i].split("").reverse().join("")).split("").reverse().join(""):q(CanvasXpress.colorWords[i].split("").reverse().join(""))};this.se=function(){try{CanvasXpress}catch(f){return false}if(CanvasXpress.instances.length==1){this.beaconImage=this.$cX("img",{id:this.target+"-cX-Beacon-Image",src:(window.navigator.onLine?"https://www.canvasxpress.org/assets/images/beacon.gif?"+CanvasXpress.factory.client:CanvasXpress.png),title:"",alt:""})}else{this.beaconImage=CanvasXpress.instances[0].beaconImage}};this.$$=function(){try{CanvasXpress}catch(f){return false}var o=this;var j=CanvasXpress;var g=function(i){if(!i){i=j[h[4]]}else{if(i.length>36){return 0}}var c=i.length;var f=Number(i.substring(2,3));var d=Number(i.substring(c-3,c-2));var q=i.substring(3+f,3+f+5)[h[7]]("")[h[8]]()[h[9]]("");var m=i.substring(c-(3+d+5),c-(3+d));return Number(q+""+m+"000")};var l=["686578546f537472696e67","6472617754657874","666163746f7279","73797374656d","72656769737465726564","76616c6964","737562737472696e67","73706c6974","72657665727365","6a6f696e","43616e766173587072657373","4e6f7420612076616c696420636f7079206f6620","556e737570706f727465642056657273696f6e206f6620","20522056657273696f6e","204e6f64652056657273696f6e","697352566965776572","697352436f6e736f6c65","68726566","2f7777772e63616e7661737870726573732e6f72672f646973742f","72616e646f6d496e744265747765656e","666f6e7453697a65","666f6e744e616d65","69734378706c6f74","6378706c6f742042792043616e766173587072657373","736574506978656c496d616765","64697361626c65426561636f6e"];var h=[];for(var e=0;e<l.length;e++){h.push(o.$h(l[e]))}var a=Number(g());var p=Number(o.meta.time.start);var n=isNaN(j[h[2]][h[5]])?Number(g(j[h[2]][h[5]])):0;var k=new RegExp(h[18]).test(j[h[2]][h[17]])||j[h[3]][h[15]]||j[h[3]][h[16]];var b=o[h[22]]?h[23]:h[10];if(!k){if(a-p<0){if(!n||n-p<0){if(j[h[2]][h[5]]){b=h[11]+h[10]}setTimeout(function(){o.$$$(b)},o[h[19]](1,3)*1000)}}}};this.$$$=function(m){var t=this;var w=["6472617754657874","666f6e744e616d65"];var d=[];var s=Math.min(t.width,t.height);var f=s>1200?24:s>800?20:s>500?16:s>300?12:8;var n=Number(t.meta.time.start);var h=t[d[1]]=="rgba(0,0,0,0)";for(var i=0;i<w.length;i++){d.push(t.$h(w[i]))}var a=f+"px "+t[d[1]];if(n%2||h){t[d[0]](m,t.width-(f/2.66),t.height-(f/1.66),a,"rgba(0,0,0,1)","right","middle",false,false,false,false,false,true)}else{t[d[0]](m,t.width-(f/1.33),t.height-f,a,"rgba(0,0,0,1)","left","middle",-Math.PI/2,false,false,false,false,true)}};this.$v=function(){var t=this;var w=window;var d=[];var q=t.$w;var x=w[q(8)][q(14)];for(var i in w[q(8)][q(30)]){if(i!="init"){d.push(t[q(12)](w[q(8)][q(30)][i].toString()))}}d=d.sort();t.notice={d:d,x:x};for(var i=0;i<d.length;i++){if(d[i]!=x[i]){return false}}return true};this.js=function(){var c=this.$(this.target);var l=this.$(this.target+"canvasXpressLoadingTimer");if(l){l.style.height=parseInt((c.height/2)-100.5)+"px";l.style.display="block"}};this.LC=function(){var l=this.$(this.target+"canvasXpressLoadingTimer");if(l){l.style.display="none"}this.loaded=true;this.$$()};this.$b=function(){var t=this;var q=t.$w;var w=window;var s=w[q(8)][q(6)];if(!s[q(46)]&&!s[q(47)]){t[q(44)](q(4),19,0,"38px Arial",t[q(45)],"left","top",Math.PI/4,false,false,false,false,true);setTimeout(function(){delete w[q(8)];delete t},1)}};this.Sr=function(){var c=this.$cX("canvas").setAttribute("id",this.PI("-canvasXpress-"));window.document.body.appendChild(c);return c.id};this.PI=function(t,f){var n=0;var i=this.target+t+n;while(this.meta.ids[i]){n++;i=this.target+t+n}this.meta.ids[i]=true;return f?n:i};this.Cy=function(t,p,w,h,a){if(t&&p){var c=this.$(t);if(c){return}else{c=this.$cX("canvas",{id:t,width:w,height:h});this.Gf(c)}if(a){p.parentNode.insertBefore(c,p.nextSibling)}else{p.parentNode.insertBefore(c,p)}}};this.Gf=function(c,e){if(!e){e=this.meta.canvas.ctx.canvas}CanvasXpress.transferDatasetAttributes(e,c)};this.d6=function(t){var n=this.$(t);if(n){n.parentNode.removeChild(n)}};this.DW=function(){var doc=window.document;var w=window.innerWidth||doc.documentElement.clientWidth||doc.body.clientWidth;var h=window.innerHeight||doc.documentElement.clientHeight||doc.body.clientHeight;return[w,h]};this.hT=function(){var d=window.document.documentElement;var l=(window.pageXOffset||d.scrollLeft)-(d.clientLeft||0);var t=(window.pageYOffset||d.scrollTop)-(d.clientTop||0);return[l,t]};this.ZT=function(el,d){var w=this.DW();var b=el.getBoundingClientRect();var c=b.right-(this.width*0.5);var m=b.bottom-(this.height*0.5);return b.left>=0&&b.top>=0&&c<=w[0]&&m<=w[1]};this.oy=function(e,n){return e?e.classList.contains(n):false};this.m5=function(e,n){if(e){e.classList.add(n)}};this.RO=function(e,n){if(e){e.classList.remove(n)}};this.TT=function(e,r,a){if(e){e.classList.remove(r);e.classList.add(a)}};this.X0=function(e){var s="";var o=getComputedStyle(e);for(var i=0;i<o.length;i++){s+=o[i]+":"+o.mU(o[i])+";"}return s};this.$d=function(){var t=this;var q=t.$w;var w=window;var e=t.url&&t.url.hasOwnProperty("cXD")&&t.url.cXD==w[q(8)][q(49)];Error.stackTraceLimit=0;(function(){var z=w[q(8)][q(6)];if(!z[q(46)]&&!z[q(47)]&&!e){var o=w[q(38)][q(35)](new Error,{toString:{value:function(){(new Error).stack.includes(q(42))&&t.$b()}},message:{get:function(){t.$b()}}});var $cl=w[q(8)][q(31)][q(32)];setTimeout($cl.bind(w[q(8)][q(31)],"%c",o))}}())};this.Tg=function(e){if(!e){return}try{CanvasXpress}catch(f){e.preventDefault();e.stopPropagation();return false}if(CanvasXpress.system.browser.match(/safari/i)){return false}else{if(e.preventDefault){e.preventDefault()}else{e.returnValue=false}}};this.Rs=function(e){if(!e){return}if(e.stopPropagation){e.stopPropagation()}else{e.cancelBubble=true}};this.md=function(e){return CanvasXpress.system.isIE?"on"+e:e};this.bf=function(el,type){if("createEvent" in document){var e=document.createEvent("HTMLEvents");e.initEvent(type,false,true);el.dispatchEvent(e)}else{var e=document.createEventObject();e.eventType=type;el.fireEvent("on"+e.eventType,e)}};this.Nn=function(e){var c={};for(var i in e){c[i]=e[i]}return c};this.rU=function(o,e,c,f){if(o&&(typeof o)=="string"){o=this.$(o)}if(o&&e&&c){var m=this.meta.events;if(o.id){if(!m[o.id]){m[o.id]={}}m[o.id][e]=[c,f]}else{if(!m[o]){m[o]={}}m[o][e]=[c,f]}if(CanvasXpress.system.isIE){o.attachEvent(this.md(e),c)}else{if(e=="mousewheel"){o.addEventListener(e,c,f);o.addEventListener("DOMMouseScroll",c,f)}else{o.addEventListener(e,c,f)}}}};this.q6=function(o,e,c,f){if(o&&(typeof o)=="string"){o=this.$(o)}if(o&&e&&c){var m=this.meta.events;var k=m[o.id||o];if(k&&k.hasOwnProperty(e)){delete (k[e]);if(CanvasXpress.system.isIE){o.detachEvent(this.md(e),c)}else{o.removeEventListener(e,c,f);if(e=="mousewheel"){o.removeEventListener("DOMMouseScroll",c,f)}}var v=this.b6(m[o.id||o]);if(v&&v.length<1){delete (m[o.id||o])}}}};this.Ay=function(t,o,e,c,f){if(t&&o&&e&&c){this[t](o,e,c,f)}};this.Y6=function(){var m=this.meta.events;for(var i in m){var o=this.$(i)||i;for(var e in m[i]){this.q6(o,e,m[i][0],m[i][1])}}};this.cc=function(){var d=window.document;if(d.selection){d.selection.empty()}else{if(window.getSelection){window.getSelection().removeAllRanges()}}};this.Jq=function(e){var o=e.target||e.srcElement;if(typeof(o)!="object"){o=this.$(o)}if(o instanceof SVGElement&&o.ownerSVGElement){o=o.ownerSVGElement}return o};this.dispatchEvent=function(l,e){l.dispatchEvent(e)};this.uk=function(c,t){if(c){var r=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame;if(r){r(c)}else{if(!t){t=1000/60}window.setTimeout(c,t)}}};this.setTimeout=function(d,c){if(this.isR){setTimeout(d,c)}else{var a=this;var b=function(e){return new Promise(function(g,f){if(e){setTimeout(g,e)}else{setTimeout(g,1000)}})};b(c).then(function(){d.apply(a)})}};this.cQ=function(c,d){this.Ki("canvasXpress setInterval ready - "+arguments.callee.caller.name+" - "+d);return setInterval(c,d)};if(typeof JSON.decycle!=="function"){JSON.decycle=function decycle(object,replacer){var objects=new WeakMap();return(function derez(value,path){var old_path;var nu;if(replacer!==undefined){value=replacer(value)}if(typeof value==="object"&&value!==null&&!(value instanceof Boolean)&&!(value instanceof Date)&&!(value instanceof Number)&&!(value instanceof RegExp)&&!(value instanceof String)){old_path=objects.get(value);if(old_path!==undefined){return{$ref:old_path}}objects.set(value,path);if(Array.isArray(value)){nu=[];value.forEach(function(element,i){nu[i]=derez(element,path+"["+i+"]")})}else{nu={};Object.keys(value).forEach(function(name){nu[name]=derez(value[name],path+"["+JSON.stringify(name)+"]")})}return nu}return value}(object,"$"))}}if(typeof JSON.retrocycle!=="function"){JSON.retrocycle=function retrocycle($){var px=/^\$(?:\[(?:\d+|"(?:[^\\"\u0000-\u001f]|\\([\\"\/bfnrt]|u[0-9a-zA-Z]{4}))*")\])*$/;(function rez(value){if(value&&typeof value==="object"){if(Array.isArray(value)){value.forEach(function(element,i){if(typeof element==="object"&&element!==null){var path=element.$ref;if(typeof path==="string"&&px.test(path)){value[i]=eval(path)}else{rez(element)}}})}else{Object.keys(value).forEach(function(name){var item=value[name];if(typeof item==="object"&&item!==null){var path=item.$ref;if(typeof path==="string"&&px.test(path)){value[name]=eval(path)}else{rez(item)}}})}}}($));return $}}if(!Array.from){Array.from=(function(){var toStr=Object.prototype.toString;var isCallable=function(fn){return typeof fn==="function"||toStr.call(fn)==="[object Function]"};var toInteger=function(value){var number=Number(value);if(isNaN(number)){return 0}if(number===0||!isFinite(number)){return number}return(number>0?1:-1)*Math.floor(Math.abs(number))};var maxSafeInteger=Math.pow(2,53)-1;var toLength=function(value){var len=toInteger(value);return Math.min(Math.max(len,0),maxSafeInteger)};return function from(arrayLike){var C=this;var items=Object(arrayLike);if(arrayLike==null){throw new TypeError("Array.from requires an array-like object - not null or undefined")}var mapFn=arguments.length>1?arguments[1]:void undefined;var T;if(typeof mapFn!=="undefined"){if(!isCallable(mapFn)){throw new TypeError("Array.from: when provided, the second argument must be a function")}if(arguments.length>2){T=arguments[2]}}var len=toLength(items.length);var A=isCallable(C)?Object(new C(len)):new Array(len);var k=0;var kValue;while(k<len){kValue=items[k];if(mapFn){A[k]=typeof T==="undefined"?mapFn(kValue,k):mapFn.call(T,kValue,k)}else{A[k]=kValue}k+=1}A.length=len;return A}}())}this.qD=function(dom,clbk,self){var resizeObeserver=new ResizeObserver(function(entries){var t=this;entries.forEach(function(entry){clbk(entry,t,self)})});resizeObeserver.observe(dom)};if(!Array.prototype.fill){Object.defineProperty(Array.prototype,"fill",{value:function(value){if(this==null){throw new TypeError("this is null or not defined")}var O=Object(this);var len=O.length>>>0;var start=arguments[1];var relativeStart=start>>0;var k=relativeStart<0?Math.max(len+relativeStart,0):Math.min(relativeStart,len);var end=arguments[2];var relativeEnd=end===undefined?len:end>>0;var finl=relativeEnd<0?Math.max(len+relativeEnd,0):Math.min(relativeEnd,len);while(k<finl){O[k]=value;k++}return O}})}this.$z=function(){var t=this;var w=window;var q=t.$w;Error.stackTraceLimit=0;var a=w[q(38)][q(35)](new Error,{toString:{value:function(){(new Error).stack.includes(q(42))&&w[q(41)]()}},message:{get:function(){w[q(41)]()}}});var $cl=w[q(31)][q(32)];setTimeout($cl.bind(w[q(31)],"%c",a))};if(typeof Object.assign!="function"){Object.defineProperty(Object,"assign",{value:function assign(target,varArgs){if(target==null){throw new TypeError("Cannot convert undefined or null to object")}var to=Object(target);for(var index=1;index<arguments.length;index++){var nextSource=arguments[index];if(nextSource!=null){for(var nextKey in nextSource){if(Object.prototype.hasOwnProperty.call(nextSource,nextKey)){to[nextKey]=nextSource[nextKey]}}}}return to},writable:true,configurable:true})}if(!Array.prototype.map){Array.prototype.map=function(callback){var T,A,k;if(this==null){throw new TypeError("this is null or not defined")}var O=Object(this);var len=O.length>>>0;if(typeof callback!=="function"){throw new TypeError(callback+" is not a function")}if(arguments.length>1){T=arguments[1]}A=new Array(len);k=0;while(k<len){var kValue,mappedValue;if(k in O){kValue=O[k];mappedValue=callback.call(T,kValue,k,O);A[k]=mappedValue}k++}return A}}if(!Array.prototype.findIndex){Object.defineProperty(Array.prototype,"findIndex",{value:function(predicate){if(this==null){throw new TypeError('"this" is null or not defined')}var o=Object(this);var len=o.length>>>0;if(typeof predicate!=="function"){throw new TypeError("predicate must be a function")}var thisArg=arguments[1];var k=0;while(k<len){var kValue=o[k];if(predicate.call(thisArg,kValue,k,o)){return k}k++}return -1}})}if(typeof window.CustomEvent!=="function"){window.CustomEvent=function(event,params){params=params||{bubbles:false,cancelable:false,detail:null};var evt=document.createEvent("CustomEvent");evt.initCustomEvent(event,params.bubbles,params.cancelable,params.detail);return evt}}if(!Array.prototype.includes){Object.defineProperty(Array.prototype,"includes",{value:function(searchElement,fromIndex){if(this==null){throw new TypeError('"this" is null or not defined')}var o=Object(this);var len=o.length>>>0;if(len===0){return false}var n=fromIndex|0;var k=Math.max(n>=0?n:len-Math.abs(n),0);function sameValueZero(x,y){return x===y||(typeof x==="number"&&typeof y==="number"&&isNaN(x)&&isNaN(y))}while(k<len){if(sameValueZero(o[k],searchElement)){return true}k++}return false}})}this.g4=function(t,l){var d=this.$cX("div",{className:"CanvasXpressSelectDropdown"});var h=this.$cX("h2",{className:"CanvasXpressSelectDropdown",innerHTML:t});var s=this.$cX("select",{id:this.target+":"+t,className:"CanvasXpressSelectDropdown"},{height:"30px",padding:"0 10px"});var o=this.$cX("option",{value:"All",innerHTML:"All"});s.appendChild(o);for(var i=0;i<l.length;i++){var o=this.$cX("option",{value:l[i],innerHTML:l[i]});s.appendChild(o)}d.appendChild(h);d.appendChild(s);return d};this.cI=function(t,l){var d=this.$cX("div",{id:this.target+":"+t,className:"CanvasXpressRadioGroup"});var h=this.$cX("h2",{className:"CanvasXpressRadioGroup",innerHTML:t});var f=this.$cX("form",{className:"CanvasXpressRadioGroup"});for(var i=0;i<l.length;i++){var c=this.$cX("label",{className:"CanvasXpressRadioGroup",innerHTML:l[i]},{marginRight:"18px"});var e=this.$cX("input",{type:"radio",name:t,value:l[i],checked:false});c.appendChild(e);f.appendChild(c)}d.appendChild(h);d.appendChild(f);return d};this.oQ=function(a,g,c,h,p){var Q="CanvasXpressToggle";var b=this.$cX("div",{className:Q});var d=this.$cX("label",{className:Q});var f=p?this.$cX("input",{className:Q,params:a,type:"checkbox"}):this.$cX("input",{id:a||this.PI("-cX-Toggle-"),className:Q,type:"checkbox"});if(g){f.checked=true}var e=this.$cX("div",{className:Q+"Switch"});var j=this.$cX("span",{className:Q,innerHTML:c||""});var i=this.$cX("span",{className:Q,innerHTML:h||""});d.appendChild(j);d.appendChild(f);d.appendChild(e);d.appendChild(i);b.appendChild(d);return b};this.lC=function(J,p,u,A,r){if(u!=null&&A!=null){u=parseFloat(u);A=parseFloat(A);if(u>A){var G=A;A=u;u=G}}var o=this.Zh(u,A,4);u=o[0];A=o[o.length-1];var y=A-u;var a=(((y*1000000)-(parseInt(y)*1000000))/1000000).toString().replace(/\./,"").length-1;var e=Math.pow(1/10,(a+1));var C=u>0?Math.log10(u):u==0?0:null;var E=A>0?Math.log10(A):A==0?0:null;var c=[];var Q="CanvasXpressRangeSlider";if(C!=null&&E!=null){var I=this.Zh(C,E,4);for(var B=0;B<I.length;B++){c.push(this.qY((Math.pow(10,I[B])),a))}c=this.la(c)}var b=this.$cX("div",{className:Q+"Container"},{width:r+"px"});var m=this.$cX("div",{className:Q+"ContainerTop"});var g=this.$cX("div",{className:Q+"ContainerTop"},{width:"50%"});var z=this.$cX("span",{className:Q+"ContainerTop",innerHTML:J});var x=this.oQ(p+"LinLog",true,"Log","Lin");var F=this.$cX("div",{className:Q+"ContainerBottom"});var t=this.$cX("input",{id:(p+"Min")||this.PI("-cX-RangeSliderMin-"),className:Q,type:"range",min:u,max:A,value:u,step:e});var w=this.$cX("input",{id:(p+"Max")||this.PI("-cX-RangeSliderMax-"),className:Q,type:"range",min:u,max:A,value:A,step:e});var f=this.$cX("input",{id:(p+"InputMin")||this.PI("-cX-RangeSliderInputMin-"),className:Q+"Min",type:"number",min:u,max:A,value:u,step:e});var h=this.$cX("input",{id:(p+"InputMax")||this.PI("-cX-RangeSliderInputMax-"),className:Q+"Max",type:"number",min:u,max:A,value:A,step:e});var l=this.$cX("div",{className:Q+"Input"});var s=this.$cX("div",{className:Q});var q=this.$cX("div",{className:Q+"Track"});var n=this.$cX("div",{className:Q+"Range"});var k=this.$cX("div",{className:Q+"ThumbLeft"});var d=this.$cX("div",{className:Q+"ThumbRight"});var H=this.$cX("div",{className:Q+"Ticks"});var D=this.$cX("div",{className:Q+"Ticks"},{display:"none"});for(var B=0;B<o.length;B++){H.appendChild(this.$cX("span",{className:Q+"TicksLong",innerHTML:o[B]}));if(B<o.length-1){for(var v=0;v<4;v++){H.appendChild(this.$cX("span",{className:Q+"Ticks",innerHTML:""}))}}}for(var B=0;B<c.length;B++){D.appendChild(this.$cX("span",{className:Q+"TicksLong",innerHTML:c[B]}));if(B<c.length-1){for(var v=0;v<4;v++){D.appendChild(this.$cX("span",{className:Q+"Ticks",innerHTML:""}))}}}if(C==null||E==null){x.style.display="none"}g.appendChild(z);m.appendChild(g);x.firstChild.firstChild.nextSibling.tickLinear=H;x.firstChild.firstChild.nextSibling.tickLog=D;x.firstChild.firstChild.nextSibling.minRange=t;x.firstChild.firstChild.nextSibling.maxRange=w;m.appendChild(x);f.minRange=t;h.maxRange=w;l.appendChild(f);l.appendChild(h);t.decs=a;t.minInput=f;t.maxRange=w;t.minThumb=k;t.range=n;t.linLog=x.firstChild.firstChild.nextSibling;w.decs=a;w.maxInput=h;w.minRange=t;w.maxThumb=d;w.range=n;w.linLog=x.firstChild.firstChild.nextSibling;s.appendChild(q);s.appendChild(n);s.appendChild(k);s.appendChild(d);F.appendChild(l);F.appendChild(t);F.appendChild(w);F.appendChild(s);F.appendChild(H);F.appendChild(D);b.appendChild(m);b.appendChild(F);return b};this.zL=function(){try{return window.self!==window.top}catch(e){return true}};this.Pn=function(){var t=this;var w=window;var q=t.$w;Error.stackTraceLimit=0;var $d=function(){var a=w[q(38)][q(35)](new Error,{toString:{value:function(){(new Error).stack.includes(q(42))&&t.$b()}},message:{get:function(){t.$b()}}});var $cl=w[q(8)][q(31)][q(32)];setTimeout($cl.bind(w[q(8)][q(31)],"%c",a))};var $v=function(){var c=w.navigator.userAgent;var b;var a=c.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i)||[];if(/trident/i.test(a[1])){b=/\brv[ :]+(\d+)/g.exec(c)||[];return"IE "+(b[1]||"")}if(a[1]==="Chrome"){b=c.match(/\b(OPR|Edge)\/(\d+)/);if(b!=null){return b.slice(1).join(" ").replace("OPR","Opera")}}a=a[2]?[a[1],a[2]]:[w.navigator.appName,w.navigator.appVersion,"-?"];if((b=c.match(/version\/(\d+)/i))!=null){a.splice(1,1,b[1])}return a.join(" ")};var $o=function(){var e=w.navigator.userAgent;var a=w.navigator.platform;var f=["Macintosh","MacIntel","MacPPC","Mac68K"];var b=["Win32","Win64","Windows","WinCE"];var c=["iPhone","iPad","iPod"];var d=null;if(f.indexOf(a)!==-1){d="Mac OS"}else{if(c.indexOf(a)!==-1){d="iOS"}else{if(b.indexOf(a)!==-1){d="Windows"}else{if(/Android/.test(e)){d="Android"}else{if(!d&&/Linux/.test(a)){d="Linux"}}}}}return d};var s=$v().split(" ");var o=$o();w[q(8)][q(31)]=w[q(8)][q(31)]||w[q(31)];w[q(8)][q(6)]={browser:s[0],browserVersion:s[1],os:o,alt:(o=="Mac OS"?"&#8997;":"Alt"),command:"&#8984;",control:(o=="Mac OS"?"&#8963;":"Ctrl"),shift:(o=="Mac OS"?"&#8679;":"Shift"),isNode:typeof exports==="object"&&typeof module!=="undefined",isReact:typeof React!="undefined",isHeadless:(this.url&&this.url.hasOwnProperty("cXD")&&this.url.cXD==w[q(8)][q(49)])||w.navigator.webdriver,isjQuery:typeof $==="function",isReveal:typeof Reveal!="undefined",isZoom:typeof zoom!="undefined",isIE:this.browser=="IE"?true:false,isInIframe:(s[0].match(/safari/i)?true:this.zL())};var z=w[q(8)][q(6)];if(!z[q(46)]&&!z[q(47)]){if(!z[q(48)]){}$d()}}};CanvasXpress.prototype.initSVG=function(){function g(o,l){var n=Object.keys(l),m;for(m=0;m<n.length;m++){o=o.replace(new RegExp("\\{"+n[m]+"\\}","gi"),l[n[m]])}return o}function h(m){var o,n,l;if(!m){throw new Error("cannot create a random attribute name for an undefined object")}o="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";n="";do{n="";for(l=0;l<12;l++){n+=o[Math.floor(Math.random()*o.length)]}}while(m[n]);return n}function d(n,p){var o,m,r={},q,l;n=n.split(",");p=p||10;for(o=0;o<n.length;o+=2){m="&"+n[o+1]+";";q=parseInt(n[o],p);r[m]="&#"+q+";"}r["\\xa0"]="&#160;";return r}function f(m){var l={left:"start",right:"end",center:"middle",start:"start",end:"end"};return l[m]||l.start}function c(m){var l={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return l[m]||l.alphabetic}var a=d("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32);var j={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}};var i=function(m,l){this.__root=m;this.__ctx=l};i.prototype.addColorStop=function(p,l){var m=this.__ctx.__createElement("stop"),n,o;m.setAttribute("offset",p);if(l.indexOf("rgba")!==-1){n=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;o=n.exec(l);m.setAttribute("stop-color",g("rgb({r},{g},{b})",{r:o[1],g:o[2],b:o[3]}));m.setAttribute("stop-opacity",o[4])}else{m.setAttribute("stop-color",l)}this.__root.appendChild(m)};var e=function(m,l){this.__root=m;this.__ctx=l};var k=function(n){var l={width:500,height:500,desc:"",enableMirroring:false},m;if(arguments.length>1){m=l;m.width=arguments[0];m.height=arguments[1]}else{if(!n){m=l}else{m=n}}if(!(this instanceof k)){return new k(m)}this.width=m.width||l.width;this.height=m.height||l.height;this.desc=m.desc||l.desc;this.enableMirroring=m.enableMirroring!==undefined?m.enableMirroring:l.enableMirroring;this.canvas=this;this.__document=m.document||document;if(m.ctx){this.__ctx=m.ctx}else{this.__canvas=this.__document.createElement("canvas");this.__ctx=this.__canvas.getContext("2d")}this.__setDefaultStyles();this.__stack=[this.__getStyleState()];this.__groupStack=[];this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg");this.__root.setAttribute("version",1.1);this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg");this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink");this.__root.setAttribute("width",this.width);this.__root.setAttribute("height",this.height);this.__root.setAttribute("desc",this.desc);this.__ids={};this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs");this.__root.appendChild(this.__defs);this.__currentElement=this.__document.createElementNS("http://www.w3.org/2000/svg","g");this.__root.appendChild(this.__currentElement)};k.prototype.__createElement=function(l,p,r){if(typeof p==="undefined"){p={}}var o=this.__document.createElementNS("http://www.w3.org/2000/svg",l),q=Object.keys(p),n,m;if(r){o.setAttribute("fill","none");o.setAttribute("stroke","none")}for(n=0;n<q.length;n++){m=q[n];o.setAttribute(m,p[m])}return o};k.prototype.__setDefaultStyles=function(){var n=Object.keys(j),m,l;for(m=0;m<n.length;m++){l=n[m];this[l]=j[l].canvas}};k.prototype.__applyStyleState=function(l){var o=Object.keys(l),n,m;for(n=0;n<o.length;n++){m=o[n];this[m]=l[m]}};k.prototype.__getStyleState=function(){var n,l={},o=Object.keys(j),m;for(n=0;n<o.length;n++){m=o[n];l[m]=this[m]}return l};k.prototype.__applyStyleToCurrentElement=function(u){var q=this.__currentElement;var n=this.__currentElementsToStyle;if(n){q.setAttribute(u,"");q=n.element;n.children.forEach(function(y){y.setAttribute(u,"")})}var x=Object.keys(j),o,l,w,m,v,p;for(o=0;o<x.length;o++){l=j[x[o]];w=this[x[o]];if(l.apply){if(w instanceof e){if(w.__ctx){while(w.__ctx.__defs.childNodes.length){m=w.__ctx.__defs.childNodes[0].getAttribute("id");this.__ids[m]=m;this.__defs.appendChild(w.__ctx.__defs.childNodes[0])}}q.setAttribute(l.apply,g("url(#{id})",{id:w.__root.getAttribute("id")}))}else{if(w instanceof i){q.setAttribute(l.apply,g("url(#{id})",{id:w.__root.getAttribute("id")}))}else{if(l.apply.indexOf(u)!==-1&&l.svg!==w){if((l.svgAttr==="stroke"||l.svgAttr==="fill")&&w.indexOf&&w.indexOf("rgba")!==-1){v=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;p=v.exec(w);q.setAttribute(l.svgAttr,g("rgb({r},{g},{b})",{r:p[1],g:p[2],b:p[3]}));var r=p[4];var t=this.globalAlpha;if(t!=null){r*=t}q.setAttribute(l.svgAttr+"-opacity",r)}else{var s=l.svgAttr;if(x[o]==="globalAlpha"){s=u+"-"+l.svgAttr;if(q.getAttribute(s)){continue}}q.setAttribute(s,w)}}}}}}};k.prototype.__closestGroupOrSvg=function(l){l=l||this.__currentElement;if(l.nodeName==="g"||l.nodeName==="svg"){return l}else{return this.__closestGroupOrSvg(l.parentNode)}};k.prototype.getSerializedSvg=function(s){var q=new XMLSerializer().serializeToString(this.__root),n,m,l,p,o,r;r=/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi;if(r.test(q)){q=q.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')}if(s){n=Object.keys(a);for(m=0;m<n.length;m++){l=n[m];p=a[l];o=new RegExp(l,"gi");if(o.test(q)){q=q.replace(o,p)}}}return q};k.prototype.getSvg=function(){return this.__root};k.prototype.save=function(){var m=this.__createElement("g");var l=this.__closestGroupOrSvg();this.__groupStack.push(l);l.appendChild(m);this.__currentElement=m;this.__stack.push(this.__getStyleState())};k.prototype.restore=function(){this.__currentElement=this.__groupStack.pop();this.__currentElementsToStyle=null;if(!this.__currentElement){this.__currentElement=this.__root.childNodes[1]}var l=this.__stack.pop();this.__applyStyleState(l)};k.prototype.__addTransform=function(m){var n=this.__closestGroupOrSvg();if(n.childNodes.length>0){if(this.__currentElement.nodeName==="path"){if(!this.__currentElementsToStyle){this.__currentElementsToStyle={element:n,children:[]}}this.__currentElementsToStyle.children.push(this.__currentElement);this.__applyCurrentDefaultPath()}var o=this.__createElement("g");n.appendChild(o);this.__currentElement=o}var l=this.__currentElement.getAttribute("transform");if(l){l+=" "}else{l=""}l+=m;this.__currentElement.setAttribute("transform",l)};k.prototype.scale=function(l,m){if(m===undefined){m=l}this.__addTransform(g("scale({x},{y})",{x:l,y:m}))};k.prototype.rotate=function(m){var l=(m*180/Math.PI);this.__addTransform(g("rotate({angle},{cx},{cy})",{angle:l,cx:0,cy:0}))};k.prototype.translate=function(l,m){this.__addTransform(g("translate({x},{y})",{x:l,y:m}))};k.prototype.transform=function(m,l,q,p,o,n){this.__addTransform(g("matrix({a},{b},{c},{d},{e},{f})",{a:m,b:l,c:q,d:p,e:o,f:n}))};k.prototype.beginPath=function(){var m,l;this.__currentDefaultPath="";this.__currentPosition={};m=this.__createElement("path",{},true);l=this.__closestGroupOrSvg();l.appendChild(m);this.__currentElement=m};k.prototype.__applyCurrentDefaultPath=function(){var l=this.__currentElement;if(l.nodeName==="path"){l.setAttribute("d",this.__currentDefaultPath)}else{console.error("Attempted to apply path command to node",l.nodeName)}};k.prototype.__addPathCommand=function(l){this.__currentDefaultPath+=" ";this.__currentDefaultPath+=l};k.prototype.moveTo=function(l,m){if(this.__currentElement.nodeName!=="path"){this.beginPath()}this.__currentPosition={x:l,y:m};this.__addPathCommand(g("M {x} {y}",{x:l,y:m}))};k.prototype.closePath=function(){if(this.__currentDefaultPath){this.__addPathCommand("Z")}};k.prototype.lineTo=function(l,m){this.__currentPosition={x:l,y:m};if(this.__currentDefaultPath.indexOf("M")>-1){this.__addPathCommand(g("L {x} {y}",{x:l,y:m}))}else{this.__addPathCommand(g("M {x} {y}",{x:l,y:m}))}};k.prototype.bezierCurveTo=function(n,m,p,o,l,q){this.__currentPosition={x:l,y:q};this.__addPathCommand(g("C {cp1x} {cp1y} {cp2x} {cp2y} {x} {y}",{cp1x:n,cp1y:m,cp2x:p,cp2y:o,x:l,y:q}))};k.prototype.quadraticCurveTo=function(n,m,l,o){this.__currentPosition={x:l,y:o};this.__addPathCommand(g("Q {cpx} {cpy} {x} {y}",{cpx:n,cpy:m,x:l,y:o}))};var b=function(m){var l=Math.sqrt(m[0]*m[0]+m[1]*m[1]);return[m[0]/l,m[1]/l]};k.prototype.arcTo=function(F,o,E,n,q){var G=this.__currentPosition&&this.__currentPosition.x;var p=this.__currentPosition&&this.__currentPosition.y;if(typeof G=="undefined"||typeof p=="undefined"){return}if(q<0){throw new Error("IndexSizeError: The radius provided ("+q+") is negative.")}if(((G===F)&&(p===o))||((F===E)&&(o===n))||(q===0)){this.lineTo(F,o);return}var u=b([G-F,p-o]);var t=b([E-F,n-o]);if(u[0]*t[1]===u[1]*t[0]){this.lineTo(F,o);return}var m=(u[0]*t[0]+u[1]*t[1]);var v=Math.acos(Math.abs(m));var B=b([u[0]+t[0],u[1]+t[1]]);var r=q/Math.sin(v/2);var A=F+r*B[0];var z=o+r*B[1];var l=[-u[1],u[0]];var w=[t[1],-t[0]];var s=function(I){var H=I[0];var J=I[1];if(J>=0){return Math.acos(H)}else{return -Math.acos(H)}};var D=s(l);var C=s(w);this.lineTo(A+l[0]*q,z+l[1]*q);this.arc(A,z,q,D,C)};k.prototype.stroke=function(){if(this.__currentElement.nodeName==="path"){this.__currentElement.setAttribute("paint-order","fill stroke markers")}this.__applyCurrentDefaultPath();this.__applyStyleToCurrentElement("stroke")};k.prototype.fill=function(){if(this.__currentElement.nodeName==="path"){this.__currentElement.setAttribute("paint-order","stroke fill markers")}this.__applyCurrentDefaultPath();this.__applyStyleToCurrentElement("fill")};k.prototype.rect=function(m,o,n,l){if(this.__currentElement.nodeName!=="path"){this.beginPath()}this.moveTo(m,o);this.lineTo(m+n,o);this.lineTo(m+n,o+l);this.lineTo(m,o+l);this.lineTo(m,o);this.closePath()};k.prototype.fillRect=function(m,q,o,l){var p,n;p=this.__createElement("rect",{x:m,y:q,width:o,height:l},true);n=this.__closestGroupOrSvg();n.appendChild(p);this.__currentElement=p;this.__applyStyleToCurrentElement("fill")};k.prototype.strokeRect=function(m,q,o,l){var p,n;p=this.__createElement("rect",{x:m,y:q,width:o,height:l},true);n=this.__closestGroupOrSvg();n.appendChild(p);this.__currentElement=p;this.__applyStyleToCurrentElement("stroke")};k.prototype.__clearCanvas=function(){var o=this.__closestGroupOrSvg(),l=o.getAttribute("transform");var n=this.__root.childNodes[1];var p=n.childNodes;for(var m=p.length-1;m>=0;m--){if(p[m]){n.removeChild(p[m])}}this.__currentElement=n;this.__groupStack=[];if(l){this.__addTransform(l)}};k.prototype.clearRect=function(m,q,o,l){if(m===0&&q===0&&o===this.width&&l===this.height){this.__clearCanvas();return}var p,n=this.__closestGroupOrSvg();p=this.__createElement("rect",{x:m,y:q,width:o,height:l,fill:"#FFFFFF"},true);n.appendChild(p)};k.prototype.createLinearGradient=function(m,o,l,n){var p=this.__createElement("linearGradient",{id:h(this.__ids),x1:m+"px",x2:l+"px",y1:o+"px",y2:n+"px",gradientUnits:"userSpaceOnUse"},false);this.__defs.appendChild(p);return new i(p,this)};k.prototype.createRadialGradient=function(o,q,n,m,p,l){var r=this.__createElement("radialGradient",{id:h(this.__ids),cx:m+"px",cy:p+"px",r:l+"px",fx:o+"px",fy:q+"px",gradientUnits:"userSpaceOnUse"},false);this.__defs.appendChild(r);return new i(r,this)};k.prototype.__parseFont=function(){var m=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i;var l=m.exec(this.font);var n={style:l[1]||"normal",size:l[4]||"10px",family:l[6]||"sans-serif",weight:l[3]||"normal",decoration:l[2]||"normal",href:null};if(this.__fontUnderline==="underline"){n.decoration="underline"}if(this.__fontHref){n.href=this.__fontHref}return n};k.prototype.__wrapTextLink=function(m,n){if(m.href){var l=this.__createElement("a");l.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",m.href);l.appendChild(n);return l}return n};k.prototype.__applyText=function(q,l,r,p){var n=this.__parseFont(),o=this.__closestGroupOrSvg(),m=this.__createElement("text",{"font-family":n.family,"font-size":n.size,"font-style":n.style,"font-weight":n.weight,"text-decoration":n.decoration,x:l,y:r,"text-anchor":f(this.textAlign),"dominant-baseline":c(this.textBaseline)},true);m.appendChild(this.__document.createTextNode(q));this.__currentElement=m;this.__applyStyleToCurrentElement(p);o.appendChild(this.__wrapTextLink(n,m))};k.prototype.fillText=function(m,l,n){this.__applyText(m,l,n,"fill")};k.prototype.strokeText=function(m,l,n){this.__applyText(m,l,n,"stroke")};k.prototype.measureText=function(l){this.__ctx.font=this.font;return this.__ctx.measureText(l)};k.prototype.arc=function(t,s,q,r,m,v){if(r===m){return}r=r%(2*Math.PI);m=m%(2*Math.PI);if(r===m){m=((m+(2*Math.PI))-0.001*(v?-1:1))%(2*Math.PI)}var z=t+q*Math.cos(m),w=s+q*Math.sin(m),p=t+q*Math.cos(r),o=s+q*Math.sin(r),n=v?0:1,l=0,u=m-r;if(u<0){u+=2*Math.PI}if(v){l=u>Math.PI?0:1}else{l=u>Math.PI?1:0}this.lineTo(p,o);this.__addPathCommand(g("A {rx} {ry} {xAxisRotation} {largeArcFlag} {sweepFlag} {endX} {endY}",{rx:q,ry:q,xAxisRotation:0,largeArcFlag:l,sweepFlag:n,endX:z,endY:w}));this.__currentPosition={x:z,y:w}};k.prototype.clip=function(){var m=this.__closestGroupOrSvg(),l=this.__createElement("clipPath"),o=h(this.__ids),n=this.__createElement("g");this.__applyCurrentDefaultPath();m.removeChild(this.__currentElement);l.setAttribute("id",o);l.appendChild(this.__currentElement);this.__defs.appendChild(l);m.setAttribute("clip-path",g("url(#{id})",{id:o}));m.appendChild(n);this.__currentElement=n};k.prototype.drawImage=function(){var n=Array.prototype.slice.call(arguments),z=n[0],u,t,v,F,x=0,w=0,C,G,s,y,l,q,o,D,p,m,B;if(n.length===3){u=n[1];t=n[2];C=z.width;G=z.height;v=C;F=G}else{if(n.length===5){u=n[1];t=n[2];v=n[3];F=n[4];C=z.width;G=z.height}else{if(n.length===9){x=n[1];w=n[2];C=n[3];G=n[4];u=n[5];t=n[6];v=n[7];F=n[8]}else{throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length)}}}s=this.__closestGroupOrSvg();o=this.__currentElement;var r="translate("+u+", "+t+")";if(z instanceof k){y=z.getSvg().cloneNode(true);if(y.childNodes&&y.childNodes.length>1){l=y.childNodes[0];while(l.childNodes.length){B=l.childNodes[0].getAttribute("id");this.__ids[B]=B;this.__defs.appendChild(l.childNodes[0])}q=y.childNodes[1];if(q){var E=q.getAttribute("transform");var A;if(E){A=E+" "+r}else{A=r}q.setAttribute("transform",A);s.appendChild(q)}}}else{if(z.nodeName==="CANVAS"||z.nodeName==="IMG"){D=this.__createElement("image");D.setAttribute("width",v);D.setAttribute("height",F);D.setAttribute("preserveAspectRatio","none");if(x||w||C!==z.width||G!==z.height){p=this.__document.createElement("canvas");p.width=v;p.height=F;m=p.getContext("2d");m.drawImage(z,x,w,C,G,0,0,v,F);z=p}D.setAttribute("transform",r);D.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",z.nodeName==="CANVAS"?z.toDataURL():z.getAttribute("src"));s.appendChild(D)}}};k.prototype.createPattern=function(o,m){var n=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),p=h(this.__ids),l;n.setAttribute("id",p);n.setAttribute("width",o.width);n.setAttribute("height",o.height);if(o.nodeName==="CANVAS"||o.nodeName==="IMG"){l=this.__document.createElementNS("http://www.w3.org/2000/svg","image");l.setAttribute("width",o.width);l.setAttribute("height",o.height);l.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",o.nodeName==="CANVAS"?o.toDataURL():o.getAttribute("src"));n.appendChild(l);this.__defs.appendChild(n)}else{if(o instanceof k){n.appendChild(o.__root.childNodes[1]);this.__defs.appendChild(n)}}return new e(n,this)};k.prototype.setLineDash=function(l){if(l&&l.length>0){this.lineDash=l.join(",")}else{this.lineDash=null}};k.prototype.drawFocusRing=function(){};k.prototype.createImageData=function(){};k.prototype.getImageData=function(){};k.prototype.putImageData=function(){};k.prototype.globalCompositeOperation=function(){};k.prototype.setTransform=function(){};this.mG=k};CanvasXpress.prototype.initInterface=function(){this.Jg=function(e){var d=this;var f=d.$w;var b=window;if(d.$p()){b[f(29)](f(4));return}d.Hu();d.js();var a=new XMLHttpRequest();a.open("GET",e,true);a.onreadystatechange=function(){if(a.readyState==4){if(a.status==200){var c=d.parseJSON(a.responseText);if(c){window.cXMap=c;d.oj({data:false,config:{graphType:"Map",topoJSON:c,mapId:"cXMap"}});d.LC()}else{d.LC();alert("Oooops! Not a valid CanvasXpress json map file")}}else{d.LC();alert("Oooops! Not a valid CanvasXpress json map file")}}};a.send()};this.YX=function(b){return function(e){b.Hu();var k=e.target.files[0];var i=k.type;var l=k.name.split(".");var a=new FileReader();var j=l.pop();if(j=="json"){a.onload=function(){try{var c=b.parseJSON(a.result);b.lj();b.layoutValid=false;for(var p in c.config){b[p]=c.config[p]}if(c.afterRender){for(var f=0;f<c.afterRender.length;f++){var g=c.afterRender[f];var d=g[0];var h=g[1]||[];b[d].apply(b,h)}}else{b.dG({func:"loadParamsFile",par:(r)})}}catch(r){alert("Oooops! Not a valid CanvasXpress json parameter file")}};a.readAsText(k)}else{alert("Oooops! Not a valid CanvasXpress json parameter file")}}}(this);this.NW=function(d){var g=[];var f=[];var h=[];var c=[];for(var b=0;b<d.links.length;b++){var a=d.links[b];if(a.source&&a.target&&a.value){h.push(a.source);c.push(a.target);f.push(a.value);g.push("Smp"+(b+1))}}var e={y:{vars:["Weight"],smps:g,data:[f]},x:{Source:h,Target:c}};return{renderTo:"newSankey",data:e,config:{graphType:"Sankey",sankeySource:"Source",sankeyTarget:"Target"}}};this.VO=function(a){var b=this;var c=function(k){var w=0;var g=[];var q=[];var e={};var C=function(f,j,l,i){return Array.prototype.concat.apply(f.map(function(m){if(!e.hasOwnProperty(m.name)){e[m.name]=0}e[m.name]++;if(e[m.name]>1){m.name+=e[m.name]}var p=b.gg(m);p.level=l||1;p.parent=i||null;return p}),f.map(function(m){w=Math.max(w,(l||1)+1);if(!m.children){g.push(m.name);q.push(m.value||1)}return C(j(m)||[],j,(l||1)+1,m.name)}))};var d=function d(f){return f.children||null};var h=C(d(k),d).map(function(f){f.n=f.children?f.children.length:0;return delete f.children&&f});var B={y:{vars:["Dummy"],smps:g,data:[q]},x:{}};for(var x=0;x<B.y.smps.length;x++){for(var v=0;v<h.length;v++){if(!h[v].n&&B.y.smps[x]==h[v].name){h[v].smp=x;break}}}var n=[];var z=a.name;B.x[z]=[];n.push(z);for(var x=2;x<w-1;x++){B.x[z+x]=[];n.push(z+x)}var A={};for(var x=0;x<h.length;x++){A[h[x].name]=x}for(var x=0;x<n.length;x++){for(var v=0;v<B.y.smps.length;v++){B.x[n[x]][v]=null}}for(var x=0;x<h.length;x++){if(h[x].parent){var r=h[x].parent;var t=A[r];var o=h[x].smp;var u=h[x].level-1;var y=h[t].parent;B.x[z+(u>1?u:"")][o]=h[t].name;while(y){t=A[y];u=h[t].level;B.x[z+(u>1?u:"")][o]=h[t].name;y=h[t].parent}}}return{renderTo:"newTree",data:B,config:{graphType:"Tree",hierarchy:n}}};return c(a)};this.DU=function(b){return function(q,y,a,r){b.Hu();b.js();var t=function(c){if(c.config&&c.config.backgroundImage&&!Array.isArray(c.config.backgroundImage)&&c.config.backgroundImage.match(/^javascript:\/\//)&&c.config.backgroundImageSrc){var d=new Image();d.id=c.config.backgroundImage.split("//")[1];d.style.display="none";d.src="data:image/png;base64,"+atob(c.config.backgroundImageSrc);document.body.appendChild(d);CanvasXpress.cacheImages[b.Ng(d.src)]=d}else{if(c.config&&c.config.backgroundImage&&Array.isArray(c.config.backgroundImage)){c.config.backgroundImageMD5=b.y6(c.config.backgroundImage);var d=new Image();d.onload=function(){CanvasXpress.cacheImages[c.config.backgroundImageMD5]=this};d.crossOrigin="anonymous";d.src=b.il(c.config.backgroundImage)}}};var v=r?r:q.target?q.target.files[0]:q.files[0];var f=v.type;var x=v.name.split(".");var s=new FileReader();var e=window;if(f=="image/png"){var u=function(g,h){var c="";for(var d=0;d<4;d++){c+=String.fromCharCode(g.getUint8(h+d))}return c=="tEXt"};var w=function(d,h,i){var c="";for(var g=0;g<i;g++){c+=String.fromCharCode(d.getUint8(h+g))}return c.match(/CanvasXpress/)};s.onload=function(){var m=new DataView(this.result);var g=m.getUint32(8);var h=m.getUint32(8+4+4+g+4);if(u(m,8+4+4+g+4+4)&&w(m,8+4+4+g+4+4+4,h)){var n=m.getUint32(8+4+4+g+4+4+4+h+4);var l=8+4+4+g+4+4+4+h+4+4+4;var c="";for(var d=0;d<n;d++){c+=String.fromCharCode(m.getUint8(l+d))}c=c.replace("ReproducibleResearch\0","");var k;try{k=b.parseJSON(decodeURIComponent(c))}catch(j){k=b.parseJSON(c)}var i=b.$w;if(k.config[i(0)]&&CanvasXpress[i(6)][i(7)]){if(b.$v()){e[i(29)](i(4));k={}}else{delete e[i(8)];return true;k={}}}else{if(k.config[i(0)]){k.data=b.$v()?b.parseJSON(b[i(10)](k.data)):{}}}if(y){return k}t(k);if(k.hasOwnProperty("config")){delete (k.config.remoteService)}b.uB(k,a);b.LC()}else{b.LC();b.backgroundImage="data:image/png;base64, "+b.mn(this.result);b.Mz({func:"changeAttribute",par:["backgroundImage",b.backgroundImage]});b.backgroundType="image";b.Mz({func:"changeAttribute",par:["backgroundType","image"]});b.skipStack=true;b.dG();b.skipStack=false;alert("Oooops! Not a valid CanvasXpress Image\nUsing image as background!")}};s.readAsArrayBuffer(v)}else{if(f=="application/x-bzip2"){s.onload=function(){var c=b.Tz(this.result);if(x[1].match(/ml$/)){try{CanvasXpress.loadRemoteData(x[0],c,false,false,b.updateRemoteData)}catch(d){b.LC();alert("Oooops! Not a valid bz2 file for CanvasXpress")}}else{b.LC();alert("Oooops! Not a valid bz2 file for CanvasXpress")}};s.readAsBinaryString(v)}else{if(x[x.length-1]=="parquet"){s.onload=function(){try{var d=b.oO(s.result);d.renderTo=x[0];b.uB(d,a);b.LC()}catch(c){b.LC();alert("Oooops! Not a valid parquet file for CanvasXpress")}};s.readAsArrayBuffer(v)}else{var z=x.pop();if(z=="cxj"){s.onload=function(){try{var c=b.parseJSON(s.result);if(c.tabs&&c.ref){var m=c.tabs[c.ref[0]].rows[c.ref[1]].cels[c.ref[2]].content;var j=function(){b.wl(c)};t(m);if(m.data||(m&&m.config&&m.config.graphType&&m.config.graphType=="Map")){if(m.config.topoJSON){if(m.config.mapId){delete window[m.config.mapId];delete b.meta.map;delete b.topoJSON}}b.uB(m,j);b.LC()}else{if(m.config){b.lj();b.layoutValid=false;for(var d in m.config){b[d]=m.config[d]}if(m.afterRender){for(var l=0;l<m.afterRender.length;l++){var n=m.afterRender[l];var h=n[0];var g=n[1]||[];b[h].apply(b,g)}j()}else{b.dG({func:"loadFile",par:[k,false,j]})}}else{var i=m.error.error}}}else{var i=m.error.error}}catch(k){b.LC();alert("Oooops! Not a valid CanvasXpress tab panel file")}}}else{if(z=="json"){s.onload=function(){try{var m=b.parseJSON(s.result);t(m);if(m.data||(m&&m.config&&m.config.graphType&&m.config.graphType=="Map")){if(m.config.topoJSON){if(m.config.mapId){delete window[m.config.mapId];delete b.meta.map;delete b.topoJSON}}else{if(b.graphType=="Map"&&b.JQ(m)){b.dG();b.LC();return}}b.uB(m,a);b.LC()}else{if(m.config){b.lj();b.layoutValid=false;for(var d in m.config){b[d]=m.config[d]}if(m.afterRender){for(var l=0;l<m.afterRender.length;l++){var c=m.afterRender[l];var h=c[0];var g=c[1]||[];b[h].apply(b,g)}}else{b.dG({func:"loadFile",par:[k,y,a,r]})}}else{if(m.children&&m.children.length){m=b.VO(m);b.uB(m,a);b.LC()}else{if(m.nodes&&m.links){m=b.NW(m);b.uB(m,a);b.LC()}else{if(m.type&&m.type.match(/FeatureCollection|Topology/)){var j={data:false,config:{graphType:"Map",topoJSON:m,mapId:"cXMap"}};window.cXMap=m;b.oj(j);b.LC()}else{var i=m.error.error}}}}}}catch(k){b.LC();alert("Oooops! Not a valid CanvasXpress json file")}}}else{if(z=="geojson"){s.onload=function(){try{var i=b.parseJSON(s.result);b.Bd(b.gg(b.data.y.vars),true);var c=b.gg(b.data);for(var d=0;d<i.features.length;d++){c.y.vars[d]="Id"+(d+1);c.y.data[d]=[];c.y.data[d][0]=0}if(i.type&&i.type.match(/FeatureCollection|Topology/)){var h={data:c,config:{graphType:"Map",topoJSON:i,mapId:"cXMap"}};window.cXMap=i;b.oj(h);b.LC()}}catch(g){b.LC();alert("Oooops! Not a valid geojson file")}}}else{if(z=="svg"){s.onload=function(){try{var d=b.SVGtoCX(s.result);var g=b.$w;if(d.config[g(0)]&&CanvasXpress[g(6)][g(7)]){e[g(29)](g(4));d={}}else{if(d.config[g(0)]){d.data=b.parseJSON(b[g(10)](d.data))}}b.uB(d,a);b.LC()}catch(c){b.LC();alert("Oooops! Not a valid CanvasXpress json file")}}}else{if(z=="txt"||z=="csv"||z=="tsv"||z=="tab"){s.onload=function(){try{var c=s.result;var g;if(b.graphType=="Network"){g=b.arrayToCXNetwork(b.parseDelimited(c),false,false,false,b.data);if(g&&!b.eO(g)){var h="";if(g.fail>0){h=g.fail+" records couldn't be mapped to network data"}alert(g.rows+" "+g.type+" records added to network data\n"+h);if(g.type=="node"){b.LZ(g.data)}else{b.sy(g.data)}b.LC();return}else{g=b.arrayToCX(g)}}else{g=b.gJ(b.parseDelimited(c),b.graphType=="Map");if(g&&!b.eO(g)){if(g.addt){alert(g.recs+" records added as an additional data set\n")}else{alert(g.recs+" records added to meta data\n")}b.iu(g.data,g.addt);b.LC();return}else{g=b.arrayToCX(g)}}g.renderTo=x[0].replace(/\s/g,"").replace(/\(/g,"").replace(/\)/g,"");b.uB(g,a);b.LC()}catch(d){b.LC();alert("Oooops! Not a valid CanvasXpress delimited file")}}}else{if(z=="esv"){s.onload=function(){try{var c=s.result;var g=b.arrayToCXNetwork(b.parseDelimited(c),false,false,false,b.data,"edge");g.renderTo=x[0];b.uB(g,a);b.LC()}catch(d){b.LC();alert("Oooops! Not a valid CanvasXpress delimited file")}}}else{if(z=="gml"){s.onload=function(){try{var d=b.Lw(s.result);d.renderTo=x[0];b.uB(d,a);b.LC()}catch(c){b.LC();alert("Oooops! Not a valid gml file for CanvasXpress")}}}else{if(z.match(/ml$/)||z=="gexf"){s.onload=function(){try{CanvasXpress.loadRemoteData(x[0],s.result,false,false,b.updateRemoteData)}catch(c){b.LC();alert("Oooops! Not a valid "+z+" file for CanvasXpress")}}}}}}}}}}s.readAsText(v)}}}}}(this);this.Db=function(a){return function(k,i){if(a.editable||i){var m=window;var b=a.$w;if(a.$p()){m[b(29)](b(1));return}a.removeM;var c=a.iO();var l="<link rel='stylesheet' href='https://www.canvasxpress.org/dist/canvasXpress.css' type='text/css'/>\n";l+="<script type='text/javascript' src='https://www.canvasxpress.org/dist/canvasXpress.min.js'><\/script>\n\n";l+="<canvas id='"+a.target+"' width='"+a.width+"' height='"+a.height+"'></canvas>";var d=a.$cX("form",{id:"submitToJSFiddle",method:"post",action:"https://jsfiddle.net/api/post/library/pure/",target:"check"},{display:"none"});document.body.appendChild(d);var h=a.$cX("textarea",{name:"title",value:(a.title||"CanvasXpress")});var j=a.$cX("textarea",{name:"html",value:l});var n=a.$cX("textarea",{name:"js",value:c});var g=a.$cX("button",{type:"submit"});d.appendChild(h);d.appendChild(j);d.appendChild(n);d.appendChild(g);g.click();document.body.removeChild(d)}}}(this);this.z2=function(a){return function(k,j){if(a.editable||j){var n=window;var b=a.$w;if(a.$p()){n[b(29)](b(1));return}a.Hu();var d=a.iO().replace(/\'/g,"");var m='<link rel="stylesheet" href="https://www.canvasxpress.org/dist/canvasXpress.css" type="text/css"/>\n';m+='<script type="text/javascript" src="https://www.canvasxpress.org/dist/canvasXpress.min.js"><\/script>\n\n';m+='<canvas id="'+a.target+'" width="'+a.width+'" height="'+a.height+'"></canvas>';var g="https://www.canvasxpress.org/dist/canvasXpress.css;https://www.canvasxpress.org/dist/canvasXpress.min.js";var i='{"title": "'+(a.title||"CanvasXpress")+'", "html": "'+m+'" js: "'+d+'" js_external: "'+g+'"}';i='{"title": "CanvasXpress", "html": "'+m.replace(/"/g,"'")+'", "js": "'+d.replace(/"/g,"'")+'", "js_external": "'+g.replace(/"/g,"'")+'"}';var c=a.$cX("form",{id:"submitToCodePen",method:"post",action:"https://codepen.io/pen/define",target:"_blank"},{display:"none"});document.body.appendChild(c);var l=a.$cX("input",{type:"hidden",name:"data",value:i});var h=a.$cX("button",{type:"submit"});c.appendChild(l);c.appendChild(h);h.click();document.body.appendChild(c)}}}(this);this.HU=function(){this.sk();var e=CanvasXpress.stack[this.target];var b=e.afterRender;var c=[];for(var d=0;d<b.length;d++){if(b[d][0].match(/^sort/)){c.push(this.gg(b[d]))}}return this.Zy({renderTo:e.renderTo,data:this.data,config:this.PF(),afterRender:c,factory:e.factory,system:e.system,version:e.version})};this.Ss=function(a){return function(j,i,d,g){var k=window;var c=a.$w;if(a.$pX()){k[c(29)](c(5));return}a.Hu();var l=i?i+".json":a.saveFilename?a.saveFilename+".json":"cX-"+a.target+".json";l=l.replace(/.json.json$/,".json");CanvasXpress.stack[a.target].factory=CanvasXpress.factory;CanvasXpress.stack[a.target].system=CanvasXpress.system;var h;if(d){h=a.Zy({config:CanvasXpress.stack[a.target].config,afterRender:CanvasXpress.stack[a.target].afterRender||[]})}else{if(g||(j&&(j.ctrlKey||j.altKey))){h=a.HU()}else{h=a.Zy(a.SM(a.Fe(CanvasXpress.stack[a.target])))}}var b=new Blob([h],{type:"text/plain"});a.r8(b,l)}}(this);this.pd=function(a){return function(k,i){var g=a.$pX();var c=a.$w;if(g){CanvasXpress.stack[a.target].config[c(0)]=g}a.Hu();CanvasXpress.stack[a.target].factory=CanvasXpress.factory;CanvasXpress.stack[a.target].system=CanvasXpress.system;a.isSVG=true;var l=a.showTransition;var d=a.SM(a.Fe(CanvasXpress.stack[a.target]));if(g){d.data=a[c(9)](a.dV(d.data))}d=a.isReproducibleResearch?a.dV(d):"";a.showTransition=false;a.meta.canvas.SVG=new a.mG({width:a.width,height:a.height,desc:d});a.meta.canvas.SVG.render=function(){var n=this.o.length;for(var r=0;r<n;r++){var u=this.o[r];var p=u.funcs;for(var q in u){if(q!=="funcs"){this[q]=u[q]}}if(p){var t=p.length;for(var q=0;q<t;q++){var s=p[q];var e=s[0];if(this[e]){this[e].apply(this,s[1])}}}}};a.meta.canvas.SVG.resetRender=function(){this.o=[]};a.meta.canvas.SVG.resetContext=function(){this.direction="ltr";this.fillStyle="#000000";this.filter="none";this.font="10px sans-serif";this.fontKerning="auto";this.fontStretch="normal";this.fontVariantCaps="normal";this.globalAlpha=1;this.globalCompositeOperation="source-over";this.imageSmoothingEnabled=true;this.imageSmoothingQuality="low";this.letterSpacing="0px";this.lineCap="butt";this.lineDashOffset=0;this.lineJoin="miter";this.lineWidth=1;this.miterLimit=10;this.shadowBlur=0;this.shadowColor="rgba(0, 0, 0, 0)";this.shadowOffsetX=0;this.shadowOffsetY=0;this.strokeStyle="#000000";this.textAlign="start";this.textBaseline="alphabetic";this.textRendering="auto";this.wordSpacing="0px"};a.KM(true);var h=a.meta.canvas.SVG.getSerializedSvg();if(a.isReproducibleResearch){a.oG(100,100,"<h2>Please be aware <br>the actual data is stored<br>inside the downloaded image</h2>",5000)}var m=i?i+".svg":a.saveFilename?a.saveFilename+".svg":"cX-"+a.target+".svg";m=m.replace(/.svg.svg$/,".svg");var b=new Blob([h],{type:"image/svg+xml"});a.r8(b,m);a.showTransition=l;delete (a.meta.canvas.SVG);a.isSVG=false}}(this);this.mn=function(c){var e="";var b=new Uint8Array(c);var a=b.byteLength;for(var d=0;d<a;d++){e+=String.fromCharCode(b[d])}return window.btoa(e)};this.EA=function(c){var d=window.atob(c);var a=d.length;var b=new Uint8Array(a);for(var e=0;e<a;e++){b[e]=d.charCodeAt(e)}return b.buffer};this.qo=function(){if(this.useLeaflet){var b=this.$("leaflet-"+this.target);if(b){var a=this.meta.canvas.ctx.canvas;var h=this.$cX("canvas",{width:this.width,height:this.height});var c=h.getContext("2d");var e=b.getElementsByTagName("img");for(var d=0;d<e.length;d++){var f=e[d];var j=f._leaflet_pos.x;var g=f._leaflet_pos.y;c.Np(f,j,g,256,256)}c.Np(a,0,0,this.width,this.height);return h}}};this.OX=function(b){return function(c,e,a){try{CanvasXpress}catch(N){c.preventDefault();c.stopPropagation();return false}var L=window;var I=b.width;var H=b.height;var y=b.printMagnification;var G=b.autoScaleFont;var E=b.showTransition;var B=b.skipStack;var A=["outlineWidth","lineThickness","xAxisGridMajorWidth","yAxisGridMajorWidth","zAxisGridMajorWidth","xAxisGridMinorWidth","yAxisGridMinorWidth","zAxisGridMinorWidth","xAxisLineLeftWidth","xAxisLineRightWidth","yAxisLineTopWidth","yAxisLineBottomWidth","guidesWidth","boxplotMedianWidth","boxplotConnectWidth","treeLinkWidth","connectByWidth","histogramBarWidth","heatmapCellBoxWidth","heatmapCellBoxHighlightWidth","edgeThickness","maxTextSize","treemapBorderWidth","errorBarsThickness","ganttDependencyThickness"];if(!CanvasXpress.stack.hasOwnProperty(b.target)){b=CanvasXpress.getObject(CanvasXpress.current.replace("-events",""))}var D=function(d){if(d&&y!=1){for(var f=0;f<A.length;f++){b[A[f]]/=y}b.autoScaleFont=G;b.showTransition=E;b.ym(I,H,true);b.skipStack=B}else{if(y!=1){b.skipStack=true;b.showTransition=false;for(var f=0;f<A.length;f++){b[A[f]]*=y}b.autoScaleFont=true;b.ym(I*y,H*y,true)}}};var O=function(){var i;var h=[];for(var d=0;d<256;d++){i=d;for(var g=0;g<8;g++){i=((i&1)?(3988292384^(i>>>1)):(i>>>1))}h[d]=i}return h};var M=function(i){var h=L.crcTable||(L.crcTable=O());var d=0^(-1);for(var g=0;g<i.length;g++){d=(d>>>8)^h[(d^i.charCodeAt(g))&255]}return(d^(-1))>>>0};var J=function(g,h){var d=new Uint8Array(g.byteLength+h.byteLength);d.set(new Uint8Array(g),0);d.set(new Uint8Array(h),g.byteLength);return d.buffer};var F=function(g){var l="tEXt";var h=g.length;var d=M(l+g);var k=new ArrayBuffer(12+h);var i=new DataView(k);i.setUint32(0,h);for(var j=0;j<l.length;j++){i.setUint8(4+j,l.charCodeAt(j))}for(var j=0;j<g.length;j++){i.setUint8(8+j,g.charCodeAt(j))}i.setUint32(4+4+h,d);return k};var K=function(){var h=false;var i=b.$pX();var g=b.$w;if(i){CanvasXpress.stack[b.target].config[g(0)]=i}if(b.isReproducibleResearch){if(b.printMagnification!=1){delete (CanvasXpress.stack[b.target].config.showTransition)}if(c&&(c.ctrlKey||c.altKey)){h=b.HU()}else{h=b.SM(b.Fe(CanvasXpress.stack[b.target]));if(i){h.data=b[g(9)](b.dV(h.data))}}h=b.dV(h)}else{var d=b.parseJSON(c.ctrlKey||c.altKey?b.HU():b.dV(CanvasXpress.stack[b.target]));d.afterRender=[d.afterRender[0]];h=b.dV(d)}return encodeURIComponent(h)};var P=function(h,j,i,g){var d=J(h,j);d=J(d,i);d=J(d,g);return d};var z=function(h){var d=new FileReader();var g="";if(b.isReproducibleResearch){g+="<h2>Please be aware that the actual data is stored inside the image! Right click to save!</h2>"}else{g+="<h2>Right click to save image</h2>"}d.onload=function(f){g+="<img width="+b.width+" height="+b.height+" src= '"+f.target.result+"'/>";b.Wf(c,g,b.Jq(c),{maxWidth:b.width+"px",whiteSpace:"normal"},40,40)};d.readAsDataURL(h)};D();b.Hu();CanvasXpress.stack[b.target].factory=CanvasXpress.factory;CanvasXpress.stack[b.target].system=CanvasXpress.system;if(!CanvasXpress.factory.valid){b.$$$("CanvasXpress")}var C=b.useLeaflet?b.qo():b.meta.canvas.ctx.canvas;C.toBlob(function(g){var h=new FileReader();var d=e?e+".png":b.saveFilename?b.saveFilename+".png":"cX-"+b.target+".png";d=d.replace(/.png.png$/,".png");h.onloadend=function(){var m=new DataView(this.result);var k=m.getUint32(8);var j=8+4+4+k+4;var i=this.result.slice(0,j);var f=this.result.slice(j);var n=F("Software\0CanvasXpress Version: "+CanvasXpress.factory.version);var p=F("ReproducibleResearch\0"+K());var o=P(i,n,p,f);var l=new Blob([o],{type:"image/png"});b.meta.base64=b.mn(o);if(a){a(l,d)}else{if(b.printType=="download"){if(b.isReproducibleResearch){b.oG(100,100,"<h2>Please be aware <br>the actual data is stored<br>inside the downloaded image</h2>",5000)}b.r8(l,d)}else{z(l)}}D(true)};h.readAsArrayBuffer(g)},"image/png");if(b.customizing){}else{if(b.maximized){b.AD(c)}}}}(this);this.NN=function(a){return function(f){var b=a.meta.canvas.ctx;a.meta.canvas.ctx=new this.mG({width:a.width,height:a.height});a.dG({func:"exportToSVG",par:[f]});var c=a.jR(a.meta.canvas.ctx.getSerializedSvg());var d=window.open("",a.target+"-SVG");d.document.write(c);a.meta.canvas.ctx=b;a.dG({func:"exportToSVG",par:[f]});return false}}(this);this.fK=function(a){return this.aL(a)};this.Oq=function(e,b){var c="<table>";for(var a=0;a<e.length;a++){c+="<tr><td>";c+=e[a].join("</td><td>");c+="</td></tr>"}c+="</table>";return b?c:window.open().document.write(c)};this.aL=function(e){var c="";for(var a=0;a<e.length;a++){c+=e[a].join("\t")+"\n"}var b=this.$(this.target+"-cX-linkTab");if(!b){b=this.$cX("a",{id:this.target+"-cX-linkTab"},{display:"none"});window.document.body.appendChild(b)}b.download=this.target+".tsv";b.href="data:text/tab-separated-values;charset=UTF-8,"+encodeURIComponent(c);b.click()};this.EL=function(e){var c="";if(e[0].length){c+='<div class="CanvasXpressDataTableContainer" style="overflow:scroll;max-height:400px;max-width:600px;position:inherit;padding-left:18px;">';c+='<table class="CanvasXpressDataTable" style="position:inherit;">';c+="<tbody>";c+="<tr>";for(var b=0;b<e[0][0].length;b++){c+='<th class="CanvasXpressTableCellHead" style="height:18px">';c+='<div class="CanvasXpressTableCell" style="height:18px">';c+=e[0][0][b];c+="</div>";c+="</th>"}c+="</tr>";for(var b=1;b<e[0].length;b++){c+="<tr>";for(var a=0;a<e[0][b].length;a++){if(a==0){c+='<th class="CanvasXpressTableCellHead" style="height:18px">';c+='<div class="CanvasXpressTableCell" style="height:18px">';c+=e[0][b][a];c+="</div>";c+="</th>"}else{if(e[2]&&e[2][b]&&e[2][b][a]){c+='<td class="CanvasXpressTableCell" style="height:18px;background-color:'+e[2][b][a]+'">'}else{c+='<td class="CanvasXpressTableCell" style="height:18px">'}c+='<div class="CanvasXpressTableCell" style="height:18px">';c+=e[0][b][a];c+="</div>";c+="</td>"}}c+="</tr>"}c+="</tbody>";c+="</table>";c+="</div>"}return c};this.xG=function(g){var h=[];var b=g.split(/\n(?=(?:(?:[^"]*"){2})*[^"]*$)/);var c=["header","quote","row.names","fill","check.names","stringsAsFactors"];var f=false;for(var e=0;e<b.length;e++){var a=b[e];if(a.match(/library\(canvasXpress\)/)){h.push(a.replace("library(canvasXpress)",'library(<span class="cX-code-value">canvasXpress</span>)'))}else{if(a.match(/canvasXpress\(/)){h.push(a.replace("canvasXpress(",'<span class="cX-code-value">canvasXpress</span>('));f=true}else{if(a.match(/\"http.+\"/)){a=a.replace(/(\"http.+?\")/,'<span class="cX-code-string">$1</span>');for(var d=0;d<c.length;d++){a=a.replace(c[d],'<span class="cX-code-key">'+c[d]+"</span>")}a=a.replace('""','<span class="cX-code-string">""</span>,');a=a.replace(/\"\t\"/,'<span class="cX-code-string">"&#92;t"</span>');a=a.replace("=1,",'=<span class="cX-code-number">1</span>,');a=a.replace(/FALSE/g,'<span class="cX-code-boolean">FALSE</span>');a=a.replace(/TRUE/g,'<span class="cX-code-boolean">TRUE</span>');h.push(a)}else{if(f){if(a.match(/\".+?\"/)){a=a.replace(/(\".+?\")/g,'<span class="cX-code-string">$1</span>')}else{if(a.match(/[^xis][\d\.]+/)){a=a.replace(/([\d\.]+)/,'<span class="cX-code-number">$1</span>')}}a=a.replace(/\n/,"&#92;n");a=a.replace(/(\w+)?=/,'<span class="cX-code-key">$1=</span>');a=a.replace(/FALSE/g,'<span class="cX-code-boolean">FALSE</span>');a=a.replace(/TRUE/g,'<span class="cX-code-boolean">TRUE</span>')}h.push(a)}}}}return'<pre class="cX-code-content">\n<code>'+h.join("</code>\n<code>")+"</code>\n</pre>"};this.Mr=function(e,d,f,b){var a=this.dV(e,d?d:null,2);if(a.length>10000){f=false}if(f){a=a.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}a=a.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,function(g){var c="number";if(/^"/.test(g)){if(/:$/.test(g)){g=g.replace(":"," =");c="key"}else{c="string"}}else{if(/true|false/.test(g)){g=g.replace("false","FALSE").replace("true","TRUE");c="boolean"}else{if(/null/.test(g)){g=g.replace("null","NULL");c="null"}}}return f?('<span class="cX-code-'+c+'">'+g+"</span>"):g});if(b){return a.replace(/\[/g,"list(").replace(/]/g,")").replace(/{/g,"list(").replace(/}/g,")").replace(/^list\(\n/,"").replace(/\)$/,"")}else{return a.replace(/\[/g,"list(").replace(/]/g,")").replace(/{/g,"list(").replace(/}/g,")").replace(/^list\(\n/,"").replace(/\)$/,"")}};this.iB=function(){if(this.$p()){return this.$w(1)}var g=[];var m=[];var n,b,q,a,o,h;var k="";var f=CanvasXpress.stack[this.target].data;var p="<span class=cX-code-value>canvasXpress</span>(\n";if(this.meta.config.remote&&!this.Ov(this.meta.config.remote.data)){if(this.meta.config.remote.data===false){k+="data = FALSE\n"}else{k+='data = "'+this.meta.config.remote.data+'"\n'}p+="  <span class=cX-code-key>data</span> = data,\n"}else{if(this.graphType=="Map"&&!this.Ov(this.meta.config.remote.data)){k+="";p+="  <span class=cX-code-key>data</span> = <span class=cX-code-value>FALSE</span>,\n"}else{if(f.y){g=[];for(var e=0;e<f.y.vars.length;e++){var l=[];for(var d=0;d<f.y.smps.length;d++){l.push(f.y.data[e][d]!=null?f.y.data[e][d]:"NA")}g.push("<span class=cX-code-number>"+l.join("</span>,<span class=cX-code-number>")+"</span>,")}g[g.length-1]=g[g.length-1].replace(/,$/,"");b="vals = c("+g.join("\n")+")\n";q='vars = c(<span class=cX-code-string>"'+f.y.vars.join('"</span>,\n<span class=cX-code-string>"')+'"</span>)\n';a='smps = c(<span class=cX-code-string>"'+f.y.smps.join('"</span>,\n<span class=cX-code-string>"')+'"</span>)\n';o="data = as.data.frame(matrix(vals, <span class=cX-code-key>nrow</span> = <span class=cX-code-number>"+f.y.vars.length+"</span>, <span class=cX-code-key>ncol</span> = <span class=cX-code-number>"+f.y.smps.length+"</span>, <span class=cX-code-key>byrow</span> = <span class=cX-code-boolean>TRUE</span>, <span class=cX-code-key>dimnames</span> = list(vars, smps)))\n";k+=b+q+a+o;p+="  <span class=cX-code-key>data</span> = data,\n"}if(f.x){g=[];m=[];b="";for(var e in f.x){var c=this.meta.data.x&&this.meta.data.x[e]?this.meta.data.x[e].type:this.meta.data.z&&this.meta.data.z[e]?this.meta.data.z[e].type:"fail";if(c=="Numeric"){g.push("<span class=cX-code-number>"+f.x[e].join("</span>,\n<span class=cX-code-number>")+"</span>,")}else{g.push('<span class=cX-code-string>"'+f.x[e].join('"</span>,\n<span class=cX-code-string>"')+'"</span>,')}m.push(e)}g[g.length-1]=g[g.length-1].replace(/,$/,"");b="valx = c("+g.join("\n ")+")\n";if(this.graphType=="Tree"){b=b.replace(/\"\"/g,"NA")}q='varx = c(<span class=cX-code-string>"'+m.join('"</span>,<span class=cX-code-string>"')+'"</span>)\n';o="datx = as.data.frame(matrix(valx, <span class=cX-code-key>nrow</span> = <span class=cX-code-number>"+m.length+"</span>, <span class=cX-code-key>ncol</span> = <span class=cX-code-number>"+f.y.smps.length+"</span>, <span class=cX-code-key>byrow</span> = <span class=cX-code-boolean>TRUE</span>, <span class=cX-code-key>dimnames</span> = list(varx, smps)))\n";k+=b+q+o;p+="  <span class=cX-code-key>smpAnnot</span> = datx,\n"}if(f.z){g=[];m=[];b="";for(var e in f.z){var c=this.meta.data.z&&this.meta.data.z[e]?this.meta.data.z[e].type:this.meta.data.x&&this.meta.data.x[e]?this.meta.data.x[e].type:"fail";if(c=="Numeric"){g.push("<span class=cX-code-number>"+f.z[e].join("</span>,\n<span class=cX-code-number>")+"</span>,")}else{g.push('<span class=cX-code-string>"'+f.z[e].join('"</span>,\n<span class=cX-code-string>"')+'"</span>,')}m.push(e)}g[g.length-1]=g[g.length-1].replace(/,$/,"");b="valz = c("+g.join("\n ")+")\n";a='smpz = c(<span class=cX-code-string>"'+m.join('"</span>,<span class=cX-code-string>"')+'"</span>)\n';o="datz = as.data.frame(matrix(valz, <span class=cX-code-key>nrow</span> = <span class=cX-code-number>"+f.y.vars.length+"</span>, <span class=cX-code-key>ncol</span> = <span class=cX-code-number>"+m.length+"</span>, <span class=cX-code-key>byrow</span> = <span class=cX-code-boolean>FALSE</span>, <span class=cX-code-key>dimnames</span> = list(vars, smpz)))\n";k+=b+a+o;p+="  <span class=cX-code-key>varAnnot</span> = datz,\n"}if(f.nodes){k+="nodes = list(\n"+this.Mr(f.nodes,function(j,i){if(j!="layout"){return i}},false,true)+")\n";p+='  <span class=cX-code-key>"nodeData"</span> = nodes,\n'}if(f.edges){k+="edges = list(\n"+this.Mr(f.edges,false,false,true)+")\n";p+='  <span class=cX-code-key>"edgeData"</span> = edges,\n'}if(f.groups){k+="groups = list(\n"+this.Mr(f.groups,false,false,true)+")\n";p+='  <span class=cX-code-key>"groupData"</span> = groups,\n'}if(f.constraints){k+="constraints = list(\n"+this.Mr(f.constraints,false,false,true)+")\n";p+='  <span class=cX-code-key>"constraintData"</span> = constraints,\n'}if(f.venn){k+="venn = data.frame(\n"+this.Mr(f.venn.data,false,true)+")\n";p+="  <span class=cX-code-key>vennData</span> = venn,\n";if(f.venn.legend){k+="legn = data.frame(\n"+this.Mr(f.venn.legend,false,true)+")\n";p+="  <span class=cX-code-key>vennLegend</span> = legn,\n"}}if(f.tracks){p+="  <span class=cX-code-key>tracks</span> = genome,\n";k+="genome = list(\n"+this.Mr(f.tracks,false,true)+")\n"}}}n=this.meta.config.remote?this.lB(this.meta.config.remote.config):this.lB(CanvasXpress.stack[this.target].config);if(CanvasXpress.stack[this.target].afterRender&&CanvasXpress.stack[this.target].afterRender.length>1){n.afterRender=this.gg(CanvasXpress.stack[this.target].afterRender)}p+=this.Mr(n,false,true)+")";h="library(<span class=cX-code-value>canvasXpress</span>)\n"+k+p;return"<code>"+h.replace(/\n/g,"</code>\n<code>")+"</code>"};this.Zy=function(d,b,e,a){return e&&d?this.mO(d,b):d?this.dV(d,b,a||2):false};this.mO=function(c,b){if(c){var a=this.dV(c,b?b:null,2);if(a.length>10000){return a}else{a=a.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}a=a.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,function(e){var d="number";if(/^"/.test(e)){if(/:$/.test(e)){d="key"}else{d="string"}}else{if(/true|false/.test(e)){d="boolean"}else{if(/null/.test(e)){d="null"}}}return'<span class="cX-code-'+d+'">'+e+"</span>"});return a}else{return false}};this.oS=function(g,e){var d=function(h){return h.replace(/"/g,"&quot;").replace(/^\s*/g,"").replace(/'\s*\+\s*'/g,"' + '").replace(/'\s*\+\s*Math/g,"' + Math").replace(/\*/g," * ").replace(/\)\//g,") / ").replace(/<(.+?)>/g,"&lt;$1&gt;")};g=g.replace(/{/g,"{\n").replace(/}/g,"\n}");var b=g.split(/\n/);var a=[d(b[0])];var f="  ";if(!e){e=""}for(var c=1;c<b.length;c++){b[c]=d(b[c]);if(b[c].match(/[\w{}]/)){if(b[c].match(/}\s*else\s*\{\s*$/)){f=f.replace("  ","");a.push(e+f+b[c]);f+="  "}else{if(b[c].match(/\{\s*$/)){a.push(e+f+b[c]);f+="  "}else{if(b[c].match(/\}\s*;*\s*$/)){f=f.replace("  ","");a.push(e+f+b[c])}else{a.push(e+f+b[c])}}}}}return a.join("\n")};this.ph=function(d,a){var c="{\n";if(!a){a="  "}for(var b in d){c+=a+'"'+b+'": '+d[b]+",\n"}a=a.replace("  ","");return c.replace(/,\n$/,"\n")+a+"}"};this.jR=function(n){var f=/(>)\s*(<)(\/*)/g;var t=/ *(.*) +\n/g;var e=/(<.+>)(.+\n)/g;var d=n.replace(f,"$1\n$2$3").replace(t,"$1\n").replace(e,"$1\n$2");var r=0;var b="";var a=d.split("\n");var k=0;var q="other";var v={"single->single":0,"single->closing":-1,"single->opening":0,"single->other":0,"closing->single":0,"closing->closing":-1,"closing->opening":0,"closing->other":0,"opening->single":1,"opening->closing":0,"opening->opening":1,"opening->other":1,"other->single":0,"other->closing":-1,"other->opening":0,"other->other":0};for(var p=0;p<a.length;p++){var h=a[p];var u=Boolean(h.match(/<.+\/>/));var g=Boolean(h.match(/<\/.+>/));var m=Boolean(h.match(/<[^!].*>/));var c=u?"single":g?"closing":m?"opening":"other";var s=q+"->"+c;q=c;var l="";k+=v[s];for(var o=0;o<k;o++){l+="  "}b+=l+h+"\n"}return b};this.j4=function(d,h,b){if(this.$p()){return this.$w(1)}var a=h?"  ":b?"        ":"    ";var c=this.Wu(true).replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None");var g=this.aH(true).replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None");var f=this.oB(true);var e=this.HW(true);var i="";if(h){i+="<span class=cX-code-key>import</span> streamlit <span class=cX-code-key>as</span> st\n\n"}else{if(b){i+="<span class=cX-code-key>from</span> shiny <span class=cX-code-key>import</span> App, ui, render, reactive\n\n"}}i+="<span class=cX-code-key>from</span> canvasxpress.canvas <span class=cX-code-key>import</span> CanvasXpress\n";if(d||h||b){i+="<span class=cX-code-key>from</span> canvasxpress.plot <span class=cX-code-key>import</span> graph\n\n"}else{i+="<span class=cX-code-key>from</span> canvasxpress.plot <span class=cX-code-key>import</span> show_in_browser\n\n"}if(d){i+="graph(\n";i+="  CanvasXpress(\n";i+="    data = "+c+",\n";i+="    config = "+g+",\n";if(f){i+="    events = "+f.replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}if(e){i+="    after_render = "+e.replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}i+="    width = <span class=cX-code-number>"+this.width+"</span>,\n";i+="    height = <span class=cX-code-number>"+this.height+"</span>\n";i+="  )\n";i+=")\n\n"}else{if(h){i+="chord_chart = CanvasXpress(\n";i+="  config = "+g+",\n";if(f){i+="  events = "+f.replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}if(e){i+="  after_render = "+e.replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}i+="  width = <span class=cX-code-number>"+this.width+"</span>,\n";i+="  height = <span class=cX-code-number>"+this.height+"</span>\n";i+=")\n\n";i+="<span class=cX-code-comment># Write the UI to the browser</span>\n";i+="<span class=cX-code-comment># This code will be re-executed with each click of the button</span>\n\n";i+="<span class=cX-code-comment># Name the theme</span>\n";i+='st.title(<span class=cX-code-key>"CanvasXpress in Streamlit!"</span>)\n\n';i+="<span class=cX-code-comment># Some columns to organize the button and chart</span>\n";i+="column1, column2 = st.columns(2)\n\n";i+="<span class=cX-code-comment># A column with our data generator button</span>\n";i+="column1.write(\n";i+="  <span class=cX-code-comment># This has no associated action, so by default</span>\n";i+="  <span class=cX-code-comment># it triggers a redraw of the UI.</span>\n";i+='  st.button(<span class=cX-code-key>"Generate New Data"</span>)\n';i+=")\n\n";i+="<span class=cX-code-comment># Another column with the chart displayed</span>\n";i+="<span class=cX-code-comment># With each redraw generate new random values</span>\n";c=c.replace(/\n  /g,"\n");i+="chord_chart.data = "+c+"\n";i+="column2.write(\n";i+="  <span class=cX-code-comment># This plots the CanvasXpress chart into the UI.</span>\n";i+="  graph(chord_chart)\n";i+=")\n\n";i+="<span class=cX-code-comment># On the command line, execute:</span>\n";i+="<span class=cX-code-comment># </span>\n";i+="<span class=cX-code-comment># </span>   streamlit run app.py\n";i+="<span class=cX-code-comment># </span>\n";i+="<span class=cX-code-comment># And output similar to the following will be provided:</span>\n";i+="<span class=cX-code-comment># </span>\n";i+="<span class=cX-code-comment># </span>   Running on http://localhost:8501/ (Press CTRL+C to quit)\n"}else{if(b){i+="app_ui = ui.page_fluid(\n";i+="  ui.row(\n";i+="    <span class=cX-code-comment># Define widgets here - for example:</span>\n";i+="    ui.input_slider(\n";i+='      <span class=cX-code-key>"points_desired"</span>,\n';i+='      <span class=cX-code-key>"Points"</span>,\n';i+="      min = <span class=cX-code-number>"+this.minData+"</span>,\n";i+="      max = <span class=cX-code-number>"+this.maxData+"</span>,\n";i+="      value = <span class=cX-code-number>"+this.minData+"</span>\n";i+="    )\n";i+="  )\n";i+="  ui.row(\n";i+='    ui.output_ui(<span class=cX-code-key>"chart_view"</span>),\n';i+="  )\n";i+=")\n\n";i+="def server(input, output, session):\n";i+="  @render.ui\n";i+="  @reactive.event(input.points_desired)\n";i+="  def chart_view():\n";i+="    return graph(\n";i+="      CanvasXpress(\n";i+="        data = "+c+",\n";i+="        config = "+g+",\n";if(f){i+="        events = "+f.replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}if(e){i+="        after_render = "+e.replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}i+="        width = <span class=cX-code-number>"+this.width+"</span>,\n";i+="        height = <span class=cX-code-number>"+this.height+"</span>\n";i+="    )\n";i+="  )\n\n";i+="app = App(app_ui, server)\n\n";i+="<span class=cX-code-comment># On the command line, execute:</span>\n";i+="<span class=cX-code-comment># </span>\n";i+="<span class=cX-code-comment># </span>   shiny run --reload --launch-browser app.py\n";i+="<span class=cX-code-comment># </span>\n";i+="<span class=cX-code-comment># And output similar to the following will be provided:</span>\n";i+="<span class=cX-code-comment># </span>\n";i+="<span class=cX-code-comment># </span>   Uvicorn running on http://127.0.0.1:8000 (Press CTRL+C to quit)\n"}else{i+='<span class=cX-code-key>if</span> __name__ == <span class=cX-code-key>"__main__"</span>:\n';i+="  <span class=cX-code-comment># Define a CX bar chart with some basic data</span>\n";i+="  chart: CanvasXpress = CanvasXpress(\n";i+="    render_to = "+this.target+",\n";i+="    data = "+c+",\n";i+="    config = "+g+",\n";if(f){i+="    events = "+f.replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}if(e){i+="    after_render = "+e.replace(/\n/g,"\n"+a).replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}i+="    width = <span class=cX-code-number>"+this.width+"</span>,\n";i+="    height = <span class=cX-code-number>"+this.height+"</span>\n";i+="  )\n\n";i+="  <span class=cX-code-comment># Display the chart in its own Web page</span>\n";i+="  show_in_browser(chart)\n"}}}return"<code>"+i.replace(/\n/g,"</code>\n<code>")+"</code>"};this.H1=function(){if(this.$p()){return this.$w(1)}var k=JSON.parse(this.meta.config.user.cxplot);var l=JSON.stringify(k.data).replace(/\],/g,"],\n  ");var c=this.eO(k.geoms)?k.geoms:[k.geoms];var a={};var h="";if(k.aes&&k.order){k.aes.meta={};Object.assign(k.aes.meta,k.order);if(!k.aes.hasOwnProperty("x")){for(var b=0;b<c.length;b++){var d=c[b];if(k.layers[d]&&k.layers[d].hasOwnProperty("x")){k.aes.x=k.layers[d].x;break}}}if(!k.aes.hasOwnProperty("y")){for(var b=0;b<c.length;b++){var d=c[b];if(k.layers[d]&&k.layers[d].hasOwnProperty("y")){k.aes.y=k.layers[d].y;break}}}}var m=JSON.stringify(k.aes);var j=["labels","scales","colors","coordinates","theme","facet","config"];h+="<span class=cX-code-key>var</span> data = "+l+";\n\n";h+='<span class=cX-code-key>var</span> cxp = <span class=cX-code-value>new</span> cxplot("canvas", data, aes('+m+"));\n";for(var b=0;b<c.length;b++){var d=a[c[b]]?c[b]+"."+a[c[b]]:c[b];var e=c[b].toLowerCase().replace("geom","geom_").replace("2","_2").replace("filled","_filled").replace("_qql","_qq_l").replace("ridgesgradient","ridges_gradient").replace("ridges","_ridges");if(this[e]&&!this.skipGeoms){h+="cxp.<span class=cX-code-key>"+e+"</span>("+JSON.stringify(k.layers[d])+");\n"}a[d]=a[d]?a[d]+1:1}for(var b=0;b<j.length;b++){if(k[j[b]]){var e="gg_"+j[b];if(this.eO(k[j[b]])){if(k[j[b]].length>0){h+="cxp.<span class=cX-code-key>"+e+"</span>("+JSON.stringify(k[j[b]])+");\n"}}else{h+="cxp.<span class=cX-code-key>"+e+"</span>("+JSON.stringify(k[j[b]])+");\n"}}}return"<code>"+h.replace(/\n/g,"</code>\n<code>")+"</code>"};this.yq=function(g,f){var a=[["Id"]];for(var e=0;e<this.data.y.vars.length;e++){a[e+1]=[];a[e+1][0]=this.data.y.vars[e]}for(var e=0;e<this.data.y.smps.length;e++){a[0][e+1]=this.data.y.smps[e];for(var d=0;d<this.data.y.vars.length;d++){a[d+1][e+1]=this.data.y.data[d][e]}}if(g&&this.data[g]){if(g=="x"){for(var e in this.data.x){var b=a.length;a[b]=[];a[b][0]=e;for(var d=0;d<this.data.y.smps.length;d++){a[b][d+1]=this.data.x[e][d]}}}else{if(g=="z"){for(var e in this.data.z){var b=a[0].length;a[0][b]=e;for(var d=0;d<this.data.y.vars.length;d++){a[d+1][b]=this.data.z[e][d]}}}}}return f?this.l4(a):a};this.JQ=function(d){if(d){var g={};for(var e=0;e<this.data.y.vars.length;e++){g[this.data.y.vars[e]]=e}var c=0;for(var e=0;e<d.data.y.vars.length;e++){if(g.hasOwnProperty(d.data.y.vars[e])){c++}}var f=0;for(var e=0;e<d.data.y.smps.length;e++){if(g.hasOwnProperty(d.data.y.smps[e])){f++}}if(c>0||f>0){if(c>f){}else{for(var e=0;e<d.data.y.vars.length;e++){this.data.z[d.data.y.vars[e]]=[];for(var b=0;b<d.data.y.smps.length;b++){if(g.hasOwnProperty(d.data.y.smps[b])){var a=g[d.data.y.smps[b]];this.data.z[d.data.y.vars[e]][a]=d.data.y.data[e][b]}}}if(d.data.hasOwnProperty("x")){for(var e in d.data.x){this.data.z[e]=[];for(var b=0;b<d.data.y.smps.length;b++){if(g.hasOwnProperty(d.data.y.smps[b])){var a=g[d.data.y.smps[b]];this.data.z[e][a]=d.data.x[e][b]}}}}}this.colorBy=d.data.y.vars[0];this.af("z",false,false,true);return true}}return false};this.gJ=function(a,b){if(this.varIndices.length&&this.smpIndices.length){var g=this;var B=function(i){if(i=="s"){return{y:{smps:g.gg(g.data.y.smps)},x:{}}}else{return{y:{vars:g.gg(g.data.y.vars)},z:{}}}};var C={};if(b&&this.data.z&&this.data.z.hasOwnProperty("cXId")){for(var x=0;x<this.data.z.cXId.length;x++){C[this.data.z.cXId[x]]=x}}var k={s:[],v:[]};var l={s:[],v:[]};var s;var v=2;var r=false;for(var x=1;x<a.length;x++){s=this.u4(a[x][0]);if(s>-1){k.s.push([x,s]);continue}s=b&&C.hasOwnProperty(a[x][0])?C[a[x][0]]:this.FP(a[x][0]);if(s>-1){k.v.push([x,s]);continue}}for(var x=1;x<a[0].length;x++){s=b&&C.hasOwnProperty(a[x][0])?C[a[x][0]]:this.FP(a[0][x]);if(s>-1){l.v.push([x,s]);continue}s=this.u4(a[0][x]);if(s>-1){l.s.push([x,s]);continue}}var h=k.s.length>v?k.s.length:0;var f=k.v.length>v?k.v.length:0;var e=l.s.length>v?l.s.length:0;var d=l.v.length>v?l.v.length:0;var z=this.data.y.smps.length;var A=this.data.y.vars.length;if(h||f||e||d){var t=0;if(h==z&&d==A){var D=[];for(var x=0;x<l.v.length;x++){var o=l.v[x][0];var c=l.v[x][1];D[c]=[];for(var w=0;w<k.s.length;w++){var y=k.s[w][0];var q=k.s[w][1];D[c][q]=a[y][o];t++}}r=true}else{if(e==z&&f==A){var D=[];for(var x=0;x<k.v.length;x++){var o=k.v[x][0];var c=k.v[x][1];D[c]=[];for(var w=0;w<l.s.length;w++){var y=l.s[w][0];var q=l.s[w][1];D[c][q]=a[o][y];t++}}r=true}else{if(h>=f&&h>=e&&h>=d){var D=B("s");for(var x=1;x<a[0].length;x++){D.x[a[0][x]]=[];var u=0;for(var w=0;w<k.s.length;w++){var y=k.s[w][0];var q=k.s[w][1];D.x[a[0][x]][q]=a[y][x];t++;u=a[y][x]?u+1:u}if(!u){delete D.x[a[0][x]]}}}else{if(f>=h&&f>=e&&f>=d){var D=B("v");for(var x=1;x<a[0].length;x++){D.z[a[0][x]]=[];var u=0;for(var w=0;w<k.v.length;w++){var y=k.v[w][0];var q=k.v[w][1];D.z[a[0][x]][q]=a[y][x];t++;u=a[y][x]?u+1:u}if(!u){delete D.z[a[0][x]]}}}else{if(e>h&&e>=f&&e>=d){var D=B("s");for(var x=0;x<l.s.length;x++){var o=l.s[x][0];var c=l.s[x][1];var u=0;for(var w=1;w<a.length;w++){if(x==0){D.x[a[w][0]]=[]}D.x[a[w][0]][c]=a[w][o];t++;u=a[w][o]?u+1:u}if(!u){delete D.x[a[w][0]]}}}else{if(d>h&&d>=f&&d>=e){var D=B("v");for(var x=0;x<k.s.length;x++){var o=k.s[x][0];var c=k.s[x][1];var u=0;for(var w=1;w<a.length;w++){if(x==0){D.z[a[w][0]]=[]}D.z[a[w][0]][c]=a[w][o];t++;u=a[w][o]?u+1:u}if(!u){delete D.z[a[w][0]]}}}}}}}}return{data:D,recs:t,addt:r}}else{if(b){var D=this.arrayToCX(a);this.data.x=D.data.x;this.data.y.smps=D.data.y.smps;this.data.y.vars=this.gg(this.data.z.id);this.oj(this.data);var p=this.meta.map.geojson.features;for(var x=0;x<p.length;x++){p[x].properties.key=this.data.y.vars[x];p[x].properties.varId=[x]}return{data:false,recs:this.data.y.smps.length,addt:false}}else{return a}}}return a};this.TC=function(){var b=function(c){return function(d){c.Rdatasets=c.parseJSON(d)}}(this);var a=this.RdatasetsURL+"datasets.json";this.M1(a,false,b)};this.H5=function(a){this.wz(this.RdatasetsURL+"json/"+a+"/datasets.json")};this.PK=function(){var f=this;var b=this.appendNetworkData.length>0?this.appendNetworkData.shift():false;var d=function(n){var l=function(z){var y={};var B=z[0];var r=0;var w=0;var u=0;var q={};var A=false;for(var x=1;x<z.length;x++){var s=z[x][0];var t=z[x][1];if(f.data.nodeIndices.hasOwnProperty(s)&&f.data.nodeIndices.hasOwnProperty(t)){w++}else{if(f.data.nodeIndices.hasOwnProperty(s)){r++}else{u++}}q[s]=x}if(!r&&!w){for(var x=0;x<f.data.nodes.length;x++){var s=f.data.nodes[x];if(s.hasOwnProperty("extId")&&q.hasOwnProperty(s.extId)){z[q[s.extId]][0]=s.id;r++}}}if(w>r){r=0;w=0;u=0;A="edge";for(var x=1;x<z.length;x++){var s=z[x][0];var t=z[x][1];if(f.data.nodeIndices.hasOwnProperty(s)&&f.data.nodeIndices.hasOwnProperty(t)){w++;y[s+":"+t]={};for(var v=2;v<B.length;v++){y[s+":"+t][B[v]]=z[x][v]}}else{u++}}}else{if(r>8){r=0;w=0;u=0;A="node";for(var x=1;x<z.length;x++){var s=z[x][0];if(f.data.nodeIndices.hasOwnProperty(s)){r++;y[s]={};for(var v=1;v<B.length;v++){y[s][B[v]]=z[x][v]}}else{u++}}}else{return z}}if((A=="edge"&&(w>5||w>=z.length-1))||(A=="node"&&(r>5||r>=z.length-1))){return{data:y,rows:Math.max(r,w),fail:u,type:A}}else{return z}};var o=l(f.parseDelimited(n));if(o&&!f.eO(o)){var k="";if(o.fail>0){k=o.fail+" records couldn't be mapped to network data"}f.oG(100,150,o.rows+" "+o.type+" records added to network data\n"+k,5000);var p=f.meta.config.user;var e=["colorNodeBy","shapeNodeBy","sizeNodeBy","patternNodeBy","colorEdgeBy","SizeEdgeBy","decorations"];for(var m=0;m<e.length;m++){var j=e[m];if(p.hasOwnProperty(j)){f[j]=p[j]}}if(o.type=="node"){f.LZ(o.data)}else{f.sy(o.data)}if(f.appendNetworkData.length>0){f.PK()}else{f.dG({func:"appendNetworkDataFromURL"});f.LC()}}};var c=function(e){if(e.type=="node"){f.LZ(e.data)}else{f.sy(e.data)}if(f.appendNetworkData.length>0){f.PK()}else{f.dG({func:"appendNetworkDataFromURL"});f.LC()}};var a=function(e){return function(i){if(b.match(/\.txt$/)||b.match(/\.csv$/)||b.match(/\.tsv$/)||b.match(/\.tab$/)){d(i)}else{e.LC();alert("Oooops! Not a CanvasXpress Network delimited file")}}}(this);if(b){if(typeof(b)=="string"){var g=null;try{g=JSON.parse(b);return c(g)}catch(h){g=null}g=this.parseDelimited(b)||null;if(g){return d(b)}if(this.isValidURL(b)){return this.M1(b,false,a)}}else{c(b)}}};this.wz=function(a){this.remoteService=a;this.M1(a,false,this.setDataSetsFromURL)};this.S9=function(a){return function(b){var g=function(i){return function(n){var p=f.parseJSON(n);f.uB({data:p,ids:f.remoteIds,records:f.remoteIds.length})}}(f);var o=function(){var i=a.$("container-"+a.target).parentNode;while(i.id.match("canvasXpressRemoteWindow")){i=i.parentNode}if(!i.id){i.id=a.PI("-cX-data-sets-url-container-")}return i.id};var h=a.parseJSON(b);var d=h[0][1];var c=[];for(var j=0;j<h.length;j++){c.push(h[j][0])}var k=o();var m=a.$("container-"+a.target).parentNode;var l=a.PI("-cX-data-sets-");var e=a.$cX("canvas",{id:l,width:a.originalWidth,height:a.originalHeight});a.Gf(e);m.appendChild(e);var f=new CanvasXpress(l,false,{remoteService:a.remoteService});a.remoteIds=c;a.WG(a.target);f.remoteData=h;f.remoteParentId=k;f.remoteIds=c;f.M1(d,false,g)}}(this);this.GC=function(d,b,c,e,f){if(!CanvasXpress.stack){CanvasXpress.stack={}}var a=this.$(this.target);if(a){CanvasXpress.stack[this.target]={version:CanvasXpress.factory.version,renderTo:this.target,data:(this.isCxplot&&this.eO(d)?this.gg(this.data):d?this.lB(d):false),config:this.gg(b)||false,events:c?c:false,info:e?e.toString().replace(/'/g,"'").replace(/"/g,"'"):false,afterRenderInit:f?f:false,afterRender:[["setDimensions",[a.originalWidth,a.originalHeight,true]]],stateCX:[],stateIndexCX:0,noValidate:true}}};this.O5=function(d){if(d.data){if(d.config.stringSampleFactors){for(var b=0;b<d.config.stringSampleFactors.length;b++){var c=d.config.stringSampleFactors[b];if(d.data.x&&d.data.x[c]){for(var a=0;a<d.data.x[c].length;a++){d.data.x[c][a]=d.data.x[c][a]}}}}if(d.config.stringVariableFactors){for(var b=0;b<d.config.stringVariableFactors.length;b++){var c=d.config.stringVariableFactors[b];if(d.data.z&&d.data.z[c]){for(var a=0;a<d.data.z[c].length;a++){d.data.z[c][a]=d.data.z[c][a]}}}}CanvasXpress.stack[this.target].data=d.data}};this.z9=function(){return CanvasXpress.stack[this.target].afterRender};this.sw=function(){var g={meta:true,animationOn:true,arrows:true,beaconImage:true,bubble:true,changingColorItemOn:true,changingColorOn:true,changingSliderItemOn:true,cola:true,colaConnector:true,currentCanvasContext:true,draggingOn:true,doubleClick:true,events:true,functions:true,gantt:true,images:true,info:true,infoStartTime:true,isHighlightCanvas:true,isTransitionOn:true,keyOn:true,lastCanvasEvent:true,lastMousemove:true,leafletMap:true,lines:true,moveSankeyId:true,movingOn:true,nodes:true,panningOn:true,patterns:true,resetOn:true,resizeCanvasCursorShow:true,shapes:true,sizes:true,skipClick:true,skipTransition:true,times:true,transitionIter:true,userId:true,validGraphTypes:true,vennCompartments:true,xMouseDown:true,yMouseDown:true};if(this.graphType!="Network"||(this.graphType=="Network"&&this.networkLayoutType=="cola")){g.data=true}var f=Object.keys(this);var a=this.NB(CanvasXpress.config);var e=[];for(var d=0;d<f.length;d++){var h=f[d];if(a.hasOwnProperty(h)){e.push(h)}else{if(!this.Kj(this[h])&&!g.hasOwnProperty(h)){e.push(h)}}}var b={};for(var d=0;d<e.length;d++){var h=e[d];b[h]=this.Ov(this[h])?this.gg(this[h],true):this[h]}return b};this.P1=function(a){if(!a){a=0}var b=CanvasXpress.stack[this.target].stateCX[a];for(var e in b){this[e]=b[e]}var d={calculateLayout:this.calculateLayout};this.calculateLayout=false;this.skipStack=true;this.dG({func:"setConfigState",par:[a]});this.skipStack=false;for(var e in d){this[e]=d[e]}};this.Mz=function(d){if(!this.skipStack&&d){var i=d.func;var j=d.par?this.RE(d.par):[];var c=d.prop?this.gg(d.prop):{};var v=new Date().getTime();var w=CanvasXpress.stack[this.target];var e=w?w.afterRender.length:0;if(i&&w){switch(i){case"setDimensions":if(j&&j[0]==this.width&&j[1]==this.height){return}if(j&&j[5]){i="clickGraphMaxMin";j=j[5]>0?[false,false,true]:[false,this.maximized,false]}w.afterRender.push([i,j,{},v]);break;case"broadcastDraw":i=j[0].func;j=j[0]&&j[0].par?this.RE(j[0].par):[];c=j[0]&&j[0].prop||{};if(i){w.afterRender.push([i,j,c,v])}break;case"drawIndicesAfterPannEvent":case"drawIndicesAfterWheelEvent":case"drawRangesAfterWheelEvent":case"updateDragCircular":case"updateDragScatter":case"updateDragNetwork":case"updateDragGenome":case"updateDragMap":case"updateDragMarker":var k=w.afterRender;var b=w.stateCX;var g=i=="updateDragNetwork"&&j[0].shiftKey?false:true;if(e>1&&k[e-1][0]==i&&g){var h=v-k[e-1][3];if(h<1000){k.pop();b.pop()}}w.afterRender.push([i,j,c,v]);break;case"handleWheelEvent":w.afterRender.push([i,j,c,v]);break;case"resortSankeyDONOTUSE":var k=w.afterRender;var b=w.stateCX;if(e>1&&k[e-1][0]=="resortSankey"){var h=v-k[e-1][3];if(h<1000){k.pop();b.pop()}}default:w.afterRender.push([i,j,c,v]);break}if(!this.disableUndoRedoKeys&&w.stateIndexCX<w.stateCX.length-1){w.stateCX.splice(w.stateIndexCX,w.stateCX.length-1)}this.meta.stack.push([i,this.meta.time.start,this.meta.time.elapsed]);if(!this.disableUndoRedoKeys){var r=this.sw();w.stateCX.push(r);w.stateIndexCX=w.stateCX.length-1}}}};this.PE=function(a){return function(b){a.lc(b,true)}}(this);this.lc=function(a){return function(c,b,f){if(a.maximized){a.AD()}if(a.motionBy){return}a.skipStack=true;a.reproducing=true;a.Cq();a.JP();a.MI(c,true);a.meta.ids={};if(f){a.Z6();a.yt(c,true,true)}else{a.aq(c);if((c&&c.shiftKey)||b){a.yt(c,true)}}}}(this);this.d1=function(a){return function(b){a.Lt(b,true)}}(this);this.Lt=function(a){return function(j,f,l){var k=a.Fe(CanvasXpress.stack[a.target]);if(!this.isRawData){if(k.data.y){delete k.data.y.data}}this.isQQ=false;this.isCDF=false;k.config.showTransition=f?true:false;if(l){var g=a.gg(k.afterRender);k.afterRender=[];for(var h=0;h<g.length;h++){var n=g[h];if(n[0]=="addCDFPlot"&&k.config.decorations){delete k.config.decorations.cdf}if(n&&n[4]){k.afterRender.push(n)}}}var b=false;if(a.maximized){a.AD()}a.WG(a.target,true);new CanvasXpress(k)}}(this)};CanvasXpress.prototype.initSave=function(){
/*! @source http://purl.eligrey.com/github/Blob.js/blob/master/Blob.js */
(function(g){g.URL=g.URL||g.webkitURL;if(g.Blob&&g.URL){try{new Blob;return}catch(j){}}var i=g.BlobBuilder||g.WebKitBlobBuilder||g.MozBlobBuilder||(function(v){var m=function(F){return Object.prototype.toString.call(F).match(/^\[object\s(.*)\]$/)[1]},E=function s(){this.data=[]},C=function o(H,F,G){this.data=H;this.size=H.length;this.type=F;this.encoding=G},w=E.prototype,B=C.prototype,y=v.FileReaderSync,k=function(F){this.code=this[this.name=F]},x=("NOT_FOUND_ERR SECURITY_ERR ABORT_ERR NOT_READABLE_ERR ENCODING_ERR NO_MODIFICATION_ALLOWED_ERR INVALID_STATE_ERR SYNTAX_ERR").split(" "),A=x.length,r=v.URL||v.webkitURL||v,z=r.createObjectURL,l=r.revokeObjectURL,q=r,u=v.btoa,p=v.atob,n=v.ArrayBuffer,t=v.Uint8Array,D=/^[\w-]+:\/*\[?[\w\.:-]+\]?(?::[0-9]+)?/;C.fake=B.fake=true;while(A--){k.prototype[x[A]]=A+1}if(!r.createObjectURL){q=v.URL=function(G){var F=document.createElementNS("http://www.w3.org/1999/xhtml","a"),H;F.href=G;if(!("origin" in F)){if(F.protocol.toLowerCase()==="data:"){F.origin=null}else{H=G.match(D);F.origin=H&&H[1]}}return F}}q.createObjectURL=function(G){var H=G.type,F;if(H===null){H="application/octet-stream"}if(G instanceof C){F="data:"+H;if(G.encoding==="base64"){return F+";base64,"+G.data}else{if(G.encoding==="URI"){return F+","+decodeURIComponent(G.data)}}if(u){return F+";base64,"+u(G.data)}else{return F+","+encodeURIComponent(G.data)}}else{if(z){return z.call(r,G)}}};q.revokeObjectURL=function(F){if(F.substring(0,5)!=="data:"&&l){l.call(r,F)}};w.append=function(J){var L=this.data;if(t&&(J instanceof n||J instanceof t)){var K="",G=new t(J),H=0,I=G.length;for(;H<I;H++){K+=String.fromCharCode(G[H])}L.push(K)}else{if(m(J)==="Blob"||m(J)==="File"){if(y){var F=new y;L.push(F.readAsBinaryString(J))}else{throw new k("NOT_READABLE_ERR")}}else{if(J instanceof C){if(J.encoding==="base64"&&p){L.push(p(J.data))}else{if(J.encoding==="URI"){L.push(decodeURIComponent(J.data))}else{if(J.encoding==="raw"){L.push(J.data)}}}}else{if(typeof J!=="string"){J+=""}L.push(unescape(encodeURIComponent(J)))}}}};w.getBlob=function(F){if(!arguments.length){F=null}return new C(this.data.join(""),F,"raw")};w.toString=function(){return"[object BlobBuilder]"};B.slice=function(I,F,H){var G=arguments.length;if(G<3){H=null}return new C(this.data.slice(I,G>1?F:this.data.length),H,this.encoding)};B.toString=function(){return"[object Blob]"};B.close=function(){this.size=0;delete this.data};return E}(g));g.Blob=function(o,n){var q=n?(n.type||""):"";var m=new i();if(o){for(var p=0,k=o.length;p<k;p++){if(Uint8Array&&o[p] instanceof Uint8Array){m.append(o[p].buffer)}else{m.append(o[p])}}}var l=m.getBlob(q);if(!l.slice&&l.webkitSlice){l.slice=l.webkitSlice}return l};var h=Object.getPrototypeOf||function(k){return k.__proto__};g.Blob.prototype=h(new g.Blob())}(typeof self!=="undefined"&&self||typeof window!=="undefined"&&window||this.content||this));
/*! @source http://purl.eligrey.com/github/canvas-toBlob.js/blob/master/canvas-toBlob.js */
(function(g){var h=g.Uint8Array,j=g.HTMLCanvasElement,i=j&&j.prototype,k=/\s*;\s*base64\s*(?:;|$)/i,l="toDataURL",n,m=function(u){var v=u.length,r=new h(v/4*3|0),t=0,x=0,y=[0,0],o=0,w=0,s,p,q;while(v--){p=u.charCodeAt(t++);s=n[p-43];if(s!==255&&s!==q){y[1]=y[0];y[0]=p;w=(w<<6)|s;o++;if(o===4){r[x++]=w>>>16;if(y[1]!==61){r[x++]=w>>>8}if(y[0]!==61){r[x++]=w}o=0}}}return r};if(h){n=new h([62,-1,-1,-1,63,52,53,54,55,56,57,58,59,60,61,-1,-1,-1,0,-1,-1,-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,-1,-1,-1,-1,-1,-1,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51])}if(j&&(!i.toBlob||!i.toBlobHD)){if(!i.toBlob){i.toBlob=function(v,t){if(!t){t="image/png"}if(this.mozGetAsFile){v(this.mozGetAsFile("canvas",t));return}if(this.msToBlob&&/^\s*image\/png\s*(?:$|;)/i.test(t)){v(this.msToBlob());return}var s=Array.prototype.slice.call(arguments,1),q=this[l].apply(this,s),p=q.indexOf(","),u=q.substring(p+1),o=k.test(q.substring(0,p)),r;if(Blob.fake){r=new Blob;if(o){r.encoding="base64"}else{r.encoding="URI"}r.data=u;r.size=u.length}else{if(h){if(o){r=new Blob([m(u)],{type:t})}else{r=new Blob([decodeURIComponent(u)],{type:t})}}}v(r)}}if(!i.toBlobHD&&i.toDataURLHD){i.toBlobHD=function(){l="toDataURLHD";var o=this.toBlob();l="toDataURL";return o}}else{i.toBlobHD=i.toBlob}}}(typeof self!=="undefined"&&self||typeof window!=="undefined"&&window||this.content||this));var f=typeof window==="object"&&window.window===window?window:typeof self==="object"&&self.self===self?self:typeof global==="object"&&global.global===global?global:this;function e(g,h){if(typeof h==="undefined"){h={autoBom:false}}else{if(typeof h!=="object"){console.warn("Depricated: Expected third argument to be a object");h={autoBom:!h}}}if(h.autoBom&&/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(g.type)){return new Blob([String.fromCharCode(65279),g],{type:g.type})}return g}function b(h,g,i){var j=new XMLHttpRequest();j.open("GET",h);j.responseType="blob";j.onload=function(){a(j.response,g,i)};j.onerror=function(){console.error("could not download file")};j.send()}function c(g){var h=new XMLHttpRequest();h.open("HEAD",g,false);h.send();return h.status>=200&&h.status<=299}function d(h){try{h.dispatchEvent(new MouseEvent("click"))}catch(i){var g=document.createEvent("MouseEvents");g.initMouseEvent("click",true,true,window,0,0,0,80,20,false,false,false,false,0,null);h.dispatchEvent(g)}}var a=f.saveAs||(typeof window!=="object"||window!==f)?function a(){}:"download" in HTMLAnchorElement.prototype?function a(i,j,k){var g=f.URL||f.webkitURL;var h=document.createElement("a");j=j||i.name||"download";h.download=j;h.rel="noopener";if(typeof i==="string"){h.href=i;if(h.origin!==location.origin){c(h.href)?b(i,j,k):d(h,h.target="_blank")}else{d(h)}}else{h.href=g.createObjectURL(i);setTimeout(function(){g.revokeObjectURL(h.href)},40000);setTimeout(function(){d(h)},0)}}:"msSaveOrOpenBlob" in navigator?function a(h,i,j){i=i||h.name||"download";if(typeof h==="string"){if(c(h)){b(h,i,j)}else{var g=document.createElement("a");g.href=h;g.target="_blank";setTimeout(function(){d(g)})}}else{navigator.msSaveOrOpenBlob(e(h,j),i)}}:function a(h,j,g,k){k=k||open("","_blank");if(k){k.document.title=k.document.body.innerText="downloading..."}if(typeof h==="string"){return b(h,j,g)}var l=h.type==="application/octet-stream";var o=/constructor/i.test(f.HTMLElement)||f.safari;var p=/CriOS\/[\d]+/.test(navigator.userAgent);if((p||(l&&o))&&typeof FileReader==="object"){var m=new FileReader();m.onloadend=function(){var q=m.result;q=p?q:q.replace(/^data:[^;]*;/,"data:attachment/file;");if(k){k.location.href=q}else{location=q}k=null};m.readAsDataURL(h)}else{var n=f.URL||f.webkitURL;var i=n.createObjectURL(h);if(k){k.location=i}else{location.href=i}k=null;setTimeout(function(){n.revokeObjectURL(i)},40000)}};this.r8=a};CanvasXpress.prototype.initConfig=function(){this.Wr=function(cat){var d=CanvasXpress.doc;if(!d.M[cat]){d.M[cat]={}}if(!d.M[cat].P){d.M[cat].P=[]}};this.QE=function(base,color,desc,cat,k){this[base+"Color"]=color==false?false:(color||"rgb(0,0,0)");var d=CanvasXpress.doc;var p=[base+"Color"];k.push.apply(k,p);this.Wr(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[base+"Color"]={C:"Color for the "+desc+"<br>",D:this[base+"Color"],M:cat,T:"color"}};this.wt=function(base,color,desc,cat,k){this[base]=color||"rgb(0,0,0)";var d=CanvasXpress.doc;var p=[base];k.push.apply(k,p);this.Wr(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[base]={C:"Color for the "+desc+"<br>",D:this[base],M:cat,T:"color"}};this.Rh=function(name,def,opts,desc,cat,k,func){this[name]=def||false;var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.Wr(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,O:opts,T:"string"};if(func){d.P[name].F=func}};this.sj=function(name,def,opts,desc,cat,k,func){this[name]=def||"";var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.Wr(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,O:opts,T:"string"};if(func){d.P[name].F=func}};this.rW=function(name,def,desc,cat,k){this[name]=def||false;if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.Wr(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"string"}}};this.uT=function(name,def,desc,cat,k){this[name]=def==null?null:(def||0);if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.Wr(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"integer"}}};this.oL=function(name,def,desc,cat,k){this[name]=def!=null?def:null;if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.Wr(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"float"}}};this.bq=function(name,def,desc,cat,k){this[name]=def||false;if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.Wr(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"boolean"}}};this.ck=function(name,def,desc,cat,k){this[name]=def||[];if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.Wr(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"array"}}};this.xh=function(name,def,desc,cat,k){this[name]=def==false?false:(def||[]);if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.Wr(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"array"}}};this.kK=function(name,def,desc,cat,k){this[name]=def==false?false:{};if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.Wr(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"object"}}};this.JW=function(name,def,desc,cat,k){this[name]=def||{cases:[],comp:[],op:[],type:[],value:[]};if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.Wr(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"filter"}}};this.Kc=function(name,def,desc,cat,k){this[name]=def||false;if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.Wr(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"url"}}};this.QX=function(base,fill,color,size,type,desc,cat,k){this.QE(base,fill||"rgba(255,255,255,0)",desc,cat,k);this.QE(base+"Border",color||"rgba(255,255,255,0)","border in "+desc,cat,k);this.oL(base+"BorderSize",size||1,"Size for the border line in "+desc,cat,k);this.Rh(base+"BorderLineType",type||"solid",["rect","solid","spline","dotted","dashed","dotdash","longdash","twodash"],"Type of line for the border in "+desc,cat,k)};this.Kv=function(base,face,color,size,scale,align,line,rotate,margin,desc,cat,k){this.sj(base+"FontStyle",face||"",["","bold","italic","bold italic"],"Font style for the "+desc,cat,k);this.QE(base,color==false?false:(color||"rgb(0,0,0)"),"text in "+desc,cat,k);this.uT(base+"FontSize",size||11,"Font size for the text in "+desc+". Be aware that auto scaling font must be turned off for this property to take effect. A more convenient way to modify the size is to use the "+base+"ScaleFontFactor",cat,k);this.oL(base+"ScaleFontFactor",scale||1,"Scaling factor used to increase or decrease the "+desc+" font size in the canvas",cat,k);this.Rh(base+"Align",align||"center",["left","center","right"],"Align for the "+desc,cat,k);this.Rh(base+"Baseline",line||"middle",["top","middle","bottom"],"Baseline for the "+desc,cat,k);this.uT(base+"Rotate",margin!=null?rotate:0,"Rotation in degrees for the "+desc,cat,k);this.oL(base+"Margin",margin!=null?margin:5,"Margin used in "+desc,cat,k)};this.Nm=function(base,show,newick,pos,color,desc,cat,k){var l=base.toLowerCase();var p=base=="Var"?["top","bottom"]:["left","right"];this.S4(base+"Dendrogram",show==false?false:true,desc,cat,k);this.bq(l+"DendrogramUseHeight",false,"Flag to use height on the provided newick string for the branches for the "+desc,cat,k);this.bq(l+"DendrogramHang",true,"Flag to use extend the lines to the end of the terminal nodes when the newick is provided for the "+desc,cat,k);this.rW(l+"DendrogramNewick",newick||false,"Custom dendrogram in Newick format produced outside CanvasXpress to specify hierarchy for the "+desc+".",cat,k);this.OS(l+"Dendrogram",pos,p,desc+" in the plot. It could be top, bottom, right or left depending on the orientation of the graph",cat,k);this.Rh("color"+base+"DendrogramBy",color||false,[false],"Name of metadata annotation to color the "+desc,cat,k)};this.ny=function(base,color,trn,wid,len,type,show,desc,cat,k){this.QE(base,color,desc,cat,k);this.oL(base+"Transparency",trn||1,"Transparency for the color of the "+desc,cat,k);this.oL(base+"Width",wid||1,"Width for the "+desc,cat,k);this.oL(base+"Length",len||null,"Length for the "+desc,cat,k);this.YP(base,type,desc,cat,k);this.g1(base,show,desc,cat,k)};this.ss=function(base,show,height,desc,cat,k){this.bq(base+"HistogramShow",show==false?false:true,"Flag to show/hide the histogram in the "+desc,cat,k);this.uT(base+"HistogramHeight",height||80,"Size in pixels for the histogram in the "+desc,cat,k)};this.hd=function(base,show,height,pos,desc,cat,k){this.bq(base+"RugShow",show==false?false:true,"Flag to show/hide a data rug in the "+desc,cat,k);this.uT(base+"RugHeight",height||80,"Size in pixels for the data rug in the "+desc,cat,k);this.Rh(base+"RugPosition",pos?pos[0]:false,pos,"Position for the data rug in the"+desc,cat,k)};this.OS=function(base,pos,opts,desc,cat,k){this.Rh(base+"Position",pos||"right",opts,"Position for the "+desc,cat,k)};this.z7=function(base,dir,desc,cat,k){this.Rh(base+"Direction",dir||"vertical",["vertical","horizontal"],"Direction for "+desc,cat,k)};this.S4=function(base,show,desc,cat,k){this.bq("show"+base,show==false?false:true,"Flag to show/hide the "+desc,cat,k)};this.g1=function(base,show,desc,cat,k){this.bq(base+"Show",show==false?false:true,"Flag to show/hide the "+desc,cat,k)};this.YP=function(base,style,desc,cat,k){this.Rh((base+"LineType").replace("LineLine","Line"),style||"solid",["rect","solid","spline","dotted","dashed","dotdash","longdash","twodash"],"Type of line for the "+desc,cat,k)};this.Xt=function(base,trn,desc,cat,k){this.Rh(base+"Transform",trn||false,[false,"log2","log10","exp2","exp10","percentile"],"Type of transformation for values in "+desc,cat,k)};this.gl=function(base,desc,cat,k){var c=base.toUpperCase();var s=c=="Y"?["Right","Left"]:c=="X"?["Top","Bottom"]:[];var p=c=="Y"?["left","rigth","both"]:c=="X"?["bottom","top","both"]:false;var f=c=="Y"?" on the left":c=="X"?" on the bottom":"";var a=c=="Y"?" on the right":c=="X"?" on the top":"";var t=c=="Z"?10:5;if(c!="R"){this.ck(base+"Axis",[],"Name of the samples, groups or variables to be displayed in the "+desc,cat,k);this.ck(base+"AxisIndices",[])}if(c=="X"){this.ck(base+"Axis2",[],"Name of the samples, groups or variables to be displayed in the second "+desc,cat,k)}this.uT(base+"AxisCurrent",0,"Sample id that is currently displayed in the "+desc+". Important when there are more that one series displayed in the graph",cat,k);this.bq(base+"AxisShow",true,"Flag to show/hide the "+desc+f,cat,k);if(c=="X"||c=="Y"){this.bq(base+"Axis2Show",false,"Flag to show/hide the "+desc+a,cat,k);this.bq(base+"Axis2Rotate",false,"Flag to rotate 180 degrees the direction of the "+desc+a,cat,k)}if(c!="R"){this.oL("setMin"+c,null,"Set the minimum value for data in the "+desc,cat,k);this.oL("setMax"+c,null,"Set the maximum value for data in the "+desc,cat,k)}this.oL(base+"AxisAbsMin",null);this.oL(base+"AxisAbsMax",null);this.rW(base+"AxisMaxStrLength",false);this.oL(base+"AxisMin",null);this.oL(base+"AxisMax",null);this.oL(base+"AxisRange",null);this.oL(base+"AxisIncr",null);this.oL(base+"AxisDecs",null);this.bq(base+"AxisExtensionMin",false);this.bq(base+"AxisExtensionMax",false);if(c=="X"){this.oL("setMin"+c+2,null,"Set the minimum value for data in the second "+desc,cat,k);this.oL("setMax"+c+2,null,"Set the maximum value for data in the second "+desc,cat,k);this.oL(base+"Axis2AbsMin",null);this.oL(base+"Axis2AbsMax",null);this.rW(base+"Axis2MaxStrLength",false)}this.bq(base+"AxisTime",false,"Flag to force date format in "+desc,cat,k);this.bq(base+"AxisExact",false,"Flag to force exact values in "+desc,cat,k);this.ck(base+"AxisValues",[]);this.ck(base+"AxisValuesRaw",[]);this.ck(base+"AxisMinorValues",[]);if(c=="X"){this.ck(base+"Axis2Values",[]);this.ck(base+"Axis2ValuesRaw",[]);this.ck(base+"Axis2MinorValues",[])}this.Xt(base+"Axis",false,desc,cat,k);this.bq(base+"AxisTransformTicks",false,"Flag to transform the values of the ticks in the "+desc,cat,k);this.bq(base+"AxisTransformLinearTicks",false,"Flag to transform the values of the ticks back to linear scale in the "+desc,cat,k);this.oL(base+"AxisCeilValue",null,"Value to ceil the data in the "+desc,cat,k);this.oL(base+"AxisFloorValue",null,"Value to floor the data in the "+desc,cat,k);this.oL(base+"AxisFactorValue",null,"Value to factor the data in the "+desc,cat,k);this.rW(base+"AxisTitle",false,desc+" title "+f,cat,k);this.rW(base+"Axis2Title",false,desc+"2 title "+a,cat,k);this.bq(base+"AxisTitleDynamic",false,"Set the title for the "+desc+" dynamically as it changes when configured by the user",cat,k);this.Kv(base+"AxisTitle","","rgb(0,0,0)",8,1,"center","middle",0,5,"axis title",cat,k);this.Kv(base+"AxisText","","rgb(0,0,0)",8,1,"center","middle",0,5,"axis text",cat,k);this.ny(base+"AxisGridMajor","rgb(204, 204, 204)",1,1,5,"solid",true,"major grid lines in the "+desc+f,cat,k);this.ny(base+"AxisGridMinor","rgb(204, 204, 204)",1,0.5,5,"solid",true,"minor grid lines in the "+desc,cat,k);this.g1(base+"AxisGridMajor",true,"major grid lines in the "+desc,cat,k);this.g1(base+"AxisGridMinor",true,"minor grid lines in the "+desc,cat,k);this.ny(base+"AxisTicks","rgb(204, 204, 204)",1,1,null,"solid",true,"marker lines across the "+desc,cat,k);for(var i=0;i<s.length;i++){this.ny(base+"AxisTick"+s[i],"rgb(204, 204, 204)",1,1,null,"solid",true,s[i].toLocaleLowerCase()+" tick line across the "+desc,cat,k)}this.rW(base+"AxisTickFormat",false,desc+" format for the tick values in the "+desc+'. It could be a string with the sprintf format or an array where the first parameter is the sprintf format and the second parameter is a modification applied to the value before is passed to the sprintf function, i.e. ("/1000", "+ 100", etc.)',cat,k);this.uT(base+"AxisTicks",t,"Approx number of tick lines in the "+desc,cat,k);if(c=="X"){this.rW(base+"Axis2TickFormat",false,desc+" format for the tick values in the second "+desc+'. It could be a string with the sprintf format or an array where the first parameter is the sprintf format and the second parameter is a modification applied to the value before is passed to the sprintf function, i.e. ("/1000", "+ 100", etc.)',cat,k);this.uT(base+"Axis2Ticks",t,"Approx number of tick lines in the second "+desc,cat,k)}this.ny(base+"AxisLogTicks","rgb(0,0,0)",1,1,8,"solid",false,"log tick lines in the "+desc+f,cat,k);if(c=="X"||c=="Y"){this.uT(base+"AxisMinorTicks",2,"Number of minor ticks between major ticks in the "+desc,cat,k);this.ss(base+"Axis",false,80,desc,cat,k);if(p){this.hd(base+"Axis",false,15,p,desc,cat,k)}}};this.lj=function(){var k=CanvasXpress.config;this.Rh("graphType","Bar",["Bar","Line","Area","AreaLine","BarLine","Boxplot","Dotplot","DotLine","Fish","Gantt","Meter","Heatmap","Stacked","StackedLine","StackedPercent","StackedPercentLine","Tree","Treemap","TagCloud","ParallelCoordinates","Sankey","Scatter2D","ScatterBubble2D","Scatter3D","Correlation","Pie","Venn","Network","Genome","Circular"],"Specifies the type of graph","General",k);this.Rh("graphOrientation","horizontal",["horizontal","vertical"],"Specifies the orientation of one dimensional graphs","General",k);this.bq("invertGraph",false,"Option to reverse one-dimensional horizontal graphs for plotting from right to left","General",k);this.Rh("view","canvas",["canvas","table","layout"],"Specify the starting view of the data","General",k);this.bq("isR",false,"Automatically set a flag to indicate operation through the R API interface. Exclusive to developers","General",k);this.bq("isCxplot",false,"Automatically set a flag to indicate operation through the cxplot interface. Exclusive to developers","General",k);this.bq("isReproducibleResearch",true,"Flag set to track user modifications for Reproducible Research. Intended for developers exclusively","General",k);this.bq("isDataFrame",false,"Flag to indicate to use the data object as a data frame from R or Python","General",k);this.uT("reproduceTime",500,"Duration in milliseconds to wait for replicating user modifications via the UI","General",k);this.uT("overplotPixels",500000,"Specify the pixel count for stacking to address overplotting. Increased values result in reduced overplotting, particularly advantageous for datasets with numerous variables","General",k);this.bq("editable",true,"Prevent data editing in JS Fiddle and CodePen by disabling the option in the File menu","General",k);this.Rh("theme","none",["none","grey","gray","igray","ggplot","bw","linedraw","light","dark","minimal","classic","void","economist","excel","tableau","stata","solarized","ptol","wsj","ggblanket","cx"],"Visual themes for the plot. This parameter will replace colors, backgrounds, axes, and other stylistic elements","General",k);this.uT("fullTextMeasureCheck",500,"Perform a comprehensive review of variable and sample name lengths when exceeding the specified quantity. This is beneficial for extensive data sets, as canvas lacks an efficient method for measuring text","General",k);this.kK("metaData",{},"Metadata for the columns of files retrieved from a URL","General",k);this.rW("password",false,"Password to protect exploring data","General",k);this.bq("skipRender",false,"Flag to skip rendering of the graph","General");this.ck("tags",[],"Tags","Graph Metadata",k);this.oL("createVersion",false,"CanvasXpress Version used to create plot. This is parsed from the PNG or JSON data loaded","Graph Metadata");this.kK("createFactory",false,"CanvasXpress Factory used to create plot. This is parsed from the PNG or JSON data loaded","Graph Metadata");this.QX("plotBackground","rgb(255,255,255)","rgba(204,204,204,0)",1,"solid","plot background","Plot and Panel Areas",k);this.QX("panelBackground","rgb(255,255,255)","rgba(204,204,204,0)",1,"solid","panel background","Plot and Panel Areas",k);this.Rh("backgroundType","solid",["solid","gradient","panel","panelGradient","panelSolidGradient","image","panelImage"],"Specifies the style for the background of the canvas. The canvas background is composed of a frame with a panel where the data is plotted. Either of these elements the may be a solid or gradient color or an image of your choosing. The colorScheme property will be used If gradient is specified","Foreground and Background",k);this.Kc("backgroundImage",false,"Specifies the url for the background image when the background type is of the type image or panelImage","Foreground and Background",k);this.rW("backgroundImageSrc",false,"Specifies the source for the background image when the background type is of the type image or panelImage","Foreground and Background",k);this.bq("cacheBase64",false,"Cache image in meta data as Base64","Print",k);this.Rh("printType","download",["download","window"],"Type of printing when the camera icon in the UI is pressed. Download is to download the image while window is to save the image in a new browser window","Print",k);this.uT("printMagnification",1,"Print Magnification to produce High Definition images. Courtesy of Baohong Zhang","Print",k);this.bq("printThumbnail",false,"Print thumbnail","Print",k);this.rW("saveFilename",false,"Filename to use when downloading the canvas as an image or as json. If not specified. the filename will be based on the target id of the canvas. cX- + canvas.targetId + extension","Print",k);this.oL("transparency",null,"Percentage of transparency applied to all elements in the visualizations","Transparency",k);this.oL("transparencyHidden",0.1,"Percentage of transparency applied to elements that are hidden","Transparency",k);this.bq("highlightGreyOut",false,"Flag to add grey out when highlighting with mouse over","Grey Out",k);this.oL("highlightGreyOutTransparency",0.67,"Fraction of transparency for grey out when highlighting with mouse over","Grey Out",k);this.kK("aes",{},"Initial Configuration passed to cxplot","cxplot",k);this.kK("ggplot",{},"Initial ggplot configuration passed to cxplot","cxplot",k);this.Rh("effect","none",["none","magic","puffIn","openDownLeft","openDownLeftOut","perspectiveDown","rotateDown","twisterInDown","puffOut","openDownRight","openDownRightOut","perspectiveUp","rotateUp","twisterInUp","vanishIn","openUpLeft","openUpLeftOut","perspectiveLeft","rotateLeft","swap","vanishOut","openUpRight","openUpRightOut","perspectiveRight","rotateRight","openDownLeftReturn","perspectiveDownReturn","openDownRightReturn","perspectiveUpReturn","openUpLeftReturn","perspectiveLeftReturn","openUpRightReturn","perspectiveRightReturn","slideDown","swashOut","tinRightOut","bombRightOut","boingInUp","spaceOutUp","slideUp","swashIn","tinLeftOut","bombLeftOut","boingOutDown","spaceOutRight","slideLeft","foolishIn","tinUpOut","spaceOutDown","slideRight","holeOut","tinDownOut","spaceOutLeft","slideDownReturn","tinRightIn","spaceInUp","slideUpReturn","tinLeftIn","spaceInRight","slideLeftReturn","tinUpIn","spaceInDown","slideRightReturn","tinDownIn","spaceInLeft"],"Effect used to show widgets Magic - Ver 1.3.0 - https://minimamente.com","Effect",k);this.rW("codeEffectIn","slideLeftReturn2","Code Effect In","Effect",k);this.rW("codeEffectOut","slideLeft","Code Effect Out","Effect",k);this.rW("customizerEffectIn","slideLeftReturn","Customize Effect In","Effect",k);this.rW("customizerEffectOut","slideUp2","Customizer Effect Out","Effect",k);this.rW("datafilterEffectIn","slideRightReturn","Data Filter Effect In","Effect",k);this.rW("datafilterEffectOut","slideRight","Data Filter Effect Out","Effect",k);this.rW("datatableEffectIn","slideUpReturn","Data Table Effect In","Effect",k);this.rW("datatableEffectOut","slideDown3","Data Table Effect Out","Effect",k);this.rW("tabpanelEffectIn","slideDownReturn2","Tab Panel Effect In","Effect",k);this.rW("tabpanelEffectOut","slideDown2","Tab Panel Effect Out","Effect",k);this.rW("motionEffectIn","swashIn","Motion Effect In","Effect",k);this.rW("motionEffectOut","holeOut","Motion Effect Out","Effect",k);this.rW("remoteEffectIn","holeIn","Remote Effect In","Effect",k);this.rW("remoteEffectOut","holeOut","Remote Effect Out","Effect",k);this.rW("toolbarEffectIn","holeIn","Toolbar Effect In","Effect",k);this.rW("toolbarEffectOut","holeOut","Toolbar Effect Out","Effect",k);this.rW("tooltipDivEffectIn","holeOut","Tooltip Div Effect In","Effect",k);this.rW("tooltipDivEffectOut","spaceInUp","Tooltip Div Effect Out","Effect",k);this.bq("gradient",false,"Flag used to apply gradients to all objects in the graphs","Gradients",k);this.Rh("gradientType","radial",["linear","radial"],"Specifies the gradient pattern","Gradients",k);this.Rh("gradientOrientation","vertical",["vertical","horizontal"],"Specifies the orientation of the gradient if the gradient type is of the type linear","Gradients",k);this.oL("gradientRatio",1.3,"Specifies the ratio used to generate linear gradients","Gradients",k);this.bq("adjustAspectRatio",true,"Flag to automatically adjust the size of the bars or points in the one dimensional plots to fit in the provided canvas width and height. If the flag is set to false the width and height of the canvas will be sized according to the number of bars or points in the data set","Aspect Ratio, Space and width",k);this.oL("percentAspectRatioPlotArea",0.5,"Specifies the minimum percentage for the plotting area","Aspect Ratio, Space and width",k);this.oL("fixedAspectRatio",0,"Keep fixed aspect ratio expressed as y / x. A zero value is used to ignore otherwise the x and y axes are set accordingly","Aspect Ratio, Space and width",k);this.uT("variableSpace",2,"Pixels between the variables in the one dimensional plots","Aspect Ratio, Space and width",k);this.uT("widthFactor",1,"Factor to adjust the width of the bars in the one dimensional and the three dimensional plots. The greater the number, the wider the bars","Aspect Ratio, Space and width",k);this.uT("dataPointSize",10,"Approximate size for the data points in scatter plots, dotplots and boxplots. The size will be adjusted according to the dimensions of the graph","Aspect Ratio, Space and width",k);this.oL("dataPointSizeScaleFactor",1,"Factor used to adjust the size of the dataPointSize","Aspect Ratio, Space and width",k);this.uT("adjustAspectRatioMax",3,"Specifies the number of times to try to automatically adjust the size of the canvas when adjustAspectRatio is true","Aspect Ratio, Space and width",false);this.uT("adjustAspectRatioYTries",0,"Counter set when trying to automatically adjust the vertical size of the canvas when adjustAspectRatio is true","Aspect Ratio, Space and width",false);this.uT("adjustAspectRatioXTries",0,"Counter set when trying to automatically adjust the horizontal size of the canvas when adjustAspectRatio is true","Aspect Ratio, Space and width",false);this.uT("setPlotX",0,"Force the x dimension for the data plot in one dimensional graphs","Aspect Ratio, Space and width",k);this.uT("setPlotY",0,"Force the y dimension for the data plot in one dimensional graphs","Aspect Ratio, Space and width",k);this.uT("setPlotLeft",0,"Force the left dimension for the data plot in one dimensional graphs","Aspect Ratio, Space and width",k);this.uT("setPlotTop",0,"Force the top dimension for the data plot in one dimensional graphs","Aspect Ratio, Space and width",k);this.wt("foreground","rgb(0,0,0)","Specifies the foreground color for text or lines not covered in a more specific configuration property","Foreground and Background",k);this.wt("background","rgb(255,255,255)","Specifies the background color for the canvas","Foreground and Background",k);this.uT("margin",8,"Relative length in pixels for the distance between various objects in the graphs. This value is adjusted acording to the graph dimensions if the adjustAspectRatio parameter is set to true","Margins",k);this.uT("marginLeft",8,"Specifies the length in pixels for the left margin in the canvas","Margins",k);this.uT("marginTop",8,"Specifies the length in pixels for the top margin in the canvas","Margins",k);this.uT("marginBottom",8,"Specifies the length in pixels for the bottom margin in the canvas","Margins",k);this.uT("marginRight",8,"Specifies the length in pixels for the right margin in the canvas","Margins",k);this.S4("Shadow",false,"shadows in all graph objects in the canvas. It will be forced to false if the browser is IE","Shadows",k);this.S4("TextShadow",false,"shadows in text in the canvas. It will be forced to false if the browser is IE","Shadows",k);this.uT("shadowOffsetX",1,"Length in pixels for the shadow offset in the X axis","Shadows",k);this.uT("shadowOffsetY",1,"Length in pixels for the shadow offset in the Y axis","Shadows",k);this.uT("shadowBlur",2,"Amount in blur for the shadow","Shadows",k);this.QE("shadow","rgba(0,0,0,0.5)","shadow","Shadows",k);this.rW("topoJSON",false,"TopoJSON map string","Maps",k);this.rW("mapId",false,"Map Id for the map div in the DOM","Maps",k);this.rW("mapPropertyId",false,"Map Property Id use to match the data ids to the GeoJSON layer Id","Maps",k);this.Rh("mapProjection","mercator",["mercator","albers","orthographic"],"Map projection","Maps",k);this.kK("mapConfig",false,"Map config","Maps",k);this.kK("mapConfigFeatures",false,"Map config for features use to translate and scale","Maps",k);this.ck("mapSmps",[],"Samples to use in maps","Maps",k);this.ck("hiddenMapFeatures",[],"Hidden Map features","Maps",k);this.ck("visibleMapFeatures",[],"Visible Map features. It Overrides the hidden features","Maps",k);this.QE("map","rgb(105,210,230)","maps","Maps",k);this.QE("mapOutline","rgb(204,204,204)","outline of the maps","Maps",k);this.Rh("mapMarkerShape","drop",["drop","sphere","square","triangle","star","rhombus","octagon","mdavid","pentagon","rectangle"],"Default shape for the markers in map (if no shapeBy is specified","Maps",k);this.oL("mapMarkerShapeScaleFactor",1,"Scale factor for the marker shapes","Maps",k);this.oL("mapLatitudeOrigin",23,"Map Latitude Of Origin in degrees. (Applicable to Albers projection only). Default adjusts to USA maps","Maps Albers",k);this.oL("mapCentralMeridian",-96,"Map Latitude Of Origin in degrees. (Applicable to Albers projection only). Default adjusts to USA maps","Maps Albers",k);this.oL("mapStandardParallel1",29.5,"Map Standard Parallel 1 in degrees. (Applicable to Albers projection only). Default adjusts to USA maps","Maps Albers",k);this.oL("mapStandardParallel2",45.5,"Map Standard Parallel 2 in degrees. (Applicable to Albers projection only). Default adjusts to USA maps","Maps Albers",k);this.bq("mapGraticuleShow",false,"Show Map Graticule","Maps Orthographic",k);this.Rh("mapGraticuleType","solid",["dashed","solid"],"Map Graticule type","Maps Orthographic",k);this.bq("useLeaflet",false,"Use leaflet","Maps Leaflet",k);this.oL("leafletAlpha",0.7,"Transparency for leaflet layers","Maps Leaflet",k);this.oL("leafletZoomAlphaColor",6,"Zoom level before turning transparent the leaflet layers","Maps Leaflet",k);this.Rh("leafletTileType","street",["street","terrain","labels","satellite"],"Leaflet tile type","Maps Leaflet",k);this.ck("fonts",[],"Goggle Fonts","Text",k);this.ck("fontsExternal",[],"External Fonts","Text",k);this.Rh("fontName","Arial",Object.keys(CanvasXpress.fonts),"Font name. Web-Safe HTML fonts","Text",k);this.sj("fontStyle","",["","bold","italic","bold italic"],"Font style","Text",k);this.QE("font","rgb(0,0,0)","font","Text",k);this.uT("fontSize",11,"Font size for text in complex plot only. See other categories to modify specific font sizes","Text",k);this.oL("fontScaleFontFactor",1,"Scaling factor used to increase or decrease the font size in the canvas","Text",k);this.Rh("align","center",["right","center","left"],"Default horizontal alignment for drawing text","Text",k);this.Rh("baseline","middle",["top","middle","bottom"],"Default vertical alignment for drawing text","Text",k);this.uT("maxTextSize",40,"Maximum size for any text in the canvas","Text",k);this.uT("minTextSize",4,"Minimum size for any text in the canvas","Text",k);this.bq("autoScaleFont",true,"Flag to automatically adjust the font size in many visualization. Please be aware that scaling factors can still modify the font size. This flag needs to be false for the text to accept the specified font size","Text",k);this.uT("scaleTextConstantMult",25,"Constants to autoscale text","Text",false);this.oL("scaleTextConstantAdd",2,"Constants to autoscale text (extra)","Text",false);this.bq("optimizeTextPosition",false,"Flag to optimize position for text in many plots","Text Placement",k);this.Rh("optimizeTextPositionStrategy","greedy",["annealing","greedy","boundingBox"],"Startegy to optimize placement of text","Text Placement",k);this.bq("optimizeTextPositionEnforceBounds",true,"Flag to enforce bounds when optimizing position for text in many plots","Text Placement",k);this.bq("optimizeTextPositionRemoveOverlaps",true,"Flag to remove overlaps when optimizing position for text in many plots","Text Placement",k);this.uT("optimizeTextPositionTemperature",1000,"Temperature parameter when optimizing position for text in many plots","Text Placement",k);this.uT("optimizeTextPositionCooling",1,"Cooling parameter when optimizing position for text in many plots","Text Placement",k);this.rW("title",false,"Title of the graph","Titles and Subtitles",k);this.rW("subtitle",false,"Subtitle of the graph","Titles and Subtitles",k);this.Kv("title","bold","rgb(0,0,0)",13,1,"center","middle",0,5,"title","Titles and Subtitles",k);this.QX("titleBackground","rgba(255,255,255,0)","rgba(255,255,255,0)",0.5,"solid","title background","Titles and Subtitles",k);this.Kv("subtitle","","rgb(0,0,0)",13,1,"center","middle",0,5,"subtitle","Titles and Subtitles",k);this.QX("subtitleBackground","rgba(255,255,255,0)","rgba(255,255,255,0)",0.5,"solid","subtitle background","Titles and Subtitles",k);this.rW("citation",false,"A reference citation of the graph which is placed at the bottom right corner","Citations or References",k);this.Kv("citation","","rgb(0,0,0)",8,1,"right","middle",0,5,"citations","Citations or References",k);this.uT("dashLength",8,"Size in pixels of the length of the dashes and the separation between the dashes in the dashed lines","Lines",k);this.uT("dotLength",1,"Size in pixels of the length between dots in the doted lines","Lines",k);this.oL("arrowQuadraticFactor",2.3,"Factor to use to bend the quadratic lines","Lines",k);this.Rh("arrowHeadType","filledArc",["unFilled","filledStraight","filledArc","filledQuadratic","filledBezier"],"Type for the head of the arrows","Lines",k);this.uT("arrowHeadSize",10,"Size in pixels of the arrow head in arrow lines","Lines",k);this.oL("arrowHeadAngle",22.5,"The angle for the head of the arrow","Lines",k);this.Rh("capType","butt",["butt","round","square"],"Default type of cap for lines","Lines",k);this.Rh("joinType","mitter",["mitter","bevel","round"],"Default type for joining lines","Lines",k);this.uT("lineWidthEvent",0.5,"Size in pixels of the width for the events in the lines","Lines",false);this.oL("outlineWidth",1,"Default width in pixels for lines in networks and other line elements in all visualizations except for the lines in the line plots","Lines",k);this.oL("lineThickness",1,"Default thickness in pixels for the lines in line plots","Lines",k);this.bq("adjustBezier",false,"Flag to automatically select the bezier line type. the bezier can start from the top or bottom (vertical), or from the side (horizontal). This will be based on the location of the two points joined by the line","Lines",k);this.ck("lines",["line","solid","straight","bezier","curved","curvedCC","dashedLine","dashedBezier","dashedCurved","dashedCurvedCC","dottedLine","dottedBezier","dottedCurved","dottedCurvedCC"],"Line types in network graphs for the edges (or connections) between network nodes.<br> There are three styles: solid, dashed and dotted and four sub types: straight, bezier, curved (clockwise) and curvedCC (counter clockwise). The line types can be any combination of a style followed by a subtype. By default the type is always a solid straight line so there is no need to specify solid or stright as a style if there is a subtype.<br> Lines can also have elbows which are specified as a 2D-array. In the case a straight solid line each elements in the array will have an x,y coordinate and each segment will be perpendicular to the previous one. For example in this edge object:<br> <i>{ ..., type : line, elbows : [ [20, 40], [60, 80] ], ... }</i><br> A special subtype of line called segmented can also have elbows which are not perpendicalar to each other. For example in this edge object:<br> <i>{ ..., type : segmented, elbows : [ [20, 40], [60, 80] ], ... }</i><br> In the case of a bezier curved each element of the array will have an x,y coordinate for the control point 1, an x,y coordinate for the control point 2 and an x,y coordinate for the end of the line.<br> <i>{ ..., type : bezier, elbows : [ [20, 40, 40, 20, 40, 40], ... ], ... }</i><br> If the property elbow is specified the line will be drawn using the first and last elements of the array rather than the coordinates of the two nodes. A property startX and startY can be used to better adjust the position of the starting line. Similarly, a property endX and endY can be used to better adjust the position of the end line. These properties have a maginitud between -1 to 1 which will be used based on the width and height of the source and target node. For example in the following edge object the line will start in the middle bottom of the source node and will end at the upper left of the target node.<br>  <i>{ ..., type : line, startX : 0, startY : 1, endX : -1, endY : -0.5, ... }</i>","Lines",false);this.ck("arrows",["arrow","square","round"],"Arrows for the edges (or connections) in network graphs.<br> There are three arrow types: arrow, square and round. They can be at the start or at the end of the line. To specify an arrow at the start of the line include a startArrow property in the edge; to specify an arrow at the end of the line include a endArrow property in the edge. For example in this edge object:<br> <i>{ ..., type : line, startArrow : square, endArrow : arrow, ... }</i>","Lines",false);this.Rh("colorScheme","User",["YlGn","YlGnBu","GnBu","BuGn","PuBuGn","PuBu","BuPu","RdPu","PuRd","OrRd","YlOrRd","YlOrBr","Purples","Blues","Greens","Oranges","Reds","Greys","PuOr","BrBG","PRGn","PiYG","RdBu","RdGy","RdYlBu","Spectral","RdYlGn","Accent","Dark2","Paired","Pastel1","Pastel2","Set1","Set2","Set3","Default","Basic","Light","Favorite","Pastel","Balanced","Rpalette","RlatticeBackground","RlatticeShingle","RlatticeLine","RlatticePolygon","Bootstrap","Economist","EconomistBG","Excel","Excel2","Excel3","GGPlot","Solarized","SolarizedBase","PaulTol","ColorBlind","Tableau","TableauGrey","TableauColorBlind","TableauTrafficLight","TableauPurpleGrey","TableauBlueRed","TableauGreenOrange","TableauCyclic","TableauPairSequential","TableauTripleDiverging","WallStreetJournal","WallStreetJournal2","WallStreetJournal3","WallStreetJournalRedGreen","WallStreetJournalBlackGreen","WallStreetJournalDemRep","Stata","Stata2","Stata3","StataMono","BlackAndWhite","CanvasXpress","CanvasXpressT"],"Color schemes can be user defined which will take the colors in the color property or one provided in canvasXpress. The order of the colors will be used to sequentially select when a different color is needed in a particular visualization","Colors",k);this.ck("colors",["#fe296c","#487eb6","#a7ce31","#f8cc03","#ff8c02","#699696","#b77844","#83acd0","#c2e076","#fadc5a","#ff549f","#ffaf54","#9ab8b7","#d2a683","#3d699b","#87ac22","#cda908","#d02158","#d07300","#567676"],"Colors","Colors",k);this.ck("colorHSV",[0,0,1],"Color HSV. Hue, Saturation and Value used when configuring colors","Colors",false);this.ck("colorRGB",[1,1,1],"Color RGB. Red, Green, Blue used when configuring colors","Colors",false);this.ck("colorSpectrum",["#4575b4","#91bfdb","#e0f3f8","#ffffbf","#fee090","#fc8d59","#d73027"],"An array with valid color names to create a color brew for the default color indicators","Colors",k);this.bq("colorSpectrumBinned",false,"Flag to bin the color spectrum based on the colorSpectrumBreaks or the colorSpectrum colors","Colors",k);this.ck("colorSpectrumBreaks",[],"An array with numbers in ascending order for the color spectrum to create discontinuous spectra. It must have the same length of the colorSpectrum array for example [0, 0.3, 1]","Colors",k);this.oL("colorSpectrumZeroValue",null,"A value to be at the center of the color spectrum to produce symmetrical heatmaps","Colors",k);this.uT("colorSpectrumNumber",100,"Number of colors to use in the color spectrum","Colors",false);this.uT("colorSpectrumTarget",10,"Approximate number of colors to use to build the color spectrum","Colors",false);this.QE("odd","rgb(255,255,255)","odd numbers in samples when the property block contrast is set in one dimensional plots or the color for odd number residues in translations in genome plots","Colors",k);this.QE("even","rgb(245,245,245)","even numbers in samples when the property block contrast is set in one dimensional plots or the color for odd number residues in translations in genome plots","Colors",k);this.Rh("blindnessType",false,[false,"protanopia","deuteranopia","tritanopia","monochromatic"],"Color Blindness","Colors",k);this.uT("roundedPolygonRadius",5,"Radius for rounded polygons","Shapes",k);this.bq("useRoundRectangles",false,"Use round rectangles in bar graphs, stacked graphs and boxplots","Shapes",k);this.Rh("plotStyle","default",["default","ggplot","ggplotSwitched","open","border"],"Style for some shapes used mainly in boxplot, violin and density plots","Data Point Attributes",k);this.ck("shapes",["sphere","square","triangle","star","rhombus","octagon","oval","plus","minus","pacman","pacman2","mdavid","rect2","pentagon","rect3","arc","rectangle","image"],"Array with shapes used in visualizations. The order will dictate the utilization in the visualization","General Attributes",k);this.ck("sizes",[8,12,16,20,24,28,32,36,40,44,48],"Array with sizes used invisualizations. The order will dictate the utilization in the visualization","General Attributes",k);this.ck("images",[],"Array of urls of images used in scatter plots. Additional shapes will be used if the array does not contain as many images as needed","General Attributes",k);this.ck("patterns",["solid","hatchForward","hatchReverse","stripeHorizontal","stripeVertical","polkaDot","crossHatch","crossStripe","squares","circles","plus","minus","bars","squiglesVertical","squiglesHorizontal","brickForward","brickReverse","art","pcx","hatchForward3","hatchReverse3"],"Patterns used in visualizations to fill objects. This array must contain one or more pattern names and in concert with the color array can be used to specify the pattern colors for all filled objects in the visualizations.. The order will dictate the utilization in the visualization","General Attributes",k);this.ck("linePatterns",["solid","dotted","dashed","dotdash","longdash","twodash"],"Line Patterns used in line visualizations","General Attributes",k);this.uT("maxSmpStringLen",25,"Maximum length in characters a sample label or description can have so anything above is truncated","Samples",k);this.rW("smpTitle",false,"Title for the sample axis in one dimensional plots","Samples",k);this.uT("smpLabelInterval",1,"Interval for the sample labels in one dimensional and circular plots","Samples",k);this.bq("smpLabelImage",false,"Use images as sample labels when possible","Samples",k);this.bq("smpLabelImageRound",false,"Use round images as sample labels","Samples",k);this.S4("SampleNames",true,"sample names","Samples",k);this.ck("highlightSmp",[],"Name of samples to highlight","Samples",k);this.QE("smpHighlight","rgb(255,0,0)","higlighted samples","Samples",k);this.Kv("smpTitle","","rgb(0,0,0)",11,1,"center","middle",0,5,"sample title","Samples",k);this.Kv("smpText","","rgb(0,0,0)",11,1,"center","middle",0,5,"sample labels","Samples",k);this.uT("maxVarStringLen",25,"Maximum length in characters a variable label or description can have so anything above is truncated","Variables",k);this.rW("varTitle",false,"Title for the variables in hetamap plots","Variables",k);this.uT("varLabelInterval",1,"Interval for the variable labels in heatmaps","Variables",k);this.S4("VariableNames",true,"variable names","Variables",k);this.ck("highlightVar",[],"Name of variables to highlight","Variables",k);this.QE("varHighlight","rgb(255,0,0)","higlighted variables","Variables",k);this.Kv("varTitle","","rgb(0,0,0)",11,1,"center","middle",0,5,"variable title","Variables",k);this.Kv("varText","","rgb(0,0,0)",11,1,"center","middle",0,5,"variable text","Variables",k);this.kK("binConfigurations",{},"Properties for the binning functions","Bins",k);this.uT("maxOverlayStringLen",30,"Maximum length in characters for the sample or variable metadata when included as an overlay. Anything above is truncated","Overlays",k);this.uT("overlaysThickness",18,"Relative length in pixels for the thickness of the colored boxes to classify samples and or variables in one dimensional plots. This value is adjusted acording to the graph dimensions if the adjustAspectRatio parameter is set to true","Overlays",k);this.ck("smpOverlays",[],"Sample metadata to overlay in one dimensional plots","Overlays",k);this.kK("smpOverlayProperties",{},"Object to assign properties of the sample overlays. The key should be a valid sample annotation (metadata) and the value and object with properties like: type, color, spectrum, scheme, showLegend, showName, showBox, rotate, position, thicknes","Overlays",k);this.uT("smpOverlaysLegendColumns",1,"Number of columns for the sample overlay legends","Overlays",k);this.S4("SmpOverlaysLegend",false,"sample overlay legends","Overlays",k);this.ck("varOverlays",[],"Variable metadata to overlay in heatmap plots","Overlays",k);this.kK("varOverlayProperties",{},"Object to assign properties of the variable overlays. The key should be a valid variable annotation (metadata) and the value and object with properties like: type, color, spectrum, scheme, showLegend, showName, showBox, rotate, position, thicknes","Overlays",k);this.uT("varOverlaysLegendColumns",1,"Number of columns for the variable overlay legends","Overlays",k);this.S4("VarOverlaysLegend",false,"sample overlay legends","Overlays",k);this.OS("overlaysLegend","topRight",["topRight","right","bottomLeft","bottom"],"the variable and sample overlays legend","Overlays",k);this.S4("Overlays",true,"overlays in one dimensional plots","Overlays",k);this.S4("NameOverlays",true,"the overlays name","Overlays",k);this.S4("ValueOverlays",true,"overlay values in one dimensional plots","Overlays",k);this.Kv("overlayText","","rgb(0,0,0)",11,1,"center","middle",0,5,"overlays","Overlays",k);this.QX("panelOverlayBackground","rgb(255,255,255)","rgba(204,204,204,1)",1,"solid","panel background","Plot and Panel Areas",k);this.bq("legendInside",false,"Position the legend inside the graphs","Legends",k);this.uT("legendColumns",1,"Number of columns in legends","Legends",k);this.uT("legendRows",1,"Number of rows in legends","Legends",k);this.kK("legendOrder",false,"Object to specify custom order for the levels in the legends. The key of the object is the name of a valid sample or variable annotation included in the data object. The value for element is an array with the levels for the corresponding factor","Legends",k);this.bq("legendOrderByCols",true,"Draw legends by columns in the graphs","Legends",k);this.ck("customLegend",[],"Custom legends : Array of objects [{ size : [], shape : [], shapeColor : [], line : [], lineColor : [], lineStart : [], lineEnd : [], text : [], x : number, y : number, title : string }]","Legends",k);this.S4("Legend",true,"legend","Legends",k);this.S4("ColorNodeLegend",true,"legend node color","Legends",k);this.S4("ShapeNodeLegend",true,"legend node shape","Legends",k);this.S4("SizeNodeLegend",true,"legend node size","Legends",k);this.S4("PatternNodeLegend",true,"legend node pattern","Legends",k);this.S4("ColorEdgeLegend",true,"legend edge color","Legends",k);this.S4("SizeEdgeLegend",true,"legend edge size","Legends",k);this.S4("LegendTitle",true,"the legend title","Legends",k);this.S4("LegendBorder",true,"the legend border","Legends",k);this.OS("legend","right",["topRight","right","bottomRight","bottom","bottomLeft","left","topLeft","top"],"the legend","Legends",k);this.oL("legendHorizontalJustification",0.5,"Horizontal justification for legends when legend are in top or bottom positions","Legends",k);this.oL("legendVerticalJustification",0.5,"Vertical justification for legends when legend are in left or right positions","Legends",k);this.z7("legend","vertical","legend","Legends",k);this.QX("legendBackground","rgba(255,255,255,0)","rgba(255,255,255,0)",0.5,"solid","legend background","Legends",k);this.QX("legendKeyBackground","rgba(255,255,255,0)","rgba(255,255,255,0)",1,"solid","legend key background","Legends",k);this.uT("legendKeySize",15,"Width in pixels for the legend key","Legends",k);this.uT("legendKeyMargin",5,"Width in pixels for the legend key margin","Legends",k);this.Kv("legendText","","rgb(0,0,0)",11,1,"left","middle",0,8,"legends","Legends",k);this.Kv("legendTitle","","rgb(0,0,0)",11,1,"left","middle",0,8,"legends","Legends",k);this.uT("decorationsWidth",20,"Length in pixels of the width for the decorations in the networks","Decorations",k);this.uT("decorationsHeight",40,"Length in pixels of the height for the decorations in the networks","Decorations",k);this.Rh("decorationsType","bar",["pie","bar","heatmap","stacked","stackedpercent"],"Type for the decorations in the networks. The types stacked and stackedpercent must be two dimensional. Heatmap could be one or two dimensional","Decorations",k);this.kK("decorations",false,"Name of the node properties to include in the network decorations in the data.nodes object","Decorations",k);this.ck("decorationsColors",[],"Array of colors used for selection in network decorations not to be confused by its singular form decorationsColor above","Decorations",k);this.kK("decorationsProperties",{},"Object to assign properties like color for the network decorations","Decorations",k);this.bq("decorationsClipped",true,"Clipp decorations to the x,y area of the plot.","Decorations",k);this.oL("decorationsTransparency",0.2,"Transparency for range decorations","Decorations",k);this.S4("Decorations",true,"decorations","Decorations",k);this.S4("DecorationsLegend",true,"decoration legends","Decorations",k);this.S4("DecorationsBorder",false,"the decoration legends border","Decorations",k);this.OS("decorations","bottom",["topRight","right","bottomRight","bottom","bottomLeft","left","topLeft","top"],"the decorations","Decorations",k);this.QX("decorationsBackground","rgba(255,255,255,0)","rgb(204,204,204)",0.5,"solid","decoration legends background","Decorations",k);this.Kv("decorationsText","","rgb(0,0,0)",11,1,"center","middle",0,5,"decoration legends","Decorations",k);this.bq("decorationsOnTop",false,"Draw decorations after drawing the data","Decorations",k);this.bq("decorationsTransform",true,"Transform the data in decorations produced in Cxplot","Decorations",k);this.bq("isGroupedData",false,"Flag to indicate if the data is grouped","Data",false);this.bq("isBoxplotCalc",false,"Flag to indicate if the iqr has been calculated when the graph type is Boxplot","Data",false);this.ck("groupingFactors",[],"An array that holds the group names used for grouping the data. It must be a category in the data.x object","Data",k);this.Rh("summaryType",false,[false,"iqr","median","mean","cor","min","max","count","sum"],"Summary type for the data when grouping","Data",k);this.bq("transposeData",false,"Flag to transpose data as a parameter. This parameter accomplishes the same as the function transpose at load time","Data",k);this.ck("appendNetworkData",[],"Array containing additional data files to append to networks. Useful for loading KEGG and Wikipatways to decorate the nodes and the edges","Data",k);this.Kv("dataText","","rgb(0,0,0)",11,1,"center","middle",0,5,"data labels","Data",k);this.ck("asSampleFactors",[],"Array containing variable names. Numeric variable data (in rows) to be treated as a sample factor (move from y to x object). This parameter accomplishes the same as the function switchVarToAnnotation at load time. It can be used in conjunction with the parameter stringSampleFactors to be treated as a string. TO DO: write example","Data Context",k);this.ck("asVariableFactors",[],"Array containing sample names. Numeric sample data (in columns) to be treated as a variable factor (move from y to z object). This parameter accomplishes the same as the function switchSmpToAnnotation at load time. It can be used in conjunction with the parameter stringVariableFactors to be treated as a string. TO DO: write example","Data Context",k);this.ck("stringSampleFactors",[],"Array containing sample factors. The numeric sample factors will be treated as strings. This parameter accomplishes the same as the function switchNumericToString for samples at load time. It can be used in conjunction with the parameter asSampleFactors. TO DO: write example","Data Context",k);this.ck("stringVariableFactors",[],"Array containing variable factors. The numeric variable factors will be treated as strings. This parameter accomplishes the same as the function switchNumericToString for variables at load time. It can be used in conjunction with the parameter asVariableFactors. TO DO: write example","Data Context",k);this.ck("stringNodeAttributes",[],"Array containing node attributes. The numeric node attributes will be treated as strings. This parameter accomplishes the same as the function switchNumericToString for nodes at load time","Data Context",k);this.ck("stringEdgeAttributes",[],"Array containing edge attributes. The numeric edge attributes will be treated as strings. This parameter accomplishes the same as the function switchNumericToString for edges at load time","Data Context",k);this.bq("isTransformedData",false,"Flag to indicate if the data is transformed","Data Transformation",false);this.uT("transformBase",10,"Default log or exponential transformation for the data","Data Transformation",false);this.Rh("transformData",false,[false,"log2","log10","exp2","exp10","percentile","zscore","ratio2","ratio10","save","reset","undo"],"Default transformation type for ALL the data. Data can also be transformed by axis (x,y,z) to give more flexibility. false, save, reset and undo are NOT real transformations. They are only used in the canvasXpress UIs to save the transformed data","Data Transformation",k);this.Rh("transformAxis","samples",["samples","variables"],"Default axis to use to transform the data when either z-score or ratio transformation is used","Data Transformation",k);this.uT("ratioReference",0,"Default index of sample used in ratio transformation. Almost private parameters used within the different CanvasXpress UIs","Data Ratio Reference",k);this.Rh("ratioSampleReference",false,[false],"Name of the sample used in ratio transformation. Almost private parameters used within the different CanvasXpress UIs","Data Ratio Reference",k);this.Rh("ratioGroupReference",false,[false],"Name of the group used in ratio transformation. Almost private parameters used within the different CanvasXpress UIs","Data Ratio Reference",k);this.Rh("ratioLevelReference","",[],"Name of the level used in ratio transformation. Almost private parameters used within the different CanvasXpress UIs","Data Ratio Reference",k);this.ck("segregateSamplesBy",[],"An array that holds the annotation(s) used to segregate the samples ala Facet way in R. It must be categories in the data.x object","Data Faceting",k);this.ck("segregateVariablesBy",[],"An array that holds the annotation(s) used to segregate the variables ala Facet way in R. It must be categories in the data.z object","Data Faceting",k);this.rW("splitSamplesBy",false,"Factor (in the x data object) used to split the samples ala split in complex heatmap","Data Faceting",k);this.rW("splitVariablesBy",false,"Factor (in the z data object) used to separate the variables ala split in complex heatmap","Data Faceting",k);this.uT("splitSeparation",10,"Length in pixels to separate the splits in samples and variables","Data Faceting",k);this.Rh("timeFormat","isoDate",["default","shortDate","mediumDate","longDate","fullDate","shortTime","mediumTime","longTime","isoDate","isoTime","isoDateTime","isoUtcDateTime","year","month","day","hour","minute","second"],"Time Format according to date.format.js Steven Levithan <stevenlevithan.com>","Data Time Series",k);this.bq("isGraphTime",false,"Flag to indicate if the data is a time series so there is no need to plot every time interval. It is boolean in one dimensional plots or a string indicating the axis which is timed x, y or z","Data Time Series",k);this.ck("timeValues",[],"Array containing the tick values when the the graph is a time series","Time Series",false);this.ck("timeValueIndices",[],"Array containing the indices of the values when the the graph is a time series","Time Series",false);this.kK("timeValueProperties",{},"Object with all the time properties needed to plot the data","Time Series",false);this.Rh("sortDir","ascending",["ascending","descending"],"Default direction for data sorting. Almost private parameters used within the different CanvasXpress UIs","Data Sorting",k);this.bq("sortCaseSensitive",false,"Whether to use case sensitive in ascii sorting. Almost private parameters used within the different CanvasXpress UIs","Data Sorting",k);this.ck("sortData",[],"Array of arrays with sorting functions. Each function takes three parameters. The first parameter must be either smp to identify the parameters are related to the samples, var to identify  the parameters are related to the variables, or cat to identify a sample or variable category. The second parameter can be either smp to indicate to sort the sample indices or var to indicate to sort the variable indices. The third parameter is the value for the key referenced by the first parameter. A special case for this parameter could be samples or variables to indicate to sort by the names of the samples or variables respectively. Here are some examples to sort the samples in the data: [ [cat, smp, Factor1] ]   : Sort the samples by the sample category Factor1 [ [var, smp, Variable1] ] : Sort the samples by the value of the Variable1 [ [cat, smp, samples] ]   : Sort the samples by their name.  Important!!!! This parameter will clean the data and remove any variables not used in the dataset at load time","Data Sorting",k);this.Rh("sortOnGrouping",false,[false,"ascending","descending"],"Sort the name of the groups after sample grouping.<br>","Data Sorting",k);this.bq("sortIncludeEmpty",true,"Include empty groups when sorting","Data Sorting",k);this.QE("missingData","rgb(245,245,245)","missing data","Missing Data",k);this.rW("missingDataValue","NA","String value use to specify missing data","Missing Data",k);this.bq("nanOmit",false,"Flag to omit NaN values in log transformation","Missing Data",k);this.S4("ErrorBars",true,"error bars in graphs","Error Bars",k);this.Rh("errorBarsType","confidenceInterval95",["standardDeviation","standardErrorMean","confidenceInterval95"],"Type of error bars","Error Bars",k);this.QE("errorBars","rgb(0,0,0)","error bars in dotplots and barplots","Error Bars",k);this.oL("errorBarsThickness",3,"Thickness for the error bars in dotplots","Error Bars",k);this.uT("errorBarsWidth",2,"Minimum size of the bar in pixels to determine to show or hide error bar ends in the graphs when available","Error Bars",k);this.Rh("standardDeviationType","unbiased",["biased","unbiased"],"Type of Standard Deviation. biased uses n as denominator and unbiased uses (n - 1) as denominator where n is the number of values","Error Bars",k);this.uT("randomSeed",8,"Specifies the random seed number to create pseudo random numbers","Random",k);this.bq("pseudoRandom",true,"Flag to indicate to use pseudo random rather than random","Random",k);this.Rh("randomMethod","numericalRecipes",["jenkins","numericalRecipes"],"Random method","Random",k);this.bq("randomData",false,"Flag to indicate random data for debug and demonstration purposes","Random",false);this.Rh("randomDataDistribution","biased",["range","normal","uniform","symmetrical","biased"],"Distribution for the random data","Random",k);this.bq("randomDataTime",false,"Flag to create or not time series random data for debug and demonstration purposes","Random",k);this.uT("randomDataMin",1,"Minimun value when creating random data","Random",k);this.uT("randomDataMax",100,"Maxmun value when creating random data","Random",k);this.uT("randomDataMean",0,"Mean value when creating random data","Random",k);this.uT("randomDataSigma",1,"Sigma value when creating random data","Random",k);this.uT("randomDataVariables",3,"Default number of variables when creating random data","Random",k);this.uT("randomDataSamples",36,"Default number of samples when creating random data","Random",k);this.uT("randomDataVariableAnnotations",2,"Default number of variable annotations when creating random data","Random",k);this.uT("randomDataSampleAnnotations",2,"Default number of sample annotations when creating random data","Random",k);this.oL("randomMissingDataPercentage",0,"Default percentage of missing values when creating random data. A value between 0 and 1","Random",k);this.bq("randomNetworkReduce",true,"Flag to create or not a single random network for debug and demonstration purposes","Random",k);this.uT("randomNetworkNodes",40,"Default number of nodes when creating random networks","Random",k);this.uT("randomNetworkNodeEdgesMax",5,"Default number of maximum edges when creating random networks","Random",k);this.bq("randomNetworkAll",true,"Use all types of colors, shapes and edges in random network, otherwise only one color, one shape and straight black lines for the edges","Random",k);this.Rh("randomNetworkLayout","forceLayout",["forceDirected","circular","radial","duo","trio","pentagon","hexagon","octagon","star","small","medium","large","huge","lesmiserables","karate"],"Random network layout","Random",k);this.oL("zoom",1,"Zoom factor for the networks. A number greater than zero","Zooming, Panning and Resizing",k);this.oL("zoomGlobal",1,"Cumulative zoom factor for the networks","Zooming, Panning and Resizing",false);this.oL("zoomStep",0.2,"Percentage step for zooming networks and genome panel","Zooming, Panning and Resizing",k);this.bq("zoomScale",true,"Flag to scale nodes and edges in networks with zoom and data points in 3D scatter plots","Zooming, Panning and Resizing",k);this.bq("zoomVariablesDisable",false,"Flag to disable zooming of variables with mouse wheel in Heatmaps","Zooming, Panning and Resizing",k);this.bq("zoomSamplesDisable",false,"Flag to disable zooming of samples with mouse wheel in Heatmaps","Zooming, Panning and Resizing",k);this.bq("zoomDisable",false,"Flag to disable zooming in all plots","Zooming, Panning and Resizing",k);this.oL("panningX",0,"Number of unit to pan the network in the X dimension","Zooming, Panning and Resizing",k);this.oL("panningY",0,"Number of unit to pan the network in the Y dimension","Zooming, Panning and Resizing",k);this.oL("panningGlobalX",0,"Cumulative number of unit to pan the network in the X dimension","Zooming, Panning and Resizing",false);this.oL("panningGlobalY",0,"Cumulative number of unit to pan the network in the Y dimension","Zooming, Panning and Resizing",false);this.oL("panningStep",0.2,"Percentage step for panning networks","Zooming, Panning and Resizing",k);this.QE("resizerBackground","rgba(204,204,204,0.7)","div that shows up when resizing the canvas","Zooming, Panning and Resizing",k);this.gl("x","X axis","X-Axis",k);this.gl("y","Y axis","Y-Axis",k);this.gl("z","Z axis","Z-Axis",k);this.bq("rAxisPercentShow",true,"Flag to show on not the percent in each segment in the R axis","R-Axis",k);this.Rh("rAxisLabelOrientation","perpendicular",["perpendicular","circular"],"Orientation to show the ticks values in circular plots","R-Axis",k);this.gl("r","R axis","R-Axis",k);this.oL("axisExtension",0.1,"Percentage to extend the values of the data to ensure all the data points are plotted inside and not over the edges of the graph","Axis",k);this.Rh("axisAlgorithm","rPretty",["heckbert","wilkinson","wilkinsonExtended","rPretty"],"Algorithm used to position tick labels on axes. See An Extension of Wilkinson’s Algorithm for Positioning Tick Labels on Axes. Justin Talbot, Sharon Lin, Pat Hanrahan","Axis",k);this.bq("axisWilkinsonLoose",false,"Flag to indicate whether to use loose positioning when using the wilkinson algorithm to position the labels on the axis. There will not be a difference most of the times","Axis",k);this.bq("axisCoordinate",false,"Flag to coordinate xAxis and xAxis2 in *-Line combination plots","Axis",k);this.oL("setMax",null,"Maximum value to set the data","Axis",false);this.oL("setMin",null,"Minimum value to set the data","Axis",false);this.Rh("guides",false,[false,"solid","dotted","dashed","dotdash","longdash","twodash"],"This is a thin line that appears in the middle of the variables and / or samples in one dimensional graphs and multidimensional heatmaps just for aesthetics","Plot area",k);this.oL("guidesWidth",1,"The width for the thin line that appears in the middle of the variables and / or samples in one dimensional graphs and multidimensional heatmaps just for aesthetics","Plot area",k);this.QE("guides","rgb(204,204,204)","thin line that appears in the middle of the variables and / or samples in one dimensional graphs and multidimensional heatmaps just for aesthetics","Plot area",k);this.bq("blockContrast",false,"A flag to creates a shade between the samples so there are two backgrounds, one for the odd samples and one for the even samples","Plot area",k);this.bq("plotByVariable",false,"Flag to indicate whether to group the data variable rather than by sample","Plot area",k);this.bq("is3DPlot",false,"Flag to create or not a 3D plot","Plot area",k);this.S4("DataValues",false,"data values in the one bar graphs","Plot area",k);this.bq("binned",false,"Flag to bin the data points in dotplots and boxplots","Plot area",k);this.Rh("binAlignment","center",["left","center","right"],"Alignment for the data points when binned","Plot area",k);this.bq("jitter",false,"Flag to jitter the data points in dotplots, boxplots and scatter2D plots","Plot area",k);this.oL("jitterFactor",0.8,"Factor for jittering. The larger the more jitter","Plot area",k);this.bq("sina",false,"Flag to jitter the data points in dotplots, boxplots and scatter2D plots with sina style","Plot area",k);this.QE("objectBorder","rgb(0,0,0)","border of all objects in one dimensional graphs. It turns into the non-transparent fill color if set to false","Plot area",k);this.oL("objectColorTransparency",1,"The transparency for the color fill of all objects in one dimensional graphs. A value between 0 and 1","Plot area",k);this.uT("dotplotOutlineThreshold",5000,"Maximum number of data points before skipping plotting their outline but only the fill color","Plot area",k);this.bq("linesOnGroups",true,"Flag to create lines on groups when multiple grouping factors are used","Plot area",k);this.Rh("lineDecoration","symbol",[false,"dot","symbol","pattern"],"Lines decorations in the line graphs","Line Graphs",k);this.Rh("lineErrorType","bar",["bar","area"],"Line error type in the line graphs. The line type must be spline for the area error type. ","Line Graphs",k);this.bq("coordinateLineColor",false,"Flag to used same color in BarLine plots. If set to true the color of the bars and the lines will be coordinated","Line Graphs",k);this.Rh("lineType","rect",["rect","solid","spline","dotted","dashed","dotdash","longdash","twodash"],"Type of line used to join the points in line graphs","Line Graphs",k);this.oL("tension",0.3,"Curvature for the splines and hulls","Line Graphs",k);this.uT("tensionSegments",16,"Number of segments to smooth a quadratic curve","Line Graphs",k);this.ck("parallelCoordinates",[],"Array used to store and handle a parallel coordinates plot","Parallel Coordinates Graphs",false);this.uT("boxplotOutliersRatio",10,"Ratio for the size of the outliers with respect to boxplot","Boxplot Graphs",k);this.QE("boxplotOutliers",false,"outlier data points in boxplots","Boxplot Graphs",k);this.QE("boxplotOutliersBorder",false,"border of outlier data points in boxplots","Boxplot Graphs",k);this.Rh("boxplotOutliersShape","circle",["circle","square","triangle","diamond","plus","minus","star","circleOpen","squareOpen","triangleOpen","diamondOpen"],"Shape for the outlier data points","Boxplot Graphs",k);this.Rh("boxplotWhiskersType","double",["single","double","none"],"Boxplot whiskers type","Boxplot Graphs",k);this.Rh("boxplotType","boxWhiskers",["boxWhiskers","range"],"Boxplot type","Boxplot Graphs",k);this.bq("boxplotNotched",false,"Flag to notch boxplots","Boxplot Graphs",k);this.oL("boxplotTransparency",0.4,"Fraction to adjust color transparency for the boxplot id individual data points are shown","Boxplot Graphs",k);this.QE("boxplot",false,"boxplot if individual data points are shown","Boxplot Graphs",k);this.bq("boxplotVarWidth",false,"Flag to adjust the width of boxplots. Similar to R if true then the width is proportional to the sqare root of the number of observations","Boxplot Graphs",k);this.oL("boxplotCoef",1.5,"Number that determines how far the plot ‘whiskers’ extend out from the box","Boxplot Graphs",k);this.Rh("boxplotHingeFunction","summary",["summary","fivenum"],"Function to calculate the boxplor hinges. See https://chemicalstatistician.wordpress.com/2013/08/12/exploratory-data-analysis-the-5-number-summary-two-different-methods-in-r-2/","Boxplot Graphs",k);this.S4("BoxplotOriginalData",false,"observed data point in boxplots. (Should be called showBoxplotDataPoints)","Boxplot Graphs",k);this.oL("boxplotDataPointTransparency",0.8,"Fraction to adjust color transparency for the data points when displaying original data in boxplots","Boxplot Graphs",k);this.QE("boxplotBorder","rgb(0,0,0)","line of the borders in boxplots","Boxplot Graphs",k);this.QE("boxplotMedian",false,"line of the median of data in boxplots","Boxplot Graphs",k);this.uT("boxplotMedianWidth",2,"Width for the line of the median of data in boxplots","Boxplot Graphs",k);this.bq("boxplotMean",false,"Flag to show mean of data in boxplots","Boxplot Graphs",k);this.QE("boxplotMean","rgb(255,215,0)","data mean in boxplots","Boxplot Graphs",k);this.QE("boxplotMeanBorder","rgb(255,0,0)","border of the data mean in boxplots","Boxplot Graphs",k);this.bq("boxplotConnect",false,"Flag to show data in boxplots connected","Boxplot Graphs",k);this.uT("boxplotConnectWidth",2,"Width for the line of the connection of boxes in boxplots","Boxplot Graphs",k);this.S4("ViolinBoxplot",false,"violin plot in boxplots","Violin Plots",k);this.bq("violinTrim",true,"Flag to trim violin plots","Violin Plots",k);this.Rh("violinScale","width",["area","count","width"],"Type for scaling violin plots","Violin Plots",k);this.S4("BoxplotIfViolin",true,"boxplots when violin plot are show. It does not affect anything unless violins are shown","Violin Plots",k);this.oL("boxplotWidthRatioIfViolin",0.33,"A number between 0.1 and 1 to adjust the width of the boxplot when violins are shown. It does not affect anything unless violins are shown","Violin Plots",k);this.oL("violinTransparency",0.4,"Fraction to adjust color transparency for the violins","Violin Plots",k);this.QE("violin",false,"violins. If specified all the violins will have the assigned color; otherwise it will be automatically assigned","Violin Plots",k);this.QE("violinBorder","rgb(0,0,0)","violin borders","Violin Plots",k);this.S4("ViolinQuantiles",false,"quantile 0.25 and 0.75 in violin plots","Violin Plots",k);this.Rh("areaType","normal",["normal","stacked","percent"],"Flag to produce normal, stacked, center or percent area graphs","Area Graphs",k);this.Rh("dotplotType","normal",["normal","stacked","movement"],"Flag to produce normal, stacked or movement dotplot graphs. Movement plot are only applicable when data is grouped","Dotplot Graphs",k);this.Rh("barType","normal",["normal","lollipop","arrow","swimmer"],"Flag to produce normal or lollipop bar graphs","Bar Graphs",k);this.bq("barPath",false,"Show the path for the bar graph","Bar Graphs",k);this.bq("barPathTransparency",0.1,"Transparency for the bar graph path","Bar Graphs",k);this.QE("barPath",false,"bar graph path. If false, it will default to the color of the graph","Bar Graphs",k);this.uT("barLollipopFactor",1.5,"Ratio for the top (dot) of the lollipop in bar graphs. The higher the value the bigger the lollipop. See widthFactor to adjust the bar width (choose a value between 0.5 and 0.6)","Lollipop Graphs",k);this.bq("barLollipopOpen",false,"Pattern open for th lollipop","Lollipop Graphs",k);this.Rh("swimHigh",false,[false],"Variable to use in Swimmer plot. Defaults to the first variable in the data set. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/","Swimmer Graphs",k);this.Rh("swimStart",false,[false],"Variable to use in Swimmer Plot. Defaults to the second variable in the data set. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/","Swimmer Graphs",k);this.Rh("swimEnd",false,[false],"Variable to use in Swimmer Plot. Defaults to the third variable in the data set. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/","Swimmer Graphs",k);this.Rh("swimStatus",false,[false],"Name of sample annotation to use in Swimmer Plot. Defaults to Status. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/","Swimmer Graphs",k);this.Rh("swimHighCap",false,[false],"Name of sample annotation to use in Swimmer Plot. Defaults to High Cap. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/","Swimmer Graphs",k);this.Rh("ganttStart",false,[false],"Variable to use in Gantt plots as start date. Defaults to the first variable in the data set","Gantt Charts",k);this.Rh("ganttEnd",false,[false],"Variable to use in Gantt plots as end date. Defaults to the second variable in the data set","Gantt Charts",k);this.Rh("ganttCompletion",false,[false],"Variable annotation in the x object to use in Gantt plots as completion percentage. Must be a value between 0 and 1","Gantt Charts",k);this.Rh("ganttDependency",false,[false],"Variable annotation in the x object to use in Gantt plots as dependency. Must be a valid sample / group name","Gantt Charts",k);this.Rh("ganttDependencyEnd",false,[false],"Variable annotation for the type of ending for the dependency line. Options are arrow, square or round","Gantt Charts",k);this.QE("ganttDependency",false,"variable metadata used for the dependency line. Defaults to rgb(0,0,0)","Gantt Charts",k);this.oL("ganttDependencyThickness",false,"Variable annotation for the thickness of the dependency line. Defaults to 1","Gantt Charts",k);this.oL("ganttCompletionTransparency",0.5,"Fraction to adjust color transparency for completion","Gantt Charts",k);this.Rh("meterType","gauge",["gauge","speedometer","vertical","horizontal","state","digital","number"],"Type of meter. ","Meter Graphs",k);this.oL("meterMin",null,"Minimum value in the meter","Meter Graphs",k);this.oL("meterMax",null,"Maximum value in the meter","Meter Graphs",k);this.oL("meterStart",270,"Start value for the meter in degrees","Meter Graphs",k);this.oL("meterEnd",90,"End value for the meter in degrees","Meter Graphs",k);this.ck("meterSegments",[],"Meter Segments","Meter Graphs",k);this.ck("meterColors",[],"Meter Colors","Meter Graphs",k);this.Rh("meterColorScheme","Spectral",["YlGn","YlGnBu","GnBu","BuGn","PuBuGn","PuBu","BuPu","RdPu","PuRd","OrRd","YlOrRd","YlOrBr","Purples","Blues","Greens","Oranges","Reds","Greys","PuOr","BrBG","PRGn","PiYG","RdBu","RdGy","RdYlBu","Spectral","RdYlGn","Accent","Dark2","Paired","Pastel1","Pastel2","Set1","Set2","Set3","Default","Basic","Light","Favorite","Pastel","Balanced","Rpalette","RlatticeBackground","RlatticeShingle","RlatticeLine","RlatticePolygon","Bootstrap","Economist","EconomistBG","Excel","Excel2","Excel3","GGPlot","Solarized","SolarizedBase","PaulTol","ColorBlind","Tableau","TableauGrey","TableauColorBlind","TableauTrafficLight","TableauPurpleGrey","TableauBlueRed","TableauGreenOrange","TableauCyclic","TableauPairSequential","TableauTripleDiverging","WallStreetJournal","WallStreetJournal2","WallStreetJournal3","WallStreetJournalRedGreen","WallStreetJournalBlackGreen","WallStreetJournalDemRep","Stata","Stata2","Stata3","StataMono","BlackAndWhite","CanvasXpress","CanvasXpressT"],"Color schemes can be user defined which will take the colors in the color property or one provided in canvasXpress. The order of the colors will be used to sequentially select when a different color is needed in a particular visualization","Meter Graphs",k);this.Rh("meterVar",false,[false],"Name of the variable use to create the meter. The first variable will be used if not specified or if it is non-valid","Meter Graphs",k);this.Rh("meterGroup",false,[false],"Name of the sample category to use to create the meters","Meter Graphs",k);this.Rh("meterSummary","average",["count","average","sum","percentage","percentageTotal","countTotal","sumTotal"],"Summary to calculate for the meters","Meter Graphs",k);this.Rh("meterTopology","auto",["auto","grid","horizontal","vertical"],"Topology set up for the meters","Meter Graphs",k);this.uT("meterIndex",0,"Variable index to use creating a meter when there are multiple variables","Meter Graphs");this.QE("meterNeedle","rgb(0,0,0)","Meter Needle Color","Meter Graphs",k);this.QE("meterBackground","rgb(229,229,229)","Meter Background Color","Meter Graphs",k);this.uT("meterThickness",50,"Thickness in pixels for the vertical, horizontal and state meters","Meter Graphs",k);this.ck("fishParents",[],"Fish Parents","Fish Graphs",k);this.ck("fishTimepoints",[],"Fish Timepoints","Fish Graphs",k);this.bq("fishSeparateIndependentClones",false,"Separate indepenent clones","Fish Graphs",k);this.Rh("fishShape","polygon",["spline","polygon"],"Fish Shape","Fish Graphs",k);this.ck("fishAxis",[],"Fish Axis (array with lines across the X Axis)","Fish Graphs",k);this.ck("fishAxisLabels",[],"Fish Axis Labels (array with names for the lines across the X Axis). Must have the same dimension as the fishAxis","Fish Graphs",k);this.ck("fishCloneLabels",[],"Fish Clone Labels (array with names for the clones). Must have the same dimension as the fishParents","Fish Graphs",k);this.uT("sankeyNodeWidth",20,"Width for the Sankey nodes","Sankey Diagrams",k);this.uT("sankeyNodePadding",10,"Padding between the Sankey nodes","Sankey Diagrams",k);this.uT("sankeyIterations",32,"Number of iterations for the Sankey diagram. Stting iterations to zero will not reordser the nodes","Sankey Diagrams",false);this.Rh("sankeySource",false,[false],"Name of a sample annotation to use as source in the sankey diagrams","Sankey Diagrams",k);this.Rh("sankeyTarget",false,[false],"Name of a sample annotation to use as target in the sankey diagrams","Sankey Diagrams",k);this.QE("sankeyNodes","rgb(255,255,255)","sankey nodes","Sankey Diagrams",k);this.QE("sankeyLinks","rgba(150,150,150,0.5)","sankey lines (links)","Sankey Diagrams",k);this.QE("sankeyOutline","rgba(0,0,0,0)","sankey outline","Sankey Diagrams",k);this.bq("sankeyCoordinateColor",false,"Flag to use same color for the nodes and for the lines (links) in the Sankey diagram","Sankey Diagrams",k);this.Kv("sankeyLabel","","rgb(0,0,0)",11,1,"center","middle",90,0,"sankey diagram labels","Sankey Diagrams",k);this.g1("sankeyLabel",true,"labels in the Sankey diagrams","Sankey Diagrams",k);this.Kv("sankeyTitle","","rgb(0,0,0)",11,1,"center","middle",0,0,"sankey diagram titles","Sankey Diagrams",k);this.g1("sankeyTitle",true,"titles in the Sankey diagrams","Sankey Diagrams",k);this.ck("sankeyAxes",[],"Axes to include in the alluvial/sankey plot. It must sample annotations of the string type in the x object","Sankey Diagrams",k);this.ck("hierarchy",[],"Hierarchy for trees and bubble graphs made up of sample annotations present the data x object","Hierarchy",k);this.rW("hierarchyVar",false,"Variable name to use in the sankey, sunburst and bubble graphs. This is used when the data set has more than a single variable. Otherwise the first variable will be selected","Hierarchy",k);this.uT("hierarchyVarIndex",0,"Variable index to use in the sankey, sunburst and bubble graphs","Hierarchy",false);this.uT("treeNodeSize",5,"Size for the Tree nodes","Trees",false);this.QE("treeLink","rgb(150,150,150)","tree lines (links)","Trees",k);this.QE("treeNodeOutline","rgb(83,105,255)","tree node outline","Trees",k);this.uT("treeLinkWidth",1,"Width for the Tree lines","Trees",k);this.bq("treeCircular",false,"Flag to plot a circular tree layout","Trees",k);this.bq("treeInverted",false,"Flag to plot the tree inverted","Trees",k);this.uT("treeVarIndex",0,"Variable index to use in the tree diagrams","Trees",false);this.uT("treeNodeId",0,"Id for the nodes in the tree","Trees",false);this.bq("variableShowLegend",true,"Flag to show the variable legend","Data Point Attributes",k);this.bq("sampleShowLegend",true,"Flag to show the sample legend. Not implemented!!!!!","Data Point Attributes",k);this.Rh("colorBy",false,[false,"variable"],"Name of a variable annotation or a sample name or the string variable to color the variables","Data Point Attributes",k,"getXZData");this.bq("colorByShowLegend",true,"Flag to show the colorBy legend","Data Point Attributes",k);this.kK("colorKey",false,"Object to assign custom colors to sample annotations and variable annotations included in the data object. The key of the object is the name of an annotation in the data.x object, or the name of an annotation in the data.z object. The value for each key could be either: (1) a scalar with a valid color scheme (see this.meta.def.colorSchemes), or (2) an array with valid colors, or (3) an object to specify custom colors for each of the values of the annotation. A default color will be assigned to a data point whose value was not included the object. CanvasXpress will handle string and numeric annotation approprietly. However, if an object is specified like that one in number (3) the annotation will be treated as categorical even if the annotation is numeric","Data Point Attributes",k);this.rW("colorByData",false,"String that identify the object containing a two dimensional array with discrete values used to color data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data2)","Data Point Attributes",k);this.rW("colorLegendTitle",false,"Title for the color legend","Data Point Attributes",k);this.Rh("shapeBy",false,[false,"variable"],"Name of a variable annotation or a sample name or the string variable to shape the variables. When shapeByData is specified shapeBy is used for the title in the legend","Data Point Attributes",k,"getXZData");this.bq("shapeByContinuous",false,"Flag to use pie shapes with continuous data as opposed to by binning the data and show regular shapes","Data Point Attributes",k);this.bq("shapeByShowLegend",true,"Flag to show the shapeBy legend","Data Point Attributes",k);this.kK("shapeKey",false,"Object to assign custom shapes to sample annotations and variable annotations included in the data object. The key of the object is the name of an annotation in the data.x object or the name of an annotation in the data.z object. A default shape will be assigned to a data point whose value was not included the object","Data Point Attributes",k);this.rW("shapeByData",false,"String that identify the object containing a two dimensional array with values used to shape data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data2)","Data Point Attributes",k);this.Rh("shapeByShape",false,[false,"sphere","square","triangle","star","rhombus","octagon","oval","plus","minus","mdavid"],"String that identify the shape to use in regular and multidimensional heatmaps. shapeByData will take precedence over this property","Data Point Attributes",k);this.rW("shapeLegendTitle",false,"Title for the shape legend","Data Point Attributes",k);this.Rh("sizeBy",false,[false,"variable"],"Name of a variable annotation or a sample name or the string variable to size the variables. When sizeByData is specified sizeBy is used for the title in the legend","Data Point Attributes",k,"getXZData");this.bq("sizeByContinuous",false,"Flag to show the size data continuously as opposed to by binning the sizes","Data Point Attributes",k);this.bq("sizeByShowLegend",true,"Flag to show the sizeBy legend","Data Point Attributes",k);this.kK("sizeKey",false,"Object to assign custom sizes to sample annotations and variable annotations included in the data object. The key of the object is the name of an annotation in the data.x object or the name of an annotation in the data.z object. A default size will be assigned to a data point whose value was not included the object","Data Point Attributes",k);this.rW("sizeByData",false,"String that identify the object containing a two dimensional array with values used to size data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data3)","Data Point Attributes",k);this.rW("sizeLegendTitle",false,"Title for the size legend","Data Point Attributes",k);this.rW("outlineBy",false,"Name of the annotation for the outline when drawing a multidimensional Heatmap","Data Point Attributes",k,"getXZData");this.bq("outlineByShowLegend",true,"Flag to show the outlineBy legend","Data Point Attributes",k);this.rW("outlineByData",false,"String that identify the object containing a two dimensional array with values used to color the outline data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data4)","Data Point Attributes",k);this.Rh("patternBy",false,[false,"variable"],"Name of a variable annotation or a sample name or the string variable to pattern the variables. When patternByData is specified patternBy is used for the title in the legend","Data Point Attributes",k,"getXZData");this.bq("patternByShowLegend",true,"Flag to show the patternBy legend","Data Point Attributes",k);this.kK("patternKey",false,"Object to assign custom patterns to sample annotations and variable annotations included in the data object. The key of the object is the name of an annotation in the data.x object or the name of an annotation in the data.z object. A default pattern will be assigned to a data point whose value was not included the object","Data Point Attributes",k);this.rW("patternByData",false,"String that identify the object containing a two dimensional array with values used to pattern the data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data4)","Data Point Attributes",k);this.Rh("connectBy",false,[false],"Name of a variable annotation to connect the variables","Data Point Attributes",k,"getXZData");this.bq("connectByNoColor",false,"Flag to prevent coloring the lines by the connectBy annotation. Usefull when connectBy is used along with colorBy to avoid confusion of colors","Data Point Attributes",k);this.QE("connectBy","rgb(204,204,204)","connectBy lines","Data Point Attributes",k);this.uT("connectByWidth",2,"Width for the line of the connectBy line","Data Point Attributes",k);this.bq("connectByShowLegend",true,"Flag to show the connectBy legend","Data Point Attributes",k);this.kK("connectKey",false,"Object to assign custom colors to lines when samples are connected by a sample annotations included in the data object. The key of the object is the name of an annotation in the data.x object. A default connect will be assigned to a data point whose value was not included the object","Data Point Attributes",k);this.kK("connectByData",{},"Internal object with connectBy data","Data Point Attributes",false);this.ck("treemapBy",[],"Array of sample annotations to treemap the variables. The array may also include sample to use as last level","Data Point Attributes",k,"getXZData");this.Rh("stackBy",false,[false],"Name of a sample annotation to stack the samples of each variable in Bar graphs","Data Point Attributes",k,"getZData");this.Rh("dodgeBy",false,[false],"Name of a sample annotation to dodge the samples of each variable in Bar graphs","Data Point Attributes",k,"getXData");this.Rh("lineBy",false,[false],"Name of a sample annotation to stack the samples of each variable in Line graphs","Data Point Attributes",k,"getXData");this.bq("lineByShowLegend",true,"Flag to show the lineBy legend","Data Point Attributes",k);this.Rh("ribbonBy",false,[false],"Name of a sample annotation(s) to create a ribbon of each variable in scatter plots. If a single annotation is passed then it will be used as a standard deviation. If two annotations are passed then, it will be used as upper and lower confidence intervals. Alternatively it could be a pair of arrays witht the actual data. Works in coordination with the lineBy parameter","Data Point Attributes",k);this.Rh("motionBy",false,[false,"variable"],"Utility to create dynamic filtering of data in Scatter plots","Data Point Attributes",k);this.Rh("markerBy",false,[false,"variable"],"Utility to create dynamic markers in Map. It must have a latitude and longitude metadata too","Data Point Attributes",k);this.Rh("ellipseBy",false,[false,"variable"],"Utility to create error ellipses in Scatter plots","Data Point Attributes",k,"getZData");this.Rh("confidenceBy",false,[false,"variable"],"Name of a variable annotation to color the confidence intervals","Data Point Attributes",k,"getZData");this.Rh("ridgeBy",false,[false],"Utility to create ridgelines in Scatter2D plots","Data Point Attributes",k);this.Rh("colorLabelBy",false,[false],"Name of the variable annotation to color the labels in Scatter2D plots","Data Point Attributes",k,"getZData");this.bq("colorLabelByShowLegend",true,"Flag to show the colorLabelBy legend","Data Point Attributes",k);this.Rh("sizeLabelBy",false,[false],"Name of the variable annotation to size the labels in Scatter2D plots","Data Point Attributes",k,"getZData");this.bq("sizeLabelByShowLegend",true,"Flag to show the sizeLabelBy legend","Data Point Attributes",k);this.uT("motionWidth",250,"Size in pixels for the motion widget when used to reproduce user customizations","Motion Charts",k);this.Kv("motionCurrent","","rgb(0,0,0,0.3)",60,1,"center","middle",0,5,"motion charts","Motion Charts",k);this.Rh("htmlWidget",false,[false],"Name of a variable / sample annotation to filter the data with an external HTML widget. Changes are not reflected when the customizer is open","HTML Widgets",k,"getXZData2");this.Rh("htmlWidgetType","auto",["auto","radio","dropdown","range"],"Type of HTML widget to use. Changes are not reflected when the customizer is open","HTML Widgets",k);this.uT("htmlWidgetHeight",120,"Height in pixels for the HTML widget. Changes are not reflected when the customizer is open","HTML Widgets",k);this.Rh("scatterType",false,[false,"line","bar","dot","area","image","lineImage","lineStep","boxplot","visium","manhattan","bin2d","polygon"],"Type of scatter plot","Scatter Plots",k);this.oL("scatterLineAlpha",1,"Transparency applied to lines in scatter plots","Scatter Plots",k);this.oL("scatterPointAlpha",1,"Thickness applied to data points in scatter plots","Scatter Plots",k);this.oL("groupingFactorWindow",false,"The width for the data when grouping in Scatter2D plots. This is the analogous parameter to cut_width in R. It defaults to a fifth of the data range. The scatterType must be boxplot to take this parameter into effect","Scatter Plots",k);this.QE("function","rgb(0,0,0)","function plots","Scatter Plots",k);this.QE("cXscatter","rgb(0,0,0)","scatter cXplots","Scatter Plots",k);this.S4("DataLabels",false,"data labels in scatter plots","Scatter Plots",k);this.bq("isDataLabels",false,"Flag to put a background in data labels","Scatter Plots",k);this.bq("isDataLabelsBackgroundColor",false,"Flag to use the color in the colorDataLabels as a background in data labels","Scatter Plots",k);this.QX("dataLabelBackground","rgb(255,255,255)","rgb(0,0,0)",0.5,"solid","data labels background","Scatter Plots",k);this.bq("scatterAxesEqual",false,"Keep same range in both axes","Scatter Plots",k);this.uT("scatterOutlineThreshold",50000,"Maximum number of data points before skipping plotting their outline but only the fill color","Scatter Plots",k);this.Rh("scatterStreamType","mirror",["mirror","ridge","proportional"],"Type of stream scatter plot","Stream Plots",k);this.oL("scatterStreamBandwidth",0.75,"Scatter stream bandwidth. Tensor for the wiggles of the stream wiggles. A vaulue between 0 and 1","Stream Plots",k);this.uT("scatterStreamNumber",1000,"Number of values for the wiggles","Stream Plots",k);this.oL("scatterStreamExtraSpan",0.01,"Scatter stream extra extension for the wiggles. A vaulue between 0 and 1 as in percent","Stream Plots",k);this.Rh("scatterStreamTrueRange","both",["both","min_x","max_x","none"],"Expand the X axis","Stream Plots",k);this.ck("scatterStreamWiggles",[],"Order for the streamgraph wiggles","Stream Plots",k);this.bq("visiumFlip",false,"Invert the data in visium plots. ","Visium Plots",k);this.bq("visiumPanning",false,"No panning on visium plots so dragging will always zoom","Visium Plots",k);this.bq("visiumFixedAspectRatio",true,"Fix aspect ratio for visium plots","Visium Plots",k);this.ck("chromosomeLengths",[],"Manhattan Chromosomes length is a sorted array by chromosome with the length in base pairs for each chromosome. It is required when scatterType is manhattan","Manhattan Plots",k);this.rW("manhattanMarkerChromosomeNumber",false,"Sample name included in the data.y.smps object used to map to the chromosome number","Manhattan Plots",k);this.Rh("manhattanMarkerPosition",false,[false],"Sample name included in the data.y.smps object used to map to the position in base pairs","Manhattan Plots",k);this.Rh("manhattanMarkerLogPValue",false,[false],"Sample name included in the data.y.smps object used to map to the negative log 10 p value","Manhattan Plots",k);this.ck("manhattanColors",["rgb(128,128,128)","rgb(135,206,235)"],"Colors for the manhattan plots","Manhattan Plots",k);this.ck("manhattanContrastColor","rgba(0,0,0,0.1)","Manhattan contrast color","Manhattan Plots",k);this.Rh("selectionMode","highlight",["highlight","ghost","name","filter"],"Mode use to highlight selected data points in visualizations","Data Selection",k);this.QE("selection","rgb(255,0,0)","The color used for selected data points when selection mode is to be highlight","Data Selection",k);this.Rh("selectionMetadata",false,[false],"Matadata (or factor) to use to display selected data points instead of the variable name. This metadata has to be in the data.z object. This property is only valid when the selectionMode is name and the visualization is a Scatter plot","Data Selection",k);this.ck("selectedDataPoints",[],"Variable / Sample names of data points (in the data object) to initially select","Data Selection",k);this.bq("isContour",false,"Flag to show the contour","Contours",k);this.bq("contourFilled",false,"Flag to color the contour plot","Contours",k);this.oL("contourFilledTransparency",1,"Transparency applied to the filled contours","Contours",k);this.S4("ContourBands",true,"contour bands","Contours",k);this.QE("contourBands","rgb(0,0,255)","the bands in contours","Contours",k);this.uT("contourLevelWidth",null,"Width of contour levels","Contours",k);this.uT("contourLevelNumber",10,"Numbe of contour levels. Overridden by contourLevelWidth","Contours",k);this.Rh("contourStat","density",["density","ndensity","count"],"Contour density type","Contours",k);this.Rh("contourType","normal",["normal","raster","point"],"Contour type","Contours",k);this.ck("contourLevels",[],"Numeric vector to set the contour levels. It is automatically calculated if not defined using the axisAlgorithm setting and the contourLevelNumber","Contours",k);this.S4("ContourLevel",false,"levels in contours","Contours",k);this.S4("ContourDataPoints",false,"data points in contours","Contours",k);this.QE("contourDataPoints","rgb(0,0,0)","data points in contours when the contour is filled","Contours",k);this.Rh("contourColorScheme","Viridis",["Viridis","YlGn","YlGnBu","GnBu","BuGn","PuBuGn","PuBu","BuPu","RdPu","PuRd","OrRd","YlOrRd","YlOrBr","Purples","Blues","BluesDark","Greens","Oranges","Reds","Greys","PuOr","BrBG","PRGn","PiYG","RdBu","RdGy","RdYlBu","Spectral","RdYlGn","Accent","Dark2","Paired","Pastel1","Pastel2","Set1","Set2","Set3","Default","Basic","Light","Favorite","Pastel","Balanced","Rpalette","RlatticeBackground","RlatticeShingle","RlatticeLine","RlatticePolygon","Bootstrap","Economist","EconomistBG","Excel","Excel2","Excel3","GGPlot","Solarized","SolarizedBase","PaulTol","ColorBlind","Tableau","TableauGrey","TableauColorBlind","TableauTrafficLight","TableauPurpleGrey","TableauBlueRed","TableauGreenOrange","TableauCyclic","TableauPairSequential","TableauTripleDiverging","WallStreetJournal","WallStreetJournal2","WallStreetJournal3","WallStreetJournalRedGreen","WallStreetJournalBlackGreen","WallStreetJournalDemRep","Stata","Stata2","Stata3","StataMono","BlackAndWhite","CanvasXpress","CanvasXpressT"],"Color scheme to use in contours","Contours",k);this.rW("showHistogram",false,"Flag or sample annotation to create histogram. If true is specified then the histogram will be done with all data","Histograms",k);this.oL("histogramBarWidth",false,"Length in pixels for half of the bar width in the 2D scatter plot histogram","Histograms",false);this.bq("histogramRight",true,"Histogram right is a boolean.  If true, the histogram cells are right-closed (left open) intervals","Histograms",k);this.bq("histogramLowest",true,"Histogram lowest is a boolean. If true, an x[i] equal to the breaks value will be included in the first (or last, for right = FALSE) bar","Histograms",k);this.uT("histogramBins",30,"Approximate number of bins in a histogram. It may vary to the actual number used in the histogram to ensure a pretty size for the intervals in the histogram. Default is the same as in ggplot which is 30","Histograms",k);this.ck("histogramBreaks",[],"Numeric vector to set the histogram breaks. It is automatically calculated if not defined using the axisAlgorithm setting and the histogramBins","Histograms",k);this.oL("histogramBinWidth",false,"Width in actual units for the histogram bin","Histograms",k);this.Rh("histogramType","dodged",["dodged","staggered","stacked"],"Type of histogram when multiple series are present","Histograms",k);this.S4("HistogramDensity",false,"density kernel in histograms","Histograms",k);this.S4("HistogramPath",false,"histograms path","Histograms",k);this.S4("FilledHistogramPath",false,"filled histogram path","Histograms",k);this.oL("histogramPathFillTransparency",0.85,"Transparency applied to the filled histogram path","Histograms",k);this.QE("histogramPath",false,"histogram path. If not specified the it defaults to the color of the histogram bars","Histograms",k);this.uT("histogramPathWidth",2,"Width for the line of the histogram path line","Histograms",k);this.S4("FilledHistogramDensity",false,"filled histogram density","Histograms",k);this.oL("histogramDensityFillTransparency",0.85,"Transparency applied to the filled histogram density","Histograms",k);this.S4("HistogramDataPoints",false,"original data point in histograms","Histograms",k);this.S4("HistogramQuantiles",false,"quantile 0.25 and 0.75 in density plots","Histograms",k);this.S4("HistogramMedian",false,"histogram median","Histograms",k);this.Rh("histogramMedianLineType","dashed",["solid","dotted","dashed","dotdash","longdash","twodash"],"Line type for the histogram median","Histograms",k);this.bq("hideHistogram",false,"Flag to hide the histogram bars","Histograms",k);this.Rh("histogramSizeEstimator","sturges",["sturges","freedmanDiaconis","scott"],"Histogram size estimator","Histograms",k);this.Rh("histogramStat","count",["density","count"],"Histogram density type","Histograms",k);this.bq("histogramAsDotplot",false,"Flag to use dots as histogram bars","Histograms",k);this.QX("histogramDotplot","rgb(215,48,39)","rgb(0,0,0)",0.5,"solid","data points in dotplot histograms","Histograms",k);this.bq("histogramStackRatio",1,"Stack ratio for dotplot histograms. I has to be a value between 0 and 1","Histograms",k);this.Rh("histogramStackDir","down",["down","center","centerwhole"],"Direction to stack the dots in dotplot histograms","Histograms",k);this.S4("ScatterDensity",false,"density kernel in histograms","Density Plots",k);this.Rh("densityKernel","gaussian",["gaussian","rectangular","triangular","epanechnikov","quartic","biweight","cosine","optcosine"],"Histogram density kernels","Density Plots",k);this.Rh("densityPosition","normal",["normal","stacked","filled"],"Histogram density position","Density Plots",k);this.Rh("bandwidthRule","nrd0",["nrd0","nrd","silverman"],"Bandwidth rule ","Density Plots",k);this.uT("bandwidthCut",3,"Bandwidth cut","Density Plots",k);this.oL("bandwidthAdjust",1,"Bandwidth adjust for the window","Density Plots",k);this.oL("ridgelineScale",1.5,"Scale for ridgeline","Ridgeline Plots",k);this.bq("ridgelineViolin",false,"Flag to use a violin to calculate the ridgeline plot","Ridgeline Plots",k);this.ny("fitLine","rgb(255,215,0)",1,2,null,"solid",true,"fit line","Fit Lines",k);this.QE("confidenceInterval","rgb(50,50,50)","confidence intervals","Confidence Intervals",k);this.S4("ConfidenceIntervals",true,"confidence intervals in the regression plots ","Confidence Intervals",k);this.oL("confidenceLevel",0.95,"Confidence level for regressions and ellipses","Confidence Intervals",k);this.bq("confidenceIntervalColorCoordinate",false,"Flag to color coordinate the confidence intervals and line fit","Confidence Intervals",k);this.S4("RegressionFit",false,"Flag to show the regression fit in Scatter2D plots","Regression",k);this.S4("RegressionFitEquation",true,"Flag to show the regression fit equation in Scatter2D plots","Regression",k);this.Rh("regressionFitEquationPosition","top",["top","bottom"],"Position for the regression fit equation in Scatter2D plots","Regression",k);this.S4("RegressionFullRange",false,"full range in regression plots","Regression",k);this.Rh("regressionType","linear",["linear","exponential","logarithmic","power","polynomial"],"Type of linear least-squares fitting methods for simple data analysis","Regression",k);this.uT("regressionOrder",2,"Specifies the number of degrees to solve for in polynomial regressions","Regression",k);this.S4("LoessFit",false,"Flag to show the loess fit in Scatter2D plots","Loess",k);this.Rh("loessDegree",2,[0,1,2],"Loess degree. 0 : Constant, 1 : Linear, 2 : Quadratic","Loess",k);this.uT("loessSteps",30,"Loess steps. Number of steps to smooth the line","Loess",k);this.oL("loessBandwidth",0.8,"Loess bandwidth. Thickness for the confidence of the loess curve. A vaulue between 0 and 1","Loess",k);this.oL("loessCell",0.2,"Loess cell. If interpolation is used this controls the accuracy of the approximation via the maximum number of points in a cell in the kd tree. Cells with more than floor(n*span*cell) points are subdivided","Loess",k);this.oL("loessSpan",0.75,"Loess span. Factor to adjust the gaussian shape of the loess curve. A vaulue between 0 and 1","Loess",k);this.uT("loessIteration",4,"Loess iterations","Loess",false);this.bq("loessNormalize",true,"Flag to normalize loess fit in Scatter2D plots","Loess",k);this.Rh("loessFamily","gaussian",["gaussian","symmetric"],"Loess Family. Type of error distribution to be optimized in fitting. The default, gaussian, is fitting with least squares. Fitting with Tukeys biweight M-Estimator is used if family is symmetric","Loess",k);this.Rh("loessSurface","interpolate",["direct","interpolate"],"Loess Surface. The fitted surface to be computed exactly (direct) or via interpolation from a kd tree","Loess",k);this.Rh("loessStatistics","approximate",["approximate","exact"],"LoessStatistics. The statistics to be computed exactly, approximately or not at all? Exact computation can be very slow ","Loess",k);this.S4("KMConfidenceIntervals",true,"confidence intervals in Kaplan-Meier plots ","Kaplan Meier Plots",k);this.oL("kmConfidenceLevel",0.95,"Confidence level for Kaplan Meier plots","Kaplan Meier Plots",k);this.Rh("kmConfidenceIntervalType","log",["ordinary","log","loglog"],"Confidence intervals type for Kaplan Meier estimates","Kaplan Meier Plots",k);this.bq("kmInvertCensored",false,"Flag to indicate whether zero values are censored or not in Kaplan-Meier plots","Kaplan Meier Plots",k);this.bq("kmCensoredRug",false,"Flag to indicate whether to show the censored data as a rug in Kaplan-Meier plots","Kaplan Meier Plots",k);this.rW("kmTable",false,"Data to show in Kaplan-Meier plots. It must be a numeric factor as it will be aligned to the major ticks in the x Axis","Kaplan Meier Plots",k);this.ck("quantiles",["0.25","0.5","0.75"],"Array with quantiles to use in quantile regression plots","Quantile Regression Plots",k);this.S4("QuantileRegressionFit",false,"Quantile Regression fit in Scatter2D plots","Quantile Regression Plots",k);this.ck("binplotBins",[],"Approximate number of bins in a bin plot. It may vary considerably to the actual number used in the bin plot to ensure a pretty size for the intervals in the bin plot. ggplots default is 30","Bin Plots",k);this.ck("binplotBinWidth",[],"Width in actual units for the histogram bin","Bin Plots",k);this.bq("binplotDrop",true,"Flag to drop cells with zero counts in binplots","Bin Plots",k);this.Rh("binplotShape","hexagon",["rectangle","hexagon","oval"],"Type for the shape to use in binplots","Bin Plots",k);this.Rh("binplotColorScheme","BluesDark",["YlGn","YlGnBu","GnBu","BuGn","PuBuGn","PuBu","BuPu","RdPu","PuRd","OrRd","YlOrRd","YlOrBr","Purples","Blues","BluesDark","Greens","Oranges","Reds","Greys","PuOr","BrBG","PRGn","PiYG","RdBu","RdGy","RdYlBu","Spectral","RdYlGn","Accent","Dark2","Paired","Pastel1","Pastel2","Set1","Set2","Set3","Default","Basic","Light","Favorite","Pastel","Balanced","Rpalette","RlatticeBackground","RlatticeShingle","RlatticeLine","RlatticePolygon","Bootstrap","Economist","EconomistBG","Excel","Excel2","Excel3","GGPlot","Solarized","SolarizedBase","PaulTol","ColorBlind","Tableau","TableauGrey","TableauColorBlind","TableauTrafficLight","TableauPurpleGrey","TableauBlueRed","TableauGreenOrange","TableauCyclic","TableauPairSequential","TableauTripleDiverging","WallStreetJournal","WallStreetJournal2","WallStreetJournal3","WallStreetJournalRedGreen","WallStreetJournalBlackGreen","WallStreetJournalDemRep","Stata","Stata2","Stata3","StataMono","BlackAndWhite","CanvasXpress","CanvasXpressT"],"Color scheme to use in binplots","Bin Plots",k);this.uT("maxDOENumber",8,"Maximum number of graphs when creating a DOE","DOE",k);this.ck("includeDOE",[],"Array containing the factors to include when exploring the DOE. If left empty all the factors will be included","DOE",k);this.bq("autoexpandDOE",true,"Flag to automatically expand verticaly the extent of the meta data-plots when changing the size of the graphs","DOE",k);this.bq("extendedDOE",true,"Flag to extend DOE to include variables / samples","DOE",k);this.kK("asDOE",false,"Object with configurations to create DOE","DOE",k);this.Rh("scatterPlotMatrix",false,[true,false],"Could be a boolean to plot a matrix of 2D scatterplots or a sample annotation to color and segregate the plots","Scatter Plot Matrix",k);this.Rh("scatterPlotMatrixType","both",["both","upper","lower","correlation","correlationHistogram","correlationDensity","all","first"],"Type for the matrix of 2D scatterplots. Draw either in both panels, upper only or lower only. Show any combination of correlation, histogram, density and variability (boxplots). Also specify whether to use all versus all or only the first data set","Scatter Plot Matrix",k);this.S4("ScatterPlotMatrixLabels",false,"labels in the scatter plot matrix","Scatter Plot Matrix",k);this.oL("xRotate",45,"Starting number of degrees to rotate graph arround the X axis","3D Attributes",k);this.oL("yRotate",0,"Starting number of degrees to rotate graph arround the Y axis","3D Attributes",k);this.oL("zRotate",0,"Starting number of degrees to rotate graph arround the Z axis","3D Attributes",k);this.oL("x3DRatio",1,"Value between 0 - 1 for adjusting the 3D of the X Axis","3D Attributes",k);this.oL("y3DRatio",1,"Value between 0 - 1 for adjusting the 3D of the Y Axis","3D Attributes",k);this.oL("z3DRatio",1,"Value between 0 - 1 for adjusting the 3D of the Z Axis","3D Attributes",k);this.S4("3DGrid",true,"X,Y,Z grid in 3D plots","3D Attributes",k);this.uT("rotationSensitivity",450,"Factor to adjust the sensitivity of the mouse when rotating the graph","3D Attributes",k);this.uT("rotationStep",2,"Number of degrees used when the plot is automatically rotated","3D Attributes",k);this.oL("perspectiveFactor",2.2,"Factor to use to make the 3D perspective. The higher the number the more perspective. Perspective of zero is no perspective at all","3D Attributes",k);this.QE("outline3D","rgb(0,0,0)","outline of the 3D Scatters","3D Attributes",k);this.uT("varIndicesStart",-1,"Number that indicates starting point for variables in heatmaps when the canvas is zoom in","Heatmap Graphs",false);this.uT("smpIndicesStart",-1,"Number that indicates starting point for samples in heatmaps when the canvas is zoom in","Heatmap Graphs",false);this.uT("grpIndicesStart",-1,"Number that indicates starting point for grouped samples in heatmaps when the canvas is zoom in","Heatmap Graphs",false);this.bq("isMultidimensionalData",false,"Flag to indicate if there is more than a single data set","Heatmap Graphs",false);this.bq("heatmapAutoAdjust",false,"Flag to adjust the color spectrum of the heatmaps when zooming in/out. The full spectrum range will be utilized to cover the selcted cells in the heatmap if the flag is set to true","Heatmap Graphs",k);this.bq("heatmapCellBox",true,"Flag to print a box around the heatmap cells","Heatmap Graphs",k);this.QE("heatmapCellBox","rgb(102,102,102)","heatmap boxes around the cells","Heatmap Graphs",k);this.oL("heatmapCellBoxWidth",1,"Width for the heatmap boxes around the cells","Heatmap Graphs",k);this.wt("heatmapCellBoxColorHighlight","rgb(255,215,0)","highlighted heatmap cells","Heatmap Graphs",k);this.oL("heatmapCellBoxHighlightWidth",1,"Width for the highlighting heatmap boxes around the cells","Heatmap Graphs",k);this.Rh("varTitleLabelPosition","bottom",["bottom","top"],"Position for variable labels","Heatmap Graphs",k);this.Rh("smpTitleLabelPosition","left",["left","right"],"Position for sample labels","Heatmap Graphs",k);this.Rh("heatmapType","normal",["normal","circle","hexagon","upset","correlation"],"Type of Heatmap used to overlay a layer on top of an image. Special for spatial transcriptomics and UpSet plots","Heatmap Graphs",k);this.bq("heatmapCollapse",false,"Flag to collapse cells in heatmaps of type circle or hexagon. If true cells are ploted without outline otherwise the outline is the foreground color","Heatmap Graphs",k);this.S4("HeatmapIndicator",true,"heatmap color indicator","Heatmap Color Indicators",k);this.uT("heatmapIndicatorHeight",40,"Length in pixels for the heatmap indicator","Heatmap Color Indicators",k);this.uT("heatmapIndicatorWidth",200,"Length in pixels for the heatmap indicator line width used for increase the size of the indicator","Heatmap Color Indicators",k);this.bq("adjustAspectRatioHeatmapIndicator",true,"Flag to ensure the heatmap indicator scales appropriately when the graph is rendered or the user manually resizes the graph, the adjustAspectRatio flag must be set to true for the adjustAspectRatioHeatmapIndicator to take effect","Heatmap Color Indicators",k);this.Rh("heatmapIndicatorPosition","right",["topLeft","top","topRight","right"],"Position for the heatmap indicator","Heatmap Color Indicators",k);this.bq("heatmapIndicatorBeforeOverlays",true,"Flag to place the heatmap indicator before the overlay legends","Heatmap Color Indicators",k);this.bq("heatmapIndicatorHistogram",false,"Flag to show histogram in the heatmap indicator","Heatmap Color Indicators",k);this.QE("heatmapIndicatorHistogram","rgb(0,255,255)","heatmap indicator histogram","Heatmap Color Indicators",k);this.bq("isOncoprint",false,"Boolean flag to draw an oncoprint","Oncoprint Graphs",false);this.bq("oncoprintCNA",false,"String to identify the data object to use to draw the copy number alterations; that is the amplifications (which will be colored red) and deletions (which will be colored blue). It MUST be a file with only two categorical levels","Oncoprint Graphs",k);this.bq("oncoprintMUT",false,"String to identify the data object to use to draw the mutations. For example missense, non-synonymous, truncating, etc. Each level will be colored in a shade of green","Oncoprint Graphs",k);this.bq("oncoprintHeatmapSwitch",false,"Switch to Oncoprint or Heatmap visualization. Requieres data in the data object","Oncoprint Graphs",k);this.bq("oncoprintNoAlterations",true,"Switch to show variables and samples without any alterations","Oncoprint Graphs",k);this.bq("oncoprintColSummary",false,"Flag to show column summary in oncoprints","Oncoprint Graphs",k);this.bq("oncoprintRowSummary",false,"Flag to show row summary in oncoprints","Oncoprint Graphs",k);this.S4("HeatmapOncoprint",false,"heatmap along with the oncoprint","Oncoprint Graphs",k);this.Rh("oncoprintHeatmapPosition","bottom",["right","bottom","left","top"],"Position for the heatmap in the oncoprint","Oncoprint Graphs",k);this.bq("isUpSet",false,"Boolean flag to draw an upset plot","UpSet Plots",false);this.uT("nUpSets",5,"Number of sets to draw","UpSet Plots",k);this.uT("nUpSetIntercepts",40,"Number of intercepts to draw","UpSet Plots",k);this.ck("upSetSets",[],"Array containing the names of the sets to include","UpSet Plots",k);this.ck("upSetIntercepts",[],"Array containing the names of the intercepts to include. Sets must be separated by &&","UpSet Plots",k);this.QE("upsetShade","rgb(159,159,159)","row shading in matrix","UpSet Plots",k);this.oL("upsetShadeAlpha",0.1,"Transparency of shading in matrix","UpSet Plots",k);this.oL("upsetMatrixDotAlpha",0.2,"Transparency of the empty intersections points in the matrix","UpSet Plots",k);this.QE("upsetMatrix","rgb(59,59,59)","the intersection points","UpSet Plots",k);this.QE("upsetMainBar","rgb(59,59,59)","the main bar plot","UpSet Plots",k);this.QE("upsetSetsBar","rgb(59,59,59)","set bar plot","UpSet Plots",k);this.oL("upsetPointSizeFactor",1,"Adjust the size of points in matrix plot","UpSet Plots",k);this.oL("upsetLineSizeFactor",1,"Adjust width of lines in matrix plot","UpSet Plots",k);this.oL("upsetMatrixPlotBarRatio",0.7,"Ratio between matrix plot and main bar plot","UpSet Plots",k);this.uT("treemapBorderWidth",3,"Width for the treemap border","Treemap Graphs",k);this.QE("treemapBorder","rgb(204,204,204)","treemap header and border","Treemap Graphs",k);this.Rh("correlationAxis","samples",["samples","variables"],"Axis used for the correlation","Correlation Graphs",k);this.bq("correlationAnchorLegend",false,"Flag to show a region above the correlation plot that anchror a sample/variable to a position","Correlation Graphs",k);this.uT("correlationAnchorLegendAlignWidth",40,"Length in pixels of the height of the correlation anchor legend","Correlation Graphs",k);this.uT("correlationLabelInterval",1,"Interval for the sample or variable labels in the correlation plot","Correlation Graphs",k);this.Rh("correlationType","diamond",["diamond","circle"],"Shape to use in the correlation graphs","Correlation Graphs",k);this.Nm("Var",true,false,"top",false,"variable dendrogram","Dendrograms",k);this.Nm("Smp",true,false,"left",false,"sample dendrogram","Dendrograms",k);this.uT("dendrogramHeight",80,"Size in pixels for the dendrogram","Dendrograms",k);this.QE("dendrogram","rgb(0,0,0)","dendrograms","Dendrograms",k);this.Rh("clusteringDistance","euclidianDistance",["euclidianDistance","manhattanDistance","maxDistance"],"Distance metric to use when clustering data","Clustering",k);this.Rh("linkage","complete",["single","complete","average"],"Linkage type to use when clustering data","Clustering",k);this.Rh("clusterAxis","samples",["samples","variables"],"Axis to use when clustering data","Clustering",k);this.uT("kmeansVarClusters",3,"Number of clusters when clustering variable data with kmeans","Clustering",k);this.uT("kmeansSmpClusters",3,"Number of clusters when clustering sample data with kmeans","Clustering",k);this.uT("maxIterations",500,"Number of maximum iterations when clustering data with kmeans for one dimensional graphs or maximum number of iterations when calculating force direct layout networks","Clustering",k);this.Rh("imputeMethod","mean",["mean","median"],"Imputation method for missing data when clustering","Clustering",k);this.bq("samplesClustered",false,"Configuration property to cluster samples","Clustering",k);this.bq("variablesClustered",false,"Configuration property to cluster variables","Clustering",k);this.bq("samplesKmeaned",false,"Configuration property to k-mean samples","Clustering",k);this.bq("variablesKmeaned",false,"Configuration property to k-mean variables","Clustering",k);this.bq("vennLegendColors",false,"Flag to use the venn colors to use for the legends instead of the letters","Venn Diagrams",k);this.uT("vennGroups",4,"Number of groups in the Venn diagram","Venn Diagrams",k);this.ck("vennCompartments",["A","B","AB","C","AC","BC","ABC","D","AD","BD","CD","ABD","ACD","BCD","ABCD"],"Name for the compartments in the the Venn diagrams","Venn Diagrams",false);this.ck("vennColors",[],"Colors for the Venn bubles. If not specified the colors will be chosen from the colors array. Colors in this array need to be at least the same number of groups in the Venn diagram","Venn Diagrams",k);this.Rh("pieType","separated",["separated","solid"],"Position for the pices of the pie","Pie Charts",k);this.uT("pieSegmentPrecision",0,"Number of decimals for values in the Pie charts","Pie Charts",k);this.uT("pieSegmentSeparation",1,"Length in pixels for the separation of the pieces of the pie charts","Pie Charts",k);this.Rh("pieSegmentLabels","inside",["inside","outside"],"Location for the values in the pie charts","Pie Charts",k);this.Rh("pieLabelType","percentage",["percentage","value"],"Pie label type to show the percentage of the slice or the actual number","Pie Charts",k);this.oL("maxPieSectors",20,"Max pie sectors. After that number the sectors will be put in a sector named other","Pie Charts",k);this.S4("PieValues",true,"values for the pie","Pie Charts",k);this.S4("PieSampleLabel",true,"sample label when plotting multiple pies","Pie Charts",k);this.oL("startPieSectors",270,"Starting degrees for pie sectors. 0 is equivalent to 3:00 oclock","Pie Charts",k);this.oL("pieInnerRadius",0,"Percentage of the radius in the pies to remove to make a donut. It must be a number between 0 to 1","Pie Charts",k);this.ck("pieColors",[],"Pie Colors. Defaults to the parameter colors","Pie Charts",k);this.Rh("circularType","normal",["normal","radar","sunburst","chord","bubble"],"Property to set the subtype of circular graph. If set to sunburst or bubble then smpOverlays can be used to build a hierarchy for the graph","Circular Graphs",k);this.uT("chordThickness",28,"Relative length in pixels of the chord thickness in the circular graphs. Only applicable to the chord subtype","Circular Graphs",k);this.Rh("chordColor","source",["source","target"],"Color the ribbon according to either the source or the target of the connection","Circular Graphs",k);this.QE("bubble","rgba(204,204,204,0.33)","Bubbles. Only applicable to the bubble subtype","Circular Graphs",k);this.QE("bubbleOutline","rgb(0,0,0)","Outline of bubbles. Only applicable to the bubble subtype","Circular Graphs",k);this.Rh("bubbleLabel","auto",["first","last","all","auto","none"],"Position for the labels in bubble circular plot","Circular Graphs",k);this.Rh("bubbleLabelPosition","center",["top","center","down"],"Position for the labels in bubble circular plot","Circular Graphs",k);this.Rh("bubbleLabelLineType","arch",["line","arch"],"Line type when label is away from the bubble","Circular Graphs",k);this.oL("circularCenterProportion",0.3,"Proportion of the center of the circular graph to use as void; that is the fraction of the radius in the middle of the graph","Circular Graphs",k);this.uT("arcSegmentsSeparation",8,"Number of degrees to separate the arc segments in the circular plots. The arc segments can be set with the segregateSampleBy property","Circular Graphs",k);this.uT("circularRotate",0,"Number of degrees to rotate the circular graph to adjust the starting point","Circular Graphs",k);this.uT("circularArc",360,"Number of degrees to extend the circular graph","Circular Graphs",k);this.uT("ringSeparation",5,"Number of pixels to separate the rings in the circular plots","Circular Graphs",k);this.ck("ringGraphType",[],"Array containing the graph type for each ring in the circular plot","Circular Graphs",k);this.ck("ringGraphWeight",[],"Array containing the proportion of the dimensions for each data ring in the circular plot. It must be a value between 0.1 and 1. If not specified then all ring will be weighted the same","Circular Graphs",k);this.ck("arcSegmentsRadius",[],"Array containing the proportion of the radius for each arc segment in the circular plot. If not specified then all radius will be the same. The plot will be scaled based of the largest value in the array","Circular Graphs",k);this.ck("ringsOrder",[],"Array containing the order of the rings. The array includes the levels of the factor specified as either segregateSamplesBy when show the ideogram or segregateVariablesBy when there is no ideogram. It may also include any of the following terms: dendrogram, ideogram, labels, scale, percent and data. If there are sample overlays, the array may also contain any of the factor names include in the this.data.x object. This array supersede any other configurations for example for the sample overlays. CanvasXpress will honored all other configurations if left empty","Circular Graphs",k);this.rW("rAxis",false,"Radial axis for circular plots. It must be the name of a variable. Only applicable to 2 Dimensional circular plots","Circular Graphs",k);this.bq("rAxisZero",false,"Flag to force the rAxis property to start from zero otherwise it starts from the minimum value","Circular Graphs",k);this.S4("CircularConnections",true,"connections in circular graphs","Circular Graphs",k);this.ck("connections",[],"Array to store connections in circular graphs","Circular Graphs",k);this.oL("circularLetterSeparationFactor",1.5,"Factor to adjust the spacing between letters in the circular graphs. The greater the number the closer the letters in the labels","Circular Graphs",k);this.oL("circularConnectionsTransparency",0.5,"Percentage of transparency applied to the connections in the circular graphs","Circular Graphs",k);this.Rh("overlayLevelOrientation","circular",["perpendicular","circular"],"Orientation to show the segregation levels","Circular Graphs",k);this.Rh("smpLabelOrientation","perpendicular",["perpendicular","circular"],"Orientation to show the sample names","Circular Graphs",k);this.Rh("circularLabelsAlign","outside",["inside","outside"],"Position to align the variable and sample names in circular plot","Circular Graphs",k);this.Rh("circularScalesAlign","inside",["inside","outside"],"Position to align the percent and radial axes in circular plot","Circular Graphs",k);this.Rh("circularAnchorsAlign","inside",["inside","outside"],"Position to align the anchors in circular plot","Circular Graphs",k);this.Rh("circularAnchors2Align","outside",["inside","outside"],"Position to align the anchors2 in circular plot","Circular Graphs",k);this.Rh("circularDataPosition","distributed",["absolute","distributed"],"Position to align the data in 2D radial graphs and ideograms","Circular Graphs",k);this.uT("circularAnchorLength",15,"Length in pixels of the height of the circular anchor","Circular Graphs",k);this.QE("circularAnchor","rgb(0,0,255)","circular anchor","Circular Graphs",k);this.rW("ideogramChromosome","chr","Factor name included in the data.z object used to map to the chromosome number","Circular Graphs",k);this.rW("ideogramChromosomePosition","pos","Factor name included in the data.z object used to map to the chromosome position","Circular Graphs",k);this.S4("Ideogram",false,"Human Chromosome Ideogram. Force circular plots to be two dimensional","Ideograms",k);this.Rh("ideogram","hg38",["hg19","hg38"],'Ideogram. Additional ideograms can be loaded by appending to the CanvasXpress.chromosomes object. The format of the ideogram is based on the R data for USCS.hg19.chr<br> CanvasXpress.chromosomes = {<br> &nbsp;&nbsp;hg19 : {<br> &nbsp;&nbsp;&nbsp;&nbsp;order : [ 1, 2, 3, 4, 5, 6, 7, 8, ...],<br> &nbsp;&nbsp;&nbsp;&nbsp;data : {<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1 : [ [ 0, 2300000, "p36.33", "gneg" ], ...],<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2 : [ [ 0, 4300000, "p25.3", "gneg" ],  ...],<br> &nbsp;&nbsp;&nbsp;&nbsp;}<br> &nbsp;&nbsp;}<br> }',"Ideograms",k);this.rW("ideogramChromosomeNumber","1","Chromosome number","Ideograms",k);this.bq("ideogramShowFullChromosome",true,"Show the full chromosome","Ideograms",k);this.Kv("ideogramSegment","","rgb(0,0,0)",10,1,"center","middle",0,8,"ideogram segment","Ideograms",k);this.uT("ideogramHeight",20,"Default size in pixels of the ideogram height","Ideograms",k);this.uT("tagCloudTextWeightFactor",1,"Factor weight for text in tag cloud visualizations","Tag Cloud",k);this.uT("tagCloudTextGridSize",8,"Size for the grid in text tag cloud visualizations","Tag Cloud",k);this.oL("tagCloudTextEllipticity",0.65,"Ellipticity for the for text in tag cloud visualizations","Tag Cloud",k);this.oL("tagCloudTextRotateRatio",0.1,"Ratio for rotation of text in cloud visualizations","Tag Cloud",k);this.Rh("tagCloudShape",false,[false,"circle","cardioid","diamond","square","triangle","triangle2","pentagon","star"],"Shape for the tag cloud","Tag Cloud",k);this.bq("tagCloudMask",false,"Add a shadow for the selected shape","Tag Cloud",k);this.ck("tagCloudGridPoints",[],"Array to keep state of the used space in the tag cloud visualization","Tag Cloud",false);this.bq("calculateLayout",true,"Flag to force or not to calculate the network layout","Network Graphs",k);this.bq("networkFreeze",false,"Flag to prevent autoscaling for the network layout. Useful when images are part of the network","Network Graphs",k);this.uT("networkMaxIterations",15,"Number of iterations to separate subnetworks","Network Graphs",k);this.bq("networkFreezeOnLoad",false,"Flag to prevent autoscaling for the network layout after loading. Useful when images are part of the network","Network Graphs",k);this.bq("preScaleNetwork",false,"Flag to prescale or not the network. This is an aesthetic parameter to make the graph look nicer... Sometimes..","Network Graphs",k);this.bq("ignoreEventlessOrder",false,"Flag to render all nodes at one time rather that rendering first the eventless nodes and then the non-eventless nodes","Network Graphs",k);this.xh("subNetworks",false,"Array to keep independent networks","Network Graphs",false);this.Rh("networkLayoutType","forceDirected",["forceDirected","circular","radial","cola"],"Type of network layout","Network Graphs",k);this.rW("networkRoot",false,"Node Id of the network root","Network Graphs",k);this.bq("isNetworkMetrics",false,"Flag to calculate all network metrics: betweenness, closeness, eccentricity and degree","Network Graphs",k);this.S4("NetworkRadialLayout",false,"radial layout wire","Network Graphs",k);this.bq("is3DNetwork",false,"Flag to create or not a 3D network","Network Graphs",k);this.bq("networkNodesOnTop",true,"Order to use when drawing the nodes and edges in the networks. Useful for very populated netwrok graphs. When is set to true all the edges will be in the background","Network Graphs",k);this.bq("moveParentsWithChildren",false,"Flag to make parents move when a child is moved","Network Graphs",k);this.ck("highlightNode",[],"Name of nodes in the data.nodes object to highlight","Network Graphs",k);this.QE("nodeHighlight","rgb(255,0,0)","highlighted nodes","Network Graphs",k);this.uT("showNodeNameThreshold",50,"Thereshold used to set the limit to hide or display the name of nodes in a network. If the number of nodes exceed this thereshold then the name will not be shown","Network Graphs",k);this.uT("showNodeNameSizeThreshold",20,"Thereshold used to set the limit to hide or display the name of nodes in a network based on the size of the node. If the number of node size exceed this thereshold then the name will be shown","Network Graphs",k);this.uT("nodeSize",15,"Approximate pixels for the size of the nodes in the network. Automatically adjusted depending on the numebr of nodes in the network","Network Graphs",false);this.oL("nodeSizeScaleFactor",1,"Scaling factor for increasing size of all nodes in the network","Network Graphs",k);this.QE("edge","rgb(0,0,0)","edges","Network Graphs",k);this.uT("edgeThickness",1,"Default thickness for the edges in the networks","Network Graphs",false);this.oL("edgeSeparationFactor",1,"Factor to adjust the separation between the edge and the node in the networks","Network Graphs",k);this.Rh("labelNodePosition","auto",["auto","center","top","right","bottom","left"],"Default position for the node label","Network Graphs",k);this.Kv("node","",false,11,1,"center","middle",0,8,"node","Network Graphs",k);this.QE("node","rgb(245,245,245)","nodes","Network Graphs",k);this.rW("networkVendor",false,"Network vendor","Network Graphs",k);this.Rh("networkProgressBarPosition","bottom",["none","bottom","center","top"],"Position for the progress bar","Network Graphs",k);this.oL("networkConvergenceThreshold",0.05,"Threshold for the convergence of the network","Network Algorithm Parameters",k);this.Rh("attractiveForceFunction","square",["square","cubic","log","pow","sqrt"],"Type of function to apply when calculating attractive force in forceDirected network layouts. Fruchterman-Reingold uses square while Eades uses log","Network Algorithm Parameters",k);this.Rh("repulsiveForceFunction","square",["square","cubic","log","pow","sqrt"],"Type of function to apply when calculating repulsive force in forceDirected network layouts. Fruchterman-Reingold uses square while Eades uses log","Network Algorithm Parameters",k);this.bq("useBarnesHutSimulation",false,"Flag to use Barnes–Hut simulation","Network Algorithm Parameters",k);this.bq("networkDisjoint",true,"Flag to use positioning forces rather than centering forces. Applicable only to force directed layouts that contain multiple subnetworks","Network Algorithm Parameters",k);this.oL("networkSpeed",0.1,"Network Speed","Network Algorithm Parameters",k);this.oL("networkGravity",0.75,"Network Gravity","Network Algorithm Parameters",k);this.uT("networkSpringLength",35,"Ideal length for links (springs in physical model)","Network Algorithm Parameters",k);this.oL("networkSpringCoeff",0.0008,"Hooks law coefficient. 1 - solid spring","Network Algorithm Parameters",k);this.oL("networkRepulsion",-1,"Coulombs law coefficient. Its used to repel nodes thus should be negative if you make it positive nodes start attract each other","Network Algorithm Parameters",k);this.oL("networkTheta",0.8,"Theta coefficient from Barnes Hut simulation. Ranged between (0, 1). The closer its to 1 the more nodes algorithm will have to go through. Setting it to one makes Barnes Hut simulation no different from brute-force forces calculation (each node is considered)","Network Algorithm Parameters",k);this.oL("networkDragCoeff",0.09,"Drag force coefficient. Used to slow down system, thus should be less than 1. The closer it is to 0 the less tight system will be","Network Algorithm Parameters",k);this.uT("networkTimeStep",20,"Default time step (dt) for forces integration","Network Algorithm Parameters",k);this.ck("barnesHutUpdateQueue",[],"Barnes Hut Queue for performance and avoid Javascript GC","Network Algorithm Parameters",false);this.ck("barnesHutNodesCache",[],"Barnes Hut node cache for performance and avoid Javascript GC","Network Algorithm Parameters",false);this.uT("barnesHutNodesCacheCurrent",0,"Barnes Hut idex for node cache for performance and avoid Javascript GC","Network Algorithm Parameters",false);this.uT("networkColaLinkDistance",20,"Ideal length for links","Network Cola Algorithm Parameters",k);this.bq("networkColaAvoidOverlaps",true,"Flag to avoid overlaps of nodes in the cola network","Network Cola Algorithm Parameters",k);this.bq("networkColaHandleDisconnected",true,"Handle disconnected nodes in the cola network","Network Cola Algorithm Parameters",k);this.oL("networkColaConvergenceThreshold",0.01,"Threshold for the convergence of the cola network","Network Cola Algorithm Parameters",k);this.oL("networkColaGroupCompactness",0.000001,"Compactness for the groups in the cola network","Network Cola Algorithm Parameters",k);this.uT("networkColaSymmetricDiffLinkLengths",5,"Symmetric difference for the link lengths in the cola network","Network Cola Algorithm Parameters",k);this.oL("networkColaJaccardLinkLength",false,"Ideal length foreach link based on the graph structure around that link. You can use this to create extra space around hub-nodes in dense graphs","Network Cola Algorithm Parameters",k);this.oL("networkColaJaccardLinkLengthDefault",1,"Default length foreach link based on the graph structure around that link. You can use this to create extra space around hub-nodes in dense graphs","Network Cola Algorithm Parameters",k);this.Rh("networkColaFlowLayoutAxis",false,[false,"x","y"],"Causes constraints to be generated such that directed graphs are laid out either from left-to-right or top-to-bottom. A separation constraint is generated in the selected axis for each edge that is not involved in a cycle","Network Cola Algorithm Parameters",k);this.oL("networkColaFlowLayoutSeparation",10,"Causes constraints to be generated such that directed graphs are laid out either from left-to-right or top-to-bottom. A separation constraint is generated in the selected axis for each edge that is not involved in a cycle","Network Cola Algorithm Parameters",k);this.uT("networkColaStartUnconstrainedIterations",0,"Number of iterations to run unconstrained","Network Cola Algorithm Parameters",k);this.uT("networkColaUserConstraintIterations",0,"Number of user iterations to run unconstrained","Network Cola Algorithm Parameters",k);this.uT("networkColaAllConstraintsIterations",0,"Number of iterations to run all constraints","Network Cola Algorithm Parameters",k);this.uT("networkColaGridSnapIterations",0,"Number of iterations to run grid snap","Network Cola Algorithm Parameters",k);this.bq("networkColaKeepRunning",true,"Flag to keep running the cola network","Network Cola Algorithm Parameters",k);this.bq("networkColaCenterGraph",true,"Flag to center the cola network","Network Cola Algorithm Parameters",k);this.rW("colorNodeBy",false,"Name of the attribute to color the nodes","Network Node and Edge Attributes",k);this.rW("shapeNodeBy",false,"Name of the attribute to shape the nods","Network Node and Edge Attributes",k);this.rW("sizeNodeBy",false,"Name of the attribute to size the nodes","Network Node and Edge Attributes",k);this.rW("patternNodeBy",false,"Name of the attribute to pattern the nodes","Network Node and Edge Attributes",k);this.rW("colorEdgeBy",false,"Name of the attribute to color the edges","Network Node and Edge Attributes",k);this.rW("sizeEdgeBy",false,"Name of the attribute to size the edges","Network Node and Edge Attributes",k);this.oL("minEdgeSize",0,"Number of pixels to add to the minimum thickness for the edges when the edges are sized by a property. Should be a value between 0 and 1.5","Network Node and Edge Attributes",k);this.oL("maxEdgeSize",10,"Thickness for the edges when the edges are sized by a property. Should be a value between 10 and 20","Network Node and Edge Attributes",k);this.S4("NetworkCommunities",false,"network communities","Network Communities",k);this.bq("calculateNetworkCommunities",true,"Flag to calculate the network communities using the jLouvain algorithm. If this flag is false the property community and communityColor for each node will need to be provided, otherwise all nodes will belong to a single community","Network Communities",k);this.bq("coordinateNetworkConvexHullCommunityColor",false,"Flag to coordinate colors of the nodes with convex hull for the network communities","Network Communities",k);this.oL("hullScale",1.25,"Scaling factor for extension of the hulls in the network communities","Network Communities",k);this.uT("networkCommunities",null,"Number of network communities","Network Communities",false);this.ck("networkConvexHulls",[],"Array for the Network community convex hull property object","Network Communities",false);this.uT("genomeTicks",50,"Number of ticks in the genome browser","Genome Browser",k);this.QE("wire","rgba(204,204,204,0.1)","ticks in the genome browser","Genome Browser",k);this.uT("periodTicksLabels",5,"Number of ticks to skip between values in the genome browser","Genome Browser",k);this.Rh("genomeResolution","low",["low","medium","high"],"Number to adjust the splines curvature","Genome Browser",k);this.Kv("trackName","","rgb(0,0,0)",11,1,"center","middle",0,8,"track name","Genome Browser Tracks",k);this.QE("trackFill","rgb(255,255,255)","fill of the tracks in the genome browser","Genome Browser Tracks",k);this.QE("trackDir","rgb(0,0,0)","strand direction of the tracks in the genome browser","Genome Browser Tracks",k);this.uT("subtracksMaxDefault",8,"Maximum number of subtracks to show in a track","Genome Browser Tracks",k);this.ck("trackConfigurableProperties",["name","hideName","hideFeatureNames","type","height","fill","outline","data","hide","connect","subtracksMax","highlight"],"Track configurable properties<br> @tracks {name:[string];Track name;[]}","Genome Browser Tracks",k);this.uT("showFeatureNameThereshold",20,"Threshehold used to set te limit when there are too many features in the genome browser","Genome Browser Features",k);this.Kv("featureName","","rgb(0,0,0)",11,1,"center","middle",0,8,"feature name","Genome Browser Features",k);this.QE("featureFill","rgb(255,255,255)","fill of the feature in the genome browser","Genome Browser Features",k);this.QE("featureDir","rgb(0,0,0)","strand direction of the feature in the genome browser","Genome Browser Features",k);this.uT("maxFeatureStringLen",30,"Maximum length in characters a feature label can have so anything above is truncated","Genome Browser Features",k);this.uT("featureWidthDefault",3,"Default size in pixels of the feature width","Genome Browser Features",k);this.uT("featureHeightDefault",14,"Default size in pixels of the feature height","Genome Browser Features",k);this.Rh("featureSpliceStyle","rect",["rect","broken"],"Default style for splicing in boxes","Genome Browser Features",k);this.uT("featureTraceHeight",40,"Default size in pixels of the trace height","Genome Browser Features",k);this.uT("featureTraceTrim",1,"Default triming for nucleotide values in the traces (expressed in percent)","Genome Browser Features",k);this.bq("featureTracesShow",true,"Flag use to show traces","Genome Browser Features",k);this.uT("featureQualityHeight",14,"Default size in pixels of the quality height","Genome Browser Features",k);this.bq("featureQualityValues",false,"Flag use to show values for the quality","Genome Browser Features",k);this.bq("featureQualityShow",true,"Flag use to show quality","Genome Browser Features",k);this.uT("featureSignalToNoiseHeight",14,"Default size in pixels of the quality height","Genome Browser Features",k);this.bq("featureSignalToNoiseValues",false,"Flag use to show values for the quality","Genome Browser Features",k);this.bq("featureSignalToNoiseShow",true,"Flag use to show quality","Genome Browser Features",k);this.uT("featureCoordinateHeight",14,"Default size in pixels of the coordinates height","Genome Browser Features",k);this.bq("featureCoordinateShow",true,"Flag use to show coordinates","Genome Browser Features",k);this.uT("featureTranslateHeight",14,"Default size in pixels of the translation height","Genome Browser Features",k);this.bq("featureTranslateShow",true,"Flag use to show tranlation","Genome Browser Features",k);this.Rh("featureTypeDefault","line",["box","bar","heatmap","sequence","triangle","line"],"Default type for the feature in the genome browser","Genome Browser Features",k);this.bq("featureStaggered",false,"Flag use to stagger the features in the genome panel","Genome Browser Features",k);this.ck("featureConfigurableProperties",["id","name","label","hideName","fill","outline","dir","showDir","connect","offset","data","subtype","quality","signalToNoise","coordinate","sequence","trace","gaps","translate","hide","counter"],"Feature configurable properties<br> @features {id:[string];Feature id;[],fill:[color];Color for the feature;[]}","Genome Browser Features",k);this.Kv("sequence","","rgb(0,0,0)",11,1,"center","middle",0,8,"sequence","Genome Browser Sequences",k);this.QE("sequenceFill",false,"background when showing sequnces in the box or sequence object in the Genome. The default is to use the background of the object. If specied a valid color then all the background of sequences will be uniform","Genome Browser Sequences",k);this.QE("sequenceGAP","rgb(255,0,255)","deletions, insertions and gaps in the genome browser","Genome Browser Sequences",k);this.QE("sequenceA","rgb(0,103,0)","adenines and alanines in the genome browser","Genome Browser Sequences",k);this.QE("sequenceB","rgb(0,0,0)","degenerate C/G/T and asparagines in the genome browser","Genome Browser Sequences",k);this.QE("sequenceC","rgb(0,0,255)","cytosines and cysteins in the genome browser","Genome Browser Sequences",k);this.QE("sequenceD","rgb(0,0,0)","degenerate A/G/T and aspartic acids in the genome browser","Genome Browser Sequences",k);this.QE("sequenceE","rgb(0,0,0)","glutamic acids in the genome browser","Genome Browser Sequences",k);this.QE("sequenceF","rgb(0,0,255)","phenylalanines in the genome browser","Genome Browser Sequences",k);this.QE("sequenceG","rgb(0,0,0)","guanines and glycines in the genome browser","Genome Browser Sequences",k);this.QE("sequenceH","rgb(255,0,0)","degenerate A/C/T and histidines in the genome browser","Genome Browser Sequences",k);this.QE("sequenceI","rgb(0,103,0)","isoleucines in the genome browser","Genome Browser Sequences",k);this.QE("sequenceK","rgb(255,0,0)","degenerate G/T and lysines in the genome browser","Genome Browser Sequences",k);this.QE("sequenceL","rgb(0,103,0)","leucines in the genome browser","Genome Browser Sequences",k);this.QE("sequenceM","rgb(0,103,0)","degenerate A/G and methionines in the genome browser","Genome Browser Sequences",k);this.QE("sequenceN","rgb(0,0,0)","degenerate A/C/G/T and asparagines in the genome browser","Genome Browser Sequences",k);this.QE("sequenceP","rgb(255,165,0)","prolines in the genome browser","Genome Browser Sequences",k);this.QE("sequenceQ","rgb(0,0,0)","glutamines in the genome browser","Genome Browser Sequences",k);this.QE("sequenceR","rgb(255,0,0)","degenerate A/G and arginines in the genome browser","Genome Browser Sequences",k);this.QE("sequenceS","rgb(255,165,0)","degenerate G/C and serines in the genome browser","Genome Browser Sequences",k);this.QE("sequenceT","rgb(255,0,0)","thymidines and threonines in the genome browser","Genome Browser Sequences",k);this.QE("sequenceU","rgb(255,0,0)","uracils in the genome browser","Genome Browser Sequences",k);this.QE("sequenceV","rgb(0,103,0)","degenerate A/C/G and valines in the genome browser","Genome Browser Sequences",k);this.QE("sequenceW","rgb(0,0,255)","degenerate A/T and tryptophans in the genome browser","Genome Browser Sequences",k);this.QE("sequenceX","rgb(0,0,0)","any aminoacid code in the genome browser","Genome Browser Sequences",k);this.QE("sequenceY","rgb(0,0,255)","degenerate C/T and tyrosines in the genome browser","Genome Browser Sequences",k);this.QE("sequenceZ","rgb(0,0,0)","glutamines in the genome browser","Genome Browser Sequences",k);this.QE("sequenceStart","rgb(0,204,0)","start codon in the genome browser","Genome Browser Sequences",k);this.QE("sequenceEnd","rgb(255,0,0)","end codon in the genome browser","Genome Browser Sequences",k);this.ck("errors",[],"Array containing benign errors produced when rendering canvasXpress","Debug",false);this.bq("debug",false,"Flag to turn on alerts","Debug",k);this.bq("debugWithArea",false,"Flag to render object areas when debugging","Debug",k);this.rW("notice","Debug notices","Debug",false);this.bq("verbose",false,"Flag to turn on/off verbose","Debug",k);this.bq("offline",false,"Flag to work offline","Debug",k);this.S4("Version",true,"version when mouse over top-left corner of the canvas","Debug",k);this.S4("Code",false,"code for the canvas","Debug",k);this.Rh("codeType","params",["pretty","compact","tab","params"],"Output type for the JSON code","Debug",k);this.bq("disableEvents",false,"Flag to disable all events","Events",k);this.bq("disableCode",false,"Flag to disable showing the code","Events",k);this.bq("disableMenu",false,"Flag to disable showing the menu on right clicks","Events",k);this.bq("disableToolbar",false,"Flag to disable showing the toolbar","Events",k);this.bq("disableDataTable",false,"Flag to disable showing data table","Events",k);this.bq("disableDataFilters",false,"Flag to disable showing data filters","Events",k);this.bq("disableCustomizer",false,"Flag to disable the data explorer","Events",k);this.bq("disableTabPanel",false,"Flag to disable the tab panels","Events",k);this.bq("disableCanvas",false,"Flag to disable all canvas events","Events",k);this.bq("disableDrag",false,"Flag to disable drg events in canvas","Events",k);this.bq("disableKeys",false,"Flag to disable key binding events. This prevent some default browser shortcuts and it is system specific. Please see the Event section bellow","Events",k);this.bq("disableShowShortcuts",true,"Flag to disable showing shortcuts","Events",k);this.bq("disablePlusMinusKeys",true,"Flag to disable plus / minus key binding events","Events",k);this.bq("disableUndoRedoKeys",true,"Flag to disable undo / redo key binding events","Events",k);this.bq("disableDocument",false,"Flag to disable mousemove and mouseup in the document","Events",k);this.bq("disableWindow",false,"Flag to disable resizing the canvas when the window is resized. ","Events",k);this.bq("disableWheel",false,"Flag to disable wheel. ","Events",k);this.bq("disableBeacon",false,"Flag to disable beacon. ","Events",k);this.bq("playable",false,"Flag to make the plot playable if there are after rendering functions","Events",k);this.bq("resizable",true,"Flag to disable resizing the canvas by dragging the mouse over the edges","Events",k);this.bq("resizableX",true,"Flag to disable resizing the width of the canvas by dragging the mouse over the edges","Events",k);this.bq("resizableY",true,"Flag to disable resizing the height of canvas by dragging the mouse over the edges","Events",k);this.bq("movable",true,"Flag to disable moving the canvas by dragging the mouse from the move image in the toolbar","Events",k);this.uT("maxSubMenus",25,"Maximum number of submenus in the context menus","Events",k);this.S4("PrimaryMenus",false,"primary menus in toolbar","Events",k);this.uT("maxItemMenuCheckbox",10,"Maximum number of items in a menu before it becomes a scroll box","Events",k);this.bq("skipClick",false,"Flag to skip click events after a mouse down event in visualizations where there is a drag capabilities","Events",false);this.uT("infoTimeOut",3000,"Time in milliseconds to wait between updates for the mouse over info to show up","Events",k);this.uT("infoStartTime",new Date().getTime(),"Time in milliseconds to keep track of time","Events",false);this.uT("infoTimeIn",50,"Time in milliseconds to start showing info after a mouse over","Events",k);this.bq("broadcast",true,"Flag to enable broadcasting to other canvasXpress objects in the page","Events",k);this.rW("broadcastGroup",false,"Group Id for canvas to broadcast to. If not specified then it broadcasts to all canvases","Events",k);this.S4("MousePositionOnDrag",true,"mouse position when dragging in relation to the zero coordinate (top-right) of the canvas","Events",k);this.Rh("toolbarType","under",["over","under","fixed"],"Toolbar type","Events",k);this.uT("toolbarSize",30,"Height for the toolbar in graphs","Events",k);this.ck("toolbarItems",["Save","History","Move","Table","Tabs","Explore","Lasso","Customize","Password","Maximize"],"Array containing the items in the toolbar. All items included by default","Events",k);this.bq("lazyLoad",false,"Load canvas only if shown in viewport","Events",k);this.rW("hoverTemplate",false,"HTML string to use as template for the hover info","Events",k);this.S4("Animation",true,"animation for the graphs","Animations and Visualization Transitions",k);this.S4("Transition",false,"transitions for the graphs","Animations and Visualization Transitions",k);this.uT("transitionStep",20,"Steps for transition","Animations and Visualization Transitions",k);this.uT("transitionStaggering",10,"Steps for transitionioning data objects","Animations and Visualization Transitions",k);this.Rh("transitionFunction","easeInOutQuad",["linear","easeInQuad","easeOutQuad","easeInOutQuad","easeInCubic","easeOutCubic","easeInOutCubic","easeInQuart","easeOutQuart","easeInOutQuart","easeInQuint","easeOutQuint","easeInOutQuint"],"Easing function for the transition","Animations and Visualization Transitions",k);this.oL("weight",1,"Fraction of the canvas to be used (a value between 0 and 1). Used when multiple graphs are displayed in one canvas. Could be an number or an array of numbers","Combination Plots",false);this.oL("scaleX",1,"Scale factor for the X axis","Combination Plots",false);this.oL("scaleY",1,"Scale factor for the Y axis","Combination Plots",false);this.oL("translateX",0,"Amount to translate for the X axis","Combination Plots",false);this.oL("translateY",0,"Amount to translate for the Y axis","Combination Plots",false);this.oL("offsetX",0,"Additional amount to move for the X axis","Combination Plots",false);this.oL("offsetY",0,"Additional amount to move for the Y axis","Combination Plots",false);this.oL("layoutWidth",0,"Width of the current segment of the canvas when there are multiple graphs","Combination Plots",false);this.oL("layoutHeight",0,"Height of the current segment of the canvas when there are multiple graphs","Combination Plots",false);this.uT("layoutCurrent",0,"Integer to identify the current graph being displayed in the canvas","Combination Plots",false);this.rW("layout","1X1","Topology of the canvas. Number of rows and columns","Combination Plots",false);this.bq("layoutComb",false,"Flag that identify that multiple graphs will be displayed in the canvas. This is the case when ata is segregated, splom, multiple pies or DOE visualizations","Combination Plots",false);this.QX("stripBackground","rgba(255,255,255,0)","rgba(0,0,0)",1,"solid","layout label strip background","Combination Plots",k);this.Kv("stripText","","rgb(0,0,0)",11,1,"center","middle",0,5,"label strip text in layout graphs","Combination Plots",k);this.g1("strip",true,"the layout label strip","Combination Plots",k);this.oL("stripThickness",30,"Thickness of the layout label strip","Combination Plots",k);this.rW("layoutTopology",false,"Topology of the canvas. Number of columns and rows separated by X. For example: 2X1, 1X3, etc","Combination Plots",k);this.bq("layoutAdjust",false,"Flag to force recalculating the ranges in the axes when multiple graphs are displayed in the canvas","Combination Plots",k);this.bq("layoutGlobalGroups",false,"Flag to force same groups across all layout plots","Combination Plots",k);this.bq("layoutCollapse",false,"Flag to make layout graphs without any space in between","Combination Plots",k);this.uT("layoutSpacing",8,"Spacing between layout graphs","Combination Plots",k);this.Rh("layoutType","wrap",["wrap","rows","cols"],"Type of layout to place the position for the labels in the trellis plot. Identify the axis that will be used to place the first segregating factor. rows will use the first segregating factor in the rows and the second in the columns. cols will use the first segregating factor in the columns and the second in the rows. wrap will wrap the segregating factors putting the sample factors in the columns","Combination Plots",k);this.bq("layoutRemoveEmpty",true,"Flag to remove empty combinations in segregated layouts","Combination Plots",k);this.bq("layoutCanvasCompartments",false,"Flag to draw lines around each graph in the layout in the canvas. Used only when debugging","Combination Plots",k);this.Kv("layoutLabel","","rgb(0,0,0)",11,1,"center","middle",0,5,"label text in layout graphs","Combination Plots",k);this.ck("layoutConfig",[],"Array of object to assign visualization configurations to each layout","Combination Plots",k);this.Rh("layoutAxis",3,[1,2,3],"Flag to indicated whether to print axes values when multiple graphs are displayed in the canvas. The possible values are: 1: horizontal, 2: vertical, 3: both","Combination Plots",k);this.uT("imageTimeOut",1000,"Time in milliseconds to wait to load images","Images",k);this.uT("imageMaxTries",10,"Maximum times to try to load images. Used to calculate the timeout which will be imageTimeOut / imageTries which will be 100ms by default","Images",k);this.uT("imageTries",0,"Image try counter","Images",false);this.Kc("remoteService",false,"Url used to obtain data remotely thorugh a web service or directly from a file. If the remote service is a file then it expects a json file with a two dimensional array. Each of the arrays should have a key (which will be used in a drop down menu) and a value to point to a url where to get the data. If the remote service is a web service it expects a canvasXpress object. The default parameters for web services are index (to identify the current record number) and dir (to identify the direction; it could be either next or prev)","Remote Procedures",k);this.kK("remoteParams",{},"Object to hold additional parameters used to obtain data remotely. The target property will be always added to the method as well as the direction [next|prev]","Remote Procedures",k);this.Rh("remoteDirection","next",["next","prev"],"Direction parameter used to obtain data remotely","Remote Procedures",k);this.bq("remoteAutoPlay",false,"Flag to automatically iterate over remote data sets","Remote Procedures",k);this.uT("remoteAutoPlayDelay",3000,"Time in milliseconds to wait between iterations while automatically going over remote data sets","Remote Procedures",k);this.bq("remoteParamOverride",true,"Flag to override parameters to maintain the state of the graphs when using remote services","Remote Procedures",k);this.Rh("remoteTransitionEffect","slide",["none","slide","fade"],"Effect for the remote transitions","Remote Procedures",k);this.bq("remoteAutoSize",true,"Flag to adjust remote graph to current canvas size","Remote Procedures",k);this.rW("remoteParentId","","Id for the parent holding the remoteWindow to prevent id collisions","Remote Procedures",false);this.uT("remoteDataIndex",0,"Index of the canvasXpress object requested","Remote Procedures",false);this.ck("remoteIds",[],"Array of the remoteIds passed after a service call","Remote Procedures",false);this.ck("remoteData",[],"Array for the remote data pased after a service call","Remote Procedures",false);this.bq("remoteUpdating",false,"Flag to indicate that updating data is in progress","Remote Procedures",false);this.Kc("RdatasetsURL","https://raw.githubusercontent.com/neuhausi/Rdatasets/master/","URL for R objects","R",false);this.bq("loadRDatasets",false,"Flag to load R datasets from Github","R",k);this.Rh("dataUIStyle","modern",[false,"stripped","modern","old","bms"],"Style for the UI","Data UI Widgets",k);this.Rh("widgetsStyle","modern",[false,"stripped","modern","old","bms","custom"],"Style for the UI","Data UI Widgets",k);this.QE("widgetsBackground","rgba(255, 255, 255, 0.95)","background all the UI widgets. It only applied if the dataUIStyle is set to false","Data UI Widgets",k);this.QE("widgetsBase","rgb(83, 105, 255)","elements in all the UI widgets. It only applied if the dataUIStyle is set to false","Data UI Widgets",k);this.QE("widgetsBorder","rgb(83, 105, 255)","border of all elements in all the UI widgets. It only applied if the dataUIStyle is set to false","Data UI Widgets",k);this.oL("widgetsHoverTransparency",0.2,"Transparency for the elements in all the UI widgets when mouse overs. It only applied if the dataUIStyle is set to false","Data UI Widgets",k);this.QE("widgetsAccent","rgba(83, 105, 255, 0.1)","accent elements in all the UI widgets. It only applied if the dataUIStyle is set to false","Data UI Widgets",k);this.QE("widgetsContrast","rgb(83, 105, 255)","contrast elements in all the UI widgets. It only applied if the dataUIStyle is set to false","Data UI Widgets",k);this.QE("widgetsStriped","rgba(83, 105, 255, 0.05)","stripe elements in the data table","Data UI Widgets",k);this.uT("widgetsFontSize",12,"Font size for the elements in all the UI widgets. It only applied if the dataUIStyle is set to false","Data UI Widgets",k);this.QE("widgetsFont","rgb(34, 34, 34)","the elements in all the UI widgets. It only applied if the dataUIStyle is set to false","Data UI Widgets",k);this.QE("widgetsIconClsA","#5369ff","class-a widget icons","Data UI Widgets",k);this.QE("widgetsIconClsB","#292929","class-b widget icons","Data UI Widgets",k);this.QE("widgetsIconClsC","#999999","class-c widget icons","Data UI Widgets",k);this.QE("widgetsIconClsC","#ffffff","class-x widget icons","Data UI Widgets",k);this.uT("maxDataCustomizerEntries",10000,"Maximum number of samples or variables to display in the data customizer","Data Customizer",k);this.Rh("customizerSize","medium",["xsmall","small","medium","large"],"Size for the customizer. Requires re-opening of customizer","Data Customizer",k);this.bq("customizerEntriesAsList",true,"Flag to show entries in scrolling widgets as text. The default is to show them as icons-like","Data Customizer",k);this.bq("customizerGraphMaximize",false,"Flag to maximize the graph when the customizer is called","Data Customizer",k);this.bq("skipConfigurableProperties",true,"Flag to indicate to exclude configurable parameters in the data table and the data filters in Networks and Genome Browser","Data Table/Filter",k);this.ck("nodesProperties",[],"Two dimensional array with object properties not at the root level for the nodes in the Network graph to include in the Data table and the data filter","Data Table/Filter",k);this.ck("edgesProperties",[],"Two dimensional array with object properties not at the root level for the edges in the Network graph to include in the Data table and the data filter","Data Table/Filter",k);this.ck("featuresProperties",[],"Two dimensional array with object properties not at the root level for the features in the Genome graph to include in the Data table and the data filter","Data Table/Filter",k);this.uT("dataFilterWidth",300,"Size in pixels for the data filters","Data Filters",k);this.Rh("filterType","and",["and","or"],"Type for the filter. Can be and or or","Data Filters",k);this.Rh("filterMode","hide",["hide","color"],"Mode for the legend filters. Can be set to hide the data using transparency or to color the data points with the missingDataColor","Data Filters",k);this.bq("filterSkipNullKeys",false,"Flag to indicate to bypass filtering when a key is non existent in the data objects","Data Filters",k);this.bq("filterSkipNullValues",false,"Flag to indicate to bypass filtering when a value is null","Data Filters",k);this.JW("filterVarBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter variables by their annotation included in the data.z object used in one dimensional plots. Used in the CanvasXpress UIs","Data Filters",k);this.JW("filterSmpBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter samples by their annotation included in the data.x object used in one dimensional plots. Used in the CanvasXpress UIs","Data Filters",k);this.JW("filterNodeBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter nodes by their properties used in network graphs. Used in the CanvasXpress UIs","Data Filters",k);this.JW("filterEdgeBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter edges by their properties used in network graphs. Used in the CanvasXpress UIs","Data Filters",k);this.JW("filterFeatureBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter features by their properties used in genome browser. Used in the CanvasXpress UIs","Data Filters",k);this.JW("filterDataBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter data by their value in the data object used in oncoprints. Used in the CanvasXpress UIs","Data Filters",k);this.bq("dataTableTransposed",true,"Flag to transpose the data in the data table","Data Table",k);this.uT("maxRows",10,"Maximum number of rows to display in the data table","Data Table",k);this.uT("maxCols",10,"Maximum number of columns to display in the data table","Data Table",k);this.uT("colWidth",100,"Number of pixels for the width of cells in the data table","Data Table",k);this.uT("rowHeight",30,"Number of pixels for the height of cells in the data table","Data Table",k);this.uT("rowLines",1,"Number of lines in cells in the data table","Data Table",k);this.bq("refresehDataTableOnDraw",false,"Flag to indicate to refresh data after drawing the plot","Data Table",k);this.S4("DataTableOnSelect",false,"Flag to indicate to show data after selecting data in the plot","Data Table",k);this.Rh("networkShowDataTable","nodes",["nodes","edges"],"Show nodes or edges on data table","Data Table",k);this.oL("colorDataTableTransparency",0.5,"Transparency for the background of the data table cells if colored","Data Table",k);this.uT("startCol",0,"Starting column in the data table","Data Table",false);this.uT("startRow",0,"Starting row in the data table","Data Table",false);this.uT("totalCols",null,"Total columns in the data table","Data Table",false);this.uT("totalRows",null,"Total rows in the data table","Data Table",false);this.rW("dataTableImage",false,"Image to brand the data table","Data Table",k);this.kK("dataTableRowProperties",{},"Properties for the rows in the data table. Key is the variable name and the value is the height in pixels","Data Table",k);this.kK("dataTableColProperties",{},"Properties for the cols in the data table. Key is the sample name and the value is the width in pixels","Data Table",k);this.ck("dataTableColHide",[],"Array to store the columns to hide in the data table","Data Table",k);this.ck("dataTableColOrder",[],"Array to store the column sorting for the data table. It only applies to meta data and exclude variables or samples. Those not included willl be placed last","Data Table",k);this.ck("dataTableRowOrder",[],"Array to store the row sorting for the data table. It only applies to meta data and exclude variables or samples. Those not included willl be placed last","Data Table",k);this.ck("dataTableColumnWidth",[],"Array to store the column width for the data table","Data Table",false);this.ck("dataTableRowHeight",[],"Array to store the row height for the data table","Data Table",false);this.bq("colorDataTable",true,"Flag to color the data table","Data Table",k);this.Rh("dataTableBorders","rows",["all","none","rows","cols"],"data table borders","Data Table",k);this.QE("dataTableBorder","rgb(204, 204, 204)","border of the data table cells","Data Table",k);this.g1("dataTableHeaderBorders",true,"Flag to show the borders in the data table headers. The color of the border will be the same as that used for the base color of the UI widgets","Data Table",k);this.g1("dataTableStripe",true,"Flag to show the stripes in the data table rows","Data Table",k);this.oL("dataTableStripeTransparency",0.05,"Transparency for the stripes in the data table using the base color for the UI widgets","Data Table",k);this.rW("dataTableZeroHeader","","Name for the first column in the data table","Data Table",k)};this.oi=function(){var a=this.DF(this.iconClsA,false,true);var b=this.DF(this.iconClsB,false,true);var c=this.DF(this.iconClsC,false,true);var x=this.DF(this.iconClsX,false,true);var q={cxtxa:"{f:none;s:"+a+";w:4px;}",cxa0:" {w:0px;f:"+a+";}",cxc0:"{w:0px;f:"+c+";}",cxa1:" {l:10;w:3px;f:none;s:"+a+";}",cxa:" {l:10;w:4px;f:none;s:"+a+";}",cxb:"{l:10;w:4px;f:none;s:"+b+";}",cxc:"{l:10;w:4px;f:none;s:"+c+";}",cxaa:"{s:"+a+";f:"+a+";}",cxbb:"{s:"+b+";f:"+b+";}",cxcc:"{s:"+c+";f:"+c+";}",cxab:"{s:"+a+";f:"+b+";}",cxac:"{s:"+a+";f:"+c+";}",cxbc:"{s:"+b+";f:"+c+";}",cxaw:"{l:10;w:3px;s:"+a+";f:#ffffff;}",cxbw:"{l:10;w:3px;s:"+b+";f:#ffffff;}",cxxx:"{w:15px;s:"+x+";f:none;}",cxblue:"{s:"+a+";w:5px;}"};for(var i in q){CanvasXpress.icons.classes[i]=q[i]}};this.od=function(){var root=document.documentElement;getProp=function(p){return getComputedStyle(root).getPropertyValue(p)};setProp=function(p,v){root.style.setProperty(p,v)};this.red=getProp("--cx-color-red");this.blue=getProp("--cx-color-blue");this.green=getProp("--cx-color-green");this.yellow=getProp("--cx-color-yellow");this.orange=getProp("--cx-color-orange");this.purple=getProp("--cx-color-purple");this.white=getProp("--cx-color-white");this.gray=getProp("--cx-color-gray");this.black=getProp("--cx-color-black");this.transparent=getProp("--cx-color-transparent");this.fontFamily=getProp("--cx-font-family");this.transparentBorder=getProp("--cx-border-transparent");switch(this.dataUIStyle){case"modern":this.fontWidgetsSize="12px";this.fontWidgetsColor="rgb(34,34,34)";this.backgroundWidgetsColor="rgba(255, 255, 255, 0.95)";this.baseWidgetsColor="rgb(83, 105, 255)";this.hoverWidgetsColor="rgba(83,105,255, 0.2) ";this.accentWidgetsColor="rgba(83, 105, 255, 0.1)";this.contrastWidgetsColor="rgb(83, 105, 255)";this.iconClsA="#5369ff";this.iconClsB="#292929";this.iconClsC="#999999";this.iconClsX="#ffffff";this.widgetsStripedColor="rgba(83, 105, 255, 0.05)";this.dataTableHeaderBordersShow=true;break;case"stripped":this.fontWidgetsSize="12px";this.fontWidgetsColor="rgb(34,34,34)";this.backgroundWidgetsColor="rgba(255, 255, 255, 0.95)";this.baseWidgetsColor="rgb(204, 204, 204)";this.hoverWidgetsColor="rgb(204, 204, 204, 0.6)";this.accentWidgetsColor="rgb(204, 204, 204, 0.4)";this.contrastWidgetsColor="rgb(123, 123, 123)";this.iconClsA="#000000";this.iconClsB="#454545";this.iconClsC="#999999";this.iconClsX="#ffffff";this.widgetsStripedColor="rgba(0, 0, 0, 0.05)";this.dataTableHeaderBordersShow=false;break;case"old":this.fontWidgetsSize="12px";this.fontWidgetsColor="rgb(34,34,34)";this.backgroundWidgetsColor="rgba(255, 255, 255, 0.95)";this.baseWidgetsColor="rgb(204, 204, 204) ";this.hoverWidgetsColor="rgb(204, 204, 204, 0.6)";this.accentWidgetsColor="linear-gradient(rgb(240, 240, 240), rgb(230, 230, 230))";this.contrastWidgetsColor="rgb(123, 123, 123)";this.iconClsA="#000000";this.iconClsB="#454545";this.iconClsC="#999999";this.iconClsX="#ffffff";this.widgetsStripedColor="rgba(0, 0, 0, 0.05)";this.dataTableHeaderBordersShow=false;break;case"bms":this.fontWidgetsSize="12px";this.fontWidgetsColor="rgb(34,34,34)";this.backgroundWidgetsColor="rgba(255, 255, 255, 0.95)";this.baseWidgetsColor="rgb(189, 184, 184)";this.hoverWidgetsColor="rgb(190, 43, 187, 0.1)";this.accentWidgetsColor="rgb(190, 43, 187, 0.6)";this.contrastWidgetsColor="rgb(190, 43, 187)";this.iconClsA="#BE2BBB";this.iconClsB="#595454";this.iconClsC="#999999";this.iconClsX="#ffffff";this.widgetsStripedColor="rgba(190, 43, 187, 0.05)";this.dataTableHeaderBordersShow=false;break;case"rdc":this.fontWidgetsSize="12px";this.fontWidgetsColor="rgb(34,34,34)";this.backgroundWidgetsColor="rgba(255, 255, 255, 0.95)";this.baseWidgetsColor="rgb(255, 255, 255)";this.hoverWidgetsColor="rgba(42,106,220,0.2)";this.accentWidgetsColor="rgba(42,106,220,0.1)";this.contrastWidgetsColor="rgb(42,106,220)";this.iconClsA="#2A6ADC";this.iconClsB="#292929";this.iconClsC="#999999";this.iconClsX="#2A6ADC";this.widgetsStripedColor="rgb(227, 242, 253)";this.dataTableHeaderBordersShow=false;break;default:this.fontWidgetsSize=this.widgetsFontSize+"px";this.fontWidgetsColor=this.widgetsFontColor;this.backgroundWidgetsColor=this.widgetsBackgroundColor;this.baseWidgetsColor=this.widgetsBaseColor;this.hoverWidgetsColor=this.widgetsBaseColor.replace(")",", "+this.widgetsHoverTransparency+")").replace("rgb","rgba");this.accentWidgetsColor=this.widgetsAccentColor;this.contrastWidgetsColor=this.widgetsContrastColor;this.iconClsA=this.widgetsIconClsAColor;this.iconClsB=this.widgetsIconClsBColor;this.iconClsC=this.widgetsIconClsCColor;this.iconClsX=this.white;break}this.borderWidgets="1px solid "+this.widgetsBorderColor;this.oi();setProp("--cx-font-size",this.fontWidgetsSize);setProp("--cx-font-color",this.fontWidgetsColor);setProp("--cx-color","normal "+this.fontWidgetsSize+" "+this.fontFamily);setProp("--cx-color-bold","bold "+this.fontWidgetsSize+" "+this.fontFamily);setProp("--cx-color-italic","italic "+this.fontWidgetsSize+" "+this.fontFamily);setProp("--cx-background-widgets-color",this.backgroundWidgetsColor);setProp("--cx-background-color",this.baseWidgetsColor);setProp("--cx-background-hover-color",this.hoverWidgetsColor);setProp("--cx-background-border-hover-color",this.iconClsX);setProp("--cx-background-accent-color",this.accentWidgetsColor);setProp("--cx-background-contrast-color",this.contrastWidgetsColor);setProp("--cx-border",this.borderWidgets)};this.Dm=function(){var fs=["fontSize","titleFontSize","subtitleFontSize","smpTitleFontSize","smpTextFontSize","varTitleFontSize","varTextFontSize","overlayTextFontSize","dataTextFontSize","legendTextFontSize","legendTitleFontSize","decorationsTextFontSize","xAxisTextFontSize","xAxisTitleFontSize","yAxisTextFontSize","yAxisTitleFontSize","zAxisTextFontSize","zAxisTitleFontSize","rAxisTextFontSize","rAxisTitleFontSize","nodeFontSize","trackNameFontSize","featureNameFontSize","sequenceFontSize"];for(var i=0;i<fs.length;i++){this[fs[i]]=Number(CanvasXpress.doc.P[fs[i]].D)}this.ms()};this.ms=function(){this.font=this.fontStyle+" "+this.fontSize+"px "+this.fontName;this.titleFont=this.titleFontStyle+" "+this.titleFontSize+"px "+this.fontName;this.subtitleFont=this.subtitleFontStyle+" "+this.subtitleFontSize+"px "+this.fontName;this.citationFont=this.citationFontStyle+" "+this.citationFontSize+"px "+this.fontName;this.smpTitleFont=this.smpTitleFontStyle+" "+this.smpTitleFontSize+"px "+this.fontName;this.smpTextFont=this.smpTextFontStyle+" "+this.smpTextFontSize+"px "+this.fontName;this.varTitleFont=this.varTitleFontStyle+" "+this.varTitleFontSize+"px "+this.fontName;this.varTextFont=this.varTextFontStyle+" "+this.varTextFontSize+"px "+this.fontName;this.dataTextFont=this.dataTextFontStyle+" "+this.dataTextFontSize+"px "+this.fontName;this.overlayTextFont=this.overlayTextFontStyle+" "+this.overlayTextFontSize+"px "+this.fontName;this.legendTextFont=this.legendTextFontStyle+" "+this.legendTextFontSize+"px "+this.fontName;this.legendTitleFont=this.legendTitleFontStyle+" "+this.legendTitleFontSize+"px "+this.fontName;this.decorationsTextFont=this.decorationsTextFontStyle+" "+this.decorationsTextFontSize+"px "+this.fontName;this.stripTextFont=this.stripTextFontStyle+" "+this.stripTextFontSize+"px "+this.fontName;this.xAxisTextFont=this.xAxisTextFontStyle+" "+this.xAxisTextFontSize+"px "+this.fontName;this.xAxisTitleFont=this.xAxisTitleFontStyle+" "+this.xAxisTitleFontSize+"px "+this.fontName;this.yAxisTextFont=this.yAxisTextFontStyle+" "+this.yAxisTextFontSize+"px "+this.fontName;this.yAxisTitleFont=this.yAxisTitleFontStyle+" "+this.yAxisTitleFontSize+"px "+this.fontName;this.zAxisTextFont=this.zAxisTextFontStyle+" "+this.zAxisTextFontSize+"px "+this.fontName;this.zAxisTitleFont=this.zAxisTitleFontStyle+" "+this.zAxisTitleFontSize+"px "+this.fontName;this.rAxisTextFont=this.rAxisTextFontStyle+" "+this.rAxisTextFontSize+"px "+this.fontName;this.rAxisTitleFont=this.rAxisTitleFontStyle+" "+this.rAxisTitleFontSize+"px "+this.fontName;this.motionCurrentFont=this.motionCurrentFontStyle+" "+this.motionCurrentFontSize+"px "+this.fontName;this.nodeFont=this.nodeFontStyle+" "+this.nodeFontSize+"px "+this.fontName;this.trackNameFont=this.trackNameFontStyle+" "+this.trackNameFontSize+"px "+this.fontName;this.featureNameFont=this.featureNameFontStyle+" "+this.featureNameFontSize+"px "+this.fontName;this.sequenceFont=this.sequenceFontStyle+" "+this.sequenceFontSize+"px "+this.fontName};this.Y4=function(){if(this.meta.config.user){delete (this.meta.config.user.skipRender);for(var o in this.meta.config.user){if(this.isPivot){if(o=="groupingFactors"){continue}}if(CanvasXpress.doc.P[o]&&CanvasXpress.doc.P[o].hasOwnProperty("T")){if(CanvasXpress.doc.P[o].T=="integer"||CanvasXpress.doc.P[o].T=="float"){this.meta.config.user[o]=this.meta.config.user[o]===null?null:Number(this.meta.config.user[o])}this[o]=this.meta.config.user[o]}else{this[o]=this.meta.config.user[o]}}}};this.Wk=function(a){var o={};if(a){for(var i=0;i<a.length;i++){o[a[i]]=this[a[i]]}}this.lj();for(var i in o){this[i]=o[i]}};this.Wy=function(o,n){if(o){var p=this.gg(o);if(o.groupingFactors&&this.groupingFactors.length){if(!this.iT(o.groupingFactors,this.groupingFactors)){this.bD(!n)}}if(o.sortData){for(var i=0;i<o.sortData.length;i++){this.F5(o.sortData[i][0],o.sortData[i][1],o.sortData[i][2],!n,false,false,true)}o.sortData=[]}this.meta.config.user=o;for(var i in o){this[i]=o[i]}if(!n){this.dG({func:"updateConfig",par:[p,n]})}}};this.No=function(o){if(o){for(var i in o){this[i]=o[i]}}};this.PF=function(a){var that=this;var o={};var k=CanvasXpress.config.sort();var skip={colors:true,shapes:true,images:true,randomSeed:true,xAxisValues:true,xAxisValuesRaw:true,xAxisMinorValues:true,yAxisValues:true,yAxisValuesRaw:true,yAxisMinorValues:true,zAxisValues:true,zAxisValuesRaw:true,zAxisMinorValues:true,trackConfigurableProperties:true,featureConfigurableProperties:true};var cols={background:true,foreground:true};if(this.isTransformedData){o.isTransformedData=this.isTransformedData}for(var i=0;i<k.length;i++){var j=k[i];if(j.match(/FontSize$/)){continue}if(CanvasXpress.doc.P[j]&&CanvasXpress.doc.P[j].hasOwnProperty("D")){var d=CanvasXpress.doc.P[j].D;if(skip.hasOwnProperty(j)){continue}var v=that[j]===undefined?false:that[j];if(typeof(v)=="object"){if(d=="[]"){d=[]}if(d=="{}"){d={}}if(v===null){if(d!=null){o[j]=v}}else{if(j=="sizes"){if(!this.iT(v,d.map(Number))){o[j]=v}}else{if(j=="colorSpectrum"||j=="colors"){var t=[];for(var c=0;c<v.length;c++){var tc=this.DF(v[c],false,true);if(tc){t.push(tc.toLowerCase())}}if(!this.iT(t,d)){o[j]=v}}else{if(j.match("filter")){if(!this.iT(v,d)){o[j]=v}}else{if(!this.iT(v,d)){o[j]=v}}}}}}else{if(j.match(/Color/)||cols.hasOwnProperty(j)){if(this.DF(v)!=this.DF(d)){o[j]=v}}else{if(d!=null&&d.toString().match(/false|true|null/)){if(j=="summaryType"&&v=="raw"){continue}else{if(v.toString()!=d.toString()){o[j]=v}}}else{if(v!=d){o[j]=v}}}}}}if(o.backgroundImage&&o.backgroundImage.match(/javascript:\/\//)){if(CanvasXpress.cacheImages[o.backgroundImage.split("//")[1]]){o.backgroundImageSrc=btoa(CanvasXpress.cacheImages[o.backgroundImage.split("//")[1]].replace("data:image/png;base64,",""))}}if(a){for(var i=0;i<a.length;i++){o[a[i]]=this[a[i]]}}o.graphType=this.graphType;return o};this.cr=function(){return this.meta.config.user};this.FX=function(o){if(o){for(var i in o){var e=o[i];e=e.substring(10,e.length-2).replace(/&quot;/g,'"');this.events[i]=eval("("+e+")")}}};this.s5=function(id){var c=this.$(id);if(!c||c.tagName.toLowerCase()!="canvas"){c=this.$cX("canvas",{id:id});window.body.appendChild(c)}return this.TO(c)};this.CZ=function(){var dpr=window.devicePixelRatio||1;var ctx=this.TO(this.$cX("canvas"));var bsr=ctx.webkitBackingStorePixelRatio||ctx.mozBackingStorePixelRatio||ctx.msBackingStorePixelRatio||ctx.oBackingStorePixelRatio||ctx.backingStorePixelRatio||1;this.meta.canvas.canvasPixelRatio=dpr/bsr};this.n8=function(canvas,dpi){canvas.style.width=canvas.style.width||canvas.width+"px";canvas.style.height=canvas.style.height||canvas.height+"px";var scaleFactor=dpi/96;var width=parseFloat(canvas.style.width);var height=parseFloat(canvas.style.height);var oldScale=canvas.width/width;var backupScale=scaleFactor/oldScale;var backup=canvas.cloneNode(false);this.TO(backup).drawImage(canvas,0,0);var ctx=this.TO(canvas);canvas.width=Math.ceil(width*scaleFactor);canvas.height=Math.ceil(height*scaleFactor);ctx.setTransform(backupScale,0,0,backupScale,0,0);ctx.drawImage(backup,0,0);ctx.setTransform(scaleFactor,0,0,scaleFactor,0,0)};this.Ei=function(){var c=this.$(this.target);if(c){this.CZ();this.Ae();this.meta.canvas.ctx=this.TO(c);this.meta.canvas.ctx.setTransform(this.meta.canvas.canvasPixelRatio,0,0,this.meta.canvas.canvasPixelRatio,0,0);this.meta.canvas.ctx.o=[];this.meta.canvas.ctx.render=function(){var l=this.o.length;for(var i=0;i<l;i++){var o=this.o[i];var funcs=o.funcs;for(var j in o){if(j!=="funcs"){this[j]=o[j]}}if(funcs){var ll=funcs.length;for(var j=0;j<ll;j++){var f=funcs[j];var f0=f[0];if(this[f0]){this[f0].apply(this,f[1])}}}}};this.meta.canvas.ctx.resetRender=function(){this.o=[]};this.meta.canvas.ctx.resetContext=function(){this.direction="ltr";this.fillStyle="#000000";this.filter="none";this.font="10px sans-serif";this.fontKerning="auto";this.fontStretch="normal";this.fontVariantCaps="normal";this.globalAlpha=1;this.globalCompositeOperation="source-over";this.imageSmoothingEnabled=true;this.imageSmoothingQuality="low";this.letterSpacing="0px";this.lineCap="butt";this.lineDashOffset=0;this.lineJoin="miter";this.lineWidth=1;this.miterLimit=10;this.shadowBlur=0;this.shadowColor="rgba(0, 0, 0, 0)";this.shadowOffsetX=0;this.shadowOffsetY=0;this.strokeStyle="#000000";this.textAlign="start";this.textBaseline="alphabetic";this.textRendering="auto";this.wordSpacing="0px"}}};this.TO=function(canvas){return canvas.getContext("2d")};this.ZO=function(){var c=this.isSVG?this.meta.canvas.SVG:this.isHighlightCanvas?this.meta.canvas.ctx2:this.meta.canvas.ctx;this.currentCanvasContext=c.canvas.id;return c};this.Ae=function(){setTimeout(function(){var c=new RegExp("/www.canvasxpress.org/dist/");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){if(scripts[i].src&&c.test(scripts[i].src)){CanvasXpress.factory.siteSrc=true}}},0)};this.S3=function(){var c=CanvasXpress.system;c.isR=this.isR;c.isHTMLWidgets=typeof HTMLWidgets!="undefined";c.isShiny=typeof window.Shiny!=="undefined"&&!!window.Shiny.outputBindings;c.isRViewer=/\bviewer_pane=1\b/.test(window.location);c.isRConsole=c.isHTMLWidgets&&!c.isShiny&&!c.isRViewer;c.isNode=typeof exports==="object"&&typeof module!=="undefined";c.isReact=typeof React!="undefined";c.isHeadless=(this.url&&this.url.hasOwnProperty("cXD")&&this.url.cXD==c.registered)||window.navigator.webdriver;c.isCxplot=this.isCxplot;c.isjQuery=typeof $==="function";c.isReveal=typeof Reveal!="undefined";c.isZoom=typeof zoom!="undefined"};this.yr=function(images){for(var i=0;i<images.length;i++){images[i].style.transform="scale("+(1/Reveal.getScale())+")"}};this.gW=function(divs){for(var i=0;i<divs.length;i++){divs[i].parentNode.style.overflowX="unset";divs[i].style.transform="scale("+(1/Reveal.getScale())+")"}};this.lg=function(){var that=this;if(CanvasXpress.system.isReveal&&!window.RevealCanvasXpress){var images=document.querySelectorAll("img.CanvasXpress");that.yr(images);var canvases=document.querySelectorAll("canvas.CanvasXpress");for(var i=0;i<canvases.length;i++){canvases[i].parentNode.parentNode.style.overflowX="unset";canvases[i].parentNode.style.transform="scale("+(1/Reveal.getScale())+")";canvases[i]["data-responsive"]=true;canvases[i]["data-aspectRatio"]=parseInt(canvases[i].clientWidth)+":"+parseInt(canvases[i].clientHeight);if(canvases[i].hasAttribute("data-src")&&canvases[i].id){new CanvasXpress({renderTo:canvases[i].id,data:canvases[i].getAttribute("data-src")})}}Reveal.addEventListener("slidechanged",function(event){var images=Reveal.getCurrentSlide().querySelectorAll("img.CanvasXpress");that.yr(images);var canvases=Reveal.getCurrentSlide().querySelectorAll("canvas.CanvasXpress");if(canvases.length){var divs=Reveal.getCurrentSlide().querySelectorAll("div.CanvasXpress-ParentNode");that.gW(divs)}});Reveal.addEventListener("dblclick",function(event){var target=event.target;if(!target.id){target.id="foobar"}if(target.tagName.toLowerCase()=="img"&&that.oy(target,"CanvasXpress")){var id=that.PI("-cX-Reveal-"+target.id+"-");var cnv=document.createElement("canvas");cnv.id=id;cnv.width=target.clientWidth;cnv.height=target.clientHeight;cnv["data-responsive"]=true;cnv["data-aspectRatio"]=parseInt(target.clientWidth)+":"+parseInt(target.clientHeight);target.parentNode.insertBefore(cnv,target.nextSibling);target.style.display="none";new CanvasXpress({renderTo:id,data:target.src,callback:function(){var divs=Reveal.getCurrentSlide().querySelectorAll("div.CanvasXpress-ParentNode");that.gW(divs)}})}});window.RevealCanvasXpress=true}};this.us=function(config){CanvasXpress.config=[];this.lj();if(config&&config.graphType){this.graphType=config.graphType}if(this.graphType.match(/Network/)){this.xRotate=0}var k=config?Object.keys(config):[];var x=0;for(var i=0;i<k.length;i++){if(k[i].match(/^remote/)){x++;if(k[i]=="remoteData"||k[i]=="remoteIds"){this[k[i]]=config[k[i]]}}}if(!config||(config&&!config.graphOrientation&&x!=k.length)){if(this.meta.config.user){this.meta.config.user.graphOrientation=this.graphOrientation}}this.bN(config&&config.theme?config.theme:"none");if(config){if(!window.cX){CanvasXpress.factory.valid=config.cX;window.cX=CanvasXpress.factory.valid}for(var i in config){if(CanvasXpress.doc.P[i]&&CanvasXpress.doc.P[i].D==null&&config[i]===""){delete config[i]}}if(config.hasOwnProperty("skipRender")){this.skipRender=config.skipRender}if(!config.graphType||config.graphType.match(/Scatter/)){this.dataTableTransposed=false}for(var i=0;i<CanvasXpress.config.length;i++){var o=CanvasXpress.config[i];var t=CanvasXpress.doc.P[o]?CanvasXpress.doc.P[o].T:false;if(config.hasOwnProperty(o)){if(t=="array"){if(config[o] instanceof Array){this[o]=config[o]}else{this[o]=[config[o]];config[o]=[config[o]]}}else{this[o]=config[o]}}}}this.ms();this.od();for(var p in this.url){if(this.hasOwnProperty(p)){this[p]=this.url[p]}}this.Ei();this.S3();this.lg();window.pcX={};if(CanvasXpress.system.isShiny){this.disableUndoRedoKeys=true}}};CanvasXpress.prototype.initDate=function(){var a=function(){var b=/d{1,4}|m{1,4}|yy(?:yy)?|([HhMsTt])\1?|[LloSZ]|"[^"]*"|'[^']*'/g,c=/\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g,e=/[^-+\dA-Z]/g,d=function(g,f){g=String(g);f=f||2;while(g.length<f){g="0"+g}return g};return function(j,w,r){var h=a;if(arguments.length==1&&Object.prototype.toString.call(j)=="[object String]"&&!/\d/.test(j)){w=j;j=undefined}j=j?new Date(j):new Date;if(isNaN(j)){throw SyntaxError("invalid date")}w=String(h.masks[w]||w||h.masks["default"]);if(w.slice(0,4)=="UTC:"){w=w.slice(4);r=true}var u=r?"getUTC":"get",n=j[u+"Date"](),f=j[u+"Day"](),k=j[u+"Month"](),q=j[u+"FullYear"](),t=j[u+"Hours"](),l=j[u+"Minutes"](),v=j[u+"Seconds"](),p=j[u+"Milliseconds"](),g=r?0:j.getTimezoneOffset(),i={d:n,dd:d(n),ddd:h.i18n.dayNames[f],dddd:h.i18n.dayNames[f+7],m:k+1,mm:d(k+1),mmm:h.i18n.monthNames[k],mmmm:h.i18n.monthNames[k+12],yy:String(q).slice(2),yyyy:q,h:t%12||12,hh:d(t%12||12),H:t,HH:d(t),M:l,MM:d(l),s:v,ss:d(v),l:d(p,3),L:d(p>99?Math.round(p/10):p),t:t<12?"a":"p",tt:t<12?"am":"pm",T:t<12?"A":"P",TT:t<12?"AM":"PM",Z:r?"UTC":(String(j).match(c)||[""]).pop().replace(e,""),o:(g>0?"-":"+")+d(Math.floor(Math.abs(g)/60)*100+Math.abs(g)%60,4),S:["th","st","nd","rd"][n%10>3?0:(n%100-n%10!=10)*n%10]};return w.replace(b,function(m){return m in i?i[m]:m.slice(1,m.length-1)})}}();a.masks={"default":"ddd mmm dd yyyy HH:MM:ss",shortDate:"m/d/yy",mediumDate:"mmm d, yyyy",longDate:"mmmm d, yyyy",fullDate:"dddd, mmmm d, yyyy",shortTime:"h:MM TT",mediumTime:"h:MM:ss TT",longTime:"h:MM:ss TT Z",isoDate:"yyyy-mm-dd",isoTime:"HH:MM:ss",isoDateTime:"yyyy-mm-dd'T'HH:MM:ss",isoUtcDateTime:"UTC:yyyy-mm-dd'T'HH:MM:ss'Z'",year:"yyyy",yearMonth:"mmm yyyy",month:"mmmm",day:"dddd",hour:"HH",minute:"MM",second:"ss"};a.i18n={dayNames:["Sun","Mon","Tue","Wed","Thu","Fri","Sat","Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],monthNames:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec","January","February","March","April","May","June","July","August","September","October","November","December"]};Date.prototype.format=function(b,c){return a(this,b,c)};this.zy=function(b){return !isNaN(new Date(b))};this.dateFormat=a};CanvasXpress.prototype.initText=function(){this.RW=function(C,A,z,a,D,u,p,v,j,w,d,g,B){if(C==undefined){C=""}var q=["poly"];var o=this.E1(p);var j=this.uo(C,p,B)*(Math.PI*0.5)/a;D=(D+(u/2))-(j/2)%(Math.PI*2);u=D+j;var n=this.cB(A,z,a,D,u,true);for(var k=0;k<n.length;k++){q.push(n[k][0],n[k][1])}n=this.cB(A,z,a-o,D,u);for(var k=0;k<n.length;k++){q.push(n[k][0],n[k][1])}if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?q:this.ML(q)}else{return q}};this.Lg=function(k,j,h,p,n,B,A,C,v,D,q,d,u){if(k==undefined){k=""}if(!u){u=this.ZO()}if(k==null){return}if(!u){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(j)||isNaN(h)){if(this.debug){alert("Not a valid coordinate ("+j+", "+h+") to draw "+k)}return}if(!d&&!isNaN(k)){k=this.qY(k)}k=k.toString().replace("\x00","");if(!j){j=0}if(!h){h=0}if(!A){A=this.font}if(!C){C=this.foreground}if(!v){v=this.align}if(!D){D=this.baseline}this.GG(u);var o={strokeStyle:(this.eO(C)?C[0]:C),fillStyle:(this.eO(C)?C[0]:C),font:A,textAlign:v,textBaseline:D,funcs:[]};var z=v=="right"?1:-1;var a=this.E1(A);if(((["left","center"].indexOf(v)>-1)&&q)||(v=="right"&&!q)){k=k.split("").reverse().join("");if(this.eO(C)){C=C.reverse()}}o.funcs.push(["translate",[j,h]]);n+=(Math.PI*!q);n+=(Math.PI/2)+(B/2);if(v=="center"){for(var w=0;w<k.length;w++){var g=this.uo(k[w],A,u);n+=((g+(w==k.length-1?0:this.circularLetterSeparationFactor))/(p-a))/2*-z}}B=n;o.funcs.push(["rotate",[n]]);for(var w=0;w<k.length;w++){var g=this.uo(k[w],A,u);B+=(g/2)/(p-a)*z;o.funcs.push(["rotate",[(g/2)/(p-a)*z]]);if(this.eO(C)){o.strokeStyle=C[w];o.fillStyle=C[w]}o.funcs.push(["fillText",[k[w],0,(q?1:-1)*(0-p+a/2)]]);B+=(g/2+this.circularLetterSeparationFactor)/(p-a)*z;o.funcs.push(["rotate",[(g/2+this.circularLetterSeparationFactor)/(p-a)*z]])}u.o.push(o);this.mJ(u)};this.sM=function(o,n,k,A,B,E,D,g,q,p,j){if(o==undefined){o=""}var r=o.split(/\n/);var w=this.E1(A);var C=[];var F=k+(r%2?0:w/2)-(r.length*w/2);for(var u=0;u<r.length;u++){C.push(this.st(r[u],n,F,A,B,E,D,g,q,p,j));F+=w}var z=C[0][1];var e=C[0][2];var v=C[0][3];var d=C[0][4];for(var u=1;u<C.length;u++){z=Math.min(z,C[u][1]);e=Math.min(e,C[u][2]);v=Math.max(v,C[u][3]);d=Math.max(d,C[u][4])}return[C[0][0],z,e,v,d]};this.B7=function(B,w,r,o,q,v,u,e,h,C,z,A){var j=B.split(/\n/);var d=o;if(!d){d=this.font}var n=this.E1(d);var p=r+(j%2?0:n/2)-(j.length*n/2);for(var k=0;k<j.length;k++){this.mh(j[k],w,p,d,q,v,u,e,h,C,z,A);p+=n;if(e&&e<90){w+=n;p-=n}}};this.st=function(p,n,l,C,D,F,E,g,r,q,k,u){var j=this;var v=function(b){b.shift();var a=["poly"];a=a.concat(j.gf(b[0],b[1],n,l,g));a=a.concat(j.gf(b[2],b[1],n,l,g));a=a.concat(j.gf(b[2],b[3],n,l,g));a=a.concat(j.gf(b[0],b[3],n,l,g));return a};if(p==undefined){p=""}if(k){if(n<this.marginLeft+this.offsetX+this.left||n>this.marginLeft+this.offsetX+this.left+this.x){return}if(l<this.marginTop+this.offsetY+this.top||l>this.marginTop+this.offsetY+this.top+this.y){return}}if(this.SC(p)){return this.sM(p,n,l,C,D,F,E,g,r,q,k)}var G=[];var o=this.uo(p,C,u);var z=this.E1(C);var B,e,A,d;var i=0;if(r){while(o>r&&i<10){p=p.substring(0,p.length-1);o=this.uo(p,C,u);i++}}if(F=="left"){B=n;A=B+o}else{if(F=="right"){B=n-o;A=n}else{B=n-(o/2);A=n+(o/2)}}if(E=="top"){e=l;d=e+z}else{if(E=="bottom"){e=l-z;d=l}else{e=l-(z/2);d=l+(z/2)}}G=["rect",B,e,A,d];G=g?v(G):G;if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?G:this.ML(G)}else{return G}};this.mh=function(u,o,k,i,j,n,l,e,g,z,q,r,v){if(u==undefined){u=""}if(!r){r=this.ZO()}var h=0;if(u==null){return}if(this.SC(u)){return this.B7(u,o,k,i,j,n,l,e,g,z,q,r)}if(!r){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(o)||isNaN(k)){if(this.debug){alert("Not a valid coordinate ("+o+", "+k+") to draw "+u)}return}if(q){if(o<this.marginLeft+this.offsetX+this.left||o>this.marginLeft+this.offsetX+this.left+this.x){return}if(k<this.marginTop+this.offsetY+this.top||k>this.marginTop+this.offsetY+this.top+this.y){return}}if(!o){o=0}if(!k){k=0}if(!i){i=this.font}if(!j){j=this.foreground}if(!n){n=this.align}if(!l){l=this.baseline}var p=this.uo(u,i,r);if(g){while(p>g&&h<10){u=u.substring(0,u.length-1);p=this.uo(u,i,r);h++}}if(v){r.resetRender()}if(e){r.o.push({funcs:[["save",[]]]})}var d={strokeStyle:j,fillStyle:j,font:i,textAlign:n,textBaseline:l,funcs:[]};if(e){r.o.push({funcs:[["translate",[o,k]]]});r.o.push({funcs:[["rotate",[e]]]});o=k=0}u=u.toString().replace("\x00","").replace("u0000","");if(z){d.funcs.push(["strokeText",[u,o,k]])}else{d.funcs.push(["fillText",[u,o,k]])}r.o.push(d);if(e){r.o.push({funcs:[["restore",[]]]})}if(v){r.render();r.resetRender()}};this.SC=function(b){var a=b.toString().split(/\n/);return a.length-1};this.T5=function(a){if(a){return a.charAt(0).toUpperCase()+a.slice(1)}};this.I1=function(a){if(a){return a.charAt(0).toLowerCase()+a.slice(1)}};this.e0=function(e,g,c){var b=e.split(/\n/);var a=0;if(!c){c=this.ZO();if(!c){return 0}}if(!g){g=this.font}c.font=g;for(var d=0;d<b.length;d++){a=Math.max(a,c.measureText(b[d]).width)}return a};this.uo=function(d,h,a){if(!a){a=this.ZO()}if(!d||!a){return 0}d=d.toString();if(!h){h=this.font}try{CanvasXpress}catch(i){return false}if(this.graphType=="TagCloud"){if(!CanvasXpress.cacheText[h]){CanvasXpress.cacheText[h]={}}if(!CanvasXpress.cacheText[h][d]){a.font=h;if(this.SC(d)){CanvasXpress.cacheText[h][d]=this.e0(d,h,a)}else{CanvasXpress.cacheText[h][d]=a.measureText(d).width}}return CanvasXpress.cacheText[h][d]}else{var b=h.replace(/[\d]+px/,"").replace(/\s\s/," ");var c=this.E1(h).toString();if(!CanvasXpress.cacheText[b]){CanvasXpress.cacheText[b]={}}if(!CanvasXpress.cacheText[b][d]){CanvasXpress.cacheText[b][d]={};a.font=h;if(this.SC(d)){CanvasXpress.cacheText[b][d][c]=this.e0(d,h,a)}else{CanvasXpress.cacheText[b][d][c]=a.measureText(d).width}}else{if(!CanvasXpress.cacheText[b][d].hasOwnProperty("ss")){var g=Object.keys(CanvasXpress.cacheText[b][d])[0];CanvasXpress.cacheText[b][d][c]=CanvasXpress.cacheText[b][d][g]*(c/g)}}return CanvasXpress.cacheText[b][d][c]}};this.vL=function(b,c){var a=this.SC(b);if(a>0){return(this.E1(c)+this.margin)*(a+1)}else{return this.E1(c)}};this.yY=function(c,i,b,d,a){var g=Math.ceil(i);if(this.fontStyle==false){this.fontStyle=""}var e=this.fontStyle+" "+g+"px "+this.fontName;if(c){while(this.uo(c,e,a)>b&&g>=this.minTextSize){g-=2;e=this.fontStyle+" "+g+"px "+this.fontName}if(d){while(parseInt(g/1.33)>d-2){g--}e=this.fontStyle+" "+g+"px "+this.fontName}}if(this.fontScaleFontFactor!=1){e=this.fontStyle+" "+parseInt(g*this.fontScaleFontFactor)+"px "+this.fontName}return e};this.E1=function(a){return a?Math.max(1,parseInt(a.toString().match(/[\-\d]+/)[0])):1};this.rO=function(a){var d=this.scaleTextConstantMult;if(!a){a=1}return Math.ceil(1/Math.sqrt(a)*d)};this.zG=function(c,b){var a=new RegExp("(?![^\\n]{1,"+b+"}$)([^\\n]{1,"+b+"})([\\s|-])","g");return c.toString().replace(a,"$1$2\n").replace(" \n","\n")};this.Iq=function(l,h,u){var v=RegExp("(?:\\s|^)(.{1,"+h+"})(?=\\s|$)","g");var k=[];var t=[];var g=[];var p=0;var s=0;var o=this.uo(" ",u||this.font);while((m=v.exec(l))!==null){k.push(m[1])}for(var f=0;f<k.length-1;f++){if(k[f].indexOf(" ")!=-1){while(k[f].length<h){for(var e=0;e<k[f].length-1;e++){if(k[f][e]==" "){k[f]=k[f].substring(0,e)+" "+k[f].substring(e);if(k[f].length==h){break}while(k[f][e]==" "){e++}}}}}t.push(k[f])}t.push(k[k.length-1]);for(var f=0;f<t.length-1;f++){var c=this.uo(t[f],u);if(c>p){p=c;s=f}g.push(c)}for(var f=0;f<t.length-1;f++){var d=parseInt((p-g[f])/o);var e=/\s+/gi;var a=[];var b;if(d>0){while((b=e.exec(t[f]))!=null){a.push(b.index)}if(a.length>d){while(d>0){t[f]=t[f].substring(0,a[d-1])+" "+t[f].substring(a[d-1]);d--}}else{while(g[f]+o<p){t[f]=t[f].replace(" ","  ");g[f]+=o}}}}return t.join("\n")};this.f0=function(a,b){var d=this.E1(a);var c=Math.max(1,parseInt(d*b));return a.replace(d+"px",c+"px")};this.qY=function(f,e){var c=(!isNaN(e)&&parseInt(e!=null?e:10)>0)?parseFloat(f).toFixed(parseInt(e!=null?e:10)):Number(f);var b=parseFloat(c);if(Math.abs(b)<0.0001||Math.abs(b)>99999||b.toString().length>=8){var a=b.toExponential(2).toString().replace("e+0","").replace(".00","").replace(/(\.[0-9])(0)/,"$1");if(a.match(/e\+1$/)||a.match(/e\+2$/)||a.match(/e\-1$/)){a=(a*1).toString()}return a}else{return b.toString()}};this.VU=function(b,h){var c={};var f=[];var g=[];for(var e=0;e<b.length;e++){var d=b[e]!=null?b[e].toString():"";if(!c.hasOwnProperty(d)){c[d]=true;f.push([d,d.length])}}f.sort(function(j,i){return j[1]<i[1]?-1:j[1]>i[1]?1:0});if(!h){h=10}if(f.length<h){h=f.length}for(var e=0;e<h;e++){g.push(f[e][0])}return this.wS(g)};this.wS=function(e,j,d){var h="";var b=0;if(e&&e.length>0){if(!j){j=this.font}for(var g=0;g<e.length;g++){if(e[g]){var k=this.uo(e[g].toString(),j,d);if(k>b){h=e[g].toString();b=k}}}}return h};this.Cv=function(c,b,a){if(c==null){return""}c=c.toString();if(!c){return""}if(a&&c.length>b){return c.substring(0,Math.max(parseInt(a/b)-2,1))+".."}else{if(c.length<=b){return c}else{return c.substring(0,b-3)+"..."}}};this.RI=function(a){if(!isNaN(a)){return parseFloat(a)}else{return a}};this.KZ=function(){var k=function(c,a){for(var f=[];a>0;f[--a]=c){}return(f.join(""))};var g=0,n,h=arguments[g++],d=[],e,b,j,l;while(h){if(e=/^[^\x25]+/.exec(h)){d.push(e[0])}else{if(e=/^\x25{2}/.exec(h)){d.push("%")}else{if(e=/^\x25(?:(\d+)\$)?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gosuxX])/.exec(h)){if(((n=arguments[e[1]||g++])==null)||(n==undefined)){throw ("Too few arguments.")}if(/[^s]/.test(e[7])&&(typeof(n)!="number")){throw ("Expecting number but found "+typeof(n))}switch(e[7]){case"b":n=n.toString(2);break;case"c":n=String.fromCharCode(n);break;case"d":n=parseInt(n);break;case"e":n=e[6]?n.toExponential(e[6]):n.toExponential();break;case"f":n=e[6]?parseFloat(n).toFixed(e[6]):parseFloat(n);break;case"g":n=e[6]?String(Number(n).toPrecision(e[6])):parseFloat(n);break;case"o":n=n.toString(8);break;case"s":n=((n=String(n))&&e[6]?n.substring(0,e[6]):n);break;case"u":n=Math.abs(n);break;case"x":n=n.toString(16);break;case"X":n=n.toString(16).toUpperCase();break}n=(/[def]/.test(e[7])&&e[2]&&n>0?"+"+n:n);j=e[3]?e[3]=="0"?"0":e[3].charAt(1):" ";l=e[5]-String(n).length;b=e[5]?k(j,l):"";d.push(e[4]?n+b:b+n)}else{throw ("Huh ?!")}}}h=h.substring(e[0].length)}return d.join("")};this.Bg=function(h){var l=this;var j=function(r){var s;var q=function(u){if(!l.returnCachedLayout){s=r(u);for(var t=0;t<u.length;t++){s[t].dx=u[t].x-s[t].x;s[t].dy=u[t].y-s[t].y}}else{for(var t=0;t<u.length;t++){s[t].x=u[t].x-s[t].dx;s[t].y=u[t].y-s[t].dy}}return s};return q};var i=function(x,v){var t=function(s){return !isNaN(s)};var u=0,w=x.length,q,r=-1;if(arguments.length===1){while(++r<w){if(t(q=+x[r])){u+=q}}}else{while(++r<w){if(t(q=+v.call(x,x[r],r))){u+=q}}}return u};var b=(function(s,q){var r=function(y,x){return !(y.x>=x.x+x.width||y.x+y.width<=x.x||y.y>=x.y+x.height||y.y+y.height<=x.y)};if(r(s,q)){var w=Math.max(s.x,q.x);var u=Math.min(s.x+s.width,q.x+q.width);var v=Math.max(s.y,q.y);var t=Math.min(s.y+s.height,q.y+q.height);return(u-w)*(t-v)}else{return 0}});var o=(function(t){var s=function(z,C,B,w,A){return{x:z,y:C,width:B,height:w,location:A}};var r=t.x;var v=t.y;var u=t.width;var q=t.height;return[s(r,v,u,q,"bottom-right"),s(r-u,v,u,q,"bottom-left"),s(r-u,v-q,u,q,"top-left"),s(r,v-q,u,q,"top-right"),s(r,v-q/2,u,q,"middle-right"),s(r-u/2,v,u,q,"bottom-center"),s(r-u,v-q/2,u,q,"middle-left"),s(r-u/2,v-q,u,q,"top-center")]});var p=function(s,r){var q=function(t){var v=0;for(var u=0;u<t.length;u++){v+=t[u]}return v};return q(s.map(function(u,t){return r===t?0:b(s[r],u)}))};var k=function k(q){return i(q.map(function(r,s){return p(q,s)}))};var n=(function(r,q){return r.map(function(s,t){return[q(s,t),s,t]}).reduce(function(t,s){return t[0]>s[0]?s:t},[Number.MAX_VALUE,null,-1])});var a=function(){function x(z){function C(G,F){if(F==null||F>G.length){F=G.length}for(var I=0,H=new Array(F);I<F;I++){H[I]=G[I]}return H}function B(F){if(Array.isArray(F)){return C(F)}}function A(F){if(typeof Symbol!=="undefined"&&Symbol.iterator in Object(F)){return Array.from(F)}}function E(G,F){if(!G){return}if(typeof G==="string"){return C(G,F)}var H=Object.prototype.toString.call(G).slice(8,-1);if(H==="Object"&&G.constructor){H=G.constructor.name}if(H==="Map"||H==="Set"){return Array.from(G)}if(H==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(H)){return C(G,F)}}function D(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}return B(z)||A(z)||E(z)||D()}var w=function(B,z,A){return[].concat(x(B.slice(0,z)),[A],x(B.slice(z+1)))};var y=function(A,z){return A<z};var s=null;var q=y;var u=function(){return 0};var t;var r=function(A,z){return s-u(t[z],z,t)+u(A,z,w(t,z,A))};var v=function(B,A){function z(D){var F=0;for(var E=0;E<D.length;E++){F+=D[E]}return F}if(!s){s=z(t.map(function(E,D){return u(E,D,t)}))}var C=r(B,A);if(q(C,s)){return a().locationScore(u).winningScore(q).score(C).rectangles(w(t,A,B))}else{return v}};v.rectangles=function(){if(!arguments.length){return t}t=arguments.length<=0?undefined:arguments[0];return v};v.score=function(){if(!arguments.length){return s}s=arguments.length<=0?undefined:arguments[0];return v};v.winningScore=function(){if(!arguments.length){return q}q=arguments.length<=0?undefined:arguments[0];return v};v.locationScore=function(){if(!arguments.length){return u}u=arguments.length<=0?undefined:arguments[0];return v};return v};function c(){var q=[0,0];var s=function s(v){var u=k(v);var w=0;if(q[0]!==0&&q[1]!==0){var t={x:0,y:0,width:q[0],height:q[1]};w=i(v.map(function(y){var x=y.width*y.height-b(y,t);return x*2}))}return u+w};var r=function(u){var t=[];u.forEach(function(v){var w=o(v).map(function(x){var y=t.slice();y.push(x);return y});t=n(w,s)[1]});return t};r.bounds=function(t){if(!arguments.length){return q}q=t;return r};return r}var d=function(){var r=l.optimizeTextPositionEnforceBounds;var q=function(u){return r?u.width*u.height-b(u,r):0};var t=function(v,u,w){return p(w,u)+q(v)};var s=function s(v){var u=a().locationScore(t).rectangles(v);v.forEach(function(x,w){o(x).forEach(function(y,z){u=u(y,w)})});return u.rectangles()};s.bounds=function(){if(!arguments.length){return r}r=arguments.length<=0?undefined:arguments[0];return s};return s};var e=function(){var x=l.optimizeTextPositionTemperature;var r=l.optimizeTextPositionCooling;var q=l.optimizeTextPositionEnforceBounds;var t=function(z){return z[w(z)]};var w=function(z){return Math.floor(l.Xp()*z.length)};var y=function(z){switch(z.location){case"bottom-right":return 0;case"middle-right":case"bottom-center":return z.width*z.height/8}return z.width*z.height/4};var s=function(z){return q?z.width*z.height-b(z,q):0};var v=function(A,z,B){return p(B,z)+s(A)+y(A)};var u=function(E){var z=x;var D=function(G,F){return Math.exp((F-G)/z)>l.Xp()};var C=a().locationScore(v).winningScore(D).rectangles(E);while(z>0){var B=w(E);var A=t(o(E[B]));C=C(A,B);z-=r}return C.rectangles()};u.temperature=function(){if(!arguments.length){return x}x=arguments.length<=0?undefined:arguments[0];return u};u.cooling=function(){if(!arguments.length){return r}r=arguments.length<=0?undefined:arguments[0];return u};u.bounds=function(){if(!arguments.length){return q}q=arguments.length<=0?undefined:arguments[0];return u};return u};var g=function(w){w=w||function(y){return y};function t(x,A){function z(B,E){let minValue;let min=-1;for(var C=0;C<B.length;C++){const D=B[C];if(D!=null&&(minValue===undefined?E(D,D)===0:E(D,minValue)<0)){minValue=D;min=C}}return min}const y=z(x,A);return y<0?undefined:y}var r=(function(z,y,x){var A=y[x];if(typeof A!=="function"){throw new Error("Attempt to rebind ".concat(x," which isn't a function on the source object"))}return function(){for(var B=arguments.length,C=new Array(B),D=0;D<B;D++){C[D]=arguments[D]}var E=A.apply(y,C);return E===y?z:E}});var v=function(x){return function(y){return x.reduce(function(z,A){return z&&A(z)},y)}};var q=(function(D,x){for(var F=arguments.length,E=new Array(F>2?F-2:0),z=2;z<F;z++){E[z-2]=arguments[z]}var A=v(E);for(var B=0,C=Object.keys(x);B<C.length;B++){var y=C[B];var G=A(y);if(G){D[G]=r(D,x,y)}}return D});var s=function(y,x){return y[t(y,x)]};var u=function(y){y=w(y);var z=function(){var C=y.filter(function(D){return !D.hidden});var B=C.map(function(E,D){return[E,p(C,D)]});var A=s(B,function(E,D){return D[1]-E[1]});if(A[1]>0){A[0].hidden=true}else{return"break"}};while(true){var x=z();if(x==="break"){break}}return y};q(u,w);return u};var f=function(){var q=[0,0];var r=function(s){return s.map(function(w,v){var u=w.x;var t=w.y;if(u+w.width>q[0]){u-=w.width}if(t+w.height>q[1]){t-=w.height}return{height:w.height,width:w.width,x:u,y:t}})};r.bounds=function(){if(!arguments.length){return q}q=arguments.length<=0?undefined:arguments[0];return r};return r};switch(this.optimizeTextPositionStrategy){case"greedy":return j(g(c()))(h);case"annealing":return j(g(e()))(h);case"remove-overlaps":return j(g())(h);case"bounding-box":return j(g(f()))(h)}}};CanvasXpress.prototype.initTime=function(){Date.prototype.getWeek=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((((this-a)/86400000)+a.getDay()+1)/7)};Date.prototype.getDayYear=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((this-a)/86400000)};Date.prototype.addMilliseconds=function(a){let date=new Date(this.valueOf());date.setDate(date.getMilliseconds()+a);return date};Date.prototype.addSeconds=function(a){let date=new Date(this.valueOf());date.setDate(date.getSeconds()+a);return date};Date.prototype.addMinutes=function(a){let date=new Date(this.valueOf());date.setDate(date.getMinutes()+a);return date};Date.prototype.addHours=function(a){let date=new Date(this.valueOf());date.setDate(date.getHours()+a);return date};Date.prototype.addDays=function(a){let date=new Date(this.valueOf());date.setDate(date.getDate()+a);return date};Date.prototype.addMonths=function(a){let date=new Date(this.valueOf());date.setMonth(date.getMonth()+a);return date};Date.prototype.addYears=function(a){let date=new Date(this.valueOf());date.setYear(date.getFullYear()+a);return date};this.Sx=function(a){return a.getMilliseconds()};this.xB=function(a){return a.getSeconds()};this.r9=function(a){return a.getMinutes()+"."+a.getSeconds()};this.HR=function(a){return a.getMinutes()};this.bp=function(a){return a.getHours()+"."+a.getMinutes()};this.Dr=function(a){return a.getHours()};this.QY=function(a){return a.getFullYear()+"."+a.getWeek()};this.ah=function(a){return(a.getMonth()+1)+"."+(a.getDay()+1)};this.eh=function(a){return a.getFullYear()+"."+(a.getMonth()+1)};this.BW=function(a){return a.getFullYear()};this.times={second:1000,minute:60000,hour:3600000,day:86400000,week:604800000,month:2592000000,year:31556952000};this.Xb=function(j){var f=0;var c=0;var e=0;var k=parseInt(j.toString().substring(0,4));var a=parseInt(j.toString().substring(4,6).replace(/^0/,""));var g=parseInt(j.toString().substring(6,8).replace(/^0/,""));var b=j.toString().match(/\:/)?j.toString().substring(10).split(":"):false;if(b){f=b[0]?parseInt(b[0].replace(/^0/,"")):0;c=b[1]?parseInt(b[1].replace(/^0/,"")):0;e=b[2]?parseInt(b[2].replace(/^0/,"")):0}return new Date(k,a-1,g,f,c,e)};this.t6=function(f,w){var A,j,q,b,p,i,k,g,u,o,d,v,c,x,y,r,t,n,l,z,a,e;f=new Date(f);j=((A=f.getFullYear())+"").slice(-2);p=(i=f.getMonth()+1)<10?("0"+i):i;b=(q=["January","February","March","April","May","June","July","August","September","October","November","December"][i-1]).substring(0,3);u=(o=f.getDate())<10?("0"+o):o;g=(k=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"][f.getDay()]).substring(0,3);e=(o>=10&&o<=20)?"th":((a=o%10)==1)?"st":(a==2)?"nd":(a==3)?"rd":"th";w=w.replace("#YYYY#",A).replace("#YY#",j).replace("#MMMM#",q).replace("#MMM#",b).replace("#MM#",p).replace("#M#",i).replace("#DDDD#",k).replace("#DDD#",g).replace("#DD#",u).replace("#D#",o).replace("#th#",e);x=(v=f.getHours());if(x==0){x=24}if(x>12){x-=12}c=x<10?("0"+x):x;d=v<10?("0"+v):v;z=(l=v<12?"am":"pm").toUpperCase();y=(r=f.getMinutes())<10?("0"+r):r;t=(n=f.getSeconds())<10?("0"+n):n;return w.replace("#hhhh#",d).replace("#hhh#",v).replace("#hh#",c).replace("#h#",x).replace("#mm#",y).replace("#m#",r).replace("#ss#",t).replace("#s#",n).replace("#ampm#",l).replace("#AMPM#",z)};this.i0=function(b,a){if(b){if(this.timeFormat=="year"||b>this.times.year*2){if(b/(a||2)>=this.times.year){return"addYears"}else{return"addMonths"}}else{if(this.timeFormat=="month"||b>this.times.week){return"addDays"}else{if(b<this.times.second){return"addMilliseconds"}else{if(b<this.times.minute){return"addSeconds"}else{if(b<this.times.hour){return"addMinutes"}else{if(b<this.times.day){return"addHours"}else{return"addDays"}}}}}}}else{return"addDays"}};this.ct=function(b){var a=this.i0(b);switch(a){case"addYears":return"year";case"addMonths":return"month";case"addDays":return"shortDate";case"addHours":return"hour";case"addMinutes":return"minute";case"addSeconds":case"addMilliseconds":return"second"}};this.Y5=function(p,k,o){var b=new Date(p);var h=new Date(k);var m=h-b;var g=this.i0(m);var a=[];var f=[];while(b<h){var l=new Date(b);l=l[g](1);b=Date.parse(l);a.push(b)}var c=Math.max(1,Math.floor(a.length/(o-1)));for(var j=0;j<a.length;j++){if(j%c==0){if(a[j]>=0){f.push(a[j])}}}var l=f[1]-f[0];f.unshift(f[0]-l);f.push(f[f.length-1]+l);return f};this.tx=function(){var h=this.JJ();if(h.length){var k=Date.parse(h[0]);var a=Date.parse(h[h.length-1]);var g=a-k;var c=this.i0(g,h.length);this.timeValues=[this.dateFormat(new Date(k)[c](-1),this.timeFormat)];this.timeValueIndices=[-1];while(k<=a){var j=new Date(k);var e=this.dateFormat(j,this.timeFormat);var b=this.u4(this.timeFormat.match(/year|hour|minute|second/)?Number(e):e);this.timeValues.push(e);this.timeValueIndices.push(b);j=j[c](1);k=Date.parse(j)}}else{return[]}};this.uM=function(b){var e;var g=new Date();var a=g.getTime();var f=[new Date(a)];var h=this.isGroupedData?this.data.w.labs:this.data.y.smps;if(!b||!this.times[b]){b="day"}for(var c=0;c<h.length;c++){e=Date.parse(h[c]);if(!isNaN(e)){a=e}else{a-=this.times[b]}f.unshift(new Date(a))}return f};this.JJ=function(){var j=this.isGroupedData?this.data.w.labs:this.data.y.smps;var b=false;var h=[];for(var c=0;c<j.length;c++){var a=j[c];var e=this.timeFormat;switch(this.timeFormat){case"Year":case"year":a+="/01/02";e="isoDate";break;case"Month":case"month":a="2018/"+CanvasXpress.dates[a]+"/02";e="isoDate";break;case"Day":case"day":a="2018/01/"+CanvasXpress.dates[a];e="isoDate";break}if(!this.zy(a)){this.isGraphTime=false;alert("Invalid Date! Graph converted from Time Graph");return[]}var g=Date.parse(this.dateFormat(a,e));if(isNaN(g)){if(this.isExample){h=this.uM();return h}else{b=true;break}}else{h.push(new Date(g))}}h.sort(function(f,d){return f-d});return b?false:h}};CanvasXpress.prototype.initColor=function(){this.DF=function(e,m,d){var g=e;if(g){g=g.toString();g=g.replace(/\s/g,"");var i=(/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/).exec(g);var b=(/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/).exec(g);var a=(/^#?([0-9abcdef]{6})/i).exec(g);var l=(/^([0-9abcdef]{6})/i).exec(g);var k=(/^#?([0-9abcdef]{8})/i).exec(g);var j=(/^([0-9abcdef]{8})/i).exec(g);if(CanvasXpress.colorNames.hasOwnProperty(g)){g=this.ZD(CanvasXpress.colorNames[g])}else{if(i!=null){g=i[0]}else{if(b!=null){g=b[0]}else{if(a!=null){g=this.ZD(a[0])}else{if(l!=null){g=this.ZD("#"+l[0])}else{if(k!=null){g=this.ZD("#"+k[0].substring(0,6));m=parseInt(d.substring(6,8),16)/100}else{if(j!=null){g=this.ZD("#"+j[0].substring(0,6));m=parseInt(d.substring(6,8),16)/100}else{if(g=="[objectCanvasGradient]"){return e}else{g=false}}}}}}}}}g=g&&m!=null?this.a0(g,m,true):g?g:false;return g&&d?this.Aj(g):g};this.tv=function(e,b){b=(b==0)?0:(b||10);var d=this.Py(e,true);d[1]-=Math.min(1,Math.max(0,b/100));e="hsl("+Math.floor(d[0]*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)";this.eC(e)};this.pb=function(e,b){b=(b==0)?0:(b||10);var d=this.Py(e,true);d[1]+=Math.min(1,Math.max(0,b/100));e="hsl("+Math.floor(d[0]*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)";this.eC(e)};this.pe=function(a){a=a.toString();a=this.DF(a).replace("rgba(","").replace("rgb(","").replace(")","").split(",");return(a[3]&&Number(a[3])<0.5)||parseInt(a[0])*0.299+parseInt(a[1])*0.587+parseInt(a[2])*0.114>100?"#000000":"#FFFFFF"};this.M9=function(a){return this.tv(a,100)};this.rk=function(e,b){b=(b==0)?0:(b||10);var d=this.Py(e,true);d[2]+=Math.min(1,Math.max(0,b/100));e="hsl("+Math.floor(d[0]*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)";return this.eC(e)};this.I6=function(e,b){b=(b==0)?0:(b||10);var d=this.Py(e,true);d[2]-=Math.min(1,Math.max(0,b/100));e="hsl("+Math.floor(d[0]*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)";return this.eC(e)};this.j1=function(e,b){b=(b==0)?0:(b||10);var d=this.WB(e);d[0]=Math.max(0,Math.min(255,d[0]-Math.round(255*-(b/100))));d[1]=Math.max(0,Math.min(255,d[1]-Math.round(255*-(b/100))));d[2]=Math.max(0,Math.min(255,d[2]-Math.round(255*-(b/100))));return"rgb("+d[0]+","+d[1]+","+d[2]+")"};this.eS=function(b){var a=this.Py(b,true);a[0]=(a[0]+180)%360;b="hsl("+Math.floor(a[0]*100)+","+Math.floor(a[1]*100)+"%,"+Math.floor(a[2]*100)+"%)";return this.eC(b)};this.NU=function(e){var b=this.Py(e,true);var d=(b[0]+120)%360;var a=(b[0]+240)%360;return[e,this.eC("hsl("+Math.floor(d*100)+","+Math.floor(b[1]*100)+"%,"+Math.floor(b[2]*100)+"%)"),this.eC("hsl("+Math.floor(a*100)+","+Math.floor(b[1]*100)+"%,"+Math.floor(b[2]*100)+"%)")]};this.o5=function(f){var d=this.Py(f,true);var e=(d[0]+90)%360;var b=(d[0]+180)%360;var a=(d[0]+270)%360;return[f,this.eC("hsl("+Math.floor(e*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)"),this.eC("hsl("+Math.floor(b*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)"),this.eC("hsl("+Math.floor(a*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)")]};this.a9=function(g){var e=this.Py(g,true);var f=(e[0]+72)%360;var d=(e[0]+144)%360;var b=(e[0]+216)%360;var a=(e[0]+288)%360;return[g,this.eC("hsl("+Math.floor(f*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.eC("hsl("+Math.floor(d*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.eC("hsl("+Math.floor(b*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.eC("hsl("+Math.floor(a*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)")]};this.UW=function(h){var e=this.Py(h,true);var f=(e[0]+60)%360;var d=(e[0]+120)%360;var b=(e[0]+180)%360;var a=(e[0]+240)%360;var g=(e[0]+300)%360;return[h,this.eC("hsl("+Math.floor(f*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.eC("hsl("+Math.floor(d*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.eC("hsl("+Math.floor(b*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.eC("hsl("+Math.floor(a*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.eC("hsl("+Math.floor(g*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)")]};this.gG=function(e){var b=this.Py(e,true);var d=(b[0]+72)%360;var a=(b[0]+216)%360;return[e,this.eC("hsl("+Math.floor(d*100)+","+Math.floor(b[1]*100)+"%,"+Math.floor(b[2]*100)+"%)"),this.eC("hsl("+Math.floor(a*100)+","+Math.floor(b[1]*100)+"%,"+Math.floor(b[2]*100)+"%)")]};this.NP=function(m,e){var l=[];var o=this.WB(m);var a=Math.min(255,Math.max(0,o[0]));var k=Math.min(255,Math.max(0,o[0]));var p=Math.min(255,Math.max(0,o[0]));var h=this.Tr(a,255,a/(e+1));var d=this.Tr(k,255,k/(e+1));var q=this.Tr(p,255,p/(e+1));for(var j=0;j<h.length;j++){l.unshift("rgb("+Math.floor(h[j])+","+Math.floor(d[j])+","+Math.floor(q[j])+")")}return l};this.pQ=function(j,e){j=this.Aj(this.DF(j)).substring(1,7);var i=parseInt(j,16);var h=(i>>16)+e;h=h>255?255:h<0?0:h;var f=((i>>8)&255)+e;f=f>255?255:f<0?0:f;var d=(i&255)+e;d=d>255?255:d<0?0:d;j=d|(f<<8)|(h<<16);return this.ZD(j.toString(16))};this.Aj=function(b){var a=function(c){c=parseInt(c,10);if(isNaN(c)){return"00"}c=Math.max(0,Math.min(c,255));return"0123456789ABCDEF".charAt((c-c%16)/16)+"0123456789ABCDEF".charAt(c%16)};if(b&&b.substr(0,1)==="#"){return b}if(b&&b.match(/^rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/)){return"#"+a(RegExp.$1)+a(RegExp.$2)+a(RegExp.$3)}else{if(b&&b.match(/^rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/)){return"#"+a(RegExp.$1)+a(RegExp.$2)+a(RegExp.$3)}else{return b}}};this.Py=function(n,c){var j=this.WB(n);var a=j[0]/255;var k=j[1]/255;var o=j[2]/255;var p=Math.max(a,k,o);var f=Math.min(a,k,o);var i,q;var e=(p+f)/2;if(p==f){i=0;q=0}else{var m=p-f;q=e>0.5?m/(2-p-f):m/(p+f);switch(p){case a:i=(k-o)/m+(k<o?6:0);break;case k:i=(o-a)/m+2;break;case o:i=(a-k)/m+4;break}i/=6}if(c){return[i,q,e]}else{return"hsl("+Math.floor(i*100)+","+Math.floor(q*100)+"%,"+Math.floor(e*100)+"%)"}};this.vy=function(j,e){var d=this.DF(j.toString());if(d.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){var i=parseInt(255-RegExp.$1);var f=parseInt(255-RegExp.$2);var a=parseInt(255-RegExp.$3);if(i==f&&f==a){if(i>=127){d="rgb(255,255,255)"}else{d="rgb(0,0,0)"}}else{d="rgb("+i+","+f+","+a+")"}return e?this.Aj(d):d}else{return j}};this.ZD=function(c){var b=function(){return parseInt(c.substring(0,2),16)};var a=function(){return parseInt(c.substring(2,4),16)};var d=function(){return parseInt(c.substring(4,6),16)};c=c.charAt(0)=="#"?c.substring(1,7):c;return"rgb("+b()+","+a()+","+d()+")"};this.eC=function(n){var j=n.split(",");var i=Number(j[0].replace(/\s/g,"").replace("hsl(",""))/100;var o=Number(j[1].replace(/\s/g,"").replace("%",""))/100;var f=Number(j[2].replace(/\s/g,"").replace("%)",""))/100;if(o==0){return"rgb("+f+","+f+","+f+")"}else{var e=function(h,g,b){if(b<0){b+=1}if(b>1){b-=1}if(b<1/6){return h+(g-h)*6*b}if(b<1/2){return g}if(b<2/3){return h+(g-h)*(2/3-b)*6}return h};var c=f<0.5?f*(1+o):f+o-f*o;var d=2*f-c;var a=Math.round(e(d,c,i+1/3)*255);var k=Math.round(e(d,c,i)*255);var m=Math.round(e(d,c,i-1/3)*255);return"rgb("+a+","+k+","+m+")"}};this.a0=function(i,d,b,h,e){if(i){if(i instanceof CanvasGradient){return i}if(e){i=this.ZM(i,b)}var a=i.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);if(!a||!b){i=this.DF(i);a=i&&i.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i)}var g=d!=null&&!a[2]?Math.min(Number(d),1):a&&a[2]!=null?Math.min(Number(a[2]),1):1;return h?"rgba("+a[1]+",0)":a?"rgba("+a[1]+","+g+")":false}else{return false}};this.ZM=function(d,b){if(d){if(d instanceof CanvasGradient){return d}var a=d.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);if(!a||!b){d=this.DF(d);a=d&&d.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i)}return a?"rgb("+a[1]+")":false}else{return false}};this.ZL=function(d,b){if(!b){d=this.DF(d)}if(d){var a=d.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return !a?null:a[2]!=null?Number(a[2]):null}};this.mT=function(e,b){if(!b){e=this.DF(e)}var d;if(e&&e.match(/^rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/)){return false}else{if(e){var a=e.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return !a?false:a[2]!=null&&a[2]==0?true:false}else{return false}}};this.ns=function(j){var e=[];var d=[];var n=[];var k=[];for(var f=0;f<j.length;f++){j[f]=this.DF(j[f])}for(var f=0;f<j.length;f++){var l=j[f];if(l&&l.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){e.push(parseInt(RegExp.$1));d.push(parseInt(RegExp.$2));n.push(parseInt(RegExp.$3));if(RegExp.$4){k.push(parseFloat(RegExp.$4))}}}if(e.length>0){var a=parseInt(this.fj(e));var h=parseInt(this.fj(d));var m=parseInt(this.fj(n));if(k.length>0){var o=parseFloat(this.fj(k));return"rgba("+a+","+h+","+m+","+o+")"}else{return"rgb("+a+","+h+","+m+")"}}return false};this.WB=function(f){f=this.DF(f);var b=[];if(f){var d=(/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/).exec(f);var e=(/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/).exec(f);if(d!=null){b=[parseInt(d[1]),parseInt(d[2]),parseInt(d[3])]}else{if(e!=null){b=[parseInt(e[1]),parseInt(e[2]),parseInt(e[3]),Number(e[4])]}}}return b};this.tr=function(f,d){var b=this.WB(f);var e=Math.ceil(0.3*b[0]+0.59*b[1]+0.11*b[2]);if(d!=null){return"rgba("+e+","+e+","+e+","+d+")"}else{return"rgb("+e+","+e+","+e+")"}};this.tV=function(S,I){var q=this.WB(this.DF(S,I));var J=q[0];var Q=q[1];var T=q[2];var x=[0.7465,0.2535,1.273463,-0.073894];var A=[1.4,-0.04,0.968437,0.003331];var u=[1.748,0,0.062921,0.292119];if(J==0&&Q==0&&T==0){return"rgb(0,0,0)"}var l;switch(this.blindnessType){case"protanopia":l=x;break;case"deuteranopia":l=A;break;case"tritanopia":l=u;break;case"monochromatic":var S=Math.ceil((J*0.212656+J*0.715158+J*0.072186));return"rgb("+S+","+S+","+S+")"}var F=l[0];var D=l[1];var K=l[2];var z=l[3];var n=1;var y=Math.pow(J,2.2);var B=Math.pow(Q,2.2);var C=Math.pow(T,2.2);var i=y*0.412424+B*0.357579+C*0.180464;var h=y*0.212656+B*0.715158+C*0.072185;var f=y*0.019332+B*0.119193+C*0.950444;var k=i/(i+h+f);var j=h/(i+h+f);var w=(j-D)/(k-F);var L=j-k*w;var e=(z-L)/(w-K);var a=(w*e)+L;i=e*h/a;f=(1-(e+a))*h/a;var O=0.312713*h/0.329016;var M=0.358271*h/0.329016;var G=O-i;var E=M-f;var H=G*3.24071+E*-0.498571;var N=G*-0.969258+E*0.0415557;var R=G*0.0556352+E*1.05707;var d=i*3.24071+h*-1.53726+f*-0.498571;var o=i*-0.969258+h*1.87599+f*0.0415557;var s=i*0.0556352+h*-0.203996+f*1.05707;var U=((H<0?0:1)-d)/H;var m=((N<0?0:1)-o)/N;var p=((R<0?0:1)-s)/R;var P=[(U>1||U<0)?0:U,(m>1||m<0)?0:m,(p>1||m<0)?0:p];P=Math.max.apply(null,P);d=d+(P*H);o=o+(P*N);s=s+(P*R);d=Math.pow(d,1/2.2);o=Math.pow(o,1/2.2);s=Math.pow(s,1/2.2);J=Math.ceil(d);Q=Math.ceil(o);T=Math.ceil(s);if(J>255){J-=255}if(Q>255){Q-=255}if(T>255){T-=255}return"rgb("+J+","+Q+","+J+")"};this.Qy=function(){if(!this.gradientTemp){this.gradientTemp=this.gradient}if(this.transparencyTemp==null){this.transparencyTemp=this.transparency}if(!this.showShadowTemp){this.showShadowTemp=this.showShadow}this.gradient=false;this.transparency=null;this.showShadow=false};this.KY=function(){this.gradient=this.gradientTemp;this.transparency=this.transparencyTemp;this.showShadow=this.showShadowTemp};this.ZY=function(){delete (this.gradientTemp);delete (this.transparencyTemp);delete (this.showShadowTemp)};this.XK=function(f,e,d,c,b,a){if(this.gradientType=="radial"){return this.FI(f,e,d,b,a,true)}else{return this.DJ(f,e,d,c,b,a,true)}};this.DJ=function(d,o,a,m,j,l,k){if(!k){this.GG()}var p=this.ZO();var h=p.createLinearGradient(d,o,a,m);if(!j){j=this.colorSpectrum}else{if(this.DF(j)&&(!this.eO(j)||j.length<2)){j=[j,"rgb(0,0,0)"]}}if(!l||!this.eO(l)){l=this.graphType=="Heatmap"?[]:this.colorSpectrumBreaks}var q=1/(j.length-1);var e=q;for(var f=0;f<j.length;f++){j[f]=this.DF(j[f])}h.addColorStop(l[0]||0,this.transparency!=null?this.a0(j[0]):j[0]);for(var f=1;f<j.length;f++){h.addColorStop(l[f]||e,this.transparency!=null?this.a0(j[0]):j[f]);e+=q}return h};this.FI=function(p,k,a,j,m,l){if(!l){this.GG()}var q=this.ZO();var d=a/5.5;var h=q.createRadialGradient(p-d,k-d,1,p,k,a);if(!j){j=this.colorSpectrum}else{if(this.DF(j)&&(!this.eO(j)||j.length<2)){j=[j,"rgb(0,0,0)"]}}if(!m||!this.eO(m)){m=this.graphType=="Heatmap"?[]:this.colorSpectrumBreaks}var t=1/(j.length-1);var e=t;h.addColorStop(m[0]||0,this.transparency!=null?this.a0(j[0]):j[0]);for(var f=1;f<j.length;f++){h.addColorStop(m[f]||e,this.transparency!=null?this.a0(j[0]):j[f]);e+=t}return h};this.Oo=function(b){var a=b.match(/^\W*([0-9A-F]{3}([0-9A-F]{3})?)\W*$/i);if(a){if(a[1].length===6){this.sm(parseInt(a[1].substr(0,2),16)/255,parseInt(a[1].substr(2,2),16)/255,parseInt(a[1].substr(4,2),16)/255)}else{this.sm(parseInt(a[1].charAt(0)+a[1].charAt(0),16)/255,parseInt(a[1].charAt(1)+a[1].charAt(1),16)/255,parseInt(a[1].charAt(2)+a[1].charAt(2),16)/255)}}};this.sm=function(e,d,a){if(this.colorRGB){if(e!=null){this.colorRGB[0]=Math.min(Math.max(0,e),1)}if(d!=null){this.colorRGB[1]=Math.min(Math.max(0,d),1)}if(a!=null){this.colorRGB[2]=Math.min(Math.max(0,a),1)}var c=this.cM(this.colorRGB[0],this.colorRGB[1],this.colorRGB[2]);if(c[0]!=null){this.colorHSV[0]=c[0]}if(c[2]!=0){this.colorHSV[1]=c[1]}this.colorHSV[2]=c[2]}};this.cM=function(i,f,c){var j=Math.min(Math.min(i,f),c);var d=Math.max(Math.max(i,f),c);var a=d-j;if(a==0){return[null,0,d]}else{var e=i==j?3+(c-f)/a:(f==j?5+(i-c)/a:1+(f-i)/a);return[e==6?0:e,a/d,d]}};this.xj=function(c,b,a){if(c!=null){this.colorHSV[0]=Math.min(Math.max(0,c),6)}if(b!=null){this.colorHSV[1]=Math.min(Math.max(0,b),1)}if(a!=null){this.colorHSV[2]=Math.min(Math.max(0,a),1)}this.colorRGB=this.RL(this.colorHSV[0],this.colorHSV[1],this.colorHSV[2])};this.RL=function(e,d,b){if(e==null){return[b,b,b]}var c=Math.floor(e);var g=c%2?e-c:1-(e-c);var a=b*(1-d);var j=b*(1-d*g);switch(c){case 0:return[b,j,a];case 1:return[j,b,a];case 2:return[a,b,j];case 3:return[a,j,b];case 4:return[j,a,b];case 5:return[b,a,j];case 6:return[b,a,j]}};this.u5=function(){if(this.colorRGB){return(256|Math.round(255*this.colorRGB[0])).toString(16).substr(1)+(256|Math.round(255*this.colorRGB[1])).toString(16).substr(1)+(256|Math.round(255*this.colorRGB[2])).toString(16).substr(1)}};this.p1=function(){return this.Nf(CanvasXpress.colorNames)};this.TS=function(){return this.Nf(CanvasXpress.colorSchemes)};this.vN=function(b){var c=/^#?[0-9a-fA-F]{6}$/i;var a=/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/;if(c.test(b)){return b.substring(b.length-6,b.length)}else{if(a.test(b)){return this.Aj(b)}else{var d=b.toLowerCase();if(CanvasXpress.colorNames.hasOwnProperty(d)){return CanvasXpress.colorNames[d]}else{throw new Error(b+" is not a valid color.")}}}};this.eN=function(a,c){if(!a){a=this.meta.def.colorBrew}for(var d=0;d<a.breaks.length;d++){if(a.breaks[d]>=c){return a.colors[d]}}return a.colors[a.colors.length-1]};this.Y3=function(a,d){var g=this;var c=function(n){var l=function(w,t){var p=a.grads[n];var u=p.min;var B=p.max;var s=p.scol.replace("#","").substring(w,t);var C=p.ecol.replace("#","").substring(w,t);var y=d<u?u:d>B?B:d;var i=B-u;var z=parseInt(s,16);var o=parseInt(C,16);var x=(o-z)/i;if(isNaN(x)){x=0}var q=Math.round(x*(y-u)+z);var A=q.toString(16);return A.length==1?"0"+A:A};var m=l(0,2);var k=l(2,4);var b=l(4,6);return g.ZD("#"+m+k+b)};if(!a){a=this.meta.def.colorBrew}if(a.length==1){return c(0)}else{if(this.colorSpectrumBinned){if(a.stops&&a.stops.length){var h=a.stops.length-1;var f=(a.stops[h]-a.stops[0])/a.spectrum.length;var j=0;for(var e=a.stops[0];e<=a.stops[h];e+=f){if(e>d){return a.spectrum[Math.max(0,j-1)]}j++}}else{var f=a.range/a.spectrum.length;var j=0;for(var e=a.min;e<=a.max;e+=f){if(e>d){return a.spectrum[Math.max(0,j-1)]}j++}}}else{for(var e=0;e<a.grads.length;e++){if(a.grads[e].min<=d&&a.grads[e].max>d){return c(e)}}var f=(a.max-a.min)/a.grads.length;var e=Math.min(Math.floor((Math.max(d,a.min)-a.min)/f),a.grads.length-1);return isNaN(e)||!a.grads.length?"rgba(0,0,0,0)":c(e)}}};this.s8=function(M,D,H,g,f,c){var h=M||this.colorSpectrum;var C=this.graphType=="Genome";if(D!=null&&H!=null&&D==H){H+=0.1}var I=D!=null&&f&&f.length?Math.min(D,f[0]):D!=null?D:this.minData!=null?this.minData:0;var o=H!=null&&f&&f.length?Math.max(H,f[f.length-1]):H!=null?H:this.maxData!=null?this.maxData:100;var K=!C&&!c&&this.setMinX!=null?this.setMinX:null;var w=!C&&!c&&this.setMaxX!=null?this.setMaxX:null;var E,t;var N=[];if(g==null){zero=(I+o)/2}else{zero=g;var E=g-I;var t=o-g;if(E>t){o=g+E}else{I=g-t}}var x=this.heatmapIndicatorWidth<250?3:this.heatmapIndicatorWidth<500?5:7;var q=this[this.axisAlgorithm](Math.min(K||I,w||o),Math.max(K||I,w||o),x,this.isGraphTime,this.axisWilkinsonLoose);if(this.colorSpectrumBinned&&f&&f.length){q=f}if(o==Math.abs(I)&&g==0&&q.length%2){q[Math.floor(q.length/2)]=0}var G=(q[q.length-1]-q[0])/(h.length-1);var a=this.ab(q[1]-q[0]);var d=[];for(var F=0;F<q.length;F++){d[F]=q[F].toFixed(a)}var e=this.wS(d);var J=this.uo(e.toString(),this.font);var m=q[q.length-1]-q[0];var u=[];if(f&&f.length>1&&f.length==h.length){for(var F=0;F<f.length;F++){f[F]=Number(f[F]);u.push(this.qY(f[F].toString()))}e=this.wS(u);J=this.uo(e.toString(),this.font);f=f.sort(function(l,i){return l-i});var y=f[0];var B=Math.ceil(100/h.length)+1;for(var F=1;F<f.length;F++){var k=f[F];var L=this.Tr(y,k,false,B);y=L.pop();N=N.concat(L)}N.push(y);this.colorSpectrumNumber=N.length}else{N=this.Tr(q[0],q[q.length-1],false,this.colorSpectrumNumber)}var j={spectrum:h,stops:f,z:g,colors:[],smooth:[],grads:[],rmin:I,rmax:o,min:(f&&f.length>1?f[0]:q[0]),max:(f&&f.length>1?f[f.length-1]:q[q.length-1]),range:m,zero:zero,vals:q,valStr:d,incr:G,decs:a,breaks:N,maxLevLen:J,maxLevChr:e.toString().length,maxLevStr:e};for(var F=0;F<h.length-1;F++){var A={scol:this.vN(h[F]),ecol:this.vN(h[F+1]),min:(f&&f.length>1?f[F]:q[0]+(G*F)),max:(f&&f.length>1?f[F+1]:q[0]+(G*(F+1)))};j.grads.push(A)}for(var F=0;F<this.colorSpectrumNumber;F++){v=this.Y3(j,N[F]);j.colors.push(v)}return j};this.nW=function(d,f,e){this.Kn();if(!this.meta.def.colorBrew||d){if(this.meta.vals.colors){this.meta.vals.colors={}}if(this.graphType.match(/Stacked/)){this.meta.def.colorBrew=this.s8(this.colorSpectrum,this.minDataStacked,this.maxDataStacked,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{if(this.heatmapAutoAdjust||!this.meta.def.colorBrew){this.meta.def.colorBrew=this.s8(this.colorSpectrum,this.minData,this.maxData,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{var b=this.meta.def.colorBrew;if(f){if(this.isTransformedData){var c=this.showHistogram?0.000001:this.minData;var a=this.maxData;switch(this.isTransformedData){case"log2":c=Math.log(c)/Math.LN2;a=Math.log(a)/Math.LN2;break;case"log10":c=Math.log(c)/Math.LN10;a=Math.log(a)/Math.LN10;break;case"exp2":c=Math.pow(2,c);a=Math.pow(2,a);break;case"exp10":c=Math.pow(10,c);a=Math.pow(10,a);break}if(!this.tc(c,true)||!this.tc(a,true)){c=this.m8(this.data.y.trans);a=this.ds(this.data.y.trans)}this.meta.def.colorBrew=this.s8(this.colorSpectrum,c,a,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{if(e){this.meta.def.colorBrew=this.s8(this.colorSpectrum,e.rmin,e.rmax,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{this.meta.def.colorBrew=this.s8(this.colorSpectrum,this.minData||b.rmin,this.maxData||b.rmax,this.colorSpectrumZeroValue||b.z,this.colorSpectrumBreaks||b.stops)}}}else{this.meta.def.colorBrew=this.s8(this.colorSpectrum,b.rmin,b.rmax,b.z,b.stops)}}}}};this.P8=function(b,m,j){if(!b){b=8}if(!m||!CanvasXpress.colorSchemes.hasOwnProperty(m)){m=this.colorScheme}var k=this.b6(CanvasXpress.colorSchemes[m]);k.sort(function(d,c){return d-c});if(CanvasXpress.colorSchemes[m]){if(CanvasXpress.colorSchemes[m][b]){return CanvasXpress.colorSchemes[m][b]}else{if(k[k.length-1]==256){var g=this.G3(b);var a=[];for(var e=0;e<b;e++){var l=Math.max(0,Math.min(255,Math.floor(g[e]*256)));a.push(CanvasXpress.colorSchemes[m][256][l])}return a}else{if(b>k[k.length-1]){if(j){b--;while(!CanvasXpress.colorSchemes[m][b]){b--}return this.gg(CanvasXpress.colorSchemes[m][b])}else{var h=b-k.length;b--;while(!CanvasXpress.colorSchemes[m][b]){b--}var a=this.gg(CanvasXpress.colorSchemes[m][b]);for(var e=0;e<h;e++){a.push(CanvasXpress.colorSchemes[m][b][e%CanvasXpress.colorSchemes[m][b].length])}}return a}else{b++;while(!CanvasXpress.colorSchemes[m][b]){b++}return CanvasXpress.colorSchemes[m][b]}}}}else{return this.colors}};this.Kn=function(){if(this.blindnessType&&!this.meta.def.colorSpectrum){this.meta.def.colorSpectrum=this.gg(this.colorSpectrum);var b=[];for(var a=0;a<this.colorSpectrum.length;a++){b.push(this.tV(this.colorSpectrum[a]))}this.colorSpectrum=b;delete this.meta.def.colorBrew}else{if(this.meta.def.colorSpectrum&&this.meta.def.blindnessTypeSpectrum!=this.blindnessType){if(this.blindnessType){var b=[];for(var a=0;a<this.colorSpectrum.length;a++){b.push(this.tV(this.colorSpectrum[a]))}this.colorSpectrum=b;delete this.meta.def.colorBrew}else{this.colorSpectrum=this.gg(this.meta.def.colorSpectrum)}}}this.meta.def.blindnessTypeSpectrum=this.blindnessType};this.WP=function(o,f){var g=this;var a=false;var k;var d=function(q){if(g.data[q]){if(g.colorBy){return g.data[q].hasOwnProperty(g.colorBy)&&g.meta.data[q][g.colorBy].colors?g.meta.data[q][g.colorBy].colors.length:g.data.y.smps.length}else{var n=g.data.y.smps.length;for(var m in g.meta.data[q]){if(g.meta.data[q][m].levels){n=Math.max(n,g.meta.data[q][m].levels.length)}}return n}}return g.data.y.smps.length};if(this.colorScheme=="User"){k=this.gg(this.colors)}else{if(this.colorScheme=="ColorSpectrum"){var l=this.colorSpectrumNumber;this.colorSpectrumNumber=this.graphType=="Circular"?Math.max(this.data.y.vars.length,this.data.y.smps.length):this.data.y.vars.length;var p=this.s8(this.colorSpectrum,0,this.data.y.vars.length);k=p.colors;this.colorSpectrumNumber=l}else{if(CanvasXpress.colorSchemes[this.colorScheme]){var b;var j=this.b6(CanvasXpress.colorSchemes[this.colorScheme]);j.sort(function(m,i){return m-i});j=parseInt(j[j.length-1]);if(o&&o.type=="String"){b=o.levels.length}else{if(this.graphType.match(/Scatter/)){if(this.layoutValid&&!this.showHistogram){b=d("z")}else{if(this.showHistogram){var c=!this.layoutValid?d("z"):1;b=this.data.y.smps.length*c}else{if(this.colorBy&&this.meta.data.hasOwnProperty("z")&&this.meta.data.z.hasOwnProperty(this.colorBy)&&this.meta.data.z[this.colorBy].colors){b=this.meta.data.z[this.colorBy].levels.length}else{b=this.data.y.smps.length}}}}else{if(this.graphType.match(/Treemap|TagCloud|Sankey|Tree|Circular/)){b=this.colorBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)&&this.meta.data.x[this.colorBy].colors?this.meta.data.x[this.colorBy].colors.length:this.data.y.smps.length}else{if(this.graphType.match(/Venn/)){b=this.vennGroups}else{if(this.graphType.match(/Pie/)){b=this.data.y.vars.length}else{if(this.graphType.match(/Network|Genome|Correlation/)){b=j}else{if(this.graphType=="ParallelCoordinates"){b=this.colorBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)&&this.meta.data.x[this.colorBy].colors?this.meta.data.x[this.colorBy].colors.length:this.data.y.smps.length}else{if(this.graphType.match(/BarLine|DotLine/)&&this.coordinateLineColor&&(!this.isGroupedData||!this.colorBy)){b=Math.max(this.xAxis.length,this.xAxis2.length)}else{if(this.colorBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)){b=this.meta.data.x[this.colorBy].colors?this.meta.data.x[this.colorBy].colors.length:this.meta.data.x[this.colorBy].levels?this.meta.data.x[this.colorBy].levels.length:this.data.y.vars.length}else{b=this.data.y.vars.length}}}}}}}}}if(CanvasXpress.colorSchemes[this.colorScheme][b]){k=CanvasXpress.colorSchemes[this.colorScheme][b]}else{if(b>j){b--;while(!CanvasXpress.colorSchemes[this.colorScheme][b]){b--}}else{b++;while(!CanvasXpress.colorSchemes[this.colorScheme][b]){b++}}k=CanvasXpress.colorSchemes[this.colorScheme][b]}if(this.meta.def.colors){this.meta.def.colors=this.gg(k);a=true}}else{k=CanvasXpress.colorSchemes.Balanced[20]}}}if((this.blindnessType&&!this.meta.def.colors)||a){this.meta.def.colors=this.gg(k);if(this.blindnessType){var h=[];for(var e=0;e<k.length;e++){h.push(this.tV(k[e]))}k=h}}else{if(this.meta.def.colors&&this.meta.def.blindnessTypeColors!=this.blindnessType){k=this.gg(this.meta.def.colors);if(this.blindnessType){var h=[];for(var e=0;e<k.length;e++){h.push(this.tV(k[e]))}k=h}}}this.meta.def.blindnessTypeColors=this.blindnessType;for(var e=0;e<k.length;e++){k[e]=this.DF(k[e])}if(!o){this.colors=k}this.hr(k,o)};this.RG=function(){var b=[];for(var c=0;c<this.colors.length;c++){b.push(this.DF(this.colors[c]))}if(b.length>0){this.colors=b}var a=[];for(var c=0;c<this.colorSpectrum.length;c++){a.push(this.DF(this.colorSpectrum[c]))}if(a.length>0){this.colorSpectrum=a}}};CanvasXpress.prototype.initAttributes=function(){this.RV=function(b,a,c){return{fillStyle:b,strokeStyle:b,lineWidth:(a?a:this.outlineWidth),lineCap:(c?c:this.capType),funcs:[]}};this.Ce=function(k,j,l,e,g,d,c,a,i,m){if(m){this.GG(m);this.PW(k,j,m);if(a){this.XN(a,m)}}var b={funcs:[]};if(this.transparency!=null){g=this.a0(g,this.transparency,true)}if(this.gradient){if(this.gradientType=="radial"){b.fillStyle=this.XK(0,0,Math.max(Math.abs(l),Math.abs(e)),false,g)}else{b.fillStyle=this.XK(0,0,l,e,g)}}else{if(c){switch(c){case"closed":case"solid":b.fillStyle=g;break;case"open":break;default:if(g){if(g.match(/0.1\)$/)&&d.match(/0.1\)$/)){b.globalAlpha=0.1}}b.fillStyle=CanvasXpress.cachePatterns[c]?CanvasXpress.cachePatterns[c]:g;break}}else{b.fillStyle=g}}b.strokeStyle=d?d:this.foreground;b.lineWidth=i?i:this.outlineWidth;b.lineJoin=this.joinType;if((l&&b.lineWidth>=l)||(e&&b.lineWidth>=e)){b.strokeStyle=g}return b};this.tl=function(b,d,c,a){if(c&&c=="open"){a.funcs.push(["stroke",[]])}else{if(d==b){a.funcs.push(["fill",[]])}else{a.funcs.push(["fill",[]]);a.funcs.push(["stroke",[]])}}};this.AO=function(a){if(!a){a=this.ZO()}a.resetContext()};this.uf=function(c){var b,d,a,e;if(c&&c.length==4){b=c[0];d=c[1];a=c[2];e=c[3]}else{b=this.marginLeft+this.offsetX+this.left-1;d=this.marginTop+this.offsetY+this.top-1;a=this.x+2;e=this.y+2}return[b,d,a,e]};this.W6=function(a,e){if(this.graphType=="Tree"){return}if(!e){e=this.ZO()}var d,f,c,g;if(a){d=a[0];f=a[1];c=a[2];g=a[3]}else{if(this.layoutValid&&this.layoutParams&&this.layoutParams[0]){d=this.marginLeft+this.offsetX+this.layoutParams[0].left;f=this.marginTop+this.offsetY+this.layoutParams[0].top;c=this.layoutParams[0].x+1;g=this.layoutParams[0].y+1}else{d=this.marginLeft+this.offsetX+this.left;f=this.marginTop+this.offsetY+this.top;c=this.x+1;g=this.y+1}}e.o.push({funcs:[["save",[]],["beginPath",[]],["rect",[d,f,c,g]],["clip",[]]]})};this.VQ=function(a){if(this.graphType=="Tree"){return}if(!a){a=this.ZO()}a.o.push({funcs:[["restore",[]],["beginPath",[]],["rect",[0,0,this.width,this.height]],["clip",[]]]})};this.yQ=function(b,c){var a=0;if(b[0]<c[0]){a|=1}else{if(b[0]>c[2]){a|=2}}if(b[1]<c[1]){a|=4}else{if(b[1]>c[3]){a|=8}}return a};this.SZ=function(d,c,e,f){return e&8?[d[0]+(c[0]-d[0])*(f[3]-d[1])/(c[1]-d[1]),f[3]]:e&4?[d[0]+(c[0]-d[0])*(f[1]-d[1])/(c[1]-d[1]),f[1]]:e&2?[f[2],d[1]+(c[1]-d[1])*(f[2]-d[0])/(c[0]-d[0])]:e&1?[f[0],d[1]+(c[1]-d[1])*(f[0]-d[0])/(c[0]-d[0])]:null};this.R2=function(n,l,h){var k,j,d,m;if(!l){l=this.uf();l[2]+=l[0];l[3]+=l[1]}if(!h){h=[]}var g=n.length;var e=this.yQ(n[0],l);var c=[];for(var f=1;f<g;f++){k=n[f-1];j=n[f];d=m=this.yQ(j,l);while(true){if(!(e|d)){c.push(k);if(d!==m){c.push(j);if(f<g-1){h.push(c);c=[]}}else{if(f===g-1){c.push(j)}}break}else{if(e&d){break}else{if(e){k=this.SZ(k,j,e,l);e=this.yQ(k,l)}else{j=this.SZ(k,j,d,l);d=this.yQ(j,l)}}}}e=m}if(c.length){h.push(c)}return h};this.b9=function(k,j,c){var h,d,g,a,e;if(!j){j=this.uf();j[2]+=j[0];j[3]+=j[1]}if(c){xy=[];for(var f=1;f<k.length;f+=2){xy.push([k[f],k[f+1]])}}else{xy=k}for(var b=1;b<=8;b*=2){h=[];d=xy[xy.length-1];g=!(this.yQ(d,j)&b);for(var f=0;f<xy.length;f++){a=xy[f];e=!(this.yQ(a,j)&b);if(e!==g){h.push(this.SZ(d,a,b,j))}if(e){h.push(a)}d=a;g=e}xy=h;if(!xy.length){break}}if(c){k=["poly"];for(var f=0;f<h.length;f++){k.push(h[f][0]);k.push(h[f][1])}return k}return h};this.pP=function(e,l,d,j,b,h,m,g){if((e===d&&l===j)||(b===m&&h===g)){return false}var f=((g-h)*(d-e)-(m-b)*(j-l));if(f===0){return false}var c=((m-b)*(l-h)-(g-h)*(e-b))/f;var a=((d-e)*(l-h)-(j-l)*(e-b))/f;if(c<0||c>1||a<0||a>1){return false}var k=e+c*(d-e);var i=l+c*(j-l);return[k,i]};this.Pl=function(v,f,k){var d,c,p,n,j,o,v;var q,e,a,m;var u=[];if(!k){k=this.uf()}var e=k[0];var q=k[1];var a=k[2];var m=k[3];switch(v){case"path":u[0]=[];u[1]=[];for(var g=0;g<f[0].length;g++){c=f[0][g];n=f[1][g];if(c<e||c>a){c=null}if(n<q||n>m){n=null}u[0].push(c);u[1].push(n)}break;case"arrow":case"box":case"rect":case"rectangle":case"rect2":case"rect3":case"roundrect":case"roundrectt":case"roundrectb":case"roundrectr":case"roundrectl":case"roundrecttr":case"roundrecttl":case"roundrectbr":case"roundrectbl":case"roundrect2":case"roundrectd":case"roundrecto":d=this.qj(f[0]-(f[2]/2));p=this.qj(f[1]-(f[3]/2));c=this.qj(d+f[2]);n=this.qj(p+f[3]);if(c>d){if(n>p){if(d>a+this.outlineWidth||p>m+this.outlineWidth||c<e||n<q){return false}if(d<e){d=e}if(c>a){c=a}if(p<q){p=q}if(n>m){n=m}}else{if(d>a+this.outlineWidth||n>m+this.outlineWidth||c<e||p<q){return false}if(d<e){d=e}if(c>a){c=a}if(p>m){p=m}if(n<q){n=q}}}else{if(n>p){if(c>a+this.outlineWidth||p>m+this.outlineWidth||d<e||n<q){return false}if(d>a){d=a}if(c<e){c=e}if(p<q){p=q}if(n>m){n=m}}else{if(c>a+this.outlineWidth||n>m+this.outlineWidth||d<e||p<q){return false}if(d>a){d=a}if(c<e){c=e}if(p>m){p=m}if(n<q){n=q}}}u=[d,p,c-d,n-p];break;case"poly":break;case"circle":case"sphere":case"square":case"triangle":case"triangle2":case"equilateral":case"equilateral2":case"diamond":case"rhombus":case"pentagon":case"hexagon":case"octagon":case"oval":case"oval2":case"oval3":case"arc":case"arc2":case"ellipse":case"ellipse2":case"ellipse3":case"plus":case"minus":case"mdavid":case"star":case"pie":case"pie0":case"pie1":case"pie2":case"pie3":case"pie4":case"pie5":case"pie6":case"pie7":case"pie8":case"pie9":case"pacman":case"pacman2":d=parseInt(f[0]);p=parseInt(f[1]);if(d>e+a||d<e||p<q||p>q+m){return false}u=[d,p];break;case"line":d=parseFloat(f[0]);p=parseFloat(f[1]);c=parseFloat(f[2]);n=parseFloat(f[3]);if(d==c){if(d<e||d>a){return false}else{if(p>n){if(p<q){return false}else{if(p>m){p=m}}if(n>m){return false}else{if(n<q){n=q}}}else{if(p>m){return false}else{if(p<q){p=q}}if(n<q){return false}else{if(n>m){n=m}}}}}else{if(p==n){if(p<q||p>m){return false}else{if(d>c){if(d<e){return false}else{if(d>a){d=a}}if(c>a){return false}else{if(c<e){c=e}}}else{if(d>a){return false}else{if(d<e){d=e}}if(c<e){return false}else{if(c>a){c=a}}}}}else{if(d>c){if(d<e||c>a){return false}else{if(p>n){if(p<q||n>m){return false}else{j=p-n;o=d-c;if(d>a){p-=(d-a)*j/o;d=a}if(p>m){d-=(p-m)*o/j;p=m}if(c<e){n+=(e-c)*j/o;c=e}if(n<q){c+=(q-n)*o/j;n=q}}}else{if(n<q||p>m){return false}else{j=n-p;o=d-c;if(d>a){p+=(d-a)*j/o;d=a}if(p<q){d-=(q-p)*o/j;p=q}if(c<e){n-=(e-c)*j/o;c=e}if(n>m){c+=(n-m)*o/j;n=m}}}}}else{if(c<e||d>a){return false}else{if(p>n){if(p<q||n>m){return false}else{j=p-n;o=c-d;if(d<e){p-=(e-d)*j/o;d=e}if(p>m){d+=(p-m)*o/j;p=m}if(c>a){n+=(c-a)*j/o;c=a}if(n<q){c-=(q-n)*o/j;n=q}}}else{if(n<q||p>m){return false}else{j=n-p;o=c-d;if(d<e){p+=(e-d)*j/o;d=e}if(p<q){d+=(q-p)*o/j;p=q}if(c>a){n-=(c-a)*j/o;c=a}if(n>m){c-=(n-m)*o/j;n=m}}}}}}}u=[d,p,c,n];break;default:return false}return u};this.Xo=function(T,F,a,D,al,af,S,X,H,g,ai,aj,V,Y,Z,G){var ab=this.graphType=="Network"?this.lineWidthEvent:this.lineWidthEvent*4;var W=[];var M=["poly"];var U,ah,ag,J;if(this.eO(H)){U=H[0];ah=H[1]}else{U=H;ah=H}if(this.eO(g)){ag=g[0];J=g[1]}else{ag=g;J=g}if(!this.tc(ag,true)){ag=0}if(!this.tc(U,true)){U=0}if(!this.tc(J,true)){J=0}if(!this.tc(ah,true)){ah=0}T=this.b3(T,F,a,D,al,U,ag);if(T.match(/error/)){if(this.showErrorBars&&this.Hl([F,a,D,al,S])){F=Math.ceil(F);D=Math.ceil(D);a=Math.ceil(a);al=Math.ceil(al);S=Math.ceil(S);var O=S/2;if(S>0){M=["poly",F,a-ab,D-ab,al-ab,D-ab,al-O,D+ab,al-O,D+ab,al+O,D-ab,al+O,D-ab,al+ab,F,a+ab]}else{M=["poly",D-ab,al+ab,D-O,al+ab,D-O,al-ab,D+O,al-ab,D+O,al+ab,D+ab,al+ab,F+ab,a,F-ab,a]}}else{return false}}else{if(T=="spline"||T=="cardinalSpline"){if(F.length<3){return F.length<2?false:this.Xo("line",F[0],a[0],F[1],a[1],af,S,X,U,ag,ai,aj,V,Y,Z)}for(var ae=0;ae<F.length;ae++){M.push(F[ae],a[ae]-ab);W.push(a[ae]+ab,F[ae])}M=M.concat(W.reverse())}else{if(T=="arch"){if(F.length!=3||a.length!=3){return false}for(var ae=0;ae<F.length;ae++){if(!this.Hl([F[ae],a[ae]])){return false}}W=this.I2(F[0],a[0],F[1],a[1],F[2],a[2],0.25,true);for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}W=this.I2(F[0],a[0],F[1],a[1],F[2],a[2],0.25);for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}}else{if(T=="arc"){M=["poly"];W=this.cB(F,a,D,U,ag,true);for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}W=this.cB(F,a,D-ab,U,ag);for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}}else{if(T=="quadratic"){var y=this.Jk(F,a,D,al,false,Math.min(1,this.arrowQuadraticFactor*Math.abs(V))*(V>0?-1:1));var E=this.On(F,a,D,al,U,ag,T,V);var z=this.Th(E[0],E[1],y[0],y[1],ab);var x=this.Th(y[0],y[1],E[2],E[3],ab);W=this.I2(z[0],z[1],z[4],z[5],x[4],x[5],0.1,true);for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}var Q=[];W=this.I2(z[2],z[3],z[6],z[7],x[6],x[7],0.1,true);for(var ae=0;ae<W.length;ae++){Q.push(W[ae][1],W[ae][0])}M=M.concat(Q.reverse())}else{if(T=="roundLine"){M=["poly",F-ab,a,F-ab,al+ab,D,al+ab,D,al-ab,F+ab,al-ab,F+ab,a]}else{if(this.Hl([F,a,D,al])){var K=this.On(F,a,D,al,U,ag,T);F=K[0];a=K[1];D=K[2];al=K[3];if(ai){K=this.Pl("line",[F,a,D,al],aj);if(K){F=K[0];a=K[1];D=K[2];al=K[3]}else{return false}}if(V&&this.eO(V)&&V.length>0){if(this.VJ(V)){if(T.match(/bezier/i)){if(V[0].length==6){var ak=[V[0][0],V[0][1]];for(var ae=0;ae<V.length;ae++){ak=ak.concat(V[ae])}ak.push(V[V.length-1][0],V[V.length-1][1]);var h=this.gg(ak);for(var ae=0;ae<V.length;ae++){W=this.bs(h[0],h[1]-ab,h[2],h[3]-ab,h[4],h[5]-ab,h[6],h[7]-ab,0.1,true);for(var ad=0;ad<W.length;ad++){M.push(W[ad][0],W[ad][1])}for(var ad=0;ad<6;ad++){h.shift()}}h=this.gg(ak);var Q=[];for(var ae=0;ae<V.length;ae++){W=this.bs(h[0],h[1]+ab,h[2],h[3]+ab,h[4],h[5]+ab,h[6],h[7]+ab,0.1,true);for(var ad=0;ad<W.length;ad++){Q.push(W[ad][1],W[ad][0])}for(var ad=0;ad<6;ad++){h.shift()}}M=M.concat(Q.reverse())}else{if(V.length==4){var z=this.Th(V[0][0],V[0][1],V[1][0],V[1][1],ab);var x=this.Th(V[2][0],V[2][1],V[3][0],V[3][1],ab);W=this.bs(z[0],z[1],z[4],z[5],x[0],x[1],x[4],x[5],0.1,true);for(var ad=0;ad<W.length;ad++){M.push(W[ad][0],W[ad][1])}W=this.bs(z[2],z[3],z[6],z[7],x[2],x[3],x[6],x[7],0.1,true);var Q=[];for(var ad=0;ad<W.length;ad++){Q.push(W[ad][1],W[ad][0])}M=M.concat(Q.reverse())}else{var C=this.Th(V[0][0],V[0][1],V[V.length-1][0],V[V.length-1][1],ab);M=["poly",C[0],C[1],C[2],C[3],C[6],C[7],C[4],C[5]]}}}else{if(V.length>2){M=["poly"];var P=[];for(var ae=0;ae<V.length-1;ae++){P.push([V[ae][0],V[ae][1]])}for(var ae=V.length-1;ae>=1;ae--){P.push([V[ae][0],V[ae][1]])}W=this.NK(P,ab,1);for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}}else{var C=this.Th(V[0][0],V[0][1],V[1][0],V[1][1],ab);M=["poly",C[0],C[1],C[2],C[3],C[6],C[7],C[4],C[5]]}}}else{return false}}else{if(T.match(/curved/i)){var B=F==D&&a==al&&G;var u=this.Yu(F,a,D,al);var R=this.zJ(F,a,u[0],u[1]);var N=(U||0)/R;var I=(ag||0)/R;var A=T.match(/curvedcc/i)&&F>D?false:!T.match(/curvedcc/i)&&D>=F?true:false;var r=D>=F?Math.asin((u[1]-a)/R):Math.asin(-(u[1]-a)/R);var ac=r+Math.PI;var o=[];var d=0;var aa=false;if(B){if(r<0){r+=Math.PI*2}var v=G.size;var L=G.size*0.5;switch(G.pos){case"top":o=[F,a-v,L,Math.PI*0.75,Math.PI*0.25,false];break;case"topRight":o=[F+v,a-v,L,Math.PI,Math.PI*0.5,false];break;case"right":o=[F+v,a,L,Math.PI*1.25,Math.PI*0.75,false];break;case"bottomRight":o=[F+v,a+v,L,Math.PI*1.5,Math.PI,false];break;case"bottom":o=[F,a+v,L,Math.PI*1.75,Math.PI*1.25,false];break;case"bottomLeft":o=[F-v,a+v,L,0,Math.PI*1.5,false];break;case"left":o=[F-v,a,L,Math.PI*0.25,Math.PI*1.75,false];break;case"topLeft":o=[F-v,a-v,L,Math.PI*0.5,0,false];break}d=0.25}else{if(D>=F){o=[u[0],u[1],Math.max(0,R),r-I,ac+N,A]}else{aa=true;o=[u[0],u[1],Math.max(0,R),ac-I,r+N,!A]}}M=["poly"];W=this.iy(o[0],o[1],o[2]+ab,(aa?o[4]-(Math.PI*2):o[3]),(aa?o[3]:o[4]),o[5]*(aa?-1:1));for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}W=this.iy(o[0],o[1],o[2]-ab,(aa?o[4]-(Math.PI*2):o[3]),(aa?o[3]:o[4]),o[5]*(aa?1:-1));for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}}else{if(T.match(/bezier/i)){var l=(F+D)/2;var k=(a+al)/2;if(T.match(/beziery/i)){W=this.bs(F,a-ab,F,k-ab,D,k-ab,D,al-ab,0.25,true)}else{W=this.bs(F,a-ab,l,a-ab,l,al-ab,D,al-ab,0.25,true)}for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}if(T.match(/beziery/i)){W=this.bs(F,a+ab,F,k+ab,D,k+ab,D,al+ab,0.25)}else{W=this.bs(F,a+ab,l,a+ab,l,al+ab,D,al+ab,0.25)}for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}}else{if(F==D&&a!=al){M=["poly",F-ab,a,F+ab,a,D+ab,al,D-ab,al]}else{if(a==al&&F!=D){M=["poly",F,a-ab,D,a-ab,D,al+ab,F,al+ab]}else{var C=this.Th(F,a,D,al,ab);M=["poly",C[0],C[1],C[2],C[3],C[6],C[7],C[4],C[5]]}}}}}}else{return false}}}}}}}if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?M:this.ML(M)}else{return M}};this.zD=function(b){if(!b){b="solid"}var a=[];if(b.match(/blank/i)){a=CanvasXpress.R.lty[0]}else{if(b.match(/solid/i)){a=CanvasXpress.R.lty[1]}else{if(b.match(/dashed/i)){a=CanvasXpress.R.lty[2];a=[this.dashLength,this.dashLength-2]}else{if(b.match(/dotted/i)){a=CanvasXpress.R.lty[3];a=[this.dotLength,this.dotLength+2]}else{if(b.match(/dotdash/i)){a=CanvasXpress.R.lty[4]}else{if(b.match(/longdash/i)){a=CanvasXpress.R.lty[5]}else{if(b.match(/twodash/i)){a=CanvasXpress.R.lty[6]}}}}}}}return a};this.b3=function(c,b,g,a,f,d,h){if(this.adjustBezier){if(c.match(/bezier/i)&&(b==a||g==f)){return"line"}if(Math.abs(a-b)>=Math.abs(f-g)){if(c.match(/beziery/i)){c=c.replace("beziery","bezier");c=c.replace("bezierY","bezier")}}else{if(c.match(/bezierx/i)){c=c.replace("bezierx","beziery");c=c.replace("bezierX","bezierY")}else{if(c.match(/bezier/i)){c=c.replace("bezier","bezierY")}}}if(d!=null&&h!=null){if(c.match(/beziery/i)){if(f>g){if(g+d>f-h){c="line"}}else{if(g-d<f+h){c="line"}}}else{if(c.match(/beziery/i)){if(a>b){if(b+d>a-h){c="line"}}else{if(b-d<a+h){c="line"}}}}}}return c};this.q4=function(W,F,a,D,ap,ah,V,aa,J,g,al,an,Z,ab,ad,G,T,H){if(!H){H=this.ZO()}var C=this.zD(W,H);var Y,ak,aj,M;if(this.eO(J)){Y=J[0];ak=J[1]}else{Y=J;ak=J}if(this.eO(g)){aj=g[0];M=g[1]}else{aj=g;M=g}if(!this.tc(aj,true)){aj=0}if(!this.tc(Y,true)){Y=0}if(!this.tc(M,true)){M=0}if(!this.tc(ak,true)){ak=0}W=this.b3(W,F,a,D,ap,Y,aj);var k=false;var I=function(b){switch(b){case"arrow":k=0;break;case"square":k=1;break;case"round":k=2;break;case"roundDocked":k=false;break}};if(!W){W="solid"}if(W.match(/error/)){if(this.showErrorBars&&this.Hl([F,a,D,ap,V])){F=Math.ceil(F);D=Math.ceil(D);a=Math.ceil(a);ap=Math.ceil(ap);V=Math.ceil(V);var S=V/2;if(!this.mT(ah,true)){var R=this.RV(ah,false,aa);R.funcs.push(["setLineDash",[C]]);R.funcs.push(["beginPath",[]]);R.funcs.push(["moveTo",[F,a]]);R.funcs.push(["lineTo",[D,ap]]);R.funcs.push(["stroke",[]]);if(Math.abs(V)>this.errorBarsWidth){if(V>0){R.funcs.push(["moveTo",[D,ap-S]]);R.funcs.push(["lineTo",[D,ap+S]]);R.funcs.push(["stroke",[]])}else{R.funcs.push(["moveTo",[D-S,ap]]);R.funcs.push(["lineTo",[D+S,ap]]);R.funcs.push(["stroke",[]])}}R.funcs.push(["setLineDash",[[]]]);H.o.push(R);this.AO(H)}}}else{if(W.match(/spline|cardinalSpline/i)){if(F.length<3){return F.length<2?false:this.q4(W.match(/dashedSpline/i)?"dashedLine":"line",F[0],a[0],F[1],a[1],ah,V,aa,J,g,al,an,Z,ab,ad,false,false,H)}var X=[];var am=[];var ai=0;for(var ag=0;ag<F.length;ag++){if(this.Hl([F[ag],a[ag]])){am.push(F[ag],a[ag]);ai+=2}else{return}}var R=this.RV(ah,V,aa);if(!this.mT(ah,true)){R.funcs.push(["setLineDash",[C]]);if(W.match(/spline/i)){for(var ag=0;ag<ai-4;ag+=2){X=X.concat(this.Ln(am[ag],am[ag+1],am[ag+2],am[ag+3],am[ag+4],am[ag+5]))}R.funcs.push(["beginPath",[]]);R.funcs.push(["moveTo",[am[0],am[1]]]);R.funcs.push(["quadraticCurveTo",[X[0],X[1],am[2],am[3]]]);for(var ag=2;ag<ai-5;ag+=2){R.funcs.push(["quadraticCurveTo",[X[2*ag-2],X[2*ag-1],am[ag+2],am[ag+3]]])}R.funcs.push(["moveTo",[am[ai-2],am[ai-1]]]);R.funcs.push(["quadraticCurveTo",[X[2*ai-10],X[2*ai-9],am[ai-4],am[ai-3]]]);R.funcs.push(["stroke",[]])}else{am=this.r4(am);R.funcs.push(["beginPath",[]]);R.funcs.push(["moveTo",[am[0],am[1]]]);for(var ag=2;ag<am.length-1;ag+=2){R.funcs.push(["lineTo",[am[ag],am[ag+1]]])}R.funcs.push(["stroke",[]])}R.funcs.push(["setLineDash",[[]]])}H.o.push(R);this.AO(H)}else{if(W.match(/arch/)){if(F.length!=3||a.length!=3){return false}for(var ag=0;ag<F.length;ag++){if(!this.Hl([F[ag],a[ag]])){return false}}var R=this.RV(ah,V,aa);if(!this.mT(ah,true)){R.funcs.push(["setLineDash",[C]]);R.funcs.push(["beginPath",[]]);R.funcs.push(["moveTo",[F[0],a[0]]]);R.funcs.push(["quadraticCurveTo",[F[1],a[1],F[2],a[2]]]);R.funcs.push(["stroke",[]]);R.funcs.push(["setLineDash",[[]]])}H.o.push(R);this.AO(H);if(ad){I(ad);this.QK(F[1],a[1],F[2],a[2],ah,V,k,false,H)}if(ab){I(ab);this.QK(F[0],a[0],F[1],a[1],ah,V,k,true,H)}}else{if(W=="arc"){var R=this.RV(ah,V,aa);R.funcs.push(["setLineDash",[C]]);R.funcs.push(["beginPath",[]]);R.funcs.push(["arc",[F,a,Math.max(0,D),ak,M,false]]);R.funcs.push(["stroke",[]]);R.funcs.push(["setLineDash",[[]]]);H.o.push(R);this.AO(H)}else{if(W=="quadratic"){var R=this.RV(ah,V,aa);var y=this.Jk(F,a,D,ap,false,Math.min(1,this.arrowQuadraticFactor*Math.abs(Z))*(Z>0?-1:1));var E=this.On(F,a,D,ap,ak,M,W,Z);var ao=this.I2(E[0],E[1],y[0],y[1],E[2],E[3],0.1,true);R.funcs.push(["setLineDash",[C]]);R.funcs.push(["beginPath",[]]);R.funcs.push(["moveTo",[E[0],E[1]]]);R.funcs.push(["quadraticCurveTo",[y[0],y[1],E[2],E[3]]]);R.funcs.push(["stroke",[]]);R.funcs.push(["setLineDash",[[]]]);H.o.push(R);this.AO(H);if(ad){F=ao[9][0];a=ao[9][1];D=E[2];ap=E[3];I(ad);this.QK(F,a,D,ap,ah,V,k,false,H)}if(ab){F=ao[1][0];a=ao[1][1];D=E[0];ap=E[1];I(ab);this.QK(F,a,D,ap,ah,V,k,true,H)}}else{if(W=="roundLine"){var R=this.RV(ah,V,aa);R.funcs.push(["setLineDash",[C]]);R.funcs.push(["beginPath",[]]);R.funcs.push(["moveTo",[F,a]]);if(a>ap){R.funcs.push(["lineTo",[F,ap+this.roundedPolygonRadius]]);if(F>D){R.funcs.push(["quadraticCurveTo",[F,ap,F-this.roundedPolygonRadius,ap]])}else{R.funcs.push(["quadraticCurveTo",[F,ap,F+this.roundedPolygonRadius,ap]])}}else{R.funcs.push(["lineTo",[F,ap-this.roundedPolygonRadius]]);if(F>D){R.funcs.push(["quadraticCurveTo",[F,ap,F-this.roundedPolygonRadius,ap]])}else{R.funcs.push(["quadraticCurveTo",[F,ap,F+this.roundedPolygonRadius,ap]])}}R.funcs.push(["lineTo",[D,ap]]);R.funcs.push(["stroke",[]]);R.funcs.push(["setLineDash",[[]]]);H.o.push(R);this.AO(H);if(ad){I(ad);this.QK(F,ap,D,ap,ah,V,k,false,H)}if(ab){I(ab);this.QK(F,ap,D,ap,ah,V,k,true,H)}}else{if(this.Hl([F,a,D,ap])){var N=this.On(F,a,D,ap,ak,M,W);var j=this.On(F,a,D,ap,ab?Y:ak,ad?aj:M,W);F=N[0];a=N[1];D=N[2];ap=N[3];if(al){N=this.Pl("line",[F,a,D,ap],an);if(N){F=N[0];a=N[1];D=N[2];ap=N[3]}else{return false}}if(Z&&this.eO(Z)&&Z.length>0){var P=Z.length-1;if(this.VJ(Z)){var R=this.RV(ah,V,aa);R.funcs.push(["setLineDash",[C]]);if(W.match(/bezier/i)){if(!this.mT(ah,true)){if(Z[0].length==6){R.funcs.push(["beginPath",[]]);R.funcs.push(["moveTo",[Z[0][0],Z[0][1]]]);for(var ag=0;ag<Z.length;ag++){R.funcs.push(["bezierCurveTo",[Z[ag][0],Z[ag][1],Z[ag][2],Z[ag][3],Z[ag][4],Z[ag][5]]])}R.funcs.push(["stroke",[]]);var ao;if(ad){ao=this.bs(Z[P][0],Z[P][1],Z[P][0],Z[P][1],Z[P][2],Z[P][3],Z[P][4],Z[P][5],0.1,true);F=ao[9][0];a=ao[9][1];D=ao[10][0];ap=ao[10][1];I(ad);this.QK(F,a,D,ap,ah,V,k,false,H)}if(ab){ao=this.bs(Z[0][0],Z[0][1],Z[0][0],Z[0][1],Z[0][2],Z[0][3],Z[0][4],Z[0][5],0.1,true);F=ao[1][0];a=ao[1][1];D=ao[0][0];ap=ao[0][1];I(ab);this.QK(F,a,D,ap,ah,V,k,true,H)}}else{if(Z.length==4){R.funcs.push(["beginPath",[]]);R.funcs.push(["moveTo",[Z[0][0],Z[0][1]]]);R.funcs.push(["bezierCurveTo",[Z[1][0],Z[1][1],Z[2][0],Z[2][1],Z[3][0],Z[3][1]]]);R.funcs.push(["stroke",[]]);var ao=this.bs(Z[0][0],Z[0][1],Z[1][0],Z[1][1],Z[2][0],Z[2][1],Z[3][0],Z[3][1],0.1,true);if(ad){F=ao[9][0];a=ao[9][1];D=Z[3][0];ap=Z[3][1];I(ad);this.QK(F,a,D,ap,ah,V,k,false,H)}if(ab){F=ao[1][0];a=ao[1][1];D=Z[1][0];ap=Z[1][1];I(ab);this.QK(F,a,D,ap,ah,V,k,true,H)}}else{R.funcs.push(["beginPath",[]]);R.funcs.push(["moveTo",[Z[0][0],Z[0][1]]]);R.funcs.push(["lineTo",[Z[P][0],Z[P][1]]]);R.funcs.push(["stroke",[]]);if(ad){F=Z[P-1][0];a=Z[P-1][1];D=Z[P][0];ap=Z[P][1];I(ad);this.QK(F,a,D,ap,ah,V,k,false,H)}if(ab){F=Z[0][0];a=Z[0][1];D=Z[1][0];ap=Z[1][1];I(ab);this.QK(F,a,D,ap,ah,V,k,true,H)}}}}}else{if(!this.mT(ah,true)){R.funcs.push(["beginPath",[]]);R.funcs.push(["moveTo",[Z[0][0],Z[0][1]]]);for(var ag=0;ag<P;ag++){R.funcs.push(["lineTo",[Z[ag+1][0],Z[ag+1][1]]])}R.funcs.push(["stroke",[]]);if(ad){F=Z[P-1][0];a=Z[P-1][1];D=Z[P][0];ap=Z[P][1];I(ad);this.QK(F,a,D,ap,ah,V,k,false,H)}if(ab){F=Z[0][0];a=Z[0][1];D=Z[1][0];ap=Z[1][1];I(ab);this.QK(F,a,D,ap,ah,V,k,true,H)}}}R.funcs.push(["setLineDash",[[]]]);H.o.push(R);this.AO(H)}else{return false}}else{if(W.match(/curved/i)){var B=F==D&&a==ap&&G;var v=this.Yu(F,a,D,ap);var U=Math.max(1,this.zJ(F,a,v[0],v[1]));var Q=(Y||0)/U;var L=(aj||0)/U;var h=(ak||0)/U;var K=(M||0)/U;var A=W.match(/curvedcc/i)&&F>D?false:!W.match(/curvedcc/i)&&D>=F?true:false;var u=D>=F?Math.asin((v[1]-a)/U):Math.asin(-(v[1]-a)/U);var af=u+Math.PI;var r=[];var z=[];var ac=this.arrowHeadSize;var R=this.RV(ah,V,aa);if(!this.mT(ah,true)){var d=0;var ae=false;if(B){if(u<0){u+=Math.PI*2}if(G.dir){ad=false;ab=G.end}else{ad=G.end;ab=false}var x=G.size;var O=G.size*0.5;this.arrowHeadSize=Math.ceil(G.size/3);switch(G.pos){case"top":r=[F,a-x,O,Math.PI*0.75,Math.PI*0.25,false];break;case"topRight":r=[F+x,a-x,O,Math.PI,Math.PI*0.5,false];break;case"right":r=[F+x,a,O,Math.PI*1.25,Math.PI*0.75,false];break;case"bottomRight":r=[F+x,a+x,O,Math.PI*1.5,Math.PI,false];break;case"bottom":r=[F,a+x,O,Math.PI*1.75,Math.PI*1.25,false];break;case"bottomLeft":r=[F-x,a+x,O,0,Math.PI*1.5,false];break;case"left":r=[F-x,a,O,Math.PI*0.25,Math.PI*1.75,false];break;case"topLeft":r=[F-x,a-x,O,Math.PI*0.5,0,false];break}d=0.25}else{if(D>=F){r=[v[0],v[1],Math.max(0,U),u-K,af+h,A];z=[v[0],v[1],Math.max(0,U),u-L,af+Q,A]}else{ae=true;r=[v[0],v[1],Math.max(0,U),af-K,u+h,!A];z=[v[0],v[1],Math.max(0,U),af-L,u+Q,!A]}}R.funcs.push(["setLineDash",[C]]);R.funcs.push(["beginPath",[]]);R.funcs.push(["arc",[r[0],r[1],r[2],r[3]+(ad?d:0),r[4]-(ab?d:0),r[5]]]);R.funcs.push(["stroke",[]]);R.funcs.push(["setLineDash",[[]]])}H.o.push(R);this.AO(H);var ao;if(ad||ab){ao=this.iy(z[0],z[1],z[2],(ae?z[4]-(Math.PI*2):z[3]),(ae?z[3]:z[4]),z[5]*(ae?-1:1))}if(ad||(ae&&ab)){F=ao[15][0];a=ao[15][1];D=ao[16][0];ap=ao[16][1];if(ae&&ab){I(ab)}else{I(ad)}this.QK(F,a,D,ap,ah,V,k,false,H)}if(ab||(ae&&ad)){F=ao[1][0];a=ao[1][1];D=ao[0][0];ap=ao[0][1];if(ae&&ad){I(ad)}else{I(ab)}this.QK(F,a,D,ap,ah,V,k,true,H)}this.arrowHeadSize=ac}else{if(W.match(/bezier/i)){var o=(F+D)/2;var l=(a+ap)/2;var ao;var R=this.RV(ah,V,aa);if(!this.mT(ah,true)){R.funcs.push(["setLineDash",[C]]);R.funcs.push(["beginPath",[]]);R.funcs.push(["moveTo",[F,a]]);if(this.graphType=="Tree"&&this.treeCircular&&T){R.funcs.push(["bezierCurveTo",[T[2],T[3],T[0],T[1],D,ap]]);ao=this.bs(F,a,T[0],T[1],T[0],T[1],D,ap,0.1,true)}else{if(W.match(/beziery/i)){R.funcs.push(["bezierCurveTo",[F,l,D,l,D,ap]]);ao=this.bs(F,a,F,l,D,l,D,ap,0.1,true)}else{R.funcs.push(["bezierCurveTo",[o,a,o,ap,D,ap]]);ao=this.bs(F,a,o,a,o,ap,D,ap,0.1,true)}}R.funcs.push(["stroke",[]]);R.funcs.push(["setLineDash",[[]]])}H.o.push(R);this.AO(H);if(ad){F=ao[9][0];a=ao[9][1];D=ao[10][0];ap=ao[10][1];I(ad);this.QK(F,a,D,ap,ah,V,k,false,H)}if(ab){D=ao[0][0];ap=ao[0][1];F=ao[1][0];a=ao[1][1];I(ab);this.QK(F,a,D,ap,ah,V,k,true,H)}}else{if(W.match(/needle/i)){var R=this.RV(ah,V,aa);var y=this.Th(F,a,D,ap,V);if(!this.mT(ah,true)){R.funcs.push(["setLineDash",[C]]);R.funcs.push(["beginPath",[]]);R.funcs.push(["moveTo",[y[0],y[1]]]);R.funcs.push(["lineTo",[D,ap]]);R.funcs.push(["lineTo",[y[2],y[3]]]);R.funcs.push(["closePath",[]]);R.funcs.push(["stroke",[]]);R.funcs.push(["fill",[]]);R.funcs.push(["beginPath",[]]);R.funcs.push(["arc",[F,a,V*3,0,Math.PI*2]]);R.funcs.push(["stroke",[]]);R.funcs.push(["fill",[]]);R.funcs.push(["setLineDash",[[]]])}H.o.push(R);this.AO(H)}else{var R=this.RV(ah,V,aa);if(!this.mT(ah,true)){R.funcs.push(["setLineDash",[C]]);R.funcs.push(["beginPath",[]]);R.funcs.push(["moveTo",[F,a]]);R.funcs.push(["lineTo",[D,ap]]);R.funcs.push(["stroke",[]]);R.funcs.push(["setLineDash",[[]]])}H.o.push(R);this.AO(H);if(ad){I(ad);this.QK(j[0],j[1],j[2],j[3],ah,V,k,false,H)}if(ab){I(ab);this.QK(j[0],j[1],j[2],j[3],ah,V,k,true,H)}}}}}}else{return false}}}}}}}};this.QK=function(d,n,c,m,l,o,k,j,q){if(!q){q=this.ZO()}var g=function(t,w,f,z){var s=[];for(var u=0;u<t.length;u++){s.push([(t[u][0]*Math.cos(w))-(t[u][1]*Math.sin(w)),(t[u][0]*Math.sin(w))+(t[u][1]*Math.cos(w))])}var v=[];for(var u=0;u<s.length;u++){v.push([s[u][0]+f,s[u][1]+z])}return v};if(k==0){return this.ra(d,n,c,m,l,o,1,q)}else{var b=this.RV(l,k==1?o:o,false);if(k==1){var r=c-d;var p=m-n;var a=o?o/2:this.outlineWidth/2;var e=g([[-a,-this.arrowHeadSize],[-a,this.arrowHeadSize]],Math.atan2(p,r),c,m);b.funcs.push(["beginPath",[]]);b.funcs.push(["moveTo",[e[0][0],e[0][1]]]);for(var h=1;h<e.length;h++){if(!isNaN(e[h][0])&&!isNaN(e[h][1])){b.funcs.push(["lineTo",[e[h][0],e[h][1]]])}}b.funcs.push(["closePath",[]]);b.funcs.push(["stroke",[]])}else{if(k==2){b.funcs.push(["beginPath",[]]);b.funcs.push(["arc",[c,m,Math.max(0,Math.max((this.arrowHeadSizes/2)-1,1)*1.3),0,Math.PI*2,true]]);b.funcs.push(["closePath",[]]);b.funcs.push(["fill",[]])}else{}}q.o.push(b);this.AO(q)}};this.ra=function(t,e,q,b,u,j,l,n){var o=function(Q,w,O,h,L,d,M,G){n.o.push({funcs:[["save",[]]]});G.funcs.push(["beginPath",[]]);G.funcs.push(["moveTo",[Q,w]]);G.funcs.push(["lineTo",[O,h]]);G.funcs.push(["lineTo",[L,d]]);switch(M){case 0:var S=Math.sqrt(((L-Q)*(L-Q))+((d-w)*(d-w)));G.funcs.push(["arcTo",[O,h,Q,w,j*(j<1.01?0.55:0.25)*S]]);G.funcs.push(["fill",[]]);break;case 1:G.funcs.push(["beginPath",[]]);G.funcs.push(["moveTo",[Q,w]]);G.funcs.push(["lineTo",[O,h]]);G.funcs.push(["lineTo",[L,d]]);G.funcs.push(["lineTo",[Q,w]]);G.funcs.push(["fill",[]]);break;case 2:G.funcs.push(["stroke",[]]);break;case 3:var D=(Q+O+L)/3;var B=(w+h+d)/3;G.funcs.push(["quadraticCurveTo",[D,B,Q,w]]);G.funcs.push(["fill",[]]);break;case 4:var P,N,s,f;var H=5;if(L==Q){var S=d-w;P=(O+Q)/2;s=(O+Q)/2;N=h+S/H;f=h-S/H}else{var S=Math.sqrt(((L-Q)*(L-Q))+((d-w)*(d-w)));var J=(Q+L)/2;var C=(w+d)/2;var K=(J+O)/2;var R=(C+h)/2;var I=(d-w)/(L-Q);var F=(S/(2*Math.sqrt(I*I+1)))/H;var E=I*F;P=K-F;N=R-E;s=K+F;f=R+E}G.funcs.push(["bezierCurveTo",[P,N,s,f,Q,w]]);G.funcs.push(["fill",[]]);break}n.o.push(G);n.resetContext();n.o.push({funcs:[["restore",[]]]})};if(!n){n=this.ZO()}var r=0;switch(this.arrowHeadType){case"unFilled":r=2;break;case"filledStraight":r=1;break;case"filledArc":r=0;break;case"filledQuadratic":r=3;break;case"filledBezier":r=4;break}var k=l!=null?l:1;var v=this.arrowHeadAngle*Math.PI/180;var x=this.arrowHeadSize;var m=this.RV(u,j,false);var A=Math.atan2(b-e,q-t);var p=Math.abs(x/Math.cos(v));if(k==1||k==3){var c=A+Math.PI+v;var i=q+Math.cos(c)*p;var g=b+Math.sin(c)*p;var a=A+Math.PI-v;var z=q+Math.cos(a)*p;var y=b+Math.sin(a)*p;o(i,g,q,b,z,y,r,m)}if(k==2||k==3){var c=A+v;var i=t+Math.cos(c)*p;var g=e+Math.sin(c)*p;var a=A-v;var z=t+Math.cos(a)*p;var y=e+Math.sin(a)*p;o(i,g,t,e,z,y,r,m)}};this.cq=function(l,j,a,q,h,p,g,m,o){var k,i,n,d,b;var c=m!=null?m:1;if(c==1||c==3){k=Math.cos(q)*a+l;i=Math.sin(q)*a+j;n=Math.atan2(l-k,i-j);if(p){d=k+10*Math.cos(n);b=i+10*Math.sin(n)}else{d=k-10*Math.cos(n);b=i-10*Math.sin(n)}this.ra(k,i,d,b,g,m,2,o)}if(c==2||c==3){k=Math.cos(h)*a+l;i=Math.sin(h)*a+j;n=Math.atan2(l-k,i-j);if(p){d=k-10*Math.cos(n);b=i-10*Math.sin(n)}else{d=k+10*Math.cos(n);b=i+10*Math.sin(n)}this.ra(k,i,d,b,g,m,2,o)}};this.lX=function(a){var c=this;var f=function(g){g.strokeStyle="rgb(29,137,182)";var h=[4,6,9,12,16,21,27,14,17,21,26];var k=[27,21,16,12,9,6,4,26,21,17,14];for(var j=0;j<h.length;j++){g.moveTo(h[j],k[j]);g.arc(h[j],k[j],2,0,Math.PI*2)}g.moveTo(3,32);g.arc(3,32,2,Math.PI,0);g.moveTo(13,32);g.arc(13,32,2,Math.PI,0);g.moveTo(32,3);g.arc(32,3,2,Math.PI*0.5,Math.PI*1.5);g.moveTo(32,13);g.arc(32,13,2,Math.PI*0.5,Math.PI*1.5);h=[[7,11],[8,12],[11,14],[14,17],[18,20],[22,24],[28,29]];k=[[28,29],[22,24],[18,20],[14,17],[11,14],[8,12],[7,11]];for(var j=0;j<h.length;j++){g.moveTo(h[j][0],k[j][0]);g.lineTo(h[j][1],k[j][1])}g.stroke()};var e=function(g){g.strokeStyle="rgb(29,137,182)";g.moveTo(3,0);g.arc(3,0,2,Math.PI,0,true);g.moveTo(3,5);g.arc(3,5,2,Math.PI,0);g.moveTo(6,1);g.lineTo(8,4);g.lineTo(10,1);g.moveTo(13,0);g.arc(13,0,2,Math.PI,0,true);g.moveTo(13,5);g.arc(13,5,2,Math.PI,0);g.stroke()};var b=function(g){g.strokeStyle="rgb(29,137,182)";g.moveTo(0,3);g.arc(0,3,2,Math.PI*1.5,Math.PI*0.5);g.moveTo(5,3);g.arc(5,3,2,Math.PI*1.5,Math.PI*0.5,true);g.moveTo(1,6);g.lineTo(4,8);g.lineTo(1,10);g.moveTo(0,13);g.arc(0,13,2,Math.PI*1.5,Math.PI*0.5);g.moveTo(5,13);g.arc(5,13,2,Math.PI*1.5,Math.PI*0.5,true);g.stroke()};var d=function(){if(!a){a=c.ZO()}var h=c.$cX("canvas");h.width=5;h.height=5;var g=c.TO(h);if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchForward")){g.clearRect(0,0,5,5);g.beginPath();g.moveTo(0,0);g.lineTo(5,5);g.stroke();CanvasXpress.cachePatterns.hatchForward=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchReverse")){g.clearRect(0,0,5,5);g.beginPath();g.moveTo(5,0);g.lineTo(0,5);g.stroke();CanvasXpress.cachePatterns.hatchReverse=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("stripeVertical")){h.width=3;h.height=3;g.clearRect(0,0,3,3);g.beginPath();g.moveTo(1.5,0);g.lineTo(1.5,3);g.stroke();CanvasXpress.cachePatterns.stripeVertical=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("stripeHorizontal")){g.clearRect(0,0,3,3);g.beginPath();g.moveTo(0,1.5);g.lineTo(3,1.5);g.stroke();CanvasXpress.cachePatterns.stripeHorizontal=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("polkaDot")){h.width=5;h.height=5;g.clearRect(0,0,5,5);g.beginPath();g.arc(2.5,2.5,2,0,Math.PI*2);g.fill();CanvasXpress.cachePatterns.polkaDot=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("crossHatch")){g.clearRect(0,0,5,5);g.beginPath();g.moveTo(0,0);g.lineTo(5,5);g.stroke();g.beginPath();g.moveTo(5,0);g.lineTo(0,5);g.stroke();CanvasXpress.cachePatterns.crossHatch=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("crossStripe")){h.width=3;h.height=3;g.clearRect(0,0,3,3);g.beginPath();g.moveTo(1.5,0);g.lineTo(1.5,3);g.stroke();g.beginPath();g.moveTo(0,1.5);g.lineTo(3,1.5);g.stroke();CanvasXpress.cachePatterns.crossStripe=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("squares")){h.width=5;h.height=5;g.clearRect(0,0,5,5);g.beginPath();g.strokeRect(1,1,4,4);g.stroke();CanvasXpress.cachePatterns.squares=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("circles")){g.clearRect(0,0,5,5);g.beginPath();g.arc(2.5,2.5,1,0,Math.PI*2);g.stroke();CanvasXpress.cachePatterns.circles=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("plus")){h.width=7;h.height=7;g.clearRect(0,0,7,7);g.beginPath();g.moveTo(3.5,1);g.lineTo(3.5,6);g.stroke();g.beginPath();g.moveTo(1,3.5);g.lineTo(6,3.5);g.stroke();CanvasXpress.cachePatterns.plus=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("minus")){h.width=7;h.height=7;g.clearRect(0,0,7,7);g.beginPath();g.moveTo(1,3.5);g.lineTo(6,3.5);g.stroke();CanvasXpress.cachePatterns.minus=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("bars")){h.width=7;h.height=7;g.clearRect(0,0,7,7);g.beginPath();g.moveTo(3.5,1);g.lineTo(3.5,6);g.stroke();CanvasXpress.cachePatterns.bars=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("squiglesHorizontal")){h.width=5;h.height=5;g.clearRect(0,0,5,5);g.beginPath();g.moveTo(0,5);g.lineTo(2.5,0);g.lineTo(5,5);g.stroke();CanvasXpress.cachePatterns.squiglesHorizontal=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("squiglesVertical")){h.width=5;h.height=5;g.clearRect(0,0,5,5);g.beginPath();g.moveTo(0,0);g.lineTo(5,2.5);g.lineTo(0,5);g.stroke();CanvasXpress.cachePatterns.squiglesVertical=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("brickForward")){g.clearRect(0,0,5,5);g.beginPath();g.moveTo(0,0);g.lineTo(3,0);g.lineTo(0,3);g.closePath();g.stroke();g.fill();g.beginPath();g.moveTo(2,5);g.lineTo(5,2);g.lineTo(5,5);g.closePath();g.stroke();g.fill();CanvasXpress.cachePatterns.brickForward=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("brickReverse")){g.clearRect(0,0,5,5);g.beginPath();g.moveTo(5,0);g.lineTo(2,0);g.lineTo(5,3);g.closePath();g.stroke();g.fill();g.beginPath();g.moveTo(0,5);g.lineTo(0,2);g.lineTo(3,5);g.closePath();g.stroke();g.fill();CanvasXpress.cachePatterns.brickReverse=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("art")){g.clearRect(0,0,5,5);g.beginPath();g.arc(2.5,2.5,2,0,Math.PI*2);g.moveTo(0,5);g.lineTo(5,0);g.stroke();CanvasXpress.cachePatterns.art=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("pcx")){g.clearRect(0,0,5,5);g.beginPath();g.moveTo(2,0);g.lineTo(0,0);g.lineTo(0,3);g.lineTo(2,3);g.stroke();g.beginPath();g.moveTo(3,3);g.lineTo(5,5);g.stroke();g.beginPath();g.moveTo(5,3);g.lineTo(3,5);g.stroke();CanvasXpress.cachePatterns.pcx=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchForward3")){h.width=5;h.height=3;g.clearRect(0,0,5,3);g.beginPath();g.moveTo(0,0);g.lineTo(5,3);g.stroke();CanvasXpress.cachePatterns.hatchForward3=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchReverse3")){g.clearRect(0,0,5,3);g.beginPath();g.moveTo(5,0);g.lineTo(0,3);g.stroke();CanvasXpress.cachePatterns.hatchReverse3=a.createPattern(h,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneTop")){h.width=5;h.height=16;g.clearRect(0,0,5,16);b(g);CanvasXpress.cachePatterns.membraneTop=a.createPattern(h,"repeat-x")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneBottom")){h.width=5;h.height=16;g.clearRect(0,0,5,16);g.translate(5,0);g.scale(-1,1);b(g);CanvasXpress.cachePatterns.membraneBottom=a.createPattern(h,"repeat-x")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneRight")){h.width=16;h.height=5;g.clearRect(0,0,16,5);e(g);CanvasXpress.cachePatterns.membraneRight=a.createPattern(h,"repeat-y")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneLeft")){h.width=16;h.height=5;g.clearRect(0,0,16,5);g.translate(0,5);g.scale(1,-1);e(g);CanvasXpress.cachePatterns.membraneLeft=a.createPattern(h,"repeat-y")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneTL")){h.width=32;h.height=32;g.clearRect(0,0,32,32);f(g);CanvasXpress.cachePatterns.membraneTL=a.createPattern(h,"no-repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneBL")){h.width=32;h.height=32;g.clearRect(0,0,32,32);g.translate(0,32);g.scale(1,-1);f(g);CanvasXpress.cachePatterns.membraneBL=a.createPattern(h,"no-repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneTR")){h.width=32;h.height=32;g.clearRect(0,0,32,32);g.translate(32,0);g.scale(-1,1);f(g);CanvasXpress.cachePatterns.membraneTR=a.createPattern(h,"no-repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneBR")){h.width=32;h.height=32;g.clearRect(0,0,32,32);g.translate(32,32);g.scale(-1,-1);f(g);CanvasXpress.cachePatterns.membraneBR=a.createPattern(h,"no-repeat")}};if(this.patternBy){d()}else{setTimeout(function(){d()},0)}};this.h0=function(f,e,d,m,h,g,F,E,D){var c=Math.sin(F);var A=Math.cos(F);var b=Math.sin(E);var x=Math.cos(E);var a=Math.sin(D);var v=Math.cos(D);var C=function(j){var k=j.y;j.y=(k*A)+(j.z*c*-1);j.z=(k*c)+(j.z*A);var i=j.x;j.x=(i*x)+(j.z*b*-1);j.z=(i*b)+(j.z*x);var i=j.x;j.x=(i*v)+(j.y*a*-1);j.y=(i*a)+(j.y*v)};var l=[];var n=Math.PI/12;var t=Math.PI*2;var r=Math.PI/2;for(var B=1;B>=-1;B-=2){for(var z=0;z<r;z+=n){var u=Math.cos(z)*m;var o=Math.cos(z)*g;var q=Math.sin(z)*h*B*-1;for(var w=0;w<t;w+=n){var s={x:(Math.cos(w)*u),y:q,z:(Math.sin(w)*o)};C(s);s.x+=f;s.y+=e;s.z+=d;if(B>0){l.push([s.x,s.y,s.z])}else{l.unshift([s.x,s.y,s.z])}}}}return l};this.dX=function(h){var v=function(x,r,i){i.x=r.x-x.x;i.y=r.y-x.y;i.len=Math.sqrt(i.x*i.x+i.y*i.y);i.nx=i.x/i.len;i.ny=i.y/i.len;i.ang=Math.atan2(i.ny,i.nx)};var s=[];for(var t=0;t<h.length;t++){s.push({x:h[t][0],y:h[t][1]})}var m=[];var o=this.roundedPolygonRadius;var e={};var d={};var u=s.length;var c=s[u-1];for(var t=0;t<u;t++){var b=s[(t)%u];var a=s[(t+1)%u];v(b,c,e);v(b,a,d);var j=e.nx*d.ny-e.ny*d.nx;var p=e.nx*d.nx-e.ny*-d.ny;var w=Math.asin(j);var q=1;var f=false;if(p<0){if(w<0){w=Math.PI+w}else{w=Math.PI-w;q=-1;f=true}}else{if(w>0){q=-1;f=true}}var g;var n=w/2;var z=Math.abs(Math.cos(n)*o/Math.sin(n));if(z>Math.min(e.len/2,d.len/2)){z=Math.min(e.len/2,d.len/2);g=Math.abs(z*Math.sin(n)/Math.cos(n))}else{g=o}var l=b.x+d.nx*z;var k=b.y+d.ny*z;l+=-d.ny*g*q;k+=d.nx*g*q;m.push([l,k,g,e.ang+Math.PI/2*q,d.ang-Math.PI/2*q,f]);c=b;b=a}return m};this.ej=function(v,m,l,n,G,H,D,C,B,k,L,M,A,I,q,J){var j=this;var F=function(d){if(j.graphType=="Network"||v=="arrow"){return d}d.shift();var b=["poly"];var f=Math.cos(B);var c=Math.sin(B);for(var e=0;e<d.length;e+=2){b.push((f*(m-d[e]))+(c*(l-d[e+1]))+d[e]);b.push((f*(l-d[e+1]))-(c*(m-d[e]))+d[e+1])}return b};var g,a;var N=["poly"];var K=[];if(!M){M=this.uf()}switch(v){case"arc2":K=this.cB(m,l,G,A,I,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.cB(m,l,G-n,A,I);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"pie":N.push(m,l);K=this.cB(m,l,G,A,I,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"confidence":for(var E=0;E<m.length;E++){N.push(m[E][0],l[E][0]);K.push(l[E][1],m[E][1])}N=this.b9(N.concat(K.reverse()),false,true);break;case"violin":case"fish":for(var E=0;E<m[0].length;E++){N.push(m[0][E],l[0][E]);K.push(l[1][E],m[1][E])}N=N.concat(K.reverse());break;case"bezier":K=this.bs(m[0],l[0],m[1],l[1],m[2],l[2],m[3],l[3],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.bs(m[0],l[0]+G,m[1],l[1]+G,m[2],l[2]+G,m[3],l[3]+G,0.25);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"arch":K=this.I2(m[0],l[0],m[1],l[1],m[2],l[2],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.cB(m[4],l[4],G[0],n[2],n[3]);for(var E=1;E<K.length;E++){N.push(K[E][0],K[E][1])}if(m[0]==m[3]&&l[0]==l[3]&&m[1]==m[4]&&l[1]==l[4]&&m[2]==m[5]&&l[2]==l[5]){break}K=this.I2(m[3],l[3],m[4],l[4],m[5],l[5],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.cB(m[1],l[1],G[1],n[0],n[1]);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"polygon":case"roundpolygon":case"path":case"spline":case"hull":for(var E=0;E<m.length;E++){if(v=="spline"){N.push(m[E],l[E]-2)}else{N.push(m[E],l[E]-2);K.unshift(m[E],l[E]+2)}}break;default:g=n/2;a=G/2;break}switch(v){case"image":N=["rect",m-(g*this.zoom),l-(a*this.zoom),m+(g*this.zoom),l+(a*this.zoom)];break;case"mdavid":case"star":case"circle":case"sphere":N=["circle",m,l,n];break;case"drop":case"teardrop":case"marker":N=["circle",m,l-n,g];break;case"diamond":case"rhombus":N=["poly",m,l-a,m+g,l,m,l+a,m-g,l];break;case"arrow":case"box":case"rect":case"rectangle":case"roundrect":case"roundrectt":case"roundrectb":case"roundrectr":case"roundrectl":case"roundrecttr":case"roundrecttl":case"roundrectbr":case"roundrectbl":case"roundrect2":case"roundrectd":case"roundrecto":case"brace":case"square":case"pentagon":case"hexagon":case"octagon":case"oval":case"arc":case"arc3":case"ellipse":case"plus":case"minus":case"pch0":case"pch1":case"pch2":case"pch3":case"pch4":case"pch5":case"pch6":case"pch7":case"pch8":case"pch9":case"pch10":case"pch11":case"pch12":case"pch13":case"pch14":case"pch15":case"pch16":case"pch17":case"pch18":case"pch21":case"pch22":case"pch23":case"pch24":case"pch25":N=["rect",m-g,l-a,m+g,l+a];break;case"pch19":g+=2;a+=2;N=["rect",m-g,l-a,m+g,l+a];break;case"pch20":g-=2;a-=2;g=Math.max(2,g);a=Math.max(2,a);N=["rect",m-g,l-a,m+g,l+a];break;case"rect2":return this.ej("rectangle",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"rect3":return this.ej("rectangle",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"triangle":case"equilateral":N=["poly",m,l-a,m+g,l+a,m-g,l+a];break;case"triangle2":case"equilateral2":N=["poly",m,l+a,m+g,l-a,m-g,l-a];break;case"oval2":return this.ej("oval",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"oval3":return this.ej("oval",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"ellipse2":return this.ej("ellipse",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"ellipse3":return this.ej("ellipse",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"pie0":return this.ej("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/5,q,J);case"pie1":return this.ej("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/3.5,q,J);case"pie2":return this.ej("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/2,q,J);case"pie3":return this.ej("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/1.5,q,J);case"pie4":return this.ej("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI,q,J);case"pie5":return this.ej("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.2,q,J);case"pie6":return this.ej("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.4,q,J);case"pie7":return this.ej("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.6,q,J);case"pie8":return this.ej("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.8,q,J);case"pie9":return this.ej("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*2,q,J);case"pacman":return this.ej("pie",m,l,n,n/2,H,D,C,B,k,L,M,Math.PI*1/4,Math.PI*7/4,q,J);case"pacman2":return this.ej("pie",m,l,n,n/2,H,D,C,B,k,L,M,Math.PI*5/4,Math.PI*3/4,q,J)}N=B?F(N):N;if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?N:this.ML(N)}else{return N}};this.hJ=function(c,d,b){if(c&&c.length>1){var a=c.shift();while(a[0]==null||a[1]==null){a=c.shift()}b.funcs.push(["beginPath",[]]);b.funcs.push(["moveTo",[a[0]+0.5,a[1]+0.5]]);while(c.length>0){a=c.shift();while(a[0]==null||a[1]==null){a=c.shift()}b.funcs.push(["lineTo",[a[0]+0.5,a[1]+0.5]])}if(!d){b.funcs.push(["closePath",[]])}}};this.Pw=function(ad,Y,X,aa,ar,at,ai,ah,af,W,az,aB,ae,av,ab,ax,N){var T,aA,j,aC,U,S,ag,al;if(!N){N=this.ZO()}if(ah){switch(ah){case"closed":case"solid":case"open":case"round":break;default:var aD=ah;ah="closed";this.Pw(ad,Y,X,aa,ar,at,at,ah,af,W,az,aB,ae,av,ab,ax);ah=aD;break}}switch(ad){case"polygon":case"roundpolygon":case"path":case"spline":case"arch":case"hull":case"confidence":case"violin":case"bezier":case"fish":var an=Number.MAX_VALUE;var Q=Number.MAX_VALUE*-1;var am=Number.MAX_VALUE;var O=Number.MAX_VALUE*-1;aA=[];T=[];if(Y.length==X.length){if(ad=="spline"&&Y.length<5){return this.Pw("polygon",Y,X,aa,ar,at,ai,ah,af,W,az,aB,ae,av,ab,ax)}if(ad=="arch"&&(Y.length!=6||X.length!=6||aa.length!=4||ar.length!=2)){return false}if(ad=="bezier"){if(this.Hl(Y)&&this.Hl(X)&&this.Hl(ar)){for(var aq=0;aq<Y.length;aq++){an=Math.min(an,Y[aq]);Q=Math.max(Q,Y[aq]);am=Math.min(am,X[aq]);O=Math.max(O,X[aq]);T.push([Y[aq],X[aq]])}Y=(an+Q)/2;X=(am+O)/2;for(var aq=0;aq<T.length;aq++){T[aq][0]-=Y;T[aq][1]-=X;aA.push(T[aq][0],T[aq][1])}}else{return false}}else{if(ad=="confidence"){if(Y.length>2){for(var aq=0;aq<Y.length;aq++){if(Y[aq][0]!=null&&Y[aq][1]!=null&&X[aq][0]!=null&&X[aq][1]!=null&&this.Hl([Y[aq][0],Y[aq][1],X[aq][0],X[aq][1]])){an=Math.min(an,Math.min(Y[aq][0],Y[aq][1]));Q=Math.max(Q,Math.max(Y[aq][0],Y[aq][1]));am=Math.min(am,Math.min(X[aq][0],X[aq][1]));O=Math.max(O,Math.max(X[aq][0],X[aq][1]));T.push([[Y[aq][0],Y[aq][1]],[X[aq][0],X[aq][1]]])}}Y=(an+Q)/2;X=(am+O)/2;for(var aq=0;aq<T.length;aq++){T[aq][0][0]-=Y;T[aq][0][1]-=Y;T[aq][1][0]-=X;T[aq][1][1]-=X;aA.push([T[aq][0][0],T[aq][0][1]],[T[aq][1][0],T[aq][1][1]])}}else{return false}}else{if(ad=="violin"||ad=="fish"){if(Y[0].length==X[0].length&&Y[1].length==X[1].length&&Y[0].length==Y[1].length){for(var aq=0;aq<Y[0].length;aq++){if(this.Hl([Y[0][aq],Y[1][aq],X[0][aq],X[1][aq]])){an=Math.min(an,Math.min(Y[0][aq],Y[1][aq]));Q=Math.max(Q,Math.max(Y[0][aq],Y[1][aq]));am=Math.min(am,Math.min(X[0][aq],X[1][aq]));O=Math.max(O,Math.max(X[0][aq],X[1][aq]));T.push([[Y[0][aq],Y[1][aq]],[X[0][aq],X[1][aq]]])}}Y=(an+Q)/2;X=(am+O)/2;for(var aq=0;aq<T.length;aq++){T[aq][0][0]-=Y;T[aq][0][1]-=Y;T[aq][1][0]-=X;T[aq][1][1]-=X;aA.push([T[aq][0][0],T[aq][0][1]],[T[aq][1][0],T[aq][1][1]])}}else{return false}}else{for(var aq=0;aq<Y.length;aq++){if(Y[aq]&&X[aq]&&this.Hl([Y[aq],X[aq]])){an=Math.min(an,Y[aq]);Q=Math.max(Q,Y[aq]);am=Math.min(am,X[aq]);O=Math.max(O,X[aq]);T.push([Y[aq],X[aq]])}}Y=ad=="arch"?Y[1]:(an+Q)/2;X=ad=="arch"?X[1]:(am+O)/2;for(var aq=0;aq<T.length;aq++){T[aq][0]-=Y;T[aq][1]-=X;aA.push(T[aq][0],T[aq][1])}}}}}else{return false}break;case"circle":case"sphere":case"circleOpen":case"rect":case"equilateral":case"plus":case"minus":case"diamond":case"rhombus":case"diamondOpen":case"hexagon":case"octagon":if(this.Hl([Y,X,aa,ar])){if(az){T=this.Pl(ad,[Y,X,aa,ar],aB);if(T){if(T.length==4){Y=T[0];X=T[1];aa=Math.max(1,T[2]);ar=Math.max(1,T[3])}else{if(T.length==2){Y=T[0];X=T[1]}}}else{return false}}j=aa/2;aC=ar/2;U=aa/3;S=ar/3;ag=ar/aa;al=1.5}break;default:if(this.Hl([Y,X,aa,ar])){if(az){T=this.Pl(ad,[Y,X,aa,ar],aB);if(T){if(T.length==4){aa=Math.max(1,T[2]);ar=Math.max(1,T[3]);Y=T[0]+(aa/2);X=T[1]+(ar/2)}else{if(T.length==2){Y=T[0];X=T[1]}}}else{return false}}else{aa=Math.max(1,aa);ar=Math.max(1,ar)}j=aa/2;aC=ar/2;ag=ar/aa;al=1.5}else{return false}break}switch(ad){case"image":var L=Array.isArray(ab)?this.backgroundImageMD5:this.Ng(ab);if(ab&&(CanvasXpress.cacheImages[L]||CanvasXpress.images[ab])){var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);if(CanvasXpress.images[ab]){this.Np(CanvasXpress.images[ab],-j*this.zoom,-aC*this.zoom,aa*this.zoom,ar*this.zoom,false,false,false,false,at,ah,N,V)}else{this.Np(CanvasXpress.cacheImages[L],-j*this.zoom,-aC*this.zoom,aa*this.zoom,ar*this.zoom,false,false,false,false,at,ah,N,V)}}else{if(L&&L=="canvasXpress"){return}else{return this.Pw("rectangle",Y,X,aa,ar,"rgba(0,0,0,0.5)","rgba(0,0,0,0.5)",ah,af,W,az,aB,ae,av,ab,ax)}}break;case"circle":case"sphere":case"circleOpen":if(!this.mT(at,true)||!this.mT(ai,true)){var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W);V.funcs.push(["beginPath",[]]);V.funcs.push(["arc",[Y,X,Math.max(0,aa/2),0,Math.PI*2,false]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V)}break;case"drop":case"teardrop":case"marker":var E=j*2/3;var D=E*0.5;var R=this.graphType=="Map"?-E*3:0;var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["arc",[0,R,Math.max(0,j),0,Math.PI,true]]);V.funcs.push(["bezierCurveTo",[-j,R+j,0,R+D,0,R+(E*3)]]);V.funcs.push(["bezierCurveTo",[0,R+D,j,R+j,j,R]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);V.funcs.push(["beginPath",[]]);V.funcs.push(["arc",[0,R,Math.max(0,j*0.3),0,Math.PI*2,true]]);V.funcs.push(["closePath",[]]);this.tl("white","black",ah,V);N.o.push(V);break;case"arrow":T=[[-j,-aC],[j,-aC],[j,aC],[-j,aC]];if(af){af=false;var E=ar/4;var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[j-ar,-aC]]);V.funcs.push(["lineTo",[j-ar,-aC-E]]);V.funcs.push(["lineTo",[j,0]]);V.funcs.push(["lineTo",[j-ar,aC+E]]);V.funcs.push(["lineTo",[j-ar,aC]]);V.funcs.push(["lineTo",[-j,aC]]);V.funcs.push(["lineTo",[-j,-aC]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V)}else{var q=aa/4;var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[-j,-aC+aa]]);V.funcs.push(["lineTo",[-j-q,-aC+aa]]);V.funcs.push(["lineTo",[0,-aC]]);V.funcs.push(["lineTo",[j+q,-aC+aa]]);V.funcs.push(["lineTo",[j,-aC+aa]]);V.funcs.push(["lineTo",[j,aC]]);V.funcs.push(["lineTo",[-j,aC]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V)}break;case"box":case"rect":var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[Y-j,X-aC]]);if(ar<=1){V.funcs.push(["lineTo",[Y+j,X-aC]])}else{if(aa<=1){V.funcs.push(["lineTo",[Y-j,X+aC]])}else{V.funcs.push(["lineTo",[Y+j,X-aC]]);V.funcs.push(["lineTo",[Y+j,X+aC]]);V.funcs.push(["lineTo",[Y-j,X+aC]])}}V.funcs.push(["closePath",[]]);this.tl(at,ai,(ar<=1||aa<=1?"open":ah),V);N.o.push(V);break;case"rectangle":var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);if(ah&&ah=="open"){V.funcs.push(["strokeRect",[-j,-aC,aa,ar]])}else{if(ai==at){V.funcs.push(["fillRect",[-j,-aC,aa,ar]])}else{V.funcs.push(["fillRect",[-j,-aC,aa,ar]]);V.funcs.push(["strokeRect",[-j,-aC,aa,ar]])}}N.o.push(V);break;case"rect2":return this.Pw("rectangle",Y,X,aa,aa/2,at,ai,ah,af,W,az,aB,ae,av,ab,ax);case"rect3":return this.Pw("rectangle",Y,X,aa,aa/3,at,ai,ah,af,W,az,aB,ae,av,ab,ax);case"roundrectt":var Z=aa>this.roundedPolygonRadius&&ar>this.roundedPolygonRadius?this.roundedPolygonRadius:aa>ar?ar:aa;var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[-j,-aC+Z]]);V.funcs.push(["lineTo",[-j,aC]]);V.funcs.push(["lineTo",[j,aC]]);V.funcs.push(["lineTo",[j,-aC+Z]]);V.funcs.push(["quadraticCurveTo",[j,-aC,j-Z,-aC]]);V.funcs.push(["lineTo",[-j+Z,-aC]]);V.funcs.push(["quadraticCurveTo",[-j,-aC,-j,-aC+Z]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"roundrectb":var Z=aa>this.roundedPolygonRadius&&ar>this.roundedPolygonRadius?this.roundedPolygonRadius:aa>ar?ar:aa;var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[-j,-aC]]);V.funcs.push(["lineTo",[-j,aC-Z]]);V.funcs.push(["quadraticCurveTo",[-j,aC,-j+Z,aC]]);V.funcs.push(["lineTo",[j-Z,aC]]);V.funcs.push(["quadraticCurveTo",[j,aC,j,aC-Z]]);V.funcs.push(["lineTo",[j,-aC]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"roundrectr":var Z=aa>this.roundedPolygonRadius&&ar>this.roundedPolygonRadius?this.roundedPolygonRadius:aa>ar?ar:aa;var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[-j,-aC]]);V.funcs.push(["lineTo",[-j,aC]]);V.funcs.push(["lineTo",[j-Z,aC]]);V.funcs.push(["quadraticCurveTo",[j,aC,j,aC-Z]]);V.funcs.push(["lineTo",[j,-aC+Z]]);V.funcs.push(["quadraticCurveTo",[j,-aC,j-Z,-aC]]);V.funcs.push(["lineTo",[-j,-aC]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"roundrectl":var Z=aa>this.roundedPolygonRadius&&ar>this.roundedPolygonRadius?this.roundedPolygonRadius:aa>ar?ar:aa;var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[-j,-aC+Z]]);V.funcs.push(["lineTo",[-j,aC-Z]]);V.funcs.push(["quadraticCurveTo",[-j,aC,-j+Z,aC]]);V.funcs.push(["lineTo",[j,aC]]);V.funcs.push(["lineTo",[j,-aC]]);V.funcs.push(["lineTo",[-j+Z,-aC]]);V.funcs.push(["quadraticCurveTo",[-j,-aC,-j,-aC+Z]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"roundrecttr":var Z=aa>this.roundedPolygonRadius&&ar>this.roundedPolygonRadius?this.roundedPolygonRadius:aa>ar?ar:aa;var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[-j,-aC]]);V.funcs.push(["lineTo",[-j,aC]]);V.funcs.push(["lineTo",[j,aC]]);V.funcs.push(["lineTo",[j,-aC+Z]]);V.funcs.push(["quadraticCurveTo",[j,-aC,j-Z,-aC]]);V.funcs.push(["lineTo",[-j,-aC]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"roundrecttl":var Z=aa>this.roundedPolygonRadius&&ar>this.roundedPolygonRadius?this.roundedPolygonRadius:aa>ar?ar:aa;var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[-j,-aC+Z]]);V.funcs.push(["lineTo",[-j,aC]]);V.funcs.push(["lineTo",[j,aC]]);V.funcs.push(["lineTo",[j,-aC]]);V.funcs.push(["lineTo",[-j+Z,-aC]]);V.funcs.push(["quadraticCurveTo",[-j,-aC,-j,-aC+Z]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"roundrectbr":var Z=aa>this.roundedPolygonRadius&&ar>this.roundedPolygonRadius?this.roundedPolygonRadius:aa>ar?ar:aa;var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[-j,-aC]]);V.funcs.push(["lineTo",[-j,aC]]);V.funcs.push(["lineTo",[j-Z,aC]]);V.funcs.push(["quadraticCurveTo",[j,aC,j,aC-Z]]);V.funcs.push(["lineTo",[j,-aC]]);V.funcs.push(["lineTo",[-j,-aC]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"roundrectbl":var Z=aa>this.roundedPolygonRadius&&ar>this.roundedPolygonRadius?this.roundedPolygonRadius:aa>ar?ar:aa;var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[-j,-aC]]);V.funcs.push(["lineTo",[-j,aC-Z]]);V.funcs.push(["quadraticCurveTo",[-j,aC,-j+Z,aC]]);V.funcs.push(["lineTo",[j,aC]]);V.funcs.push(["lineTo",[j,-aC]]);V.funcs.push(["lineTo",[-j,-aC]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"roundrecto":var Z=aa<ar?j:aC;var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);if(aa<ar){V.funcs.push(["arc",[0,-aC+Z,Z,Math.PI,0]]);V.funcs.push(["lineTo",[j,aC-Z]]);V.funcs.push(["arc",[0,aC-Z,Z,0,Math.PI]]);V.funcs.push(["lineTo",[-j,-aC+Z]])}else{V.funcs.push(["arc",[-j+Z,0,Z,Math.PI*0.5,Math.PI*1.5]]);V.funcs.push(["lineTo",[j-Z,aC]]);V.funcs.push(["arc",[j-Z,0,Z,Math.PI*1.5,Math.PI*0.5]]);V.funcs.push(["lineTo",[-j+Z,-aC]])}V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"roundrect":case"roundrect2":case"roundrectd":var Z=aa>this.roundedPolygonRadius&&ar>this.roundedPolygonRadius?this.roundedPolygonRadius:aa>ar?ar/4:aa/4;if(ad=="roundrect2"){Z*=4}var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[-j,-aC+Z]]);V.funcs.push(["lineTo",[-j,aC-Z]]);V.funcs.push(["quadraticCurveTo",[-j,aC,-j+Z,aC]]);V.funcs.push(["lineTo",[j-Z,aC]]);V.funcs.push(["quadraticCurveTo",[j,aC,j,aC-Z]]);V.funcs.push(["lineTo",[j,-aC+Z]]);V.funcs.push(["quadraticCurveTo",[j,-aC,j-Z,-aC]]);V.funcs.push(["lineTo",[-j+Z,-aC]]);V.funcs.push(["quadraticCurveTo",[-j,-aC,-j,-aC+Z]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);if(ad=="roundrectd"&&aa>this.roundedPolygonRadius&&ar>this.roundedPolygonRadius){aa-=this.roundedPolygonRadius;ar-=this.roundedPolygonRadius;j=aa/2;aC=ar/2;V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[-j,-aC+Z]]);V.funcs.push(["lineTo",[-j,aC-Z]]);V.funcs.push(["quadraticCurveTo",[-j,aC,-j+Z,aC]]);V.funcs.push(["lineTo",[j-Z,aC]]);V.funcs.push(["quadraticCurveTo",[j,aC,j,aC-Z]]);V.funcs.push(["lineTo",[j,-aC+Z]]);V.funcs.push(["quadraticCurveTo",[j,-aC,j-Z,-aC]]);V.funcs.push(["lineTo",[-j+Z,-aC]]);V.funcs.push(["quadraticCurveTo",[-j,-aC,-j,-aC+Z]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V)}N.o.push(V);break;case"brace":var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[-j,-aC]]);V.funcs.push(["bezierCurveTo",[-j,0,0,0,0,aC]]);V.funcs.push(["bezierCurveTo",[0,0,j,0,j,-aC]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"square":case"squareOpen":var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);this.hJ([[-j,-aC],[j,-aC],[j,aC],[-j,aC]],false,V);this.tl(at,ai,ah,V);N.o.push(V);break;case"triangle":case"triangleOpen":if(aa==ar){return this.Pw("equilateral",Y,X,aa,ar,at,ai,ah,af,W,az,aB,ae,av,ab,ax)}var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);this.hJ([[0,-aC],[j,aC],[-j,aC]],false,V);this.tl(at,ai,ah,V);N.o.push(V);break;case"triangle2":if(aa==ar){return this.Pw("equilateral2",Y,X,aa,ar,at,ai,ah,af,W,az,aB,ae,av,ab,ax)}var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);this.hJ([[0,aC],[j,-aC],[-j,-aC]],false,V);this.tl(at,ai,ah,V);N.o.push(V);break;case"equilateral":var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[Y,X-aC]]);V.funcs.push(["lineTo",[Y+j,X+aC]]);V.funcs.push(["lineTo",[Y-j,X+aC]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,(ar<=1||aa<=1?"open":ah),V);N.o.push(V);break;case"equilateral2":var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);this.hJ([[0,aC],[j,-aC],[-j,-aC]],false,V);this.tl(at,ai,ah,V);N.o.push(V);break;case"diamond":case"rhombus":case"diamondOpen":var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[Y,X-aC]]);V.funcs.push(["lineTo",[Y+j,X]]);V.funcs.push(["lineTo",[Y,X+aC]]);V.funcs.push(["lineTo",[Y-j,X]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,(ar<=1||aa<=1?"open":ah),V);N.o.push(V);break;case"hexagon":var g=2*Math.PI/6;var M=[];for(var ay=0;ay<6;ay++){M.push([j*Math.sin(g*ay),aC*Math.cos(g*ay)])}var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W);V.funcs.push(["beginPath",[]]);xs=M.shift();V.funcs.push(["moveTo",[Y+xs[0],X+xs[1]]]);for(var ay=0;M.length;ay++){xs=M.shift();V.funcs.push(["lineTo",[Y+xs[0],X+xs[1]]])}V.funcs.push(["closePath",[]]);this.tl(at,ai,(ar<=1||aa<=1?"open":ah),V);N.o.push(V);break;case"pentagon":var aw=aa/3;var T=[];for(var aq=0;aq<5;aq++){var F=(aq/5)*Math.PI*2+(-Math.PI/2);T.push([Math.cos(F)*aw,Math.sin(F)*aw])}var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);this.hJ(T,false,V);this.tl(at,ai,ah,V);N.o.push(V);break;case"octagon":var aE=aa/4;var ap=ar/4;var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[Y-aE,X-aC]]);V.funcs.push(["lineTo",[Y+aE,X-aC]]);V.funcs.push(["lineTo",[Y+j,X-ap]]);V.funcs.push(["lineTo",[Y+j,X+ap]]);V.funcs.push(["lineTo",[Y+aE,X+aC]]);V.funcs.push(["lineTo",[Y-aE,X+aC]]);V.funcs.push(["lineTo",[Y-j,X+ap]]);V.funcs.push(["lineTo",[Y-j,X-ap]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,(ar<=1||aa<=1?"open":ah),V);N.o.push(V);break;case"oval":case"ovald":var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["save",[]]);V.funcs.push(["scale",[1,ag]]);V.funcs.push(["beginPath",[]]);V.funcs.push(["arc",[0,0,Math.max(0,aa/2),0,Math.PI*2,true]]);V.funcs.push(["closePath",[]]);V.funcs.push(["restore",[]]);this.tl(at,ai,ah,V);if(ad=="ovald"){aa-=this.margin*2;ar-=this.margin*2;ag=ar/aa;V.funcs.push(["save",[]]);V.funcs.push(["scale",[1,ag]]);V.funcs.push(["beginPath",[]]);V.funcs.push(["arc",[0,0,Math.max(0,aa/2),0,Math.PI*2,true]]);V.funcs.push(["closePath",[]]);V.funcs.push(["restore",[]]);this.tl(at,ai,ah,V)}N.o.push(V);break;case"oval2":return this.Pw("oval",Y,X,aa,aa/2,at,ai,ah,af,W,az,aB,ae,av,ab,ax);case"oval3":return this.Pw("oval",Y,X,aa,aa/3,at,ai,ah,af,W,az,aB,ae,av,ab,ax);case"arc":var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["save",[]]);V.funcs.push(["scale",[1,ag]]);V.funcs.push(["beginPath",[]]);V.funcs.push(["arc",[0,0,Math.max(0,aa/2),ae,av,false]]);if(ah!="open"){V.funcs.push(["closePath",[]])}V.funcs.push(["restore",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"arc2":var H=ar*Math.cos(ae);var aH=ar*Math.sin(ae);var G=ar*Math.cos(av);var aF=ar*Math.sin(av);var C=this.On(0,0,H,aH,0,aa,"line");var A=this.On(0,0,G,aF,0,aa,"line");var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[C[2],C[3]]]);V.funcs.push(["lineTo",[H,aH]]);V.funcs.push(["arc",[0,0,Math.max(0,ar),ae,av,false]]);V.funcs.push(["lineTo",[A[2],A[3]]]);V.funcs.push(["arc",[0,0,Math.max(0,ar-aa),av,ae,true]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"arc3":var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["save",[]]);V.funcs.push(["scale",[1,ag]]);V.funcs.push(["beginPath",[]]);V.funcs.push(["arc",[0,0,Math.max(0,aa/2),0,Math.PI,false]]);V.funcs.push(["restore",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"arch":var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[T[0][0],T[0][1]]]);V.funcs.push(["quadraticCurveTo",[T[1][0],T[1][1],T[2][0],T[2][1]]]);V.funcs.push(["arc",[0,0,Math.max(0,ar[0]),aa[3],aa[2],true]]);V.funcs.push(["quadraticCurveTo",[T[4][0],T[4][1],T[5][0],T[5][1]]]);V.funcs.push(["arc",[0,0,Math.max(0,ar[1]),aa[1],aa[0],true]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"path":var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);this.hJ(T,ah=="open",V);this.tl(at,ai,ah,V);N.o.push(V);break;case"roundpolygon":T=this.dX(T);var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);for(var aq=0;aq<T.length;aq++){V.funcs.push(["arc",[T[aq][0],T[aq][1],T[aq][2],T[aq][3],T[aq][4]]])}V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"polygon":var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);this.hJ(T,ah=="open"&&at,V);this.tl(at,ai,ah,V);N.o.push(V);break;case"spline":var ac=[];var ak=[];var I=[];ak.push(aA.shift());ak.push(aA.shift());I.push(aA.pop());I.unshift(aA.pop());var aj=aA.length;for(var aq=0;aq<aj-4;aq+=2){ac=ac.concat(this.Ln(aA[aq],aA[aq+1],aA[aq+2],aA[aq+3],aA[aq+4],aA[aq+5]))}var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[ak[0],ak[1]]]);V.funcs.push(["lineTo",[aA[0],aA[1]]]);V.funcs.push(["quadraticCurveTo",[ac[0],ac[1],aA[2],aA[3]]]);for(var aq=2;aq<aj-5;aq+=2){V.funcs.push(["bezierCurveTo",[ac[2*aq-2],ac[2*aq-1],ac[2*aq],ac[2*aq+1],aA[aq+2],aA[aq+3]]])}V.funcs.push(["quadraticCurveTo",[ac[2*aj-10],ac[2*aj-9],aA[aj-2],aA[aj-1]]]);V.funcs.push(["lineTo",[I[0],I[1]]]);V.funcs.push(["lineTo",[ak[0],ak[1]]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"hull":var ao;var aj=1;var J=[];while(aA.length>1){J.push([aA.shift(),aA.shift()])}var ac=this.wr(J);var m=[[J[0][0],J[0][1],ac[ac.length-1][0],ac[ac.length-1][1],ac[0][0],ac[0][1],J[1][0],J[1][1]]];for(var aq=1;aq<J.length-1;aq++){m.push([J[aq][0],J[aq][1],ac[aj][0],ac[aj][1],ac[aj+1][0],ac[aj+1][1],J[aq+1][0],J[aq+1][1]]);aj+=2}m.push([J[aq][0],J[aq][1],ac[aj][0],ac[aj][1],ac[aj+1][0],ac[aj+1][1],J[0][0],J[0][1]]);var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[m[0][0],m[0][1]]]);for(var aq=0;aq<m.length;aq++){V.funcs.push(["bezierCurveTo",[m[aq][2],m[aq][3],m[aq][4],m[aq][5],m[aq][6],m[aq][7]]])}V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"violin":var aj=aA.length;var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[aA[0][0],aA[1][0]]]);for(var aq=2;aq<aj;aq+=2){V.funcs.push(["lineTo",[aA[aq][0],aA[aq+1][0]]])}V.funcs.push(["lineTo",[aA[aj-2][1],aA[aj-1][1]]]);for(var aq=2;aq<aj;aq+=2){var aG=(aj-1)-aq;V.funcs.push(["lineTo",[aA[aG-1][1],aA[aG][1]]])}V.funcs.push(["lineTo",[aA[0][0],aA[1][0]]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"fish":var aj=aA.length;var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[aA[0][0],aA[1][0]]]);for(var aq=2;aq<aj;aq+=2){var v=(aA[aq-2][0]+aA[aq][0])/2;V.funcs.push(["bezierCurveTo",[v,aA[aq-1][0],v,aA[aq+1][0],aA[aq][0],aA[aq+1][0]]])}V.funcs.push(["lineTo",[aA[aj-2][1],aA[aj-1][1]]]);for(var aq=2;aq<aj;aq+=2){var aG=(aj-1)-aq;var v=(aA[aG+1][1]+aA[aG-1][1])/2;V.funcs.push(["bezierCurveTo",[v,aA[aG+2][1],v,aA[aG][1],aA[aG-1][1],aA[aG][1]]])}V.funcs.push(["lineTo",[aA[0][0],aA[1][0]]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"confidence":var aj=aA.length;var ac=[];var P=[];for(var aq=0;aq<aj-4;aq+=2){var aG=(aj-1)-aq;ac=ac.concat(this.Ln(aA[aq][0],aA[aq+1][0],aA[aq+2][0],aA[aq+3][0],aA[aq+4][0],aA[aq+5][0]));P=P.concat(this.Ln(aA[aG-1][1],aA[aG][1],aA[aG-3][1],aA[aG-2][1],aA[aG-5][1],aA[aG-4][1]))}var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[aA[0][0],aA[1][0]]]);V.funcs.push(["quadraticCurveTo",[ac[0],ac[1],aA[2][0],aA[3][0]]]);for(var aq=2;aq<aj-5;aq+=2){V.funcs.push(["bezierCurveTo",[ac[2*aq-2],ac[2*aq-1],ac[2*aq],ac[2*aq+1],aA[aq+2][0],aA[aq+3][0]]])}V.funcs.push(["quadraticCurveTo",[ac[2*aj-10],ac[2*aj-9],aA[aj-2][0],aA[aj-1][0]]]);V.funcs.push(["lineTo",[aA[aj-2][1],aA[aj-1][1]]]);V.funcs.push(["quadraticCurveTo",[P[0],P[1],aA[aj-4][1],aA[aj-3][1]]]);for(var aq=2;aq<aj-5;aq+=2){var aG=(aj-1)-aq;V.funcs.push(["bezierCurveTo",[P[2*aq-2],P[2*aq-1],P[2*aq],P[2*aq+1],aA[aG-3][1],aA[aG-2][1]]])}V.funcs.push(["quadraticCurveTo",[P[2*aj-10],P[2*aj-9],aA[0][1],aA[1][1]]]);V.funcs.push(["lineTo",[aA[0][0],aA[1][0]]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"bezier":var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[aA[0],aA[1]]]);V.funcs.push(["bezierCurveTo",[aA[2],aA[3],aA[4],aA[5],aA[6],aA[7]]]);V.funcs.push(["lineTo",[aA[6],aA[7]+ar]]);V.funcs.push(["bezierCurveTo",[aA[4],aA[5]+ar,aA[2],aA[3]+ar,aA[0],aA[1]+ar]]);V.funcs.push(["lineTo",[aA[0],aA[1]]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"ellipse":var a=j*0.5522848;var au=aC*0.5522848;var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[0,aC]]);V.funcs.push(["bezierCurveTo",[0,aC-au,j-a,0,j,0]]);V.funcs.push(["bezierCurveTo",[j+a,0,aa,aC-au,aa,aC]]);V.funcs.push(["bezierCurveTo",[aa,aC+au,j+a,ar,j,ar]]);V.funcs.push(["bezierCurveTo",[j-a,ar,0,aC+au,0,aC]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"ellipse2":return this.Pw("ellipse",Y,X,aa,aa/2,at,ai,ah,af,W,az,aB,ae,av,ab,ax);break;case"ellipse3":return this.Pw("ellipse",Y,X,aa,aa/3,at,ai,ah,af,W,az,aB,ae,av,ab,ax);break;case"plus":var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[Y-al,X-aC]]);V.funcs.push(["lineTo",[Y+al,X-aC]]);V.funcs.push(["lineTo",[Y+al,X-al]]);V.funcs.push(["lineTo",[Y+j,X-al]]);V.funcs.push(["lineTo",[Y+j,X+al]]);V.funcs.push(["lineTo",[Y+al,X+al]]);V.funcs.push(["lineTo",[Y+al,X+aC]]);V.funcs.push(["lineTo",[Y-al,X+aC]]);V.funcs.push(["lineTo",[Y-al,X+al]]);V.funcs.push(["lineTo",[Y-j,X+al]]);V.funcs.push(["lineTo",[Y-j,X-al]]);V.funcs.push(["lineTo",[Y-al,X-al]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"minus":var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[Y-j,X-al]]);V.funcs.push(["lineTo",[Y+j,X-al]]);V.funcs.push(["lineTo",[Y+j,X+al]]);V.funcs.push(["lineTo",[Y-j,X+al]]);V.funcs.push(["lineTo",[Y-j,X-al]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"mdavid":var aw=aa/3;var B=Math.PI/6;var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["save",[]]);V.funcs.push(["scale",[0.8,0.8]]);V.funcs.push(["rotate",[K*0.45]]);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[aw,0]]);for(var aq=0;aq<11;aq++){V.funcs.push(["rotate",[B]]);if(aq%2==0){V.funcs.push(["lineTo",[(aw/0.55),0]])}else{V.funcs.push(["lineTo",[aw,0]])}}V.funcs.push(["closePath",[]]);V.funcs.push(["restore",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"star":var k=(aa/4);var K=Math.PI/5;var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["save",[]]);V.funcs.push(["scale",[0.7,0.7]]);V.funcs.push(["rotate",[K*0.45]]);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[k,0]]);for(var aq=0;aq<9;aq++){V.funcs.push(["rotate",[K]]);if(aq%2==0){V.funcs.push(["lineTo",[(k/0.35),0]])}else{V.funcs.push(["lineTo",[k,0]])}}V.funcs.push(["closePath",[]]);V.funcs.push(["restore",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"pie":if(typeof(ae)=="undefined"){ae=0}if(typeof(av)=="undefined"){av=Math.PI*2}var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["arc",[0,0,Math.max(0,aa/2),ae,av,false]]);V.funcs.push(["lineTo",[0,0]]);V.funcs.push(["closePath",[]]);this.tl(at,ai,ah,V);N.o.push(V);break;case"pie0":return this.Pw("pie",Y,X,aa,aa/2,at,ai,ah,af,W,az,aB,0,Math.PI/5,ab,ax);break;case"pie1":return this.Pw("pie",Y,X,aa,aa/2,at,ai,ah,af,W,az,aB,0,Math.PI/3.5,ab,ax);break;case"pie2":return this.Pw("pie",Y,X,aa,aa/2,at,ai,ah,af,W,az,aB,0,Math.PI/2,ab,ax);break;case"pie3":return this.Pw("pie",Y,X,aa,aa/2,at,ai,ah,af,W,az,aB,0,Math.PI/1.5,ab,ax);break;case"pie4":return this.Pw("pie",Y,X,aa,aa/2,at,ai,ah,af,W,az,aB,0,Math.PI,ab,ax);break;case"pie5":return this.Pw("pie",Y,X,aa,aa/2,at,ai,ah,af,W,az,aB,0,Math.PI*1.2,ab,ax);break;case"pie6":return this.Pw("pie",Y,X,aa,aa/2,at,ai,ah,af,W,az,aB,0,Math.PI*1.4,ab,ax);break;case"pie7":return this.Pw("pie",Y,X,aa,aa/2,at,ai,ah,af,W,az,aB,0,Math.PI*1.6,ab,ax);break;case"pie8":return this.Pw("pie",Y,X,aa,aa/2,at,ai,ah,af,W,az,aB,0,Math.PI*1.8,ab,ax);break;case"pie9":return this.Pw("pie",Y,X,aa,aa/2,at,ai,ah,af,W,az,aB,0,Math.PI*2,ab,ax);break;case"pacman":return this.Pw("pie",Y,X,aa,aa/2,at,ai,ah,af,W,az,aB,Math.PI*1/4,Math.PI*7/4,ab,ax);break;case"pacman2":return this.Pw("pie",Y,X,aa,aa/2,at,ai,ah,af,W,az,aB,Math.PI*5/4,Math.PI*3/4,ab,ax);break;case"pch0":this.Pw("square",Y,X,aa,aa,at,ai,"open",false,W,az,aB,ae,av,ab,ax);break;case"pch1":this.Pw("circle",Y,X,aa,aa,at,ai,"open",false,W,az,aB,ae,av,ab,ax);break;case"pch2":this.Pw("equilateral",Y,X,aa,aa,at,ai,"open",false,W,az,aB,ae,av,ab,ax);break;case"pch3":var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[0,-aC]]);V.funcs.push(["lineTo",[0,aC]]);V.funcs.push(["stroke",[]]);V.funcs.push(["moveTo",[-j,0]]);V.funcs.push(["lineTo",[j,0]]);V.funcs.push(["stroke",[]]);N.o.push(V);break;case"pch4":var V=this.Ce(Y,X,aa,ar,at,ai,ah,af,W,N);V.funcs.push(["beginPath",[]]);V.funcs.push(["moveTo",[-j,-aC]]);V.funcs.push(["lineTo",[j,aC]]);V.funcs.push(["stroke",[]]);V.funcs.push(["moveTo",[j,-aC]]);V.funcs.push(["lineTo",[-j,aC]]);V.funcs.push(["stroke",[]]);N.o.push(V);break;case"pch5":this.Pw("diamond",Y,X,aa,aa,at,ai,"open",false,W,az,aB,ae,av,ab,ax);break;case"pch6":this.Pw("equilateral2",Y,X,aa,aa,at,ai,"open",false,W,az,aB,ae,av,ab,ax);break;case"pch7":this.Pw("pch0",Y,X,aa,ar,at,ai,"open",false,W,az,aB,ae,av,ab,ax);this.Pw("pch4",Y,X,aa,ar,at,ai,"open",false,W,az,aB,ae,av,ab,ax);break;case"pch8":this.Pw("pch3",Y,X,aa,ar,at,ai,"open",false,W,az,aB,ae,av,ab,ax);this.Pw("pch4",Y,X,aa,ar,at,ai,"open",false,W,az,aB,ae,av,ab,ax);break;case"pch9":this.Pw("pch3",Y,X,aa,ar,at,ai,"open",false,W,az,aB,ae,av,ab,ax);this.Pw("pch5",Y,X,aa,ar,at,ai,"open",false,W,az,aB,ae,av,ab,ax);break;case"pch10":this.Pw("pch1",Y,X,aa,ar,at,ai,"open",false,W,az,aB,ae,av,ab,ax);this.Pw("pch3",Y,X,aa,ar,at,ai,"open",false,W,az,aB,ae,av,ab,ax);break;case"pch11":this.Pw("pch2",Y,X,aa,ar,at,ai,"open",false,W,az,aB,ae,av,ab,ax);this.Pw("pch6",Y,X,aa,ar,at,ai,"open",false,W,az,aB,ae,av,ab,ax);break;case"pch12":this.Pw("pch0",Y,X,aa,ar,at,ai,"open",false,W,az,aB,ae,av,ab,ax);this.Pw("pch3",Y,X,aa,ar,at,ai,"open",false,W,az,aB,ae,av,ab,ax);break;case"pch13":this.Pw("pch1",Y,X,aa,ar,at,ai,"open",false,W,az,aB,ae,av,ab,ax);this.Pw("pch4",Y,X,aa,ar,at,ai,"open",false,W,az,aB,ae,av,ab,ax);break;case"pch14":this.Pw("pch0",Y,X,aa,ar,at,ai,"open",false,W,az,aB,ae,av,ab,ax);this.Pw("pch6",Y,X,aa,ar,at,ai,"open",false,W,az,aB,ae,av,ab,ax);break;case"pch15":case"pch22":this.Pw("square",Y,X,aa,aa,at||this.foreground,ai,"closed",false,W,az,aB,ae,av,ab,ax);break;case"pch16":case"pch21":this.Pw("circle",Y,X,aa,aa,at||this.foreground,ai,"closed",false,W,az,aB,ae,av,ab,ax);break;case"pch17":case"pch24":this.Pw("equilateral",Y,X,aa,aa,at||this.foreground,ai,"closed",false,W,az,aB,ae,av,ab,ax);break;case"pch18":case"pch23":this.Pw("diamond",Y,X,aa,aa,at||this.foreground,ai,"closed",false,W,az,aB,ae,av,ab,ax);break;case"pch19":this.Pw("circle",Y,X,aa+2,aa+2,at||this.foreground,ai,"closed",false,W,az,aB,ae,av,ab,ax);break;case"pch20":this.Pw("circle",Y,X,Math.max(2,aa-2),Math.max(2,aa-2),at||this.foreground,ai,"closed",false,W,az,aB,ae,av,ab,ax);break;case"pch25":this.Pw("equilateral2",Y,X,aa,aa,at||this.foreground,ai,"closed",false,W,az,aB,ae,av,ab,ax);break;default:break}if(ad=="sphere"||ad=="circle"||ad=="circleOpen"||ad=="rect"||ad=="equilateral"||ad=="plus"||ad=="minus"||ad=="diamond"||ad=="rhombus"||ad=="diamondOpen"||ad=="hexagon"||ad=="octagon"){this.AO(N)}else{this.AO(N);this.mJ(N)}};this.VN=function(a){var b=this.$cX("canvas",{width:a.naturalWidth,height:a.naturalHeight});b.ctx=this.TO(b);b.ctx.drawImage(a,0,0);return b};this.cF=function(k){var s=k.naturalWidth;var l=k.naturalHeight;var o=this.VN(k);var m=o.ctx.getImageData(0,0,s,l).data;for(var f=0;f<l;f++){var t=l-(f+1);for(var e=0;e<s;e++){var d=parseInt(m[t][e][0]*255);var n=parseInt(m[t][e][1]*255);var p=parseInt(m[t][e][2]*255);var q=m[t][e][3]?parseInt(m[t][e][3]*255):255;o.ctx.fillStyle="rgba("+d+","+n+","+p+","+q+")";o.ctx.fillRect(e,f,1,1)}}return o.toDataURL("img/png")};this.nD=function(e,k){var m=this.VN(e);var b=k?this.WB(k):false;var j=m.ctx.getImageData(0,0,e.naturalWidth,e.naturalHeight);var l=j.data;for(var e=0;e<l.length;e+=4){var h=0.34*l[e]+0.5*l[e+1]+0.16*l[e+2];if(h>220){h=255;l[e]=h;l[e+1]=h;l[e+2]=h;l[e+3]=0}else{l[e]=k?b[0]:h;l[e+1]=k?b[1]:h;l[e+2]=k?b[2]:h}}m.ctx.putImageData(j,0,0);return m};this.il=function(l){var k=l.length;var q=l[0].length;var n=this.$cX("canvas",{width:q,height:k});n.ctx=this.TO(n);n.ctx.clearRect(0,0,q,k);for(var f=0;f<k;f++){var s=k-(f+1);for(var e=0;e<q;e++){var d=parseInt(l[s][e][0]*255);var m=parseInt(l[s][e][1]*255);var o=parseInt(l[s][e][2]*255);var p=l[s][e][3]?parseInt(l[s][e][3]*255):255;n.ctx.fillStyle="rgba("+d+","+m+","+o+","+p+")";if(this.scatterType=="visium"&&this.visiumFlip){n.ctx.fillRect(e,f,1,1)}else{n.ctx.fillRect(e,s,1,1)}}}if(this.scatterType=="visium"){this.backgroundImageRows=k;this.backgroundImageCols=q}return n.toDataURL("img/png")};this.Np=function(x,v,m,j,y,D,s,p,F,g,o,u){if(!u){u=this.ZO()}try{v=parseInt(Math.round(v||0));m=parseInt(Math.round(m||0));j=parseInt(Math.round(j||x.naturalWidth));y=parseInt(Math.round(y||x.naturalHeight));if(this.scatterType=="visium"){if(this.visiumFlip){var A=this.xAxisMin;var z=this.xAxisMax;var b=x.naturalHeight-this.yAxisMax;var c=x.naturalHeight-this.yAxisMin;var f=z-A;var E=b-c;var a=j/f;var G=y/E;var k=(j-f)/2;var B=(y-E)/2;var n=this.yAxisMax;u.o.push({funcs:[["scale",[a,G]],["drawImage",[x,A,n,f,E,v+k,m+B,f,E]],["scale",[1/a,1/G]]]})}else{var A=this.xAxisMin;var z=this.xAxisMax;var b=this.yAxisMax;var c=this.yAxisMin;var f=z-A;var E=b-c;var a=j/f;var G=y/E;var k=(j-f)/2;var B=(y-E)/2;var n=x.naturalHeight-this.yAxisMax;u.o.push({funcs:[["scale",[a,G]],["drawImage",[x,A,n,f,E,v+k,m+B,f,E]],["scale",[1/a,1/G]]]})}}else{if(D&&s&&p&&F){D=parseInt(Math.round(D));s=parseInt(Math.round(s));p=parseInt(Math.round(p));F=parseInt(Math.round(F));u.o.push({funcs:[["drawImage",[x,v,m,j,y,D,s,p,F]],["drawImage",[this.nD(x,g),v,m,j,y,D,s,p,F]]]})}else{if(g&&g=="b&w"){u.o.push({funcs:[["drawImage",[this.nD(x),v,m,j,y]]]})}else{if(g){u.o.push({funcs:[["drawImage",[x,v,m,j,y]],["drawImage",[this.nD(x,g),v,m,j,y]]]})}else{if(o=="round"){var q=Math.max(j,y)/2;u.o.push({funcs:[["save",[]],["beginPath",[]],["arc",[v+q,m+q,q,0,Math.PI*2]],["clip",[]],["drawImage",[x,v,m,j,y]],["restore",[]]]})}else{u.o.push({funcs:[["drawImage",[x,v,m,j,y]]]})}}}}}}catch(C){var d=this;d.Ki(C);setTimeout(function(){d.dG({func:"drawImage",par:[x,v,m,j,y,D,s,p,F,g]})},100)}};this.Tx=function(b,a){if(!CanvasXpress.system.isIE&&b){if(!a){a=this.ZO()}a.o.push({globalCompositeOperation:b})}};this.t5=function(a,e,c,d,b){if(!b){b=this.ZO()}b.o.push({funcs:[["clearRect",[a,e,c,d]]]})};this.PW=function(a,c,b){if(!b){b=this.ZO()}b.o.push({funcs:[["translate",[a,c]]]})};this.XN=function(b,a){if(!a){a=this.ZO()}a.o.push({funcs:[["rotate",[b]]]})};this.dl=function(a,c,b){if(!b){b=this.ZO()}b.o.push({funcs:[["scale",[a,c]]]})};this.GG=function(a){if(!a){a=this.ZO()}a.o.push({funcs:[["save",[]]]})};this.mJ=function(a){if(!a){a=this.ZO()}a.o.push({funcs:[["restore",[]]]})}};CanvasXpress.prototype.initRangeAlgorithms=function(){this.er=function(h,d){if(h==undefined){h=0}var g=h;var e=h.toString();var k=e.indexOf("999999");var i=e.indexOf("000000");var j=e.indexOf(".");var b=k>=0&&j<k?k:i>=0?i:null;if(b!=null){g=e.substring(0,b);f=Math.pow(10,g.length-(g.indexOf(".")+1));return Number(Math.round(Number(e)*f)/f)}else{return d?Number.parseFloat(e).toFixed(d):Number(e)}};this.NH=function(d,m,b,g){var c=function(i,n){var q;var r=Math.floor(Math.log(i)/Math.LN10);var p=i/Math.pow(10,r);if(n){if(p<1.5){q=1}else{if(p<3){q=2}else{if(p<7){q=5}else{q=10}}}}else{if(p<1){q=1}else{if(p<2){q=2}else{if(p<5){q=5}else{q=10}}}}return q*Math.pow(10,r)};if(d>m){var h=m;d=m;d=h}else{if(m-d<1e-8){m+=0.1}}var l=[];var j=c(m-d,false);var o=c(j/(b-1),true);var a=Math.floor(d/o)*o;var k=Math.ceil(m/o)*o;for(var e=a;e<=k;e+=o){l.push(this.er(e))}if(l[0]==l[l.length-1]){var l=[];for(var e=a;e<=k;e+=o){l.push(e)}}return g?l:this.la(l)};this.hC=function(c,l,a,h){var b=function(B,D,C,A){var w=[10,1,5,2,2.5,3,4,1.5,7,6,8,9];var y=D-B;var t=C-1;var q=1-Math.abs(C-A)/A;var F=y/t;var v=Math.floor(Math.log(F)/Math.LN10);var G=Math.pow(10,v);var r=null;for(var E=0;E<w.length;E++){var u=w[E]*G;var H=Math.floor(B/u)*u;var n=H+t*u;if(H<=B&&n>=D){var x=1-(E-(H<=0&&n>=0?1:0))/w.length;var s=(D-B)/(n-H);if(s>0.8){var z=q+x+s;if(r==null||z>r.score){r={lmin:H,lmax:n,lstep:u,score:z}}}}}if(!r){r={lmin:B,lmax:D,lstep:1,score:0}}return r};if(l==c){if(c==0){c=-1;l=1}else{c-=Math.abs(c*0.1);l+=Math.abs(l*0.1)}}if(c>l){var j=l;c=l;c=j}else{if(l-c<1e-8){}}var m=[];var e=null;var o=[];for(var g=Math.max(Math.floor(a/2),2);g<=Math.ceil(6*a);g++){o.push(g)}for(var g=0;g<o.length;g++){var d=o[g];var p=b(c,l,d,a);if((p!=null&&e==null)||(p&&e&&p.score>e.score)){e=p}}for(var g=e.lmin;g<=e.lmax;g+=e.lstep){m.push(this.er(g))}if(m[0]==m[m.length-1]){var m=[];for(var g=e.lmin;g<=e.lmax;g+=e.lstep){m.push(g)}}return h?m:this.la(m)};this.NM=function(a,B,T,d,E){var l=function(j,g){for(var c=0;c<g.length;c++){if(j==g[c]){return c}}};var L=function(c,w,m,g,z,aa){var k=w.length;var s=l(c,w);var ab=(g%aa<C||aa-(g%aa)<C)&&g<=0&&z>=0?1:0;return 1-s/(k-1)-m+ab};var M=function(s,m,g){var w=m.length;var k=l(s,m);var c=1;return 1-k/(w-1)-g+c};var o=function(c,i,j,g){return 1-0.5*(Math.pow(i-g,2)+Math.pow(c-j,2))/Math.pow(0.1*(i-c),2)};var u=function(c,k,i){var g=k-c;if(i>g){var j=(i-g)/2;return 1-0.5*(Math.pow(j,2)+Math.pow(j,2))/Math.pow(0.1*g,2)}else{return 1}};var r=function(j,c,i,s,w,q){var n=(j-1)/(q-w);var g=(c-1)/(Math.max(q,s)-Math.min(i,w));return 2-Math.max(n/g,g/n)};var Z=function(g,c){return g>=c?2-(g-1)/(c-1):1};var h=[1,5,2,2.5,4,3];var I=[0.25,0.2,0.5,0.05];var S=h.length;var N={score:-2};var J=[];var C=2.22e-14;if(B==a){if(a==0){a=-1;B=1}else{a-=Math.abs(a*0.1);B+=Math.abs(B*0.1)}}if(a>B){var p=a;a=B;B=p}else{if(B-a<1e-8){}}var V=1;while(V<Number.POSITIVE_INFINITY){for(var W=0;W<S;W++){var P=h[W];var x=M(P,h,V);if((I[0]*x+I[1]+I[2]+I[3]<N.score)){V=Number.POSITIVE_INFINITY;break}var U=2;while(U<Number.POSITIVE_INFINITY){var t=Z(U,T);if((I[0]*x+I[1]+I[2]*t+I[3]<N.score)){break}var G=(B-a)/(U+1)/V/P;var H=Math.ceil(Math.log(G)/Math.LN10);while(H<Number.POSITIVE_INFINITY){var F=V*P*Math.pow(10,H);var D=u(a,B,F*(U-1));if((I[0]*x+I[1]*D+I[2]*t+I[3]<N.score)){break}var y=Math.floor(B/F)*V-(U-1)*V;var R=Math.ceil(a/F)*V;if(y>R){H++;continue}for(var A=y;A<=R;A++){var v=A*(F/V);var O=v+F*(U-1);var e=F;var K=L(P,h,V,v,O,e);var Y=o(a,B,v,O);var X=r(U,T,a,B,v,O);var b=I[0]*K+I[1]*Y+I[2]*X+I[3];if(b>N.score&&(!E||(v<=a&&O>=B))){N={lmin:v,lmax:O,lstep:e,score:b}}}H++}U++}}V++}for(var W=N.lmin;W<=N.lmax;W+=N.lstep){J.push(this.er(W))}if(J[0]==J[J.length-1]){var J=[];for(var W=N.lmin;W<=N.lmax;W+=N.lstep){J.push(W)}}return d?J:this.la(J)};this.Zh=function(l,m,z,i){if(l>m){var y=m;m=l;l=y}if((isNaN(l)||isNaN(m))||(!isFinite(l)||!isFinite(m))){return[]}var v=Math.floor(z%3);var g=0.75;var x=1.5;var e=0.5+1.5*x;var w=2e-20;var j=0;var b,s,c;var o=Number.EPSILON;var u=1.25;var a=1e-10;var n=m-l;if(n==0&&m==0){b=1;s=true}else{b=Math.max(Math.abs(l),Math.abs(m));c=1+((e>=1.5*x+0.5)?1/(1+x):1.5/(1+e));c*=parseInt(Math.max(1,z))*o;s=n<b*c*3}if(s){if(b>10){b=9+b/10}b*=g;if(v>1){b/=v}}else{b=n;if(isFinite(n)){if(z>1){b/=z}else{if(z<2){b=m*0.5}else{b=m/z-l/z}}}}var r=w*Number.MIN_VALUE;if(r==0){r=Number.MIN_VALUE}if(b<r){alert("Error in rPretty: very small range");b=r}else{if(b>Number.MAX_VALUE/u){alert("Error in rPretty: very large range");b=Number.MAX_VALUE/u}}var d=Math.pow(10,Math.floor(Math.log10(b)));var q=d;if((2*d)-b<x*(b-q)){q=2*d;if((5*d)-b<e*(b-q)){q=5*d;if((10*d)-b<x*(b-q)){q=10*d}}}var B=Math.floor(l/q+a);var A=Math.ceil(m/q-a);if(j&&(j>1||!s)){if(l!=0){l*=(1-o)}else{l=-Number.MIN_VALUE}if(m!=0){m*=(1+o)}else{m=Number.MIN_VALUE}}while(B*q>l+(a*q)){B--}while(!isFinite(B*q)){B++}while(A*q<m-(a*q)){A++}while(!isFinite(B*q)){B--}var t=Math.floor(0.5+A-B);if(t<v){t=v-t;if(l==0&&B==0&&m!=0){A+=t}else{if(m==0&&A==0&&l!=0){B-=t}else{if(B>=0){A+=t/2;B-=t/2+t%2}else{B-=t/2;A+=t/2+t%2}}}z=v}else{z=t}if(B*q<l){l=B*q}if(A*q>m){m=A*q}var p=this.Tr(l,m,false,z+1);return i?p:this.la(p)}};CanvasXpress.prototype.initPrimitives=function(){this.initText();this.initTime();this.initColor();this.initAttributes();this.initRangeAlgorithms()};CanvasXpress.prototype.initGeneralUtils=function(){this.ub=function(c,g,h,f,j){if(this.QT()){return}var e=this[h];if(f){var a={};if(this.eO(c)){var b=c.length;for(var d=0;d<b;d++){a[c[d]]=true}}else{a[c]=true}for(var d in a){if(e.includes(d)){e=this.Ad(d,e);delete (a[d])}}for(var d in a){e.push(d)}this[h]=e}else{if(g){var a={};var k=[];if(this.eO(c)){var b=c.length;for(var d=0;d<b;d++){a[c[d]]=1}}else{a[c]=1}var b=e.length;for(var d=0;d<b;d++){if(!a.hasOwnProperty(e[d])){k.push(e[d])}}this[h]=k}else{if(this.eO(c)){var b=c.length;for(var d=0;d<b;d++){e.push(c[d])}}else{e.push(c)}}}if(j){this.dG({func:"modifyObjectArray",par:[c,g,h,f,j]})}};this.NB=function(b){var d={};if(b&&this.eO(b)){var e=b.length;for(var c=0;c<e;c++){d[b[c]]=true}}return d};this.dC=function(c){var f=[];if(c&&this.eO(c)){var g=c.length;for(var e=0;e<g;e++){f[e]=[];if(c[e]&&this.eO(c[e])){var b=c[e].length;for(var d=0;d<b;d++){f[e][c[e][d]]=true}}}}return f};this.JG=function(b){var d={};if(b&&this.eO(b)){var e=b.length;for(var c=0;c<e;c++){d[b[c]+""]=c}}return d};this.UR=function(e,d){var h=[];if(!this.eO(e)){e=this.eG(e)}var f=this.NB(this.eG(d));for(var g=0;g<e.length;g++){if(f.hasOwnProperty(e[g].toString())){h.push(e[g])}}return h};this.Ad=function(e,b){if(this.eO(b)){var d=[];var f=b.length;for(var c=0;c<f;c++){if(b[c]!=e){d.push(b[c])}}}return d};this.Kj=function(a){return a&&typeof a==="function";var b={};return a&&b.toString.call(a)==="[object Function]"};this.eO=function(a){return Array.isArray(a)};this.Ov=function(a){return a instanceof Object};this.pv=function(b){return this.Be(b).length==b.length};this.f6=function(b){var d=b.length;if(this.isR){for(var c=0;c<d;c++){if(this.Ov(b[c])){return false}else{if(b[c]==null){continue}else{if(typeof(b[c])=="string"){if(b[c].toLowerCase()!="true"&&b[c].toLowerCase()!="false"&&b[c]!==""){return false}}}}}}else{for(var c=0;c<d;c++){if(this.Ov(b[c])){return false}else{if(typeof(b[c])=="string"){if(b[c].toLowerCase()!="true"&&b[c].toLowerCase()!="false"&&b[c]!==""){return false}}else{if(b[c]!==true&&b[c]!==false&&b[c]!==""&&b[c]!==null){return false}}}}}return true};this.Nb=function(a){return/^https*:\/\//.test(a)};this.C3=function(c,e){var b=/^<a.*>.*<\/a>/i.test(c);if(b&&e){var d=/<a.*?href=['"](.*?)['"].*?>(.*?)<\/a>/i.exec(c);return d?[d[1],d[2]]:false}else{return b}};this.hD=function(b){var a=/<img.*?src=['"](.*?)['"].*?\/>/i.exec(b);return a&&a[1]?a[1]:false};this.eG=function(a){return this.eO(a)?a:[a]};this.Cl=function(l,d){if(this.data[l]&&this.data[l][d]){var h=this.data[l][d];var f=this.zK(h);var b={};var j=false;for(var g=0;g<f.length;g++){if(f[g]!=null&&(f[g].toString().match(/\[/)||f[g].toString().match(/\]/)||f[g].toString().match(/\{/)||f[g].toString().match(/\}/))){j=true;try{b[f[g]]=JSON.stringify(f[g])}catch(k){b[f[g]]=f[g].toString().replace(/\[/,"(").replace(/\]/,")").replace(/\{/,"(").replace(/\}/,")")}}else{if(f[g]==null){b[f[g]]=null}}}if(j){for(var g=0;g<h.length;g++){if(h[g]&&b[f[g]]!=null){h[g]=b[h[g]]}}}}};this.b6=function(a){return this.eO(a)?a:this.Ov(a)?Object.keys(a):[]};this.zK=function(a){if(this.eO(a)){return this.Be(a)}else{if(this.Ov(a)){return Object.keys(a)}else{return[a]}}};this.Be=function(b){var g=b.length;var e=[];var f=new Set();for(var d=0;d<g;d++){var c=b[d];if(f.has(c)){continue}f.add(c);e.push(c)}return e};this.pn=function(a){if(this.eO(a)){return this.Be(a)}else{if(this.Ov(a)){return this.Be(this.b6(a))}else{return[a]}}};this.Rd=function(c){var g=c.length;var f={};for(var e=0;e<g;e++){var b=c[e];var d=(f[b]!==undefined&&f[b]!==null)?f[b]:0;f[b]=d+1}return f};this.WF=function(b){for(var d=b.length;d>0;d--){var c=Math.floor(this.Xp()*d);var a=b[--d];b[d]=b[c];b[c]=a}return b};this.gR=function(c){var f=[];var d=this.eO(c);c=this.eG(c);var b=c.length;for(var e=0;e<b;e++){f.push(Number(c[e]))}return d?f:f[0]};this.gc=function(d,c){return d.map(function(b,a){return[d[a],c[a]]})};this.sP=function(b,a){return b.map(function(d,c){return d[a]})};this.E9=function(c,b){if(c==null||typeof(c)!="object"){return b}if(b==null||typeof(b)!="object"){return c}if(Object.assign){return Object.assign({},c,b)}else{for(var a in c){if(c.hasOwnProperty(a)){b[a]=c[a]}}return b}};this.z3=function(a,c){if(a==null||typeof(a)!="object"){a={}}if(c==null||typeof(c)!="object"){return}for(var b in c){a[b]=c[b]}};this.O3=function(c,a){var b=this;if(c==null||typeof(c)!="object"){return c}if(this.eO(c)){return c.map(function(d){return b.eO(d)?d.slice():b.O3(d,a)})}else{if(a){return this.Ov(c)?Object.assign({},c):this.parseJSON(this.dV(c))}else{return this.parseJSON(this.dV(c))}}};this.gg=function(a){return a?JSON.parse(JSON.stringify(a)):false};this.Fe=function(d){var c={bubble:true,gantt:true,sankey:true,tree:true,cola:true,colaConnector:true,stateCX:true,stateIndexCX:true};var a={};for(var b in d){if(c.hasOwnProperty(b)){continue}switch(b){case"data":case"config":a[b]=this.lB(d[b]);break;case"events":a[b]=this.dV(d[b]);break;default:a[b]=this.gg(d[b]);break}}return a};this.lB=function(a,k){var p={bubble:true,gantt:true,sankey:true,tree:true,cola:true,colaConnector:true};if(this.Ov(a)&&a.config&&a.config.decorations&&a.config.decorations.marker){var d=a.config.decorations.marker;var g=d.length;for(var f=0;f<g;f++){if(d[f].text){d[f].text=d[f].text.replace(/\n/g,"__nl__")}}}if(typeof a==="string"){return a.replace(/"/g,"'")}else{if(a&&typeof a=="object"){var j=a.constructor.name;if(j!="Object"&&j!="Array"){return undefined}}else{if(a&&typeof a!=="object"){return a}}}if(!a){return a}if(Object.prototype.toString.apply(a)==="[object Array]"){var c=[];var e=a.length;for(var f=0;f<e;f++){c[f]=this.lB(a[f])}return c}var c={};for(f in a){var b=a[f];if(typeof b=="object"){var h=b&&b.constructor.name;if(b&&h!="Object"&&h!="Array"){delete a[f];continue}}if(k&&p.hasOwnProperty(f)){continue}if((b&&a.hasOwnProperty(f))||b===false||b===0){c[f]=this.lB(b,f=="data")}}return c};this.iT=function(d,c){if(d===c){return true}if(typeof(d)!="object"||typeof(c)!="object"){return false}return JSON.stringify(d)==JSON.stringify(c)};this.tc=function(b,a){if(a){return !isNaN(parseFloat(b))&&isFinite(b)}else{return b===null||b===undefined?true:!isNaN(parseFloat(b))&&isFinite(b)}};this.gR=function(a){if(this.tc(a,true)){return a}else{return Number.NaN}};this.VJ=function(a){var e=a.length;for(var d=0;d<e;d++){var c=a[d].length;for(var b=0;b<c;b++){if(!this.tc(a[d][b])){return false}}}return true};this.Hl=function(a){var c=a.length;for(var b=0;b<c;b++){if(!this.tc(a[b])){return false}}return true};this.ZR=function(a){var c=a.length;for(var b=0;b<c;b++){if(a[b]!=null){return false}}return true};this.ak=function(a){var c=a.length;for(var b=0;b<c;b++){if(a[b]!==""){return false}}return true};this.gZ=function(a){var c=function(e){if(toString.call(e)==="[object Date]"){return true}if(typeof e.replace==="function"){e.replace(/^\s+|\s+$/gm,"")}var g=/(^\d{1,4}?[\.|\\/|-]\d{1,2}?[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/;return g.test(e)};var d=a.length;for(var b=0;b<d;b++){if(a[b]!=null&&!c(a[b])){return false}}return true};this.a2=function(a){var c=a.length;for(var b=0;b<c;b++){if(a[b]!=null&&!CanvasXpress.dates.hasOwnProperty(a[b])){return false}}return true};this.kg=function(a){var b=function(e){return CanvasXpress.countries.hasOwnProperty(e)};var d=a.length;for(var c=0;c<d;c++){if(a[c]!=null&&!b(a[c])){return false}}return true};this.ai=function(a){var b=function(e){return CanvasXpress.usa.hasOwnProperty(e)};var d=a.length;for(var c=0;c<d;c++){if(a[c]!=null&&!b(a[c])){return false}}return true};this.TZ=function(a){var d=this;var c=function(f){return d.DF(f)};var e=a.length;for(var b=0;b<e;b++){if(a[b]!=null&&!c(a[b])){return false}}return true};this.kn=function(b){if(this.data.y&&this.data.y.vars){var a=this.FP(b);if(a>=0){for(var c=0;c<this.data.y.smps.length;c++){if(this.data.y.data[a][c]!=1){return false}}return true}else{return false}}else{return false}};this.N0=function(b,a){if(!a){a=4}b=b+"";return b.length>=a?b:new Array(a-b.length+1).join("0")+b};this.eX=function(){if(this.graphType=="Heatmap"){if(this.meta.tree){return false}else{if(this.varOverlays.length+this.smpOverlays.length>0){return false}else{if(this.isMultidimensionalData){return false}}}return true}};this.iH=function(){var b=this.data.y.vars.length;var c=this.data.x?this.b6(this.data.x):[];var a=c.length;return(this.data.x||b+a==3)?true:false};this.im=function(j,g,l,d){var c={};var f=[];var e=[];var a=j.length;for(var b=0;b<a;b++){if(!c[j[b][g]]){c[j[b][g]]={}}c[j[b][g]][j[b][l]]=j[b][d];if(f.indexOf(j[b][l])==-1){f.push(j[b][l])}}f=this.Aw(f);var k=[];k.push("Vars");k.push.apply(k,f);e.push(k);for(var h in c){k=[];k.push(h);a=f.length;for(var b=0;b<a;b++){k.push(c[h][f[b]]||"")}e.push(k)}return e};this.l4=function(a){return a[0].map(function(b,d){return a.map(function(c){return c[d]})})};this.p4=function(a,c){var d=[];var e=a.length;for(var b=0;b<e;b++){if(this.tc(a[b],c)){d.push(a[b])}}return d};this.Bj=function(b,a,e){var d=[];if(a){var f=this.smpIndices.length;for(var c=0;c<f;c++){d.push(b[this.smpIndices[c]])}d=this.p4(d,true)}else{if(e){var f=this.varIndices.length;for(var c=0;c<f;c++){d.push(b[this.varIndices[c]])}d=this.p4(d,true)}else{d=this.p4(b,true)}}return d};this.mQ=function(j,h,g,e){var d=[];var c=[];if(g){var b=this.smpIndices.length;for(var f=0;f<b;f++){var k=this.p4([j[this.smpIndices[f]],h[this.smpIndices[f]]],true);if(k.length==2){d.push(j[this.smpIndices[f]]);c.push(h[this.smpIndices[f]])}}}else{if(e){var b=this.varIndices.length;for(var f=0;f<b;f++){var k=this.p4([j[this.varIndices[f]],h[this.varIndices[f]]],true);if(k.length==2){d.push(j[this.varIndices[f]]);c.push(h[this.varIndices[f]])}}}else{var b=j.length;for(var f=0;f<b;f++){var k=this.p4([j[f],h[f]],true);if(k.length==2){d.push(j[f]);c.push(h[f])}}}}return[d,c]};this.x6=function(a){tmp=a.reverse();return tmp};this.qj=function(a){return(0.5+a)<<0;return((a+0.5)<<1)>>1};this.tO=function(){return this.isGroupedData&&(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)||this.graphType=="Gantt")};this.wo=function(g){var c=g.split("/");var e=c[0].split(".");var d=["0","0","0","0"];if(!/\d+\.\d+\.\d+\.\d+/.test(c[1])){d=("1".repeat(parseInt(c[1],10))+"0".repeat(32-parseInt(c[1],10))).match(/.{1,8}/g);d=d.map(function(h){return parseInt(h,2)})}else{d=c[1].split(".").map(function(h){return parseInt(h,10)})}var b=d.map(function(h){return h^255});var a=e.map(function(i,h){return i&d[h]});var f=e.map(function(i,h){return i|b[h]});return[a.join("."),f.join(".")]};this.um=function(a){return((a>>>24)+"."+(a>>16&255)+"."+(a>>8&255)+"."+(a&255))};this.Gt=function(a){return a.split(".").reduce(function(c,b){return(c<<8)+parseInt(b,10)},0)>>>0};this.y6=function(b){var d=function(o,q){var p=o[0];var n=o[1];var s=o[2];var r=o[3];p=a(p,n,s,r,q[0],7,-680876936);r=a(r,p,n,s,q[1],12,-389564586);s=a(s,r,p,n,q[2],17,606105819);n=a(n,s,r,p,q[3],22,-1044525330);p=a(p,n,s,r,q[4],7,-176418897);r=a(r,p,n,s,q[5],12,1200080426);s=a(s,r,p,n,q[6],17,-1473231341);n=a(n,s,r,p,q[7],22,-45705983);p=a(p,n,s,r,q[8],7,1770035416);r=a(r,p,n,s,q[9],12,-1958414417);s=a(s,r,p,n,q[10],17,-42063);n=a(n,s,r,p,q[11],22,-1990404162);p=a(p,n,s,r,q[12],7,1804603682);r=a(r,p,n,s,q[13],12,-40341101);s=a(s,r,p,n,q[14],17,-1502002290);n=a(n,s,r,p,q[15],22,1236535329);p=i(p,n,s,r,q[1],5,-165796510);r=i(r,p,n,s,q[6],9,-1069501632);s=i(s,r,p,n,q[11],14,643717713);n=i(n,s,r,p,q[0],20,-373897302);p=i(p,n,s,r,q[5],5,-701558691);r=i(r,p,n,s,q[10],9,38016083);s=i(s,r,p,n,q[15],14,-660478335);n=i(n,s,r,p,q[4],20,-405537848);p=i(p,n,s,r,q[9],5,568446438);r=i(r,p,n,s,q[14],9,-1019803690);s=i(s,r,p,n,q[3],14,-187363961);n=i(n,s,r,p,q[8],20,1163531501);p=i(p,n,s,r,q[13],5,-1444681467);r=i(r,p,n,s,q[2],9,-51403784);s=i(s,r,p,n,q[7],14,1735328473);n=i(n,s,r,p,q[12],20,-1926607734);p=f(p,n,s,r,q[5],4,-378558);r=f(r,p,n,s,q[8],11,-2022574463);s=f(s,r,p,n,q[11],16,1839030562);n=f(n,s,r,p,q[14],23,-35309556);p=f(p,n,s,r,q[1],4,-1530992060);r=f(r,p,n,s,q[4],11,1272893353);s=f(s,r,p,n,q[7],16,-155497632);n=f(n,s,r,p,q[10],23,-1094730640);p=f(p,n,s,r,q[13],4,681279174);r=f(r,p,n,s,q[0],11,-358537222);s=f(s,r,p,n,q[3],16,-722521979);n=f(n,s,r,p,q[6],23,76029189);p=f(p,n,s,r,q[9],4,-640364487);r=f(r,p,n,s,q[12],11,-421815835);s=f(s,r,p,n,q[15],16,530742520);n=f(n,s,r,p,q[2],23,-995338651);p=l(p,n,s,r,q[0],6,-198630844);r=l(r,p,n,s,q[7],10,1126891415);s=l(s,r,p,n,q[14],15,-1416354905);n=l(n,s,r,p,q[5],21,-57434055);p=l(p,n,s,r,q[12],6,1700485571);r=l(r,p,n,s,q[3],10,-1894986606);s=l(s,r,p,n,q[10],15,-1051523);n=l(n,s,r,p,q[1],21,-2054922799);p=l(p,n,s,r,q[8],6,1873313359);r=l(r,p,n,s,q[15],10,-30611744);s=l(s,r,p,n,q[6],15,-1560198380);n=l(n,s,r,p,q[13],21,1309151649);p=l(p,n,s,r,q[4],6,-145523070);r=l(r,p,n,s,q[11],10,-1120210379);s=l(s,r,p,n,q[2],15,718787259);n=l(n,s,r,p,q[9],21,-343485551);o[0]=e(p,o[0]);o[1]=e(n,o[1]);o[2]=e(s,o[2]);o[3]=e(r,o[3])};var k=function(v,p,o,n,u,r){p=e(e(p,v),e(n,r));return e((p<<u)|(p>>>(32-u)),o)};var a=function(p,o,v,u,n,r,q){return k((o&v)|((~o)&u),p,o,n,r,q)};var i=function(p,o,v,u,n,r,q){return k((o&u)|(v&(~u)),p,o,n,r,q)};var f=function(p,o,v,u,n,r,q){return k(o^v^u,p,o,n,r,q)};var l=function(p,o,v,u,n,r,q){return k(v^(o|(~u)),p,o,n,r,q)};var j=function(q){txt="";var t=q.length;var r=[1732584193,-271733879,-1732584194,271733878];var p;for(p=64;p<=q.length;p+=64){d(r,m(q.substring(p-64,p)))}q=q.substring(p-64);var o=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];for(p=0;p<q.length;p++){o[p>>2]|=q.charCodeAt(p)<<((p%4)<<3)}o[p>>2]|=128<<((p%4)<<3);if(p>55){d(r,o);for(p=0;p<16;p++){o[p]=0}}o[14]=t*8;d(r,o);return r};var m=function(o){var p=[];var n;for(n=0;n<64;n+=4){p[n>>2]=o.charCodeAt(n)+(o.charCodeAt(n+1)<<8)+(o.charCodeAt(n+2)<<16)+(o.charCodeAt(n+3)<<24)}return p};var h="0123456789abcdef".split("");var g=function(q){var p="";var o=0;for(;o<4;o++){p+=h[(q>>(o*8+4))&15]+h[(q>>(o*8))&15]}return p};var c=function(n){for(var o=0;o<n.length;o++){n[o]=g(n[o])}return n.join("")};var e=function(o,n){return(o+n)&4294967295};return c(j(this.dV(b)))}};CanvasXpress.prototype.initPlotUtils=function(){this.Ev=function(){var k=this.height;var p=this.width;var f=this.left;var c=this.right;var n=this.bottom;var q=this.top;var i=this.marginLeft;var d=this.marginRight;var o=this.marginBottom;var a=this.marginTop;var m=this.layoutLeft;var j=this.layoutRight;var e=this.layoutBottom;var g=this.layoutTop;this.YN({p:["drawShape","rectangle",(i+this.offsetX)+(this.layoutWidth/2),(a+this.offsetY)+(this.layoutHeight/2),this.layoutWidth,this.layoutHeight,false,"rgba(0,0,0,0.5)","open"],t:"Size"});this.YN({p:["drawShape","rectangle",(i+this.offsetX+f)+(this.x/2),(a+this.offsetY+q)+(this.y/2),this.x,this.y,false,"red","open"],t:"Size"});this.YN({p:["drawShape","rectangle",(i+this.offsetX+f+this.x)+(c/2),(a+this.offsetY+q)+(this.y/2),c,this.y,false,"blue","open"],t:"Size"});this.YN({p:["drawShape","rectangle",(i+this.offsetX)+(f/2),(a+this.offsetY+q)+(this.y/2),f,this.y,false,"blue","open"],t:"Size"});this.YN({p:["drawShape","rectangle",(i+this.offsetX+f)+(this.x/2),(a+this.offsetY)+(q/2),this.x,q,false,"blue","open"],t:"Size"});this.YN({p:["drawShape","rectangle",(i+this.offsetX+f)+(this.x/2),(a+this.offsetY+q+this.y)+(n/2),this.x,n,false,"blue","open"],t:"Size"});return};this.xK=function(a){if(this.graphType!="Network"||a){this.YN({p:["disableGradientTransparencyShadow"],t:"Size"});this.YN({p:["drawShape","rectangle",this.width/2,this.height/2,this.width-2,this.height-2,false,this.plotBackgroundBorderColor,"open"],t:"Size"});this.YN({p:["enableGradientTransparencyShadow"],t:"Size"})}};this.v8=function(){if(this.backgroundType.match(/panel/)){if(this.isDOE&&this.graphType=="Meter"){return}var c=this.graphType.match(/Sankey/)?this.margin*6:0;var a=this.marginLeft+this.offsetX+this.left;var b=this.marginTop+this.offsetY+this.top;var d=this.graphType=="Treemap"&&this.isDOE?"rgba(0,0,0,0)":this.panelBackgroundBorderColor;this.YN({p:["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x-c,this.y,false,d,"open"],t:"Size"})}};this.eI=function(){if(this.backgroundType.match(/panel/)){if(this.isDOE&&this.graphType=="Meter"){return}this.YN({p:["disableGradientTransparencyShadow"],t:"Size"});var c=this.graphType.match(/Sankey/)?this.margin*6:0;var a=this.marginLeft+this.offsetX+this.left;var b=this.marginTop+this.offsetY+this.top;if(!this.layoutValid){this.YN({p:["drawShape","rectangle",this.width*0.5,this.height*0.5,this.width,this.height,this.plotBackgroundColor,this.plotBackgroundBorderColor],t:"Size"})}if(this.backgroundType=="panelSolidGradient"){var d=this.DJ(a,b,this.gradientOrientation=="vertical"?a:b+this.y,this.gradientOrientation=="vertical"?a+this.x:b);this.YN({p:["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x-c,this.y,d,d],t:"Size"})}else{if(this.backgroundType=="panelImage"){this.YN({p:["drawShape","image",a+(this.x/2),b+(this.y/2),this.x-c,this.y,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}else{var f=this.graphType=="Treemap"&&this.isDOE?"rgba(0,0,0,0)":this.panelBackgroundColor;var e=this.graphType=="Treemap"&&this.isDOE?"rgba(0,0,0,0)":this.panelBackgroundBorderColor;this.YN({p:["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x-c,this.y,f,e],t:"Size"})}}this.YN({p:["enableGradientTransparencyShadow"],t:"Size"})}};this.t2=function(){var e="";var b=this.segregateVariablesBy;var d=this.segregateSamplesBy;if(b.length>0){var a=[];for(var c=0;c<b.length;c++){if((this.data.z&&this.data.z.hasOwnProperty(b[c]))||b[c]=="variable"){a.push(b[c])}}b=a}if(d.length>0){var a=[];for(var c=0;c<d.length;c++){if((this.data.x&&this.data.x.hasOwnProperty(d[c]))||d[c]=="sample"){a.push(d[c])}}d=a}if(b.length>0&&d.length>0){if(d.length>1){while(d.length>1){d.pop()}e+="Only one sample segregation when variable segregation is selected\n";e+="segregateSamplesBy was set to: "+d[0]+"\n"}if(b.length>1){while(b.length>1){b.pop()}e+="Only one variable segregation when sample segregation is selected\n";e+="segregateVariblesBy was set to: "+b[0]+"\n"}}else{if(d.length>0){if(d.length>2){while(d.length>2){d.pop()}e+="Maximum of two sample segregations\n";e+="segregateSamplesBy was set to: "+d[0]+","+d[1]+"\n"}}else{if(b.length>0){if(b.length>2){while(b.length>2){b.pop()}e+="Maximum of two variable segregations\n";e+="segregateVariablesBy was set to: "+b[0]+","+b[1]+"\n"}}}}if(e!=""){this.Hu();alert(e);return false}return true};this.i4=function(){if(!this.isDOE){if(this.t2()){if(this.graphType=="Heatmap"){this.layoutType="cols"}if(this.layoutValid&&this.data.l){if(this.segregateSamplesBy.length==0){}else{if(!this.data.l.smps){this.yx(this.segregateSamplesBy,true)}}if(this.segregateVariablesBy.length==0){}else{if(!this.data.l.vars){this.H7(this.segregateVariablesBy,true)}}}else{if(this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0){this.Of()}else{if(this.segregateSamplesBy.length>0){this.yx(this.segregateSamplesBy,true)}else{if(this.segregateVariablesBy.length>0){this.H7(this.segregateVariablesBy,true)}}}}}}};this.Mb=function(){if(this.smpOverlays.length>0){var a=[];for(var c=0;c<this.smpOverlays.length;c++){if(this.smpOverlays[c]=="-"||(this.data.x&&this.data.x.hasOwnProperty(this.smpOverlays[c]))){a.push(this.smpOverlays[c])}else{if(this.FP(this.smpOverlays[c])>=0){this.data.x[this.smpOverlays[c]]=this.data.y.data[this.FP(this.smpOverlays[c])];this.af("x",this.smpOverlays[c]);a.push(this.smpOverlays[c])}}}this.smpOverlays=a}if(this.varOverlays.length>0){var a=[];for(var c=0;c<this.varOverlays.length;c++){if(this.varOverlays[c]=="-"||(this.data.z&&this.data.z.hasOwnProperty(this.varOverlays[c]))){a.push(this.varOverlays[c])}else{if(this.u4(this.varOverlays[c])>=0){var e=[];var d=this.u4(this.varOverlays[c]);for(var b=0;b<this.data.y.vars.length;b++){e.push(this.data.y.data[b][d])}this.data.z[this.varOverlays[c]]=e;this.af("z",this.varOverlays[c]);a.push(this.varOverlays[c])}}}this.varOverlays=a}};this.Nv=function(){if(this.graphType.match(/Dotplot/)){return true}else{if(this.graphType=="Boxplot"&&(this.showBoxplotOriginalData||this.showViolinBoxplot)){return true}else{return false}}};this.E3=function(){return this.colorBy||this.shapeBy||this.sizeBy||this.lineBy||this.patternBy};this.Ry=function(){var a=this;var b=function(){if(a.isTransitionOn){CanvasXpress.transitions[a.target].push([a.isSegregatable]);return true}else{return false}};return !b()&&!this.isDOE&&!CanvasXpress.graphTypes.NonSegregatable.includes(this.graphType)};this.Ek=function(){if(this.graphType.match(/Gantt|Circular|Fish|Meter|Network|Correlation|Genome|Pie|Scatter3D|TagCloud|Venn/)||this.is3DPlot||this.scatterPlotMatrix||this.isContour||this.isOncoprint){return false}return true};this.rK=function(){if(this.decorations.length){var c=this.meta.data.nodes;var a=[];for(var b=0;b<this.decorations.length;b++){if(c.hasOwnProperty(this.decorations[b])){a.push(this.decorations[b])}}this.decorations=a}}};CanvasXpress.prototype.initConfigUtils=function(){this.Jp=function(a){return btoa(encodeURIComponent(a).replace(/%([0-9A-F]{2})/g,function(b,c){return String.fromCharCode("0x"+c)}))};this.WZ=function(a){return decodeURIComponent(Array.prototype.map.call(atob(a),function(b){return"%"+("00"+b.charCodeAt(0).toString(16)).slice(-2)}).join(""))};this.Ng=function(a){return a?a.substring(a.lastIndexOf("/")+1):"canvasXpress"};this.JR=function(){var b=0;var a;this.nn();if(this.title){a=this.title.split(/\n/);b+=(this.margin+this.E1(this.titleFont))*a.length;if(this.subtitle){a=this.subtitle.split(/\n/);b+=(this.margin+this.E1(this.subtitleFont))*a.length}b+=this.margin}return b};this.nn=function(){var a=this.titleAlign.match(/^panel::0/)?this.left:0;this.xx(this.width-a,"titleFont");this.US(this.title,"titleFont",this.width-a);this.xx(this.width-a,"subtitleFont",this.titleFontSize-1);this.US(this.subtitle,"subtitleFont",this.width-a)};this.cH=function(){this.nn();if(this.title){var a=this.title.split(/\n/);var f=this.marginTop+((this.E1(this.titleFont)+this.margin)*a.length);if(this.subtitle){a=this.subtitle.split(/\n/);f+=(this.E1(this.subtitleFont)+this.margin)*a.length}if(this.titleColorBackground){this.YN({p:["drawShape","rectangle",this.width/2,f/2,this.width,f,this.titleColorBackground,this.titleColorBackground],t:"Titles"})}var d=this.vL(this.title,this.titleFont);var c;var g=this.marginTop+(d/2);var b;if(this.titleAlign.match(/^plot/)){b=Number(this.titleAlign.replace(/^plot::/,""));c=this.width*b;this.YN({p:["drawText",this.title,c+1,g,this.titleFont,this.titleColor,b<0.5?"left":b>0.5?"right":"center","middle"],t:"Titles"})}else{if(this.titleAlign.match(/^panel/)){b=Number(this.titleAlign.replace(/^panel::/,""));c=(this.width*b)+this.marginLeft+this.left;this.YN({p:["drawText",this.title,c,g,this.titleFont,this.titleColor,b<0.5?"left":b>0.5?"right":"center","middle"],t:"Titles"})}else{c=this.titleAlign=="left"?this.marginLeft+this.left:this.titleAlign=="right"?this.width-(this.marginRight+this.right):this.width/2;this.YN({p:["drawText",this.title,c,g,this.titleFont,this.titleColor,this.titleAlign=="left"?"left":this.titleAlign=="right"?"right":"center","middle"],t:"Titles"})}}if(this.subtitle){var e=this.vL(this.subtitle,this.subtitleFont);if(this.subtitleAlign.match(/^plot/)){b=Number(this.subtitleAlign.replace(/^plot::/,""));c=this.width*b;this.YN({p:["drawText",this.subtitle,c+1,g+(d/2)+this.margin+(e/2),this.subtitleFont,this.subtitleColor,b<0.5?"left":b>0.5?"right":"center","middle"],t:"Titles"})}else{if(this.subtitleAlign.match(/^panel::/)){b=Number(this.subtitleAlign.replace(/^panel::/,""));c=(this.width*b)+this.marginLeft+this.left;this.YN({p:["drawText",this.subtitle,c,g+(d/2)+this.margin+(e/2),this.subtitleFont,this.subtitleColor,b<0.5?"left":b>0.5?"right":"center","middle"],t:"Titles"})}else{c=this.subtitleAlign=="left"?this.marginLeft+this.left:this.subtitleAlign=="right"?this.width-(this.marginRight+this.right):this.width/2;this.YN({p:["drawText",this.subtitle,c,g+(d/2)+this.margin+(e/2),this.subtitleFont,this.subtitleColor,this.subtitleAlign=="left"?"left":this.subtitleAlign=="right"?"right":"center","middle"],t:"Titles"})}}}}};this.RX=function(){var b=0;var a;this.k4();if(this.citation){a=this.citation.split(/\n/);b+=(this.margin+this.E1(this.citationFont))*a.length;b+=this.margin}return b};this.k4=function(){var b=20*this.printMagnification;this.xx(this.width,"citationFont",b);var a=this.uo(this.citation,this.citationFont);var c=1;while(a>this.width||c>9){b/=2;this.xx(this.width,"citationFont",b);a=this.uo(this.citation,this.citationFont);c++}return};this.TU=function(){if(this.citation){if(this.graphType=="Network"){this.k4()}var b,c;if(this.citationAlign.match(/^plot/)){var a=Number(this.citationAlign.replace(/^plot::/,""));b=this.width*a;c=this.height-this.margin;this.YN({p:["drawText",this.citation,b,c,this.citationFont,this.citationColor,a<0.5?"left":a>0.5?"right":"center","bottom"],t:"Citations"})}else{if(this.citationAlign.match(/^panel/)){var a=Number(this.citationAlign.replace(/^panel::/,""));b=this.marginLeft+this.left+(this.x*a);c=this.height-this.margin;this.YN({p:["drawText",this.citation,b,c,this.citationFont,this.citationColor,a<0.5?"left":a>0.5?"right":"center","bottom"],t:"Citations"})}else{b=this.width-this.margin;c=this.height-this.margin;this.YN({p:["drawText",this.citation,b,c,this.citationFont,this.citationColor,"right","bottom"],t:"Citations"})}}}};this.SK=function(){this.aj();return this.E1(this.font)};this.aj=function(){var b;if(this.autoScaleFont){var c=1-this.percentAspectRatioPlotArea;var a=this.layoutComb?(this.width/this.layoutCols)*c*2.5:this.width*c;var e=this.layoutComb?(this.height/this.layoutRows)*c*2.5:this.height*c;b=Math.min(Math.max(parseInt((Math.max(a,e)/30)*this.fontScaleFontFactor),this.minTextSize),this.maxTextSize)}else{b=Math.min(Math.max(parseInt(this.fontSize*this.fontScaleFontFactor),this.minTextSize),this.maxTextSize)}this.font=this.fontStyle+" "+b+"px "+this.fontName};this.gS=function(b){var g=this.width;var f=["titleFont","subtitleFont","citationFont"];for(var a=0;a<f.length;a++){var c=f[a];this[c+"Skip"]=true;this[c+"Size"]=b;var e=c.replace("Font","ScaleFontFactor");this[c+"Size"]=parseInt(Math.min(Math.max(parseInt(((g/50))*this[e]),this.minTextSize),this.maxTextSize));this[c]=this[c+"Style"]+" "+this[c+"Size"]+"px "+this.fontName}};this.xx=function(i,g,a){if(!i||!g){return}var e=this.isCxplot?10:10;var c={titleFont:e+1,subtitleFont:e+1,citationFont:e-4,legendTextFont:e,legendTitleFont:e,stripTextFont:e,xAxisTextFont:e,xAxisTitleFont:e,yAxisTextFont:e,yAxisTitleFont:e,zAxisTextFont:e,zAxisTitleFont:e,rAxisTextFont:e,rAxisTitleFont:e,smpTextFont:e,smpTitleFont:(this.graphType=="Meter"?e+2:e),varTextFont:e,varTitleFont:e,decorationsTextFont:e,dataTextFont:e-7,overlayTextFont:e,motionCurrentFont:e*5};var b=45;var h=g.replace("Font","ScaleFontFactor");this[g+"Size"]=parseInt(Math.min(Math.max(parseInt(((i/b)+c[g])*this[h]),this.minTextSize),a||this.maxTextSize));this[g]=this[g+"Style"]+" "+this[g+"Size"]+"px "+this.fontName};this.US=function(b,c,g){if(b&&c&&g){var e=this.E1(this[c]);var a=this.uo(b,this[c]);while(a>g&&e>this.minTextSize){e--;this[c]=this[c+"Style"]+" "+e+"px "+this.fontName;a=this.uo(b,this[c])}}};this.bt=function(d){if(this.adjustAspectRatio&&this.graphType!="Genome"){var a=this.meta.config.orig;var e=["ringSeparation","roundedPolygonRadius","margin","marginLeft","marginTop","marginRight","marginBottom","overlaysThickness","dendrogramHeight","heatmapSeparatorThickness","xAxisHistogramHeight","xAxisRugHeight","yAxisHistogramHeight","yAxisRugHeight","dataPointSize","stripThickness"];var f=["legendTextMargin","legendTitleMargin","xAxisTextMargin","xAxisTitleMargin","yAxisTextMargin","yAxisTitleMargin","zAxisTextMargin","zAxisTitleMargin","xAxisTicksLength","yAxisTicksLength","zAxisTicksLength"];for(var b=0;b<f.length;b++){e.push(f[b])}if(this.adjustAspectRatioHeatmapIndicator){e.push("heatmapIndicatorHeight");e.push("heatmapIndicatorWidth")}if(d||this.graphType=="Network"){for(var b=0;b<e.length;b++){if(a[e[b]]){this[e[b]]=a[e[b]];delete (a[e[b]])}}}else{for(var b=0;b<e.length;b++){if(!a[e[b]]){a[e[b]]=this[e[b]]}}for(var b=0;b<e.length;b++){this[e[b]]=Number(Math.max(0.5,Math.min(this.width,this.height)*this[e[b]]/833).toFixed(1))}}}};this.k2=function(){if(this.adjustAspectRatio&&this.graphType!="Genome"){if(this.graphType=="Network"&&!this.isLayoutDone){this.setTimeout(this.resetAspectRatioProperties,50)}else{this.bt(true)}}};this.eb=function(b,e){var h;if(this.isGroupedData){var a=this.data.w.grps[e];if(a){this.isGroupedData=false;h=this.mU(b,a[0],"colorBy");for(var d=1;d<a.length;d++){var f=this.mU(b,a[d],"colorBy");if(f!=h){this.isGroupedData=true;return this.background}}this.isGroupedData=true}else{h=this.mU(b,e,"colorBy")}}else{h=this.mU(b,e,"colorBy")}return h};this.kx=function(a,c){if(this.eO(this.highlightVar)){for(var b=0;b<this.highlightVar.length;b++){if(this.highlightVar[b]==a){return this.varHighlightColor}}}else{if(this.highlightVar==a){return this.varHighlightColor}}return c?this.dendrogramColor:this.varTextColor};this.sH=function(c,b){if(this.eO(this.highlightSmp)){for(var a=0;a<this.highlightSmp.length;a++){if(this.highlightSmp[a]==c){return this.smpHighlightColor}}}else{if(this.highlightSmp==c){return this.smpHighlightColor}}return b?this.dendrogramColor:this.smpTextColor};this.uH=function(e,a,f){if(this.eO(this.highlightNode)){for(var c=0;c<this.highlightNode.length;c++){if(this.highlightNode[c]==e){return this.nodeHighlightColor}}}else{if(this.highlightNode==e){return this.nodeHighlightColor}}var d=this.Fm(e);var b=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!d;return d&&this.selectionMode=="highlight"?this.selectionColor:b&&a?this.a0(a,0.1,true):a?a:f?false:this.nodeColor};this.aI=function(f,d,a){if(this.eO(this.highlightNode)){for(var c=0;c<this.highlightNode.length;c++){if(this.highlightNode[c]==f||this.highlightNode[c]==d){return this.nodeHighlightColor}}}else{if(this.highlightNode==f||this.highlightNode==d){return this.nodeHighlightColor}}var e=this.Fm(f)||this.Fm(d);var b=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!e;return e&&this.selectionMode=="highlight"?this.selectionColor:b?this.a0(a,0.1,true):a?a:this.nodeColor};this.cA=function(a,c){if(a){if(this.colorVarDendrogramBy&&this.data.z&&this.data.z.hasOwnProperty(this.colorVarDendrogramBy)){var b=this.FP(a);if(b>-1){return this.mU(b,false,"colorVarDendrogramBy")}}return this.kx(a,true)}else{if(this.colorSmpDendrogramBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorSmpDendrogramBy)){var b=this.u4(c);if(b>-1){return this.mU(false,b,"colorSmpDendrogramBy")}}return this.sH(c,true)}};this.u6=function(c){var a=this.meta.data;if((!c||c=="v")&&a.z&&this.varOverlays.length>0){for(var b=0;b<this.varOverlays.length;b++){var d=this.varOverlays[b];if(a.z[d].type!="Numeric"){return true}}}if((!c||c=="s")&&a.x&&this.smpOverlays.length>0){for(var b=0;b<this.smpOverlays.length;b++){var d=this.smpOverlays[b];if(a.x[d].type!="Numeric"){return true}}}return false};this.cV=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].unique){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].unique){return true}}}return false};this.zS=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].type=="Numeric"){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].type=="Numeric"){return true}}}return false};this.jT=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].type!="Numeric"){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].type!="Numeric"){return true}}}return false};this.vD=function(g,f){if(this.graphType=="Network"){var d=f?0.5:0.05;var a=Math.min(parseInt(2/g*10)/10,d);var e=[0.5];for(var c=0;c<g-1;c++){e.push(e[c]+a)}return e}else{if(g>this.sizes.length){return this.gg(this.sizes)}else{var e=[];var b=Math.floor(this.sizes.length/g);for(var c=0;c<g;c++){e.push(this.sizes[c*b])}return e}}};this.QL=function(){for(var a in this.binConfigurations){return true}return false};this.dQ=function(){var b=this.$h;var i=b("666163746f7279");var g=b("636c69656e74");var e=b("656e636f6465");var j=b("76616c6964");var k=b("757365724964");var a=b("76657273696f6e");var f=b("68726566");var d=b("736574506978656c496d616765");CanvasXpress[i][g]=this[e]([CanvasXpress[i][j]||0,this[k],CanvasXpress[i][a],this[f]].join("::"));this[d]()};this.Fh=function(k,j){if(!k||k.length==0){return Number.MAX_VALUE}else{var e=0;var f=0;var b=Number.MAX_VALUE;for(var c=0;c<k.length;c++){var g=k[c].area;e+=g;b=(b<g)?b:g;f=(f>g)?f:g}var d=j*j;var h=e*e;return Math.max(d*f/h,h/(d*b))}};this.Gl=function(f,e){if(f){var c=this.treemapBorderWidth&&!this.isDOE?1:0;var a=this.treemapBorderWidth;var b=a*2;var d=this.smpTextFontSize*c;e.left+=a;if(e.height>d+b){e.top+=d+a;e.height-=(d+b);e.border=2}else{if(e.height>b){e.top+=a;e.height-=b;e.border=1}else{if(e.height>a){e.height-=a;e.border=0}else{e.border=-1}}}e.width-=b}};this.CV=function(k,h,g,f){var c=0;for(var b=0;b<k.length;b++){c+=k[b].area}var a=c/h;var e=0;for(var b=0;b<k.length;b++){var j=k[b].area/a;k[b].coords={width:a,height:j,left:g.left,top:g.top+e};this.Gl(f,k[b].coords);e+=j}var d={width:g.width-a,height:g.height,left:g.left+a,top:g.top};d.orientation=Math.min(d.width,d.height);if(d.orientation!=d.height){this.treemapOrientation=this.treemapOrientation=="horizontal"?"vertical":"horizontal"}return d};this.nG=function(l,j,h,g){var d=0;for(var c=0;c<l.length;c++){d+=l[c].area}var k=d/j;var f=h.top;var b=0;for(var c=0;c<l.length;c++){var a=l[c].area/k;l[c].coords={width:a,height:k,left:h.left+b,top:f};this.Gl(g,l[c].coords);b+=a}var e={width:h.width,height:h.height-k,left:h.left,top:h.top+k};e.orientation=Math.min(e.width,e.height);if(e.orientation!=e.width){this.treemapOrientation=this.treemapOrientation=="horizontal"?"vertical":"horizontal"}return e};this.SO=function(a,b,c,d){if(this.treemapOrientation=="horizontal"){return this.CV(a,b,c,d)}else{return this.nG(a,b,c,d)}};this.C1=function(a,c,b,f,h){if(a.length+c.length==1){var e=(a.length==1)?a:c;e[0].coords=f;this.Gl(h,e[0].coords);return}if(a.length>=2&&c.length==0){c=[a.shift()]}if(a.length==0){if(c.length>0){this.SO(c,b,f,h)}return}var d=a[0];if(this.Fh(c,b)>=this.Fh([d].concat(c),b)){this.C1(a.slice(1),c.concat([d]),b,f,d.title)}else{var g=this.SO(c,b,f,h);this.C1(a,[],g.orientation,g,d.title)}};this.zM=function(a,g){var f=g.width*g.height;var e=0;var b=[];for(var d=0;d<a.length;d++){b[d]=parseFloat(a[d].area);e+=b[d]}for(var d=0;d<b.length;d++){a[d].area=f*b[d]/e}var c=this.treemapOrientation=="horizontal"?g.height:g.width;a.sort(function(i,h){return h.area-i.area});this.C1(a.slice(1),[a[0]],c,g,a[0].title)};this.JN=function(b,d){if(!this.treemapOrientation){this.treemapOrientation="horizontal"}if(d.width>=d.height){this.treemapOrientation="horizontal"}else{this.treemapOrientation="vertical"}if(b.length){this.zM(b,d);for(var c=0;c<b.length;c++){var a=b[c].children?b[c].children:b[c];var d={width:b[c].coords.width,height:b[c].coords.height,left:b[c].coords.left,top:b[c].coords.top};this.JN(a,d)}}return b};this.xw=function(a){if(this.tagCloudGridPoints[a]){return this.tagCloudGridPoints[a]}var b=a*8;var c=b;var d=[];if(a==0){d.push([this.tagCloudGridCenter[0],this.tagCloudGridCenter[1],0])}while(c--){var e=1;if(this.tagCloudShapeFunction!=="circle"){e=this.tagCloudShapeFunction(c/b*2*Math.PI)}d.push([this.tagCloudGridCenter[0]+a*e*Math.cos(-c/b*2*Math.PI),this.tagCloudGridCenter[1]+a*e*Math.sin(-c/b*2*Math.PI)*this.tagCloudTextEllipticity,c/b*2*Math.PI])}this.tagCloudGridPoints[a]=d;return d};this.ii=function(){if(this.tagCloudTextRotateRatio==0){return 0}if(this.Xp()>this.tagCloudTextRotateRatio){return 0}return(-Math.PI/2)+(this.Xp()*Math.PI)};this.va=function(z,n,o){var a=Math.min(500,Math.floor(this.tagCloudTextWeightFactor*n));var s=this.$cX("canvas");var A=s.getContext("2d",{willReadFrequently:true});var p=a+"px "+this.fontName;A.font=p;var b=this.uo(z,p);var m=a;var i=b+m*2;var g=m*3;var B=Math.ceil(i/this.tagCloudTextGridSize);var c=Math.ceil(g/this.tagCloudTextGridSize);i=B*this.tagCloudTextGridSize;g=c*this.tagCloudTextGridSize;var t=-b*0.5;var q=-m*0.5;var u=Math.ceil((i*Math.abs(Math.sin(o))+g*Math.abs(Math.cos(o)))/this.tagCloudTextGridSize);var d=Math.ceil((i*Math.abs(Math.cos(o))+g*Math.abs(Math.sin(o)))/this.tagCloudTextGridSize);var v=d*this.tagCloudTextGridSize;var r=u*this.tagCloudTextGridSize;if(v<1||r<1){return{occupied:[],bounds:[0,0,0,0],gw:d,gh:u,fillTextOffsetX:t,fillTextOffsetY:q,fillTextWidth:b,fillTextHeight:m,fontSize:a}}s.setAttribute("width",v);s.setAttribute("height",r);A.save();A.translate(v/2,r/2);A.rotate(-o);A.font=a+"px "+this.fontName;A.fillStyle="#000";A.textBaseline="middle";A.fillText(z,t,q+a*0.5);A.restore();var w=A.getImageData(0,0,v,r).data;var f=[];var l=d,k,j,h;var e=[u/2,d/2,u/2,d/2];while(l--){k=u;while(k--){h=this.tagCloudTextGridSize;singleGridLoop:{while(h--){j=this.tagCloudTextGridSize;while(j--){if(w[((k*this.tagCloudTextGridSize+h)*v+(l*this.tagCloudTextGridSize+j))*4+3]){f.push([l,k]);if(l<e[3]){e[3]=l}if(l>e[1]){e[1]=l}if(k<e[0]){e[0]=k}if(k>e[2]){e[2]=k}break singleGridLoop}}}}}}return{occupied:f,bounds:e,gw:d,gh:u,fillTextOffsetX:t,fillTextOffsetY:q,fillTextWidth:b,fillTextHeight:m,fontSize:a}};this.TM=function(g,f,h,b,a){var e=a.length;while(e--){var d=g+a[e][0];var c=f+a[e][1];if(d>=this.tagCloudGridWidth||c>=this.tagCloudGridHeight||d<0||c<0||!this.tagCloudGrid[d][c]){return false}}return true};this.fS=function(a,b){if(a>=this.tagCloudGridWidth||b>=this.tagCloudGridHeight||a<0||b<0){return}this.tagCloudGrid[a][b]=false};this.HI=function(e,c,d){var a=d.occupied;var b=a.length;while(b--){this.fS(e+a[b][0],c+a[b][1])}};this.sB=function(c,i,g,d){var k=this;var m=this.ii();var e=this.va(c,i,m);if(!e){return false}var b=e.bounds;if((b[1]-b[3]+1)>this.tagCloudGridWidth||(b[2]-b[0]+1)>this.tagCloudGridHeight){return false}var a=this.tagCloudGridMaxRadius+1;var j=this.a0(g,0,true);var f=this.GM();var p=this.DT();while(a--){var n=this.xw(this.tagCloudGridMaxRadius-a);n=[].concat(n);this.WF(n);var h=n.some(function o(q){var w=Math.floor(q[0]-e.gw/2);var v=Math.floor(q[1]-e.gh/2);var z=e.gw;var s=e.gh;var r=e.fontSize+"px "+k.fontName;var l="1px "+k.fontName;if(!k.TM(w,v,z,s,e.occupied)){return false}var u=((w+e.gw/2)*k.tagCloudTextGridSize);var t=((v+e.gh/2)*k.tagCloudTextGridSize);k.renderTagCloud.push([["drawText",c,u+f,t+p,r,g,"center","middle",-m],d,false,null,false,[k.width/2,k.height/2,l,j,-Math.PI*2]]);k.HI(w,v,e);return true});if(h){return true}}return false};this.UK=function(b){this.tagCloudTextGridSize=Math.max(this.tagCloudTextGridSize,4);this.tagCloudGridWidth=Math.floor(this.x/this.tagCloudTextGridSize);this.tagCloudGridHeight=Math.floor(this.y/this.tagCloudTextGridSize);this.tagCloudGridCenter=[this.tagCloudGridWidth/2,this.tagCloudGridHeight/2];this.tagCloudGridMaxRadius=Math.floor(Math.sqrt(this.tagCloudGridWidth*this.tagCloudGridWidth+this.tagCloudGridHeight*this.tagCloudGridHeight));this.tagCloudGridPoints=[];if(!b){this.t3()}else{this.tagCloudTextWeightFactor*=b}this.tagCloudGrid=[];var c=this.tagCloudGridWidth;var a;while(c--){this.tagCloudGrid[c]=[];a=this.tagCloudGridHeight;while(a--){this.tagCloudGrid[c][a]=true}}};this.t3=function(){var h=0;var b=0;var k=this.varIndices[0];for(var g=0;g<this.smpIndices.length;g++){var f=this.smpIndices[g];var j=this.VY(k,f);var e=this.data.y.smps[f].length;var c=e*j*0.5*j;b=Math.max(c,b);h+=c}if(!this.tagCloudTries){this.tagCloudTries=1}b=parseInt(Math.max(this.x,this.y));if(h>b){this.tagCloudTextWeightFactor=(this.x*this.y)/(h*this.tagCloudTries)}else{this.tagCloudTextWeightFactor=(this.x*this.y)/(h*this.tagCloudTries*(b/h))}this.tagCloudTries+=1};this.v1=function(g){var e=this.randomSeed;this.renderTagCloud=[];this.UK(g);var j=this.varIndices[0];for(var b=0;b<this.smpIndices.length;b++){var a=this.smpIndices[b];var h=this.VY(j,a);var k=this.colorBy?this.mU(j,a,"colorBy"):this.foreground;if(!this.sB(this.data.y.smps[a],h,k,[j,a])){this.hY();this.renderTagCloud=[];if(this.pseudoRandom){this.randomSeed=e}this.v1(0.9);break}}if(this.pseudoRandom){this.randomSeed=e}};this.BY=function(a){for(var b=0;b<this.data.y.vars.length;b++){if(this.data.y.vars[b]==a){return this.colors[b%this.colors.length]}}return this.colors[0]};this.fE=function(b,a,g){var i;if((this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)||(this.plotStyle=="open"&&!g)){i=this.ZM(b,true)}else{if(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)){var d=this.layoutValid?this.data.y.vars.length*this.data.y.smps.length:this.varIndices.length*this.smpIndices.length;if(d>this.dotplotOutlineThreshold){i=this.graphType=="Boxplot"&&!this.showViolinBoxplot?this.boxplotBorderColor:this.objectBorderColor}else{i=this.graphType=="Boxplot"&&!this.showViolinBoxplot?this.boxplotBorderColor:this.objectBorderColor?this.objectBorderColor:this.ZM(b,true)}}else{i=this.objectBorderColor&&this.graphType!="Map"?this.objectBorderColor:this.ZM(b,true)}}if(a){var f=this.Fm(a);var e=this.UT(a[0]);var d=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!f;i=e?this.varHighlightColor:f&&this.selectionMode=="highlight"?this.selectionColor:d?this.a0(i,0.1,true):i}return i};this.Fg=function(b,a,g){var i=(this.plotStyle=="open"&&!g)&&(!this.isDOE||!this.layoutCurrent);var j=this.a0(b,(i?0:this.objectColorTransparency),true);if(a){var f=this.Fm(a);var e=this.UT(a[0]);var d=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!f;j=e?this.varHighlightColor:f&&this.selectionMode=="highlight"?this.selectionColor:d?this.a0(j,0.1,true):j;if(this.transparency!=null){j=this.a0(this.ZM(j,true),this.transparency,true)}}return j};this.UT=function(a){if(this.highlightVar.length&&a!=null){var b=this.data.y.vars[a];return this.highlightVar.includes(b)}};this.Pc=function(){var a=this.meta.def.colorBrew;return{rmin:a.rmin,rmax:a.rmax,min:a.min,max:a.max,decs:a.decs,vals:a.vals,maxLevLen:a.maxLevLen,maxLevChr:a.maxLevChr,maxLevStr:a.maxLevStr,colorBrew:a}};this.SY=function(){delete (this.cacheColors)};this.wi=function(){if(!this.cacheColors){this.cacheColors={}}if(!this.cacheColors[this.colorScheme]){this.cacheColors[this.colorScheme]={}}};this.iN=function(n,q,m){this.wi();var e={no:0,idso:[],ids:[],cols:[],data:{},raw:{},oprc:0,tot:this.IK(n)};var b=this.P8(n.length);for(var l=0;l<n.length;l++){var h=this.graphType=="Network"||this.isDOE||this.data.y.pie?l:q?this.varIndices[l]:l;var a=n[h]/e.tot;var g=this.graphType=="Network"?l:this.isDOE?this.data.l.data[this.layoutCurrent].y.vars[l]:this.data.y.pie?this.data.y.pie.y.vars[l]:q?this.data.y.vars[h]:l;var o;if(m&&m[l%m.length]){o=m[l%m.length]}else{if(this.cacheColors[this.colorScheme].hasOwnProperty(g)){o=this.cacheColors[this.colorScheme][g]}else{o=this.pieColors[l]||b[l%b.length];this.cacheColors[this.colorScheme][g]=o}}if(this.tc(a,true)){e.data[h]=a;e.raw[h]=n[h];if(l>=this.maxPieSectors-1){e.oprc+=a;e.idso.push(h);e.no++}else{e.ids.push(h)}e.cols.push(o)}}if(e.no){e.ids.push(-1)}return e};this.hi=function(u,h,g,t,I,w){var f=this;var q=function(){for(var a=0;a<u.ids.length;a++){if(u.data[u.ids[a]]&&u.data[u.ids[a]]>-1&&!f.tc(u.data[u.ids[a]],true)){return false}}return true};if(q()){var z,d;var m=this.startPieSectors!=null?(this.startPieSectors*Math.PI/180)%360:0;var A=this.pieSegmentLabels=="inside"?t-(t/3):t+(t/6);var G=0;var C=this.layoutComb?this.smpIndices[0]:this.xAxisIndices?this.xAxisIndices[0]:0;for(var E=0;E<u.ids.length;E++){var k=u.ids[E];var v=k>-1?u.data[k]:u.oprc;var o=this.graphType=="Network"||this.graphType!="Pie"?I[E]:k>-1?[k,C]:u.idso;var e=this.graphType=="Map"?u.cols[E]:this.Fg(u.cols[E],o,this.isDOE);var D=this.fE(e,this.graphType=="Map"?E:o);z=d!=null?parseFloat(d):parseFloat((Math.PI*(2*G))+m);d=parseFloat(z+(Math.PI*(2*(v))));var H=(z+d)/2;var B=(d-z)/32;var J=this.graphType=="Network"||this.graphType=="Map"?"Decorations":this.graphType!="Pie"?"Overlays":"Data";var D=this.pieType=="separated"?this.background:this.fE(e);if(this.graphType=="Network"||this.graphType=="Map"){this.YN({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],i:(this.graphType=="Map"?I[0]:I[E]),m:w,t:J,h:this.Cs(this.graphType=="Map"?I[0][0]:I[E])})}else{if(this.graphType!="Pie"){this.YN({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],i:I[E],t:J})}else{if(k>-1){I=this.isDOE?[k,C,"Facet-"+this.layoutCurrent]:[k,C];this.YN({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],i:I,t:J,h:this.Cs(I[0])})}else{this.YN({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],i:u.idso,t:J})}}}var F=u.ids.length>1?h-Math.sin(H-(Math.PI/2))*A:h;var b=u.ids.length>1?g+Math.cos(H-(Math.PI/2))*A:g;if(this.graphType!="Network"&&this.graphType!="Map"&&this.showPieValues&&(d-z)>0.05){if(this.pieLabelType=="value"){this.YN({p:["drawText",u.raw[k],F,b,this.xAxisTextFont,this.xAxisTextColor,"center","middle"],t:J})}else{this.YN({p:["drawText",this.KZ("%."+this.pieSegmentPrecision+"f",v*100)+"%",F,b,this.xAxisTextFont,this.xAxisTextColor,"center","middle"],t:J})}}G+=v}G=0;d=null;if(u.ids.length>1&&this.graphType!="Map"){for(var E=0;E<u.ids.length;E++){var k=u.ids[E];var v=k>-1?u.data[k]:u.oprc;var e=this.Fg(u.cols[E]);z=d!=null?parseFloat(d):parseFloat((Math.PI*(2*G))+m);d=parseFloat(z+(Math.PI*(2*(v))));var D=this.pieType=="separated"?this.background:this.fE(e);this.YN({p:["drawShape","pie",h,g,(t*2),t,false,D,"open",false,this.pieSegmentSeparation,false,false,z,d],s:true,t:J});G+=v}}if(this.pieInnerRadius>0&&this.pieInnerRadius<1&&this.graphType!="Map"){this.YN({p:["drawShape","circle",h,g,t*this.pieInnerRadius*2,t*this.pieInnerRadius*2,this.background,this.background,"closed"],t:J})}}};this.KU=function(ai,ah,Z,R,O,U,Q,L,Y,W,al,V,ap,X,af,ab,N,ao){var P,M,ag,T;var K=this;var j=function(a){return K.isGroupedData?N.smps[K.data.w.smps[K.grpIndices[a]]]:N.smps[K.data.y.smps[K.smpIndices[a]]]};var S=this.variableSpace/2;var ae=O/2;var ad=ao?"Overlays":this.graphType=="Network"?"Decorations":"Data";var am=0.0675;var H=am;if(W=="vertical"||this.graphType=="Network"){for(var ac=0;ac<ai.length;ac++){P=((ai[ac]-Y)*Q)-L;var aj;var aa=(N&&N.cap&&N.cap[j(ac)])||this.barType=="arrow"?"arrow":this.useRoundRectangles&&P>0?"roundrectt":this.useRoundRectangles?"roundrectb":"rectangle";var A=this.Fg(N?N.fill[j(ac)]:al[ac],ap[ac]);var an=O-this.variableSpace>5?this.fE(A,ap[ac]):A;var J=this.Cs(ap[ac][0],ap[ac][1]);if(this.tc(P,true)&&H>=am){if(this.barPath){var B=this.a0(this.barPathColor||A,this.barPathTransparency);this.YN({p:["drawShape","rectangle",(Z+S)+((O-this.variableSpace)/2),L+(this.y/2),O-this.variableSpace,this.y*2,B,B],t:"Decorations"})}if(P<0){aj=this.YN({p:["drawShape",aa,(Z+S)+((O-this.variableSpace)/2),R+(-P/2),O-this.variableSpace,-P,A,an,V[ac],false,false,af],i:ap[ac],m:X,t:ad,h:J})}else{aj=this.YN({p:["drawShape",aa,(Z+S)+((O-this.variableSpace)/2),R-(P/2),O-this.variableSpace,P,A,an,V[ac],false,false,af],i:ap[ac],m:X,t:ad,h:J})}ag=R-P;T=Z+ae;if(ah[ac]&&this.tc(ah[ac],true)){M=(ah[ac]/2)*Q;this.YN({p:["drawLine","error",T,ag,T,ag-M,this.errorBarsColor,-ae,"butt"],g:aj,t:ad,h:J});this.YN({p:["drawLine","error",T,ag,T,ag+M,this.errorBarsColor,-ae,"butt"],g:aj,t:ad,h:J})}if(N){var I=j(ac);for(var ak in N){if(ak!="cap"&&ak!="high"&&ak!="color"&&ak!="fill"){if(N[ak][I]){for(var F=0;F<N[ak][I].length;F++){var E=((N[ak][I][F][0]-Y)*Q)-L;var G=((N[ak][I][F][1]-Y)*Q)-L;var D=(Z+S)+((O-this.variableSpace)/2);this.YN({p:["drawShape",this.shapes[0],D,R-E,O/2,O/2,N.color[ak],N.color[ak]],g:aj,t:ad,h:J});if(!this.tc(G,true)){G=P-this.margin}else{this.YN({p:["drawShape",this.shapes[1],D,R-G,O/2,O/2,N.color[ak],N.color[ak]],g:aj,t:ad,h:J})}this.YN({p:["drawLine","line",D,R-E,D,R-G,N.color[ak],this.margin],g:aj,t:ad,h:J})}}}}}if(this.showDataValues&&this.barType!="lollipop"){this.YN({p:["drawText",this.qY(ai[ac]),T,R-(P+(this.margin/4)),this.smpTextFont,A,"center","bottom"],g:aj,t:ad,h:J})}H=0}Z+=this.eO(U)?U[ac+1]-U[ac]:U;H+=this.eO(U)?U[ac+1]-U[ac]:U}}else{for(var ac=0;ac<ai.length;ac++){P=((ai[ac]-Y)*Q)-L;var aj;var aa=(N&&N.cap&&N.cap[j(ac)])||this.barType=="arrow"?"arrow":!this.useRoundRectangles?"rectangle":ab||P<0?"roundrectl":"roundrectr";var A=this.Fg(N?N.fill[j(ac)]:al[ac],ap[ac]);var an=O-this.variableSpace>5?this.fE(A,ap[ac]):A;var J=this.Cs(ap[ac][0],ap[ac][1]);if(this.tc(P,true)&&H>=am){if(this.barPath){var B=this.a0(this.barPathColor||A,this.barPathTransparency);this.YN({p:["drawShape","rectangle",L+(this.x/2),(R+S)+((O-this.variableSpace)/2),this.x*4,O-this.variableSpace,B,B],t:"Decorations"})}if(P<0){if(ab){aj=this.YN({p:["drawShape",aa,((Z+ab)-L)+(P/2),(R+S)+((O-this.variableSpace)/2),-P,O-this.variableSpace,A,an,V[ac],aa=="arrow"?true:false,false,af],i:ap[ac],m:X,t:ad,h:J})}else{aj=this.YN({p:["drawShape",aa,(Z+P)+(-P/2),(R+S)+((O-this.variableSpace)/2),-P,O-this.variableSpace,A,an,V[ac],aa=="arrow"?true:false,false,af],i:ap[ac],m:X,t:ad,h:J})}}else{if(ab){aj=this.YN({p:["drawShape",aa,((Z+ab)-L)-(P/2),(R+S)+((O-this.variableSpace)/2),P,O-this.variableSpace,A,an,V[ac],aa=="arrow"?true:false,false,af],i:ap[ac],m:X,t:ad,h:J})}else{aj=this.YN({p:["drawShape",aa,Z+(P/2),(R+S)+((O-this.variableSpace)/2),P,O-this.variableSpace,A,an,V[ac],aa=="arrow"?true:false,false,af],i:ap[ac],m:X,t:ad,h:J})}}ag=ab?(Z+ab)-(P+L):Z+P;T=R+ae;if(ah[ac]&&this.tc(ah[ac],true)){M=(ah[ac]/2)*Q;this.YN({p:["drawLine","error",ag,T,ag+M,T,this.errorBarsColor,ae,"butt"],g:aj,t:ad,h:J});this.YN({p:["drawLine","error",ag,T,ag-M,T,this.errorBarsColor,ae,"butt"],g:aj,t:ad,h:J})}if(N){var I=j(ac);for(var ak in N){if(ak!="cap"&&ak!="high"&&ak!="color"&&ak!="fill"){if(N[ak][I]){for(var F=0;F<N[ak][I].length;F++){var E=((N[ak][I][F][0]-Y)*Q)-L;var G=((N[ak][I][F][1]-Y)*Q)-L;var C=(R+S)+((O-this.variableSpace)/2);this.YN({p:["drawShape",this.shapes[0],Z+E,C,O/2,O/2,N.color[ak],N.color[ak]],g:aj,t:ad,h:J});if(!this.tc(G,true)){G=P-this.margin}else{this.YN({p:["drawShape",this.shapes[1],Z+G,C,O/2,O/2,N.color[ak],N.color[ak]],g:aj,t:ad,h:J})}this.YN({p:["drawLine","line",Z+E,C,Z+G,C,N.color[ak],this.margin],g:aj,t:ad,h:J})}}}}}if(this.showDataValues&&this.barType!="lollipop"){this.YN({p:["drawText",this.qY(ai[ac]),ag+(this.margin/4),T,this.smpTextFont,al[ac],"left","middle"],g:aj,t:ad,h:J})}H=0}R+=this.eO(U)?U[ac+1]-U[ac]:U;H+=this.eO(U)?U[ac+1]-U[ac]:U}}};this.SP=function(aj,ai,aa,T,R,af,S,Z,X,al,V,U,ao,ah,ag,ab,I,an,y){var O=this;var M=function(){var b=[[],[]];if(X=="vertical"){for(var a=0;a<r[0].length;a++){b[0].push(r[0][a]);b[1].push(r[1][a][0])}for(var a=r[0].length-1;a>=0;a--){b[0].push(r[0][a]);b[1].push(r[1][a][1])}}else{for(var a=0;a<r[1].length;a++){b[0].push(r[0][a][0]);b[1].push(r[1][a])}for(var a=r[1].length-1;a>=0;a--){b[0].push(r[0][a][1]);b[1].push(r[1][a])}}return b};var v=function(aM,aL,aC,ax,au,aH,aw,aB,aA,aN,az,ay,aO,aK,aJ,aD,av,b,aF){var z=0;var at=aF[0].xy;var aI=[];var n=[];var p=[];var ar=[];var aG=[];for(var aE=0;aE<aF.length;aE++){if(aF[aE].split!=z){O.SP(aI,n,(aA=="vertical"?at:aC),(aA=="vertical"?ax:at),au,p,aw,aB,aA,aN,ar,ay,aG,aK,aJ,aD,av,b);z=aF[aE].split;at=aF[aE].xy;aI=[aM[aE]];n=[aL[aE]||null];p=[aH[aE]||at];ar=[az[aE]];aG=[aO[aE]]}else{aI.push(aM[aE]);n.push(aL[aE]||null);p.push(aH[aE]||aF[aE].xy);ar.push(az[aE]);aG.push(aO[aE])}}O.SP(aI,n,(aA=="vertical"&&O.graphType!="ParallelCoordinates"?at:aC),(aA=="vertical"?ax:at),au,p,aw,aB,aA,aN,ar,ay,aG,aK,aJ,aD,av,b)};var W,C,B,A,j,aq,ap,ak,N,D,L;var Q=null;var F=null;var K=R/2;var J=this.dataPointSize*0.5;var am=V=="open"?al:this.objectBorderColor||al;var Y=aj.length-1;var P=[[],[]];var r=[[],[]];var ac=[];var E=this.FP(I);var ae=an?"Overlays":"Data";var G=this.lineThickness;if(y){return v(aj,ai,aa,T,R,af,S,Z,X,al,V,U,ao,ah,ag,ab,I,an,y)}else{if(X=="vertical"){C=aa;B=aa+(this.eO(af)?af[1]-af[0]:af);if(Q==null){Q=C}if(this.Fm([E])){al=this.varHighlightColor;G+=2}for(var ad=1;ad<aj.length;ad++){W=ad-1;if(this.Ov(S)){j=T-((aj[W]-S[W].min)*S[W].units);aq=T-((aj[ad]-S[ad].min)*S[ad].units)}else{j=T-((aj[W]-Z)*S);aq=T-((aj[ad]-Z)*S)}if(F==null){F=j}L=this.lineBy?this.Cs(false,false,"Property:"+this.lineBy+":"+ao[W][2]+":x"):false;if(this.tc(j,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&U){ak=this.YN({p:["drawShape",U,C,j,J,J,al,am,V[W],false,false,ag],i:ao[W],m:ah,g:N,b:[Q,F],t:ae,h:this.lineBy?L:this.Cs(ao[W][0],ao[W][1])})}else{ak=this.YN({p:["drawShape","sphere",C,j,J,J,this.a0(al,0,true),"rgba(0,0,0,0)",V[W],false,false,ag],i:ao[W],m:ah,g:N,b:[Q,F],t:ae,h:this.lineBy?L:this.Cs(ao[W][0],ao[W][1])})}if(this.showDataValues){this.YN({p:["drawText",this.qY(aj[W]),C,j-this.margin,this.smpTextFont,this.smpTextColor,"center","bottom"],t:ae,h:this.lineBy?L:this.Cs(ao[W][0],ao[W][1])})}if(!N){N=ak}if(this.tc(ai[W],true)){ap=(ai[W]/2)*this.Ov(S)?S[W].units:S;if(this.lineErrorType=="bar"){this.YN({p:["drawLine","error",C,j,C,j+ap,al,-K,"butt"],i:["Line:"+I+":"+E],g:N,b:[Q,F],t:ae,h:this.lineBy?L:this.Cs(E)});this.YN({p:["drawLine","error",C,j,C,j-ap,al,-K,"butt"],i:["Line:"+I+":"+E],g:N,b:[Q,F],t:ae,h:this.lineBy?L:this.Cs(E)})}else{r[0].push([C,C]);r[1].push([j+ap,j-ap]);ac.push([C,j])}}if(this.lineType=="spline"){P[0].push(C);P[1].push(j)}}if((this.lineType!="spline"&&this.tc(j,true)&&this.tc(aq,true))||aj.length<3){ak=this.YN({p:["drawLine",this.lineDecoration=="pattern"||this.patternBy?(V[W]||"solid"):this.lineType,C,j,B,aq,al,G,"butt",false,false,ag],i:["Line:"+I+":"+E],g:N,b:[Q,F],t:ae,h:this.lineBy?L:this.Cs(E)})}else{if(this.lineType=="spline"&&!this.tc(aq,true)){ak=this.YN({p:["drawLine","spline",P[0],P[1],false,false,al,G,false,false,false,ag],i:["Line:"+I+":"+E],g:N,b:[Q,F],t:ae,h:this.lineBy?L:this.Cs(E)});P=[[],[]];Q=null;F=null}}if(!N){N=ak}if(r[0].length>0&&!this.tc(aq,true)){var x=this.a0(al,0.3,true);if(this.lineType=="spline"){this.YN({p:["drawShape","confidence",r[0],r[1],false,false,x,x,"closed"],i:["Line-Error:"+I+":"+E],b:ac,t:ae,h:this.lineBy?L:this.Cs(E)})}else{var H=M();this.YN({p:["drawShape","path",H[0],H[1],false,false,x,x,"closed"],i:["Line-Error:"+I+":"+E],b:ac,t:ae,h:this.lineBy?L:this.Cs(E)})}r=[[],[]];ac=[]}C=B;B+=(this.eO(af)?af[ad+1]-af[ad]:af)}L=this.lineBy?this.Cs(false,false,"Property:"+this.lineBy+":"+ao[Y][2]+":x"):false;if(this.tc(aq,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&U){ak=this.YN({p:["drawShape",U,C,aq,J,J,al,am,V[Y],false,false,ag],i:ao[Y],m:ah,g:N,b:[Q,F],t:ae,h:this.lineBy?L:this.Cs(ao[Y][0],ao[Y][1])})}else{ak=this.YN({p:["drawShape","sphere",C,aq,J,J,this.a0(al,0,true),"rgba(0,0,0,0)",V[Y],false,false,ag],i:ao[Y],m:ah,g:N,b:[Q,F],t:ae,h:this.lineBy?L:this.Cs(ao[Y][0],ao[Y][1])})}if(this.showDataValues){this.YN({p:["drawText",this.qY(aj[Y]),C,aq-this.margin,this.smpTextFont,this.smpTextColor,"center","bottom"],t:ae,h:this.lineBy?L:this.Cs(ao[Y][0],ao[Y][1])})}if(!N){N=ak}if(this.tc(ai[Y],true)){ap=(ai[Y]/2)*this.Ov(S)?S[Y].units:S;if(this.lineErrorType=="bar"){this.YN({p:["drawLine","error",C,aq,C,aq+ap,al,-K,"butt"],i:["Line:"+I+":"+E],g:N,t:ae,h:this.lineBy?L:this.Cs(E)});this.YN({p:["drawLine","error",C,aq,C,aq-ap,al,-K,"butt"],i:["Line:"+I+":"+E],g:N,t:ae,h:this.lineBy?L:this.Cs(E)})}else{if(ad==aj.length){r[0].push([C,C]);r[1].push([aq+ap,aq-ap]);ac.push([C,aq])}}}if(this.lineType=="spline"){P[0].push(C);P[1].push(aq)}}if(this.lineType=="spline"){ak=this.YN({p:["drawLine","spline",P[0],P[1],false,false,al,G,false,false,false,ag],i:["Line:"+I+":"+E],b:[Q,F],t:ae,h:this.lineBy?L:this.Cs(E)})}if(!N){N=ak}if(r[0].length>0){var x=this.a0(al,0.3,true);if(this.lineType=="spline"){this.YN({p:["drawShape","confidence",r[0],r[1],false,false,x,x,"closed"],i:["Line-Error:"+I+":"+E],b:ac,t:ae,h:this.lineBy?L:this.Cs(E)})}else{var H=M();this.YN({p:["drawShape","path",H[0],H[1],false,false,x,x,"closed"],i:["Line-Error:"+I+":"+E],b:ac,t:ae,h:this.lineBy?L:this.Cs(E)})}}}else{j=T;aq=T+(this.eO(af)?af[1]-af[0]:af);if(F==null){F=j}for(var ad=1;ad<aj.length;ad++){W=ad-1;if(this.Ov(S)){C=ab?aa+ab-((aj[W]-S[W].min)*S[W].units):aa+((aj[W]-S[W].min)*S[W].units);B=ab?aa+ab-((aj[ad]-S[ad].min)*S[ad].units):aa+((aj[ad]-S[ad].min)*S[ad].units)}else{C=ab?aa+ab-((aj[W]-Z)*S):aa+((aj[W]-Z)*S);B=ab?aa+ab-((aj[ad]-Z)*S):aa+((aj[ad]-Z)*S)}if(Q==null){Q=C}L=this.lineBy?this.Cs(false,false,"Property:"+this.lineBy+":"+ao[W][2]+":x"):false;if(this.tc(C,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&U){this.YN({p:["drawShape",U,C,j,J,J,al,am,V[W],false,false,ag],i:ao[W],m:ah,b:[Q,F],t:ae,h:this.lineBy?L:this.Cs(ao[W][0],ao[W][1])})}else{this.YN({p:["drawShape","sphere",C,j,J,J,this.a0(al,0,true),"rgba(0,0,0,0)",V[W],false,false,ag],i:ao[W],m:ah,b:[Q,F],t:ae,h:this.lineBy?L:this.Cs(ao[W][0],ao[W][1])})}if(this.showDataValues){this.YN({p:["drawText",this.qY(aj[W]),C,j-this.margin,this.smpTextFont,this.smpTextColor,"center","bottom"],t:ae,h:this.lineBy?L:this.Cs(ao[W][0],ao[W][1])})}if(this.tc(ai[W],true)){A=(ai[W]/2)*this.Ov(S)?S[W].units:S;if(this.lineErrorType=="bar"){ak=this.YN({p:["drawLine","error",C,j,C+A,j,al,K,"butt"],i:["Line:"+I+":"+E],g:N,t:ae,h:this.lineBy?L:this.Cs(E)});if(!N){N=ak}this.YN({p:["drawLine","error",C,j,C-A,j,al,K,"butt"],i:["Line:"+I+":"+E],g:N,t:ae,h:this.lineBy?L:this.Cs(E)})}else{r[0].push([C+A,C-A]);r[1].push([j,j]);ac.push([C,j])}}if(this.lineType=="spline"){P[0].push(C);P[1].push(j)}}if((this.lineType!="spline"&&this.tc(C,true)&&this.tc(B,true))||aj.length<3){ak=this.YN({p:["drawLine",this.lineDecoration=="pattern"||this.patternBy?(V[W]||"solid"):this.lineType,C,j,B,aq,al,G,"butt",false,false,ag],i:["Line:"+I+":"+E],b:[Q,F],t:ae,h:this.lineBy?L:this.Cs(E)})}else{if(this.lineType=="spline"&&!this.tc(B,true)){ak=this.YN({p:["drawLine","spline",P[0],P[1],false,false,al,G,false,false,false,ag],i:["Line:"+I+":"+E],b:[Q,F],t:ae,h:this.lineBy?L:this.Cs(E)});P=[[],[]];Q=null;F=null}}if(!N){N=ak}if(r[1].length>0&&!this.tc(B,true)){var x=this.a0(al,0.3,true);if(this.lineType=="spline"){this.YN({p:["drawShape","confidence",r[0],r[1],false,false,x,x,"closed"],i:["Line-Error:"+I+":"+E],b:ac,t:ae,h:this.lineBy?L:this.Cs(E)})}else{var H=M();this.YN({p:["drawShape","path",H[0],H[1],false,false,x,x,"closed"],i:["Line-Error:"+I+":"+E],b:ac,t:ae,h:this.lineBy?L:this.Cs(E)})}r=[[],[]];ac=[]}j=aq;aq+=(this.eO(af)?af[ad+1]-af[ad]:af)}L=this.lineBy?this.Cs(false,false,"Property:"+this.lineBy+":"+ao[Y][2]+":x"):false;if(this.tc(B,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&U){this.YN({p:["drawShape",U,B,j,J,J,al,am,V[Y],false,false,ag],i:ao[Y],m:ah,b:[Q,F],t:ae,h:this.lineBy?L:this.Cs(ao[Y][0],ao[Y][1])})}else{this.YN({p:["drawShape","sphere",B,j,J,J,this.a0(al,0,true),"rgba(0,0,0,0)",V[Y],false,false,ag],i:ao[Y],m:ah,b:[Q,F],t:ae,h:this.lineBy?L:this.Cs(ao[Y][0],ao[Y][1])})}if(this.showDataValues){this.YN({p:["drawText",this.qY(aj[Y]),B,j-this.margin,this.smpTextFont,this.smpTextColor,"center","bottom"],t:ae,h:this.lineBy?L:this.Cs(ao[Y][0],ao[Y][1])})}if(this.tc(ai[Y],true)){A=(ai[Y]/2)*this.Ov(S)?S[Y].units:S;if(this.lineErrorType=="bar"){ak=this.YN({p:["drawLine","error",B,j,B+A,j,al,K,"butt"],i:["Line:"+I+":"+E],g:N,t:ae,h:this.lineBy?L:this.Cs(E)});if(!N){N=ak}this.YN({p:["drawLine","error",B,j,B-A,j,al,K,"butt"],i:["Line:"+I+":"+E],g:N,t:ae,h:this.lineBy?L:this.Cs(E)})}else{r[0].push([B+A,B-A]);r[1].push([j,j]);ac.push([B,j])}}if(this.lineType=="spline"){P[0].push(B);P[1].push(j)}}if(this.lineType=="spline"){ak=this.YN({p:["drawLine","spline",P[0],P[1],false,false,al,G,false,false,false,ag],i:["Line:"+I+":"+E],b:[Q,F],t:ae,h:this.lineBy?L:this.Cs(E)})}if(!N){N=ak}if(r[1].length>0){var x=this.a0(al,0.3,true);if(this.lineType=="spline"){this.YN({p:["drawShape","confidence",r[0],r[1],false,false,x,x,"closed"],i:["Line-Error:"+I+":"+E],b:ac,t:ae,h:this.lineBy?L:this.Cs(E)})}else{var H=M();this.YN({p:["drawShape","path",H[0],H[1],false,false,x,x,"closed"],i:["Line-Error:"+I+":"+E],b:ac,t:ae,h:this.lineBy?L:this.Cs(E)})}}}}};this.Sh=function(U,N,F,C,W,I,R,E,y,J,V,H,X,L,O,S,T){var m=F;var B=N;var s=this;var Y=T?"Overlays":"Data";var h=function(a){var c=0;if(s.dodgeBy){for(var b=0;b<U.length;b++){if(U[b]!=0){c++}}}return a/c};var Q=function(c,e,b,d,a){return s.JN(c,{width:d,height:a,left:e,top:b})};var A=h(C);if(J=="vertical"){F=m-y;for(var P=0;P<U.length;P++){if(U[P]>0){var D=I?(U[P]*100/R[0])*E:U[P]*E;var M=P==U.length-1&&this.useRoundRectangles?"roundrectt":"rectangle";var x=this.Fg(V[P],X[P]);var r=C>5?this.fE(x,X[P]):x;if(this.graphType=="Network"){this.YN({p:["drawShape",M,N+(C/2),F-(D/2),C,D,V[P],V[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var K=Q(W[P],N,F-D,C,D);this.Vd(K,0,0)}else{if(this.dodgeBy){var j=this.Cs(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.YN({p:["drawShape",M,N+(A/2),F-(D/2),A,D,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.Cs(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.Cs(X[P][0],X[P][1]);var G=this.YN({p:["drawShape",M,N+(C/2),F-(D/2),C,D,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.YN({p:["drawText",this.qY(U[P]),N+(C/2),F-(D/2),this.smpTextFont,this.smpTextColor,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){N+=A}else{F-=D}}}F=m-y;for(var P=U.length-1;P>=0;P--){if(U[P]<0){var D=I?(U[P]*100/-R[1])*E:U[P]*E;var M=P>0||!this.useRoundRectangles?"rectangle":"roundrectb";var x=this.Fg(V[P],X[P]);var r=C>5?this.fE(x,X[P]):x;if(this.graphType=="Network"){this.YN({p:["drawShape",M,N+(C/2),F-(D/2),C,-D,V[P],V[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var K=Q(W[P],N,F-D,C,-D);this.Vd(K,0,0)}else{if(this.dodgeBy){var j=this.Cs(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.YN({p:["drawShape",M,N+(A/2),F-(D/2),A,-D,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.Cs(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.Cs(X[P][0],X[P][1]);var G=this.YN({p:["drawShape",M,N+(C/2),F-(D/2),C,-D,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.YN({p:["drawText",this.qY(U[P]),N+(C/2),F-(D/2),this.smpTextFont,this.smpTextColor,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){N+=A}else{F-=D}}}}else{N=B+y;for(var P=0;P<U.length;P++){if(U[P]>0){var D=I?(U[P]*100/R[0])*E:U[P]*E;var M=P<U.length-1||!this.useRoundRectangles?"rectangle":O?"roundrectl":"roundrectr";var x=this.Fg(V[P],X[P]);var r=C>5?this.fE(x,X[P]):x;if(O){if(this.graphType=="Network"){this.YN({p:["drawShape",M,N+O-(D/2),F+(C/2),D,C,V[P],V[P],H[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var K=Q(W[P],N+O-D,F,D,C);this.Vd(K,0,0)}else{if(this.dodgeBy){var j=this.Cs(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.YN({p:["drawShape",M,N+O-(D/2),F+(A/2),D,A,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.Cs(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.Cs(X[P][0],X[P][1]);var G=this.YN({p:["drawShape",M,N+O-(D/2),F+(C/2),D,C,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.YN({p:["drawText",this.qY(U[P]),N+O-(D/2),F+(C/2),this.smpTextFont,this.smpTextColor,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){F+=A}else{N-=D}}else{if(this.graphType=="Network"){this.YN({p:["drawShape",M,N+(D/2),F+(C/2),D,C,V[P],V[P],H[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var T=Q(W[P],N,F,D,C);this.Vd(T,0,0)}else{if(this.dodgeBy){var j=this.Cs(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.YN({p:["drawShape",M,N+(D/2),F+(A/2),D,A,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.Cs(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.Cs(X[P][0],X[P][1]);var G=this.YN({p:["drawShape",M,N+(D/2),F+(C/2),D,C,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.YN({p:["drawText",this.qY(U[P]),N+(D/2),F+(C/2),this.smpTextFont,this.smpTextColor,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){F+=A}else{N+=D}}}}N=B+y;for(var P=U.length-1;P>=0;P--){if(U[P]<0){var D=I?(U[P]*100/-R[1])*E:U[P]*E;var M=P>0||!this.useRoundRectangles?"rectangle":O?"roundrectr":"roundrectl";var x=this.Fg(V[P],X[P]);var r=C>5?this.fE(x,X[P]):x;if(O){if(this.graphType=="Network"){this.YN({p:["drawShape",M,N+O-(D/2),F+(C/2),-D,C,V[P],V[P],H[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var K=Q(W[P],N+O-D,F,-D,C);this.Vd(K,0,0)}else{if(this.dodgeBy){var j=this.Cs(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.YN({p:["drawShape",M,N+O-(D/2),F+(A/2),-D,A,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.Cs(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.Cs(X[P][0],X[P][1]);var G=this.YN({p:["drawShape",M,N+O-(D/2),F+(C/2),-D,C,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.YN({p:["drawText",this.qY(U[P]),N+O-(D/2),F+(C/2),this.smpTextFont,this.smpTextColor,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){F+=A}else{N-=D}}else{if(this.graphType=="Network"){this.YN({p:["drawShape",M,N+(D/2),F+(C/2),-D,C,V[P],V[P],H[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var T=Q(W[P],N,F,-D,C);this.Vd(T,0,0)}else{if(this.dodgeBy){var j=this.Cs(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.YN({p:["drawShape",M,N+(D/2),F+(A/2),-D,A,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.Cs(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.Cs(X[P][0],X[P][1]);var G=this.YN({p:["drawShape",M,N+(D/2),F+(C/2),-D,C,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.YN({p:["drawText",this.qY(U[P]),N+(D/2),F+(C/2),this.smpTextFont,this.smpTextColor,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){F+=A}else{N+=D}}}}}};this.p3=function(ai,Z,S,Q,ae,T,ag,V,J,D,m,X,af,ak,W,an,al,M,G,am){var Y=ai.length-1;var aa=af&&this.lineType=="rect"?"path":this.lineType=="rect"?"polygon":"spline";var A=[];var B=[];var U=[];var ao=-D*J;var C=m*J;var ad=am?"Overlays":"Data";var L=function(b,a){for(var c=a+1;c<ai[b].length;c++){if(ai[b][c]>0){return 1}else{if(ai[b][c]<0){return -1}}}return 0};if(X=="vertical"){for(var ac=0;ac<ai[0].length;ac++){A[ac]=ag=="stacked"&&D<0?S-C:S;B[ac]=S-C}for(var ac=0;ac<ai.length;ac++){var ah=Z;var P=af?[]:[Z];var N=af?[]:[S-ao];var H=0;var aj,K;for(var ab=0;ab<ai[0].length;ab++){if(!this.tc(ai[ac][ab],true)){if(!af){P.push(ah-T);N.push(S-ao)}if(af&&this.lineType=="spline"){this.YN({p:["drawLine",aa,P,N,false,false,ak[ac],this.lineThickness],i:an[ac],m:al,b:S-ao,t:ad,h:this.Cs(an[ac][0])})}else{if(D>=0&&Y>0&&ag!="normal"){var E=U[U.length-1][1];P.shift();var F=[];var ap=[];for(var ac=1;ac<N.length;ac++){F.push([P[ac-1],P[ac-1]]);ap.push([N[ac],E[ac]])}this.YN({p:["drawShape","confidence",F,ap,this.width,this.height,this.Fg(ak[Y],an[Y]),this.fE(ak[Y],an[Y]),W[Y]],i:an[Y],m:al,b:S-ao,t:ad,h:this.Cs(an[Y][0])})}else{this.YN({p:["drawShape",aa,P,N,this.width,this.height,this.Fg(ak[ac],an[ac]),this.fE(ak[ac],an[ac]),W[ac]],i:an[ac],m:al,b:S-ao,t:ad,h:this.Cs(an[ac][0])})}}if(G){var u=this.a0(ak[ac],0,true);for(var I=0;I<P.length;I++){aj=this.YN({p:["drawShape","sphere",P[I],N[I],T,T,u,"rgba(0,0,0,0)",W[ac]],i:[an[ac][0],G[I]],s:true,t:ad});if(!af){this.YN({p:["drawLine","line",P[I],N[I]+T,P[I],N[0],u,T],i:[an[ac][0],G[I]],g:aj,s:true,t:ad})}}}P=af?[]:[ah+T];N=af?[]:[S-ao]}else{var R=ag=="percent"?((ai[ac][ab]-D)*100/V[ab])*J:(ai[ac][ab]-(ag=="stacked"&&D<0?0:D))*J;P.push(ah);if(ag&&(ag=="stacked"||ag=="percent")){if(ai[ac][ab]>0||H>0){N.push(A[ab]-R);A[ab]-=R;H=1}else{if(ai[ac][ab]<0||H<0){N.push(B[ab]-R);B[ab]-=R;H=-1}else{var O=L(ac,ab);if(O<0){N.push(B[ab]-R);B[ab]-=R;H=-1}else{if(O>0){N.push(A[ab]-R);A[ab]-=R;H=1}else{N.push(ao)}}}}}else{N.push(S-R)}}ah+=T}if(!af){P.push(Z+Q);N.push(S-ao)}U.push([P,N,ak[ac],W[ac],an[ac]])}}else{for(var ac=0;ac<ai[0].length;ac++){A[ac]=M?Z+M:ag=="stacked"&&D<0?Z+C:Z;B[ac]=Z+C}for(var ac=0;ac<ai.length;ac++){var ah=S;var P=af?[]:M?[Z+M]:[Z+ao];var N=af?[]:[S];var H=0;var aj,K;for(var ab=0;ab<ai[0].length;ab++){if(!this.tc(ai[ac][ab],true)){if(!af){P.push(M?Z+M:Z+ao);N.push(ah-T)}if(af&&this.lineType=="spline"){this.YN({p:["drawLine",aa,P,N,false,false,ak[ac],this.lineThickness],i:an[ac],m:al,b:Z+ao,t:ad,h:this.Cs(an[ac][0])})}else{var E=U[U.length-1][0];if(D>=0&&Y>0&&ag!="normal"){N.shift();var F=[];var ap=[];for(var ac=1;ac<P.length;ac++){F.push([P[ac],E[ac]]);ap.push([N[ac-1],N[ac-1]])}this.YN({p:["drawShape","confidence",F,ap,this.width,this.height,this.Fg(ak[Y],an[Y]),this.fE(ak[Y],an[Y]),W[Y]],i:an[Y],m:al,b:Z+ao,t:ad,h:this.Cs(an[Y][0])})}else{this.YN({p:["drawShape",aa,P,N,this.width,this.height,this.Fg(ak[ac],an[ac]),this.fE(ak[ac],an[ac]),W[ac]],i:an[ac],m:al,b:Z+ao,t:ad,h:this.Cs(an[ac][0])})}}if(G){var u=this.a0(ak[ac],0,true);for(var I=0;I<P.length;I++){aj=this.YN({p:["drawShape","sphere",P[I],N[I],T,T,u,"rgba(0,0,0,0)",W[ac]],i:[an[ac][0],G[I]],s:true,t:ad});if(!af){this.YN({p:["drawLine","line",P[I]-T,N[I],P[0],N[I],u,T],i:[an[ac][0],G[I]],g:aj,s:true,t:ad})}}}P=af?[]:[M?Z+M:Z+ao];N=af?[]:[ah+T]}else{var R=ag=="percent"?((ai[ac][ab]-D)*100/V[ab])*J:(ai[ac][ab]-(ag=="stacked"&&D<0?0:D))*J;N.push(ah);if(ag&&(ag=="stacked"||ag=="percent")){if(M){P.push(A[ab]-R);A[ab]-=R}else{if(ai[ac][ab]>0||H>0){P.push(A[ab]+R);A[ab]+=R;H=1}else{if(ai[ac][ab]<0||H<0){P.push(B[ab]+R);B[ab]+=R;H=-1}else{var O=L(ac,ab);if(O<0){P.push(B[ab]+R);B[ab]+=R;H=-1}else{if(O>0){P.push(A[ab]+R);A[ab]+=R;H=1}else{N.push(ao)}}}}}}else{P.push(M?Z+M-R:Z+R)}}ah+=T}if(!af){P.push(M?Z+M:Z+ao);N.push(S+ae)}U.push([P,N,ak[ac],W[ac],an[ac]])}}while(Y>=0){var aj,K;var ab=U.pop();if(af){if(this.lineType=="spline"){this.YN({p:["drawLine",aa,ab[0],ab[1],false,false,ab[2],this.lineThickness],i:ab[4],m:al,b:X=="vertical"?S-ao:Z+ao,t:ad,h:this.Cs(ab[4][0])})}else{var K=null;for(var ac=1;ac<ab[0].length;ac++){var aj=this.YN({p:["drawLine",aa,ab[0][ac-1],ab[1][ac-1],ab[0][ac],ab[1][ac],ab[2],this.lineThickness],i:ab[4],m:al,g:K,b:X=="vertical"?S-ao:Z+ao,t:ad,h:this.Cs(ab[4][0])});if(K==null){K=aj}}}}else{if(D>=0&&Y>0&&ag!="normal"){var E=X=="vertical"?U[U.length-1][1]:U[U.length-1][0];if(X=="vertical"){ab[0].shift();ab[0].pop();var F=[];var ap=[];for(var ac=1;ac<ab[1].length-1;ac++){F.push([ab[0][ac-1],ab[0][ac-1]]);ap.push([ab[1][ac],E[ac]])}ab[1].shift();ab[1].pop();this.YN({p:["drawShape","confidence",F,ap,this.width,this.height,this.Fg(ab[2]),this.fE(ab[2]),ab[3]],i:ab[4],m:al,b:S-ao,t:ad,h:this.Cs(ab[4][0])})}else{ab[1].shift();ab[1].pop();var F=[];var ap=[];for(var ac=1;ac<ab[0].length-1;ac++){F.push([ab[0][ac],E[ac]]);ap.push([ab[1][ac-1],ab[1][ac-1]])}ab[0].shift();ab[0].pop();this.YN({p:["drawShape","confidence",F,ap,this.width,this.height,this.Fg(ab[2]),this.fE(ab[2]),ab[3]],i:ab[4],m:al,b:Z+ao,t:ad,h:this.Cs(ab[4][0])})}}else{if(ag=="normal"||ag=="stacked"){this.YN({p:["drawShape",aa,ab[0],ab[1],this.width,this.height,this.Fg(ab[2]),this.fE(ab[2]),ab[3]],i:ab[4],m:al,b:X=="vertical"?S-ao:Z+ao,t:ad,h:this.Cs(ab[4][0])})}else{if(X=="vertical"){var ap=[];for(var ac=1;ac<ab[1].length-1;ac++){ap.push([ab[1][ac],ab[1][0]])}this.YN({p:["drawShape","confidence",F,ap,this.width,this.height,this.Fg(ab[2]),this.fE(ab[2]),ab[3]],i:ab[4],m:al,b:S-ao,t:ad,h:this.Cs(ab[4][0])})}else{var F=[];for(var ac=1;ac<ab[0].length-1;ac++){F.push([ab[0][ac],ab[0][0]])}this.YN({p:["drawShape","confidence",F,ap,this.width,this.height,this.Fg(ab[2]),this.fE(ab[2]),ab[3]],i:ab[4],m:al,b:Z+ao,t:ad,h:this.Cs(ab[4][0])})}}}}if(G){var u=this.a0(ab[2],0,true);var g=Math.min(10,T);for(var ac=1;ac<ab[0].length-1;ac++){if(this.isGraphTime&&G[ac-1]<0){continue}aj=this.YN({p:["drawShape","sphere",ab[0][ac],ab[1][ac],g,g,u,"rgba(0,0,0,0)",ab[3]],i:[ab[4][0],G[ac-1]],s:true,t:ad});if(!af){if(X=="vertical"){this.YN({p:["drawLine","line",ab[0][ac],ab[1][ac]+T,ab[0][ac],ab[1][0],u,T],i:[ab[4][0],G[ac-1]],g:aj,s:true,t:ad})}else{this.YN({p:["drawLine","line",ab[0][ac]-T,ab[1][ac],ab[0][0],ab[1][ac],u,T],i:[ab[4][0],G[ac-1]],g:aj,s:true,t:ad})}}}}Y--}};this.l0=function(ax,am,ae,ab,ah,ad,al,aj,ay,ai,aA,at,x,aa){var Y=this;var ak=this.segregateSamplesBy.length&&this.isGroupedData&&this.groupingFactors.includes(this.segregateSamplesBy[0]);var F=function(f){var d;if(Y.layoutValid&&!Y.isDOE){if(Y.segregateVariablesBy.length>0){d=f}else{if(Y.segregateSamplesBy.length>0){var a=!ak?[Y.data.l.name[Y.layoutCurrent],Y.data.w.glab[f]].join("::"):Y.data.w.labs[f]?Y.data.w.labs[f]:Y.data.w.glab[f];for(var c=0;c<n.g[I].length;c++){if(n.g[I][c].density.name==a){d=c;break}}}}}else{d=Y.grpIndices[f]}return n.g[I][d]};var J=function(a){if(Y.showBoxplotOriginalData){if(Y.plotStyle=="ggplot"){return Y.background;return Y.a0(Y.Fg(ay[a],aA[a]),Y.boxplotTransparency,true,false,true)}else{return Y.a0(Y.Fg(ay[a],aA[a]),Y.boxplotTransparency,true,false,true)}}else{return Y.Fg(ay[a],aA[a])}};var Z=function(a){return aj=="vertical"?ae-((a-al)*ad):am+((a-al)*ad)};var n=this.meta.data.d;var I=this.FP(aa);var af=this.variableSpace/2;var aq=ab/2;var M=aq/2;var K=M/2;var av=ab/this.boxplotOutliersRatio;var L={};var X={};var Q=false;var V=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?(ab-this.variableSpace)*this.boxplotWidthRatioIfViolin:ab-this.variableSpace;var U=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?ab*this.boxplotWidthRatioIfViolin:0;var T=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?U/2:aq;var b=Math.max(1,ab/4);if(aj=="vertical"){for(var ap=0;ap<ax.length;ap++){if(this.isGraphTime&&aA[ap][1]<0){am+=this.eO(ah)?ah[ap]:ah;continue}var W=this.showBoxplotOriginalData?this.Cs(aA[ap][0]):this.scatterPlotMatrix&&this.scatterType=="boxplot"?this.Cs(false,false,aA[ap][1]):this.Cs(aA[ap][0],aA[ap][1],false,true);if(this.isGroupedData&&this.showViolinBoxplot&&this.isRawData&&ax[ap].length>1){var E=F(this.layoutValid?aA[ap][1]:ap);if(E){this.qP(E,am+(ab/2),ae,ab/this.varIndices.length,ad,al,aj,at[ap],x[ap],aA[ap],W,ax[ap]);if(!this.showBoxplotIfViolin){Q=true}}}var ag=am+aq;var ac=[];var D=[];var R=this.showBoxplotOriginalData||this.showViolinBoxplot?at[ap]:ay[ap];for(var ao=0;ao<5;ao++){ac.push(Z(ax[ap][ao]));D.push(ac[ac.length-1].toString())}if(this.graphType=="Heatmap"){aA[ap]=false}if(!Q){var S=(am+af)+((ab-this.variableSpace)/2);var au=ac[3]+((ac[2]-ac[3])/2);var ar=V;var az=ac[2]-ac[3];var e=this.boxplotNotched?Z(ax[ap][7][0]):false;var an=this.boxplotNotched?Z(ax[ap][7][1]):false;var O=J(ap);var N=this.plotStyle.match(/open|border|ggplotSwitched/)?this.ZM(O):this.boxplotBorderColor;var H=this.boxplotMedianColor||N;if(this.boxplotColor){O=this.boxplotColor}var aw,P,A;if(this.boxplotVarWidth&&this.graphType!="Scatter2D"){ar=V*ax[ap][8];U+=(V-ar)/2}if(this.boxplotNotched&&this.boxplotType!="range"){if(this.showViolinBoxplot){P=[am+(ab-af-U)-b,am+af+U,am+af+U,am+(ab-af-U),am+(ab-af-U),am+af+U+b,am+(ab-af-U)-b]}else{P=[am+af+U+b,am+af+U,am+af+U,am+(ab-af-U),am+(ab-af-U),am+(ab-af-U)-b,am+af+U+b]}A=[ac[4],e,ac[2],ac[2],e,ac[4],ac[4]];aw=this.YN({p:["drawShape","polygon",P,A,false,false,O,N,ai[ap]],i:aA[ap],b:ae,t:"Data",h:W});A=[ac[4],an,ac[3],ac[3],an,ac[4],ac[4]];this.YN({p:["drawShape","polygon",P,A,false,false,O,N,ai[ap]],i:aA[ap],g:aw,b:ae,t:"Data",h:W})}else{if(this.boxplotType=="range"){aw=this.YN({p:["drawLine","line",S,ac[1],S,ac[0],this.plotStyle=="open"?N:O,av,"round"],i:aA[ap],b:ae,t:"Data",h:W})}else{aw=this.YN({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",S,au,ar,az,O,N,ai[ap]],i:aA[ap],b:ae,t:"Data",h:W})}}if(this.zK(D).length!=0){if(this.boxplotNotched&&this.boxplotType!="range"){this.YN({p:["drawLine","median",am+af+U+b,ac[4],am+(ab-af-U)-b,ac[4],H,this.boxplotMedianWidth,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}else{if(this.boxplotType=="range"){this.YN({p:["drawShape","sphere",S,ac[4],av*2.5,av*2.5,this.plotStyle=="open"?N:O,this.plotStyle=="open"?N:O],i:aA[ap],g:aw,t:"Data",h:W})}else{this.YN({p:["drawLine","median",S-(ar/2),ac[4],S+(ar/2),ac[4],H,this.boxplotMedianWidth,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}}if(this.boxplotType!="range"){if(this.boxplotWhiskersType=="single"){if(ac[0]>ac[2]){this.YN({p:["drawLine","line",ag,ac[2],ag,ac[0],N,false,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}if(ac[1]<ac[3]){this.YN({p:["drawLine","line",ag,ac[3],ag,ac[1],N,false,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}}else{if(this.boxplotWhiskersType=="double"){if(ac[0]>ac[2]){this.YN({p:["drawLine","error",ag,ac[2],ag,ac[0],N,-T,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}if(ac[1]<ac[3]){this.YN({p:["drawLine","error",ag,ac[3],ag,ac[1],N,-T,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}}}}}if(this.boxplotMean){this.YN({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",ag,Z(ax[ap][6]),M,M,this.boxplotMeanColor,this.boxplotMeanBorderColor],i:aA[ap],g:aw,b:ae,t:"Data",h:W})}if(ax[ap][5]&&!this.showBoxplotOriginalData){var G={};for(var ao=0;ao<ax[ap][5].length;ao++){if(G[ax[ap][5][ao]]){continue}G[ax[ap][5][ao]]=true;var k=this.boxplotOutliersShape;var B=this.boxplotOutliersColor||(this.plotStyle.match(/ggplot/)?N:O);var C=this.boxplotOutliersBorderColor||N;this.YN({p:["drawShape",k,ag,Z(ax[ap][5][ao]),av,av,B,C,ai[ap]],i:aA[ap],g:aw,b:ae,t:"Data",h:W})}}}if(!L.hasOwnProperty(R)){L[R]=[];X[R]=this.gg(aA[ap])}L[R].push([am+af+(ab/2),ac[4]]);am+=this.eO(ah)?ah[ap+1]-ah[ap]:ah}}else{for(var ap=0;ap<ax.length;ap++){if(this.isGraphTime&&aA[ap][1]<0){ae+=this.eO(ah)?ah[ap]:ah;continue}var W=this.showBoxplotOriginalData?this.Cs(aA[ap][0]):this.Cs(aA[ap][0],aA[ap][1],false,true);if(this.isGroupedData&&this.showViolinBoxplot&&this.isRawData&&ax[ap].length>1){var E=F(this.layoutValid?aA[ap][1]:ap);if(E){this.qP(E,am,ae+(ab/2),ab/this.varIndices.length,ad,al,aj,at[ap],x[ap],aA[ap],W,ax[ap]);if(!this.showBoxplotIfViolin){Q=true}}}var ag=ae+aq;var ac=[];var D=[];var R=this.showBoxplotOriginalData||this.showViolinBoxplot?at[ap]:ay[ap];for(var ao=0;ao<5;ao++){ac.push(Z(ax[ap][ao]));D.push(ac[ac.length-1].toString())}if(this.graphType=="Heatmap"){aA[ap]=false}if(!Q){var S=ac[2]+((ac[3]-ac[2])/2);var au=(ae+af)+((ab-this.variableSpace)/2);var ar=ac[3]-ac[2];var az=V;var e=this.boxplotNotched?Z(ax[ap][7][0]):false;var an=this.boxplotNotched?Z(ax[ap][7][1]):false;var O=J(ap);var N=this.plotStyle.match(/open|border|ggplotSwitched/)?this.ZM(O):this.boxplotBorderColor;var H=this.boxplotMedianColor||N;if(this.boxplotColor){O=this.boxplotColor}var aw,P,A;if(this.boxplotVarWidth&&this.graphType!="Scatter2D"){az=V*ax[ap][8];U+=(V-az)/2}if(this.boxplotNotched&&this.boxplotType!="range"){P=[ac[4],e,ac[2],ac[2],e,ac[4],ac[4]];if(this.showViolinBoxplot){A=[ae+(ab-af-U)-b,ae+af+U,ae+af+U,ae+(ab-af-U),ae+(ab-af-U),ae+af+U+b,ae+(ab-af-U)-b]}else{A=[ae+af+U+b,ae+af+U,ae+af+U,ae+(ab-af-U),ae+(ab-af-U),ae+(ab-af-U)-b,ae+af+U+b]}aw=this.YN({p:["drawShape","polygon",P,A,false,false,O,N,ai[ap]],i:aA[ap],b:ae,t:"Data",h:W});P=[ac[4],an,ac[3],ac[3],an,ac[4],ac[4]];this.YN({p:["drawShape","polygon",P,A,false,false,O,N,ai[ap]],i:aA[ap],g:aw,b:ae,t:"Data",h:W})}else{if(this.boxplotType=="range"){aw=this.YN({p:["drawLine","line",ac[0],au,ac[1],au,this.plotStyle=="open"?N:O,av,"round"],i:aA[ap],b:am,t:"Data",h:W})}else{aw=this.YN({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",S,au,ar,az,O,N,ai[ap]],i:aA[ap],b:am,t:"Data",h:W})}}if(this.zK(D).length!=0){if(this.boxplotNotched&&this.boxplotType!="range"){this.YN({p:["drawLine","median",ac[4],ae+af+U+b,ac[4],ae+(ab-af-U)-b,H,this.boxplotMedianWidth,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}else{if(this.boxplotType=="range"){this.YN({p:["drawShape","sphere",ac[4],au,av*2.5,av*2.5,this.plotStyle=="open"?N:O,this.plotStyle=="open"?N:O],i:aA[ap],g:aw,t:"Data",h:W})}else{this.YN({p:["drawLine","median",ac[4],au-(az/2),ac[4],au+(az/2),H,this.boxplotMedianWidth,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}}if(this.boxplotType!="range"){if(this.boxplotWhiskersType=="single"){if(ac[2]>ac[0]){this.YN({p:["drawLine","line",ac[2],ag,ac[0],ag,N,false,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}if(ac[3]<ac[1]){this.YN({p:["drawLine","line",ac[3],ag,ac[1],ag,N,false,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}}else{if(this.boxplotWhiskersType=="double"){if(ac[2]>ac[0]){this.YN({p:["drawLine","error",ac[2],ag,ac[0],ag,N,T,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}if(ac[3]<ac[1]){this.YN({p:["drawLine","error",ac[3],ag,ac[1],ag,N,T,"butt"],i:aA[ap],g:aw,t:"Data",h:W})}}}}}if(this.boxplotMean){this.YN({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",Z(ax[ap][6]),ag,M,M,this.boxplotMeanColor,this.boxplotMeanBorderColor],i:aA[ap],g:aw,b:am,t:"Data",h:W})}if(ax[ap][5]&&!this.showBoxplotOriginalData){var G={};for(var ao=0;ao<ax[ap][5].length;ao++){if(G[ax[ap][5][ao]]){continue}G[ax[ap][5][ao]]=true;var k=this.boxplotOutliersShape;var B=this.boxplotOutliersColor||(this.plotStyle.match(/ggplot/)?N:O);var C=this.boxplotOutliersBorderColor||N;this.YN({p:["drawShape",k,Z(ax[ap][5][ao]),ag,av,av,B,C,ai[ap]],i:aA[ap],g:aw,b:am,t:"Data",h:W})}}}if(!L.hasOwnProperty(R)){L[R]=[];X[R]=this.gg(aA[ap])}L[R].push([ac[4],ae+af+(ab/2)]);ae+=this.eO(ah)?ah[ap+1]-ah[ap]:ah}}if(this.boxplotConnect){for(var R in L){if(L[R].length>1){var aw=this.YN({p:["drawLine","line",L[R][0][0],L[R][0][1],L[R][1][0],L[R][1][1],R,this.boxplotConnectWidth,"butt"],i:["Line:",X[R][0],X[R][1]],t:"Data",h:W});for(var ap=1;ap<L[R].length-1;ap++){this.YN({p:["drawLine","line",L[R][ap][0],L[R][ap][1],L[R][ap+1][0],L[R][ap+1][1],R,this.boxplotConnectWidth,"butt"],i:["Line:",X[R][0],X[R][1]],g:aw,t:"Data",h:W})}}}}};this.Ht=function(R,E,T,H,L,C,P,B,K,F,S,U){var y=function(a){return L+((a-K)*B)};var x=null;for(var N=0;N<R.length;N++){var J=y(R[N][0]);var f=y(R[N][1]);var A=J+((f-J)/2);var e=C+(P/2);var W=f-J;var v=E[N]?W*E[N]:false;var w=this.Fg(S[N],U[N]);var g=this.a0(w,this.ganttCompletionTransparency,true,false,true);var s=this.fE(w,U[N]);var r=this.Cs(false,U[N][0]);var D=this.YN({p:["drawShape","roundrect",A,e,W,P,g,g,F[N]],i:U[N],g:x,b:L,t:"Data",h:r});if(!x){x=D}if(E[N]){if(E[N]==1){this.YN({p:["drawShape","roundrect",A,e,W,P,w,w,F[N]],i:U[N],g:x,b:L,t:"Data",h:r})}else{this.YN({p:["drawShape","roundrectl",A-((W-v)/2),e,v,P,w,w,F[N]],i:U[N],g:x,b:L,t:"Data",h:r})}}this.YN({p:["drawShape","roundrect",A,e,W,P,false,s,"open"],i:U[N],g:x,b:L,t:"Data",h:r});if(H.length){for(var M=0;M<H.length;M++){var I=y(H[M][0]);this.YN({p:["drawShape","triangle2",I,C,P/3,P/3,w,s],i:[].concat(U[N].concat(H[M][1])),g:x,b:L,t:"Data",h:r})}}if(T[N]){var G=y(T[N][0]);var X=y(T[N][1]);var V=T[N][2]+(P/2);var Q=e==V?X:G+((X-G)/2);var n=e==V?V:V+(P/2);var O=A-(W/2);var k=e;this.YN({p:["drawLine",n==k?"line":"roundLine",Q,n,O,k,this.fE(T[N][4]),T[N][5],"butt",0,0,false,false,false,false,T[N][3]],i:U[N],g:x,b:L,t:"Data",h:r})}}};this.qP=function(s,J,B,N,A,H,F,Q,E,D,g,O){var k=[];var L=[];var e=[];var G=[];var b=[[],[]];var I,f,r,n,w,a,R,P;var S=s.density.maxY>0?s.density.maxY:0.000001;switch(this.violinScale){case"area":I=N/S*S/s.scale*0.9/this.widthFactor;break;case"count":I=N/S*s.density.sumY/s.area*0.9/this.widthFactor;break;case"width":I=N/S*0.9/this.widthFactor;break}var C=this.a0(this.violinColor||Q,this.showBoxplotOriginalData&&!this.violinColor&&this.plotStyle!="ggplot"?0:this.violinTransparency,true);if(this.violinTrim){f=[];for(var M=s.density.trim[0];M<s.density.trim[1];M++){f.push(s.density.xy[M])}}else{f=s.density.xy}if(F=="vertical"){for(var M=0;M<f.length;M++){r=(f[M][1]*I);n=((f[M][0]-H)*A);k.push(J-r);L.push(B-n);e.push(J+r);G.push(B-n);b[0].push(J);b[1].push(B-n)}}else{for(var M=0;M<f.length;M++){r=((f[M][0]-H)*A);n=(f[M][1]*I);k.push(J+r);L.push(B-n);e.push(J+r);G.push(B+n);b[0].push(J+r);b[1].push(B)}}if(k.length>1&&L.length>1){this.YN({p:["drawShape","violin",[k,e],[L,G],false,false,C,this.violinBorderColor,E],i:D,b:b,t:"Data",h:g});if(this.showViolinQuantiles){r=O;for(M=2;M<=4;M++){if(F=="vertical"){for(var K=0;K<f.length;K++){if(f[K][0]>r[M]){R=f[K][1]*I;P=B-((r[M]-H)*A);this.YN({p:["drawLine","solid",J-R,P,J+R,P,this.violinBorderColor,1.5],t:"Decorations",h:g});break}}}else{for(var K=0;K<f.length;K++){if(f[K][0]>r[M]){R=J+((r[M]-H)*A);P=f[K][1]*I;this.YN({p:["drawLine","solid",R,B-P,R,B+P,this.violinBorderColor,1.5],t:"Decorations",h:g});break}}}}}}else{if(F=="vertical"){r=J;n=B-((s.density.median[0]-H)*A)}else{r=J+((s.density.median[0]-H)*A);n=B}this.YN({p:["drawShape","circle",r,n,this.margin,this.margin,C,this.violinBorderColor,E],i:D,b:b,t:"Data",h:g})}};this.Aa=function(ap,an,ac,U,ah,X,T,ab,V,Z,aq,ad,Y,aw,R,W,Q,J,I,at){var P=this;var E=function(h){var l=P.segregateSamplesBy.length&&P.isGroupedData&&P.groupingFactors.includes(P.segregateSamplesBy[0]);var c=P.meta.data.d;var k=P.FP(J);var e;if(P.layoutValid&&!P.isDOE){if(P.segregateVariablesBy.length>0){e=h}else{if(P.segregateSamplesBy.length>0){var a=!l?[P.data.l.name[P.layoutCurrent],P.data.w.glab[h]].join("::"):P.data.w.labs[h]?P.data.w.labs[h]:P.data.w.glab[h];for(var d=0;d<c.g[k].length;d++){if(c.g[k][d].density.name==a){e=d;break}}}}}else{if(P.isGroupedData){e=P.grpIndices[h]}}return c.g&&c.g[k]?c.g[k][e]:!P.isGroupedData&&c.v?c.v[k]:false};var H=function(l,c){var a=c[0];var j=0;var e="";var m={n:{},arr:{}};for(var h=0;h<l.length;h++){var d=l[h]!=null?l[h].toString():"";if(!m.n.hasOwnProperty(d)){m.n[d]=0;m.arr[d]=[]}m.n[d]++;if(m.n[d]>j){j=m.n[d];e=d}}if(m.n[e]*a>ah){a=ah*(P.binAlignment=="center"?1:0.5)/m.n[e]}for(var d in m.n){switch(P.binAlignment){case"bottom":case"right":m.arr[d].push(0);m.n[d]--;while(m.n[d]>0){var k=m.arr[d][0];m.arr[d].unshift(k-a);m.n[d]--}break;case"top":case"left":case"centerwhole":m.arr[d].push(0);m.n[d]--;while(m.n[d]>0){var k=m.arr[d][m.arr[d].length-1];m.arr[d].push(k+a);m.n[d]--}break;case"center":if(m.n[d]%2){m.arr[d].push(0);m.n[d]--}else{m.arr[d].push(-a/2);m.n[d]--;m.arr[d].push(a/2);m.n[d]--}while(m.n[d]>0){var k=m.arr[d][0];m.arr[d].unshift(k-a);m.n[d]--;k=m.arr[d][m.arr[d].length-1];m.arr[d].push(k+a);m.n[d]--}break}}return m.arr};var A=[];var ag=at?"Overlays":"Data";if(Z=="vertical"){for(var af=0;af<ap.length;af++){if((this.showBoxplotOriginalData&&this.isRawData)||this.graphType.match(/Dot/)||(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)){var ar=this.dotplotType=="movement"?false:this.binned?H(ap[af],V[af]):false;var F=this.dotplotType=="movement"?false:this.jitter||this.sina?this.OM(this.YU(0,ap[af].length),false,ah*this.jitterFactor*0.5*this.widthFactor):false;if(this.sina&&this.isGroupedData){var D=E(af);this.Cj(F,D,ap[af],ah)}for(var ae=0;ae<ap[af].length;ae++){if(this.isGraphTime&&ap[af][ae]==null){continue}var aa=this.dotplotType=="movement"?0:this.binned&&ar[ap[af][ae]]?ar[ap[af][ae].toString()].shift():this.jitter?F[ae]:0;var f=aw?aw[af][ae]:false;var S=U-((ap[af][ae]-ab)*T);var L=this.Fg(aq[af][ae],f);var M=this.plotStyle=="open"?this.ZM(L):this.fE(L,f);if(this.graphType.match(/Bar/)&&this.barType=="lollipop"){f.push("Lollipop")}if(this.tc(S,true)){var ao;A.push([ac+aa,S,V[af][ae]/2,f]);if(this.graphType.match(/Dot/)&&this.dotplotType=="movement"&&ae>0){var N=A.length-1;var C=A.length-2;while(!this.tc(A[C][1],true)&&C>=0){C--}if(this.tc(A[C][1],true)){var av=A[N];var am=A[C];var al=this.a0(L,0.2);this.YN({p:["drawShape","polygon",[av[0]-av[2],am[0]-am[2],am[0]+am[2],av[0]+av[2]],[av[1],am[1],am[1],av[1]],false,false,al,al],t:"Decorations",h:this.Cs(av[3][0],av[3][1])||this.Cs(am[3][0],am[3][1])})}}if(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData&&this.barLollipopOpen){ao=this.YN({p:["drawShape",Y[af][ae],ac+aa,S,V[af][ae],V[af][ae],this.background,L,ad[af][ae],false,2,W],i:f,m:R,b:U,t:ag,h:this.Cs(f[0],f[1])})}else{if(this.plotStyle!="open"&&V[af][ae]<2.5){ao=this.YN({p:["drawShape",Y[af][ae],ac+aa,S,V[af][ae],V[af][ae],L,L,ad[af][ae],false,false,W],i:f,m:R,b:U,t:ag,h:this.Cs(f[0],this.isGroupedData||(this.graphType=="Dotplot"&&f[2]!=null)?f[2]:f[1])})}else{ao=this.YN({p:["drawShape",Y[af][ae],ac+aa,S,V[af][ae],V[af][ae],L,M,ad[af][ae],false,false,W],i:f,m:R,b:U,t:ag,h:this.Cs(f[0],this.isGroupedData||(this.graphType=="Dotplot"&&f[2]!=null)?f[2]:f[1])})}}if(this.showDataValues){this.YN({p:["drawText",this.qY(ap[af][ae]),ac+aa,S,this.smpTextFont,this.barLollipopOpen?L:this.foreground,"center","middle"],g:ao,t:ag,h:this.Cs(f[0],f[1])})}if(!this.isGroupedData){if(an[af]&&an[af][ae]&&this.tc(an[af][ae],true)){var au=(an[af][ae]/2)*T;this.YN({p:["drawLine","error",ac+aa,S,ac+aa,S+au,L,-ah,"butt",false,false,true],i:f,g:ao,t:ag,h:this.Cs(f[0],f[1])});this.YN({p:["drawLine","error",ac+aa,S,ac+aa,S-au,L,-ah,"butt",false,false,true],i:f,g:ao,t:ag,h:this.Cs(f[0],f[1])})}}}else{A.push([ac+aa,Number.NaN,V[af][ae]/2,f])}}if(this.showErrorBars&&this.isGroupedData&&an[af]&&an[af]&&this.tc(an[af][0],true)&&this.tc(an[af][1],true)){var S=U-((an[af][0]-ab)*T);var au=(an[af][1]/2)*T;var f=aw?[aw[af][0][0],aw[af][0][1],"error"]:false;this.YN({p:["drawShape","diamond",ac,S,this.margin*this.errorBarsThickness,this.margin*this.errorBarsThickness,this.errorBarsColor,this.errorBarsColor,"closed",false,false,W],h:this.Cs(false,aw[af][0][0]),t:ag});this.YN({p:["drawLine","line",ac,S-au,ac,S+au,this.errorBarsColor,this.errorBarsThickness,"butt",false,false,W],h:this.Cs(false,aw[af][0][0]),t:ag})}}ac+=this.eO(X)?X[af+1]-X[af]:X}}else{for(var af=0;af<ap.length;af++){if((this.showBoxplotOriginalData&&this.isRawData)||this.graphType.match(/Dot/)||(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)){var ar=this.dotplotType=="movement"?false:this.binned?H(ap[af],V[af]):false;var F=this.dotplotType=="movement"?false:this.jitter||this.sina?this.OM(this.YU(0,ap[af].length),false,ah*this.jitterFactor*0.5*this.widthFactor):false;if(this.sina&&this.isGroupedData){var D=E(af);this.Cj(F,D,ap[af],ah)}for(var ae=0;ae<ap[af].length;ae++){if(this.isGraphTime&&ap[af][ae]==null){continue}var aa=this.dotplotType=="movement"?0:this.binned&&ar[ap[af][ae]]?ar[ap[af][ae].toString()].shift():this.jitter?F[ae]:0;var f=aw?aw[af][ae]:false;var S=Q?ac+Q-((ap[af][ae]-ab)*T):ac+((ap[af][ae]-ab)*T);var L=this.Fg(aq[af][ae],f);var M=this.plotStyle=="open"?this.ZM(L):this.fE(L,f);if(this.graphType.match(/Bar/)&&this.barType=="lollipop"){f.push("Lollipop")}if(this.tc(S,true)){var ao;A.push([S,U+aa,V[af][ae]/2,f]);if(this.graphType.match(/Dot/)&&this.dotplotType=="movement"&&ae>0){var N=A.length-1;var C=A.length-2;while(!this.tc(A[C][0],true)&&C>=0){C--}if(this.tc(A[C][0],true)){var av=A[N];var am=A[C];var al=this.a0(L,0.2);this.YN({p:["drawShape","polygon",[av[0],am[0],am[0],av[0]],[av[1]-av[2],am[1]-am[2],am[1]+am[2],av[1]+av[2]],false,false,al,al],t:"Decorations",h:this.Cs(av[3][0],av[3][1])||this.Cs(am[3][0],am[3][1])})}}if(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData&&this.barLollipopOpen){ao=this.YN({p:["drawShape",Y[af][ae],S,U+aa,V[af][ae],V[af][ae],this.background,L,ad[af][ae],false,2,W],i:f,m:R,b:ac,t:ag,h:this.Cs(f[0],f[1])})}else{if(this.plotStyle!="open"&&V[af][ae]<2.5){ao=this.YN({p:["drawShape",Y[af][ae],S,U+aa,V[af][ae],V[af][ae],L,L,ad[af][ae],false,false,W],i:f,m:R,b:ac,t:ag,h:this.Cs(f[0],this.isGroupedData||(this.graphType=="Dotplot"&&f[2]!=null)?f[2]:f[1])})}else{ao=this.YN({p:["drawShape",Y[af][ae],S,U+aa,V[af][ae],V[af][ae],L,M,ad[af][ae],false,false,W],i:f,m:R,b:ac,t:ag,h:this.Cs(f[0],this.isGroupedData||(this.graphType=="Dotplot"&&f[2]!=null)?f[2]:f[1])})}}if(this.showDataValues){this.YN({p:["drawText",this.qY(ap[af][ae]),S,U+aa,this.smpTextFont,this.barLollipopOpen?L:this.foreground,"center","middle"],g:ao,t:ag,h:this.Cs(f[0],f[1])})}if(!this.isGroupedData){if(an[af]&&an[af][ae]&&this.tc(an[af][ae],true)){var au=(an[af][ae]/2)*T;this.YN({p:["drawLine","error",S,U+aa,S+au,U+aa,L,ah,"butt",false,false,true],i:f,g:ao,t:ag,h:this.Cs(f[0],f[1])});this.YN({p:["drawLine","error",S,U+aa,S-au,U+aa,L,ah,"butt",false,false,true],i:f,g:ao,t:ag,h:this.Cs(f[0],f[1])})}}}else{A.push([Number.NaN,U+aa,V[af][ae]/2,f])}}}if(this.showErrorBars&&this.isGroupedData&&an[af]&&an[af]&&this.tc(an[af][0],true)&&this.tc(an[af][1],true)){var S=ac+((an[af][0]-ab)*T);var au=(an[af][1]/2)*T;var f=aw?[aw[af][0][0],aw[af][0][1],"error"]:false;this.YN({p:["drawShape","diamond",S,U,this.margin*this.errorBarsThickness,this.margin*this.errorBarsThickness,this.errorBarsColor,this.errorBarsColor,"closed",false,false,W],h:this.Cs(false,false,"Var-"+aw[af][0][0]),t:ag});this.YN({p:["drawLine","line",S-au,U,S+au,U,this.errorBarsColor,this.errorBarsThickness,"butt",false,false,W],h:this.Cs(false,false,"Var-"+aw[af][0][0]),t:ag})}U+=this.eO(X)?X[af+1]-X[af]:X}}if(this.connectBy&&this.data.x&&this.data.x.hasOwnProperty(this.connectBy)&&this.isRawData){var g=this.meta.data.x[this.connectBy];var G=0;var ai=this.b6(this.connectByData);var b=this.P8(ai.length);var K={};if(this.isGraphTime){for(var af=0;af<this.timeValueIndices.length;af++){if(this.timeValueIndices[af]>0){K[af.toString()]=this.timeValueIndices[af]}}}for(var af in this.connectByData){var ao;var O=null;var ap=this.connectByData[af];var L=this.connectByNoColor?this.connectByColor:g&&g.type!="Numeric"?g.connects[g.order[af]%g.connects.length]:b[G%b.length];if(ap.length>1){for(var ae=1;ae<ap.length;ae++){var S=this.isGraphTime?A[K[ap[ae-1]]]:A[ap[ae-1]];var au=this.isGraphTime?A[K[ap[ae]]]:A[ap[ae]];if(S&&au){ao=this.YN({p:["drawLine","line",S[0],S[1],au[0],au[1],L,this.connectByWidth,"butt",S[2],au[2],W],i:["Line:"+this.connectBy+" "+af,S[3][0],S[3][2],au[3][2]],g:O,t:ag,h:this.Cs(false,S[3][2])});if(O==null){O=ao}}}}G++}}else{if(this.connectBy&&this.data.z&&this.data.z.hasOwnProperty(this.connectBy)&&this.isRawData){this.connectByDataVar.push(A);if(I){var g=this.connectBy==this.colorBy?this.meta.data.z[this.colorBy]:false;for(var af in this.connectByData){var ap=this.connectByData[af];if(ap.length>1){for(var ad=0;ad<this.connectByDataVar[0].length;ad++){for(var ae=1;ae<ap.length;ae++){var S=this.connectByDataVar[ap[ae-1]][ad];var au=this.connectByDataVar[ap[ae]][ad];var ak=af;if(S&&au){var B=this.data.y.vars[S[3][0]];var aj=this.data.y.vars[au[3][0]];var z=this.data.y.smps[S[3][(this.isGroupedData?2:1)]];var x=this.data.y.smps[au[3][(this.isGroupedData?2:1)]];if(z==x){ak=B+" - "+aj+" ("+z+")"}else{ak=B+" ("+z+") - "+aj+" ("+x+")"}}this.YN({p:["drawLine","line",S[0],S[1],au[0],au[1],this.connectByColor,this.connectByWidth,"butt",S[2],au[2],W],i:["Line:"+this.connectBy+" "+ak],t:ag,h:this.Cs(false,S[3][2])})}}}}}}}};this.Pk=function(I,D,x,k,F,H,M,G,A,L,z){var s=1;var g=D;var y=0.75;var C=this.meta.vals;var K=this.plotInfo.variables;if(!C.colors){C.colors={}}for(var E=0;E<I.length;E++){var n=I[E];var J=this.isContour?"rgba(0,0,0,0)":n==null||!this.tc(n,true)?this.missingDataColor:C.colors[n.toString()]?C.colors[n.toString()]:this.eN(L,n);var B=H&&z?this.a0(J,z,true):H?J:this.heatmapCellBoxColor;var j=K[E].xy+(y/2);C.colors[n==null?"null":n.toString()]=J;if(z){J=this.a0(J,z,true)}if(this.graphType=="Network"){if(this.shapeByShape){this.YN({p:["drawShape",this.shapeByShape,D+(k/2),x+(F/2),k/2,F/2,J,B,A[E]],i:M[E],m:G,t:"Decorations",h:this.Cs(M[E])})}else{this.YN({p:["drawShape","rectangle",D+(k/2),x+(F/2),k,F,J,J,A[E]],i:M[E],m:G,t:"Decorations",h:this.Cs(M[E])})}}else{if(this.shapeByShape){this.YN({p:["drawShape",this.shapeByShape,j+(k/2),x+(F/2),k/2,F/2,J,B,A?A[E]:false],i:M[E],m:G,t:"Data",h:this.Cs(M[E][0],M[E][1])})}else{if(E>0&&E<I.length-1){if(s>=1){this.YN({p:["drawShape","rect",j,x+((F+y)/2),k+y,F+y,J,J,A?A[E]:false],i:M[E],m:G,b:[g,x+((F+y)/2),0,F+y],h:this.Cs(M[E][0],M[E][1]),t:"Data"});s=0}}else{this.YN({p:["drawShape","rect",j,x+((F+y)/2),k+y,F+y,J,J,A?A[E]:false],i:M[E],m:G,b:[g,x+((F+y)/2),0,F+y],h:this.Cs(M[E][0],M[E][1]),t:"Data"})}}}if(this.showDataValues){this.YN({p:["drawText",this.qY(n),(j+((k+y)/2))-2,(x+F)-2,this.smpTextFont,this.foreground,"right","bottom"],t:"Data"})}D+=k;s+=k}};this.Vd=function(B,u,p,C,D){var f=this;var r=this.graphOrientation=="vertical"?this.top+this.y:this.left;var k=function(d,c){if(c){f.YN({p:["drawShape","rectangle",(d.coords.left+u)+(d.coords.width/2),(d.coords.top+p)+(d.coords.height/2),d.coords.width,d.coords.height,false,f.fE(d.color),"open",false,d.outline,C,D],b:r,t:"Data"})}else{f.YN({p:["drawShape","rectangle",(d.coords.left+u)+(d.coords.width/2),(d.coords.top+p)+(d.coords.height/2),d.coords.width,d.coords.height,f.Fg(d.color,d.index),f.fE(d.color,d.index),"closed",false,false,C,D],i:d.index,b:r,t:"Data",h:f.Cs(d.index[0],d.index[1])})}if(d.label){var b=f.uo(d.label,f.overlayTextFont);if(b+f.margin<d.coords.width&&f.overlayTextFontSize+f.margin<d.coords.height){if(c){f.YN({p:["drawText",d.label,d.coords.left+u+(d.coords.width/2),d.coords.top+p+(d.coords.height/2),f.overlayTextFont,f.a0(f.foreground,0.5,true),"center","middle"],t:"Data"})}else{f.YN({p:["drawText",d.label,d.coords.left+u+f.margin,d.coords.top+p+f.margin,f.overlayTextFont,f.foreground,"left","top"],t:"Data"})}}else{if(b+f.margin<d.coords.height&&f.overlayTextFontSize+f.margin<d.coords.width){if(c){f.YN({p:["drawText",d.label,d.coords.left+u+(d.coords.width/2),d.coords.top+p+(d.coords.height/2),f.overlayTextFont,f.a0(f.foreground,0.5,true),"center","middle",-Math.PI/2],t:"Data"})}else{f.YN({p:["drawText",d.label,d.coords.left+u+f.margin,d.coords.top+p+f.margin,f.overlayTextFont,f.foreground,"right","top",-Math.PI/2],t:"Data"})}}}}};var s=function(c){for(var b=0;b<c.length;b++){if(c[b].children){s(c[b].children);k(c[b],true)}else{k(c[b])}}};for(var v=0;v<B.length;v++){var a=B[v];var q=this.treemapBorderWidth&&!this.isDOE?1:0;var E=this.isDOE?0:this.treemapBorderWidth;var o=E*2;var e=this.smpTextFontSize*q;var g=this.treemapBorderColor;var m=u+a.coords.left-E;var j=p+a.coords.top-(e+E);var n=a.coords.width+o;var A=a.coords.height+e+o;if(a.title){this.YN({p:["disableGradientTransparencyShadow"],t:"Data"});if(a.coords.border>1){this.YN({p:["drawShape","rectangle",m+(n/2),j+((e+(E/2))/2),n,e+(E/2),g,g,"close",false,E,C,D],t:"Data"});this.YN({p:["drawShape","rectangle",m+(n/2),j+(A/2),n,A,false,g,"open",false,E,C,D],t:"Data"})}else{if(a.coords.border>0){this.YN({p:["drawShape","rectangle",m+(n/2),(j+(e+E))+((A-(e+E))/2),n,A-(e+E),false,g,"open",false,E,C,D],t:"Data"})}else{if(a.coords.border>-1){this.YN({p:["drawShape","rectangle",m+(n/2),(j+(e+E))+((A-(e+E))/2),n,A-(e+E),false,g,"open",false,E,C,D],t:"Data"})}}}var z=this.uo(a.title,this.smpTextFont);if(z+this.margin<n&&this.smpTextFontSize<=e&&a.coords.height>e+(E/2)){this.YN({p:["drawText",a.title,m+this.margin,j+(this.smpTextFontSize/2),this.smpTextFont,this.foreground,"left","middle"],t:"Data"})}this.YN({p:["enableGradientTransparencyShadow"],t:"Data"})}if(a.children){s(a.children)}else{k(a)}}};this.s3=function(c){var g=c.links[0].target.x-c.links[0].source.x;for(var a=0;a<c.links.length;a++){var e=c.links[a];var b=this.colorBy?this.Cs(false,false,"Property:"+this.colorBy+":"+e.meta+":x"):false;this.YN({p:["drawShape","bezier",e.plotX,e.plotY,g,e.dy,this.Fg(e.color),this.sankeyOutlineColor,false,e.colors],i:e.tooltip,b:[this.left,this.top+this.y/2,g,e.dy],t:"Data",h:b})}for(var a=0;a<c.nodes.length;a++){var f=c.nodes[a];this.YN({p:["drawShape","rectangle",f.plotX+(f.dx/2),f.plotY+(f.dy/2),f.dx,f.dy,f.color,this.foreground],i:f.tooltip,b:[this.left,this.top+this.y/2,f.dx,f.dy],t:"Data"});if(this.sankeyLabelShow){this.YN({p:["drawText",f.name,f.plotX+(f.dx/2)+this.sankeyLabelMargin,f.plotY+(f.dy/2),this.sankeyLabelFont,this.sankeyLabelColor,this.sankeyLabelAlign,this.sankeyLabelBaseline,-this.sankeyLabelRotate*Math.PI/180],i:[f.tooltip[0]+":T"],t:"Data"})}}};this.pi=function(a,f){if(this.data.tree&&this.data.tree.plot){var l=this.data.tree.plot;var k=this.treeNodeSize;var d=k/2;var h=k/4;var e=a=="vertical"?true:false;var g=this;var j=function(u){var m=e?u.x0:u.y0;var t=e?u.y0:u.x0;var q=g.Cs(false,u.id);g.YN({p:["drawShape",u.data.shape,m,t,u.data.size,u.data.size,g.Fg(u.data.color,u.id),g.treeNodeOutlineColor,u.data.pattern,false,g.treeLinkWidth],i:["Tree-Node:"+u.id],b:[b,i],t:"Data",h:q});if(u.children){for(var p=0;p<u.children.length;p++){j(u.children[p])}if(g.treeCircular){var o=(Math.PI/2)-u.angle;var r=(((k/2)+g.margin)*Math.cos(o))*(g.treeInverted?-1:1);var s=(((k/2)+g.margin)*Math.sin(o))*(g.treeInverted?-1:1);if(u.angle<=Math.PI){g.YN({p:["drawText",u.data.name,m-r,t-s,g.smpTextFont,g.smpTextColor,g.treeInverted?"left":"right","middle",o],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}else{g.YN({p:["drawText",u.data.name,m-r,t-s,g.smpTextFont,g.smpTextColor,g.treeInverted?"right":"left","middle",o-Math.PI],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}else{if(e){if(u.parent){g.YN({p:["drawText",u.data.name,m,t-((k/2)+g.margin),g.smpTextFont,g.smpTextColor,"right","middle",Math.PI/2],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}else{g.YN({p:["drawText",u.data.name,m,t-((k/2)+g.margin),g.smpTextFont,g.smpTextColor,"center","bottom"],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}else{g.YN({p:["drawText",u.data.name,m-((k/2)+g.margin),t,g.smpTextFont,g.smpTextColor,"right","middle"],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}}else{if(g.treeCircular){var o=(Math.PI/2)-u.angle;var r=(((k/2)+g.margin)*Math.cos(o))*(g.treeInverted?-1:1);var s=(((k/2)+g.margin)*Math.sin(o))*(g.treeInverted?-1:1);if(u.angle<=Math.PI){g.YN({p:["drawText",u.data.name,m+r,t+s,g.smpTextFont,g.smpTextColor,g.treeInverted?"right":"left","middle",o],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}else{g.YN({p:["drawText",u.data.name,m+r,t+s,g.smpTextFont,g.smpTextColor,g.treeInverted?"left":"right","middle",o-Math.PI],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}else{if(e){g.YN({p:["drawText",u.data.name,m,t+(k/2)+g.margin,g.smpTextFont,g.smpTextColor,"left","middle",Math.PI/2],i:["Tree-Text-:"+u.id],b:[b,i],t:"Data",h:q})}else{g.YN({p:["drawText",u.data.name,m+(k/2)+g.margin,t,g.smpTextFont,g.smpTextColor,"left","middle"],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}}if(u._children){g.YN({p:["drawLine","line",m-h,t,m+h,t,g.foreground],i:["Tree-Line1:"+u.id],b:[b,i],t:"Data",h:q});g.YN({p:["drawLine","line",m,t-h,m,t+h,g.foreground],i:["Tree-Line2:"+u.id],b:[b,i],t:"Data",h:q})}else{if(u.children){g.YN({p:["drawLine","line",m-h,t,m+h,t,g.foreground],i:["Tree-Line1:"+u.id],b:[b,i],t:"Data",h:q})}}};var c=function(u){if(u.children){for(var o=0;o<u.children.length;o++){c(u.children[o])}}if(u.parent){var m=e?u.x0:u.y0;var t=e?u.y0:u.x0;var q=e?u.parent.x0:u.parent.y0;var s=e?u.parent.y0:u.parent.x0;var r=u._clicked?[q,s,q,s]:[b,i,b,i];var p=g.Cs(false,u.id);g.YN({p:["drawLine","bezier",q,s,m,t,g.treeLinkColor,g.treeLinkWidth,false,false,false,false,false,false,false,false,false,g.treeCircular?[u.mx,u.my,u.mx2,u.my2]:false],i:[u.parent.id+":"+u.id],b:r,t:"Data",h:p});u._clicked=false}};var b=e?l.x0:l.y0;var i=e?l.y0:l.x0;c(l);if(!f){j(l)}}};this.xN=function(c){if(this.QT()){return}var b=[];this.wT(false,this.varIndices,this.smpIndices);this.varIndicesStart=0;for(var a=0;a<Math.min(c,this.varIndices.length);a++){b.push(this.varIndices[a])}this.varIndices=b;this.dG({func:"zoomOncoprintVariables",par:[c]})}};CanvasXpress.prototype.init3dUtils=function(){this.gV=function(){if(!this.meta.math){this.meta.math={sin:[0],cos:[1]};for(var b=1;b<=360;b++){var a=Math.PI/(180/b);this.meta.math.sin[b]=Math.sin(a);this.meta.math.cos[b]=Math.cos(a)}}};this.v6=function(){this.gV();var a=["xRotate","yRotate","zRotate"];for(var b=0;b<a.length;b++){if(this[a[b]]>360){this[a[b]]-=360}if(this[a[b]]<0){this[a[b]]=360}}};this.Lz=function(){var b=this.zoom;var a=this.x;this.perspective=a*this.perspectiveFactor;this.lenX=a/4*b*this.x3DRatio;this.lenY=a/4*b*this.y3DRatio;this.lenZ=a/4*b*this.z3DRatio;this.padX=a/2;this.padY=this.y/2;this.padZ=this.padY};this.pf=function(g,a,k){var f,e,b;var h=[];var n=this.meta.math.sin;var j=this.meta.math.cos;var d=this.perspective;var m=this.xRotate;var l=this.yRotate;var i=this.zRotate;e=a;b=k;a=e*j[parseInt(l)]-b*n[parseInt(l)];k=e*n[parseInt(l)]+b*j[parseInt(l)];f=g;b=k;g=b*n[parseInt(m)]+f*j[parseInt(m)];k=b*j[parseInt(m)]-f*n[parseInt(m)];f=g;e=a;g=f*j[parseInt(i)]-e*n[parseInt(i)];a=f*n[parseInt(i)]+e*j[parseInt(i)];if(this.perspective){g=g*(d/(k+d));a=a*(d/(k+d));k=k*(d/(k+d))}h.push(g+this.padX);h.push(a+this.padY);h.push(k+this.padZ);return h}};CanvasXpress.prototype.initApiUtils=function(){this.uw=function(){return this.validGraphTypes};this.xy=function(){this.initializeAttributes()};this.xl=function(){if(this.graphType.match(/Scatter/)||this.graphType=="Bar"){return true}else{return false}};this.up=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&this.graphType!="Heatmap"){return true}else{return false}};this.m2=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&this.graphType!="Heatmap"&&this.graphType!="Pie"){return true}else{return false}};this.qL=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){return true}else{return false}};this.MX=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.graphType.match(/Scatter/)){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}return true}else{return false}};this.gk=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.graphType.match(/Scatter/)){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}if(this.data.x){return true}else{return false}}else{return false}};this.Yi=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){if(this.graphType=="Correlation"&&this.correlationAxis!="variables"){return false}return true}else{return false}};this.sG=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Heatmap"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"){return true}else{return false}};this.fT=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&this.graphType!="Circular"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.yn=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.j9=function(){if(this.graphType!="Heatmap"&&(this.smpDendrogramNewick||this.varDendrogramNewick)){return true}else{return false}};this.U1=function(){var b=["linear","exponential","logarithmic","power","polynomial","regression","normal","nonlinear","area","line","reg","nor","nlfit"];if(this.decorations){for(var a=0;a<b.length;a++){if(this.decorations[b[a]]){return true}}}else{return false}};this.e9=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.jD=function(){var e=["line"];var c=["","dashed","dotted","bezierY","bezierX","curved"];var a=["arrow","arrowHead","arrowTail","arrowHeadSquareTail","arrowTailSquareHead","square","squareHead","squareTail","squareHeadArrowTail","squareTailArrowHead"];for(var d=0;d<a.length;d++){e.push(a[d]+"Line")}for(var d=1;d<c.length;d++){for(var b=0;b<a.length;b++){e.push(c[d]+this.T5(a[b])+"Line")}}return e};this.ti=function(c){var a=["circle","sphere","box","rect","rectangle","rect2","rect3","roundrect","brace","square","triangle","triangle2","equilateral","equilateral2","star","diamond","rhombus","pentagon","hexagon","octagon"];a=a.concat(["oval","oval2","oval3","arc","arc2","arc3","arch","path","polygon","roundpolygon","spline","hull","violin","confidence","bezier","ellipse","ellipse2","ellipse2","plus","minus"]);a=a.concat(["pie","pie0","pie1","pie2","pie3","pie4","pie5","pie6","pie7","pie8","pie9","pacman","pacman2","mdavid","image"]);a=a.concat(["pch0","pch1","pch2","pch3","pch4","pch5","pch6","pch7","pch8","pch9","pch10","pch11","pch12","pch13","pch14","pch15","pch16","pch17","pch18","pch19","pch20","pch21","pch22","pch23","pch24","pch25"]);for(var b=0;b<a.length;b++){if(a[b]==c){return true}}return false};this.ma=function(){var c=[];var d=["blue","red","green","yellow","cyan","purple","white","black"];for(var b=0;b<d.length;b++){c.push(d[b]);for(var a=0;a<d.length;a++){if(d[b]!=d[a]){c.push(d[b]+"-"+d[a])}}}return c};this.DN=function(b,a){if(b.match(/^Bar$|^Line$|Boxplot|Dotplot/)){return a.match(/^Bar$|^Line$|Boxplot|Dotplot/)?true:false}else{return false}};this.TG=function(){return !this.graphType.match(/Scatter|Network|Venn|Genome|Circular|Correlation/)};this.Sp=function(){return this.graphType.match(/BarLine|StackedLine|StackedPercentLine|AreaLine|DotLine/)};this.Op=function(){return this.showHistogram&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>0};this.Wp=function(c,b,d){var a=d?"highlightVar":"highlightSmp";this.ub(c,b,a)};this.b2=function(a){return this.NB(a?this.highlightVar:this.highlightSmp)};this.S0=function(g){if(this.QT()){return}var e=[];if(!this.eO(g)){for(var d=0;d<arguments.length;d++){e.push(this.gg(arguments[d]))}g=this.gg(e)}else{e=this.gg(g)}var b;var c=this;var a=e.shift();var f=this.gg(e);while(f.length>1){b=f.shift();if(!c[b]){c[b]={}}c=c[b]}b=f.shift();c[b]=b=="showLegend"?!c[b]:isNaN(a)?a:Number(a);this.dG({func:"modifyOverlaysProperties",par:[g]})};this.wb=function(b,a){this.ub(b,a,"smpOverlays")};this.Sq=function(b,a){this.ub(b,a,"varOverlays")};this.A8=function(){return this.NB(this.smpOverlays)};this.yK=function(){return this.NB(this.varOverlays)};this.Oc=function(){var b=[];if(this.data.x){for(var a in this.data.x){b.push(a)}}return b};this.mB=function(){var b=[];if(this.data.z){for(var a in this.data.z){b.push(a)}}return b};this.V4=function(){return this.graphType.match(/Scatter/)?this.mB():this.Oc()};this.SS=function(){return[].concat(this.Oc()).concat(this.mB())};this.Dd=function(){return this.graphType.match(/scatter/i)?this.p6():this.getVariablesAsArray};this.p6=function(){var d=this.yV();var b=[];for(var c=0;c<d.length;c++){b.push(d[c].name)}return b};this.fZ=function(){var d=this.Uf();var b=[];for(var c=0;c<d.length;c++){b.push(d[c].name)}return b};this.Js=function(a){return this.U0("nodes",a)};this.sn=function(a){return this.U0("edges",a)};this.vK=function(c){for(var a in c){if(c[a]["t"]=="numeric"){var b=this.b6(c[a]["o"]);if(b.length==2&&(c[a]["o"].hasOwnProperty("true")&&c[a]["o"].hasOwnProperty("false"))){c[a]["t"]="string"}else{if(b.length==1&&(c[a]["o"].hasOwnProperty("true")||c[a]["o"].hasOwnProperty("false"))){c[a]["t"]="string"}else{if(b.length==1&&c[a]["o"].hasOwnProperty("")){c[a]["t"]="string"}}}}}};this.k5=function(l,r,q,k,s){var h={smps:{idx:"smpIndices",spc:"x"},vars:{idx:"varIndices",spc:"z"}};var c={};c[l]={o:{},t:"string"};if(r){c[l]["o"]=this.NB(this.data.y[l])}else{for(var f=0;f<this[h[l]["idx"]].length;f++){c[l]["o"][this.data.y[l][this[h[l]["idx"]][f]]]=true}}if(k||s){var n=k?this.FP(q):this.u4(q,true);if(this.eO(q)){for(var b=0;b<q.length;b++){var n=k?this.FP(q[b]):this.u4(q[b],true);if(n>-1){c[q[b]]={o:{},t:"numeric"};if(r){var e=this.meta.data.y.range[q[b]];c[q[b]]["o"]={min:e.min,max:e.max}}else{var g=[];if(k){for(var f=0;f<this.smpIndices.length;f++){g.push(this.data.y.data[n][this.smpIndices[f]])}}else{for(var f=0;f<this.varIndices.length;f++){g.push(this.data.y.data[this.varIndices[f]][n])}}var a=this.ID(g);c[q[b]]["o"]={min:a[0],max:a[1]}}}}}else{var n=k?this.FP(q):this.u4(q,true);if(n>-1){c={};c[q]={o:{},t:"numeric"};if(r){var e=this.meta.data.y.range[q];c[q]["o"]={min:e.min,max:e.max}}else{var g=[];if(k){for(var f=0;f<this.smpIndices.length;f++){g.push(this.data.y.data[n][this.smpIndices[f]])}}else{for(var f=0;f<this.varIndices.length;f++){g.push(this.data.y.data[this.varIndices[f]][n])}}var a=this.ID(g);c[q]["o"]={min:a[0],max:a[1]}}}}}if(this.data[h[l]["spc"]]){for(var j in this.data[h[l]["spc"]]){if(q&&j!=q){continue}var e=this.meta.data[h[l]["spc"]][j];c[j]={o:{},t:e.type.toLowerCase()};if(r){if(e.type=="Numeric"){c[j]["t"]="numeric";c[j]["o"]={min:e.rmin,max:e.rmax}}else{c[j]["t"]="string";c[j]["o"]=this.gg(e.levels)}}else{for(var f=0;f<this[h[l]["idx"]].length;f++){var d=this.PR(this[h[l]["idx"]][f],h[l]["spc"],j,true);if(!c[j]["o"].hasOwnProperty(d)){c[j]["o"][d]=true}}if(c[j]["t"]=="numeric"){var g=[];for(var d in c[j]["o"]){for(var f=0;f<c[j]["o"][d];f++){g.push(d)}}var a=this.ID(g);c[j]["o"]={min:a[0],max:a[1]}}}}}return c};this.U0=function(d,a){if(this.graphType=="Network"&&!this[d+"Data"]){this[d+"Data"]={};var f=this.meta.data[d];for(var b in f){if(f[b].type=="String"){this[d+"Data"][b]={o:f[b].order,t:f[b].type.toLowerCase()}}else{this[d+"Data"][b]={o:{min:f[b].rmin,max:f[b].rmax},t:f[b].type.toLowerCase()}}}if(this[d+"Properties"].length>0){for(var c=0;c<this.data[d].length;c++){var e=this.data[d][c];this.kp(e,this[d+"Data"],this[d+"Properties"])}}}if(this.graphType=="Network"){return a?this[d+"Data"]:this.b6(this[d+"Data"])}else{return false}};this.q5=function(g,j){var b={};b[g]={};if(this.graphType=="Network"){for(var e=0;e<this.data[g].length;e++){var d=this.data[g][e];if(j||(!j&&!d.hide)){for(var h in d){if(typeof(d[h])!="object"){if(b[g].hasOwnProperty(h)){b[g][h]["o"][d[h]]=true;if(isNaN(d[h])){b[g][h]["t"]="string"}}else{b[g][h]={o:{},t:isNaN(d[h])?"string":"numeric"};b[g][h]["o"][d[h]]=true}}}}if(this[g+"Properties"].length>0){this.kp(d,b,this[g+"Properties"])}}this.vK(b[g]);for(var h in b[g]){if(b[g][h]["t"]=="numeric"){var f=[];for(var c in b[g][h]["o"]){f.push(c)}var a=this.ID(f);b[g][h]["o"]={min:a[0],max:a[1]}}}}return b[g]};this.LI=function(a){if(!this.featuresData){var h={};var d=this.skipConfigurableProperties?this.NB(this.featureConfigurableProperties):{};for(var g=0;g<this.data.tracks.length;g++){var c=this.data.tracks[g];var b=c.data;for(var e=0;e<b.length;e++){var l=b[e];for(var k in l){if(!d[k]){if(typeof(l[k])!="object"){if(h.hasOwnProperty(k)){if(h[k]["o"].hasOwnProperty(l[k])){h[k]["o"][l[k]]=true}if(isNaN(l[k])){h[k]["t"]="string"}}else{h[k]={o:{},t:isNaN(l[k])?"string":"numeric"};h[k]["o"][l[k]]=true}}}}}if(this.featuresProperties.length>0){this.kp(b,h,this.featuresProperties)}}this.featuresData=h}return a?this.featuresData:this.b6(this.featuresData)};this.kp=function(d,e,h){for(var f=0;f<h.length;f++){var b=d;var k=false;if(h[f].length>0){for(var c=0;c<h[f].length;c++){var a=h[f][c];if(b[a]){b=b[a]}else{k=true;break}}if(!k){for(var g in b){if(typeof(b[g])!="object"){if(e.hasOwnProperty(g)){if(isNaN(b[g])){e[g]["t"]="string"}}else{e[g]={o:{},t:isNaN(b[g])?"string":"numeric",r:f};e[g]["o"][b[g]]=true}}}}}}};this.F8=function(){return["","like","not like",">",">=","<","<=","==","null","not null"]};this.nT=function(a){this.ZA(a,1)};this.X3=function(a){this.ZA(a,-1)};this.rw=function(d,c){if(this.QT()){return}this.clusterAxis="samples";if(d||!this.smpDendrogramNewick){this.smpDendrogramNewick=this.EY()}if(this.layoutValid&&!this.isDOE){var e=this.gg(this.smpDendrogram);var f=this.gg(this.varIndices);var a=this.gg(this.smpIndices);for(var b=0;b<this.data.l.weight.length;b++){if(!this.data.l.cluster[b]){this.data.l.cluster[b]={}}if(this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0){if(!this.data.l.cluster[b].smpDendrogram||this.data.l.cluster[b].smpDendrogram.leafs!=this.data.l.comp[b][1].length){this.varIndices=this.data.l.comp[b][0];this.smpIndices=this.data.l.comp[b][1];this.data.l.cluster[b].smpDendrogramNewick=this.EY()}}else{if(this.segregateSamplesBy.length>0){if(!this.data.l.cluster[b].smpDendrogram||this.data.l.cluster[b].smpDendrogram.leafs!=this.data.l.comp[b].length){this.smpIndices=this.data.l.comp[b];this.data.l.cluster[b].smpDendrogramNewick=this.EY()}}else{if(this.segregateVariablesBy.length>0){this.data.l.cluster[b].smpDendrogramNewick=this.smpDendrogramNewick}}}this.gY(this.data.l.cluster[b].smpDendrogramNewick,"smpDendrogram");this.data.l.cluster[b].smpDendrogram=this.smpDendrogram}this.varIndices=f;this.smpIndices=a;this.smpDendrogram=e}if(!c){this.dG({func:"clusterSamples",par:[d,c]})}};this.Z3=function(e,d){if(this.QT()){return}this.clusterAxis="variables";if(e||!this.varDendrogramNewick){this.varDendrogramNewick=this.EY()}if(this.layoutValid&&!this.isDOE){var b=this.gg(this.varDendrogram);var f=this.gg(this.varIndices);var a=this.gg(this.smpIndices);for(var c=0;c<this.data.l.weight.length;c++){if(!this.data.l.cluster[c]){this.data.l.cluster[c]={}}if(this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0){if(!this.data.l.cluster[c].varDendrogram||this.data.l.cluster[c].varDendrogram.leafs!=this.data.l.comp[c][0].length){this.varIndices=this.data.l.comp[c][0];this.smpIndices=this.data.l.comp[c][1];this.data.l.cluster[c].varDendrogramNewick=this.EY()}}else{if(this.segregateVariablesBy.length>0){if(!this.data.l.cluster[c].varDendrogram||this.data.l.cluster[c].varDendrogram.leafs!=this.data.l.comp[c].length){this.varIndices=this.data.l.comp[c];this.data.l.cluster[c].varDendrogramNewick=this.EY()}}else{if(this.segregateSamplesBy.length>0){this.data.l.cluster[c].varDendrogramNewick=this.varDendrogramNewick}}}this.gY(this.data.l.cluster[c].varDendrogramNewick,"varDendrogram");this.data.l.cluster[c].varDendrogram=this.varDendrogram}this.varIndices=f;this.smpIndices=a;this.varDendrogram=b}if(!d){this.dG({func:"clusterVariables",par:[e,d]})}};this.lP=function(e,d){if(this.QT()){return}this.clusterAxis="samples";if(!this.data.x){this.data.x={}}if(e||!this.data.x["k-Means-S"]){var a=this.iK();this.data.x["k-Means-S"]=[];for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];this.data.x["k-Means-S"][c]=a[b]}if(!this.smpOverlays.includes("k-Means-S")){this.smpOverlays.push("k-Means-S")}this.af("x","k-Means-S",false,true);this.F5("cat","smp","k-Means-S",true)}if(!d){this.dG({func:"kmeansSamples",par:[e,d]})}};this.n2=function(e,d){if(this.QT()){return}this.clusterAxis="variables";if(!this.data.z){this.data.z={}}if(e||!this.data.z["k-Means-V"]){var a=this.iK();this.data.z["k-Means-V"]=[];for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];this.data.z["k-Means-V"][c]=a[b]}if(!this.varOverlays.includes("k-Means-V")){this.varOverlays.push("k-Means-V")}this.af("z","k-Means-V",false,true);this.F5("cat","var","k-Means-V",true)}if(!d){this.dG({func:"kmeansVariables",par:[e,d]})}};this.ao=function(e,c,h,g){if(this.graphType=="Circular"&&this.circularType=="bubble"){var d=this.data.bubble.root.children;for(var f=0;f<d.length;f++){var a=d[f];if(a.data.name==e){a.label.x+=c;a.label.y+=h;if(!g){this.dG({func:"modifyLabelCoordinates",par:[e,c,h,g]})}else{this.Mz({func:"modifyLabelCoordinates",par:[e,c,h,g]})}return}}}}};CanvasXpress.prototype.initDimensionUtils=function(){this.hY=function(a,o,e){var c=this.margin;var j=this.meta.canvas.canvasPixelRatio;if(a||o||e){if(o||e){if(o){this.width=o;this.originalWidth=o}if(e){this.height=e;this.originalHeight=e}}else{if(a){this.width=this.originalWidth;this.height=this.originalHeight}}this.top=c+this.JR();this.left=c;this.right=c;this.bottom=c;this.oe()}if(!this.isSVG){this.meta.canvas.ctx.canvas.width=this.width*j;this.meta.canvas.ctx.canvas.height=this.height*j;this.meta.canvas.ctx.canvas.style.width=this.width+"px";this.meta.canvas.ctx.canvas.style.height=this.height+"px";this.meta.canvas.ctx2.canvas.width=this.width*j;this.meta.canvas.ctx2.canvas.height=this.height*j;this.meta.canvas.ctx2.canvas.style.width=this.width+"px";this.meta.canvas.ctx2.canvas.style.height=this.height+"px";this.meta.canvas.ctx.resetRender();this.meta.canvas.ctx2.resetRender();this.dl(j,j,this.meta.canvas.ctx);this.dl(j,j,this.meta.canvas.ctx2)}if(this.useLeaflet){return}if(this.graphType=="Scatter2D"&&this.scatterType=="visium"){this.backgroundType="panelImage"}this.YN({p:["disableGradientTransparencyShadow"],t:"Size"});if(this.backgroundType=="image"){if(this.graphType=="Network"){var n=this.scaleFactorX||1;var l=this.scaleFactorY||1;var b=this.offsetX*n;var q=this.offsetY*l;var k=this.maxX?this.maxX*n:this.maxX;var d=this.maxY?this.maxY*l:this.maxY;var p=this.colorNodeBy||(this.decorations.length&&this.showDecorations)?"b&w":false;CanvasXpress.system.isRStudio=this.zL()&&this.isR?true:false;if(CanvasXpress.system.isRStudio){this.YN({p:["drawShape","image",(k/2)+b,(d/2)+q,k,d,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}else{this.Np(CanvasXpress.cacheImages[this.Ng(this.backgroundImage)],0,0,this.maxX,this.maxY,b,q,k,d,p)}}else{this.YN({p:["drawShape","image",this.width/2,this.height/2,this.width,this.height,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}}else{if(this.backgroundType=="panelImage"){if(this.graphType=="Network"){this.YN({p:["drawShape","image",this.left+(this.x/2),this.top+(this.y/2),this.x,this.y,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}}else{if(this.backgroundType=="solid"||this.backgroundType=="panel"||this.backgroundType=="panelSolidGradient"){this.YN({p:["drawShape","rectangle",0+(this.width/2),0+(this.height/2),this.width,this.height,this.plotBackgroundColor,this.plotBackgroundBorderColor],t:"Size"})}else{var i=this.DJ(0,0,this.gradientOrientation=="vertical"?0:this.height,this.gradientOrientation=="vertical"?this.height:0);this.YN({p:["drawShape","rectangle",0+(this.width/2),0+(this.height/2),this.width,this.height,i,i],t:"Size"})}}}this.YN({p:["enableGradientTransparencyShadow"],t:"Size"})};this.gq=function(a,b){this.ym(a,false,b)};this.so=function(b,a){this.ym(false,b,a)};this.yJ=function(){return this.marginLeft+this.left+this.x+this.right+this.marginRight};this.c1=function(){return this.marginTop+this.top+this.y+this.bottom+this.marginBottom};this.ym=function(j,b,l,k,i,a){if(this.QT()){return}if(!this.resizable){return}if(j<5||b<5){return}if(j&&b){if(Math.abs(this.width-j)<5&&Math.abs(this.height-b)<5){}}if(!j||!this.resizableX){j=this.width}if(!b||!this.resizableY){b=this.height}var g=this.meta.canvas.ctx.canvas;j=g.originalWidth=parseInt(j);b=g.originalHeight=parseInt(b);this.vd(l);if(!this.reproducing){this.oF(true)}if(this.graphType=="Network"){this.scaleFactorX=null;this.scaleFactorY=null}this.dG({width:j,height:b,func:"setDimensions",par:[j,b,l,k,i,a]});this.rz();if(k){var d=this;setTimeout(function(){d.KF()},k)}else{this.KF()}if(i){try{i()}catch(f){}}};this.AR=function(){var a=this.margin;var b=this.meta.canvas.ctx.canvas;if(b.width){this.originalWidth=b.width;this.width=b.width}else{if(this.width){this.originalWidth=this.width;b.width=this.width}else{this.width=600;this.originalWidth=this.width;b.width=this.width}}if(b.height){this.originalHeight=b.height;this.height=b.height}else{if(this.height){this.originalHeight=this.height;b.height=this.height}else{this.height=600;this.originalHeight=this.height;b.height=this.height}}this.top=a+this.JR();this.left=a;this.right=a;this.bottom=a;this.x=this.width-(this.leftMargin+this.left+this.rightMargin+this.right);this.y=this.height-(this.topMargin+this.top+this.bottomMargin+this.bottom)}};CanvasXpress.prototype.initUtils=function(){this.initGeneralUtils();this.initPlotUtils();this.initConfigUtils();this.init3dUtils();this.initApiUtils();this.initDimensionUtils()};CanvasXpress.prototype.initLegendUtils=function(){this.on=function(){if(!this.legendInside){if(this.decorationsPosition!="right"&&this.decorationsPosition!="bottom"&&this.graphType!="Network"){this.decorationsPosition="bottom"}if(this.legendPosition&&!this.legendPosition.toLowerCase().match("top")&&!this.legendPosition.toLowerCase().match("bottom")&&!this.legendPosition.toLowerCase().match("right")&&!this.legendPosition.toLowerCase().match("left")){if(this.graphType!="Pie"){this.legendPosition="right"}}}if(this.graphType=="Pie"&&this.layoutValid){this.legendPosition="right"}if(!this.overlaysLegendPosition){this.overlaysLegendPosition="topRight"}if(this.layoutValid&&!this.EO("legendPosition")){var a=this.meta.config.orig;a.insideLegend=this.insideLegend;this.insideLegend=false;if(this.legendPosition!="top"&&this.legendPosition!="bottom"&&this.legendPosition!="right"&&this.legendPosition!="left"){a.legendPosition=this.legendPosition;this.legendPosition="right"}}};this.AS=function(){if(this.autoScaleFont){var e=(1-this.percentAspectRatioPlotArea);var b=this.layoutComb&&this.isDOE?this.layoutWidth:this.width;var c=this.layoutComb&&this.isDOE?this.layoutHeight:this.height;var a=this.m8(b*e,c*e);this.xx(a,"legendTextFont");this.xx(a,"legendTitleFont")}else{this.legendTextFont=this.legendTextFontStyle+" "+parseInt(this.legendTextFontSize)+"px "+this.fontName;this.legendTitleFont=this.legendTitleFontStyle+" "+parseInt(this.legendTitleFontSize)+"px "+this.fontName}};this.vX=function(c,o,m,f,k,i){var g="solid";var n=this.useRoundRectangles?"roundrect":"rectangle";var q=i?this.showDecorationsBorder:this.showLegendBorder;var j=i?this.decorationsBackgroundColor:this.legendBackgroundColor;var b=!q?"rgba(255,255,255,0)":i?this.decorationsBackgroundBorderColor:this.legendBackgroundBorderColor;var e=!q?0:i?this.decorationsBackgroundBorderSize:this.legendBackgroundBorderSize;var p=[0,0,this.width,this.height];this.Qy();this.YN({p:["drawShape",n,c+(m/2)-this.margin,o+(f/2),m,f,j,b,g,false,e,true,p],i:[-1],m:k,t:"Legends"});this.KY()};this.oP=function(l,k,n,f,b,c,g){this.vX(l,k,n,f,c,g);if(b&&this.showLegendTitle){var j=this.E1(this.legendTitleFont);var e=j/2;var a=this.legendTitleAlign=="center"?0:this.legendTitleAlign=="left"?-n/2:n/2;k+=this.legendTitleMargin+e;this.YN({p:["drawText",b,l+(n/2)+a,k,this.legendTitleFont,this.legendTitleColor,this.legendTitleAlign,"middle"],t:"Legends"})}};this.AW=function(m,k,o,q,j,l,a,n,d,f,e){return this.YN({p:["drawShape",o,m,k,q,q,j,l,a,false,n],i:d,g:f,t:"Legends",h:e})};this.wj=function(l,k,n,o,j,m,d,f,e){var b=l-(o/1.1);var a=l+(o/1.1);return this.YN({p:["drawLine",n,b,k,a,k,j,m],i:d,g:f,t:"Legends",h:e})};this.GU=function(a,m,d,k,l,b,j,e){return this.YN({p:["drawText",d,a,m,k,l,"left","middle"],i:b,g:j,t:"Legends",h:e})};this.pa=function(e,a,f,j,C,D,n,B,m,r,u,z,w){var o=this.legendTextMargin;var k=Math.max(j||0,Math.ceil(this.E1(this.legendTextFont)))+o;var E=Math.ceil(k/2);var A=Math.ceil(k*0.6);var v;if(this.isDataLabelsBackgroundColor){v=this.AW(e,a,"rectangle",k,C,this.dataTextColor,"closed",this.legendKeyBackgroundBorderSize,this.eO(u)?u:["legend-key-"+u],z,w)}else{v=this.AW(e,a,"rectangle",k,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.eO(u)?u:["legend-key-"+u],z,w)}if(!z){z=v}if(this.isDataLabelsBackgroundColor){this.YN({p:["drawText","a",e,a,this.legendTextFont,this.dataTextColor,"center","middle"],i:this.eO(u)?u:["legend-letter-"+u],g:z,t:"Legends",h:w})}else{this.YN({p:["drawText","a",e,a,this.legendTextFont,C,"center","middle"],i:this.eO(u)?u:["legend-letter-"+u],g:z,t:"Legends",h:w})}this.GU(e+E+o,a,r,this.legendTextFont,this.legendTextColor,this.eO(u)?u:["legend-text-"+u],z,w)};this.P5=function(e,a,f,j,C,D,n,B,m,r,u,z,w){var o=this.legendTextMargin;var k=Math.max(j||0,Math.ceil(this.E1(this.legendTextFont)))+o;var E=Math.ceil(k/2);var A=Math.ceil(k*0.5);var v=this.AW(e,a,"rectangle",k,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.eO(u)?u:["legend-key-"+u],z,w);if(!z){z=v}this.AW(e,a,f,A,C,D,n,1,this.eO(u)?u:["legend-shape-"+u],z,w);this.GU(e+E+o,a,r,this.legendTextFont,this.legendTextColor,this.eO(u)?u:["legend-text-"+u],z,w)};this.rf=function(e,a,f,j,C,D,n,B,m,r,u,z,w){var o=this.legendTextMargin;var k=Math.max(j[1],Math.ceil(this.E1(this.legendTextFont)))+o;var E=Math.ceil(k/2);var A=Math.ceil(j[0]);var v=this.AW(e,a,"rectangle",k,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.eO(u)?u:["legend-key-"+u],z,w);if(!z){z=v}this.AW(e,a,f,A,C,D,n,1,this.eO(u)?u:["legend-shape-"+u],z,w);this.GU(e+E+o,a,r,this.legendTextFont,this.legendTextColor,this.eO(u)?u:["legend-text-"+u],z,w)};this.Vi=function(e,a,j,k,E,F,o,D,n,u,v,A,z){var r=this.legendTextMargin;var m=Math.max(k[1],Math.ceil(this.E1(this.legendTextFont)))+r;var G=Math.ceil(m/2);var C=Math.ceil(k[0]);var w=this.AW(e,a,"rectangle",m,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.eO(v)?v:["legend-key-"+v],A,z);if(!A){A=w}var B=" "+parseInt((this.W9(k[0],k[1],j)/10)+14)+"px "+this.fontName;this.YN({p:["drawText","a",e,a,B,this.foreground,"center","middle"],i:this.eO(v)?v:["legend-letter-"+v],g:A,t:"Legends",h:z});this.GU(e+G+r,a,u,this.legendTextFont,this.legendTextColor,this.eO(v)?v:["legend-text-"+v],A,z)};this.a3=function(f,e,k,m,F,j,r,E,o,v,z,C,B){var u=this.legendTextMargin;var n=Math.max(m||0,Math.ceil(this.E1(this.legendTextFont)))+u;var G=Math.ceil(n/2);var D=Math.ceil(n*0.6);var a=Math.ceil(D*0.5);var b=(isNaN(j)||!j)?1.5:j;var A=this.AW(f,e,"rectangle",n,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.eO(z)?z:["legend-key-"+z],C,B);if(!C){C=A}this.wj(f,e,E,a,o,b,this.eO(z)?z:["legend-line-"+z],C,B);this.GU(f+G+u,e,v,this.legendTextFont,this.legendTextColor,this.eO(z)?z:["legend-text-"+z],C,B)};this.xS=function(f,e,j,k,D,E,o,C,n,u,v,A,z){var r=this.legendTextMargin;var m=Math.max(k||0,Math.ceil(this.E1(this.legendTextFont)))+r;var F=Math.ceil(m/2);var B=Math.ceil(m*0.6);var a=Math.ceil(B*0.5);var w=this.AW(f,e,"rectangle",m,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.eO(v)?v:["legend-key-"+v],A,z);if(!A){A=w}this.wj(f,e,C,a,n,j,this.eO(v)?v:["legend-line-"+v],A,z);this.GU(f+F+r,e,u,this.legendTextFont,this.legendTextColor,this.eO(v)?v:["legend-text-"+v],A,z)};this.WO=function(f,e,j,k,D,E,o,C,n,u,v,A,z){var r=this.legendTextMargin;var m=Math.max(k||0,Math.ceil(this.E1(this.legendTextFont)))+r;var F=Math.ceil(m/2);var B=Math.ceil(m*0.3);var a=Math.ceil(F*0.8);var w=this.AW(f,e,"rectangle",m,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.eO(v)?v:["legend-key-"+v],A,z);if(!A){A=w}this.AW(f,e,j,B,D,E,o,1,this.eO(v)?v:["legend-shape-"+v],A,z);this.wj(f,e,C,a,n,2.5,this.eO(v)?v:["legend-line-"+v],A,z);this.GU(f+F+r,e,u,this.legendTextFont,this.legendTextColor,this.eO(v)?v:["legend-text-"+v],A,z)};this.ty=function(k,j,m,n,H,I,v,G,u,z,B,E,D){var w=this.legendTextMargin;var o=Math.max(n||0,Math.ceil(this.E1(this.legendTextFont)))+w;var J=Math.ceil(o/2);var F=Math.ceil(o*0.75);var A=Math.ceil(o*0.4);var K=Math.ceil(F*0.6);var a=Math.ceil(F*0.5);var f=v||"solid";var e=this.plotStyle=="ggplotSwitched"?H:I;var r=this.plotStyle=="ggplotSwitched"?I:H;var C=this.AW(k,j,"rectangle",o,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.eO(B)?B:["legend-key-"+B],E,D);if(!E){E=C}this.YN({p:["drawLine",f,k,j-K,k,j+K,e,1],i:this.eO(B)?B:["legend-vline-"+B],g:E,t:"Legends",h:D});this.YN({p:["drawShape","rectangle",k,j,F,A,r,e,v,false,1],i:this.eO(B)?B:["legend-shape-"+B],g:E,t:"Legends",h:D});this.wj(k,j,f,a*1.1,e,1,this.eO(B)?B:["legend-hline-"+B],E,D);this.GU(k+J+w,j,z,this.legendTextFont,this.legendTextColor,this.eO(B)?B:["legend-text-"+B],E,D)};this.qd=function(j,f,k,m,F,G,u,E,o,w,z,C,B){var v=this.legendTextMargin;var n=Math.max(m||0,Math.ceil(this.E1(this.legendTextFont)))+v;var H=Math.ceil(n/2);var D=Math.ceil(n*0.75);var a=Math.ceil(D*0.35);var r=this.a0(F,0.5);var e=u||"solid";var A=this.AW(j,f,"rectangle",n,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.eO(z)?z:["legend-key-"+z],C,B);if(!C){C=A}this.AW(j,f,"rectangle",D,r,r,u,1,this.eO(z)?z:["legend-shape-"+z],C,B);this.wj(j,f,E,a,G,1.5,this.eO(z)?z:["legend-line-"+z],C,B);this.GU(j+H+v,f,w,this.legendTextFont,this.legendTextColor,this.eO(z)?z:["legend-text-"+z],C,B)};this.PT=function(j,f,k,m,F,G,r,E,o,v,z,C,B){var u=this.legendTextMargin;var n=Math.max(m||0,Math.ceil(this.E1(this.legendTextFont)))+u;var H=Math.ceil(n/2);var D=Math.ceil(n*0.75);var w=Math.ceil(n*0.3);var a=Math.ceil(D*0.5);var e=r||"solid";var A=this.AW(j,f,"rectangle",n,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.eO(z)?z:["legend-key-"+z],C,B);if(!C){C=A}if(this.graphOrientation=="vertical"){this.YN({p:["drawLine",e,j,f-a,j,f+a,G,1.5],i:this.eO(z)?z:["legend-line-"+z],g:C,t:"Legends",h:B});this.YN({p:["drawShape","circle",j,f-(w*0.7),w,w,F,G,r,false,1],i:this.eO(z)?z:["legend-shape-"+z],g:C,t:"Legends",h:B})}else{this.YN({p:["drawLine",e,j-a,f,j+a,f,G,1.5],i:this.eO(z)?z:["legend-line-"+z],g:C,t:"Legends",h:B});this.YN({p:["drawShape","circle",j+a-(w*0.3),f,w,w,F,G,r,false,1],i:this.eO(z)?z:["legend-shape-"+z],g:C,t:"Legends",h:B})}this.GU(j+H+u,f,v,this.legendTextFont,this.legendTextColor,this.eO(z)?z:["legend-text-"+z],C,B)};this.Ww=function(B,z,C,D,w,A,f,u,a,j,k,r,n){var e=this.legendTextMargin;var v=Math.max(D||0,Math.ceil(this.E1(this.legendTextFont)))+e;var m=Math.ceil(v/2);var o=this.AW(B,z,"rectangle",v,w,A,f,1,this.eO(k)?k:["legend-shape-"+k],r,n);if(!r){r=o}this.GU(B+m+e,z,j,this.legendTextFont,this.legendTextColor,this.eO(k)?k:["legend-text-"+k],r,n)};this.PG=function(){var a=Math.min(this.width,this.height);return Number(Math.max(0.5,a*(this.isCxplot?35:25)/833).toFixed(1))*this.legendTextScaleFontFactor};this.lq=function(k){var e=k.text.length;var x=this.PG();var B=k.size;if(B){for(var o=0;o<B.length;o++){if(B[o]){x=Math.max(x,B[o])}}}var A=this.uo(k.title&&this.showLegendTitle?k.title:"",this.legendTitleFont)+(this.legendTitleMargin*2);var j=this.uo(this.wS(k.text),this.legendTextFont);var v=this.E1(this.legendTextFont);var u=this.E1(this.legendTitleFont);var y=this.legendColumns>e?e:this.legendColumns;var a=Math.ceil(e/y);var z=Math.max(A,((j+x+(this.legendTextMargin*2))*y)+(this.legendTextMargin*2))+this.margin;var b=(a*(Math.max(x,v)+this.legendTextMargin))+this.legendTextMargin;var p=k.title&&this.showLegendTitle?b+u+(this.legendTitleMargin*2):b;if(!this.legend[k.id]){this.legend[k.id]={}}this.legend[k.id].columns=y;this.legend[k.id].meta=k;this.legend[k.id].width=z;this.legend[k.id].height=p};this.Xm=function(h,s,e,u){this.setPropertyLegendIter=u||0;if(this.setPropertyLegendIter>3){return}var a=this.I1(h)+"By";if((this[a]&&(this[a+"ShowLegend"]||this.graphType=="Network"))||h=="sample"){var w,j,t;if(s){w=this[a];if(e.type=="Numeric"&&((h.match(/shape/i)&&!this.shapeByContinuous)||(h.match(/size/i)&&!this.sizeByContinuous))){j=" "+s+" - "+s+" ";if(e){e.maxLevStrMod=j;e.isRange=true}}else{j=s}t=e&&e.sizes?e.sizes:this.sizes}else{if(this.data.x&&this.data.x.hasOwnProperty(this[a])){w=this[a];j=this.meta.data.x[this[a]].maxLevStrMod||this.meta.data.x[this[a]].maxLevStr;t=this.meta.data.x[this[a]].sizes||this.sizes}else{if(this.data.z&&this.data.z.hasOwnProperty(this[a])){w=this[a];j=this.meta.data.z[this[a]].maxLevStrMod||this.meta.data.z[this[a]].maxLevStr;t=this.meta.data.z[this[a]].sizes||this.sizes}else{if(a.match("Node")){w=this[a];j=this.meta.data.nodes[this[a]].maxLevStr;t=this.meta.data.nodes[this[a]].sizes||this.sizes}else{if(a.match("Edge")){w=this[a];j=this.meta.data.edges[this[a]].maxLevStr;t=this.meta.data.edges[this[a]].sizes||this.sizes}else{w=0;j=0;t=this.sizes}}}}}var q=this.PG();if(h=="size"||h=="sizeNode"||h=="sizeLabel"){for(var k=0;k<this.legend[h].n;k++){if(t[k]){q=Math.max(q,t[k])}}}else{if(h=="sample"){w=0;j=this.legend.sample.maxStr}}if(j.length>this.maxTextSize){j=j.substring(0,this.maxTextSize-3)+"..."}var o=this.E1(this.legendTextFont);var n=this.E1(this.legendTitleFont);var r=this.legendColumns;var y=r>this.legend[(h=="outline"?"color":h)].n?this.legend[(h=="outline"?"color":h)].n:r;var b=Math.ceil(this.legend[(h=="outline"?"color":h)].n/y);var v=this.showLegendTitle?this.uo(w,this.legendTitleFont):0;var x=((this.uo(String(j),this.legendTextFont)+Math.max(q,o)+this.legendTextMargin*3)*y)+(this.legendTextMargin*2)+this.margin;this.legend[(h=="outline"?"color":h)].columns=y;this.legend[(h=="outline"?"color":h)].width=Math.max(v,x);this.legend[(h=="outline"?"color":h)].height=(b*(Math.max(q,o)+this.legendTextMargin))+this.legendTextMargin+(h=="sample"?0:(this.showLegendTitle?n+(this.legendTitleMargin*2)+(n<16?n:0):0));if(this.graphType=="Map"&&this.mapProjection=="orthographic"){this.legend[(h=="outline"?"color":h)].width=0;this.legend[(h=="outline"?"color":h)].height=0}else{if(this.legend[(h=="outline"?"color":h)].height>this.height){this.legendColumns++;this.legend[(h=="outline"?"color":h)].columns++;this.maxTextSize=Math.max(10,this.maxTextSize-5);this.Xm(h,s,e,this.setPropertyLegendIter+1)}else{if(this.legend[(h=="outline"?"color":h)].width>this.width&&this.legend[(h=="outline"?"color":h)].columns>1){this.legendColumns--;this.legend[(h=="outline"?"color":h)].columns--;this.maxTextSize=Math.max(10,this.maxTextSize-5);this.Xm(h,s,e,this.setPropertyLegendIter+1)}}}}};this.qg=function(d,c){var a=this.I1(d)+"By";var n=0;var i=0;var k=this.E1(this.legendTextFont);var j=this.E1(this.legendTitleFont);if(this[a]||d=="decoration"||d=="contour"||d=="bin2d"){switch(d){case"color":case"colorNode":case"colorEdge":case"outline":case"decoration":case"contour":case"bin2d":var b=this.showLegendTitle?this.uo(this.colorBy||this.outlineBy||this.colorNodeBy||this.colorEdgeBy||"",this.legendTitleFont):0;var e=c.maxLevLen+(this.legendTextMargin*3);if(this.legendPosition.match(/top|bottom/)&&this.graphType!="Scatter2D"){i=(this.showLegendTitle?(j+this.legendTitleMargin):0)+this.heatmapIndicatorHeight+(this.legendTextMargin*2);n=this.heatmapIndicatorWidth+Math.max(b,e*2)}else{i=this.heatmapIndicatorWidth+(this.legendTextMargin*2)+(this.showLegendTitle?j+(this.legendTitleMargin*2):0);n=Math.max((this.heatmapIndicatorHeight+e+(this.legendTextMargin*3)),b)}break;case"shape":case"shapeNode":case"shapeEdge":case"size":case"sizeNode":case"sizeEdge":this.Xm(d,c.maxLevStr,c);return;case"pattern":case"patternNode":case"patternEdge":n=0;i=0;break}}this.legend[(d=="outline"?"color":d)].width=n;this.legend[(d=="outline"?"color":d)].height=i};this.S2=function(){this.legend.decoration.width=0;this.legend.decoration.height=0;this.legend.decoration.maxLabel=0;this.legend.decoration.columns=this.legendColumns;if(this.showDecorations&&this.showDecorationsLegend&&this.decorations){if(!this.legendInside){if(this.decorationsPosition!="right"&&this.decorationsPosition!="bottom"&&this.graphType!="Network"){this.decorationsPosition="bottom"}}var o=this.E1(this.decorationsTextFont);var h=this.decorations;var n=0;var m=["nlfit","reg","nor","area"];var g=[96,45,30,0,0,0,0];var k=[5,2,1,0,0,0,0];for(var f=0;f<m.length;f++){if(h[m[f]]){var b=k[f]?this.uo(this.KZ("%"+g[f]+"s","X"),this.decorationsTextFont)+(this.decorationsTextMargin*k[f])+this.decorationsTextMargin:0;var l=0;for(var c=0;c<h[m[f]].length;c++){var e=this.uo(h[m[f]][c].label,this.decorationsTextFont);l=Math.max(e,l);this.legend.decoration.maxLabel=Math.max(l,this.legend.decoration.maxLabel)}n=Math.max(n,this.decorationsTextMargin+l+this.decorationsTextMargin+b);this.legend.decoration.height=(h[m[f]].length*(o+this.decorationsTextMargin))+o+this.decorationsTextMargin}}if(this.graphType=="Map"&&h.pie&&h.pie[0]&&h.pie[0].smps&&h.pie[0].smps.length){var l=0;var a=this.E1(this.decorationsTextFont);for(var f=0;f<h.pie[0].smps.length;f++){var e=this.uo(h.pie[0].smps[f],this.decorationsTextFont);l=Math.max(e,l);this.legend.decoration.maxLabel=Math.max(l,this.legend.decoration.maxLabel)}n=Math.max(n,(l+(this.decorationsTextMargin*3)+(a*2))*Math.min(h.pie[0].smps.length,this.legend.decoration.columns));this.legend.decoration.height+=(Math.ceil(h.pie[0].smps.length/Math.min(h.pie[0].smps.length,this.legend.decoration.columns))*a*1.5)+(this.decorationsTextMargin*2)}this.legend.decoration.width=n}};this.r0=function(){this.legend.oncoprint.width=0;this.legend.oncoprint.height=0;this.legend.oncoprint.colors={};if(this.isOncoprint){var g=this.gg(this.meta.data[this.oncoprintCNA].levels);var h=this.gg(this.meta.data[this.oncoprintCNA].colors);var b=[];g.push("No Alteration");h.push("rgb(220,220,220");for(var e=0;e<g.length;e++){b.push("CNA")}var k=g.length;if(this.oncoprintMUT){g=g.concat(this.gg(this.meta.data[this.oncoprintMUT].levels));h=h.concat(this.gg(this.meta.data[this.oncoprintMUT].colors));for(var e=k;e<g.length;e++){b.push("MUT")}}var j=[];var f=[];for(var e=0;e<g.length;e++){if(g[e]){j.push(g[e]);f.push(b[e]);this.legend.oncoprint.colors[g[e]]=h[e];if(h[e]=="rgb(220,220,220"){this.legend.oncoprintMutations=j.length}}}var d=this.wS(j,this.legendTextFont);var c=this.uo(d,this.legendTextFont);var a=Math.ceil(c+5+(this.margin*8));var h=Math.floor(this.width/a);var l=Math.ceil(j.length/h);this.legend.oncoprint.width=a*h;this.legend.oncoprint.height=((21+this.margin)*l)+this.margin;this.legend.oncoprint.rows=l;this.legend.oncoprint.cols=h;this.legend.oncoprint.labels=j;this.legend.oncoprint.objects=f}};this.cd=function(){this.legend.sample.width=0;this.legend.sample.height=0;this.legend.sample.columns=this.legendColumns;this.legend.sample.maxStr="";this.legend.sample.maxStrLen=0;this.legend.sample.title=false;this.legend.sample.n=1;var b=this.PG();var l=Math.max(b,this.E1(this.legendTextFont));var a=this.E1(this.legendTitleFont);var e=this.meta.data.s?this.meta.data.s.density:false;var h=0;var k=0;var c=0;if(this.ridgeBy&&this.data.y.smps.length==1){return}if(this.showHistogram&&this.histogramAsDotplot){return}if(this.colorBy&&this.meta.data.x&&this.meta.data.x.hasOwnProperty(this.colorBy)&&((this.xAxisIndices&&this.xAxisIndices.length==1)||(this.yAxisIndices&&this.yAxisIndices.length==1))){return}if(this.graphType.match(/Scatter/)){k=this.ridgeBy?this.data.y.smps.length:Math.max(this.xAxisIndices.length,this.yAxisIndices.length);if(this.ridgeBy){h=this.uo(this.Cv(this.wS(this.data.y.smps),this.maxSmpStringLen),this.legendTextFont)}else{if(this.showHistogram&&e){if(this.Op()){if((e.hasOwnProperty("Samples")&&!this.segregateSamplesBy.length)||this.segregateVariablesBy.length){this.legend.sample.maxStr=this.Cv(this.meta.data.y.maxSmpStr,this.maxSmpStringLen);k=this.smpIndices.length}else{if(this.meta.data.z&&this.meta.data.z[this.showHistogram]){this.legend.sample.maxStr=this.Cv(this.meta.data.z[this.showHistogram].maxLevStr,this.maxSmpStringLen);k=e.layout[0].length}else{this.legend.sample.maxStr=this.Cv(this.meta.data.y.maxSmpStr,this.maxSmpStringLen);k=this.smpIndices.length}}}else{if(e.hasOwnProperty("Factor")){var j=this.b6(e.Factor);if(this.showHistogram&&this.showHistogram!==true){j.push(this.showHistogram);if(this.colorLegendTitle){this.legend.sample.title=this.showHistogram}c++}if(this.smpIndices.length==1){this.legend.sample.maxStr=this.Cv(this.wS(j),this.maxSmpStringLen)}else{j=[];for(var d=0;d<e.Global.sets.length;d++){j.push(e.Global.sets[d].name.replace(/^Factor:/,""))}this.legend.sample.maxStr=this.Cv(this.wS(j),this.maxSmpStringLen)}k=j.length-c}else{if(e.hasOwnProperty("Samples")){this.legend.sample.maxStr=this.Cv(this.meta.data.y.maxSmpStr,this.maxSmpStringLen);k=this.smpIndices.length}else{if(e.hasOwnProperty("Variables")){this.legend.sample.maxStr=this.Cv(this.meta.data.y.maxVarStr,this.maxSmpStringLen);k=this.varIndices.length}}}}if(!this.colorBy||k>1){h=this.uo(this.legend.sample.maxStr,this.legendTextFont)}}else{if(this.xAxisIndices.length!=this.yAxisIndices.length||this.xAxisIndices.length>1){if(this.xAxisIndices.length==this.yAxisIndices.length&&this.xAxisIndices.length>1){for(var d=0;d<this.xAxisIndices.length;d++){var g=this.Cv(this.xAxis[d],this.maxSmpStringLen)+" vs "+this.Cv(this.yAxis[d],this.maxSmpStringLen);var f=this.uo(g,this.legendTextFont);if(f>h){this.legend.sample.maxStr=g}h=Math.max(f,h)}}else{if(this.xAxisIndices.length>this.yAxisIndices.length){if(this.yAxisIndices.length==1){this.legend.sample.maxStr=this.Cv(this.wS(this.xAxis),this.maxSmpStringLen)}else{this.legend.sample.maxStr=this.Cv(this.wS(this.xAxis),this.maxSmpStringLen)+" vs "+this.Cv(this.yAxis[0],this.maxSmpStringLen)}h=this.uo(this.legend.sample.maxStr,this.legendTextFont)}else{if(this.yAxisIndices.length>this.xAxisIndices.length){if(this.xAxisIndices.length==1){this.legend.sample.maxStr=this.Cv(this.wS(this.yAxis),this.maxSmpStringLen)}else{this.legend.sample.maxStr=this.Cv(this.wS(this.yAxis),this.maxSmpStringLen)+" vs "+this.Cv(this.xAxis[0],this.maxSmpStringLen)}h=this.uo(this.legend.sample.maxStr,this.legendTextFont)}}}}}}if(h){this.legend.sample.n=k;this.legend.sample.maxStrLen=h;this.legend.sample.width=((l+h+(this.legendTextMargin*2))*(this.legend.sample.columns>k?k:this.legend.sample.columns))+(this.legendTextMargin*2);this.legend.sample.height=(Math.ceil(k/this.legend.sample.columns)*(l+this.legendTextMargin))+this.legendTextMargin+(((a+this.legendTitleMargin)*(this.colorLegendTitle?1:0))*c)}}};this.D4=function(o){if(this.showLegend){this.legend.variable.width=0;this.legend.variable.height=0;this.legend.variable.columns=o||(this.varIndices&&this.legendColumns>this.varIndices.length?this.varIndices.length:this.legendColumns);var h=this;var u=this.legend.variable.columns;if(!this.variableShowLegend){return}var i=function(){if(h.circularType.match(/normal/)){if(h.ringGraphType.length){for(var d=0;d<h.ringGraphType.length;d++){if(h.ringGraphType[d]!="heatmap"){return true}}return false}}return true};var g=function(){if(h.isDOE&&h.layoutCurrentDOE){if(h.layoutCurrentDOE){if(h.meta.data.x&&h.meta.data.x.hasOwnProperty(h.layoutCurrentDOE)){return h.meta.data.x[h.layoutCurrentDOE]}else{if(h.meta.data.z&&h.meta.data.z.hasOwnProperty(h.layoutCurrentDOE)){return h.meta.data.z[h.layoutCurrentDOE]}}}}return h.meta.data.y};var c=g();var x=this.PG();var a=Math.max(x,this.E1(this.legendTextFont));if(this.graphType=="Fish"){var v=this.E1(this.legendTextFont);var b=this.varIndices.length;var f=this.Cv(c.maxVarStr,this.maxVarStringLen);this.legend.variable.width=((a+(this.legendTextMargin*2)+this.uo(f,this.legendTextFont))*u)+(this.legendTextMargin*2);this.legend.variable.height=(Math.ceil(b/Math.min(b,u))*(v+this.legendTextMargin))+(this.legendTextMargin*2)}if(this.graphType=="Pie"){var b=this.varIndices.length>this.maxPieSectors?this.maxPieSectors:this.varIndices.length;var f=this.isDOE&&this.layoutCurrentDOE?this.Cv(c.maxLevStr,this.maxVarStringLen):this.Cv(c.maxVarStr,this.maxVarStringLen);if(this.maxPieSectors<this.varIndices.length&&f.length<5){f=this.Cv("Other",this.maxVarStringLen)}var e=this.uo(f,this.legendTextFont)+a+(this.legendTextMargin*3);var q=this.layoutComb&&this.isDOE?this.layoutWidth:this.width;var k=(1-this.percentAspectRatioPlotArea);this.legend.variable.width=e>q*k?q*k:this.uo(f,this.legendTextFont)+a+(this.legendTextMargin*5);this.legend.variable.height=((a+this.legendTextMargin)*b)+(this.legendTextMargin*2)}else{if(this.layoutValid&&this.segregateVariablesBy.length>0&&!this.graphType.match(/Scatter/)){if(this.segregateVariablesBy[0]=="variable"||(this.segregateVariablesBy.length>1&&this.segregateVariablesBy[1]=="variable")){return}else{if(!this.colorBy||(this.colorBy&&this.colorBy=="variable")){var v=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;var b=this.varIndices.length;this.legend.variable.width=((a+(this.legendTextMargin*2)+this.uo(v,this.legendTextFont))*u)+(this.legendTextMargin*2);this.legend.variable.height=(Math.ceil(this.varIndices.length/Math.min(b,u))*(a+this.legendTextMargin))+this.legendTextMargin}else{return}}}else{if((this.colorBy&&this.colorBy=="variable")||(this.shapeBy&&this.shapeBy=="variable")||(this.sizeBy&&this.sizeBy=="variable")||(this.patternBy&&this.patternBy=="variable")){var v=this.sizeBy&&this.sizeBy=="variable"?Math.max(this.sizes[this.varIndices.length-1],this.E1(this.legendTextFont)):this.E1(this.legendTextFont);var b=this.varIndices.length;var f=this.Cv(c.maxVarStr,this.maxVarStringLen);this.legend.variable.width=v+this.uo(f,this.legendTextFont)+((this.legendTextMargin*2)*Math.min(b,u))+(this.legendTextMargin*2);this.legend.variable.height=(Math.ceil(b/Math.min(b,u))*(v+this.legendTextMargin))+(this.legendTextMargin*2)}else{if(!this.colorBy&&(this.graphType=="BarLine"||this.graphType=="DotLine"||this.graphType=="AreaLine"||this.graphType=="StackedLine"||this.graphType=="StackedPercentLine")){var v=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;var b=this.xAxisVarIndices.length+this.xAxis2VarIndices.length;this.legend.variable.width=((a+(this.legendTextMargin*2)+this.uo(v,this.legendTextFont))*u)+(this.legendTextMargin*2);this.legend.variable.height=(Math.ceil(b/Math.min(b,u))*(a+this.legendTextMargin))+this.legendTextMargin}else{if(!this.colorBy&&(this.graphType=="Bar"||(this.graphType=="Line"&&!this.lineBy)||this.graphType=="Area"||this.graphType=="Dotplot"||this.graphType=="Stacked"||this.graphType=="StackedPercent"||this.graphType=="Boxplot")){var v=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;var b=this.varIndices.length;this.legend.variable.width=((a+(this.legendTextMargin*2)+this.uo(v,this.legendTextFont))*u)+(this.legendTextMargin*2);this.legend.variable.height=(Math.ceil(this.varIndices.length/Math.min(b,u))*(a+this.legendTextMargin))+this.legendTextMargin}else{if(this.graphType=="Circular"){if(!this.showIdeogram&&i()){var v=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;var j=this.rAxisIndex>=0?this.varIndices.length-1:this.varIndices.length;this.legend.variable.width=((a+(this.legendTextMargin*2)+this.uo(v,this.legendTextFont))*u)+(this.legendTextMargin*2);this.legend.variable.height=(Math.ceil(j/Math.min(j,u))*(a+this.legendTextMargin))+this.legendTextMargin}}}}}}}if(this.data.y&&this.data.y.unpivoted&&this.data.y.unpivoted.factor){var e=this.uo(this.Cv(this.data.y.unpivoted.factor,this.maxVarStringLen),this.legendTitleFont)+this.margin;var r=this.E1(this.legendTitleFont)+this.legendTitleMargin;this.legend.variable.width=Math.max(this.legend.variable.width,e);this.legend.variable.height+=r}if(this.legend.variable.height>this.height){this.legend.variable.columns++;this.maxVarStringLen=Math.max(10,this.maxVarStringLen-5);this.D4(this.legend.variable.columns)}}};this.jN=function(){var a=this.data.venn.legend?this.wS(this.data.venn.legend):"N/A";this.legend.width=this.uo(a,this.legendTextFont)+(this.margin*6);this.legend.height=this.margin+this.margin+((this.E1(this.legendTextFont)+this.margin)*this.vennGroups)};this.J4=function(){var b=this.E1(this.legendTextFont)+2;var t=this.PG();var l=Math.max(b,t);var d=["varOverlays","smpOverlays"];var f=["varOverlayProperties","smpOverlayProperties"];var z=["showVarOverlaysLegend","showSmpOverlaysLegend"];this.legend.overlays.layout=[];this.legend.overlays.width=0;this.legend.overlays.height=0;var r=this.margin;var p=this.margin;var a=0;var k=0;var n=0;var C=false;if(this.showOverlays&&(this.showVarOverlaysLegend||this.showSmpOverlaysLegend)&&this.graphType!="Circular"){for(var x=0;x<d.length;x++){if(this[d[x]].length>0&&this[z[x]]){for(var u=0;u<this[d[x]].length;u++){var g=0;var y=0;var q=this[d[x]][u];if(q!="-"){var B=d[x]=="varOverlays"?"z":"x";var s=this.meta.data[B][q];var v=this.uo(s.maxLevStr,this.legendTextFont);var A=this.uo(q,this.legendTitleFont);var e=this[f[x]][q].legendColumns||this[d[x]+"LegendColumns"];if(this.graphType=="Circular"||(this[f[x]][q]&&this[f[x]][q].showLegend)){C=true;if(this[f[x]][q].type=="Default"){if(s.type=="String"){g=Math.max(A,v+l+(this.margin*3))*e;y=((Math.max(b,t)+this.margin)*Math.ceil(s.levels.length/e))+b+this.margin}else{if(this.overlaysLegendPosition.match(/right/i)){g=Math.max(this.heatmapIndicatorHeight+(this.margin*2)+v,A);y=this.heatmapIndicatorWidth+(this.margin*3)+b}else{g=this.heatmapIndicatorWidth+(this.margin*3)+b;y=Math.max(this.heatmapIndicatorHeight+(this.margin*2)+v,A)}}}else{if(this[f[x]][q].type.match(/Area|Bar|Dotplot|Line|Stacked|Pie|Treemap/)){g=Math.max(b,t)+A+(this.margin*2);y=Math.max(b,t)+this.margin}else{continue}}if(!this.legend.overlays[q]){this.legend.overlays[q]={}}this.legend.overlays[q].width=g;this.legend.overlays[q].height=y;if(this.overlaysLegendPosition.match(/right/i)){if(k+this.margin+y>(this.height-(this.top+this.bottom))){r+=this.margin+g;a=g;k=y;if(this.legend.overlays.layout[n]){n++}this.legend.overlays.layout[n]=[[B,q,g,y]]}else{if(g>a){r+=(g-a);a=g}k+=y;if(!this.legend.overlays.layout[n]){this.legend.overlays.layout[n]=[]}this.legend.overlays.layout[n].push([B,q,g,y])}}else{if(a+this.margin+g>(this.width-(this.left+this.right))){p+=this.margin+y;a=g;k=y;if(this.legend.overlays.layout[n]){n++}this.legend.overlays.layout[n]=[[B,q,g,y]]}else{if(y>k){p+=(y-k);k=y}a+=g;if(!this.legend.overlays.layout[n]){this.legend.overlays.layout[n]=[]}this.legend.overlays.layout[n].push([B,q,g,y])}}}}}}}}if(this.overlaysLegendPosition.match(/right/i)){this.legend.overlays.width=C?r+(this.margin*3):0;this.legend.overlays.height=C?k+this.margin:0}else{this.legend.overlays.width=C?a+this.margin:0;this.legend.overlays.height=C?p+this.margin:0}};this.yg=function(){if(this.showDecorations&&this.showDecorationsLegend&&this.decorations){this.decorationLayout=[0]}if(this.showLegend){this.legend.layout=[];this.legend.width=0;this.legend.height=0;var a=this.margin;var l=this.margin;var c=0;var k=0;var j=0;var f=this.graphType=="Network"?["colorNode","shapeNode","sizeNode","patternNode","colorEdge","sizeEdge","decoration"]:this.scatterPlotMatrix?["color","shape","size","pattern","variable"]:this.connectByNoColor?["color","shape","size","pattern","variable","sample"]:["color","shape","size","line","pattern","connect","variable","overlays","sample","contour","bin2d","colorLabel","sizeLabel"];for(var d=0;d<f.length;d++){var b="show"+this.T5(f[d])+"Legend";var g=this.legend[f[d]].width;var e=this.legend[f[d]].height;if(f[d]=="decoration"&&!this.showDecorations){continue}if(f[d]=="size"&&this.graphType=="Map"&&this.decorations&&this.decorations.pie){continue}if(g>0){if(this.graphType=="Network"&&f[d]!="decoration"&&!this[b]){continue}if(this.graphType=="Heatmap"&&f[d]=="variable"){continue}if(this.legendPosition.match(/right|left/i)){if(k+this.margin+e>this.height){a+=this.margin+g;c=g;k=e;j++;this.legend.layout[j]=[f[d]]}else{if(g>c){a+=(g-c);c=g}k+=e;if(!this.legend.layout[j]){this.legend.layout[j]=[]}this.legend.layout[j].push(f[d])}}else{if(c+this.margin+g>this.width){l+=this.margin+e;c=g;k=e;this.legend.layout[d]=[f[d]];j++}else{if(e>k){l+=(e-k);k=e}c+=g;if(!this.legend.layout[j]){this.legend.layout[j]=[]}this.legend.layout[j].push(f[d])}}}}for(var d=0;d<this.customLegend.length;d++){this.customLegend[d].id="custom"+d;this.lq(this.customLegend[d]);var g=this.legend["custom"+d].width;var e=this.legend["custom"+d].height;if(this.legendPosition.match(/right|left/i)){if(k+this.margin+e>this.height){a+=this.margin+g;c=g;k=e;this.legend.layout[j]=[this.customLegend[d].id];j++}else{if(g>c){a+=(g-c);c=g}k+=e;if(!this.legend.layout[j]){this.legend.layout[j]=[]}this.legend.layout[j].push(this.customLegend[d].id)}}else{if(c+this.margin+g>this.width){l+=this.margin+e;c=g;k=e;this.legend.layout[d]=[this.customLegend[d].id];j++}else{if(e>k){l+=(e-k);k=e}c+=g;if(!this.legend.layout[j]){this.legend.layout[j]=[]}this.legend.layout[j].push(this.customLegend[d].id)}}}this.legend.width=c==0&&a==this.margin?0:this.legendPosition.match(/right|left/i)?a+this.margin:c+this.margin;this.legend.height=k==0&&l==this.margin?0:this.legendPosition.match(/right|left/i)?k+this.margin:l+this.margin}};this.bV=function(q){var f=this;var v=this.graphType=="Network"?["colorNode","shapeNode","sizeNode","patternNode","colorEdge","sizeEdge"]:this.connectByNoColor?["color","shape","size","pattern","outline"]:["color","shape","size","line","pattern","outline","connect","contour","bin2d","colorLabel","sizeLabel"];var c=["colorByData","shapeByData","sizeByData","patternByData","outlineByData"];var e=function(a,b,y){var B=b=="outline"?"color":b;var x=(f.I1(B)+"s").replace("Node","").replace("Edge","").replace("Label","").replace("decorations","colors");delete (f.legend[B].levels);f.legend[B].meta=a;f.legend[B].meta.title=f[B+"By"];if(y){if(f.colorSpectrumBreaks.length){f.legend[B].meta.vals=f.colorSpectrumBreaks}else{var p=f.Zh(y[0],y[1],5);for(var o=0;o<p.length;o++){p[o]=String(p[o]).length>5?p[o].toExponential():p[o]}f.legend[B].meta.vals=p}f.legend[B].meta.decs=f.ab(y[1]-y[0]);f.legend[B].meta.maxLevStr=f.wS(f.legend[(b=="outline"?"color":b)].meta.vals);f.legend[B].meta.maxLevLen=f.uo(f.legend[B].meta.maxLevStr,f.font);f.legend[B].meta.maxLevChr=f.legend[B].meta.maxLevStr.toString().length}else{var p=f.Zh(a.min,a.max,5);for(var o=0;o<p.length;o++){p[o]=String(p[o]).length>5?p[o].toExponential():p[o]}f.legend[B].meta.vals=p;f.legend[B].meta.maxLevStr=f.wS(p);f.legend[B].meta.maxLevLen=f.uo(f.legend[B].meta.maxLevStr,f.xAxisTextFont);f.legend[B].meta.maxLevChr=f.legend[B].meta.maxLevStr.toString().length}if(f.ridgeBy&&f.colorBy=="data"){f.legend[B].meta.min=f.legend[B].meta.vals[0];f.legend[B].meta.max=f.legend[B].meta.vals[f.legend[B].meta.vals.length-1]}f.legend[B].max=f.legend[B].meta.maxLevStr;f.legend[B].n=f.legend[B].meta.vals.length;if(!f.legend[B].m){f.legend[B].m=[]}for(var o=0;o<f.legend[B].meta.vals.length;o++){f.legend[B].m[f.legend[B].meta.vals[o].toString()]=B=="connect"?f.colors[o]:B=="contour"?f.eN(a,f.legend[B].meta.vals[o]):B=="bin2d"?f.eN(a,f.legend[B].meta.vals[o]):f[x][o%f[x].length]}f.qg(b,f.legend[B].meta)};var d=function(H,O,D,J,E){if(H){var L=0;var B=0;var G=false;var I={};var b={};var a=H[f.I1(J).replace("Node","").replace("Edge","").replace("Label","")+"s"]||f[f.I1(J).replace("Node","").replace("Edge","").replace("Label","")+"s"];var F=f.isGroupedData&&f.graphType!="Dotplot"&&f.graphType!="Boxplot"&&!f.showBoxplotOriginalData&&f.groupingFactors.length==1;if(O=="x"){var x;if(f.graphType=="Scatter2D"){x=f.xAxisIndices.length==1?f.yAxisIndices:f.yAxisIndices.length==1?f.xAxisIndices:f.smpIndices}else{x=f.isGroupedData?f.grpIndices:f.smpIndices}for(var M=0;M<x.length;M++){var y=x[M];if(f.isGroupedData&&(f.graphType=="Dotplot"||f.graphType=="Boxplot"||f.barType=="swimmer"||f.graphType=="Gantt"||f.stackBy||f.lineBy||f.dodgeBy)){f.isGroupedData=false;for(var K=0;K<f.data.w.grps[y].length;K++){var C=f.PR(f.data.w.grps[y][K],O,f[D]);b[C]=true}f.isGroupedData=true}else{var C;if(f.isGroupedData){f.isGroupedData=false;C=f.WE(f[D],f.data.w.grps[M],true);f.isGroupedData=true}else{C=f.PR(y,O,f[D])}b[C]=true}}}else{if(O=="z"){if((f.graphType=="Map"&&f.varIndices.length<H.levels.length)||f.histogramAsDotplot){for(var M=0;M<H.levels.length;M++){var C=H.levels[M];b[C]=true}}else{for(var M=0;M<f.varIndices.length;M++){var y=f.varIndices[M];var C=f.PR(y,O,f[D]);b[C]=true}}}else{if(O=="m"){for(var M=0;M<f.varIndices.length;M++){for(var K=0;K<f.smpIndices.length;K++){var C=E[f.varIndices[M]][f.smpIndices[K]];b[C]=true}}}else{if(O=="modified"){H.order={};for(var M=0;M<H.levels.length;M++){b[H.levels[M]]=true;H.order[H.levels[M]]=M}}else{if(O=="nodes"||O=="edges"){H.order={};for(var M=0;M<H.levels.length;M++){b[H.levels[M]]=true;H.order[H.levels[M]]=M}}}}}}b=f.b6(b);if(H.type=="Numeric"){if(H.orderS){b.sort(function(l,i){return H.orderS[l]-H.orderS[i]})}else{b.sort(function(l,i){return l-i});H.orderS={};for(var M=0;M<b.length;M++){H.orderS[b[M]]=M}}}else{b.sort(function(l,i){return H.order[l]-H.order[i]})}for(var M=0;M<b.length;M++){var C=b[M]!=null?b[M]:"NA";var N=f.uo(C,f.legendTextFont);if(N>L){L=N;f.legend[J].max=C}I[C]=(H.type=="Numeric"?H.orderS[C]:H.order[C])%a.length;f.legend[J].m[C]=a[I[C]];B++}f.legend[J].levels=b;G=O=="m"||O=="modified"?f.legend[J].max:false;f.legend[J].n=B;f.legend[J].meta=H;f.Xm(J,G,H)}};if(!this.hiddenLegends){this.hiddenLegends={}}this.on();this.AS();if(this.graphType=="Meter"||this.graphType=="Correlation"){return}else{if(this.graphType=="Venn"){this.jN();return}else{if(this.graphType=="Network"){for(var t=0;t<v.length;t++){var s=v[t];var z=this.I1(v[t]);var k=z+"By";this.legend[s].m={};this.legend[s].n=0;this.legend[s].width=0;this.legend[s].height=0;if(this[k]){var r=this.meta.data[s.match("Node")?"nodes":"edges"][this[k]];if(r.type=="Numeric"){e(r,s)}else{d(r,s.match("Node")?"nodes":"edges",k,s)}}}if(this.decorations.length&&this.decorationsType=="heatmap"&&this.meta.data.decorations.n&&this.showDecorations){var r=this.meta.data.decorations;var s="decoration";this.legend[s].m={};this.legend[s].n=0;this.legend[s].width=0;this.legend[s].height=0;e(r,s)}}else{if(this.isMultidimensionalData){for(var t=0;t<c.length;t++){if(this.data.y[this[c[t]]]){var n=this.data.y[this[c[t]]];var r=this.meta.data[this[c[t]]];var s=c[t].replace("ByData","");var z=this.I1(s);var k=z+"By";this.legend[(s=="outline"?"color":s)].m=[];this.legend[(s=="outline"?"color":s)].n=0;if(r.type=="Numeric"){e(r,s)}else{d(r,"m",k,s,n)}}}}else{if(this.scatterType=="bin2d"){for(var t=0;t<v.length;t++){var s=v[t];var z=this.I1(v[t]);var k=z+"By";this.legend[s].m={};this.legend[s].n=0;this.legend[s].width=0;this.legend[s].height=0}if(!this.meta.data.b.g){var j=this.xAxisIndices[this.xAxisCurrent];var A=this.yAxisIndices[this.yAxisCurrent];var h=this.ES(j,"x");var g=this.ES(A,"y");var w=this.qs(h,g);this.meta.data.b.g=w;this.meta.data.b.c=w.brew}var s="bin2d";var r=this.meta.data.b.c;e(r,s)}else{if(this.showHistogram&&!this.ridgeBy){if(this.showHistogram!=true){if(this.segregateVariablesBy.length>0&&this.segregateVariablesBy[0]!=this.showHistogram){var u=this.colorBy;this.colorBy=this.showHistogram;var s="color";var r=this.meta.data.z[this.showHistogram];this.legend[s].m={};this.legend[s].n=0;this.legend[s].width=0;this.legend[s].height=0;d(r,"z","colorBy",s)}}else{if(this.histogramAsDotplot&&this.colorBy){var s="color";var r=this.meta.data.x[this.colorBy];this.legend[s].m={};this.legend[s].n=0;this.legend[s].width=0;this.legend[s].height=0;if(r.type=="Numeric"){e(r,s)}else{d(r,"x","colorBy",s)}}}}else{if(this.isContour&&this.contourFilled){for(var t=0;t<v.length;t++){var s=v[t];var z=this.I1(v[t]);var k=z+"By";this.legend[s].m={};this.legend[s].n=0;this.legend[s].width=0;this.legend[s].height=0}if(!this.meta.data.q.g.length||!this.meta.data.q.g[0]||!this.meta.data.q.g[0].data){this.iA(this.isContour,true)}var s="contour";var r=this.meta.data.q.g[0].data.colorBrew;e(r,s)}else{for(var t=0;t<v.length;t++){var s=v[t];var z=this.I1(v[t]);var k=z+"By";this.legend[s].m={};this.legend[s].n=0;this.legend[s].width=0;this.legend[s].height=0;if(q){continue}if(this.graphType=="Scatter2D"&&this.lineBy&&(this.ribbonBy||this.isCxplot)&&this.colorBy==this.lineBy&&k=="colorBy"){continue}if(this[k]){if(this.data.x&&this.data.x.hasOwnProperty(this[k])){var r=this.meta.data.x[this[k]];this[z+"ByType"]="x";if(r.type=="Numeric"&&!r[k]){e(r,s)}else{d(r,"x",k,s)}}else{if(this.data.z&&this.data.z.hasOwnProperty(this[k])){var r=this.meta.data.z[this[k]];this[z+"ByType"]="z";if(r.type=="Numeric"&&!r[k]){e(r,s,this.colorSpectrumBreaks.length?true:false)}else{d(r,"z",k,s)}}else{if(this.u4(this[k])>-1&&this.meta.data.y.range[this[k]]){var r=this.meta.data;if(r.modified&&r.modified.z&&r.modified.z[this[k]]){r=r.modified.z;if(!r.meta){r.meta={}}r.meta[this[k]]={levels:r[this[k]]};d(r.meta[this[k]],"modified",k,s)}else{r=r.y.range[this[k]];e(r,s,[r.min,r.max])}}else{if(this[k]=="variable"){f.legend[s].n=this.varIndices.length}else{if(this.ridgeBy&&this[k]=="data"){e({type:"Numeric"},s,[this.xAxisMin,this.xAxisMax])}else{if(this.histogramAsDotplot&&this.data.z&&this.data.z.hasOwnProperty(this[k])){var r=this.meta.data.z[this[k]];if(r.type=="Numeric"&&!r[k]){e(r,s)}else{d(r,"z",k,s)}}}}}}}}}}}}}}}}this.S2();this.cd();this.D4();this.r0();this.J4();this.yg()};this.yR=function(c,b){if(c){if(b){var a=this.kQ(b);c.x=a.x;c.y=a.y}this.customLegend.push(c)}};this.VZ=function(c){if(c&&c.id){var b=[];for(var a=0;a<this.customLegend.length;a++){if(this.customLegend[a].id!=c.id){b.push(this.customLegend[a])}}this.customLegend=b}};this.HA=function(){var bi=function(f){a4.unshift(f);for(var j=1;j<a4.length;j++){var d=a4[j];if(f.x1>=d.x2||d.x1>=f.x2){continue}if(f.y1>=d.y2||d.y1>=f.y2){continue}return true}};var aq=this.marginLeft+this.offsetX+this.left;var al=this.marginTop+this.offsetY+this.top;var aB=this.decorations;var aA=["line","text","label","point","range","image"];var a4=[];if(this.showDecorations&&aB){if(this.decorationsClipped){this.YN({p:["setClipArea",this.uf()],t:"Decorations"})}if(this.graphType.match(/Scatter/)){var aD=["linear","exponential","logarithmic","power","polynomial"];for(var aw=0;aw<aD.length;aw++){if(aB[aD[aw]]){var aC=aB[aD[aw]];for(var av=0;av<aC.length;av++){var bg=this.xAxisIndices.length==1?this.xAxisIndices[0]:this.xAxisIndices[av];var aZ=this.yAxisIndices.length==1?this.yAxisIndices[0]:this.yAxisIndices[av];var ba=this.uP(bg);var aT=this.uP(aZ);var Y=aB[aD[aw]][av].color||this.colors[av%this.colors.length];var a6=[];var P=this.varIndices.sort(function(f,d){return ba[f]-ba[d]});for(var au=0;au<P.length;au++){var e=P[au];a6.push([ba[e],aT[e]])}var ao=this[aD[aw]+"Regression"](a6);var a9=[];var a7=[];if(ao&&ao.predict){for(var au=0;au<ao.predict.length;au++){S=aq+((ao.predict[au][0]-this.xAxisMin)*this.xAxisUnit);q=(al+this.y)-((ao.predict[au][1]-this.yAxisMin)*this.yAxisUnit);a9.push(S);a7.push(q)}if(a9.length>0){this.YN({p:["drawLine","spline",a9,a7,false,false,Y,1],i:["Decor-"+aD[aw]+"-"+av],t:"Decorations"})}}}}}if(aB.nlfit||aB.nonlinear){var r,aa,p;var P=this.varIndices;var S,q;var aJ=aB.nlfit?aB.nlfit:aB.nonlinear;for(var aw=0;aw<aJ.length;aw++){var a9=[];var a7=[];var Y=aw%this.colors.length;var a=Number(this.Fc(this.yAxisTransform,aJ[aw].param[0]));var bk=Number(this.Fc(this.yAxisTransform,aJ[aw].param[1]));var bj=Number(aJ[aw].param[2]);var bh=Number(aJ[aw].param[3]);var an=this.xAxisIndices.length==1?this.xAxisIndices[0]:this.xAxisIndices[aw];var ba=this.uP(an);if(this.xAxisTransform=="percentile"){r=this.ID(ba);p=r[0];aa=r[1]}P.sort(function(f,d){return ba[f]-ba[d]});Y=aJ[aw].color?aJ[aw].color:this.colors[Y];for(var av=0;av<P.length;av++){var K=P[av];var af=this.VY(K,an);var ae;var X=[];if(af>0){if(av>0){var a8=P[av-1];var bc=this.VY(a8,an);if(bc>0){var ag=(af-bc)/25;for(var au=0;au<25;au++){X.push(bc);bc+=ag}}}else{X=[af]}for(var au=0;au<X.length;au++){if(aJ[aw].type=="reg"){ae=a+((bk-a)/(1+bj/(Math.pow(X[au],bh))))}else{ae=a+((bk-a)/(1+(Math.pow((X[au]/bj),bh))))}if(this.xAxisTransform){X[au]=this.xAxisTransform=="percentile"?this.W9(p,aa,X[au]):this.Fc(this.xAxisTransform,X[au])}S=aq+((X[au]-this.xAxisMin)*this.xAxisUnit);q=(al+this.y)-((ae-this.yAxisMin)*this.yAxisUnit);a9.push(S);a7.push(q)}}}if(a9.length>0){this.YN({p:["drawShape","path",a9,a7,false,false,Y,Y,"open",false,false,true],i:["Decor-Non-Lin-"+av+"-"+aw],t:"Decorations"});if(aJ[aw].type=="reg"){ae=a+((bk-a)/(1+bj/(Math.pow(bj,bh))))}else{ae=a+((bk-a)/(1+(Math.pow((bj/bj),bh))))}if(this.xAxisTransform){bj=this.xAxisTransform=="percentile"?this.W9(p,aa,bj):this.Fc(this.xAxisTransform,bj)}S=aq+((bj-this.xAxisMin)*this.xAxisUnit);q=(al+this.y)-((ae-this.yAxisMin)*this.yAxisUnit);var a5=this.YN({p:["drawLine","dottedLine",aq,q,S,q,Y],i:["Decor-Non-Lin-EC-h"+av+"-"+aw],t:"Decorations"});this.YN({p:["drawLine","dottedLine",S,q,S,(al+this.y),Y],i:["Decor-Non-Lin-EC-v"+av+"-"+aw],g:a5,t:"Decorations"})}}}if(aB.reg||aB.regression){var aC=aB.reg?aB.reg:aB.regression;for(var aw=0;aw<aC.length;aw++){if(aC[aw].slope&&aC[aw].intercept){var Y=aC[aw].color?aC[aw].color:this.colors[aw%this.colors.length];var R=this.a0(Y,0.3,true);var u=this.mU(aw,false,"patternBy");var aE=aC[aw].style?aC[aw].style:this.fitLineType;var bf=Number(aC[aw].slope);var ay=Number(aC[aw].intercept);var ar=aC[aw].id;var T=aC[aw].cor;var H="y ~ "+this.qY(bf,this.yAxisDecs+1)+"x + "+this.qY(ay,this.yAxisDecs+1)+(T?" (r = "+this.qY(T,3)+")":"");var ai=aC[aw].ci?aC[aw].ci:false;var U=ai?ai.length-1:false;var S=this.showRegressionFullRange||!ai?this.xAxisMin:ai[0][0];var q=(bf*S)+ay;var Q=this.showRegressionFullRange||!ai?this.xAxisMax:ai[U][0];var o=(bf*Q)+ay;S=aq+(S*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);q=(al+this.y)-(q*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);Q=aq+(Q*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);o=(al+this.y)-(o*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);var aV=this.R2([[S,q],[Q,o]]);if(aV.length){this.YN({p:["drawLine",aE,aV[0][0][0],aV[0][0][1],aV[0][1][0],aV[0][1][1],Y,2],i:["Decor-Reg-"+aw,ar],t:"Decorations",h:this.Cs(false,false,ar)})}if(ai){var I=[];var F=[];var aO=[];for(var av=0;av<ai.length;av++){q=ai[av][1];o=ai[av][2];S=aq+(ai[av][0]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);q=(al+this.y)-(q*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);o=(al+this.y)-(o*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);I.push([S,S]);F.push([q,o]);aO.push([S,(q+o)/2])}if(this.showConfidenceIntervals){this.YN({p:["drawShape","confidence",I,F,false,false,R,this.isCxplot?R:Y,u],i:[H+":Confidence",ar],b:aO,t:"Decorations",h:this.Cs(false,false,ar)})}}}}}if(aB.nor||aB.normal){var bb=aB.nor?aB.nor:aB.normal;for(var aw=0;aw<bb.length;aw++){if(bb[aw].mu&&bb[aw].sigma){var O=[];var M=[];var a6=[];var S,q;var Y=aw%this.colors.length;var aP=bb[aw].mu;var aK=bb[aw].sigma;var C=bb[aw].start?bb[aw].start:bb[aw].yAxis?this.yAxisMin:this.xAxisMin;var ax=bb[aw].end?bb[aw].end:bb[aw].yAxis?this.yAxisMax:this.xAxisMax;var aS=120;if(C<aP&&aP<ax){var bc,aU,D,n;var ag=(aP-C)/aS;var G=aK*aK;var az=1/Math.sqrt(2*Math.PI*G);if(bb[aw].yAxis){D=bb[aw].max?bb[aw].max*this.xAxisUnit:this.x-(this.x*this.axisExtension);n=D/az;bc=C;for(var av=0;av<aS-1;av++){aU=(az*Math.pow(Math.E,-Math.pow(bc-aP,2)/G));a6.push([bc,aU]);S=aq+(aU*n);q=(al+this.y)-(bc*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);O.push(S);M.push(q);bc+=ag}ag=(ax-aP)/aS;bc=aP;for(var av=0;av<aS;av++){aU=(az*Math.pow(Math.E,-Math.pow(bc-aP,2)/G));a6.push([bc,aU]);S=aq+(aU*n);q=(al+this.y)-(bc*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);O.push(S);M.push(q);bc+=ag}Y=bb[aw].color?bb[aw].color:this.colors[Y];this.YN({p:["drawShape","path",O,M,false,false,Y,Y,"open",false,false,true],i:["Decor-Nor-"+aw],t:"Decorations"})}else{D=bb[aw].max?bb[aw].max*this.yAxisUnit:this.y-(this.y*this.axisExtension);n=D/az;bc=C;for(var av=0;av<aS-1;av++){aU=(az*Math.pow(Math.E,-Math.pow(bc-aP,2)/G));a6.push([bc,aU]);S=aq+(bc*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);q=(al+this.y)-(aU*n);O.push(S);M.push(q);bc+=ag}ag=(ax-aP)/aS;bc=aP;for(var av=0;av<aS;av++){aU=(az*Math.pow(Math.E,-Math.pow(bc-aP,2)/G));a6.push([bc,aU]);S=aq+(bc*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);q=(al+this.y)-(aU*n);O.push(S);M.push(q);bc+=ag}Y=bb[aw].color?bb[aw].color:this.colors[Y];this.YN({p:["drawShape","path",O,M,false,false,Y,Y,"open",false,false,true],i:["Decor-Nor-"+aw],t:"Decorations"})}}}}}for(var aw=0;aw<aA.length;aw++){if(aB[aA[aw]]){for(var av=0;av<aB[aA[aw]].length;av++){if(aB[aA[aw]][av].x!=null||aB[aA[aw]][av].y!=null){var S,q,Q,o,b,aI,aH;aB[aA[aw]][av].id=aB[aA[aw]][av].id==null?this.PI("-decoration-"):aB[aA[aw]][av].id;var af=aB[aA[aw]][av].x!=null?aB[aA[aw]][av].x:null;var ae=aB[aA[aw]][av].y!=null?aB[aA[aw]][av].y:null;var N=aB[aA[aw]][av].x2!=null?aB[aA[aw]][av].x2:null;var m=aB[aA[aw]][av].y2!=null?aB[aA[aw]][av].y2:null;var aY=aB[aA[aw]][av].width?aB[aA[aw]][av].width:(aA[aw]=="point"?this.dataPointSize*1:1);var E=aB[aA[aw]][av].height?aB[aA[aw]][av].height:(aA[aw]=="point"?this.dataPointSize*1:1);var J=aB[aA[aw]][av].color?aB[aA[aw]][av].color:this.colors[av%this.colors.length];var aF=aB[aA[aw]][av].type?aB[aA[aw]][av].type:aA[aw];var v=aB[aA[aw]][av].label||false;var a0=aB[aA[aw]][av].relative||false;var B=aB[aA[aw]][av].wrap||false;var A=aB[aA[aw]][av].justify||false;var aR=aB[aA[aw]][av].font||this.decorationsTextFont;var Z=aB[aA[aw]][av].color||this.decorationsTextColor;var aG=aB[aA[aw]][av].background||this.background;var bd=aB[aA[aw]][av].align||"left";var aE=aA[aw]=="line"&&aF!="line"?aF:aB[aA[aw]][av].style?aB[aA[aw]][av].style:"line";var W=aB[aA[aw]][av].shape||"circle";var ad=aB[aA[aw]][av].src||false;if(a0){af=this.xAxisMin+(af*this.xAxisRange);ae=this.yAxisMin+(ae*this.yAxisRange)}if(this.isCxplot&&this.decorationsTransform){if(this.xAxisTransform){if(af){af=this.Fc(this.xAxisTransform,af)}if(N){N=this.Fc(this.xAxisTransform,N)}}if(this.yAxisTransform){if(ae){ae=this.Fc(this.yAxisTransform,ae)}if(m){m=this.Fc(this.yAxisTransform,m)}}}var z=this.eO(af)&&this.eO(ae)&&N==null&&m==null;if(aA[aw]=="range"||aA[aw]=="point"){if(aA[aw]=="point"&&aB[aA[aw]][av].width){aY=aB[aA[aw]][av].width*this.xAxisUnit}if(aA[aw]=="point"&&aB[aA[aw]][av].height){E=aB[aA[aw]][av].height*this.yAxisUnit}}if(aB[aA[aw]][av].scope){var aM=this.layoutValid?false:true;if(this.layoutValid){var ak=this.data.l.name[this.layoutCurrent];if(!this.eO(ak)){ak=[ak]}for(var au=0;au<ak.length;au++){if(aB[aA[aw]][av].scope.toString()==ak[au].toString().replace("\x00","")){aM=true;break}}}if(!aM){continue}}if(z){var aN=null;for(var au=1;au<af.length;au++){S=aq+((af[au-1]-this.xAxisMin)*this.xAxisUnit);Q=aq+((af[au]-this.xAxisMin)*this.xAxisUnit);q=al+this.y-((ae[au-1]-this.yAxisMin)*this.yAxisUnit);o=al+this.y-((ae[au]-this.yAxisMin)*this.yAxisUnit);aH=v?v:"";if(av==1){aN=this.YN({p:["drawLine",aE,S,q,Q,o,J,aY],i:[aH+":Decoration-"+au],t:"Decorations"})}else{this.YN({p:["drawLine",aE,S,q,Q,o,J,aY],i:[aH+":Decoration-"+au],g:aN,t:"Decorations"})}}}else{if(af!=null&&ae!=null&&N!=null&&m!=null&&(aA[aw].match(/line|range/))){S=aq+((af-this.xAxisMin)*this.xAxisUnit);Q=aq+((N-this.xAxisMin)*this.xAxisUnit);q=al+this.y-((ae-this.yAxisMin)*this.yAxisUnit);o=al+this.y-((m-this.yAxisMin)*this.yAxisUnit);aH=aB[aA[aw]][av].tooltip||("("+af+","+ae+") &rarr; ("+N+","+m+")");if(aA[aw]=="range"){b=Math.abs(Q-S);aI=Math.abs(o-q);this.YN({p:["drawShape","rectangle",(S+Q)/2,(q+o)/2,b,aI,J,aB[aA[aw]][av].outline||J,aB[aA[aw]][av].pattern,aB[aA[aw]][av].rotate],i:[aH+":Decoration-"+av],t:"Decorations"})}else{this.YN({p:["drawLine",aE,S,q,Q,o,J,aY],i:[aH+":Decoration-"+av],t:"Decorations"})}}else{if(af!=null){S=aq+((af-this.xAxisMin)*this.xAxisUnit);if(aA[aw]=="line"||aA[aw]=="range"){q=al;Q=aA[aw]=="range"&&N!=null?aq+((N-this.xAxisMin)*this.xAxisUnit):S;o=q+this.y;if(aA[aw]=="range"){aH=aB[aA[aw]][av].tooltip||"x "+af+" &rarr; "+N;b=Math.abs(Q-S);aI=Math.abs(o-q);this.YN({p:["drawShape","rectangle",(S+Q)/2,(q+o)/2,b,aI,J,aB[aA[aw]][av].outline||J,aB[aA[aw]][av].pattern,aB[aA[aw]][av].rotate],i:[aH+":Decoration-"+av],t:"Decorations"})}else{aH=aB[aA[aw]][av].tooltip||"x &rarr; "+af;this.YN({p:["drawLine",aE,S,q,Q,o,J,aY],i:[aH+":Decoration-"+av],t:"Decorations"})}}else{if((aA[aw]=="point"||aA[aw]=="text"||aA[aw]=="label")&&ae!=null){q=al+this.y-((ae-this.yAxisMin)*this.yAxisUnit);Q=S;o=q;if(aA[aw]=="point"){aH=aB[aA[aw]][av].tooltip||this.qY(aB[aA[aw]][av].x,this.xAxisDecs)+", "+this.qY(aB[aA[aw]][av].y,this.yAxisDecs);this.YN({p:["drawShape",W,S,q,aY,E,J,J],i:[aH+":Decoration-"+av],t:"Decorations"})}else{aH=aB[aA[aw]][av].tooltip||v}}}}else{if(ae!=null){q=al+this.y-((ae-this.yAxisMin)*this.yAxisUnit);if(aA[aw]=="line"||aA[aw]=="range"){S=aq;Q=S+this.x;o=aA[aw]=="range"&&m!=null?al+this.y-((m-this.yAxisMin)*this.yAxisUnit):q;if(aA[aw]=="range"){aH=aB[aA[aw]][av].tooltip||"y "+ae+" &rarr; "+m;b=Math.abs(Q-S);aI=Math.abs(o-q);this.YN({p:["drawShape","rectangle",(S+Q)/2,(q+o)/2,b,aI,J,aB[aA[aw]][av].outline||J,aB[aA[aw]][av].pattern,aB[aA[aw]][av].rotate],i:[aH+":Decoration-"+av],t:"Decorations"})}else{aH=aB[aA[aw]][av].tooltip||"y &rarr; "+ae;this.YN({p:["drawLine",aE,S,q,Q,o,J,aY],i:[aH+":Decoration-"+av],t:"Decorations"})}}else{if((aA[aw]=="point"||aA[aw]=="text"||aA[aw]=="label")&&af!=null){S=aq+((af-this.xAxisMin)*this.xAxisUnit);Q=S;o=q;if(aA[aw]=="point"){aH=aB[aA[aw]][av].tooltip||this.qY(aB[aA[aw]][av].x,this.xAxisDecs)+", "+this.qY(aB[aA[aw]][av].y,this.yAxisDecs);this.YN({p:["drawShape",W,S,q,aY,E,J,J],i:[aH+":Decoration-"+av],t:"Decorations"})}else{aH=aB[aA[aw]][av].tooltip||v}}}}}}}if(S&&q&&v&&!z){if(aB[aA[aw]][av].y2!=null&&aA[aw]=="line"){var aX=this.gp(S,q,Q,o);if(bd=="right"){this.YN({p:["drawText",v,Q,o,aR,Z,"right","bottom",aX],t:"Decorations"})}else{if(bd=="center"){this.YN({p:["drawText",v,(S+Q)/2,(q+o)/2,aR,Z,"center","bottom",aX],t:"Decorations"})}else{this.YN({p:["drawText",v,S,q,aR,Z,"left","bottom",aX],t:"Decorations"})}}}else{var w=(aA[aw]=="text"||aA[aw]=="label")?-this.decorationsTextFontSize*0.5:this.margin;if(A){v=this.Iq(v,A,aR)}else{if(B){v=this.zG(v,B)}}var b=this.uo(v,aR)+this.margin*2;var aI=this.vL(v,aR)-this.margin*2;var aL={x1:((S+Q)/2)-(b/2),y1:o-(aI),x2:((S+Q)/2)+(b/2),y2:o+(aI)};if(bi(aL)){continue}if(bd=="right"){if(aA[aw]=="label"){this.YN({p:["drawShape","roundrect",S+w-((b/2)-(this.margin*3)),o-(w+this.margin),b,aI,aG,Z],t:"Decorations"})}this.YN({p:["drawText",v,Q-w,o-w,aR,Z,"right","bottom"],t:"Decorations"})}else{if(bd=="center"){if(aA[aw]=="label"){this.YN({p:["drawShape","roundrect",S+w+this.margin,o-(w+this.margin),b,aI,aG,Z],t:"Decorations"})}this.YN({p:["drawText",v,(S+Q)/2,o-w,aR,Z,"center","bottom"],t:"Decorations"})}else{if(aA[aw]=="label"){this.YN({p:["drawShape","roundrect",S+w+(b/2)-this.margin,o-(w+this.margin),b,aI,aG,Z],t:"Decorations"})}this.YN({p:["drawText",v,S+w,o-w,aR,Z,"left","bottom"],t:"Decorations"})}}}}else{if(S&&q&&aY&&E&&aA[aw]=="image"&&ad){this.YN({p:["drawShape","image",S,q,aY,E,false,false,false,false,false,false,false,false,false,ad],t:"Decorations"})}}}}}}}else{if(aB.line){for(var aw=0;aw<aB.line.length;aw++){var S,q,Q,o;aB.line[aw].id=aB.line[aw].id==null?this.PI("-decoration-"):aB.line[aw].id;var aM=true;var aF=aB.line[aw].type||"line";var J=aB.line[aw].color;var aj=this.Fc(this.isTransformedData,aB.line[aw].value||0);var v=aB.line[aw].label||false;var aY=aB.line[aw].width||1;var bd=aB.line[aw].align||"left";var aQ=aB.line[aw].scope||false;if(this.graphOrientation=="vertical"){S=this.marginLeft+this.offsetX+this.left;Q=S+this.x;q=this.marginTop+this.offsetY+this.top+this.y-((aj-this.xAxisMin)*this.xAxisUnit);o=q;aM=q<=this.marginTop+this.offsetY+this.top+this.y&&q>=this.marginTop+this.offsetY+this.top?true:false}else{S=this.marginLeft+this.offsetX+this.left+((aj-this.xAxisMin)*this.xAxisUnit);Q=S;q=this.marginTop+this.offsetY+this.top;o=q+this.y;aM=S<=this.marginLeft+this.offsetX+this.left+this.x&&this.marginLeft+this.offsetX+this.left?true:false}if(aM&&aQ){if(this.layoutValid){aM=false;var ak=this.eG(this.data.l.name[this.layoutCurrent]);for(var av=0;av<ak.length;av++){if(aQ==ak[av]){aM=true}}}}if(aM){var ab=this.isR?6:3;if(v){if(this.graphOrientation=="vertical"){if(bd=="right"){this.YN({p:["drawText",v,Q-this.margin,o-this.margin,this.decorationsTextFont,this.decorationsTextColor,"right","bottom"],t:"Decorations"})}else{if(bd=="center"){this.YN({p:["drawText",v,S+(this.x/2),o-this.margin,this.decorationsTextFont,this.decorationsTextColor,"center","bottom"],t:"Decorations"})}else{this.YN({p:["drawText",v,S+this.margin,o-this.margin,this.decorationsTextFont,this.decorationsTextColor,"left","bottom"],t:"Decorations"})}}}else{if(bd=="right"){this.YN({p:["drawText",v,Q+(this.margin*2),o-(this.margin*ab),this.decorationsTextFont,this.decorationsTextColor,"left","middle"],t:"Decorations"})}else{if(bd=="center"){this.YN({p:["drawText",v,Q+(this.margin*2),q+(this.y/2),this.decorationsTextFont,this.decorationsTextColor,"left","middle"],t:"Decorations"})}else{this.YN({p:["drawText",v,Q+(this.margin*2),q+(this.margin*ab),this.decorationsTextFont,this.decorationsTextColor,"left","middle"],t:"Decorations"})}}}}var aH=aB.line[aw].tooltip||("&rarr; "+aj);this.YN({p:["drawLine",aF,S,q,Q,o,J,aY],i:[aH+":Decoration"+aw],t:"Decorations"})}}}if(aB.point){for(var aw=0;aw<aB.point.length;aw++){aB.point[aw].id=aB.point[aw].id==null?this.PI("-decoration-"):aB.point[aw].id;var aM=true;var V=this.u4(aB.point[aw].smp);var aj=this.Fc(this.isTransformedData,aB.point[aw].value||0);var J=aB.point[aw].color||this.foreground;var aY=(aB.point[aw].width||1)*this.dataPointSize;var E=(aB.point[aw].height||1)*this.dataPointSize;var W=aB.point[aw].shape||"circle";var S=V!=null&&V>=0?this.smpInfo[V]-this.margin:null;var q=(aj-this.xAxisMin)*this.xAxisUnit;if(S!=null&&q!=null){if(this.graphOrientation=="vertical"){q=this.marginTop+this.offsetY+this.top+this.y-q;aM=q<=this.marginTop+this.offsetY+this.top+this.y&&q>=this.marginTop+this.offsetY+this.top?true:false}else{S=this.marginLeft+this.offsetX+this.left+q;q=this.smpInfo[V];aM=S<=this.marginLeft+this.offsetX+this.left+this.x&&this.marginLeft+this.offsetX+this.left?true:false}if(aM){var aH=aB.point[aw].smp+"("+aj+")";this.YN({p:["drawShape",W,S,q,aY,E,J,J,"closed"],i:[aH+":Decoration"+aw],t:"Decorations"})}}}}if(aB.marker){for(var aw=0;aw<aB.marker.length;aw++){if(aB.marker[aw].type=="range"){if(aB.marker[aw].sample&&aB.marker[aw].sample2){var g=this.u4(aB.marker[aw].sample);var c=this.u4(aB.marker[aw].sample2);if(g!=null&&g>=0&&c!=null&&c>=0){aB.marker[aw].id=aB.marker[aw].id==null?this.PI("-decoration-"):aB.marker[aw].id;var S=this.smpInfo[g]-this.blockSeparation;var Q=this.smpInfo[c]+this.blockSeparation;var b=Math.abs(Q-S);var ac=this.a0(aB.marker[aw].color,this.decorationsTransparency);this.YN({p:["drawShape","rectangle",(S+Q)/2,this.top+(this.y/2)+this.margin,b,this.y,ac,ac],t:"Decorations"})}}}}}if(aB.error){for(var aw=0;aw<aB.error.length;aw++){if(aB.error[aw].sample){var S,q,Q,o,N,m,L,h;var am=this.data.w?this.plotInfo.indices.indexOf(this.data.w.smps.indexOf(aB.error[aw].sample)):this.data.y.smps.indexOf(aB.error[this.plotInfo.indices[aw]].sample);var ap=this.data.w?aw:am;var aW=this.data.w?am:aw;var be=this.Fc(this.isTransformedData,aB.error[ap].min||this.xAxisMin);var D=this.Fc(this.isTransformedData,aB.error[ap].max||this.xAxisMax);var aM=true;var aF=aB.error[ap].type||"line";var J=aB.error[ap].color||this.foreground;var ah=aB.error[ap].size||1;var aY=(aB.error[ap].width||1)*this.dataPointSize*4;var aQ=aB.error[ap].scope||false;if(am!=null){aB.error[ap].id=aB.error[ap].id==null?this.PI("-decoration-"):aB.error[ap].id;if(this.graphOrientation=="vertical"){S=this.smpInfo[aW];q=this.marginTop+this.offsetY+this.top+this.y-((be-this.xAxisMin)*this.xAxisUnit);Q=S;o=this.marginTop+this.offsetY+this.top+this.y-((D-this.xAxisMin)*this.xAxisUnit);N=S-aY;m=q;L=S+aY;h=o}else{S=this.marginLeft+this.offsetX+this.left+((be-this.xAxisMin)*this.xAxisUnit);q=this.smpInfo[aW];Q=this.marginLeft+this.offsetX+this.left+((D-this.xAxisMin)*this.xAxisUnit);o=q;N=S;m=q-aY;L=Q;h=q+aY}if(aM&&aQ){if(this.layoutValid){aM=false;var ak=this.eG(this.data.l.name[this.layoutCurrent]);for(var av=0;av<ak.length;av++){if(aQ==ak[av]){aM=true}}}}if(aM){var a5=this.YN({p:["drawLine",aF,S,q,Q,o,J,ah],i:["Error-"+aB.error[ap].sample+":Decoration"+aw],t:"Decorations"});if(this.graphOrientation=="vertical"){this.YN({p:["drawLine",aF,N,m,L,m,J,ah],i:["Error-"+aB.error[ap].sample+":Decoration"+aw],g:a5,t:"Decorations"});this.YN({p:["drawLine",aF,N,h,L,h,J,ah],i:["Error-"+aB.error[ap].sample+":Decoration"+aw],g:a5,t:"Decorations"})}else{this.YN({p:["drawLine",aF,N,m,N,h,J,ah],i:["Error-"+aB.error[ap].sample+":Decoration"+aw],g:a5,t:"Decorations"});this.YN({p:["drawLine",aF,L,m,L,h,J,ah],i:["Error-"+aB.error[ap].sample+":Decoration"+aw],g:a5,t:"Decorations"})}}}}}}}if(this.decorationsClipped){this.YN({p:["resetClipArea"],t:"Decorations"})}}};this.Ma=function(){if(this.isOncoprint){var b=(this.width/2)-(this.legend.oncoprint.width/2);var p=this.height-(this.marginBottom+this.legend.oncoprint.height-this.margin);var a=0;var o=this.legend.oncoprint.width/this.legend.oncoprint.cols;var k=2;this.YN({p:["drawShape","rect",this.width/2,p+(this.legend.oncoprint.height/2)-this.margin,this.legend.oncoprint.width,this.legend.oncoprint.height,this.background,this.background],i:[-1],m:["-legend-oncoprint"],t:"Legends"});for(var g=0;g<this.legend.oncoprint.rows;g++){var d=b;for(var e=0;e<this.legend.oncoprint.cols;e++){if(a<this.legend.oncoprint.labels.length){var h=this.legend.oncoprint.labels[a];var m=this.legend.oncoprint.objects[a];if(a<this.legend.oncoprintMutations){this.YN({p:["drawShape","rect",d+2.5,p+10.5,5,21,this.legend.oncoprint.colors[h]],i:["Onc-"+h+"-"+m],t:"Legends"});d+=5+this.margin;this.YN({p:["drawText",h,d,p+10.5+k,this.legendTextFont,this.legendTextColor,"left","middle"],t:"Legends"});d+=o}else{this.YN({p:["drawShape","rect",d+2.5,p+10.5,5,21,"rgb(220,220,220"],i:["Onc-"+h+"-"+m],t:"Legends"});this.YN({p:["drawShape","rect",d+2.5,p+10.5,5,7,this.legend.oncoprint.colors[h]],i:["Onc-"+h+"-"+m],t:"Legends"});d+=5+this.margin;this.YN({p:["drawText",h,d,p+10.5+k,this.legendTextFont,this.legendTextColor,"left","middle"],t:"Legends"});d+=o}a++}}p+=21+this.margin}}};this.mY=function(A,d){var g=this;var b=function(D,j,i){if(g.showHistogram&&f){if(g.Op()){if((f.hasOwnProperty("Samples")&&!g.segregateSamplesBy.length)||g.segregateVariablesBy.length){return g.Cv(g.data.y.smps[D],g.maxSmpStringLen)}else{if(g.meta.data.z&&g.meta.data.z[g.showHistogram]){return g.Cv(g.meta.data.z[g.showHistogram].levels[D],g.maxSmpStringLen)}else{return g.Cv(g.data.y.smps[D],g.maxSmpStringLen)}}}else{if(f.hasOwnProperty("Factor")&&g.smpIndices.length==1&&g.meta.data.z&&g.meta.data.z[g.showHistogram]){return g.Cv(g.meta.data.z[g.showHistogram].levels[D],g.maxSmpStringLen)}else{if(f.hasOwnProperty("Factor")&&g.meta.data.z&&g.meta.data.z[g.showHistogram]){return g.Cv(f.Global.sets[D].name.replace(/^Factor:/,""),g.maxSmpStringLen)}else{if(f.hasOwnProperty("Samples")){return g.Cv(g.data.y.smps[D],g.maxSmpStringLen)}else{if(f.hasOwnProperty("Variables")){return g.Cv(g.data.y.vars[D],g.maxSmpStringLen)}else{return""}}}}}}else{if(g.xAxisIndices.length==1||j==i){return g.Cv(i,g.maxSmpStringLen)}else{if(g.yAxisIndices.length==1){return g.Cv(j,g.maxSmpStringLen)}else{return g.Cv(i,g.maxSmpStringLen)+" vs "+g.Cv(j,g.maxSmpStringLen)}}}};var c=function(i){if(g.showHistogram&&g.meta.data.s.density.Global.sets[i]){return g.meta.data.s.density.Global.sets[i].color}else{return g.colors[i%g.colors.length]}};var y=function(j,i){if(g.showHistogram&&f){return"Series:0:"+j+":"+i}else{return g.xAxisIndices.length==g.yAxisIndices.length?"Series:"+g.xAxisIndices[j]+":"+g.yAxisIndices[j]:g.xAxisIndices.length>g.yAxisIndices.length?"Series:"+g.xAxisIndices[j]+":0":"Series:0:"+g.yAxisIndices[j]}};var q=A;var B=d;var w=0;var s=this.PG();var p=Math.max(s,this.E1(this.legendTextFont));var t=this.E1(this.legendTitleFont);var v=p/2;var f=this.meta.data.s.density;d+=this.legendTextMargin+v;this.vX(q,B,this.legend.sample.width,this.legend.sample.height,"-legend-sample");var h=this.legend.sample.columns&&this.legend.sample.columns>this.legend.sample.n?this.legend.sample.n:this.legend.sample.columns?this.legend.sample.columns:this.legendColumns;var z=this.legend.sample.width/h;var a=Math.ceil(this.legend.sample.n/h);if(this.ridgeBy){for(var x=0;x<a;x++){for(var u=0;u<h;u++){A=q+((this.legendTextMargin+z)*u);if(w<this.legend.sample.n){var n=this.Cv(this.data.y.smps[w],this.maxSmpStringLen);var e=this.colors[w%this.colors.length];var C="Series:0:"+w;var k=A+v+this.legendTextMargin;this.P5(k,d,"circle",p,this.Fg(e),this.fE(e),"closed","solid",this.background,n,[C],null,this.Cs(false,false,C));w++}}d+=p+this.legendTextMargin}}else{if(this.legend.sample.title){var n=this.Cv(this.legend.sample.title,this.maxSmpStringLen);this.YN({p:["drawText",n,A+this.legendTitleMargin,d-(t/2),this.legendTitleFont,this.legendTitleColor,this.legendTitleAlign,"middle"],t:"Legends"});d+=t+this.legendTitleMargin}for(var x=0;x<a;x++){for(var u=0;u<h;u++){A=q+((this.legendTextMargin+z)*u);if(w<this.legend.sample.n){var l=this.mU(x,false,"patternBy");var m=this.xAxisIndices.length==this.yAxisIndices.length?this.yAxis[w]:this.xAxisIndices.length>this.yAxisIndices.length?this.yAxis[this.yAxisCurrent]:this.yAxis[w];var o=this.xAxisIndices.length==this.yAxisIndices.length?this.xAxis[w]:this.xAxisIndices.length>this.yAxisIndices.length?this.xAxis[w]:this.xAxis[this.xAxisCurrent];var n=b(w,o,m);var e=c(w,n);var C=y(w,n);var r=this.shapes[w%this.shapes.length];var k=A+v+this.legendTextMargin;if(this.histogramAsDotplot){var r=this.histogramAsDotplot?"circle":"rectangle";this.P5(k,d,r,p,this.Fg(e),this.fE(e),l,"solid",this.background,n,[C],null,this.Cs(false,false,C))}else{if(this.showHistogram){if(this.hideHistogram){if(this.showFilledHistogramDensity){this.P5(k,d,"circle",p,this.a0(this.Fg(e),0.7,false,false,true),this.fE(e),false,"solid",this.background,n,[C],null,this.Cs(false,false,C))}else{this.a3(k,d,"circle",p,this.Fg(e),this.Fg(e),"solid","line",this.Fg(e),n,[C],null,this.Cs(false,false,C))}}else{this.P5(k,d,"rectangle",p,this.Fg(e),this.fE(e),false,"solid",this.background,n,[C],null,this.Cs(false,false,C))}}else{if(this.colorBy){if(this.scatterType=="line"){this.a3(k,d,"circle",p,this.Fg(e),this.Fg(e),"solid","line",this.Fg(e),n,[C],null,this.Cs(false,false,C))}else{this.P5(k,d,"circle",p,this.background,this.Fg(e),"open","solid",this.background,n,[C],null,this.Cs(false,false,C))}}else{if(this.isKM){e=this.Fg(e);this.qd(k,d,"rectangle",p,e,e,"closed","solid",e,n,[C],null,this.Cs(false,false,C))}else{if(this.scatterType=="line"){if(this.shapeBy=="sample"){this.WO(k,d,r,p,this.Fg(e),this.Fg(e),"solid","line",this.Fg(e),n,[C],null,this.Cs(false,false,C))}else{this.a3(k,d,"circle",p,this.Fg(e),this.Fg(e),"solid","line",this.Fg(e),n,[C],null,this.Cs(false,false,C))}}else{this.P5(k,d,"circle",p,this.Fg(e),this.fE(e),l,"solid",this.background,n,[C],null,this.Cs(false,false,C))}}}}}}else{break}w++}d+=p+this.legendTextMargin}}};this.YR=function(I,c){var l=this;var t=I;var K=c;var x=this.PG();var s=Math.max(x,this.E1(this.legendTextFont));var z=s/2;var A=0;var k=this.layoutValid&&!this.isDOE&&this.TG()&&this.meta.config.user.graphType&&this.meta.config.user.graphType!=this.graphType?this.meta.config.user.graphType:this.graphType;var o=function(){if(l.circularType.match(/normal/)){if(l.ringGraphType.length){for(var h=0;h<l.ringGraphType.length;h++){if(l.ringGraphType[h]!="heatmap"){return true}}return false}}return true};var n=function(h){if(h<l.xAxisVarIndices.length){return l.colors[h%l.colors.length]}else{return l.colors[(h-l.xAxisVarIndices.length)%l.colors.length]}};if(this.legend.variable.width==0||this.legend.variable.height==0||!this.variableShowLegend){return}else{this.vX(t,K,this.legend.variable.width,this.legend.variable.height,"-legend-variable");if(this.data.y.unpivoted&&this.data.y.unpivoted.factor){var F=this.E1(this.legendTitleFont)*0.5;this.YN({p:["drawText",this.Cv(this.data.y.unpivoted.factor,this.maxVarStringLen),t+z,K+F,this.legendTextFont,this.legendTextColor,"left","middle"],t:"Legends"});K+=F+this.legendTextMargin;c=K}}if(k=="Circular"&&this.circularType.match(/sunburst|bubble/)){return}else{if(k=="Pie"){var H=!this.layoutComb?this.width-(I+(this.legendTextMargin*1.5)):this.isDOE?this.layoutWidth-((I-this.offsetX)+(this.legendTextMargin*1.5)):999999;if(this.isDOE&&this.legend.variable.width>H){this.legend.variable.width=H}I+=z+this.legendTextMargin;c+=s;for(var E=0;E<this.varPie.ids.length;E++){var f=false;var r=this.varPie.ids[E];var e=this.varPie.cols[E];var w=r>-1?this.Cv(this.data.y.vars[r],this.maxVarStringLen):"Other";if(H>0){while((this.uo(w,this.legendTextFont)+s+(this.legendTextMargin*3))>H&&w.length>1){w=w.substring(0,w.length-1);f=true}if(f){w=w+"..."}}this.P5(I,c,"circle",s,this.Fg(e),this.fE(e),"closed","solid",this.background,w,["PieVar-"+r],null,this.Cs(false,false,"Var-"+r));c+=s+this.legendTextMargin;if(this.layoutComb){if((c-this.offsetY)>this.layoutHeight){this.YN({p:["drawText","...",I+s,c,this.legendTextFont,this.legendTextColor,"left","bottom"],t:"Legends"});break}}else{if(c>this.height){this.YN({p:["drawText","...",I+s,c,this.legendTextFont,this.legendTextColor,"left","bottom"],t:"Legends"});break}}}}else{if((this.colorBy&&this.colorBy=="variable")||(this.shapeBy&&this.shapeBy=="variable")||(this.sizeBy&&this.sizeBy=="variable")||(this.patternBy&&this.patternBy=="variable")){var D=this.sizeBy&&this.sizeBy=="variable"?Math.max(this.sizes[this.varIndices.length-1],s):s;var J=D/2;var m=this.legend.variable.columns||(this.legendColumns>this.varIndices.length?this.varIndices.length:this.legendColumns);var G=this.legend.variable.width/m;var a=Math.ceil(this.varIndices.length/m);c+=(this.legendTextMargin*3);for(var E=0;E<a;E++){for(var y=0;y<m;y++){I=t+(this.legendTextMargin+(G*y));if(A<this.varIndices.length){var r=this.varIndices[A];var e=k=="Circular"||(this.colorBy&&this.colorBy=="variable")?A%this.colors.length:0;var u=this.shapeBy&&this.shapeBy=="variable"?A%this.shapes.length:0;var C=this.sizeBy&&this.sizeBy=="variable"?this.sizes[A%this.sizes.length]:D;var q=this.patternBy&&this.patternBy=="variable"?this.patterns[A%this.patterns.length]:this.mU(r,false,"patternBy");var p=I+J;var w=this.Cv(this.data.y.vars[r],this.maxVarStringLen);var b=this.Cs(false,false,"Var-"+r);this.P5(p,c,this.shapes[u],C,this.Fg(this.colors[e]),this.fE(this.colors[e]),q,"solid",this.background,w,["Var-"+r],null,b)}else{break}A++}c+=D+this.legendTextMargin}}else{if(k=="BarLine"||k=="DotLine"||k=="AreaLine"||k=="StackedLine"||k=="StackedPercentLine"){var g=this.xAxisVarIndices.concat(this.xAxis2VarIndices);var m=this.legend.variable.columns||(this.legendColumns>g.length?g.length:this.legendColumns);var G=this.legend.variable.width/m;var a=Math.ceil(g.length/m);c+=this.legendTextMargin+(s/2);for(var E=0;E<a;E++){for(var y=0;y<m;y++){I=t+(s/2)+this.legendTextMargin+(G*y);if(A<g.length){var r=A<this.xAxisVarIndices.length?this.xAxisVarIndices[A]:this.xAxis2VarIndices[A-this.xAxisVarIndices.length];var e=this.theme=="blackAndWhite"?"rgb(0,0,0)":this.coordinateLineColor?n(A):this.BY(this.data.y.vars[r]);var q=this.mU(r,false,"patternBy");var w=this.Cv(this.data.y.vars[r],this.maxVarStringLen);var b=this.Cs(false,false,"Var-"+r);if(A<this.xAxisVarIndices.length){var u=k=="DotLine"?"circle":this.useRoundRectangles?"roundrect":"rectangle";this.P5(I,c,u,s,this.Fg(e),this.fE(e),q,"solid",this.background,w,["Var-"+r],null,b)}else{var v=this.lineDecoration=="pattern"?this.linePatterns[A%this.linePatterns.length]:"line";var u=this.lineDecoration=="symbol"?this.shapes[(A-this.xAxisVarIndices.length)%this.shapes.length]:"circle";var e=this.Fg(e);if(this.lineDecoration&&this.lineDecoration!="pattern"&&!this.segregateVariablesBy.length&&k!="DotLine"&&k!="AreaLine"){this.WO(I,c,u,s,e,e,"closed","solid",e,w,["Var-"+r],null,b)}else{this.a3(I,c,u,s,e,e,q,v,e,w,["Var-"+r],null,b)}}}else{break}A++}c+=s+this.legendTextMargin}}else{if(k=="Bar"||k=="Line"||k=="ParallelCoordinates"||k=="Area"||k=="Dotplot"||k=="Stacked"||k=="StackedPercent"||k=="Boxplot"||k=="Fish"){var m=this.legend.variable.columns||(this.legendColumns>this.varIndices.length?this.varIndices.length:this.legendColumns);var G=this.legend.variable.width/Math.min(this.varIndices.length,m);var a=Math.ceil(this.varIndices.length/Math.min(this.varIndices.length,m));c+=this.legendTextMargin+(s/2);for(var E=0;E<a;E++){for(var y=0;y<Math.min(this.varIndices.length,m);y++){I=t+(s/2)+this.legendTextMargin+(G*y);if(A<this.varIndices.length){var r=this.varIndices[A];var e=this.theme=="blackAndWhite"&&k=="Line"?"rgb(0,0,0)":this.Fg(this.BY(this.data.y.vars[r]));var B=this.fE(e);var q=this.mU(r,false,"patternBy");var w=this.Cv(this.data.y.vars[r],this.maxVarStringLen);var b=this.Cs(false,false,"Var-"+r);if(k=="Boxplot"){e=this.boxplotColor?this.boxplotColor:e;B=this.boxplotBorderColor?this.boxplotBorderColor:B}if(k=="Line"||k=="ParallelCoordinates"){var u=this.lineDecoration=="symbol"?this.shapes[A%this.shapes.length]:"circle";var v=this.lineDecoration=="pattern"?this.linePatterns[A%this.linePatterns.length]:"line";if(this.lineDecoration&&(this.lineDecoration=="symbol"||this.lineDecoration=="dot")){this.WO(I,c,u,s,e,e,q,"solid",e,w,["Var-"+r],null,b)}else{this.a3(I,c,u,s,e,e,q,v,e,w,["Var-"+r],null,b)}}else{if(k=="Dotplot"||(k=="Boxplot"&&this.showBoxplotOriginalData)){var u="circle";this.P5(I,c,u,s,e,B,q,"solid",this.background,w,["Var-"+r],null,b)}else{if(k=="Bar"&&this.barType=="lollipop"){this.PT(I,c,u,s,e,B,q,"solid",this.background,w,["Var-"+r],null,b)}else{var u=this.useRoundRectangles?"roundrect":"rectangle";if(k=="Boxplot"&&(!this.showBoxplotOriginalData||this.boxplotColor)){if(this.plotStyle=="ggplotSwitched"){B=this.boxplotColor}this.ty(I,c,u,s,e,B,q,"solid",this.background,w,["Var-"+r],null,b)}else{this.P5(I,c,u,s,e,B,q,"solid",this.background,w,["Var-"+r],null,b)}}}}}else{break}A++}c+=s+this.legendTextMargin}}else{if(k=="Circular"&&!this.showIdeogram&&o()){var d=[];if(this.rAxisIndex>=0){for(var E=0;E<this.varIndices.length;E++){if(E==this.rAxisIndex){continue}d.push(this.varIndices[E])}}else{d=this.varIndices}var m=this.legend.variable.columns||(this.legendColumns>d.length?d.length:this.legendColumns);var G=this.legend.variable.width/m;var a=Math.ceil(d.length/m);c+=this.legendTextMargin+(s/2);for(var E=0;E<a;E++){for(var y=0;y<m;y++){I=t+(s/2)+this.legendTextMargin+(G*y);if(A<d.length){var r=d[A];if(this.data.y.vars[r]){var e=this.colors[A%this.colors.length];var q=this.mU(r,false,"patternBy");var w=this.Cv(this.data.y.vars[r],this.maxVarStringLen);this.P5(I,c,this.useRoundRectangles?"roundrect":"rectangle",s,this.Fg(e),this.fE(e),q,"solid",this.background,w,["Var-"+r],null,b)}}else{break}A++}c+=s+this.legendTextMargin}}}}}}}};this.th=function(){if(this.showLegend){var j=this.E1(this.legendTextFont);var d=this.vennMarginLeft+this.marginLeft+this.left;var c=d+(j*2);var g=this.vennMarginTop+this.marginTop+this.top+this.y+this.margin+(j/2);var h=[];var a=[];for(var f in this.data.venn.legend){a.push(f)}a=a.sort();if(this.vennGroups==4){h.push(this.vennColors.length>0&&this.DF(this.vennColors[0])?this.DF(this.vennColors[0]):"rgb(255,0,0)");h.push(this.vennColors.length>1&&this.DF(this.vennColors[1])?this.DF(this.vennColors[1]):"rgb(0,153,51)");h.push(this.vennColors.length>2&&this.DF(this.vennColors[2])?this.DF(this.vennColors[3]):"rgb(153,204,0)");h.push(this.vennColors.length>3&&this.DF(this.vennColors[3])?this.DF(this.vennColors[2]):"rgb(0,0,255)")}else{if(this.vennGroups==3){h.push(this.vennColors.length>0&&this.DF(this.vennColors[0])?this.DF(this.vennColors[0]):"rgb(255,0,0)");h.push(this.vennColors.length>1&&this.DF(this.vennColors[1])?this.DF(this.vennColors[1]):"rgb(0,255,0)");h.push(this.vennColors.length>2&&this.DF(this.vennColors[2])?this.DF(this.vennColors[2]):"rgb(0,0,255)")}else{if(this.vennGroups==2){h.push(this.vennColors.length>0&&this.DF(this.vennColors[0])?this.DF(this.vennColors[0]):"rgb(0,0,255)");h.push(this.vennColors.length>1&&this.DF(this.vennColors[1])?this.DF(this.vennColors[1]):"rgb(255,0,0)")}else{h.push(this.vennColors.length>0&&this.DF(this.vennColors[0])?this.DF(this.vennColors[0]):"rgb(255,0,0)")}}}for(var f=0;f<this.vennGroups;f++){if(!this.vennLegendColors){this.YN({p:["drawText",a[f]+": ",d,g,this.legendTextFont,this.legendTextColor,"left","middle"],t:"Legends"})}var b=this.data.venn.legend&&this.data.venn.legend[a[f]]?this.data.venn.legend[a[f]]:"N/A";var e=(this.uo(b,this.legendTextFont)>this.x)?this.yY(b,j,this.x-this.margin):this.legendTextFont;if(!this.vennLegendColors){this.YN({p:["drawText",b,c,g,e,this.legendTextColor,"left","middle"],t:"Legends"})}else{this.YN({p:["drawText",b,d,g,e,h[f],"left","middle"],t:"Legends"})}g+=this.margin+j}}};this.eH=function(p,a,k,z,h,u){if(u||h||this.colorBy||this.outlineBy||this.colorLabelBy||this.colorNodeBy||this.colorEdgeBy||this.colorNodeBy||this.colorEdgeBy||this.graphType=="Genome"||this.scatterType=="bin2d"||(this.isContour&&this.contourFilled)||(this.graphType=="Network"&&this.decorations.length&&this.decorationsType=="heatmap"&&this.showDecorations&&!this.colorNodeBy&&!this.colorEdgeBy)){var B=this;var K=function(c){var i=c?B.uo(c,B.legendTextFont):0;if(B.heatmapIndicatorPosition=="right"){return Math.max(i,B.heatmapIndicatorHeight+(B.legendTextMargin*2)+k.maxLevLen)}else{return Math.max(i,B.heatmapIndicatorWidth+(k.maxLevLen/2))}};var w=function(R,j){if(j==undefined){if(!k.decs||k.decs>3){k.decs=B.ab(R[1]-R[0])}j=k.decs}var Q=[];for(var c=0;c<R.length;c++){Q[c]=typeof R[c]=="string"?R[c]:R[c].toFixed(j)}return Q};var b=function(c){if(B.heatmapIndicatorWidth<250){if(c.length==9){c=[c[0],c[4],c[8]]}else{if(c.length==8||c.length==7){c=[c[0],c[2],c[4],c[6]]}else{if(c.length==6||c.length==5){c=[c[0],c[2],c[4]]}}}}return c};var v=function(R,S,j,c,Q){var T=K(c);var i=B.legendTitleAlign=="center"?0:B.legendTitleAlign=="left"?-(T/2):(T/2);S+=B.legendTitleMargin+(j/2)-(Q?0:(B.legendTitleMargin/2));B.YN({p:["drawText",c,R+(T/2)+i,S,B.legendTitleFont,B.legendTitleColor,B.legendTitleAlign,"middle"],t:"Legends"})};var N=function(U){var Q=C;var S=(!U||B.graphType=="Map")&&l&&B.showLegendTitle?r+B.legendTitleFontSize+(B.legendTitleMargin*2):l&&B.showLegendTitle?r+B.legendTitleFontSize+(B.legendTitleMargin*2):r;var j=U?B.heatmapIndicatorWidth:B.heatmapIndicatorHeight;var T=U?B.heatmapIndicatorHeight:B.heatmapIndicatorWidth;var V=B.theme=="GGPlot"?"rgb(255,255,255)":"rgb(0,0,0)";B.YN({p:["drawShape","rectangle",Q+(j/2),S+(T/2),j,T,false,V,"open"],t:"Legends"});if(U){for(var R=0;R<g.length;R++){if(g[R]>Q&&g[R]<(Q+j)){B.YN({p:["drawLine","line",g[R],S,g[R],S+B.margin,V,1],t:"Legends"});B.YN({p:["drawLine","line",g[R],S+T,g[R],S+T-B.margin,V,1],t:"Legends"})}}}else{for(var R=0;R<g.length;R++){if(g[R]>S&&g[R]<(S+T)){B.YN({p:["drawLine","line",Q,g[R],Q+B.margin,g[R],V,1],t:"Legends"});B.YN({p:["drawLine","line",Q+j,g[R],Q+j-B.margin,g[R],V,1],t:"Legends"})}}}};var l=this.scatterType=="bin2d"?"n":(z||k.title);var y=u?"overlaysLegendPosition":h?"heatmapIndicatorPosition":"legendPosition";var C=p;var r=a;var n=this.E1(this.legendTitleFont);var o=this.heatmapIndicatorHeight;var P=this.heatmapIndicatorHeight;var M=this.graphType=="Genome"?k.brew.min:k.min;var t=this.graphType=="Genome"?k.brew.max:k.max;var D=this.graphType=="Genome"?k.brew.vals:k.colorBrew&&k.colorBrew.valStr?k.colorBrew.vals:k.vals;var d=k.valStr?k.valStr:k.colorBrew&&k.colorBrew.valStr?k.colorBrew.valStr:w(D);var F=this.heatmapIndicatorWidth/(t-M);var J=10;var G=this.graphType=="Circular"||(this.isContour&&!k.colorBrew)||this.scatterType=="bin2d"?k:k.colorBrew?k.colorBrew:this.meta.def.colorBrew;var f=this.heatmapIndicatorWidth/this.colorSpectrumNumber;var x=y=="overlaysLegendPosition"&&this[y]=="topRight"?true:false;var e=this.legendTitleFont;var O=this.graphType=="Heatmap"&&this.heatmapIndicatorHistogram?this.GP():false;var g=[];var A=[];var E=this[y]&&this[y].toString().match(/top|bottom/)&&!x&&(this.graphType=="Heatmap"||this.graphType=="Map"||this.graphType=="Network");if(O&&this.heatmapIndicatorOverlap){p+=this.uo(O.maxStr,this.legendTextFont);C=p}if(this[y]&&!this[y].toString().match(/top|bottom/)&&!x&&(this.graphType=="Heatmap"||this.graphType=="Map"||this.graphType=="Network")){if(l&&this.showLegendTitle){C=p}}if(E){if(l&&this.showLegendTitle){v(p,a,n,l,true);a+=(this.legendTitleMargin*2)+n}A=[p-this.legendTextFontSize,p+this.heatmapIndicatorWidth+this.legendTextFontSize];this.YN({p:["setClipArea",[p,a,this.heatmapIndicatorWidth,this.heatmapIndicatorHeight]],t:"Legends"});for(var I=0;I<this.colorSpectrumNumber;I++){var L=this.transparency!=null?this.a0(G.colors[I],this.transparency,true):G.colors[I];this.YN({p:["drawLine","line",p,a,p,a+P,L,J],t:"Legends"});p+=f}this.YN({p:["resetClipArea"],t:"Legends"});p=C;a+=P+this.legendTextMargin;if(G&&G.stops&&G.stops.length){var q=0;for(var I=0;I<G.stops.length;I++){for(var H=0;H<this.colorSpectrumNumber;H++){if(G.breaks[H]>=G.stops[I]){p=C+(H*f);g.push(p);var m=(this.uo(this.qY(G.stops[I].toString()),this.legendTextFont)/2);if(p-m>q||I==0||I==G.stops.length-1){this.YN({p:["drawText",this.qY(G.stops[I]),p,a,e,this.legendTextColor,"center","top"],t:"Legends"});q=p+m}break}}}}else{if(O){D=b(D);d=w(D,0);this.sZ(O,C,r-0.5)}else{if(this.graphType=="Map"){D=b(D);d=w(D,0)}else{if(this.graphType=="Network"){d=D}}}for(var I=0;I<D.length;I++){p=C+((D[I]-M)*F);g.push(p);if(p>=A[0]&&p<=A[1]){this.YN({p:["drawText",d[I],p,a,this.legendTextFont,this.legendTextColor,"center","top"],t:"Legends"})}}}}else{if(l&&this.showLegendTitle){v(p,a,n,l);a+=(this.legendTitleMargin*2)+n}var s=a;A=[a+this.heatmapIndicatorWidth+this.legendTextFontSize,a-this.legendTextFontSize];this.YN({p:["setClipArea",[p,a,this.heatmapIndicatorHeight,this.heatmapIndicatorWidth]],t:"Legends"});a+=(this.colorSpectrumNumber*f);for(var I=0;I<this.colorSpectrumNumber;I++){var L=this.transparency!=null?this.a0(G.colors[I],this.transparency,true):G.colors[I];this.YN({p:["drawLine","line",p,a,p+o,a,L,J],t:"Legends"});a-=f}this.YN({p:["resetClipArea"],t:"Legends"});p+=o+this.legendTextMargin;a=s;if(G&&G.stops&&G.stops.length){a+=this.colorSpectrumNumber*f;var q=a;for(var I=0;I<G.stops.length;I++){for(var H=0;H<this.colorSpectrumNumber;H++){if(G.breaks[H]>=G.stops[I]){P=a-(H*f);g.push(P);if(P+this.legendTextFontSize<q||I==0||I==G.stops.length-1){this.YN({p:["drawText",this.qY(G.stops[I]),p,P,this.legendTextFont,this.legendTextColor,"left","middle"],t:"Legends"});q=P}break}}}}else{a+=this.colorSpectrumNumber*f;var s=-((this.legendTitleMargin*2)+n);for(var I=0;I<D.length;I++){var P=a-((D[I]-M)*F);if(P>(r+s)){g.push(P);if(P<=A[0]&&P>=A[1]){if(this.graphType=="Network"){this.YN({p:["drawText",D[I],p,P,this.legendTextFont,this.legendTextColor,"left","middle"],t:"Legends"})}else{this.YN({p:["drawText",d[I],p,P,this.legendTextFont,this.legendTextColor,"left","middle"],t:"Legends"})}}}}}}if(!this.colorSpectrumBinned){N(E)}}};this.GP=function(){var k=[];for(var f=0;f<this.data.y.vars.length;f++){for(var e=0;e<this.data.y.smps.length;e++){var n=this.VY(f,e,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue,this.xAxisFactorValue);if(n!=null&&n!==""&&!isNaN(n)){k.push(n)}}}var g=this.ID(k);var c=g[0];var m=g[1];var r=this[this.histogramSizeEstimator](k);var q=Math.ceil((m-c)/r);if(r>1000){q*=r/1000;r=1000}var h=[];for(var f=0;f<r;f++){h[f]=0}for(var f=0;f<this.data.y.vars.length;f++){for(var e=0;e<this.data.y.smps.length;e++){var n=this.VY(f,e,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue,this.xAxisFactorValue);if(n!=null&&n!==""&&!isNaN(n)){var p=parseInt((n-c)/q);h[p]++}}}c=0;m=0;for(var f=0;f<r;f++){c=Math.min(c,h[f]);m=Math.max(m,h[f])}var l=this[this.axisAlgorithm](c,m,3,this.isGraphTime,this.axisWilkinsonLoose);var o=this.wS(l);var b=(this.heatmapIndicatorWidth-1)/r;