% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_points.R
\name{plot_points}
\alias{plot_points}
\title{Plot phenotypic effect for two markers as points}
\usage{
plot_points(
  phenoV,
  marker1_vals,
  marker2_vals,
  pheno_name,
  marker1_label,
  marker2_label,
  ymin = NULL,
  ymax = NULL
)
}
\arguments{
\item{phenoV}{A vector of trait values}

\item{marker1_vals}{A vector of genotype values 
for marker1}

\item{marker2_vals}{A vector of genotype values
for marker2.}

\item{pheno_name}{A string indicating the name of
the trait being plotted.}

\item{marker1_label}{A string indicating the name
of marker1}

\item{marker2_label}{A string indicating the name
of marker2}

\item{ymin}{A numeric value indicating the minimum 
y value for the plot. If NULL, it will be calculated
based on phenoV and error bars.}

\item{ymax}{A numeric value indicating the maximum
y value for the plot. If NULL, it will be calculated
based on phenoV and error bars.}
}
\value{
None
}
\description{
This internal function is called by 
\code{\link{plot_effects}} to generate a 
plot showing trait the effects of genotype
on phenotype. If marker2_vals is NULL, this
plot shows the main effect of marker1. 
Otherwise it shows effects of the two alleles
together. 
In this plot all individual values are plotted
as points using color to separate the genotype
combinations. The means for each group are indicated
by line segments.
}
\keyword{internal}
