% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capitalR.R
\name{annuity}
\alias{annuity}
\title{Annuity Loan Calculation}
\usage{
annuity(type = c("pv", "fv", "pmt", "nper", "rate"), pv, fv = 0, pmt,
  n, r, end = TRUE)
}
\arguments{
\item{type}{Loan parameter to return. ("pv", "fv", "pmt", "nper", "rate")}

\item{pv}{Present Value}

\item{fv}{Future Value}

\item{pmt}{Periodic Payment}

\item{n}{Number of Periods}

\item{r}{Rate}

\item{end}{Logical, set to TRUE. If FALSE, payments are made at the beginning the period.}
}
\value{
Returns the selected Annuity Loan Parameter
}
\description{
Calculates the payment, present value, future value, rate, or the number of periods
}
\examples{
annuity(type = "pmt", pv = -2000, fv = 0, n  = 4 * 12, r = 0.06/12, end = TRUE)
}
