% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/physical_competence.R
\name{get_plank_score}
\alias{get_plank_score}
\title{Compute a plank score.}
\usage{
get_plank_score(plank_time = NA)
}
\arguments{
\item{plank_time}{A numeric vector representing time (in seconds).}
}
\value{
Returns a numeric vector with values between 0 and 10 (if valid) or NA (if not valid).
}
\description{
This function computes a plank score (\code{plank_score}) based on the duration of time (in seconds) for which a plank is held. This score is used to
compute the physical competence domain score (\code{pc_score}).
}
\details{
Other \code{capl} functions called by this function include: \code{\link[=validate_number]{validate_number()}}.
}
\examples{
get_plank_score(c(120.5, 75.6, 40, 10.99, 90))

# [1] 10  6  3  0  8

}
