% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias_corr.R
\name{bias_corr}
\alias{bias_corr}
\title{Asymptotic bias correction after fitting binary choice models with a
1,2,3-way error component}
\usage{
bias_corr(object = NULL, l = 0L, panel_structure = c("classic", "network"))
}
\arguments{
\item{object}{an object of class \code{"feglm"}.}

\item{l}{unsigned integer indicating a bandwidth for the estimation of
spectral densities proposed by Hahn and Kuersteiner (2011). The default is
zero, which should be used if all regressors are assumed to be strictly
exogenous with respect to the idiosyncratic error term. In the presence of
weakly exogenous regressors, e.g. lagged outcome variables, we suggest to
choose a bandwidth between one and four. Note that the order of factors to
be partialed out is important for bandwidths larger than zero.}

\item{panel_structure}{a string equal to \code{"classic"} or \code{"network"}
which determines the structure of the panel used. \code{"classic"} denotes
panel structures where for example the same cross-sectional units are
observed several times (this includes pseudo panels). \code{"network"}
denotes panel structures where for example bilateral trade flows are
observed for several time periods. Default is \code{"classic"}.}
}
\value{
A named list of classes \code{"bias_corr"} and \code{"feglm"}.
}
\description{
Post-estimation routine to substantially reduce the incidental
parameter bias problem. Applies the analytical bias correction derived by
Fernández-Val and Weidner (2016) and Hinz, Stammann, and Wanner (2020) to
obtain bias-corrected estimates of the structural parameters and is
currently restricted to \code{\link[stats]{binomial}} with 1,2,3-way fixed
effects.
}
\examples{
# subset trade flows to avoid fitting time warnings during check
set.seed(123)
trade_2006 <- trade_panel[trade_panel$year == 2006, ]
trade_2006 <- trade_2006[sample(nrow(trade_2006), 500), ]

trade_2006$trade <- ifelse(trade_2006$trade > 100, 1L, 0L)

# Fit 'feglm()'
mod <- feglm(trade ~ lang | year, trade_2006, family = binomial())

# Apply analytical bias correction
mod_bc <- bias_corr(mod)
summary(mod_bc)

}
\references{
Czarnowske, D. and A. Stammann (2020). "Fixed Effects Binary
Choice Models: Estimation and Inference with Long Panels". ArXiv e-prints.

Fernández-Val, I. and M. Weidner (2016). "Individual and time
effects in nonlinear panel models with large N, T". Journal of Econometrics,
192(1), 291-312.

Fernández-Val, I. and M. Weidner (2018). "Fixed effects
estimation of large-t panel data models". Annual Review of Economics, 10,
109-138.

Hahn, J. and G. Kuersteiner (2011). "Bias reduction for dynamic
nonlinear panel models with fixed effects". Econometric Theory, 27(6),
1152-1191.

Hinz, J., A. Stammann, and J. Wanner (2020). "State Dependence
and Unobserved Heterogeneity in the Extensive Margin of Trade". ArXiv
e-prints.

Neyman, J. and E. L. Scott (1948). "Consistent estimates based on
partially consistent observations". Econometrica, 16(1), 1-32.
}
\seealso{
\code{\link{feglm}}
}
