% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_clusts.R
\name{gen_multicluster}
\alias{gen_multicluster}
\title{Generate Multiple Clusters}
\usage{
gen_multicluster(
  n = c(200, 300, 500),
  p = 4,
  k = 3,
  loc = matrix(c(0, 0, 0, 0, 5, 9, 0, 0, 3, 4, 10, 7), nrow = 3, byrow = TRUE),
  scale = c(3, 1, 2),
  shape = c("gaussian", "bluntedcorn", "unifcube"),
  rotation = NULL,
  is_bkg = FALSE,
  ...
)
}
\arguments{
\item{n}{A numeric vector (default: c(200, 500, 300)) representing the sample sizes.}

\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{k}{A numeric value (default: 3) representing the number of clusters.}

\item{loc}{A numeric matrix (default: matrix(c(0, 0, 0, 0,
5, 9, 0, 0,
3, 4, 10, 7
), nrow = 3, byrow = TRUE)) representing the locations/centroids of clusters.}

\item{scale}{A numeric vector (default: c(3, 1, 2)) representing the scaling factors of clusters.}

\item{shape}{A character vector (default: c("gen_gaussian", "gen_cone", "gen_unifcube")) representing the shapes of clusters.}

\item{rotation}{A numeric list which contains plane and the corresponding angle along that plane for each cluster.}

\item{is_bkg}{A Boolean value (default: FALSE) representing the background noise should exist or not.}

\item{...}{Additional arguments passed to the cluster generator functions.}
}
\value{
A data containing same/different shaped clusters.
}
\description{
This function generates a dataset with multiple clusters.
}
\examples{
set.seed(20240412)
rotations_4d <- list(
cluster1 = list(
  list(plane = c(1, 2), angle = 60), # Rotation in the (1, 2) plane
  list(plane = c(3, 4), angle = 90)  # Rotation in the (3, 4) plane
  ),
cluster2 = list(
  list(plane = c(1, 3), angle = 30) # Rotation in the (1, 3) plane
  ),
cluster3 = list(
  list(plane = c(2, 4), angle = 45) # Rotation in the (2, 4) plane
  )
)
clust_data <- gen_multicluster(n = c(200, 300, 500), p = 4, k = 3,
loc = matrix(c(
  0, 0, 0, 0,
  5, 9, 0, 0,
  3, 4, 10, 7
), nrow = 3, byrow = TRUE),
scale = c(3, 1, 2),
shape = c("gaussian", "cone", "unifcube"),
rotation = rotations_4d,
is_bkg = FALSE)
}
