% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trefoil.R
\name{gen_trefoil3d}
\alias{gen_trefoil3d}
\title{Generate 3-D Trefoil Knot Coordinates (Stereographic Projection)}
\usage{
gen_trefoil3d(n = 500, p = 4, steps = 5, noise_fun = gen_noisedims, ...)
}
\arguments{
\item{n}{A numeric value (default: 500) representing the sample size.}

\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{steps}{A numeric value (default: 5) representing the number of steps for the theta parameter.}

\item{noise_fun}{A function specifying which noise generation function to use for the additional dimensions. Default is \code{gen_noisedims}. Other options include \code{gen_wavydims1}, \code{gen_wavydims2}, and \code{gen_wavydims3}.}

\item{...}{Additional arguments passed to the selected \code{noise_fun} (e.g., \code{m}, \code{s}, \code{theta}, \code{x1_vec}, \code{data}).}
}
\value{
A data containing 3-D trefoil knot.
}
\description{
This function generates coordinates for a 3-D trefoil knot
by applying a stereographic projection from 4-D space.
}
\examples{
set.seed(20240412)
trefoil3d <- gen_trefoil3d(n = 500, p = 4, steps = 5)
}
