% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift_ard_columns.R
\name{rename_ard_columns}
\alias{rename_ard_columns}
\title{Rename ARD Columns}
\usage{
rename_ard_columns(x, columns = c(all_ard_groups(), all_ard_variables()))
}
\arguments{
\item{x}{(\code{data.frame})\cr
a data frame}

\item{columns}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Name of columns to coalesce together and rename.}
}
\value{
data frame
}
\description{
This function combines a pair of \code{group}/\code{group_level} or \code{variable}/\code{variable_level} columns into a
single column. The \code{group_level} or \code{variable_level} column is renamed according to the value of
the \code{group} or \code{variable} column, respectively.
}
\examples{
data <- data.frame(group1 = "A", group1_level = "B", variable = "C", variable_level = "D")

rename_ard_columns(data)
rename_ard_columns(data, columns = c("group1", "group1_level"))
}
