% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowdist.R
\name{flowdist}
\alias{flowdist}
\title{Builds a continuous distance matrices from a spatial features background}
\usage{
flowdist(tab, dist.method, result)
}
\arguments{
\item{tab}{the input flow dataset}

\item{dist.method}{distance calculation algorithm, default is euclidian calculation}

\item{result}{Choose Building a "flowdist" or a simple "dist" matrice. See Details}
}
\value{
(1) A flowdata set with continuous  distances calculations. See dist.method parameter

(2) A flowdata set with movement from euclidian distances calculations
}
\description{
From a layer of areal spatial features, compute and threshold a continuous distance matrix.
The result is either a matrice of distances between ODs, or a flow matrix based on the distance travelled between ODs ; both can be used for filtering flow before flow mapping (\link{flowmap})
}
\details{
-- result = "dist" is the simple resulting distance matrice.\cr
-- result = "flowdist" is the resulting distance matrice with additional calculated parameters.\cr
-- It is also possible to filter flow by a level of distance travelled.
}
\examples{
library(cartograflow)
library(sf)
data(flowdata)
map <- st_read(system.file("shape/MGP_TER.shp", package = "cartograflow"))
tabflow <- flowjointure(
  geom = "area", bkg = map, DF.flow = flows, origin = "i",
  destination = "j", id = "EPT_NUM", x = "X", y = "Y"
)

# Format long with only origin, destination and distance parameters:
tab.distance <- flowdist(tabflow, dist.method = "euclidian", result = "dist")
# Format long with with all parameters: coordinates, distance, mouvement
tab.distance <- flowdist(tabflow, dist.method = "euclidian", result = "flowdist")
}
