% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartogram_cont.R
\name{cartogram_cont}
\alias{cartogram_cont}
\alias{cartogram_cont.SpatialPolygonsDataFrame}
\alias{cartogram_cont.sf}
\title{Calculate Contiguous Cartogram Boundaries}
\usage{
cartogram_cont(
  x,
  weight,
  itermax = 15,
  maxSizeError = 1.0001,
  prepare = "adjust",
  threshold = 0.05
)

\method{cartogram_cont}{SpatialPolygonsDataFrame}(
  x,
  weight,
  itermax = 15,
  maxSizeError = 1.0001,
  prepare = "adjust",
  threshold = 0.05
)

\method{cartogram_cont}{sf}(
  x,
  weight,
  itermax = 15,
  maxSizeError = 1.0001,
  prepare = "adjust",
  threshold = 0.05
)
}
\arguments{
\item{x}{SpatialPolygonDataFrame or an sf object}

\item{weight}{Name of the weighting variable in x}

\item{itermax}{Maximum iterations for the cartogram transformation, if maxSizeError ist not reached}

\item{maxSizeError}{Stop if meanSizeError is smaller than maxSizeError}

\item{prepare}{Weighting values are adjusted to reach convergence much earlier. Possible methods are 
"adjust", adjust values to restrict the mass vector to the quantiles defined by threshold and 1-threshold (default),
"remove", remove features with values lower than quantile at threshold,
"none", don't adjust weighting values}

\item{threshold}{Define threshold for data preparation}
}
\value{
An object of the same class as x
}
\description{
Construct a continuous area cartogram by a rubber sheet distortion algorithm (Dougenik et al. 1985)
}
\examples{

library(maptools)
library(cartogram)
library(rgdal)
data(wrld_simpl)

# Remove uninhabited regions
afr <- spTransform(wrld_simpl[wrld_simpl$REGION==2 & wrld_simpl$POP2005 > 0,], 
                    CRS("+init=epsg:3395"))

# Create cartogram
afr_carto <- cartogram_cont(afr, "POP2005", 3)

# Plot 
par(mfcol=c(1,2))
plot(afr, main="original")
plot(afr_carto, main="distorted (sp)")

# Same with sf objects
library(sf)

afr_sf = st_as_sf(afr)

afr_sf_carto <- cartogram_cont(afr_sf, "POP2005", 3)

# Plot 
par(mfcol=c(1,3))
plot(afr, main="original")
plot(afr_carto, main="distorted (sp)")
plot(st_geometry(afr_sf_carto), main="distorted (sf)")

}
\references{
Dougenik, J. A., Chrisman, N. R., & Niemeyer, D. R. (1985). An Algorithm To Construct Continuous Area Cartograms. In The Professional Geographer, 37(1), 75-81.
}
