% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/legends.R
\name{legendCirclesSymbols}
\alias{legendCirclesSymbols}
\title{Legend for Proportional Circles Maps}
\usage{
legendCirclesSymbols(pos = "topleft", title.txt = "Title of the legend",
  title.cex = 0.8, cex = 1, values.cex = 0.6, var, r, breakval = NULL,
  col = "red", col2 = "blue", frame = FALSE, values.rnd = 0,
  style = "c")
}
\arguments{
\item{pos}{position of the legend, one of "topleft", "top",
"topright", "left", "right", "bottomleft", "bottom", "bottomright".}

\item{title.txt}{title of the legend.}

\item{title.cex}{size of the legend title.}

\item{cex}{size of the legend. 2 means two times bigger.}

\item{values.cex}{size of the values in the legend.}

\item{var}{vector of values.}

\item{r}{a vector giving the radii of the circles.}

\item{breakval}{breaking value (see Details).}

\item{col}{color of symbols.}

\item{col2}{second color of symbols (see Details).}

\item{frame}{whether to add a frame to the legend (TRUE) or
not (FALSE).}

\item{values.rnd}{number of decimal places of the values in
the legend.}

\item{style}{either "c" or "e". The legend has two display
styles, "c" stands for compact and "e" for extended.}
}
\description{
Plot legend for proportional circles maps
}
\details{
The breakval parameter allows to plot symbols of two
colors: the first color (col) for values superior or equal to breakval,
second color (col2) for values inferior to breakval.
}
\examples{
data("nuts2006")
plot(nuts0.spdf)

legendCirclesSymbols(pos = "topleft", title.txt = "Title of\\nthe legend",
                     title.cex = 0.8, values.cex = 0.6,cex = 1.5,
                     var = nuts1.df$pop2008,
                     r = sqrt((abs(nuts1.df$pop2008) * 100000) / pi),
                     col = "pink", frame = TRUE,
                     values.rnd=0, style ="c")
}

