% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choroLayer.R
\name{choroLayer}
\alias{choroLayer}
\title{Choropleth Layer}
\usage{
choroLayer(spdf, df, spdfid = NULL, dfid = NULL, var, breaks = NULL,
  method = "quantile", nclass = NULL, col = NULL, border = "grey20",
  lwd = 1, colNA = "white", legend.pos = "bottomleft",
  legend.title.txt = var, legend.title.cex = 0.8, legend.values.cex = 0.6,
  legend.values.rnd = 0, legend.nodata = "no data", legend.frame = FALSE,
  add = FALSE)
}
\arguments{
\item{spdf}{a SpatialPolygonsDataFrame.}

\item{df}{a data frame that contains the values to plot. If df is missing 
spdf@data is used instead.}

\item{spdfid}{name of the identifier field in spdf, default to the first column 
of the spdf data frame. (optional)}

\item{dfid}{name of the identifier field in df, default to the first column 
of df. (optional)}

\item{var}{name of the numeric field in df to plot.}

\item{breaks}{break values in sorted order to indicate the intervals for assigning the colors. 
Note that if there are nlevel colors (classes) there should be (nlevel+1) break values (see Details).}

\item{method}{a discretization method; one of "sd", "equal", 
"quantile", "fisher-jenks","q6" or "geom"  (see Details).}

\item{nclass}{a targeted number of classes. If null, the number of class is automatically defined (see Details).}

\item{col}{a vector of colors. Note that if breaks is specified there must be one less 
colors specified than the number of break.}

\item{border}{color of the polygons borders.}

\item{lwd}{borders width.}

\item{colNA}{no data color.}

\item{legend.pos}{position of the legend, one of "topleft", "top", 
"topright", "left", "right", "bottomleft", "bottom", "bottomright". If 
legend.pos is "n" then the legend is not plotted.}

\item{legend.title.txt}{title of the legend.}

\item{legend.title.cex}{size of the legend title.}

\item{legend.values.cex}{size of the values in the legend.}

\item{legend.values.rnd}{number of decimal places of the values in 
the legend.}

\item{legend.nodata}{no data label.}

\item{legend.frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{add}{whether to add the layer to an existing plot (TRUE) or 
not (FALSE).}
}
\description{
Plot a chorpoleth layer.
}
\details{
The optimum number of class depends on the number of geographical objects. 
If nclass is not defined, an automatic method inspired by Sturges (1926) 
is used : nclass = 1+3.3*log10(N), where nclass is the number 
of class and N is the variable length.\cr


If breaks is used then nclass and method are not. \cr


"sd", "equal", "quantile" and "fisher-jenks" are \link{classIntervals} methods. 
Jenks and Fisher-Jenks algorithms are based on the same principle and give 
quite similar results but Fisher-Jenks is much faster. \cr
The "q6" method uses the following \link{quantile} probabilities: 0, 0.05, 
0.275, 0.5, 0.725, 0.95, 1.\cr   
The "geom" method is based on a geometric progression along the variable values.
}
\examples{
data("nuts2006")

## Example 1
nuts2.df$unemprate <- nuts2.df$unemp2008/nuts2.df$act2008*100
choroLayer(spdf = nuts2.spdf,
           df = nuts2.df,
           var = "unemprate")

## Example 2
nuts2.df$unemprate <- nuts2.df$unemp2008/nuts2.df$act2008*100
choroLayer(spdf = nuts2.spdf,
           df = nuts2.df,
           var = "unemprate",
           method = "quantile",
           nclass = 8,
           col = carto.pal(pal1 = "turquoise.pal", n1 = 8),
           border = "grey40",
           add = FALSE,
           legend.pos = "topright",
           legend.title.txt = "Unemployement rate\\n(\%)",
           legend.values.rnd = 1)

## Example 3
# Compute the compound annual growth rate
nuts2.df$cagr <- (((nuts2.df$pop2008 / nuts2.df$pop1999)^(1/9)) - 1) * 100
summary(nuts2.df$cagr)
# Plot the compound annual growth rate
cols <- carto.pal(pal1 = "blue.pal", n1 = 2, pal2 = "red.pal", n2 = 4)
choroLayer(spdf = nuts2.spdf,
           df = nuts2.df,
           var = "cagr", breaks = c(-2.43,-1,0,0.5,1,2,3.1),
           col = cols,
           border = "grey40",
           add = FALSE,
           legend.pos = "topright",
           legend.title.txt = "Compound annual\\ngrowth rate",
           legend.values.rnd = 2)
# Layout plot
layoutLayer(title = "Demographic Trends",
            sources = "Eurostat, 2008",
            scale = NULL,
            frame = TRUE,
            col = "black",
            coltitle = "white")
}
\references{
Herbert A. Sturges, «
\emph{The Choice of a Class Interval }», Journal of the American Statistical 
Association, vol. 21, n° 153, mars 1926, p. 65-66.
}
\seealso{
\link{getBreaks}, \link{carto.pal},  \link{legendChoro}, \link{propSymbolsChoroLayer}
}
