% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legends.R
\name{legendBarsSymbols}
\alias{legendBarsSymbols}
\title{Legend for Proportional Bars Maps}
\usage{
legendBarsSymbols(pos = "topleft", title.txt = "Title of the legend",
  title.cex = 0.8, cex = 1, values.cex = 0.6, var, inches, col = "red",
  frame = FALSE, values.rnd = 0, style = "c")
}
\arguments{
\item{pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates in map units (c(x, y)).}

\item{title.txt}{title of the legend.}

\item{title.cex}{size of the legend title.}

\item{cex}{size of the legend. 2 means two times bigger.}

\item{values.cex}{size of the values in the legend.}

\item{var}{vector of values (at least min and max).}

\item{inches}{height of the higher bar.}

\item{col}{color of symbols.}

\item{frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{values.rnd}{number of decimal places of the values in 
the legend.}

\item{style}{either "c" or "e". The legend has two display 
styles, "c" stands for compact and "e" for extended.}
}
\description{
Plot legend for proportional bars maps
}
\examples{
data("nuts2006")
plot(nuts0.spdf)

legendBarsSymbols(pos = "topleft", title.txt = "Title of\\nthe legend",
                     title.cex = 0.8, values.cex = 0.6,cex = 1,
                     var = c(min(nuts0.df$pop2008),max(nuts0.df$pop2008)),
                     inches = 0.5,
                     col = "purple",
                     values.rnd=0, style ="e")
}
