% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propSymbolsTypoLayer.R
\name{propSymbolsTypoLayer}
\alias{propSymbolsTypoLayer}
\title{Proportional Symbols Typo Layer}
\usage{
propSymbolsTypoLayer(x, spdf, df, spdfid = NULL, dfid = NULL, var,
  inches = 0.3, fixmax = NULL, symbols = "circle",
  border = "grey20", lwd = 1, var2, col = NULL, colNA = "white",
  legend.title.cex = 0.8, legend.values.cex = 0.6,
  legend.var.pos = "bottomleft", legend.var.title.txt = var,
  legend.values.rnd = 0, legend.var.style = "c",
  legend.var.frame = FALSE, legend.var2.pos = "topright",
  legend.var2.title.txt = var2, legend.var2.values.order = NULL,
  legend.var2.nodata = "no data", legend.var2.frame = FALSE,
  add = TRUE)
}
\arguments{
\item{x}{an sf object, a simple feature collection. If x is used then spdf, df, spdfid and dfid are not.}

\item{spdf}{SpatialPointsDataFrame or SpatialPolygonsDataFrame; if spdf
is a SpatialPolygonsDataFrame symbols are plotted on centroids.}

\item{df}{a data frame that contains the values to plot. If df is missing 
spdf@data is used instead.}

\item{spdfid}{name of the identifier variable in spdf, default to the first column
of the spdf data frame. (optional)}

\item{dfid}{name of the identifier variable in df, default to the first column
of df. (optional)}

\item{var}{name of the numeric variable used to plot the symbols sizes.}

\item{inches}{size of the biggest symbol (radius for circles, width for
squares, height for bars) in inches.}

\item{fixmax}{value of the biggest symbol. (optional)}

\item{symbols}{type of symbols, one of "circle", "square" or "bar".}

\item{border}{color of symbols borders.}

\item{lwd}{width of symbols borders.}

\item{var2}{name of the factor (or character) variable used to plot the 
symbols colors.}

\item{col}{a vector of colors.}

\item{colNA}{no data color.}

\item{legend.title.cex}{size of the legend title.}

\item{legend.values.cex}{size of the values in the legend.}

\item{legend.var.pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates in map units (c(x, y)).}

\item{legend.var.title.txt}{title of the legend (numeric data).}

\item{legend.values.rnd}{number of decimal places of the values in
the legend.}

\item{legend.var.style}{either "c" or "e". The legend has two display
styles, "c" stands for compact and "e" for extended.}

\item{legend.var.frame}{whether to add a frame to the legend (TRUE) or
not (FALSE).}

\item{legend.var2.pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates in map units (c(x, y)).}

\item{legend.var2.title.txt}{title of the legend (factor data).}

\item{legend.var2.values.order}{values order in the legend, a character vector 
that matches var modalities. Colors will be affected following this order.}

\item{legend.var2.nodata}{text for "no data" values}

\item{legend.var2.frame}{whether to add a frame to the legend (TRUE) or
not (FALSE).}

\item{add}{whether to add the layer to an existing plot (TRUE) or
not (FALSE).}
}
\description{
Plot a proportional symbols layer with colors based on
 qualitative data.
}
\examples{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
# Countries plot
plot(st_geometry(mtq), col = "lightblue4",border = "lightblue3", 
     bg = "lightblue1")
# Population plot on proportional symbols
propSymbolsTypoLayer(x = mtq, var = "POP", var2 = "STATUS",
                     symbols = "circle",
                     col = c("aquamarine4", "yellow3","wheat"),
                     legend.var2.values.order = c("Prefecture",
                                                  "Sub-prefecture",
                                                  "Simple municipality"),
                     legend.var.pos = "right", border = "grey",
                     legend.var.title.txt = "Total\\nPopulation")
layoutLayer(title = "Population Distribution in Martinique, 2015")
}
\seealso{
\link{legendBarsSymbols}, \link{legendTypo},
\link{legendCirclesSymbols}, \link{legendSquaresSymbols},
\link{typoLayer}, \link{propSymbolsLayer}
}
