% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carx_simulate.R
\name{carxSimCenTS}
\alias{carxSimCenTS}
\title{simulate a sample \code{\link{cenTS}} data for \code{carx}}
\usage{
carxSimCenTS(nObs = 200, prmtrAR = c(-0.28, 0.25), prmtrX = c(0.2, 0.4),
  sigma = 0.6, lcl = -1, ucl = 1, x = NULL, seed = NULL,
  value.name = "y", end.date = Sys.Date(), inno.dist = c("normal", "t"),
  t.df = 5)
}
\arguments{
\item{nObs}{number of observations to be simulated.}

\item{prmtrAR}{the AR parameter.}

\item{prmtrX}{the regression parameters for X.}

\item{sigma}{the innovation standard deviation for the AR process.}

\item{lcl}{the lower censoring limit.}

\item{ucl}{the upper censoring limit.}

\item{x}{optional matrix for X. Default = \code{NULL}, in which case X will be simulated from 
the standard normal distribution with dimensions determined by \code{nObs} and \code{prmtrX}.}

\item{seed}{optional to set the seed of random number generator used by \code{R}, default=\code{NULL}.}

\item{value.name}{the name of the response series}

\item{end.date}{the date of the last observation, default = \code{Sys.date()}.}

\item{inno.dist}{innovation distribution, can be "normal" or "t", default="normal". If it is "t", 
its degree of freedom should be supplied in \code{t.df}.}

\item{t.df}{the degree of freedom of the t distribution, used only if \code{inno.dist}="t". Default=5.}
}
\value{
a \code{cenTS} object with regressors.
}
\description{
Use provided parameters and other settings to simulate a series of data as a \code{cenTS} object.
}
\examples{
cts = carxSimCenTS()
}
\seealso{
\code{\link{carxSim}}.
}

