% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CIndex.R
\docType{methods}
\name{setSeasonality<-}
\alias{setSeasonality<-}
\alias{setSeasonality<-,Index,vector-method}
\alias{setSeasonality,ANY-method}
\title{Set seasonality on a monthly basis.}
\usage{
setSeasonality(this, ...) <- value

\S4method{setSeasonality}{Index,vector}(this) <- value
}
\arguments{
\item{this}{Index Object}

\item{...}{Additional function arguments}

\item{value}{Numeric Vector (default:rep(1,12))}
}
\description{
\code{setSeasonality<-} sets monthly multiplier to reflect seasonal impact.
}
\examples{
xindex <- new("Index")
setID(xindex)<-"IDX1"
setTabulate(xindex)<-TRUE
setAnnualizedRate(xindex)<-0.03
setYearlyIndex(xindex)<- c(1,1.05,1.2,0.95,1.3)
set.seed(123)
setSeasonality(xindex)<-rnorm(12,mean=1,sd=0.03)
xindex<-setIndex(xindex)
xindex@monthlyIndex
}
