% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Common.R
\name{dtnbinom}
\alias{dtnbinom}
\alias{ptnbinom}
\alias{qtnbinom}
\alias{rtnbinom}
\title{Density function of Truncated Negative Binomial Distribution}
\usage{
dtnbinom(x, size, prob, min = 0, max = 1e+09)

ptnbinom(q, size, prob, min = 0, max = 1e+09)

qtnbinom(p, size, prob, min = 0, max = 1e+09)

rtnbinom(n, size, prob, min = 0, max = 1e+09)
}
\arguments{
\item{x}{Value of the variable after deductible and limit max(0,min(claim,limit)-deductible)}

\item{size}{Number of successful trials}

\item{prob}{Probability of success in each trial}

\item{min}{Left truncation deductible}

\item{max}{Right truncation limit}

\item{q}{Value of the variable after deductible and limit max(0,min(claim,limit)-deductible)}

\item{p}{Value of the probability}

\item{n}{Number of samples}
}
\description{
Density function of Truncated Negative Binomial Distribution

Cumulative probability function of Truncated Negative Binomial Distribution

Quantile function of Truncated Negative Binomial Distribution max(0,min(claim,limit)-deductible)

Random generation of Truncated Negative Binomial Distribution max(0,min(claim,limit)-deductible)
}
\examples{
dtnbinom(230,100,0.3)
ptnbinom(230,100,0.3)
qtnbinom(0.5,100,0.3)
rtnbinom(500,100,0.3)
}
