% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/plots.R, R/utils.R
\name{plot.popTime}
\alias{plot.popTime}
\alias{plot.popTimeExposure}
\alias{popTime}
\alias{checkArgsTimeEvent}
\title{Population Time Plot}
\usage{
\method{plot}{popTime}(x, ..., xlab = "Follow-up time", ylab = "Population",
  line.width = 1, line.colour = "grey80", point.size = 1,
  point.colour = "red", legend = FALSE, legend.position = c("bottom",
  "top", "left", "right"))

\method{plot}{popTimeExposure}(x, ..., ncol = 1, xlab = "Follow-up time",
  ylab = "Population", line.width = 1, line.colour = "grey80",
  point.size = 1, point.colour = "red", legend = FALSE,
  legend.position = c("bottom", "top", "left", "right"))

popTime(data, time, event, censored.indicator, exposure)

checkArgsTimeEvent(data, time, event)
}
\arguments{
\item{x}{an object of class \code{popTime} or \code{popTimeExposure}.}

\item{...}{Ignored.}

\item{xlab, ylab, line.width, line.colour, point.size, point.colour, legend, legend.position}{See
\code{\link[graphics]{par}}.}

\item{ncol}{Number of columns.}

\item{data}{a \code{data.frame} or \code{data.table} containing the source
dataset.}

\item{time}{a character string giving the name of the time variable. See
Details.}

\item{event}{a character string giving the name of the event variable
contained in \code{data}. See Details. If \code{event} is a numeric
variable, then 0 needs to represent a censored observation, 1 needs to be
the event of interest. Integers 2, 3, ... and so on are treated as
competing events. If event is a \code{factor} or \code{character} and
\code{censored.indicator} is not specified, this function will assume the
reference level is the censored indicator}

\item{censored.indicator}{a character string of length 1 indicating which
value in \code{event} is the censored. This function will use
\code{\link[stats]{relevel}} to set \code{censored.indicator} as the
reference level. This argument is ignored if the \code{event} variable is a
numeric}

\item{exposure}{a character string of length 1 giving the name of the
exposure variable which must be contained in \code{data}. Default is
\code{NULL}. This is used to produced exposure stratified plots. If an
\code{exposure} is specified, \code{popTime} returns an object of class
\code{popTimeExposure}}
}
\value{
The methods for \code{plot} return a population time plot, stratified by exposure status
  in the case of \code{popTimeExposure}.

The methods for \code{plot} return a population time plot, stratified by exposure status
  in the case of \code{popTimeExposure}.

An object of class \code{popTime} (or \code{popTimeExposure} if
  exposure is specified), \code{data.table} and \code{data.frame} in this
  order! The output of this function is to be used with the plot method for
  objects of class \code{popTime} or of class \code{popTimeExposure}, which
  will produce population time plots
}
\description{
\code{plot} method for objects of class \code{popTime} and \code{popTimeExposure}

Create a data frame for population time plots to give a visual representation
of incidence density
}
\details{
It is assumed that \code{data} contains the two columns
  corresponding to the supplied time and event variables. If either the
  \code{time} or \code{event} argument is missing, the function looks for
  columns that contain the words \code{"time"}, \code{"event"}, or
  \code{"status"} in them (case insensitive). The function first looks for
  the time variable, then it looks for the event variable. This order of
  operation is important if for example the time variable is named
  \code{"event time"} and the event variable is named \code{"event
  indicator"}. This function will first (automatically) find the time
  variable and remove this as a possibility from subsequent searches of the
  event variable.
  The following regular expressions are used for the time and event
  variables: \describe{ \item{time}{\code{"[\\s\\W_]+time|^time\\b"}}
  \item{event}{\code{"[\\s\\W_]+event|^event\\b|[\\s\\W_]+status|^status\\b"}}
   }
  This allows for \code{"time"} to be preceded or followed by one or more
  white space characters, one or more non-word characters or one or more
  underscores. For example, the following column names would be recognized by
  the function as the \code{"time"} variable: \code{"time of death",
  "death_time", "Time", "time", "diagnosis_time", "time.diag", "diag__time"}.
  But the following will not be recognized: \code{"diagtime","eventtime",
  "Timediag"}
}
\examples{
\dontrun{
data(bmtccr)
popTimeData <- popTime(data = bmtccr, time = "ftime", exposure = "D")
# p is an object of class gg and ggplot
p <- plot(popTimeData)
# you can further modify the object using all ggplot2 functions
# here we modify the number of y-tick labels
p + scale_y_continuous(breaks = seq(0, max(popTimeData$data$ycoord), 10))
}
}
\seealso{
\code{\link{plot.popTime}}, \code{\link{plot.popTimeExposure}}
}
