% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/association.R
\name{sc_splines}
\alias{sc_splines}
\title{Spline based index.}
\usage{
sc_splines(x, y)
}
\arguments{
\item{x}{numeric vector}

\item{y}{numeric vector}
}
\value{
A "numeric" object that gives the plot's spines score.
}
\description{
(Taken from tourr git repo)
Compares the variance in residuals of a fitted
spline model to the overall variance to find
functional dependence in 2D projections
of the data.
}
\examples{
  require(ggplot2)
  require(tidyr)
  require(dplyr)
  data(anscombe)
  anscombe_tidy <- anscombe \%>\%
  pivot_longer(cols = everything(),
    names_to = c(".value", "set"),
    names_pattern = "(.)(.)")
  ggplot(anscombe_tidy, aes(x=x, y=y)) +
    geom_point() +
    facet_wrap(~set, ncol=2, scales = "free")
  sc_splines(anscombe$x1, anscombe$y1)
  sc_splines(anscombe$x2, anscombe$y2)
  sc_splines(anscombe$x3, anscombe$y3)

}
