% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readQualtrics.R
\name{readQualtrics}
\alias{readQualtrics}
\alias{readQualtrics,character-method}
\title{Clean adaptive inventory responses from Qualtrics}
\usage{
\S4method{readQualtrics}{character}(catObj, responseID)
}
\arguments{
\item{catObj}{Vector containing JSON character representations of the completed Cat objects from Qualtrics survey}

\item{responseID}{Vector containing unique character identifiers for the respondents in the Qualtrics survey}
}
\value{
This function returns a data frame containing cleaned adaptive inventory responses.
}
\description{
This function cleans the adaptive inventory responses stored as embedded data in Qualtrics
}
\details{
This function cleans the adaptive inventory responses contained in the Qualtrics survey
results.  Because different respondents recieve different adaptive inventories, 
their answers to the battery are not stored as usual as separate columns in the Data & Analysis tab 
in the Qualtrics toolbar.  Rather, the respondents' answers to the adaptive battery are saved in 
the catObj embedded data object.  To access the answers, click "Export & Import", and then "Export Data."
In the window that appears, we recommend downloading the data as a .csv file.
Then, feed this function the catObj column and the responseID column.
}
\examples{

data(ex_qualtrics_results) # loads example results
cat_vect <- ex_qualtrics_results$catObj[-c(1,2)] # vector of Cat embedded data objects
ids <- ex_qualtrics_results$ResponseId[-c(1,2)] # vector of respondent identifiers

# clean answer profiles
clean_df <- readQualtrics(catObj = cat_vect, responseID = ids)

# estimate respondents' positions
setEstimation(agree_cat) <- "MAP"
estimateThetas(catObj = agree_cat, responses = clean_df)

}
\seealso{
\code{\link{Cat-class}}, \code{\link{ex_qualtrics_results}}, \code{\link{ex_qualtrics_results_multiple}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery, Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
