% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sv_selftransc_cat}
\alias{sv_selftransc_cat}
\title{Self-Transcendence (Schwartz Values) Cat Object}
\format{
An object of class \code{Cat} of length 1.
}
\source{
See \url{https://dataverse.harvard.edu/dataverse/pdsl} for the raw YouGov and/or Qualtrics data.
}
\usage{
data(sv_selftransc_cat)
}
\description{
Cat object containing item parameters for graded response model fit with responses to the Self-Transcendence (Schwartz Values) inventory
}
\details{
Cat object containing item parameters for graded response model fit with 8,415 response profiles by myPersonalit Project and 718 response profiles
collected by YouGov in June 2018.  The sample from myPersonality Project was a convenience sample, and the
respondents from YouGov were matched to a sampling frame on gender, age, race, and education.

See \code{\link{Cat-class}} for details regarding the Cat object structure.
See \code{\link{grmCat}} for details regarding the graded response model.

A normal prior was chosen with mean from the theta estimates from the YouGov sample (.004) and a standard deviation (1.2)
wide enough to envelope the range of estimated theta values across both samples.

Note that due to how the item parameters were estimated, large, positive values indicate "more" of the latent trait.

Response options for the Schwartz Values survey are:

0 - means the value is not at all important, it is not relevant as a guiding principle for you.
3 - means the value is important.
6 - means the value is very important.

-1 is for rating any values opposed to the principles that guide you.
7 is for rating a value of supreme importance as a guiding principle in your life; ordinarily there are no more than two such values.

However, for computerized adaptive testing methods, the 0-7 response option range as been shifted to a 1-9 range. 

The wording of the question items: 

\describe{
\item{\code{q1}}{   EQUALITY (equal opportunity for all)}
\item{\code{q17}}{   A WORLD AT PEACE (free of war and conflict)}
\item{\code{q24}}{  UNITY WITH NATURE (fitting into nature)}
\item{\code{q26}}{  WISDOM (a mature understanding of life)}
\item{\code{q29}}{    A WORLD OF BEAUTY (beauty of nature and the arts)}
\item{\code{q30}}{   SOCIAL JUSTICE (correcting injustice, care for the weak)}
\item{\code{q35}}{  BROADMINDED (tolerant of different ideas and beliefs)}
\item{\code{q38}}{  PROTECTING THE ENVIRONMENT (preserving nature)}
\item{\code{q33}}{   LOYAL (faithful to my friends, group)}
\item{\code{q45}}{  HONEST (genuine, sincere)}
\item{\code{q49}}{HELPFUL (working for the welfare of others)}
\item{\code{q52}}{ RESPONSIBLE (dependable, reliable)}
\item{\code{q54}}{ FORGIVING (willing to pardon others)}
}
}
\references{
Stillwell, David, and Michal Kosinski. 2007. "myPersonality Project."
\url{https://sites.google.com/michalkosinski.com/mypersonality}

Schwartz, Shalom H. "Universals in the content and structure of values: 
Theoretical advances and empirical tests in 20 countries." 
Advances in experimental social psychology. Vol. 25. Academic Press, 1992. 1-65.
}
\seealso{
\code{\link{Cat-class}}, \code{\link{grmCat}}
}
\keyword{datasets}
