% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocov.R
\encoding{UTF-8}
\name{mad.dist}
\alias{mad.dist}
\title{MAD distances between objects}
\usage{
mad.dist(X)
}
\arguments{
\item{X}{objects-by-terms matrix}
}
\value{
object of class \code{dist} giving inter-object MAD distances
}
\description{
Computes and returns inter-object median of absolute deviations (MADs) based 
differences.
}
\examples{
data(bread)
CATA.freq <- apply(bread$cata, 2:3, sum)
# median-center columns (attributes)
CATA.swept <- sweep(CATA.freq, 2, apply(CATA.freq, 2, median))
# cluster analysis of products using complete linkage
dist.Products <- mad.dist(CATA.swept)
plot(as.dendrogram(hclust(dist.Products, method = "complete")), main = "Product clusters")
# cluster analysis of attributes using complete linkage
dist.Att <- mad.dist(t(CATA.swept))
plot(as.dendrogram(hclust(dist.Att, method = "complete")), main = "Attribute clusters")
}
\references{
Chaya, C., Castura, J.C., & Greenacre, M.J. (2025). One citation, one vote! 
A new approach for analyzing check-all-that-apply (CATA) data in sensometrics, 
using L1 norm methods. \doi{doi:10.48550/arXiv.2502.15945}
}
\author{
J.C. Castura
}
