% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catsim.R
\name{binssim}
\alias{binssim}
\title{Categorical Structural Similarity Index Metric (whole image)}
\usage{
binssim(
  x,
  y,
  alpha = 1,
  beta = 1,
  gamma = 1,
  c1 = 0.01,
  c2 = 0.01,
  method = "Cohen",
  ...
)
}
\arguments{
\item{x, y}{binary or categorical image}

\item{alpha}{normalizing parameter, by default 1}

\item{beta}{normalizing parameter, by default 1}

\item{gamma}{normalizing parameter, by default 1}

\item{c1}{small normalization constant for the \code{c} function,
by default 0.01}

\item{c2}{small normalization constant for the \code{s} function,
by default 0.01}

\item{method}{whether to use Cohen's kappa (\code{Cohen}),
Jaccard Index (\code{Jaccard}), Dice index (\code{Dice}),
accuracy (\code{accuracy}),  Rand index (\code{Rand}),
Adjusted Rand Index (\code{AdjRand} or \code{ARI}), or normalized mutual
information (\code{NMI} or \code{MI}) as the similarity index.
Note Jaccard and Dice should only be used on binary data.}

\item{...}{Constants can be passed to the components of the index.}
}
\value{
Structural similarity index.
}
\description{
This computes the categorical or binary structural similarity index metric
on a whole-image scale. The difference between this and the default 2-D
method is that this considers the whole image at once and one scale rather
than computing the index over a sliding window and downsampling to consider
it at other scales.
}
\examples{
set.seed(20181207)
x <- matrix(sample(1:4, 10000, replace = TRUE), nrow = 100)
y <- x
for (i in 1:100) y[i, i] <- 1
for (i in 1:99) y[i, i + 1] <- 1
binssim(x, y)
}
