% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities.R
\name{ancestral}
\alias{ancestral}
\alias{ancestral.cauphylm}
\alias{ancestral.cauphyfit}
\title{Posterior density of a node}
\usage{
ancestral(x, ...)

\method{ancestral}{cauphylm}(x, node, values, n_values = 100, n_cores = 1, ...)

\method{ancestral}{cauphyfit}(x, node, values, n_values = 100, n_cores = 1, ...)
}
\arguments{
\item{x}{an object of class \code{\link{fitCauchy}} or \code{\link{cauphylm}}.}

\item{...}{other arguments to be passed to the method.}

\item{node}{the vector of nodes for which to compute the posterior density. 
If not specified, the reconstruction is done on all the nodes.}

\item{values}{the vector of values where the density should be computed. 
If not specified, the reconstruction is done for a grid of \code{n_values} values 
between \code{1.5 * min(x$y)} and \code{1.5 * max(x$y)}.}

\item{n_values}{the number of point for the grid of values. 
Default to \code{100}. Ignored if \code{values} is provided.}

\item{n_cores}{number of cores for the parallelization. Default to 1.}
}
\value{
an object of S3 class \code{ancestralCauchy},
 which is a matrix of posterior values, with nodes in rows and values in columns.
}
\description{
Compute the posterior density of a node value under a fitted Cauchy process on a phylogenetic tree.
}
\details{
This function assumes a Cauchy Process on the tree with fitted parameters 
(see \code{\link{fitCauchy}}),
and computes the posterior ancestral density of internal nodes, 
conditionally on the vector of tip values.

It computes the posterior density on all the points in \code{values},
that should be refined enough to get a good idea of the density curve.
}
\section{Methods (by class)}{
\itemize{
\item \code{ancestral(cauphylm)}: \code{\link{cauphylm}} object

\item \code{ancestral(cauphyfit)}: \code{\link{fitCauchy}} object

}}
\examples{
set.seed(1289)
# Simulate tree and data
phy <- ape::rphylo(10, 0.1, 0)
dat <- rTraitCauchy(n = 1, phy = phy, model = "cauchy",
                    parameters = list(root.value = 10, disp = 0.1))
# Fit the data
fit <- fitCauchy(phy, dat, model = "cauchy", method = "reml")
# Reconstruct the ancestral nodes
anc <- ancestral(fit)
plot_asr(fit, anc = anc, offset = 3)
plot(anc, type = "l", node = c(11, 17))
# Refine grid for node 12 and 17
anc2 <- ancestral(fit, node = c(12, 17), n_values = 1000)
plot(anc2, type = "l")
# Find HDI
library(HDInterval)
hdi_anc <- hdi(anc2)
hdi_anc
plot(anc2, interval = hdi_anc, type = "l")

}
\references{
Bastide, P. and Didier, G. 2023. The Cauchy Process on Phylogenies: a Tractable Model for Pulsed Evolution. Systematic Biology. doi:10.1093/sysbio/syad053.
}
\seealso{
\code{\link{fitCauchy}}, \code{\link{cauphylm}},
\code{\link{plot.ancestralCauchy}}, \code{\link{plot_asr}}, \code{\link{increment}},
\code{\link{hdi.ancestralCauchy}}
}
