% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treatment_effect.R
\name{vcov.causalEffect}
\alias{vcov.causalEffect}
\title{Get the variance of a causalEffect}
\usage{
\method{vcov}{causalEffect}(object, ...)
}
\arguments{
\item{object}{An object of class \link[=causalEffect-class]{causalEffect}}

\item{...}{Passed on to the sandwich estimator if there is a model fit that supports one}
}
\value{
The variance of the treatment effect as a matrix
}
\description{
Get the variance of a causalEffect
}
\examples{
# set-up data
set.seed(1234)
data <- Hainmueller$new()
data$gen_data()

# calculate quantities
weight <- calc_weight(data, estimand = "ATT", method = "Logistic")
tx_eff <- estimate_effect(causalWeights = weight)

vcov(tx_eff)
}
