% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process-optimizer.R
\name{opt_effect}
\alias{opt_effect}
\title{Compute a bound on the average causal effect}
\usage{
opt_effect(opt, obj)
}
\arguments{
\item{opt}{A string. Either \code{"min"} or \code{"max"} for a lower or an upper bound, respectively.}

\item{obj}{An object as returned by the function \code{\link{analyze_graph}}. Contains the casual query to be estimated.}
}
\value{
An object of class \code{optbound}; a list with the following named components: 
\itemize{
  \item \code{expr} is the \emph{main} output; an expression of the bound as a print-friendly string,
  \item \code{type} is either \code{"lower"} or \code{"upper"} according to the type of the bound,
  \item \code{dual_vertices} is a numeric matrix whose rows are the vertices of the convex polytope of the dual LP,
  \item \code{dual_vrep} is a V-representation of the dual convex polytope, including some extra data.
}
}
\description{
This helper function does the heavy lifting for \code{\link{optimize_effect_2}}.
For a given casual query, it computes either a lower or an upper bound on the corresponding causal effect.
}
