% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_data_read.R
\name{cc_data_read}
\alias{cc_data_read}
\title{Read CCAFS data}
\usage{
cc_data_read(x, unreadable = "filter")
}
\arguments{
\item{x}{A \code{ccafs_files} object, the output from a call to
\code{\link[=cc_data_fetch]{cc_data_fetch()}}}

\item{unreadable}{(character) what to do when unreadable files are passed in.
default is to filter them out and proceed ("filter") - alternatively,
you can choose "stop", in which case we'll stop with a message.}
}
\value{
\code{RasterLayer} or \code{RasterStack} class object. See their
help files in \code{raster} package documentation.
}
\description{
Read CCAFS data
}
\details{
Look in \code{rappdirs::user_cache_dir("ccafs")} for what files
are cached and to delete any.

\code{\link[=cc_data_fetch]{cc_data_fetch()}} downloads data to your machine, and this
function reads the data into your R session.

For more control over vizualizations of raster data, check out the
\code{rasterVis} package (https://CRAN.R-project.org/package=rasterVis)
}
\examples{
\dontrun{
key <- "ccafs/ccafs-climate/data/ipcc_5ar_ciat_downscaled/rcp2_6/
 2030s/bcc_csm1_1_m/10min/
 bcc_csm1_1_m_rcp2_6_2030s_prec_10min_r1i1p1_no_tile_asc.zip"
res <- cc_data_fetch(key = key)

# a single file
cc_data_read(res[1])

# select individual files
cc_data_read(res[1:2])

# all files
cc_data_read(res)

# character path input
## you can also pass in a path to a file(s)
cc_data_read(unclass(res[1]))

# plot data
library(raster)
plot(cc_data_read(res[1:3]))
}
}
