% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_search.R
\name{cc_search}
\alias{cc_search}
\title{Search CCAFS data}
\usage{
cc_search(
  file_set = NULL,
  scenario = NULL,
  model = NULL,
  extent = NULL,
  format = NULL,
  period = NULL,
  variable = NULL,
  resolution = NULL,
  tile = NULL
)
}
\arguments{
\item{file_set}{(integer) a file set, 2 through 12}

\item{scenario}{(integer) a scenario, 1 through 10}

\item{model}{(integer) a model, 1 through 89}

\item{extent}{(character) an extent, 'global' or 'region'}

\item{format}{(character) a format, 'ascii' or 'esri'}

\item{period}{(integer) a period, 1 through 10}

\item{variable}{(integer) a variable, 1 through 7, or 9999}

\item{resolution}{(integer) a resolutions, 1 through 7}

\item{tile}{(character) a tile defining a spatial area on the globe.
one of A1-6, B1-6, or C1-6. See web interface for where those are located.}
}
\value{
character strings, one or more urls
}
\description{
Search CCAFS data
}
\details{
See \link{ccafs-search} for details on parameters.

note that some URLs will be for Amazon S3 and others will have different
base URLS (e.g., http://gisweb.ciat.cgiar.org)

Output can be passed to \code{\link[=cc_data_fetch]{cc_data_fetch()}}, and subsequently to
\code{\link[=cc_data_read]{cc_data_read()}}
}
\examples{
\dontrun{
(res <- cc_search(file_set = 12, extent = "global", format = "ascii",
  period = 4, variable = 1, resolution = 4))

res <- cc_search(file_set = 7, extent = "region", format = "ascii",
  period = 9, variable = 5, resolution = 6)
cc_data_fetch(res[3])

# Alternatively, you can use the helper list
# where you can reference options by name
# the downside is that this is very verbose
(res <- cc_search(file_set = cc_params$file_set$`Delta method IPCC AR4`,
                  scenario = cc_params$scenario$`SRES B1`,
                  model = cc_params$model$bccr_bcm2_0,
                  extent = cc_params$extent$global,
                  format = cc_params$format$ascii,
                  period = cc_params$period$`2040s`,
                  variable = cc_params$variable$Precipitation,
                  resolution = cc_params$resolution$`5 minutes`))
}
}
