% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cckde.R
\name{cckde}
\alias{cckde}
\alias{dcckde}
\alias{predict.cckde}
\title{Continuous convolution density estimator}
\usage{
cckde(x, bw = NULL, mult = 1, theta = 0, nu = 5, ...)

dcckde(x, object)

\method{predict}{cckde}(object, newdata, ...)
}
\arguments{
\item{x}{a matrix or data frame containing the data (or evaluation points).}

\item{bw}{vector of bandwidth parameter; if \code{NULL}, the bandwidths are
selected automatically by likelihood cross validation.}

\item{mult}{bandwidth multiplier; either a positive number or a vector of
such. Each bandwidth parameter is multiplied with the corresponding
multiplier.}

\item{theta}{scale parameter of the USB distribution (see, \code{\link[=dusb]{dusb()}}).}

\item{nu}{smoothness parameter of the USB distribution (see, \code{\link[=dusb]{dusb()}}).
The estimator uses the Epanechnikov kernel for smoothing and the USB
distribution for continuous convolution (default parameters correspond to
the uniform distribution on \eqn{[-0.5, 0.5]}.}

\item{...}{unused.}

\item{object}{\code{cckde} object.}

\item{newdata}{matrix or data frame containing evaluation points.}
}
\description{
The continuous convolution kernel density estimator is defined as the
classical kernel density estimator based on continuously convoluted data (see
\code{\link[=cont_conv]{cont_conv()}}). \code{\link[=cckde]{cckde()}} fits the estimator (including bandwidth selection),
\code{\link[=dcckde]{dcckde()}} and \code{\link[=predict.cckde]{predict.cckde()}} can be used to evaluate the estimator.
}
\details{
If a variable should be treated as ordered discrete, declare it as
\code{\link[=ordered]{ordered()}}, factors are expanded into discrete dummy codings.
}
\examples{
# dummy data with discrete variables
dat <- data.frame(
    F1 = factor(rbinom(10, 4, 0.1), 0:4),
    Z1 = ordered(rbinom(10, 5, 0.5), 0:5),
    Z2 = ordered(rpois(10, 1), 0:10),
    X1 = rnorm(10),
    X2 = rexp(10)
)

fit <- cckde(dat)  # fit estimator
dcckde(dat, fit)   # evaluate density
predict(fit, dat)  # equivalent

}
\references{
Nagler, T. (2017). \emph{A generic approach to nonparametric function
estimation with mixed data.} \href{https://arxiv.org/pdf/1704.07457.pdf}{arXiv:1704.07457}
}
