% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneralTransform.R
\name{convert_records}
\alias{convert_records}
\title{General transform from arbitrary record shape to arbitrary record shape.}
\usage{
convert_records(table, incoming_shape, outgoing_shape, ...,
  keyColumns = NULL, columnsToCopy_in = NULL, checkNames = TRUE,
  checkKeys = FALSE, strict = FALSE,
  incoming_controlTableKeys = colnames(incoming_shape)[[1]],
  outgoing_controlTableKeys = colnames(outgoing_shape)[[1]],
  tmp_name_source = wrapr::mk_tmp_name_source("crec"),
  temporary = TRUE)
}
\arguments{
\item{table}{data.frame or relop.}

\item{incoming_shape}{data.frame, definition of incoming record shape.}

\item{outgoing_shape}{data.frame, defintion of outgoing record shape.}

\item{...}{force later arguments to bind by name.}

\item{keyColumns}{character vector of column defining incoming row groups}

\item{columnsToCopy_in}{character array of incoming column names to copy.}

\item{checkNames}{logical, if TRUE check names.}

\item{checkKeys}{logical, if TRUE check columnsToCopy form row keys (not a requirement, unless you want to be able to invert the operation).}

\item{strict}{logical, if TRUE check control table name forms.}

\item{incoming_controlTableKeys}{character, which column names of the incoming control table are considered to be keys.}

\item{outgoing_controlTableKeys}{character, which column names of the outgoing control table are considered to be keys.}

\item{tmp_name_source}{a tempNameGenerator from cdata::mk_tmp_name_source()}

\item{temporary}{logical, if TRUE use temporary tables}
}
\value{
processing pipeline or transformed table
}
\description{
General transform from arbitrary record shape to arbitrary record shape.
}
