% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.itembank.R
\name{gen.itembank}
\alias{gen.itembank}
\title{Item bank generation}
\usage{
gen.itembank(
  Q = NULL,
  gen.Q = list(J = NULL, K = NULL, propK.J = NULL, nI = 1, minJ.K = NULL, max.Kcor = 1),
  mean.IQ,
  range.IQ,
  model = "GDINA",
  min.param = 0,
  seed = NULL
)
}
\arguments{
\item{Q}{Numeric matrix of length \emph{J} number of items x \emph{K} number of atributes. Q-matrix}

\item{gen.Q}{A list of arguments to generate a Q-matrix if \code{Q} is not provided. \code{J} = number of items (scalar numeric). \code{K} = number of attributes (scalar numeric). \code{propK.J} = numeric vector summing up to 1 that determines the proportion of 1-attribute, 2-attribute, ..., items. The length of \code{propK.J} determines the maximum number of attributes considered for an item (see \code{Examples} below). \code{nI} = Scalar numeric that sets the minimum number of identity matrices to be included in the Q-matrix. \code{minJ.K} = numeric vector of length \emph{K} that sets the minimum number of items measuring each attribute. \code{max.Kcor} = scalar numeric that sets the maximum positive correlation allowed between two attributes}

\item{mean.IQ}{Item discrimination (mean for the uniform distribution). \emph{mean.IQ} = \emph{P}(\strong{1}) - \emph{P}(\strong{0}) (Sorrel et al., 2017; Najera et al., in press). Must be a scalar numeric between 0 and 1}

\item{range.IQ}{Item discrimination (range for the uniform distribution). Must be a scalar numeric between 0 and 1}

\item{model}{A character vector of length \emph{J} with one model for each item, or a single value to be used for all items. The possible options include \code{"DINA"}, \code{"DINO"}, \code{"ACDM"}, and \code{"GDINA"}. One-attribute items will be coded in the output as \code{"GDINA"}}

\item{min.param}{Scalar numeric. Minimum value for the delta parameter of the principal effects of each attribute. Only usable if \code{model} = \code{"ACDM"} or \code{model} = \code{"GDINA"}}

\item{seed}{Scalar numeric. A scalar to use with \code{set.seed}}
}
\value{
\code{gen.itembank} returns an object of class \code{gen.itembank}.
\describe{
\item{simQ}{Generated Q-matrix (only if \code{gen.Q} arguments have been used)}
\item{simcatprob.parm}{A list of success probabilities for each latent group in each item}
\item{simdelta.parm}{A list of delta parameters for each item}
\item{check}{A list that contains the mean.IQ and range.IQ for the item bank so that users can check whether these values match the expected results}
\item{specifications}{A list that contains all the specifications}
}
}
\description{
This function can be used to generate an item bank.
The user can provide a Q-matrix or create one defining a set of arguments.
Item quality is sampled from a uniform distribution with mean = \emph{mean.IQ} and range = \emph{range.IQ}.
Item parameters are generated so that the monotonicity constraint is satisfied.
}
\examples{
####################################
# Example 1.                       #
# Generate item bank providing a   #
# Q-matrix using the G-DINA model  #
####################################

Q <- sim180GDINA$simQ
bank <- gen.itembank(Q = Q, mean.IQ = .70, range.IQ = .20, model = "GDINA")

####################################
# Example 2.                       #
# Generate item bank providing a   #
# Q-matrix using multiple models   #
####################################

Q <- sim180GDINA$simQ
K <- ncol(Q)
model <- sample(c("DINA", "DINO", "ACDM"), size = nrow(Q), replace = TRUE)
bank <- gen.itembank(Q = Q, mean.IQ = .70, range.IQ = .20, model = model)

####################################
# Example 3.                       #
# Generate item bank without       #
# providing a Q-matrix (using      #
# gen.Q arguments)                 #
####################################

bank <- gen.itembank(gen.Q = list(J = 150, K = 5, propK.J = c(0.4, 0.3, 0.2, 0.1),
                     nI = 3, minJ.K = 30, max.Kcor = 1),
                     mean.IQ = .80, range.IQ = .10, min.param = 0.1)

}
\references{
Najera, P., Sorrel, M. A., de la Torre, J., & Abad, F. J. (in press). Improving robustness in Q-matrix validation using an iterative and dynamic procedure. \emph{Applied Psychological Measurement}.

Sorrel, M. A., Abad, F. J., Olea, J., de la Torre, J., & Barrada, J. R. (2017). Inferential item-fit evaluation in cognitive diagnosis modeling. \emph{Applied Psychological Measurement, 41}, 614-631.
}
