% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmwr-map.r
\name{mmwr_weekday}
\alias{mmwr_weekday}
\title{Convert a Date to an MMWR weekday}
\usage{
mmwr_weekday(x, abbr = FALSE)
}
\arguments{
\item{x}{a vector of \code{Date} objects or a character vector in \code{YYYY-mm-dd} format.}

\item{abbr}{(logical) if \code{TRUE}, return abbreviated weekday names, otherwise full
weekday names (see Note).}
}
\value{
ordered factor
}
\description{
This is a reformat and re-export of a function in the \code{MMWRweek} package.
It provides a snake case version of its counterpart, produces a \code{factor} of
weekday names (Sunday-Saturday).
}
\note{
Weekday names are explicitly mapped to "Sunday-Saturday" or "Sun-Sat" and
do not change with your locale.
}
\examples{
mwday <- mmwr_weekday(Sys.Date())
}
